#ifndef __WEBSERVICES_H__
#define __WEBSERVICES_H__

#if defined (_MSC_VER) && (_MSC_VER >= 1020)
#pragma once
#endif

#include <windows.h>
#include <wtypes.h>
#include <wincrypt.h>
#ifdef __cplusplus
extern "C"
{
#endif

//  HANDLES
typedef struct _WS_XML_READER WS_XML_READER;

typedef struct _WS_XML_WRITER WS_XML_WRITER;

typedef struct _WS_XML_BUFFER WS_XML_BUFFER;

typedef struct _WS_CHANNEL WS_CHANNEL;

typedef struct _WS_OPERATION_CONTEXT WS_OPERATION_CONTEXT;

typedef struct _WS_ERROR WS_ERROR;

typedef struct _WS_HEAP WS_HEAP;

typedef struct _WS_LISTENER WS_LISTENER;

typedef struct _WS_MESSAGE WS_MESSAGE;

typedef struct _WS_SECURITY_TOKEN WS_SECURITY_TOKEN;

typedef struct _WS_SECURITY_CONTEXT WS_SECURITY_CONTEXT;

typedef struct _WS_SERVICE_HOST WS_SERVICE_HOST;

typedef struct _WS_SERVICE_PROXY WS_SERVICE_PROXY;

typedef struct _WS_METADATA WS_METADATA;

typedef struct _WS_POLICY WS_POLICY;

//  STRUCT DECLARATIONS
typedef struct _WS_XML_DICTIONARY WS_XML_DICTIONARY;

typedef struct _WS_XML_STRING WS_XML_STRING;

typedef struct _WS_XML_QNAME WS_XML_QNAME;

typedef struct _WS_XML_NODE_POSITION WS_XML_NODE_POSITION;

typedef struct _WS_XML_READER_PROPERTY WS_XML_READER_PROPERTY;

typedef struct _WS_XML_CANONICALIZATION_INCLUSIVE_PREFIXES WS_XML_CANONICALIZATION_INCLUSIVE_PREFIXES;

typedef struct _WS_XML_CANONICALIZATION_PROPERTY WS_XML_CANONICALIZATION_PROPERTY;

typedef struct _WS_XML_WRITER_PROPERTY WS_XML_WRITER_PROPERTY;

typedef struct _WS_XML_BUFFER_PROPERTY WS_XML_BUFFER_PROPERTY;

typedef struct _WS_XML_TEXT WS_XML_TEXT;

typedef struct _WS_XML_UTF8_TEXT WS_XML_UTF8_TEXT;

typedef struct _WS_XML_UTF16_TEXT WS_XML_UTF16_TEXT;

typedef struct _WS_XML_BASE64_TEXT WS_XML_BASE64_TEXT;

typedef struct _WS_XML_BOOL_TEXT WS_XML_BOOL_TEXT;

typedef struct _WS_XML_INT32_TEXT WS_XML_INT32_TEXT;

typedef struct _WS_XML_INT64_TEXT WS_XML_INT64_TEXT;

typedef struct _WS_XML_UINT64_TEXT WS_XML_UINT64_TEXT;

typedef struct _WS_XML_FLOAT_TEXT WS_XML_FLOAT_TEXT;

typedef struct _WS_XML_DOUBLE_TEXT WS_XML_DOUBLE_TEXT;

typedef struct _WS_XML_DECIMAL_TEXT WS_XML_DECIMAL_TEXT;

typedef struct _WS_XML_GUID_TEXT WS_XML_GUID_TEXT;

typedef struct _WS_XML_UNIQUE_ID_TEXT WS_XML_UNIQUE_ID_TEXT;

typedef struct _WS_DATETIME WS_DATETIME;

typedef struct _WS_XML_DATETIME_TEXT WS_XML_DATETIME_TEXT;

typedef struct _WS_TIMESPAN WS_TIMESPAN;

typedef struct _WS_XML_TIMESPAN_TEXT WS_XML_TIMESPAN_TEXT;

typedef struct _WS_XML_QNAME_TEXT WS_XML_QNAME_TEXT;

typedef struct _WS_XML_LIST_TEXT WS_XML_LIST_TEXT;

typedef struct _WS_XML_NODE WS_XML_NODE;

typedef struct _WS_XML_ATTRIBUTE WS_XML_ATTRIBUTE;

typedef struct _WS_XML_ELEMENT_NODE WS_XML_ELEMENT_NODE;

typedef struct _WS_XML_TEXT_NODE WS_XML_TEXT_NODE;

typedef struct _WS_XML_COMMENT_NODE WS_XML_COMMENT_NODE;

typedef struct _WS_XML_READER_INPUT WS_XML_READER_INPUT;

typedef struct _WS_XML_READER_BUFFER_INPUT WS_XML_READER_BUFFER_INPUT;

typedef struct _WS_XML_READER_STREAM_INPUT WS_XML_READER_STREAM_INPUT;

typedef struct _WS_XML_READER_ENCODING WS_XML_READER_ENCODING;

typedef struct _WS_XML_READER_TEXT_ENCODING WS_XML_READER_TEXT_ENCODING;

typedef struct _WS_XML_READER_BINARY_ENCODING WS_XML_READER_BINARY_ENCODING;

typedef struct _WS_STRING WS_STRING;

typedef struct _WS_XML_READER_MTOM_ENCODING WS_XML_READER_MTOM_ENCODING;

typedef struct _WS_XML_READER_RAW_ENCODING WS_XML_READER_RAW_ENCODING;

typedef struct _WS_XML_WRITER_ENCODING WS_XML_WRITER_ENCODING;

typedef struct _WS_XML_WRITER_TEXT_ENCODING WS_XML_WRITER_TEXT_ENCODING;

typedef struct _WS_XML_WRITER_BINARY_ENCODING WS_XML_WRITER_BINARY_ENCODING;

typedef struct _WS_XML_WRITER_MTOM_ENCODING WS_XML_WRITER_MTOM_ENCODING;

typedef struct _WS_XML_WRITER_RAW_ENCODING WS_XML_WRITER_RAW_ENCODING;

typedef struct _WS_XML_WRITER_OUTPUT WS_XML_WRITER_OUTPUT;

typedef struct _WS_XML_WRITER_BUFFER_OUTPUT WS_XML_WRITER_BUFFER_OUTPUT;

typedef struct _WS_XML_WRITER_STREAM_OUTPUT WS_XML_WRITER_STREAM_OUTPUT;

typedef struct _WS_XML_WRITER_PROPERTIES WS_XML_WRITER_PROPERTIES;

typedef struct _WS_XML_READER_PROPERTIES WS_XML_READER_PROPERTIES;

typedef struct _WS_ASYNC_CONTEXT WS_ASYNC_CONTEXT;

typedef struct _WS_ASYNC_STATE WS_ASYNC_STATE;

typedef struct _WS_ASYNC_OPERATION WS_ASYNC_OPERATION;

typedef struct _WS_CHANNEL_PROPERTY WS_CHANNEL_PROPERTY;

typedef struct _WS_CUSTOM_HTTP_PROXY WS_CUSTOM_HTTP_PROXY;

typedef struct _WS_CHANNEL_PROPERTIES WS_CHANNEL_PROPERTIES;

typedef struct _WS_CUSTOM_CHANNEL_CALLBACKS WS_CUSTOM_CHANNEL_CALLBACKS;

typedef struct _WS_HTTP_HEADER_MAPPING WS_HTTP_HEADER_MAPPING;

typedef struct _WS_HTTP_MESSAGE_MAPPING WS_HTTP_MESSAGE_MAPPING;

typedef struct _WS_ELEMENT_DESCRIPTION WS_ELEMENT_DESCRIPTION;

typedef struct _WS_MESSAGE_DESCRIPTION WS_MESSAGE_DESCRIPTION;

typedef struct _WS_CHANNEL_ENCODER WS_CHANNEL_ENCODER;

typedef struct _WS_CHANNEL_DECODER WS_CHANNEL_DECODER;

typedef struct _WS_HTTP_REDIRECT_CALLBACK_CONTEXT WS_HTTP_REDIRECT_CALLBACK_CONTEXT;

typedef struct _WS_ENDPOINT_IDENTITY WS_ENDPOINT_IDENTITY;

typedef struct _WS_ENDPOINT_ADDRESS WS_ENDPOINT_ADDRESS;

typedef struct _WS_DNS_ENDPOINT_IDENTITY WS_DNS_ENDPOINT_IDENTITY;

typedef struct _WS_UPN_ENDPOINT_IDENTITY WS_UPN_ENDPOINT_IDENTITY;

typedef struct _WS_SPN_ENDPOINT_IDENTITY WS_SPN_ENDPOINT_IDENTITY;

typedef struct _WS_BYTES WS_BYTES;

typedef struct _WS_RSA_ENDPOINT_IDENTITY WS_RSA_ENDPOINT_IDENTITY;

typedef struct _WS_CERT_ENDPOINT_IDENTITY WS_CERT_ENDPOINT_IDENTITY;

typedef struct _WS_UNKNOWN_ENDPOINT_IDENTITY WS_UNKNOWN_ENDPOINT_IDENTITY;

typedef struct _WS_ERROR_PROPERTY WS_ERROR_PROPERTY;

typedef struct _WS_FAULT_REASON WS_FAULT_REASON;

typedef struct _WS_FAULT_CODE WS_FAULT_CODE;

typedef struct _WS_FAULT WS_FAULT;

typedef struct _WS_FAULT_DETAIL_DESCRIPTION WS_FAULT_DETAIL_DESCRIPTION;

typedef struct _WS_HEAP_PROPERTY WS_HEAP_PROPERTY;

typedef struct _WS_HEAP_PROPERTIES WS_HEAP_PROPERTIES;

typedef struct _WS_LISTENER_PROPERTY WS_LISTENER_PROPERTY;

typedef struct _WS_DISALLOWED_USER_AGENT_SUBSTRINGS WS_DISALLOWED_USER_AGENT_SUBSTRINGS;

typedef struct _WS_LISTENER_PROPERTIES WS_LISTENER_PROPERTIES;

typedef struct _WS_HOST_NAMES WS_HOST_NAMES;

typedef struct _WS_CUSTOM_LISTENER_CALLBACKS WS_CUSTOM_LISTENER_CALLBACKS;

typedef struct _WS_MESSAGE_PROPERTY WS_MESSAGE_PROPERTY;

typedef struct _WS_MESSAGE_PROPERTIES WS_MESSAGE_PROPERTIES;

typedef struct _WS_SECURITY_ALGORITHM_PROPERTY WS_SECURITY_ALGORITHM_PROPERTY;

typedef struct _WS_SECURITY_ALGORITHM_SUITE WS_SECURITY_ALGORITHM_SUITE;

typedef struct _WS_SECURITY_PROPERTY WS_SECURITY_PROPERTY;

typedef struct _WS_SECURITY_PROPERTIES WS_SECURITY_PROPERTIES;

typedef struct _WS_SECURITY_BINDING_PROPERTY WS_SECURITY_BINDING_PROPERTY;

typedef struct _WS_SECURITY_BINDING_PROPERTIES WS_SECURITY_BINDING_PROPERTIES;

typedef struct _WS_SERVICE_SECURITY_IDENTITIES WS_SERVICE_SECURITY_IDENTITIES;

typedef struct _WS_CERT_CREDENTIAL WS_CERT_CREDENTIAL;

typedef struct _WS_SUBJECT_NAME_CERT_CREDENTIAL WS_SUBJECT_NAME_CERT_CREDENTIAL;

typedef struct _WS_THUMBPRINT_CERT_CREDENTIAL WS_THUMBPRINT_CERT_CREDENTIAL;

typedef struct _WS_CUSTOM_CERT_CREDENTIAL WS_CUSTOM_CERT_CREDENTIAL;

typedef struct _WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL;

typedef struct _WS_STRING_WINDOWS_INTEGRATED_AUTH_CREDENTIAL WS_STRING_WINDOWS_INTEGRATED_AUTH_CREDENTIAL;

typedef struct _WS_DEFAULT_WINDOWS_INTEGRATED_AUTH_CREDENTIAL WS_DEFAULT_WINDOWS_INTEGRATED_AUTH_CREDENTIAL;

typedef struct _WS_OPAQUE_WINDOWS_INTEGRATED_AUTH_CREDENTIAL WS_OPAQUE_WINDOWS_INTEGRATED_AUTH_CREDENTIAL;

typedef struct _WS_USERNAME_CREDENTIAL WS_USERNAME_CREDENTIAL;

typedef struct _WS_STRING_USERNAME_CREDENTIAL WS_STRING_USERNAME_CREDENTIAL;

typedef struct _WS_SECURITY_KEY_HANDLE WS_SECURITY_KEY_HANDLE;

typedef struct _WS_RAW_SYMMETRIC_SECURITY_KEY_HANDLE WS_RAW_SYMMETRIC_SECURITY_KEY_HANDLE;

typedef struct _WS_NCRYPT_ASYMMETRIC_SECURITY_KEY_HANDLE WS_NCRYPT_ASYMMETRIC_SECURITY_KEY_HANDLE;

typedef struct _WS_CAPI_ASYMMETRIC_SECURITY_KEY_HANDLE WS_CAPI_ASYMMETRIC_SECURITY_KEY_HANDLE;

typedef struct _WS_SECURITY_BINDING WS_SECURITY_BINDING;

typedef struct _WS_SSL_TRANSPORT_SECURITY_BINDING WS_SSL_TRANSPORT_SECURITY_BINDING;

typedef struct _WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING;

typedef struct _WS_HTTP_HEADER_AUTH_SECURITY_BINDING WS_HTTP_HEADER_AUTH_SECURITY_BINDING;

typedef struct _WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING;

typedef struct _WS_USERNAME_MESSAGE_SECURITY_BINDING WS_USERNAME_MESSAGE_SECURITY_BINDING;

typedef struct _WS_SECURITY_DESCRIPTION WS_SECURITY_DESCRIPTION;

typedef struct _WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING;

typedef struct _WS_SECURITY_CONTEXT_PROPERTY WS_SECURITY_CONTEXT_PROPERTY;

typedef struct _WS_XML_SECURITY_TOKEN_PROPERTY WS_XML_SECURITY_TOKEN_PROPERTY;

typedef struct _WS_XML_TOKEN_MESSAGE_SECURITY_BINDING WS_XML_TOKEN_MESSAGE_SECURITY_BINDING;

typedef struct _WS_SAML_AUTHENTICATOR WS_SAML_AUTHENTICATOR;

typedef struct _WS_CERT_SIGNED_SAML_AUTHENTICATOR WS_CERT_SIGNED_SAML_AUTHENTICATOR;

typedef struct _WS_SAML_MESSAGE_SECURITY_BINDING WS_SAML_MESSAGE_SECURITY_BINDING;

typedef struct _WS_REQUEST_SECURITY_TOKEN_PROPERTY WS_REQUEST_SECURITY_TOKEN_PROPERTY;

typedef struct _WS_ANY_ATTRIBUTE WS_ANY_ATTRIBUTE;

typedef struct _WS_ANY_ATTRIBUTES WS_ANY_ATTRIBUTES;

typedef struct _WS_BOOL_DESCRIPTION WS_BOOL_DESCRIPTION;

typedef struct _WS_GUID_DESCRIPTION WS_GUID_DESCRIPTION;

typedef struct _WS_DATETIME_DESCRIPTION WS_DATETIME_DESCRIPTION;

typedef struct _WS_DURATION WS_DURATION;

typedef struct _WS_DURATION_DESCRIPTION WS_DURATION_DESCRIPTION;

typedef struct _WS_TIMESPAN_DESCRIPTION WS_TIMESPAN_DESCRIPTION;

typedef struct _WS_UNIQUE_ID_DESCRIPTION WS_UNIQUE_ID_DESCRIPTION;

typedef struct _WS_STRING_DESCRIPTION WS_STRING_DESCRIPTION;

typedef struct _WS_XML_STRING_DESCRIPTION WS_XML_STRING_DESCRIPTION;

typedef struct _WS_XML_QNAME_DESCRIPTION WS_XML_QNAME_DESCRIPTION;

typedef struct _WS_CHAR_ARRAY_DESCRIPTION WS_CHAR_ARRAY_DESCRIPTION;

typedef struct _WS_BYTE_ARRAY_DESCRIPTION WS_BYTE_ARRAY_DESCRIPTION;

typedef struct _WS_UTF8_ARRAY_DESCRIPTION WS_UTF8_ARRAY_DESCRIPTION;

typedef struct _WS_WSZ_DESCRIPTION WS_WSZ_DESCRIPTION;

typedef struct _WS_INT8_DESCRIPTION WS_INT8_DESCRIPTION;

typedef struct _WS_UINT8_DESCRIPTION WS_UINT8_DESCRIPTION;

typedef struct _WS_INT16_DESCRIPTION WS_INT16_DESCRIPTION;

typedef struct _WS_UINT16_DESCRIPTION WS_UINT16_DESCRIPTION;

typedef struct _WS_INT32_DESCRIPTION WS_INT32_DESCRIPTION;

typedef struct _WS_UINT32_DESCRIPTION WS_UINT32_DESCRIPTION;

typedef struct _WS_INT64_DESCRIPTION WS_INT64_DESCRIPTION;

typedef struct _WS_UINT64_DESCRIPTION WS_UINT64_DESCRIPTION;

typedef struct _WS_FLOAT_DESCRIPTION WS_FLOAT_DESCRIPTION;

typedef struct _WS_DOUBLE_DESCRIPTION WS_DOUBLE_DESCRIPTION;

typedef struct _WS_DECIMAL_DESCRIPTION WS_DECIMAL_DESCRIPTION;

typedef struct _WS_BYTES_DESCRIPTION WS_BYTES_DESCRIPTION;

typedef struct _WS_ENUM_VALUE WS_ENUM_VALUE;

typedef struct _WS_ENUM_DESCRIPTION WS_ENUM_DESCRIPTION;

typedef struct _WS_ITEM_RANGE WS_ITEM_RANGE;

typedef struct _WS_DEFAULT_VALUE WS_DEFAULT_VALUE;

typedef struct _WS_FIELD_DESCRIPTION WS_FIELD_DESCRIPTION;

typedef struct _WS_UNION_FIELD_DESCRIPTION WS_UNION_FIELD_DESCRIPTION;

typedef struct _WS_STRUCT_DESCRIPTION WS_STRUCT_DESCRIPTION;

typedef struct _WS_UNION_DESCRIPTION WS_UNION_DESCRIPTION;

typedef struct _WS_ENDPOINT_ADDRESS_DESCRIPTION WS_ENDPOINT_ADDRESS_DESCRIPTION;

typedef struct _WS_FAULT_DESCRIPTION WS_FAULT_DESCRIPTION;

typedef struct _WS_VOID_DESCRIPTION WS_VOID_DESCRIPTION;

typedef struct _WS_CUSTOM_TYPE_DESCRIPTION WS_CUSTOM_TYPE_DESCRIPTION;

typedef struct _WS_ATTRIBUTE_DESCRIPTION WS_ATTRIBUTE_DESCRIPTION;

typedef struct _WS_PARAMETER_DESCRIPTION WS_PARAMETER_DESCRIPTION;

typedef struct _WS_OPERATION_DESCRIPTION WS_OPERATION_DESCRIPTION;

typedef struct _WS_CONTRACT_DESCRIPTION WS_CONTRACT_DESCRIPTION;

typedef struct _WS_SERVICE_CONTRACT WS_SERVICE_CONTRACT;

typedef struct _WS_SERVICE_PROPERTY WS_SERVICE_PROPERTY;

typedef struct _WS_SERVICE_ENDPOINT_PROPERTY WS_SERVICE_ENDPOINT_PROPERTY;

typedef struct _WS_SERVICE_PROPERTY_ACCEPT_CALLBACK WS_SERVICE_PROPERTY_ACCEPT_CALLBACK;

typedef struct _WS_SERVICE_METADATA_DOCUMENT WS_SERVICE_METADATA_DOCUMENT;

typedef struct _WS_SERVICE_METADATA WS_SERVICE_METADATA;

typedef struct _WS_SERVICE_PROPERTY_CLOSE_CALLBACK WS_SERVICE_PROPERTY_CLOSE_CALLBACK;

typedef struct _WS_SERVICE_ENDPOINT_METADATA WS_SERVICE_ENDPOINT_METADATA;

typedef struct _WS_SERVICE_ENDPOINT WS_SERVICE_ENDPOINT;

typedef struct _WS_PROXY_PROPERTY WS_PROXY_PROPERTY;

typedef struct _WS_PROXY_MESSAGE_CALLBACK_CONTEXT WS_PROXY_MESSAGE_CALLBACK_CONTEXT;

typedef struct _WS_CALL_PROPERTY WS_CALL_PROPERTY;

typedef struct _WS_URL WS_URL;

typedef struct _WS_HTTP_URL WS_HTTP_URL;

typedef struct _WS_HTTPS_URL WS_HTTPS_URL;

typedef struct _WS_NETTCP_URL WS_NETTCP_URL;

typedef struct _WS_SOAPUDP_URL WS_SOAPUDP_URL;

typedef struct _WS_UNIQUE_ID WS_UNIQUE_ID;

typedef struct _WS_BUFFERS WS_BUFFERS;

typedef struct _WS_METADATA_ENDPOINT WS_METADATA_ENDPOINT;

typedef struct _WS_METADATA_ENDPOINTS WS_METADATA_ENDPOINTS;

typedef struct _WS_METADATA_PROPERTY WS_METADATA_PROPERTY;

typedef struct _WS_POLICY_PROPERTY WS_POLICY_PROPERTY;

typedef struct _WS_POLICY_PROPERTIES WS_POLICY_PROPERTIES;

typedef struct _WS_SECURITY_BINDING_PROPERTY_CONSTRAINT WS_SECURITY_BINDING_PROPERTY_CONSTRAINT;

typedef struct _WS_SECURITY_BINDING_CONSTRAINT WS_SECURITY_BINDING_CONSTRAINT;

typedef struct _WS_SSL_TRANSPORT_SECURITY_BINDING_CONSTRAINT WS_SSL_TRANSPORT_SECURITY_BINDING_CONSTRAINT;

typedef struct _WS_USERNAME_MESSAGE_SECURITY_BINDING_CONSTRAINT WS_USERNAME_MESSAGE_SECURITY_BINDING_CONSTRAINT;

typedef struct _WS_HTTP_HEADER_AUTH_SECURITY_BINDING_CONSTRAINT WS_HTTP_HEADER_AUTH_SECURITY_BINDING_CONSTRAINT;

typedef struct _WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING_CONSTRAINT WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING_CONSTRAINT;

typedef struct _WS_CERT_MESSAGE_SECURITY_BINDING_CONSTRAINT WS_CERT_MESSAGE_SECURITY_BINDING_CONSTRAINT;

typedef struct _WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_CONSTRAINT WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_CONSTRAINT;

typedef struct _WS_REQUEST_SECURITY_TOKEN_PROPERTY_CONSTRAINT WS_REQUEST_SECURITY_TOKEN_PROPERTY_CONSTRAINT;

typedef struct _WS_ISSUED_TOKEN_MESSAGE_SECURITY_BINDING_CONSTRAINT WS_ISSUED_TOKEN_MESSAGE_SECURITY_BINDING_CONSTRAINT;

typedef struct _WS_SECURITY_PROPERTY_CONSTRAINT WS_SECURITY_PROPERTY_CONSTRAINT;

typedef struct _WS_SECURITY_CONSTRAINTS WS_SECURITY_CONSTRAINTS;

typedef struct _WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING_CONSTRAINT WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING_CONSTRAINT;

typedef struct _WS_CHANNEL_PROPERTY_CONSTRAINT WS_CHANNEL_PROPERTY_CONSTRAINT;

typedef struct _WS_POLICY_EXTENSION WS_POLICY_EXTENSION;

typedef struct _WS_ENDPOINT_POLICY_EXTENSION WS_ENDPOINT_POLICY_EXTENSION;

typedef struct _WS_POLICY_CONSTRAINTS WS_POLICY_CONSTRAINTS;

typedef struct _WS_HTTP_POLICY_DESCRIPTION WS_HTTP_POLICY_DESCRIPTION;

typedef struct _WS_SSL_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION WS_SSL_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION;

typedef struct _WS_HTTP_SSL_POLICY_DESCRIPTION WS_HTTP_SSL_POLICY_DESCRIPTION;

typedef struct _WS_HTTP_HEADER_AUTH_SECURITY_BINDING_POLICY_DESCRIPTION WS_HTTP_HEADER_AUTH_SECURITY_BINDING_POLICY_DESCRIPTION;

typedef struct _WS_HTTP_HEADER_AUTH_POLICY_DESCRIPTION WS_HTTP_HEADER_AUTH_POLICY_DESCRIPTION;

typedef struct _WS_HTTP_SSL_HEADER_AUTH_POLICY_DESCRIPTION WS_HTTP_SSL_HEADER_AUTH_POLICY_DESCRIPTION;

typedef struct _WS_USERNAME_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION WS_USERNAME_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION;

typedef struct _WS_HTTP_SSL_USERNAME_POLICY_DESCRIPTION WS_HTTP_SSL_USERNAME_POLICY_DESCRIPTION;

typedef struct _WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION;

typedef struct _WS_HTTP_SSL_KERBEROS_APREQ_POLICY_DESCRIPTION WS_HTTP_SSL_KERBEROS_APREQ_POLICY_DESCRIPTION;

typedef struct _WS_TCP_POLICY_DESCRIPTION WS_TCP_POLICY_DESCRIPTION;

typedef struct _WS_SSPI_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION WS_SSPI_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION;

typedef struct _WS_TCP_SSPI_POLICY_DESCRIPTION WS_TCP_SSPI_POLICY_DESCRIPTION;

typedef struct _WS_TCP_SSPI_USERNAME_POLICY_DESCRIPTION WS_TCP_SSPI_USERNAME_POLICY_DESCRIPTION;

typedef struct _WS_TCP_SSPI_KERBEROS_APREQ_POLICY_DESCRIPTION WS_TCP_SSPI_KERBEROS_APREQ_POLICY_DESCRIPTION;

typedef struct _WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION;

typedef struct _WS_SECURITY_CONTEXT_SECURITY_BINDING_POLICY_DESCRIPTION WS_SECURITY_CONTEXT_SECURITY_BINDING_POLICY_DESCRIPTION;

typedef struct _WS_TCP_SSPI_KERBEROS_APREQ_SECURITY_CONTEXT_POLICY_DESCRIPTION WS_TCP_SSPI_KERBEROS_APREQ_SECURITY_CONTEXT_POLICY_DESCRIPTION;

typedef struct _WS_TCP_SSPI_USERNAME_SECURITY_CONTEXT_POLICY_DESCRIPTION WS_TCP_SSPI_USERNAME_SECURITY_CONTEXT_POLICY_DESCRIPTION;

typedef struct _WS_HTTP_SSL_USERNAME_SECURITY_CONTEXT_POLICY_DESCRIPTION WS_HTTP_SSL_USERNAME_SECURITY_CONTEXT_POLICY_DESCRIPTION;

typedef struct _WS_HTTP_SSL_KERBEROS_APREQ_SECURITY_CONTEXT_POLICY_DESCRIPTION WS_HTTP_SSL_KERBEROS_APREQ_SECURITY_CONTEXT_POLICY_DESCRIPTION;

typedef struct _WS_HTTP_BINDING_TEMPLATE WS_HTTP_BINDING_TEMPLATE;

typedef struct _WS_TCP_BINDING_TEMPLATE WS_TCP_BINDING_TEMPLATE;

typedef struct _WS_SSL_TRANSPORT_SECURITY_BINDING_TEMPLATE WS_SSL_TRANSPORT_SECURITY_BINDING_TEMPLATE;

typedef struct _WS_HTTP_SSL_BINDING_TEMPLATE WS_HTTP_SSL_BINDING_TEMPLATE;

typedef struct _WS_HTTP_HEADER_AUTH_SECURITY_BINDING_TEMPLATE WS_HTTP_HEADER_AUTH_SECURITY_BINDING_TEMPLATE;

typedef struct _WS_HTTP_HEADER_AUTH_BINDING_TEMPLATE WS_HTTP_HEADER_AUTH_BINDING_TEMPLATE;

typedef struct _WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING_TEMPLATE WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING_TEMPLATE;

typedef struct _WS_TCP_SSPI_BINDING_TEMPLATE WS_TCP_SSPI_BINDING_TEMPLATE;

typedef struct _WS_HTTP_SSL_HEADER_AUTH_BINDING_TEMPLATE WS_HTTP_SSL_HEADER_AUTH_BINDING_TEMPLATE;

typedef struct _WS_USERNAME_MESSAGE_SECURITY_BINDING_TEMPLATE WS_USERNAME_MESSAGE_SECURITY_BINDING_TEMPLATE;

typedef struct _WS_HTTP_SSL_USERNAME_BINDING_TEMPLATE WS_HTTP_SSL_USERNAME_BINDING_TEMPLATE;

typedef struct _WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_TEMPLATE WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_TEMPLATE;

typedef struct _WS_HTTP_SSL_KERBEROS_APREQ_BINDING_TEMPLATE WS_HTTP_SSL_KERBEROS_APREQ_BINDING_TEMPLATE;

typedef struct _WS_TCP_SSPI_USERNAME_BINDING_TEMPLATE WS_TCP_SSPI_USERNAME_BINDING_TEMPLATE;

typedef struct _WS_TCP_SSPI_KERBEROS_APREQ_BINDING_TEMPLATE WS_TCP_SSPI_KERBEROS_APREQ_BINDING_TEMPLATE;

typedef struct _WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING_TEMPLATE WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING_TEMPLATE;

typedef struct _WS_SECURITY_CONTEXT_SECURITY_BINDING_TEMPLATE WS_SECURITY_CONTEXT_SECURITY_BINDING_TEMPLATE;

typedef struct _WS_HTTP_SSL_USERNAME_SECURITY_CONTEXT_BINDING_TEMPLATE WS_HTTP_SSL_USERNAME_SECURITY_CONTEXT_BINDING_TEMPLATE;

typedef struct _WS_HTTP_SSL_KERBEROS_APREQ_SECURITY_CONTEXT_BINDING_TEMPLATE WS_HTTP_SSL_KERBEROS_APREQ_SECURITY_CONTEXT_BINDING_TEMPLATE;

typedef struct _WS_TCP_SSPI_USERNAME_SECURITY_CONTEXT_BINDING_TEMPLATE WS_TCP_SSPI_USERNAME_SECURITY_CONTEXT_BINDING_TEMPLATE;

typedef struct _WS_TCP_SSPI_KERBEROS_APREQ_SECURITY_CONTEXT_BINDING_TEMPLATE WS_TCP_SSPI_KERBEROS_APREQ_SECURITY_CONTEXT_BINDING_TEMPLATE;

//  ENUM DEFINITIONS

//  XML Reader enum
//  
//   Each xml reader property is identified by an ID and has an associated
//  value.
//  
typedef enum
{
    WS_XML_READER_PROPERTY_MAX_DEPTH                              = 0,
    WS_XML_READER_PROPERTY_ALLOW_FRAGMENT                         = 1,
    WS_XML_READER_PROPERTY_MAX_ATTRIBUTES                         = 2,
    WS_XML_READER_PROPERTY_READ_DECLARATION                       = 3,
    WS_XML_READER_PROPERTY_CHARSET                                = 4,
    WS_XML_READER_PROPERTY_ROW                                    = 5,
    WS_XML_READER_PROPERTY_COLUMN                                 = 6,
    WS_XML_READER_PROPERTY_UTF8_TRIM_SIZE                         = 7,
    WS_XML_READER_PROPERTY_STREAM_BUFFER_SIZE                     = 8,
    WS_XML_READER_PROPERTY_IN_ATTRIBUTE                           = 9,
    WS_XML_READER_PROPERTY_STREAM_MAX_ROOT_MIME_PART_SIZE         = 10,
    WS_XML_READER_PROPERTY_STREAM_MAX_MIME_HEADERS_SIZE           = 11,
    WS_XML_READER_PROPERTY_MAX_MIME_PARTS                         = 12,
    WS_XML_READER_PROPERTY_ALLOW_INVALID_CHARACTER_REFERENCES     = 13,
    WS_XML_READER_PROPERTY_MAX_NAMESPACES                         = 14,
} WS_XML_READER_PROPERTY_ID;



//  XML Canonicalization enum
//  
//   Defines the values for the XML canonicalization algorithms.
//  
typedef enum
{
    WS_EXCLUSIVE_XML_CANONICALIZATION_ALGORITHM                   = 0,
    WS_EXCLUSIVE_WITH_COMMENTS_XML_CANONICALIZATION_ALGORITHM     = 1,
    WS_INCLUSIVE_XML_CANONICALIZATION_ALGORITHM                   = 2,
    WS_INCLUSIVE_WITH_COMMENTS_XML_CANONICALIZATION_ALGORITHM     = 3,
} WS_XML_CANONICALIZATION_ALGORITHM;



//  XML Canonicalization enum
//  
//   Each XML canonicalization property is identified by an ID and has an associated
//  value.
//  
typedef enum
{
    WS_XML_CANONICALIZATION_PROPERTY_ALGORITHM              = 0,
    WS_XML_CANONICALIZATION_PROPERTY_INCLUSIVE_PREFIXES     = 1,
    WS_XML_CANONICALIZATION_PROPERTY_OMITTED_ELEMENT        = 2,
    WS_XML_CANONICALIZATION_PROPERTY_OUTPUT_BUFFER_SIZE     = 3,
} WS_XML_CANONICALIZATION_PROPERTY_ID;



//  XML Writer enum
//  
//   Each xml writer property is identified by an ID and has an associated value.
//  
typedef enum
{
    WS_XML_WRITER_PROPERTY_MAX_DEPTH                              = 0,
    WS_XML_WRITER_PROPERTY_ALLOW_FRAGMENT                         = 1,
    WS_XML_WRITER_PROPERTY_MAX_ATTRIBUTES                         = 2,
    WS_XML_WRITER_PROPERTY_WRITE_DECLARATION                      = 3,
    WS_XML_WRITER_PROPERTY_INDENT                                 = 4,
    WS_XML_WRITER_PROPERTY_BUFFER_TRIM_SIZE                       = 5,
    WS_XML_WRITER_PROPERTY_CHARSET                                = 6,
    WS_XML_WRITER_PROPERTY_BUFFERS                                = 7,
    WS_XML_WRITER_PROPERTY_BUFFER_MAX_SIZE                        = 8,
    WS_XML_WRITER_PROPERTY_BYTES                                  = 9,
    WS_XML_WRITER_PROPERTY_IN_ATTRIBUTE                           = 10,
    WS_XML_WRITER_PROPERTY_MAX_MIME_PARTS_BUFFER_SIZE             = 11,
    WS_XML_WRITER_PROPERTY_INITIAL_BUFFER                         = 12,
    WS_XML_WRITER_PROPERTY_ALLOW_INVALID_CHARACTER_REFERENCES     = 13,
    WS_XML_WRITER_PROPERTY_MAX_NAMESPACES                         = 14,
    WS_XML_WRITER_PROPERTY_BYTES_WRITTEN                          = 15,
    WS_XML_WRITER_PROPERTY_BYTES_TO_CLOSE                         = 16,
    WS_XML_WRITER_PROPERTY_COMPRESS_EMPTY_ELEMENTS                = 17,
} WS_XML_WRITER_PROPERTY_ID;



//  XML Buffer enum
//  
//   Each xml buffer property is identified by an ID and has an associated
//  value.
//  
typedef enum
{
} WS_XML_BUFFER_PROPERTY_ID;



//  XML Node enum
//  
//   Indicates the type of WS_XML_TEXT structure.
//  
typedef enum
{
    WS_XML_TEXT_TYPE_UTF8          = 1,
    WS_XML_TEXT_TYPE_UTF16         = 2,
    WS_XML_TEXT_TYPE_BASE64        = 3,
    WS_XML_TEXT_TYPE_BOOL          = 4,
    WS_XML_TEXT_TYPE_INT32         = 5,
    WS_XML_TEXT_TYPE_INT64         = 6,
    WS_XML_TEXT_TYPE_UINT64        = 7,
    WS_XML_TEXT_TYPE_FLOAT         = 8,
    WS_XML_TEXT_TYPE_DOUBLE        = 9,
    WS_XML_TEXT_TYPE_DECIMAL       = 10,
    WS_XML_TEXT_TYPE_GUID          = 11,
    WS_XML_TEXT_TYPE_UNIQUE_ID     = 12,
    WS_XML_TEXT_TYPE_DATETIME      = 13,
    WS_XML_TEXT_TYPE_TIMESPAN      = 14,
    WS_XML_TEXT_TYPE_QNAME         = 15,
    WS_XML_TEXT_TYPE_LIST          = 16,
} WS_XML_TEXT_TYPE;



//  XML Node enum
//  
//   Indicates the type of WS_XML_NODE structure.
//  
typedef enum
{
    WS_XML_NODE_TYPE_ELEMENT         = 1,
    WS_XML_NODE_TYPE_TEXT            = 2,
    WS_XML_NODE_TYPE_END_ELEMENT     = 3,
    WS_XML_NODE_TYPE_COMMENT         = 4,
    WS_XML_NODE_TYPE_CDATA           = 6,
    WS_XML_NODE_TYPE_END_CDATA       = 7,
    WS_XML_NODE_TYPE_EOF             = 8,
    WS_XML_NODE_TYPE_BOF             = 9,
} WS_XML_NODE_TYPE;



//  XML Buffer enum
//  
//   This enumeration identifies the various ways to move about an xml document.
//  
typedef enum
{
    WS_MOVE_TO_ROOT_ELEMENT         = 0,
    WS_MOVE_TO_NEXT_ELEMENT         = 1,
    WS_MOVE_TO_PREVIOUS_ELEMENT     = 2,
    WS_MOVE_TO_CHILD_ELEMENT        = 3,
    WS_MOVE_TO_END_ELEMENT          = 4,
    WS_MOVE_TO_PARENT_ELEMENT       = 5,
    WS_MOVE_TO_NEXT_NODE            = 6,
    WS_MOVE_TO_PREVIOUS_NODE        = 7,
    WS_MOVE_TO_FIRST_NODE           = 8,
    WS_MOVE_TO_BOF                  = 9,
    WS_MOVE_TO_EOF                  = 10,
    WS_MOVE_TO_CHILD_NODE           = 11,
} WS_MOVE_TO;



//  XML Node enum
//  
//   An enumeration of the different types of fixed-size primitives.
//  
typedef enum
{
    WS_BOOL_VALUE_TYPE         = 0,
    WS_INT8_VALUE_TYPE         = 1,
    WS_INT16_VALUE_TYPE        = 2,
    WS_INT32_VALUE_TYPE        = 3,
    WS_INT64_VALUE_TYPE        = 4,
    WS_UINT8_VALUE_TYPE        = 5,
    WS_UINT16_VALUE_TYPE       = 6,
    WS_UINT32_VALUE_TYPE       = 7,
    WS_UINT64_VALUE_TYPE       = 8,
    WS_FLOAT_VALUE_TYPE        = 9,
    WS_DOUBLE_VALUE_TYPE       = 10,
    WS_DECIMAL_VALUE_TYPE      = 11,
    WS_DATETIME_VALUE_TYPE     = 12,
    WS_TIMESPAN_VALUE_TYPE     = 13,
    WS_GUID_VALUE_TYPE         = 14,
    WS_DURATION_VALUE_TYPE     = 15,
} WS_VALUE_TYPE;



//  XML Reader enum
//  
//   Indicates the type of WS_XML_READER_INPUT structure.
//  
typedef enum
{
    WS_XML_READER_INPUT_TYPE_BUFFER     = 1,
    WS_XML_READER_INPUT_TYPE_STREAM     = 2,
} WS_XML_READER_INPUT_TYPE;



//  XML Reader enum
//  
//   Indicates the type of WS_XML_READER_ENCODING structure.
//  
typedef enum
{
    WS_XML_READER_ENCODING_TYPE_TEXT       = 1,
    WS_XML_READER_ENCODING_TYPE_BINARY     = 2,
    WS_XML_READER_ENCODING_TYPE_MTOM       = 3,
    WS_XML_READER_ENCODING_TYPE_RAW        = 4,
} WS_XML_READER_ENCODING_TYPE;



//  XML Writer enum

typedef enum
{
    WS_CHARSET_AUTO        = 0,
    WS_CHARSET_UTF8        = 1,
    WS_CHARSET_UTF16LE     = 2,
    WS_CHARSET_UTF16BE     = 3,
} WS_CHARSET;



//  XML Writer enum
//  
//   Indicates the type of WS_XML_WRITER_ENCODING structure.
//  
typedef enum
{
    WS_XML_WRITER_ENCODING_TYPE_TEXT       = 1,
    WS_XML_WRITER_ENCODING_TYPE_BINARY     = 2,
    WS_XML_WRITER_ENCODING_TYPE_MTOM       = 3,
    WS_XML_WRITER_ENCODING_TYPE_RAW        = 4,
} WS_XML_WRITER_ENCODING_TYPE;



//  XML Writer enum
//  
//   Indicates the type of WS_XML_WRITER_OUTPUT structure.
//  
typedef enum
{
    WS_XML_WRITER_OUTPUT_TYPE_BUFFER     = 1,
    WS_XML_WRITER_OUTPUT_TYPE_STREAM     = 2,
} WS_XML_WRITER_OUTPUT_TYPE;



//  Async Model enum
//  
//   Used to specify the threading behavior of a callback (for example, a WS_ASYNC_CALLBACK).
//  
typedef enum
{
    WS_SHORT_CALLBACK     = 0,
    WS_LONG_CALLBACK      = 1,
} WS_CALLBACK_MODEL;



//  Channel enum
//  
//   An enumeration of the different encodings (message formats).
typedef enum
{
    WS_ENCODING_XML_BINARY_1             = 0,
    WS_ENCODING_XML_BINARY_SESSION_1     = 1,
    WS_ENCODING_XML_MTOM_UTF8            = 2,
    WS_ENCODING_XML_MTOM_UTF16BE         = 3,
    WS_ENCODING_XML_MTOM_UTF16LE         = 4,
    WS_ENCODING_XML_UTF8                 = 5,
    WS_ENCODING_XML_UTF16BE              = 6,
    WS_ENCODING_XML_UTF16LE              = 7,
    WS_ENCODING_RAW                      = 8,
} WS_ENCODING;



//  Channel enum
//  An enumeration of the different states that a channel can be in.
typedef enum
{
    WS_CHANNEL_STATE_CREATED       = 0,
    WS_CHANNEL_STATE_OPENING       = 1,
    WS_CHANNEL_STATE_ACCEPTING     = 2,
    WS_CHANNEL_STATE_OPEN          = 3,
    WS_CHANNEL_STATE_FAULTED       = 4,
    WS_CHANNEL_STATE_CLOSING       = 5,
    WS_CHANNEL_STATE_CLOSED        = 6,
} WS_CHANNEL_STATE;



//  Channel enum
//  
//   Specifies whether a message is required or not when receiving from a channel.
//  
typedef enum
{
    WS_RECEIVE_REQUIRED_MESSAGE     = 1,
    WS_RECEIVE_OPTIONAL_MESSAGE     = 2,
} WS_RECEIVE_OPTION;



//  Channel enum
//  
//   The channel binding indicates the protocol stack to use for the channel.
//  
typedef enum
{
    WS_HTTP_CHANNEL_BINDING       = 0,
    WS_TCP_CHANNEL_BINDING        = 1,
    WS_UDP_CHANNEL_BINDING        = 2,
    WS_CUSTOM_CHANNEL_BINDING     = 3,
} WS_CHANNEL_BINDING;



//  Channel enum
//  
//   The channel type indicates the basic characteristics of the channel, such as whether it is
//  sessionful, and what directions of communication are supported.
//  
typedef enum
{
    WS_CHANNEL_TYPE_INPUT              = 0x1,
    WS_CHANNEL_TYPE_OUTPUT             = 0x2,
    WS_CHANNEL_TYPE_SESSION            = 0x4,
    WS_CHANNEL_TYPE_INPUT_SESSION      = (WS_CHANNEL_TYPE_INPUT | WS_CHANNEL_TYPE_SESSION),
    WS_CHANNEL_TYPE_OUTPUT_SESSION     = (WS_CHANNEL_TYPE_OUTPUT | WS_CHANNEL_TYPE_SESSION),
    WS_CHANNEL_TYPE_DUPLEX             = (WS_CHANNEL_TYPE_INPUT | WS_CHANNEL_TYPE_OUTPUT),
    WS_CHANNEL_TYPE_DUPLEX_SESSION     = (WS_CHANNEL_TYPE_INPUT | WS_CHANNEL_TYPE_OUTPUT | WS_CHANNEL_TYPE_SESSION),
    WS_CHANNEL_TYPE_REQUEST            = 0x8,
    WS_CHANNEL_TYPE_REPLY              = 0x10,
} WS_CHANNEL_TYPE;



//  Channel enum
//  
//   The transfer mode indicates whether messages that are sent or received are streamed or buffered.
//  
typedef enum
{
    WS_STREAMED_INPUT_TRANSFER_MODE      = 0x1,
    WS_STREAMED_OUTPUT_TRANSFER_MODE     = 0x2,
    WS_BUFFERED_TRANSFER_MODE            = 0x0,
    WS_STREAMED_TRANSFER_MODE            = (WS_STREAMED_INPUT_TRANSFER_MODE | WS_STREAMED_OUTPUT_TRANSFER_MODE),
} WS_TRANSFER_MODE;



//  Channel enum
//  
//   Proxy setting indicates HTTP proxy setting for the channel with binding WS_HTTP_CHANNEL_BINDING.
//  This is specified as part of WS_CHANNEL_PROPERTY_HTTP_PROXY_SETTING_MODE channel property.
//  
typedef enum
{
    WS_HTTP_PROXY_SETTING_MODE_AUTO       = 0x1,
    WS_HTTP_PROXY_SETTING_MODE_NONE       = 0x2,
    WS_HTTP_PROXY_SETTING_MODE_CUSTOM     = 0x3,
} WS_HTTP_PROXY_SETTING_MODE;



//  Channel enum
//  
//   Each channel property is identified by an ID and has an associated
//  value.  If a property is not specified when the channel is created,
//  then its default value is used.
//  
typedef enum
{
    WS_CHANNEL_PROPERTY_MAX_BUFFERED_MESSAGE_SIZE                = 0,
    WS_CHANNEL_PROPERTY_MAX_STREAMED_MESSAGE_SIZE                = 1,
    WS_CHANNEL_PROPERTY_MAX_STREAMED_START_SIZE                  = 2,
    WS_CHANNEL_PROPERTY_MAX_STREAMED_FLUSH_SIZE                  = 3,
    WS_CHANNEL_PROPERTY_ENCODING                                 = 4,
    WS_CHANNEL_PROPERTY_ENVELOPE_VERSION                         = 5,
    WS_CHANNEL_PROPERTY_ADDRESSING_VERSION                       = 6,
    WS_CHANNEL_PROPERTY_MAX_SESSION_DICTIONARY_SIZE              = 7,
    WS_CHANNEL_PROPERTY_STATE                                    = 8,
    WS_CHANNEL_PROPERTY_ASYNC_CALLBACK_MODEL                     = 9,
    WS_CHANNEL_PROPERTY_IP_VERSION                               = 10,
    WS_CHANNEL_PROPERTY_RESOLVE_TIMEOUT                          = 11,
    WS_CHANNEL_PROPERTY_CONNECT_TIMEOUT                          = 12,
    WS_CHANNEL_PROPERTY_SEND_TIMEOUT                             = 13,
    WS_CHANNEL_PROPERTY_RECEIVE_RESPONSE_TIMEOUT                 = 14,
    WS_CHANNEL_PROPERTY_RECEIVE_TIMEOUT                          = 15,
    WS_CHANNEL_PROPERTY_CLOSE_TIMEOUT                            = 16,
    WS_CHANNEL_PROPERTY_ENABLE_TIMEOUTS                          = 17,
    WS_CHANNEL_PROPERTY_TRANSFER_MODE                            = 18,
    WS_CHANNEL_PROPERTY_MULTICAST_INTERFACE                      = 19,
    WS_CHANNEL_PROPERTY_MULTICAST_HOPS                           = 20,
    WS_CHANNEL_PROPERTY_REMOTE_ADDRESS                           = 21,
    WS_CHANNEL_PROPERTY_REMOTE_IP_ADDRESS                        = 22,
    WS_CHANNEL_PROPERTY_HTTP_CONNECTION_ID                       = 23,
    WS_CHANNEL_PROPERTY_CUSTOM_CHANNEL_CALLBACKS                 = 24,
    WS_CHANNEL_PROPERTY_CUSTOM_CHANNEL_PARAMETERS                = 25,
    WS_CHANNEL_PROPERTY_CUSTOM_CHANNEL_INSTANCE                  = 26,
    WS_CHANNEL_PROPERTY_TRANSPORT_URL                            = 27,
    WS_CHANNEL_PROPERTY_NO_DELAY                                 = 28,
    WS_CHANNEL_PROPERTY_SEND_KEEP_ALIVES                         = 29,
    WS_CHANNEL_PROPERTY_KEEP_ALIVE_TIME                          = 30,
    WS_CHANNEL_PROPERTY_KEEP_ALIVE_INTERVAL                      = 31,
    WS_CHANNEL_PROPERTY_MAX_HTTP_SERVER_CONNECTIONS              = 32,
    WS_CHANNEL_PROPERTY_IS_SESSION_SHUT_DOWN                     = 33,
    WS_CHANNEL_PROPERTY_CHANNEL_TYPE                             = 34,
    WS_CHANNEL_PROPERTY_TRIM_BUFFERED_MESSAGE_SIZE               = 35,
    WS_CHANNEL_PROPERTY_ENCODER                                  = 36,
    WS_CHANNEL_PROPERTY_DECODER                                  = 37,
    WS_CHANNEL_PROPERTY_PROTECTION_LEVEL                         = 38,
    WS_CHANNEL_PROPERTY_COOKIE_MODE                              = 39,
    WS_CHANNEL_PROPERTY_HTTP_PROXY_SETTING_MODE                  = 40,
    WS_CHANNEL_PROPERTY_CUSTOM_HTTP_PROXY                        = 41,
    WS_CHANNEL_PROPERTY_HTTP_MESSAGE_MAPPING                     = 42,
    WS_CHANNEL_PROPERTY_ENABLE_HTTP_REDIRECT                     = 43,
    WS_CHANNEL_PROPERTY_HTTP_REDIRECT_CALLBACK_CONTEXT           = 44,
    WS_CHANNEL_PROPERTY_FAULTS_AS_ERRORS                         = 45,
    WS_CHANNEL_PROPERTY_ALLOW_UNSECURED_FAULTS                   = 46,
    WS_CHANNEL_PROPERTY_HTTP_SERVER_SPN                          = 47,
    WS_CHANNEL_PROPERTY_HTTP_PROXY_SPN                           = 48,
    WS_CHANNEL_PROPERTY_MAX_HTTP_REQUEST_HEADERS_BUFFER_SIZE     = 49,
} WS_CHANNEL_PROPERTY_ID;



//  Channel enum
//  
//   A set of flags that control how mapped headers appear in an HTTP request or response.
//  
enum
{
    WS_HTTP_HEADER_MAPPING_COMMA_SEPARATOR         = 0x1,
    WS_HTTP_HEADER_MAPPING_SEMICOLON_SEPARATOR     = 0x2,
    WS_HTTP_HEADER_MAPPING_QUOTED_VALUE            = 0x4,
};



//  Channel enum
//  
//   A set of flags that control how HTTP responses
//  are mapped to the message object.
//  
enum
{
    WS_HTTP_RESPONSE_MAPPING_STATUS_CODE     = 0x1,
    WS_HTTP_RESPONSE_MAPPING_STATUS_TEXT     = 0x2,
};



//  Channel enum
//  
//   A set of flags that control how HTTP requests
//  are mapped to the message object.
//  
enum
{
    WS_HTTP_REQUEST_MAPPING_VERB     = 0x2,
};



//  Channel enum
//  
//   An enumeration used to specify how to handle HTTP cookies.
//  
typedef enum
{
    WS_MANUAL_COOKIE_MODE     = 1,
    WS_AUTO_COOKIE_MODE       = 2,
} WS_COOKIE_MODE;



//  Context enum
//  
//   Each property represents a property available on the Context. Not all properties may be available
//  at a given point on a context. All context properties are available through WsGetOperationContextProperty.
//  
typedef enum
{
    WS_OPERATION_CONTEXT_PROPERTY_CHANNEL                  = 0,
    WS_OPERATION_CONTEXT_PROPERTY_CONTRACT_DESCRIPTION     = 1,
    WS_OPERATION_CONTEXT_PROPERTY_HOST_USER_STATE          = 2,
    WS_OPERATION_CONTEXT_PROPERTY_CHANNEL_USER_STATE       = 3,
    WS_OPERATION_CONTEXT_PROPERTY_INPUT_MESSAGE            = 4,
    WS_OPERATION_CONTEXT_PROPERTY_OUTPUT_MESSAGE           = 5,
    WS_OPERATION_CONTEXT_PROPERTY_HEAP                     = 6,
    WS_OPERATION_CONTEXT_PROPERTY_LISTENER                 = 7,
    WS_OPERATION_CONTEXT_PROPERTY_ENDPOINT_ADDRESS         = 8,
} WS_OPERATION_CONTEXT_PROPERTY_ID;



//  Endpoint Identity enum
//  
//   The type of the endpoint identity, used as a selector for subtypes of
//   WS_ENDPOINT_IDENTITY.
//  
typedef enum
{
    WS_DNS_ENDPOINT_IDENTITY_TYPE         = 1,
    WS_UPN_ENDPOINT_IDENTITY_TYPE         = 2,
    WS_SPN_ENDPOINT_IDENTITY_TYPE         = 3,
    WS_RSA_ENDPOINT_IDENTITY_TYPE         = 4,
    WS_CERT_ENDPOINT_IDENTITY_TYPE        = 5,
    WS_UNKNOWN_ENDPOINT_IDENTITY_TYPE     = 6,
} WS_ENDPOINT_IDENTITY_TYPE;



//  Endpoint Identity enum
//  
//   This identifies a type of extension within the extensions field of the
//   WS_ENDPOINT_ADDRESS.
//  
typedef enum
{
    WS_ENDPOINT_ADDRESS_EXTENSION_METADATA_ADDRESS     = 1,
} WS_ENDPOINT_ADDRESS_EXTENSION_TYPE;



//  Errors enum
//  
//   A set of property values associated with the error.  They are set
//  and retrieved using WsGetErrorProperty and
//   WsSetErrorProperty.
//  
typedef enum
{
    WS_ERROR_PROPERTY_STRING_COUNT            = 0,
    WS_ERROR_PROPERTY_ORIGINAL_ERROR_CODE     = 1,
    WS_ERROR_PROPERTY_LANGID                  = 2,
} WS_ERROR_PROPERTY_ID;



//  Errors enum
//  
//   An enumeration of structured exception codes thrown by this component.  These
//  exceptions are fatal and should not be handled by the application.
//  
typedef enum
{
    WS_EXCEPTION_CODE_USAGE_FAILURE        = 0xC03D0000,
    WS_EXCEPTION_CODE_INTERNAL_FAILURE     = 0xc03d0001,
} WS_EXCEPTION_CODE;



//  Faults enum
//  
//   A set of values used with WsSetFaultErrorProperty and
//   WsGetFaultErrorProperty.
//  
typedef enum
{
    WS_FAULT_ERROR_PROPERTY_FAULT      = 0,
    WS_FAULT_ERROR_PROPERTY_ACTION     = 1,
    WS_FAULT_ERROR_PROPERTY_HEADER     = 2,
} WS_FAULT_ERROR_PROPERTY_ID;



//  Faults enum
//  
//   Controls how much error information is included in a fault.
//  
typedef enum
{
    WS_MINIMAL_FAULT_DISCLOSURE     = 0,
    WS_FULL_FAULT_DISCLOSURE        = 1,
} WS_FAULT_DISCLOSURE;



//  Heap enum
//  
//   Each heap property is identified by an ID and has an associated value.
//  
typedef enum
{
    WS_HEAP_PROPERTY_MAX_SIZE           = 0,
    WS_HEAP_PROPERTY_TRIM_SIZE          = 1,
    WS_HEAP_PROPERTY_REQUESTED_SIZE     = 2,
    WS_HEAP_PROPERTY_ACTUAL_SIZE        = 3,
} WS_HEAP_PROPERTY_ID;



//  Listener enum
//  And enumeration of the different states that a listener can be in.
typedef enum
{
    WS_LISTENER_STATE_CREATED     = 0,
    WS_LISTENER_STATE_OPENING     = 1,
    WS_LISTENER_STATE_OPEN        = 2,
    WS_LISTENER_STATE_FAULTED     = 3,
    WS_LISTENER_STATE_CLOSING     = 4,
    WS_LISTENER_STATE_CLOSED      = 5,
} WS_LISTENER_STATE;



//  Listener enum
//  
//   Each listener property is of type WS_LISTENER_PROPERTY and is
//  is identified by an ID and has an associated value.  If a property
//  is not specified when the listener is created, then its default value is used.
//  
typedef enum
{
    WS_LISTENER_PROPERTY_LISTEN_BACKLOG                     = 0,
    WS_LISTENER_PROPERTY_IP_VERSION                         = 1,
    WS_LISTENER_PROPERTY_STATE                              = 2,
    WS_LISTENER_PROPERTY_ASYNC_CALLBACK_MODEL               = 3,
    WS_LISTENER_PROPERTY_CHANNEL_TYPE                       = 4,
    WS_LISTENER_PROPERTY_CHANNEL_BINDING                    = 5,
    WS_LISTENER_PROPERTY_CONNECT_TIMEOUT                    = 6,
    WS_LISTENER_PROPERTY_IS_MULTICAST                       = 7,
    WS_LISTENER_PROPERTY_MULTICAST_INTERFACES               = 8,
    WS_LISTENER_PROPERTY_MULTICAST_LOOPBACK                 = 9,
    WS_LISTENER_PROPERTY_CLOSE_TIMEOUT                      = 10,
    WS_LISTENER_PROPERTY_TO_HEADER_MATCHING_OPTIONS         = 11,
    WS_LISTENER_PROPERTY_TRANSPORT_URL_MATCHING_OPTIONS     = 12,
    WS_LISTENER_PROPERTY_CUSTOM_LISTENER_CALLBACKS          = 13,
    WS_LISTENER_PROPERTY_CUSTOM_LISTENER_PARAMETERS         = 14,
    WS_LISTENER_PROPERTY_CUSTOM_LISTENER_INSTANCE           = 15,
    WS_LISTENER_PROPERTY_DISALLOWED_USER_AGENT              = 16,
} WS_LISTENER_PROPERTY_ID;



//  Listener enum
//  
//   Specifies an IP version.
//  
typedef enum
{
    WS_IP_VERSION_4        = 1,
    WS_IP_VERSION_6        = 2,
    WS_IP_VERSION_AUTO     = 3,
} WS_IP_VERSION;



//  Listener enum
//  
//   A set of flags used to specify how to match a URL.
//  
enum
{
    WS_MATCH_URL_DNS_HOST                     = 0x1,
    WS_MATCH_URL_DNS_FULLY_QUALIFIED_HOST     = 0x2,
    WS_MATCH_URL_NETBIOS_HOST                 = 0x4,
    WS_MATCH_URL_LOCAL_HOST                   = 0x8,
    WS_MATCH_URL_HOST_ADDRESSES               = 0x10,
    WS_MATCH_URL_THIS_HOST                    = (WS_MATCH_URL_DNS_HOST | WS_MATCH_URL_DNS_FULLY_QUALIFIED_HOST | WS_MATCH_URL_NETBIOS_HOST | WS_MATCH_URL_LOCAL_HOST | WS_MATCH_URL_HOST_ADDRESSES),
    WS_MATCH_URL_PORT                         = 0x20,
    WS_MATCH_URL_EXACT_PATH                   = 0x40,
    WS_MATCH_URL_PREFIX_PATH                  = 0x80,
    WS_MATCH_URL_NO_QUERY                     = 0x100,
};



//  Message enum
//  
//   The different states that a message can be in.
//  
typedef enum
{
    WS_MESSAGE_STATE_EMPTY           = 1,
    WS_MESSAGE_STATE_INITIALIZED     = 2,
    WS_MESSAGE_STATE_READING         = 3,
    WS_MESSAGE_STATE_WRITING         = 4,
    WS_MESSAGE_STATE_DONE            = 5,
} WS_MESSAGE_STATE;



//  Message enum
//  
//   The following values specify what headers the
//   WsInitializeMessage
//   should add to the message.
//  
typedef enum
{
    WS_BLANK_MESSAGE         = 0,
    WS_DUPLICATE_MESSAGE     = 1,
    WS_REQUEST_MESSAGE       = 2,
    WS_REPLY_MESSAGE         = 3,
    WS_FAULT_MESSAGE         = 4,
} WS_MESSAGE_INITIALIZATION;



//  Message enum
//  
//   This enum is used to specify whether a header is expected
//  to appear more than once in a message.
//  
typedef enum
{
    WS_REPEATING_HEADER     = 1,
    WS_SINGLETON_HEADER     = 2,
} WS_REPEATING_HEADER_OPTION;



//  Message enum
//  
//   Identifies a type of header.
//  
typedef enum
{
    WS_ACTION_HEADER         = 1,
    WS_TO_HEADER             = 2,
    WS_MESSAGE_ID_HEADER     = 3,
    WS_RELATES_TO_HEADER     = 4,
    WS_FROM_HEADER           = 5,
    WS_REPLY_TO_HEADER       = 6,
    WS_FAULT_TO_HEADER       = 7,
} WS_HEADER_TYPE;



//  Message enum
//  
//   A set of flags representing the SOAP mustUnderstand and relay attributes of a header.
//  
enum
{
    WS_MUST_UNDERSTAND_HEADER_ATTRIBUTE     = 0x1,
    WS_RELAY_HEADER_ATTRIBUTE               = 0x2,
};



//  Message enum
//  
//   The following values identify the version of the specification used for
//  the addressing headers.
typedef enum
{
    WS_ADDRESSING_VERSION_0_9           = 1,
    WS_ADDRESSING_VERSION_1_0           = 2,
    WS_ADDRESSING_VERSION_TRANSPORT     = 3,
} WS_ADDRESSING_VERSION;



//  Message enum
//  
//   Identifies the version of the specification used for the envelope
//  structure.
//  
typedef enum
{
    WS_ENVELOPE_VERSION_SOAP_1_1     = 1,
    WS_ENVELOPE_VERSION_SOAP_1_2     = 2,
    WS_ENVELOPE_VERSION_NONE         = 3,
} WS_ENVELOPE_VERSION;



//  Message enum
//  
//   Each message property is identified by an ID and has an associated
//  value.
//  
typedef enum
{
    WS_MESSAGE_PROPERTY_STATE                                = 0,
    WS_MESSAGE_PROPERTY_HEAP                                 = 1,
    WS_MESSAGE_PROPERTY_ENVELOPE_VERSION                     = 2,
    WS_MESSAGE_PROPERTY_ADDRESSING_VERSION                   = 3,
    WS_MESSAGE_PROPERTY_HEADER_BUFFER                        = 4,
    WS_MESSAGE_PROPERTY_HEADER_POSITION                      = 5,
    WS_MESSAGE_PROPERTY_BODY_READER                          = 6,
    WS_MESSAGE_PROPERTY_BODY_WRITER                          = 7,
    WS_MESSAGE_PROPERTY_IS_ADDRESSED                         = 8,
    WS_MESSAGE_PROPERTY_HEAP_PROPERTIES                      = 9,
    WS_MESSAGE_PROPERTY_XML_READER_PROPERTIES                = 10,
    WS_MESSAGE_PROPERTY_XML_WRITER_PROPERTIES                = 11,
    WS_MESSAGE_PROPERTY_IS_FAULT                             = 12,
    WS_MESSAGE_PROPERTY_MAX_PROCESSED_HEADERS                = 13,
    WS_MESSAGE_PROPERTY_USERNAME                             = 14,
    WS_MESSAGE_PROPERTY_ENCODED_CERT                         = 15,
    WS_MESSAGE_PROPERTY_TRANSPORT_SECURITY_WINDOWS_TOKEN     = 16,
    WS_MESSAGE_PROPERTY_HTTP_HEADER_AUTH_WINDOWS_TOKEN       = 17,
    WS_MESSAGE_PROPERTY_MESSAGE_SECURITY_WINDOWS_TOKEN       = 18,
    WS_MESSAGE_PROPERTY_SAML_ASSERTION                       = 19,
    WS_MESSAGE_PROPERTY_SECURITY_CONTEXT                     = 20,
    WS_MESSAGE_PROPERTY_PROTECTION_LEVEL                     = 21,
} WS_MESSAGE_PROPERTY_ID;



//  Security Bindings enum
//  
//  The type of the security binding, used as a selector for subtypes of
//   WS_SECURITY_BINDING.  In general, the type name of the
//  security binding (one of the values defined here) specifies how the
//  security token used with that security binding is obtained and used.
//  
typedef enum
{
    WS_SSL_TRANSPORT_SECURITY_BINDING_TYPE                = 1,
    WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING_TYPE           = 2,
    WS_HTTP_HEADER_AUTH_SECURITY_BINDING_TYPE             = 3,
    WS_USERNAME_MESSAGE_SECURITY_BINDING_TYPE             = 4,
    WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_TYPE       = 5,
    WS_XML_TOKEN_MESSAGE_SECURITY_BINDING_TYPE            = 6,
    WS_SAML_MESSAGE_SECURITY_BINDING_TYPE                 = 7,
    WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING_TYPE     = 8,
} WS_SECURITY_BINDING_TYPE;



//  Security Binding Settings enum
//  
//  Defines the options for performing client authentication using HTTP
//  authentication headers.
//  
enum
{
    WS_HTTP_HEADER_AUTH_SCHEME_NONE          = 0x1,
    WS_HTTP_HEADER_AUTH_SCHEME_BASIC         = 0x2,
    WS_HTTP_HEADER_AUTH_SCHEME_DIGEST        = 0x4,
    WS_HTTP_HEADER_AUTH_SCHEME_NTLM          = 0x8,
    WS_HTTP_HEADER_AUTH_SCHEME_NEGOTIATE     = 0x10,
    WS_HTTP_HEADER_AUTH_SCHEME_PASSPORT      = 0x20,
};



//  Security Binding Settings enum
//  
//  Defines the target for the HTTP header authentication security binding.
//  
typedef enum
{
    WS_HTTP_HEADER_AUTH_TARGET_SERVICE     = 1,
    WS_HTTP_HEADER_AUTH_TARGET_PROXY       = 2,
} WS_HTTP_HEADER_AUTH_TARGET;



//  Security Binding Settings enum
//  
//  Defines the specific SSP package to be used for Windows Integrated
//  Authentication.
//  
typedef enum
{
    WS_WINDOWS_INTEGRATED_AUTH_PACKAGE_KERBEROS     = 1,
    WS_WINDOWS_INTEGRATED_AUTH_PACKAGE_NTLM         = 2,
    WS_WINDOWS_INTEGRATED_AUTH_PACKAGE_SPNEGO       = 3,
} WS_WINDOWS_INTEGRATED_AUTH_PACKAGE;



//  Security Channel Settings enum
//  
//   Defines the WS-Security specification version to be used with message
//  security and mixed-mode security.
//  
typedef enum
{
    WS_SECURITY_HEADER_VERSION_1_0     = 0x1,
    WS_SECURITY_HEADER_VERSION_1_1     = 0x2,
} WS_SECURITY_HEADER_VERSION;



//  Security Binding Settings enum
//  
//   Defines the WS-Trust specification version to be used with message
//  security and mixed-mode security.
//  
typedef enum
{
    WS_TRUST_VERSION_FEBRUARY_2005     = 0x1,
    WS_TRUST_VERSION_1_3               = 0x2,
} WS_TRUST_VERSION;



//  Security Binding Settings enum
//  
//   Defines which set of actions to use when negotiating security tokens using WS-Trust.
//  
typedef enum
{
    WS_REQUEST_SECURITY_TOKEN_ACTION_ISSUE             = 1,
    WS_REQUEST_SECURITY_TOKEN_ACTION_NEW_CONTEXT       = 2,
    WS_REQUEST_SECURITY_TOKEN_ACTION_RENEW_CONTEXT     = 3,
} WS_REQUEST_SECURITY_TOKEN_ACTION;



//  Security Channel Settings enum
//  
//   Defines the WS-SecureCoversation specification version to be used with message
//  security and mixed-mode security.
//  
typedef enum
{
    WS_SECURE_CONVERSATION_VERSION_FEBRUARY_2005     = 0x1,
    WS_SECURE_CONVERSATION_VERSION_1_3               = 0x2,
} WS_SECURE_CONVERSATION_VERSION;



//  Security Channel Settings enum
//  
//  With message security and mixed-mode security, this defines when a
//  timestamp element should be generated and demanded in the WS-Security
//  header.
//  
typedef enum
{
    WS_SECURITY_TIMESTAMP_USAGE_ALWAYS            = 1,
    WS_SECURITY_TIMESTAMP_USAGE_NEVER             = 2,
    WS_SECURITY_TIMESTAMP_USAGE_REQUESTS_ONLY     = 3,
} WS_SECURITY_TIMESTAMP_USAGE;



//  Security Channel Settings enum
//  
//  Defines the layout rules applied to the elements of the WS-Security
//  security header.  This setting is relevant to message security
//  bindings and mixed-mode security bindings.
//  
typedef enum
{
    WS_SECURITY_HEADER_LAYOUT_STRICT                       = 1,
    WS_SECURITY_HEADER_LAYOUT_LAX                          = 2,
    WS_SECURITY_HEADER_LAYOUT_LAX_WITH_TIMESTAMP_FIRST     = 3,
    WS_SECURITY_HEADER_LAYOUT_LAX_WITH_TIMESTAMP_LAST      = 4,
} WS_SECURITY_HEADER_LAYOUT;



//  Security Channel Settings enum
//  
//  Identifies the properties representing security algorithm knobs.
//  
typedef enum
{
} WS_SECURITY_ALGORITHM_PROPERTY_ID;



//  Security Channel Settings enum
//  
//   Defines the security algorithms to be used with WS-Security.
//  These values are relevant to message security bindings
//  and mixed-mode security bindings.
//  
typedef enum
{
    WS_SECURITY_ALGORITHM_DEFAULT                                      = 0,
    WS_SECURITY_ALGORITHM_CANONICALIZATION_EXCLUSIVE                   = 1,
    WS_SECURITY_ALGORITHM_CANONICALIZATION_EXCLUSIVE_WITH_COMMENTS     = 2,
    WS_SECURITY_ALGORITHM_DIGEST_SHA1                                  = 3,
    WS_SECURITY_ALGORITHM_DIGEST_SHA_256                               = 4,
    WS_SECURITY_ALGORITHM_DIGEST_SHA_384                               = 5,
    WS_SECURITY_ALGORITHM_DIGEST_SHA_512                               = 6,
    WS_SECURITY_ALGORITHM_SYMMETRIC_SIGNATURE_HMAC_SHA1                = 7,
    WS_SECURITY_ALGORITHM_SYMMETRIC_SIGNATURE_HMAC_SHA_256             = 8,
    WS_SECURITY_ALGORITHM_SYMMETRIC_SIGNATURE_HMAC_SHA_384             = 9,
    WS_SECURITY_ALGORITHM_SYMMETRIC_SIGNATURE_HMAC_SHA_512             = 10,
    WS_SECURITY_ALGORITHM_ASYMMETRIC_SIGNATURE_RSA_SHA1                = 11,
    WS_SECURITY_ALGORITHM_ASYMMETRIC_SIGNATURE_DSA_SHA1                = 12,
    WS_SECURITY_ALGORITHM_ASYMMETRIC_SIGNATURE_RSA_SHA_256             = 13,
    WS_SECURITY_ALGORITHM_ASYMMETRIC_SIGNATURE_RSA_SHA_384             = 14,
    WS_SECURITY_ALGORITHM_ASYMMETRIC_SIGNATURE_RSA_SHA_512             = 15,
    WS_SECURITY_ALGORITHM_ASYMMETRIC_KEYWRAP_RSA_1_5                   = 16,
    WS_SECURITY_ALGORITHM_ASYMMETRIC_KEYWRAP_RSA_OAEP                  = 17,
    WS_SECURITY_ALGORITHM_KEY_DERIVATION_P_SHA1                        = 18,
} WS_SECURITY_ALGORITHM_ID;



//  Security Channel Settings enum
//  
//  Defines the required integrity and confidentiality levels for sent and
//  received messages.  With transport and mixed-mode security bindings,
//  this setting applies to each message as a whole.  With message
//  security, the protection level is specified at the granularity of a
//  message header or body.  The default value defined applies only to
//  transport and mixed-mode security.
//  
typedef enum
{
    WS_PROTECTION_LEVEL_NONE                 = 1,
    WS_PROTECTION_LEVEL_SIGN                 = 2,
    WS_PROTECTION_LEVEL_SIGN_AND_ENCRYPT     = 3,
} WS_PROTECTION_LEVEL;



//  Security Channel Settings enum
//  
//   Identifies the properties representing channel-wide security knobs.
//  
typedef enum
{
    WS_SECURITY_PROPERTY_TRANSPORT_PROTECTION_LEVEL       = 1,
    WS_SECURITY_PROPERTY_ALGORITHM_SUITE                  = 2,
    WS_SECURITY_PROPERTY_ALGORITHM_SUITE_NAME             = 3,
    WS_SECURITY_PROPERTY_MAX_ALLOWED_LATENCY              = 4,
    WS_SECURITY_PROPERTY_TIMESTAMP_VALIDITY_DURATION      = 5,
    WS_SECURITY_PROPERTY_MAX_ALLOWED_CLOCK_SKEW           = 6,
    WS_SECURITY_PROPERTY_TIMESTAMP_USAGE                  = 7,
    WS_SECURITY_PROPERTY_SECURITY_HEADER_LAYOUT           = 8,
    WS_SECURITY_PROPERTY_SECURITY_HEADER_VERSION          = 9,
    WS_SECURITY_PROPERTY_EXTENDED_PROTECTION_POLICY       = 10,
    WS_SECURITY_PROPERTY_EXTENDED_PROTECTION_SCENARIO     = 11,
    WS_SECURITY_PROPERTY_SERVICE_IDENTITIES               = 12,
} WS_SECURITY_PROPERTY_ID;



//  Security Binding Settings enum
//  
//  The key type of a security token.  It is used as the return type when
//  a security token is queried about its key.  It is also used to specify
//  the required key type when requesting a security token from a security
//  token service.
//  
typedef enum
{
    WS_SECURITY_KEY_TYPE_NONE           = 1,
    WS_SECURITY_KEY_TYPE_SYMMETRIC      = 2,
    WS_SECURITY_KEY_TYPE_ASYMMETRIC     = 3,
} WS_SECURITY_KEY_TYPE;



//  Security Binding Settings enum
//  
//   A suite of security algorithms used for tasks such as signing and encryting.
//  The values in this enumeration correspond to the suites defined in
//   (http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/) WS-SecurityPolicy 1.1
//   section 7.1.
//  
typedef enum
{
    WS_SECURITY_ALGORITHM_SUITE_NAME_BASIC256                  = 1,
    WS_SECURITY_ALGORITHM_SUITE_NAME_BASIC192                  = 2,
    WS_SECURITY_ALGORITHM_SUITE_NAME_BASIC128                  = 3,
    WS_SECURITY_ALGORITHM_SUITE_NAME_BASIC256_RSA15            = 4,
    WS_SECURITY_ALGORITHM_SUITE_NAME_BASIC192_RSA15            = 5,
    WS_SECURITY_ALGORITHM_SUITE_NAME_BASIC128_RSA15            = 6,
    WS_SECURITY_ALGORITHM_SUITE_NAME_BASIC256_SHA256           = 7,
    WS_SECURITY_ALGORITHM_SUITE_NAME_BASIC192_SHA256           = 8,
    WS_SECURITY_ALGORITHM_SUITE_NAME_BASIC128_SHA256           = 9,
    WS_SECURITY_ALGORITHM_SUITE_NAME_BASIC256_SHA256_RSA15     = 10,
    WS_SECURITY_ALGORITHM_SUITE_NAME_BASIC192_SHA256_RSA15     = 11,
    WS_SECURITY_ALGORITHM_SUITE_NAME_BASIC128_SHA256_RSA15     = 12,
} WS_SECURITY_ALGORITHM_SUITE_NAME;



//  Security Binding Settings enum
//  
//  With message and mixed-mode security bindings, the mechanism to use to
//  refer to a security token from signatures, encrypted items and derived
//  tokens.  The security runtime can use the right reference on its own
//  most of the time, and this needs to be explicitly set only when a
//  specific reference mechanism is required, typically for interop with
//  another platform that supports only that reference form.
//  
typedef enum
{
    WS_SECURITY_TOKEN_REFERENCE_MODE_LOCAL_ID                = 1,
    WS_SECURITY_TOKEN_REFERENCE_MODE_XML_BUFFER              = 2,
    WS_SECURITY_TOKEN_REFERENCE_MODE_CERT_THUMBPRINT         = 3,
    WS_SECURITY_TOKEN_REFERENCE_MODE_SECURITY_CONTEXT_ID     = 4,
    WS_SECURITY_TOKEN_REFERENCE_MODE_SAML_ASSERTION_ID       = 5,
} WS_SECURITY_TOKEN_REFERENCE_MODE;



//  Security Binding Settings enum
//  
//   Defines failures related to certificate validation. Can be used with WS_SECURITY_BINDING_PROPERTY_CERT_FAILURES_TO_IGNORE to
//  specify which certificate verification failures should be ignored.
//  
enum
{
    WS_CERT_FAILURE_CN_MISMATCH            = 0x1,
    WS_CERT_FAILURE_INVALID_DATE           = 0x2,
    WS_CERT_FAILURE_UNTRUSTED_ROOT         = 0x4,
    WS_CERT_FAILURE_WRONG_USAGE            = 0x8,
    WS_CERT_FAILURE_REVOCATION_OFFLINE     = 0x10,
};



//  Security Binding Settings enum
//  
//  Defines how randomness should be contributed to the issued key during
//  a security token negotiation done with message and mixed-mode security.
//  
typedef enum
{
    WS_SECURITY_KEY_ENTROPY_MODE_CLIENT_ONLY     = 1,
    WS_SECURITY_KEY_ENTROPY_MODE_SERVER_ONLY     = 2,
    WS_SECURITY_KEY_ENTROPY_MODE_COMBINED        = 3,
} WS_SECURITY_KEY_ENTROPY_MODE;



//  Extended Protection enum
//  
//   Defines if Extended Protection data should be validated. This property is only available on the server,
//  and can only be set when WS_HTTP_CHANNEL_BINDING with WS_SSL_TRANSPORT_SECURITY_BINDING and either WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING
//   or WS_HTTP_HEADER_AUTH_SECURITY_BINDING is used.
//  
typedef enum
{
    WS_EXTENDED_PROTECTION_POLICY_NEVER              = 1,
    WS_EXTENDED_PROTECTION_POLICY_WHEN_SUPPORTED     = 2,
    WS_EXTENDED_PROTECTION_POLICY_ALWAYS             = 3,
} WS_EXTENDED_PROTECTION_POLICY;



//  Extended Protection enum
//  
//   Defines how Extended Protection is validated. For most configurations, the runtime can automatically determine what needs to
//  be validated based on the presence of the WS_SSL_TRANSPORT_SECURITY_BINDING. However, if the SSL connection is terminated at
//  an intermediary such as a proxy prior to reaching the server then the validation method must change, and this scenario cannot be automatically detected.
//  
//   Only available on the server.
//  
typedef enum
{
    WS_EXTENDED_PROTECTION_SCENARIO_BOUND_SERVER       = 1,
    WS_EXTENDED_PROTECTION_SCENARIO_TERMINATED_SSL     = 2,
} WS_EXTENDED_PROTECTION_SCENARIO;



//  Security Binding Settings enum
//  
//   Identifies the properties used to specify security
//  binding settings.  Security binding settings are present
//  in (WS_SECURITY_BINDING) security bindings
//  that are used, in turn, in a (WS_SECURITY_DESCRIPTION) security description.
//  
//  Note that the related enum WS_SECURITY_TOKEN_PROPERTY_ID
//  defines the keys for extracting fields from a security token instance.
//  Thus, WS_SECURITY_BINDING_PROPERTY enables specifying security binding
//  settings at channel / listener creation time to influence how a
//  security token is created and used, whereas WS_SECURITY_TOKEN_PROPERTY_ID
//  enables extracting fields out of a security token -- typically a
//  security token from a received message when the channel and security
//  are 'live'.
//  
typedef enum
{
    WS_SECURITY_BINDING_PROPERTY_REQUIRE_SSL_CLIENT_CERT                   = 1,
    WS_SECURITY_BINDING_PROPERTY_WINDOWS_INTEGRATED_AUTH_PACKAGE           = 2,
    WS_SECURITY_BINDING_PROPERTY_REQUIRE_SERVER_AUTH                       = 3,
    WS_SECURITY_BINDING_PROPERTY_ALLOW_ANONYMOUS_CLIENTS                   = 4,
    WS_SECURITY_BINDING_PROPERTY_ALLOWED_IMPERSONATION_LEVEL               = 5,
    WS_SECURITY_BINDING_PROPERTY_HTTP_HEADER_AUTH_SCHEME                   = 6,
    WS_SECURITY_BINDING_PROPERTY_HTTP_HEADER_AUTH_TARGET                   = 7,
    WS_SECURITY_BINDING_PROPERTY_HTTP_HEADER_AUTH_BASIC_REALM              = 8,
    WS_SECURITY_BINDING_PROPERTY_HTTP_HEADER_AUTH_DIGEST_REALM             = 9,
    WS_SECURITY_BINDING_PROPERTY_HTTP_HEADER_AUTH_DIGEST_DOMAIN            = 10,
    WS_SECURITY_BINDING_PROPERTY_SECURITY_CONTEXT_KEY_SIZE                 = 11,
    WS_SECURITY_BINDING_PROPERTY_SECURITY_CONTEXT_KEY_ENTROPY_MODE         = 12,
    WS_SECURITY_BINDING_PROPERTY_MESSAGE_PROPERTIES                        = 13,
    WS_SECURITY_BINDING_PROPERTY_SECURITY_CONTEXT_MAX_PENDING_CONTEXTS     = 14,
    WS_SECURITY_BINDING_PROPERTY_SECURITY_CONTEXT_MAX_ACTIVE_CONTEXTS      = 15,
    WS_SECURITY_BINDING_PROPERTY_SECURE_CONVERSATION_VERSION               = 16,
    WS_SECURITY_BINDING_PROPERTY_SECURITY_CONTEXT_SUPPORT_RENEW            = 17,
    WS_SECURITY_BINDING_PROPERTY_SECURITY_CONTEXT_RENEWAL_INTERVAL         = 18,
    WS_SECURITY_BINDING_PROPERTY_SECURITY_CONTEXT_ROLLOVER_INTERVAL        = 19,
    WS_SECURITY_BINDING_PROPERTY_CERT_FAILURES_TO_IGNORE                   = 20,
    WS_SECURITY_BINDING_PROPERTY_DISABLE_CERT_REVOCATION_CHECK             = 21,
} WS_SECURITY_BINDING_PROPERTY_ID;



//  Security Credentials enum
//  
//  The type of the certificate credential, used as a selector for
//  subtypes of WS_CERT_CREDENTIAL.
//  
typedef enum
{
    WS_SUBJECT_NAME_CERT_CREDENTIAL_TYPE     = 1,
    WS_THUMBPRINT_CERT_CREDENTIAL_TYPE       = 2,
    WS_CUSTOM_CERT_CREDENTIAL_TYPE           = 3,
} WS_CERT_CREDENTIAL_TYPE;



//  Security Credentials enum
//  
//  The type of the Windows Integrated Authentication credential, used as
//  a selector for subtypes of WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL.
//  
typedef enum
{
    WS_STRING_WINDOWS_INTEGRATED_AUTH_CREDENTIAL_TYPE      = 1,
    WS_DEFAULT_WINDOWS_INTEGRATED_AUTH_CREDENTIAL_TYPE     = 2,
    WS_OPAQUE_WINDOWS_INTEGRATED_AUTH_CREDENTIAL_TYPE      = 3,
} WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL_TYPE;



//  Security Credentials enum
//  
//  The type of the username/password credential, used as a selector for
//  subtypes of WS_USERNAME_CREDENTIAL.
//  
typedef enum
{
    WS_STRING_USERNAME_CREDENTIAL_TYPE     = 1,
} WS_USERNAME_CREDENTIAL_TYPE;



//  Security Processing Results enum
//  
//   Defines the keys for the fields and properties that can be extracted
//  from a security token.  Not all properties are valid for all security
//  token types.  The function WsGetSecurityTokenProperty uses
//  the values defined here as keys.
//  
//   See also WS_SECURITY_BINDING_PROPERTY.
//  
typedef enum
{
    WS_SECURITY_TOKEN_PROPERTY_KEY_TYPE                     = 1,
    WS_SECURITY_TOKEN_PROPERTY_VALID_FROM_TIME              = 2,
    WS_SECURITY_TOKEN_PROPERTY_VALID_TILL_TIME              = 3,
    WS_SECURITY_TOKEN_PROPERTY_SERIALIZED_XML               = 4,
    WS_SECURITY_TOKEN_PROPERTY_ATTACHED_REFERENCE_XML       = 5,
    WS_SECURITY_TOKEN_PROPERTY_UNATTACHED_REFERENCE_XML     = 6,
    WS_SECURITY_TOKEN_PROPERTY_SYMMETRIC_KEY                = 7,
} WS_SECURITY_TOKEN_PROPERTY_ID;



//  Security Bindings enum
//  
//  Types of security keys.
//  
typedef enum
{
    WS_RAW_SYMMETRIC_SECURITY_KEY_HANDLE_TYPE         = 1,
    WS_NCRYPT_ASYMMETRIC_SECURITY_KEY_HANDLE_TYPE     = 2,
    WS_CAPI_ASYMMETRIC_SECURITY_KEY_HANDLE_TYPE       = 3,
} WS_SECURITY_KEY_HANDLE_TYPE;



//  Security Bindings enum
//  
//  Defines how a message security binding attaches the security token
//  corresponding to it to a message using WS-Security mechanisms.
//  
typedef enum
{
    WS_SUPPORTING_MESSAGE_SECURITY_USAGE     = 1,
} WS_MESSAGE_SECURITY_USAGE;



//  Security Context enum
//  
//   Identifies a property of a security context object.
//  
typedef enum
{
    WS_SECURITY_CONTEXT_PROPERTY_IDENTIFIER                         = 1,
    WS_SECURITY_CONTEXT_PROPERTY_USERNAME                           = 2,
    WS_SECURITY_CONTEXT_PROPERTY_MESSAGE_SECURITY_WINDOWS_TOKEN     = 3,
    WS_SECURITY_CONTEXT_PROPERTY_SAML_ASSERTION                     = 4,
} WS_SECURITY_CONTEXT_PROPERTY_ID;



//  Security Channel Settings enum
//  
//   Identifies the properties for the creation of XML security tokens.
//  
typedef enum
{
    WS_XML_SECURITY_TOKEN_PROPERTY_ATTACHED_REFERENCE       = 1,
    WS_XML_SECURITY_TOKEN_PROPERTY_UNATTACHED_REFERENCE     = 2,
    WS_XML_SECURITY_TOKEN_PROPERTY_VALID_FROM_TIME          = 3,
    WS_XML_SECURITY_TOKEN_PROPERTY_VALID_TILL_TIME          = 4,
} WS_XML_SECURITY_TOKEN_PROPERTY_ID;



//  Security Bindings enum
//  
//  The type ids of the SAML token authenticators used on the server side
//  (i.e., relying party) to validate incoming SAML tokens.
//  
typedef enum
{
    WS_CERT_SIGNED_SAML_AUTHENTICATOR_TYPE     = 1,
} WS_SAML_AUTHENTICATOR_TYPE;



//  Security Channel Settings enum
//  
//   Identifies the properties for requesting a security token from an issuer.
//  
typedef enum
{
    WS_REQUEST_SECURITY_TOKEN_PROPERTY_APPLIES_TO                      = 1,
    WS_REQUEST_SECURITY_TOKEN_PROPERTY_TRUST_VERSION                   = 2,
    WS_REQUEST_SECURITY_TOKEN_PROPERTY_SECURE_CONVERSATION_VERSION     = 3,
    WS_REQUEST_SECURITY_TOKEN_PROPERTY_ISSUED_TOKEN_TYPE               = 4,
    WS_REQUEST_SECURITY_TOKEN_PROPERTY_REQUEST_ACTION                  = 5,
    WS_REQUEST_SECURITY_TOKEN_PROPERTY_EXISTING_TOKEN                  = 6,
    WS_REQUEST_SECURITY_TOKEN_PROPERTY_ISSUED_TOKEN_KEY_TYPE           = 7,
    WS_REQUEST_SECURITY_TOKEN_PROPERTY_ISSUED_TOKEN_KEY_SIZE           = 8,
    WS_REQUEST_SECURITY_TOKEN_PROPERTY_ISSUED_TOKEN_KEY_ENTROPY        = 9,
    WS_REQUEST_SECURITY_TOKEN_PROPERTY_LOCAL_REQUEST_PARAMETERS        = 10,
    WS_REQUEST_SECURITY_TOKEN_PROPERTY_SERVICE_REQUEST_PARAMETERS      = 11,
    WS_REQUEST_SECURITY_TOKEN_PROPERTY_MESSAGE_PROPERTIES              = 12,
} WS_REQUEST_SECURITY_TOKEN_PROPERTY_ID;



//  Serialization enum
//  
//   An enumeration of the different types supported for serialization.
//  
typedef enum
{
    WS_BOOL_TYPE                 = 0,
    WS_INT8_TYPE                 = 1,
    WS_INT16_TYPE                = 2,
    WS_INT32_TYPE                = 3,
    WS_INT64_TYPE                = 4,
    WS_UINT8_TYPE                = 5,
    WS_UINT16_TYPE               = 6,
    WS_UINT32_TYPE               = 7,
    WS_UINT64_TYPE               = 8,
    WS_FLOAT_TYPE                = 9,
    WS_DOUBLE_TYPE               = 10,
    WS_DECIMAL_TYPE              = 11,
    WS_DATETIME_TYPE             = 12,
    WS_TIMESPAN_TYPE             = 13,
    WS_GUID_TYPE                 = 14,
    WS_UNIQUE_ID_TYPE            = 15,
    WS_STRING_TYPE               = 16,
    WS_WSZ_TYPE                  = 17,
    WS_BYTES_TYPE                = 18,
    WS_XML_STRING_TYPE           = 19,
    WS_XML_QNAME_TYPE            = 20,
    WS_XML_BUFFER_TYPE           = 21,
    WS_CHAR_ARRAY_TYPE           = 22,
    WS_UTF8_ARRAY_TYPE           = 23,
    WS_BYTE_ARRAY_TYPE           = 24,
    WS_DESCRIPTION_TYPE          = 25,
    WS_STRUCT_TYPE               = 26,
    WS_CUSTOM_TYPE               = 27,
    WS_ENDPOINT_ADDRESS_TYPE     = 28,
    WS_FAULT_TYPE                = 29,
    WS_VOID_TYPE                 = 30,
    WS_ENUM_TYPE                 = 31,
    WS_DURATION_TYPE             = 32,
    WS_UNION_TYPE                = 33,
    WS_ANY_ATTRIBUTES_TYPE       = 34,
} WS_TYPE;



//  Serialization enum
//  
//   Specifies how a field of a structure is represented in XML.  This is used within
//  a WS_FIELD_DESCRIPTION.
//  
typedef enum
{
    WS_TYPE_ATTRIBUTE_FIELD_MAPPING               = 0,
    WS_ATTRIBUTE_FIELD_MAPPING                    = 1,
    WS_ELEMENT_FIELD_MAPPING                      = 2,
    WS_REPEATING_ELEMENT_FIELD_MAPPING            = 3,
    WS_TEXT_FIELD_MAPPING                         = 4,
    WS_NO_FIELD_MAPPING                           = 5,
    WS_XML_ATTRIBUTE_FIELD_MAPPING                = 6,
    WS_ELEMENT_CHOICE_FIELD_MAPPING               = 7,
    WS_REPEATING_ELEMENT_CHOICE_FIELD_MAPPING     = 8,
    WS_ANY_ELEMENT_FIELD_MAPPING                  = 9,
    WS_REPEATING_ANY_ELEMENT_FIELD_MAPPING        = 10,
    WS_ANY_CONTENT_FIELD_MAPPING                  = 11,
    WS_ANY_ATTRIBUTES_FIELD_MAPPING               = 12,
} WS_FIELD_MAPPING;



//  Serialization enum
//  
//   A set of flags used within a WS_STRUCT_DESCRIPTION.
//  
enum
{
    WS_STRUCT_ABSTRACT                            = 0x1,
    WS_STRUCT_IGNORE_TRAILING_ELEMENT_CONTENT     = 0x2,
    WS_STRUCT_IGNORE_UNHANDLED_ATTRIBUTES         = 0x4,
};



//  Serialization enum
//  
//   A set of flags used within a WS_FIELD_DESCRIPTION.
//  
enum
{
    WS_FIELD_POINTER             = 0x1,
    WS_FIELD_OPTIONAL            = 0x2,
    WS_FIELD_NILLABLE            = 0x4,
    WS_FIELD_NILLABLE_ITEM       = 0x8,
    WS_FIELD_OTHER_NAMESPACE     = 0x10,
};



//  Serialization enum
//  
//   Specifies how a WS_TYPE maps to/from XML when serialized
//  or deserialized.
//  
typedef enum
{
    WS_ELEMENT_TYPE_MAPPING             = 1,
    WS_ATTRIBUTE_TYPE_MAPPING           = 2,
    WS_ELEMENT_CONTENT_TYPE_MAPPING     = 3,
    WS_ANY_ELEMENT_TYPE_MAPPING         = 4,
} WS_TYPE_MAPPING;



//  Serialization enum
//  
//   Specifies whether a value is required, and how the value should be allocated.
//  
typedef enum
{
    WS_READ_REQUIRED_VALUE       = 1,
    WS_READ_REQUIRED_POINTER     = 2,
    WS_READ_OPTIONAL_POINTER     = 3,
    WS_READ_NILLABLE_POINTER     = 4,
    WS_READ_NILLABLE_VALUE       = 5,
} WS_READ_OPTION;



//  Serialization enum
//  
//   Specifies whether a storage specified contains the value, or a pointer to the value,
//  and whether the value can be represented as nil in the XML content.
//  
typedef enum
{
    WS_WRITE_REQUIRED_VALUE       = 1,
    WS_WRITE_REQUIRED_POINTER     = 2,
    WS_WRITE_NILLABLE_VALUE       = 3,
    WS_WRITE_NILLABLE_POINTER     = 4,
} WS_WRITE_OPTION;



//  Service Operation enum
//  
//   An enumeration of the different reasons for which a cancel can occur.
//  
typedef enum
{
    WS_SERVICE_HOST_ABORT          = 0,
    WS_SERVICE_CHANNEL_FAULTED     = 1,
} WS_SERVICE_CANCEL_REASON;



//  Service Operation enum
//  
//   An enumeration of the different operation styles.
//  
typedef enum
{
    WS_NON_RPC_LITERAL_OPERATION     = 0,
    WS_RPC_LITERAL_OPERATION         = 1,
} WS_OPERATION_STYLE;



//  Service Operation enum
//  
//   An enumeration of the different parameter types.
//  
typedef enum
{
    WS_PARAMETER_TYPE_NORMAL          = 0,
    WS_PARAMETER_TYPE_ARRAY           = 1,
    WS_PARAMETER_TYPE_ARRAY_COUNT     = 2,
    WS_PARAMETER_TYPE_MESSAGES        = 3,
} WS_PARAMETER_TYPE;



//  Service Operation enum
//  
//   A set of flags used within a WS_OPERATION_DESCRIPTION.
//  
enum
{
    WS_SERVICE_OPERATION_MESSAGE_NILLABLE_ELEMENT     = 0x1,
};



//  Service Host enum
//  
//   Each property represents optional parameters for configuring
//  the given WS_SERVICE_ENDPOINT.
//  
typedef enum
{
    WS_SERVICE_ENDPOINT_PROPERTY_ACCEPT_CHANNEL_CALLBACK          = 0,
    WS_SERVICE_ENDPOINT_PROPERTY_CLOSE_CHANNEL_CALLBACK           = 1,
    WS_SERVICE_ENDPOINT_PROPERTY_MAX_ACCEPTING_CHANNELS           = 2,
    WS_SERVICE_ENDPOINT_PROPERTY_MAX_CONCURRENCY                  = 3,
    WS_SERVICE_ENDPOINT_PROPERTY_BODY_HEAP_MAX_SIZE               = 4,
    WS_SERVICE_ENDPOINT_PROPERTY_BODY_HEAP_TRIM_SIZE              = 5,
    WS_SERVICE_ENDPOINT_PROPERTY_MESSAGE_PROPERTIES               = 6,
    WS_SERVICE_ENDPOINT_PROPERTY_MAX_CALL_POOL_SIZE               = 7,
    WS_SERVICE_ENDPOINT_PROPERTY_MAX_CHANNEL_POOL_SIZE            = 8,
    WS_SERVICE_ENDPOINT_PROPERTY_LISTENER_PROPERTIES              = 9,
    WS_SERVICE_ENDPOINT_PROPERTY_CHECK_MUST_UNDERSTAND            = 10,
    WS_SERVICE_ENDPOINT_PROPERTY_METADATA_EXCHANGE_TYPE           = 11,
    WS_SERVICE_ENDPOINT_PROPERTY_METADATA                         = 12,
    WS_SERVICE_ENDPOINT_PROPERTY_METADATA_EXCHANGE_URL_SUFFIX     = 13,
    WS_SERVICE_ENDPOINT_PROPERTY_MAX_CHANNELS                     = 14,
} WS_SERVICE_ENDPOINT_PROPERTY_ID;



//  Service Metadata enum

typedef enum
{
    WS_METADATA_EXCHANGE_TYPE_NONE         = 0,
    WS_METADATA_EXCHANGE_TYPE_MEX          = 1,
    WS_METADATA_EXCHANGE_TYPE_HTTP_GET     = 2,
} WS_METADATA_EXCHANGE_TYPE;



//  Service Host enum
//  
//   Each property represents optional parameters for configuring the service host.
//  
typedef enum
{
    WS_SERVICE_PROPERTY_HOST_USER_STATE      = 0,
    WS_SERVICE_PROPERTY_FAULT_DISCLOSURE     = 1,
    WS_SERVICE_PROPERTY_FAULT_LANGID         = 2,
    WS_SERVICE_PROPERTY_HOST_STATE           = 3,
    WS_SERVICE_PROPERTY_METADATA             = 4,
    WS_SERVICE_PROPERTY_CLOSE_TIMEOUT        = 5,
} WS_SERVICE_PROPERTY_ID;



//  Service Host enum
//  An enumeration of the different states that a service host can be in.
typedef enum
{
    WS_SERVICE_HOST_STATE_CREATED     = 0,
    WS_SERVICE_HOST_STATE_OPENING     = 1,
    WS_SERVICE_HOST_STATE_OPEN        = 2,
    WS_SERVICE_HOST_STATE_CLOSING     = 3,
    WS_SERVICE_HOST_STATE_CLOSED      = 4,
    WS_SERVICE_HOST_STATE_FAULTED     = 5,
} WS_SERVICE_HOST_STATE;



//  Service Proxy State Machine enum
//  
//   See Service Proxy State Machine for detail.
//  
typedef enum
{
    WS_SERVICE_PROXY_STATE_CREATED     = 0,
    WS_SERVICE_PROXY_STATE_OPENING     = 1,
    WS_SERVICE_PROXY_STATE_OPEN        = 2,
    WS_SERVICE_PROXY_STATE_CLOSING     = 3,
    WS_SERVICE_PROXY_STATE_CLOSED      = 4,
    WS_SERVICE_PROXY_STATE_FAULTED     = 5,
} WS_SERVICE_PROXY_STATE;



//  Service Proxy enum
//  
//   Optional parameters for configuring the service proxy. With an exception of
//   WS_PROXY_PROPERTY_STATE all the values are only supported for
//  use with WsCreateServiceProxy.
//  
typedef enum
{
    WS_PROXY_PROPERTY_CALL_TIMEOUT           = 0,
    WS_PROXY_PROPERTY_MESSAGE_PROPERTIES     = 1,
    WS_PROXY_PROPERTY_MAX_CALL_POOL_SIZE     = 2,
    WS_PROXY_PROPERTY_STATE                  = 3,
    WS_PROXY_PROPERTY_MAX_PENDING_CALLS      = 4,
    WS_PROXY_PROPERTY_MAX_CLOSE_TIMEOUT      = 5,
    WS_PROXY_FAULT_LANG_ID                   = 6,
} WS_PROXY_PROPERTY_ID;



//  Service Proxy enum
//  
//   Optional parameters for configuring a call on a client side service operation.
//  
typedef enum
{
    WS_CALL_PROPERTY_CALL_ID                     = 0,
    WS_CALL_PROPERTY_SEND_MESSAGE_CONTEXT        = 1,
    WS_CALL_PROPERTY_RECEIVE_MESSAGE_CONTEXT     = 2,
    WS_CALL_PROPERTY_CHECK_MUST_UNDERSTAND       = 3,
} WS_CALL_PROPERTY_ID;



//  Tracing enum

typedef enum
{
    WS_TRACE_API_NONE                                      = -1,
    WS_TRACE_API_START_READER_CANONICALIZATION             = 0,
    WS_TRACE_API_END_READER_CANONICALIZATION               = 1,
    WS_TRACE_API_START_WRITER_CANONICALIZATION             = 2,
    WS_TRACE_API_END_WRITER_CANONICALIZATION               = 3,
    WS_TRACE_API_CREATE_XML_BUFFER                         = 4,
    WS_TRACE_API_REMOVE_NODE                               = 5,
    WS_TRACE_API_CREATE_READER                             = 6,
    WS_TRACE_API_SET_INPUT                                 = 7,
    WS_TRACE_API_SET_INPUT_TO_BUFFER                       = 8,
    WS_TRACE_API_FREE_XML_READER                           = 9,
    WS_TRACE_API_GET_READER_PROPERTY                       = 10,
    WS_TRACE_API_GET_READER_NODE                           = 11,
    WS_TRACE_API_FILL_READER                               = 12,
    WS_TRACE_API_READ_START_ELEMENT                        = 13,
    WS_TRACE_API_READ_TO_START_ELEMENT                     = 14,
    WS_TRACE_API_READ_START_ATTRIBUTE                      = 15,
    WS_TRACE_API_READ_END_ATTRIBUTE                        = 16,
    WS_TRACE_API_READ_NODE                                 = 17,
    WS_TRACE_API_SKIP_NODE                                 = 18,
    WS_TRACE_API_READ_END_ELEMENT                          = 19,
    WS_TRACE_API_FIND_ATTRIBUTE                            = 20,
    WS_TRACE_API_READ_ELEMENT_VALUE                        = 21,
    WS_TRACE_API_READ_CHARS                                = 22,
    WS_TRACE_API_READ_CHARS_UTF8                           = 23,
    WS_TRACE_API_READ_BYTES                                = 24,
    WS_TRACE_API_READ_ARRAY                                = 25,
    WS_TRACE_API_GET_READER_POSITION                       = 26,
    WS_TRACE_API_SET_READER_POSITION                       = 27,
    WS_TRACE_API_MOVE_READER                               = 28,
    WS_TRACE_API_CREATE_WRITER                             = 29,
    WS_TRACE_API_FREE_XML_WRITER                           = 30,
    WS_TRACE_API_SET_OUTPUT                                = 31,
    WS_TRACE_API_SET_OUTPUT_TO_BUFFER                      = 32,
    WS_TRACE_API_GET_WRITER_PROPERTY                       = 33,
    WS_TRACE_API_FLUSH_WRITER                              = 34,
    WS_TRACE_API_WRITE_START_ELEMENT                       = 35,
    WS_TRACE_API_WRITE_END_START_ELEMENT                   = 36,
    WS_TRACE_API_WRITE_XMLNS_ATTRIBUTE                     = 37,
    WS_TRACE_API_WRITE_START_ATTRIBUTE                     = 38,
    WS_TRACE_API_WRITE_END_ATTRIBUTE                       = 39,
    WS_TRACE_API_WRITE_VALUE                               = 40,
    WS_TRACE_API_WRITE_XML_BUFFER                          = 41,
    WS_TRACE_API_READ_XML_BUFFER                           = 42,
    WS_TRACE_API_WRITE_XML_BUFFER_TO_BYTES                 = 43,
    WS_TRACE_API_READ_XML_BUFFER_FROM_BYTES                = 44,
    WS_TRACE_API_WRITE_ARRAY                               = 45,
    WS_TRACE_API_WRITE_QUALIFIED_NAME                      = 46,
    WS_TRACE_API_WRITE_CHARS                               = 47,
    WS_TRACE_API_WRITE_CHARS_UTF8                          = 48,
    WS_TRACE_API_WRITE_BYTES                               = 49,
    WS_TRACE_API_PUSH_BYTES                                = 50,
    WS_TRACE_API_PULL_BYTES                                = 51,
    WS_TRACE_API_WRITE_END_ELEMENT                         = 52,
    WS_TRACE_API_WRITE_TEXT                                = 53,
    WS_TRACE_API_WRITE_START_CDATA                         = 54,
    WS_TRACE_API_WRITE_END_CDATA                           = 55,
    WS_TRACE_API_WRITE_NODE                                = 56,
    WS_TRACE_API_PREFIX_FROM_NAMESPACE                     = 57,
    WS_TRACE_API_GET_WRITER_POSITION                       = 58,
    WS_TRACE_API_SET_WRITER_POSITION                       = 59,
    WS_TRACE_API_MOVE_WRITER                               = 60,
    WS_TRACE_API_TRIM_XML_WHITESPACE                       = 61,
    WS_TRACE_API_VERIFY_XML_NCNAME                         = 62,
    WS_TRACE_API_XML_STRING_EQUALS                         = 63,
    WS_TRACE_API_NAMESPACE_FROM_PREFIX                     = 64,
    WS_TRACE_API_READ_QUALIFIED_NAME                       = 65,
    WS_TRACE_API_GET_XML_ATTRIBUTE                         = 66,
    WS_TRACE_API_COPY_NODE                                 = 67,
    WS_TRACE_API_ASYNC_EXECUTE                             = 68,
    WS_TRACE_API_CREATE_CHANNEL                            = 69,
    WS_TRACE_API_OPEN_CHANNEL                              = 70,
    WS_TRACE_API_SEND_MESSAGE                              = 71,
    WS_TRACE_API_RECEIVE_MESSAGE                           = 72,
    WS_TRACE_API_REQUEST_REPLY                             = 73,
    WS_TRACE_API_SEND_REPLY_MESSAGE                        = 74,
    WS_TRACE_API_SEND_FAULT_MESSAGE_FOR_ERROR              = 75,
    WS_TRACE_API_GET_CHANNEL_PROPERTY                      = 76,
    WS_TRACE_API_SET_CHANNEL_PROPERTY                      = 77,
    WS_TRACE_API_WRITE_MESSAGE_START                       = 78,
    WS_TRACE_API_WRITE_MESSAGE_END                         = 79,
    WS_TRACE_API_READ_MESSAGE_START                        = 80,
    WS_TRACE_API_READ_MESSAGE_END                          = 81,
    WS_TRACE_API_CLOSE_CHANNEL                             = 82,
    WS_TRACE_API_ABORT_CHANNEL                             = 83,
    WS_TRACE_API_FREE_CHANNEL                              = 84,
    WS_TRACE_API_RESET_CHANNEL                             = 85,
    WS_TRACE_API_ABANDON_MESSAGE                           = 86,
    WS_TRACE_API_SHUTDOWN_SESSION_CHANNEL                  = 87,
    WS_TRACE_API_GET_CONTEXT_PROPERTY                      = 88,
    WS_TRACE_API_GET_DICTIONARY                            = 89,
    WS_TRACE_API_READ_ENDPOINT_ADDRESS_EXTENSION           = 90,
    WS_TRACE_API_CREATE_ERROR                              = 91,
    WS_TRACE_API_ADD_ERROR_STRING                          = 92,
    WS_TRACE_API_GET_ERROR_STRING                          = 93,
    WS_TRACE_API_COPY_ERROR                                = 94,
    WS_TRACE_API_GET_ERROR_PROPERTY                        = 95,
    WS_TRACE_API_SET_ERROR_PROPERTY                        = 96,
    WS_TRACE_API_RESET_ERROR                               = 97,
    WS_TRACE_API_FREE_ERROR                                = 98,
    WS_TRACE_API_GET_FAULT_ERROR_PROPERTY                  = 99,
    WS_TRACE_API_SET_FAULT_ERROR_PROPERTY                  = 100,
    WS_TRACE_API_CREATE_FAULT_FROM_ERROR                   = 101,
    WS_TRACE_API_SET_FAULT_ERROR_DETAIL                    = 102,
    WS_TRACE_API_GET_FAULT_ERROR_DETAIL                    = 103,
    WS_TRACE_API_CREATE_HEAP                               = 104,
    WS_TRACE_API_ALLOC                                     = 105,
    WS_TRACE_API_GET_HEAP_PROPERTY                         = 106,
    WS_TRACE_API_RESET_HEAP                                = 107,
    WS_TRACE_API_FREE_HEAP                                 = 108,
    WS_TRACE_API_CREATE_LISTENER                           = 109,
    WS_TRACE_API_OPEN_LISTENER                             = 110,
    WS_TRACE_API_ACCEPT_CHANNEL                            = 111,
    WS_TRACE_API_CLOSE_LISTENER                            = 112,
    WS_TRACE_API_ABORT_LISTENER                            = 113,
    WS_TRACE_API_RESET_LISTENER                            = 114,
    WS_TRACE_API_FREE_LISTENER                             = 115,
    WS_TRACE_API_GET_LISTENER_PROPERTY                     = 116,
    WS_TRACE_API_SET_LISTENER_PROPERTY                     = 117,
    WS_TRACE_API_CREATE_CHANNEL_FOR_LISTENER               = 118,
    WS_TRACE_API_CREATE_MESSAGE                            = 119,
    WS_TRACE_API_CREATE_MESSAGE_FOR_CHANNEL                = 120,
    WS_TRACE_API_INITIALIZE_MESSAGE                        = 121,
    WS_TRACE_API_RESET_MESSAGE                             = 122,
    WS_TRACE_API_FREE_MESSAGE                              = 123,
    WS_TRACE_API_GET_HEADER_ATTRIBUTES                     = 124,
    WS_TRACE_API_GET_HEADER                                = 125,
    WS_TRACE_API_GET_CUSTOM_HEADER                         = 126,
    WS_TRACE_API_REMOVE_HEADER                             = 127,
    WS_TRACE_API_SET_HEADER                                = 128,
    WS_TRACE_API_REMOVE_CUSTOM_HEADER                      = 129,
    WS_TRACE_API_ADD_CUSTOM_HEADER                         = 130,
    WS_TRACE_API_ADD_MAPPED_HEADER                         = 131,
    WS_TRACE_API_REMOVE_MAPPED_HEADER                      = 132,
    WS_TRACE_API_GET_MAPPED_HEADER                         = 133,
    WS_TRACE_API_WRITE_BODY                                = 134,
    WS_TRACE_API_READ_BODY                                 = 135,
    WS_TRACE_API_WRITE_ENVELOPE_START                      = 136,
    WS_TRACE_API_WRITE_ENVELOPE_END                        = 137,
    WS_TRACE_API_READ_ENVELOPE_START                       = 138,
    WS_TRACE_API_READ_ENVELOPE_END                         = 139,
    WS_TRACE_API_GET_MESSAGE_PROPERTY                      = 140,
    WS_TRACE_API_SET_MESSAGE_PROPERTY                      = 141,
    WS_TRACE_API_ADDRESS_MESSAGE                           = 142,
    WS_TRACE_API_CHECK_MUST_UNDERSTAND_HEADERS             = 143,
    WS_TRACE_API_MARK_HEADER_AS_UNDERSTOOD                 = 144,
    WS_TRACE_API_FILL_BODY                                 = 145,
    WS_TRACE_API_FLUSH_BODY                                = 146,
    WS_TRACE_API_REQUEST_SECURITY_TOKEN                    = 147,
    WS_TRACE_API_GET_SECURITY_TOKEN_PROPERTY               = 148,
    WS_TRACE_API_CREATE_XML_SECURITY_TOKEN                 = 149,
    WS_TRACE_API_FREE_SECURITY_TOKEN                       = 150,
    WS_TRACE_API_REVOKE_SECURITY_CONTEXT                   = 151,
    WS_TRACE_API_GET_SECURITY_CONTEXT_PROPERTY             = 152,
    WS_TRACE_API_READ_ELEMENT_TYPE                         = 153,
    WS_TRACE_API_READ_ATTRIBUTE_TYPE                       = 154,
    WS_TRACE_API_READ_TYPE                                 = 155,
    WS_TRACE_API_WRITE_ELEMENT_TYPE                        = 156,
    WS_TRACE_API_WRITE_ATTRIBUTE_TYPE                      = 157,
    WS_TRACE_API_WRITE_TYPE                                = 158,
    WS_TRACE_API_SERVICE_REGISTER_FOR_CANCEL               = 159,
    WS_TRACE_API_GET_SERVICE_HOST_PROPERTY                 = 160,
    WS_TRACE_API_CREATE_SERVICE_HOST                       = 161,
    WS_TRACE_API_OPEN_SERVICE_HOST                         = 162,
    WS_TRACE_API_CLOSE_SERVICE_HOST                        = 163,
    WS_TRACE_API_ABORT_SERVICE_HOST                        = 164,
    WS_TRACE_API_FREE_SERVICE_HOST                         = 165,
    WS_TRACE_API_RESET_SERVICE_HOST                        = 166,
    WS_TRACE_API_GET_SERVICE_PROXY_PROPERTY                = 167,
    WS_TRACE_API_CREATE_SERVICE_PROXY                      = 168,
    WS_TRACE_API_OPEN_SERVICE_PROXY                        = 169,
    WS_TRACE_API_CLOSE_SERVICE_PROXY                       = 170,
    WS_TRACE_API_ABORT_SERVICE_PROXY                       = 171,
    WS_TRACE_API_FREE_SERVICE_PROXY                        = 172,
    WS_TRACE_API_RESET_SERVICE_PROXY                       = 173,
    WS_TRACE_API_ABORT_CALL                                = 174,
    WS_TRACE_API_CALL                                      = 175,
    WS_TRACE_API_DECODE_URL                                = 176,
    WS_TRACE_API_ENCODE_URL                                = 177,
    WS_TRACE_API_COMBINE_URL                               = 178,
    WS_TRACE_API_DATETIME_TO_FILETIME                      = 179,
    WS_TRACE_API_FILETIME_TO_DATETIME                      = 180,
    WS_TRACE_API_DUMP_MEMORY                               = 181,
    WS_TRACE_API_SET_AUTOFAIL                              = 182,
    WS_TRACE_API_CREATE_METADATA                           = 183,
    WS_TRACE_API_READ_METADATA                             = 184,
    WS_TRACE_API_FREE_METADATA                             = 185,
    WS_TRACE_API_RESET_METADATA                            = 186,
    WS_TRACE_API_GET_METADATA_PROPERTY                     = 187,
    WS_TRACE_API_GET_MISSING_METADATA_DOCUMENT_ADDRESS     = 188,
    WS_TRACE_API_GET_METADATA_ENDPOINTS                    = 189,
    WS_TRACE_API_MATCH_POLICY_ALTERNATIVE                  = 190,
    WS_TRACE_API_GET_POLICY_PROPERTY                       = 191,
    WS_TRACE_API_GET_POLICY_ALTERNATIVE_COUNT              = 192,
    WS_TRACE_API_WS_CREATE_SERVICE_PROXY_FROM_TEMPLATE     = 193,
    WS_TRACE_API_WS_CREATE_SERVICE_HOST_FROM_TEMPLATE      = 194,
} WS_TRACE_API;



//  Url enum
//  
//   The set of schemes used with WsDecodeUrl, WsEncodeUrl,
//  and WsCombineUrl.
//  
typedef enum
{
    WS_URL_HTTP_SCHEME_TYPE        = 0,
    WS_URL_HTTPS_SCHEME_TYPE       = 1,
    WS_URL_NETTCP_SCHEME_TYPE      = 2,
    WS_URL_SOAPUDP_SCHEME_TYPE     = 3,
} WS_URL_SCHEME_TYPE;



//  Url enum
//  
//   Flags that control behavior of WsDecodeUrl, WsEncodeUrl,
//  and WsCombineUrl.
//  
enum
{
    WS_URL_FLAGS_ALLOW_HOST_WILDCARDS     = 0x1,
    WS_URL_FLAGS_NO_PATH_COLLAPSE         = 0x2,
    WS_URL_FLAGS_ZERO_TERMINATE           = 0x4,
};



//  Utilities enum
//  
//   Specifies the textual format of a WS_DATETIME.
//  
typedef enum
{
    WS_DATETIME_FORMAT_UTC       = 0,
    WS_DATETIME_FORMAT_LOCAL     = 1,
    WS_DATETIME_FORMAT_NONE      = 2,
} WS_DATETIME_FORMAT;



//  Metadata Import enum
//  
//   The state of the metadata object.
//  
typedef enum
{
    WS_METADATA_STATE_CREATED      = 1,
    WS_METADATA_STATE_RESOLVED     = 2,
    WS_METADATA_STATE_FAULTED      = 3,
} WS_METADATA_STATE;



//  Metadata Import enum
//  
//   Each metadata property is identified by an ID and has an associated
//  value.  If a property is not specified when the metadata is created,
//  then its default value is used.
//  
typedef enum
{
    WS_METADATA_PROPERTY_STATE                   = 1,
    WS_METADATA_PROPERTY_HEAP_PROPERTIES         = 2,
    WS_METADATA_PROPERTY_POLICY_PROPERTIES       = 3,
    WS_METADATA_PROPERTY_HEAP_REQUESTED_SIZE     = 4,
    WS_METADATA_PROPERTY_MAX_DOCUMENTS           = 5,
    WS_METADATA_PROPERTY_HOST_NAMES              = 6,
    WS_METADATA_PROPERTY_VERIFY_HOST_NAMES       = 7,
} WS_METADATA_PROPERTY_ID;



//  Metadata Import enum
//  
//   The state of the policy object.
//  
typedef enum
{
    WS_POLICY_STATE_CREATED     = 1,
    WS_POLICY_STATE_FAULTED     = 2,
} WS_POLICY_STATE;



//  Metadata Import enum
//  
//   Each policy property is identified by an ID and has an associated
//  value.
//  
typedef enum
{
    WS_POLICY_PROPERTY_STATE                = 1,
    WS_POLICY_PROPERTY_MAX_ALTERNATIVES     = 2,
    WS_POLICY_PROPERTY_MAX_DEPTH            = 3,
    WS_POLICY_PROPERTY_MAX_EXTENSIONS       = 4,
} WS_POLICY_PROPERTY_ID;



//  Metadata Import enum
//  
//   The values in this enumeration are used to identify the sub-types of WS_SECURITY_BINDING_CONSTRAINT.
//  
typedef enum
{
    WS_SSL_TRANSPORT_SECURITY_BINDING_CONSTRAINT_TYPE                = 1,
    WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING_CONSTRAINT_TYPE           = 2,
    WS_HTTP_HEADER_AUTH_SECURITY_BINDING_CONSTRAINT_TYPE             = 3,
    WS_USERNAME_MESSAGE_SECURITY_BINDING_CONSTRAINT_TYPE             = 4,
    WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_CONSTRAINT_TYPE       = 5,
    WS_ISSUED_TOKEN_MESSAGE_SECURITY_BINDING_CONSTRAINT_TYPE         = 6,
    WS_CERT_MESSAGE_SECURITY_BINDING_CONSTRAINT_TYPE                 = 7,
    WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING_CONSTRAINT_TYPE     = 8,
} WS_SECURITY_BINDING_CONSTRAINT_TYPE;



//  Metadata Import enum
//  
//   The values in this enumeration are used to identify the sub-types of WS_POLICY_EXTENSION.
//  
typedef enum
{
    WS_ENDPOINT_POLICY_EXTENSION_TYPE     = 1,
} WS_POLICY_EXTENSION_TYPE;



//  Policy Support enum
//  
//   An enumeration of the different security binding combinations that
//  are supported in current product.
//  
typedef enum
{
    WS_HTTP_BINDING_TEMPLATE_TYPE                                         = 0,
    WS_HTTP_SSL_BINDING_TEMPLATE_TYPE                                     = 1,
    WS_HTTP_HEADER_AUTH_BINDING_TEMPLATE_TYPE                             = 2,
    WS_HTTP_SSL_HEADER_AUTH_BINDING_TEMPLATE_TYPE                         = 3,
    WS_HTTP_SSL_USERNAME_BINDING_TEMPLATE_TYPE                            = 4,
    WS_HTTP_SSL_KERBEROS_APREQ_BINDING_TEMPLATE_TYPE                      = 5,
    WS_TCP_BINDING_TEMPLATE_TYPE                                          = 6,
    WS_TCP_SSPI_BINDING_TEMPLATE_TYPE                                     = 7,
    WS_TCP_SSPI_USERNAME_BINDING_TEMPLATE_TYPE                            = 8,
    WS_TCP_SSPI_KERBEROS_APREQ_BINDING_TEMPLATE_TYPE                      = 9,
    WS_HTTP_SSL_USERNAME_SECURITY_CONTEXT_BINDING_TEMPLATE_TYPE           = 10,
    WS_HTTP_SSL_KERBEROS_APREQ_SECURITY_CONTEXT_BINDING_TEMPLATE_TYPE     = 11,
    WS_TCP_SSPI_USERNAME_SECURITY_CONTEXT_BINDING_TEMPLATE_TYPE           = 12,
    WS_TCP_SSPI_KERBEROS_APREQ_SECURITY_CONTEXT_BINDING_TEMPLATE_TYPE     = 13,
} WS_BINDING_TEMPLATE_TYPE;


struct _CERT_CONTEXT;

struct _SecPkgContext_IssuerListInfoEx;

struct _WS_FAULT_CODE;

//  CALLBACK DEFINITIONS

//  XML Reader callback
//  
//   A user-defined callback used by the WS_XML_READER
//   to read from some source into a buffer.
//  
typedef HRESULT (CALLBACK* WS_READ_CALLBACK)(
    __in void* callbackState, 
    __out_bcount_part(maxSize, *actualSize) void* bytes, 
    __in ULONG maxSize, 
    __out ULONG* actualSize, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  XML Writer callback
//  
//   A user-defined callback used by the WS_XML_WRITER
//   to write a buffer to some destination.
//  
typedef HRESULT (CALLBACK* WS_WRITE_CALLBACK)(
    __in void* callbackState, 
    __in_ecount(count) const WS_BYTES* buffers, 
    __in ULONG count, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  XML Writer callback
//  
//   A user-defined callback used by WsPushBytes to request that data be written.
//  
typedef HRESULT (CALLBACK* WS_PUSH_BYTES_CALLBACK)(
    __in void* callbackState, 
    __in WS_WRITE_CALLBACK writeCallback, 
    __in void* writeCallbackState, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  XML Writer callback
//  
//   A user-defined callback used by WsPullBytes to request
//  the data that should be written.
//  
typedef HRESULT (CALLBACK* WS_PULL_BYTES_CALLBACK)(
    __in void* callbackState, 
    __out_bcount_part(maxSize, *actualSize) void* bytes, 
    __in ULONG maxSize, 
    __out ULONG* actualSize, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  XML Writer callback
//  
//   A user-defined callback used in WS_XML_WRITER_BINARY_ENCODING
//   that determines whether the string can be written in an optimized form.
//  
typedef HRESULT (CALLBACK* WS_DYNAMIC_STRING_CALLBACK)(
    __in void* callbackState, 
    __in const WS_XML_STRING* string, 
    __out BOOL* found, 
    __out ULONG* id, 
    __in_opt WS_ERROR* error);


//  Async Model callback
//  
//   The type of a callback used in the Async Model.
//  
typedef void (CALLBACK* WS_ASYNC_CALLBACK)(
    __in HRESULT errorCode, 
    __in WS_CALLBACK_MODEL callbackModel, 
    __in void* callbackState);


//  Async Model callback
//  
//   Used with the WsAsyncExecute to specify the next
//  function to invoke in a series of async operations.
//  
typedef HRESULT (CALLBACK* WS_ASYNC_FUNCTION)(
    __in HRESULT hr, 
    __in WS_CALLBACK_MODEL callbackModel, 
    __in void* callbackState, 
    __inout WS_ASYNC_OPERATION* next, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles the WsCreateChannel call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_CREATE_CHANNEL_CALLBACK)(
    __in WS_CHANNEL_TYPE channelType, 
    __in_bcount(channelParametersSize) const void* channelParameters, 
    __in ULONG channelParametersSize, 
    __deref_out void** channelInstance, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles the WsFreeChannel call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef void (CALLBACK* WS_FREE_CHANNEL_CALLBACK)(__in void* channelInstance);


//  Channel callback
//  
//   This callback handles the WsResetChannel call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_RESET_CHANNEL_CALLBACK)(
    __in void* channelInstance, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles the WsAbortChannel call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_ABORT_CHANNEL_CALLBACK)(
    __in void* channelInstance, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles the WsOpenChannel call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_OPEN_CHANNEL_CALLBACK)(
    __in void* channelInstance, 
    __in const WS_ENDPOINT_ADDRESS* endpointAddress, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles the WsCloseChannel call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_CLOSE_CHANNEL_CALLBACK)(
    __in void* channelInstance, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles the WsSetChannelProperty call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_SET_CHANNEL_PROPERTY_CALLBACK)(
    __in void* channelInstance, 
    __in WS_CHANNEL_PROPERTY_ID id, 
    __in_bcount(valueSize) const void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles the WsGetChannelProperty call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_GET_CHANNEL_PROPERTY_CALLBACK)(
    __in void* channelInstance, 
    __in WS_CHANNEL_PROPERTY_ID id, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles the WsReadMessageStart call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_READ_MESSAGE_START_CALLBACK)(
    __in void* channelInstance, 
    __in WS_MESSAGE* message, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles the WsReadMessageEnd call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_READ_MESSAGE_END_CALLBACK)(
    __in void* channelInstance, 
    __in WS_MESSAGE* message, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles the WsWriteMessageStart call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_WRITE_MESSAGE_START_CALLBACK)(
    __in void* channelInstance, 
    __in WS_MESSAGE* message, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles the WsWriteMessageEnd call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_WRITE_MESSAGE_END_CALLBACK)(
    __in void* channelInstance, 
    __in WS_MESSAGE* message, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles the WsAbandonMessage call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_ABANDON_MESSAGE_CALLBACK)(
    __in void* channelInstance, 
    __in WS_MESSAGE* message, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles the WsShutdownSessionChannel call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_SHUTDOWN_SESSION_CHANNEL_CALLBACK)(
    __in void* channelInstance, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles creating an encoder instance.
//  
typedef HRESULT (CALLBACK* WS_CREATE_ENCODER_CALLBACK)(
    __in void* createContext, 
    __in WS_WRITE_CALLBACK writeCallback, 
    __in void* writeContext, 
    __deref_out void** encoderContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback is invoked to get the content type of the message.
//  
typedef HRESULT (CALLBACK* WS_ENCODER_GET_CONTENT_TYPE_CALLBACK)(
    __in void* encoderContext, 
    __in const WS_STRING* contentType, 
    __out WS_STRING* newContentType, 
    __out WS_STRING* contentEncoding, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback is invoked to start encoding a message.
//  
typedef HRESULT (CALLBACK* WS_ENCODER_START_CALLBACK)(
    __in void* encoderContext, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback is invoked to encode a message.
//  
typedef HRESULT (CALLBACK* WS_ENCODER_ENCODE_CALLBACK)(
    __in void* encoderContext, 
    __in_ecount(count) const WS_BYTES* buffers, 
    __in ULONG count, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback is invoked to encode the end of a message.
//  
typedef HRESULT (CALLBACK* WS_ENCODER_END_CALLBACK)(
    __in void* encoderContext, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles freeing an encoder instance.
//  
typedef void (CALLBACK* WS_FREE_ENCODER_CALLBACK)(__in void* encoderContext);


//  Channel callback
//  
//   This callback handles creating an decoder instance.
//  
typedef HRESULT (CALLBACK* WS_CREATE_DECODER_CALLBACK)(
    __in void* createContext, 
    __in WS_READ_CALLBACK readCallback, 
    __in void* readContext, 
    __deref_out void** decoderContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback is invoked to get the content type of the message.
//  
typedef HRESULT (CALLBACK* WS_DECODER_GET_CONTENT_TYPE_CALLBACK)(
    __in void* decoderContext, 
    __in const WS_STRING* contentType, 
    __in_opt const WS_STRING* contentEncoding, 
    __out WS_STRING* newContentType, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback is invoked to start decoding a message.
//  
typedef HRESULT (CALLBACK* WS_DECODER_START_CALLBACK)(
    __in void* encoderContext, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback is invoked to decode a message.
//  
typedef HRESULT (CALLBACK* WS_DECODER_DECODE_CALLBACK)(
    __in void* encoderContext, 
    __out_bcount_part(maxLength, *length) void* buffer, 
    __in ULONG maxLength, 
    __out ULONG* length, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback is invoked to decode the end of a message.
//  
typedef HRESULT (CALLBACK* WS_DECODER_END_CALLBACK)(
    __in void* encoderContext, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel callback
//  
//   This callback handles freeing an decoder instance.
//  
typedef void (CALLBACK* WS_FREE_DECODER_CALLBACK)(__in void* decoderContext);


//  Channel callback
//  
//   This callback is invoked when a message is about to be automatically
//  redirected to another service utilizing HTTP auto redirect functionality
//  as described in RFC2616. If the redirection should not be allowed, this
//  callback should return S_FALSE or an error value. Otherwise the auto
//  HTTP redirection will proceed.
//  
typedef HRESULT (CALLBACK* WS_HTTP_REDIRECT_CALLBACK)(
    __in void* state, 
    __in const WS_STRING* originalUrl, 
    __in const WS_STRING* newUrl);


//  Listener callback
//  
//   This callback handles the WsCreateListener call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_CREATE_LISTENER_CALLBACK)(
    __in WS_CHANNEL_TYPE channelType, 
    __in_bcount(listenerParametersSize) const void* listenerParameters, 
    __in ULONG listenerParametersSize, 
    __deref_out void** listenerInstance, 
    __in_opt WS_ERROR* error);


//  Listener callback
//  
//   This callback handles the WsFreeListener call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef void (CALLBACK* WS_FREE_LISTENER_CALLBACK)(__in void* listenerInstance);


//  Listener callback
//  
//   This callback handles the WsResetListener call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_RESET_LISTENER_CALLBACK)(
    __in void* listenerInstance, 
    __in_opt WS_ERROR* error);


//  Listener callback
//  
//   This callback handles the WsOpenListener call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_OPEN_LISTENER_CALLBACK)(
    __in void* listenerInstance, 
    __in const WS_STRING* url, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Listener callback
//  
//   This callback handles the WsCloseListener call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_CLOSE_LISTENER_CALLBACK)(
    __in void* listenerInstance, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Listener callback
//  
//   This callback handles the WsGetListenerProperty call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_GET_LISTENER_PROPERTY_CALLBACK)(
    __in void* listenerInstance, 
    __in WS_LISTENER_PROPERTY_ID id, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Listener callback
//  
//   This callback handles the WsSetListenerProperty call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_SET_LISTENER_PROPERTY_CALLBACK)(
    __in void* listenerInstance, 
    __in WS_LISTENER_PROPERTY_ID id, 
    __in_bcount(valueSize) const void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Listener callback
//  
//   This callback handles the WsAcceptChannel call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_ACCEPT_CHANNEL_CALLBACK)(
    __in void* listenerInstance, 
    __in void* channelInstance, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Listener callback
//  
//   This callback handles the WsAbortListener call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_ABORT_LISTENER_CALLBACK)(
    __in void* listenerInstance, 
    __in_opt WS_ERROR* error);


//  Listener callback
//  
//   This callback handles the WsCreateChannelForListener call
//  for a WS_CUSTOM_CHANNEL_BINDING.
//  
typedef HRESULT (CALLBACK* WS_CREATE_CHANNEL_FOR_LISTENER_CALLBACK)(
    __in void* listenerInstance, 
    __in_bcount(channelParametersSize) const void* channelParameters, 
    __in ULONG channelParametersSize, 
    __deref_out void** channelInstance, 
    __in_opt WS_ERROR* error);


//  Message callback
//  
//   This callback is used as a notification that the message is done using
//  the WS_XML_READER supplied to WsReadEnvelopeStart
//   or the WS_XML_WRITER supplied to WsWriteEnvelopeStart.
//  
typedef void (CALLBACK* WS_MESSAGE_DONE_CALLBACK)(__in void* doneCallbackState);


//  Security Credentials callback
//  
//  Callback for providing a certificate to the security runtime.  This
//  callback is specified as part of the WS_CUSTOM_CERT_CREDENTIAL,
//  which in turn may be specified as part of a security binding that requires a
//  certificate credential. The runtime will invoke this callback when the channel
//  (client-side) or the listener (server-side) is opened.
//  
//  Cert ownership: If this callback returns a success HRESULT, the caller
//  (namely, the security runtime) will take ownership of the returned
//  certificate, and will free it when the containing channel no longer
//  needs it.  If this callback returns a failure HRESULT, the caller will
//  NOT take ownership of, or even look at, the value returned in the out
//  parameter 'cert'.
//  
typedef HRESULT (CALLBACK* WS_GET_CERT_CALLBACK)(
    __in void* getCertCallbackState, 
    __in_opt const WS_ENDPOINT_ADDRESS* targetAddress, 
    __in_opt const WS_STRING* viaUri, 
    __deref_out const struct _CERT_CONTEXT** cert, 
    __in_opt WS_ERROR* error);


//  Security Credentials callback
//  
//  The callback to notify the client of the list of certificate issuers
//  that are acceptable to the server.  With some protocols such as SSL,
//  the server may optionally send such an issuer list to help the client
//  choose a certificate.
//  
//  This callback is an optional part of the WS_CUSTOM_CERT_CREDENTIAL.
//  If the (possibly NULL) certificate returned by the WS_GET_CERT_CALLBACK is
//  accepted by the server, then this callback is never invoked.  If the
//  server rejects it and sends back an issuer list, then this callback
//  will be invoked.  The client may then choose a certificate based on
//  the issuer list and supply that certificate when the channel is opened
//  next and WS_GET_CERT_CALLBACK is invoked again.
//  
//  The parameters supplied during this callback are valid only for the
//  duration of the callback.
//  
typedef HRESULT (CALLBACK* WS_CERT_ISSUER_LIST_NOTIFICATION_CALLBACK)(
    __in void* certIssuerListNotificationCallbackState, 
    __in const struct _SecPkgContext_IssuerListInfoEx* issuerList, 
    __in_opt WS_ERROR* error);


//  Security Credentials callback
//  
//  Application supplied callback for validating a username/password pair
//  on the receiver side.  When a WS_USERNAME_MESSAGE_SECURITY_BINDING
//  containing this callback is included in the security description, this callback
//  is invoked for each received message at the server.  This callback is expected
//  to return S_OKif the username/password pair was successfully validated, S_FALSE
//  when the pair could not be validated and an error value if an unexpected error occurred.
//  Returning any result other than S_OK from this callback will result in
//  the associated receive message failing with a security error.
//  
//  As with all security callbacks, the application should expect to
//  receive this callback any time between channel/listener open and close,
//  but it will never be invoked when a channel is not open.  In the
//  current drop, this callback is always invoked synchronously.  In the
//  next drop, this callback will be invoked synchronously for synchronous
//  message receives and asynchronously for asynchronous message receives,
//  but it will always be invoked (WS_SHORT_CALLBACK) short
//  when it is invoked asynchronously.
//  
typedef HRESULT (CALLBACK* WS_VALIDATE_PASSWORD_CALLBACK)(
    __in_opt void* passwordValidatorCallbackState, 
    __in const WS_STRING* username, 
    __in const WS_STRING* password, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Security Bindings callback
//  
//  Application supplied callback for validating a SAML assertion.  If a
//  received SAML assertion passes the signature verification checks that
//  ensure the SAML was issued by a trusted issuer, then this callback is
//  invoked to enable the application to do additional validation on the
//  XML form of the SAML assertion.  This callback is expected to return
//  S_OK if the SAML assertion was successfully validated, S_FALSE when
//  the assertion could not be validated and an error value if an
//  unexpected error occurred.  Returning any result other than S_OK from
//  this callback will result in the associated receive message failing
//  with a security error.
//  
//  As with all security callbacks, the application should expect to
//  receive this callback any time between listener open and close, but it
//  will never be invoked when a listener is not open.
//  
typedef HRESULT (CALLBACK* WS_VALIDATE_SAML_CALLBACK)(
    __in_opt void* samlValidatorCallbackState, 
    __in WS_XML_BUFFER* samlAssertion, 
    __in_opt WS_ERROR* error);


//  Serialization callback
//  
//   This callback is invoked to compare two durations.
//  
typedef HRESULT (CALLBACK* WS_DURATION_COMPARISON_CALLBACK)(
    __in const WS_DURATION* duration1, 
    __in const WS_DURATION* duration2, 
    __out int* result, 
    __in_opt WS_ERROR* error);


//  Serialization callback
//  
//   This callback is invoked to read an value when WS_CUSTOM_TYPE
//   has been specified.  This allows reading of XML constructs which do not easily
//  map to the core serialization model.
//  
typedef HRESULT (CALLBACK* WS_READ_TYPE_CALLBACK)(
    __in WS_XML_READER* reader, 
    __in WS_TYPE_MAPPING typeMapping, 
    __in const void* descriptionData, 
    __in_opt WS_HEAP* heap, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Serialization callback
//  
//   This callback is invoked to write an element when WS_CUSTOM_TYPE
//   has been specified.  This allows writing of XML constructs which do not easily
//  map to the core serialization model.
//  
typedef HRESULT (CALLBACK* WS_WRITE_TYPE_CALLBACK)(
    __in WS_XML_WRITER* writer, 
    __in WS_TYPE_MAPPING typeMapping, 
    __in const void* descriptionData, 
    __in_bcount(valueSize) const void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Serialization callback
//  
//   This callback is invoked before a value that is handled
//  by a WS_CUSTOM_TYPE is serialized in order to
//  determine if the value is the default value.  Support
//  for default values is enabled by specifying
//  when WS_FIELD_OPTIONAL in the WS_FIELD_DESCRIPTION.
//  
typedef HRESULT (CALLBACK* WS_IS_DEFAULT_VALUE_CALLBACK)(
    __in const void* descriptionData, 
    __in_bcount(valueSize) const void* value, 
    __in_bcount_opt(valueSize) const void* defaultValue, 
    __in ULONG valueSize, 
    __out BOOL* isDefault, 
    __in_opt WS_ERROR* error);


//  Contract callback
//  
//   It is invoked when a WS_MESSAGE is received on an endpoint configured
//  with a WS_SERVICE_CONTRACT which has defaultMessageHandlerCallback set.
//  
//   The incoming WS_MESSAGE, the serviceProxy along with other parameters
//  is made available to the callback through WS_OPERATION_CONTEXT.
//  
typedef HRESULT (CALLBACK* WS_SERVICE_MESSAGE_RECEIVE_CALLBACK)(
    __in const WS_OPERATION_CONTEXT* context, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Call cancellation callback
//  
//   This callback is invoked by service model to notify a cancellation of an
//  async service operation call as a result of an aborted shutdown of service host.
//  
typedef void (CALLBACK* WS_OPERATION_CANCEL_CALLBACK)(
    __in const WS_SERVICE_CANCEL_REASON reason, 
    __in void* state);


//  Call cancellation callback
//  
//   This callback is invoked by service model to allow application to cleanup
//  state that was registered with cancellation callback.
//  
typedef void (CALLBACK* WS_OPERATION_FREE_STATE_CALLBACK)(__in void* state);


//  Contract callback
//  
//   This callback is invoked by service model to delegate to the service
//  operation call. This callback is generated by (Web Service Compiler Tool) wsutil.exe
//   for every service operation. It is defined on the WS_OPERATION_DESCRIPTION for each
//  service operation.
//  
typedef HRESULT (CALLBACK* WS_SERVICE_STUB_CALLBACK)(
    __in const WS_OPERATION_CONTEXT* context, 
    __in void* frame, 
    __in const void* callback, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Service Host callback
//  
//   This callback is invoked when a channel is accepted on an endpoint
//  listener by service host.
//  
//   For (Contract) session based service contract, this notification signifies session initiation.
//  Thus an application state scoped for the session can be created within this callback.
//  
typedef HRESULT (CALLBACK* WS_SERVICE_ACCEPT_CHANNEL_CALLBACK)(
    __in const WS_OPERATION_CONTEXT* context, 
    __deref_out void** channelState, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Service Host callback
//  
//   This callback is invoked when a channel is closed/or aborted on an endpoint.
//  This callback is called right before we are about to close the channel.
//  
//   For normal operation when service host is running and the client cleanly
//  closed the channel, this implies that we have received a session closure
//  from the client and we are about to close the channel.
//  
//   The other scenario is when service host is going through an Abort Shutdown
//  or during the processing of the message an unrecoverable error condition is
//  met, as a result of this we attempt to abort and then close the channel.
//  In this case as well right before the abort we will call upon this callback.
//  
//   For (Contract) session based service contract, this notification
//  signifies session tear down. Thus an application state scoped for the session
//  can be destroyed within this callback.
//  
typedef HRESULT (CALLBACK* WS_SERVICE_CLOSE_CHANNEL_CALLBACK)(
    __in const WS_OPERATION_CONTEXT* context, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext);


//  Service Authorization callback
//  
//   This callback is invoked when headers of the incoming message
//  are received and the body is not processed.
//  
typedef HRESULT (CALLBACK* WS_SERVICE_SECURITY_CALLBACK)(
    __in const WS_OPERATION_CONTEXT* context, 
    __out BOOL* authorized, 
    __in_opt WS_ERROR* error);


//  Service Proxy callback
//  
//   The callback is invoked when the headers of the input message are
//  about to be sent through, or when an output message headers are just received.
//  
typedef HRESULT (CALLBACK* WS_PROXY_MESSAGE_CALLBACK)(
    __in WS_MESSAGE* message, 
    __in WS_HEAP* heap, 
    __in void* state, 
    __in_opt WS_ERROR* error);


//  STRUCT DEFINITIONS

//  XML Node structure
//  
//   Represents a set of unique strings.  This information is used by the binary
//  encoding to write a more compact xml document.
//  
struct _WS_XML_DICTIONARY {
    GUID guid;
    WS_XML_STRING* strings;
    ULONG stringCount;
    BOOL isConst;
};


//  XML Node structure
//  
//   Represents a string that optionally has (WS_XML_DICTIONARY) dictionary
//   information associated with it.  The xml APIs use WS_XML_STRINGs to identify prefixes,
//  localNames and namespaces.
//  
struct _WS_XML_STRING {
    ULONG length;
    BYTE* bytes;
    WS_XML_DICTIONARY* dictionary;
    ULONG id;
};


//  XML Node structure
//  
//   A structure used to specify an XML name (of an element or an attribute) as
//  a local name, namespace pair.
//  
struct _WS_XML_QNAME {
    WS_XML_STRING localName;
    WS_XML_STRING ns;
};


//  XML Buffer structure
//  
//   Represents a position within an XML Buffer.  The current position within
//  a reader or writer may be obtained by calling WsGetReaderPosition or
//   WsGetWriterPosition.  The current position within a reader or writer
//  may be set by calling WsSetReaderPosition or WsSetWriterPosition.
//  
//   Using WsRemoveNode to remove a node that corresponds to or contains a
//  position will cause subsequent use of the position to fail.  The position itself
//  remains valid, but operations that depend on that position will fail.
//  
//   Positions may be used as long as the containing XML buffer is valid.  Using a position
//  after its corresponding buffer has been deleted will exhibit undefined behavior.
//  
struct _WS_XML_NODE_POSITION {
    WS_XML_BUFFER* buffer;
    void* node;
};


//  XML Reader structure
//  
//   Specifies a reader specific setting.
//  
struct _WS_XML_READER_PROPERTY {
    WS_XML_READER_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  XML Canonicalization structure
//  
//   An array of XML prefixes that should be treated as
//  inclusive prefixes during exclusive XML canonicalization.  The
//  treatment of inclusive prefixes is defined in
//   (http://tools.ietf.org/html/rfc3741) RFC 3741.
//  
struct _WS_XML_CANONICALIZATION_INCLUSIVE_PREFIXES {
    ULONG prefixCount;
    WS_XML_STRING* prefixes;
};


//  XML Canonicalization structure
//  
//   Specifies a setting that controls how XML canonicalization is done.
//  
struct _WS_XML_CANONICALIZATION_PROPERTY {
    WS_XML_CANONICALIZATION_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  XML Writer structure
//  
//   Specifies a writer specific setting.
//  
struct _WS_XML_WRITER_PROPERTY {
    WS_XML_WRITER_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  XML Buffer structure
//  
//   Specifies an xml buffer specific setting.
//  
struct _WS_XML_BUFFER_PROPERTY {
    WS_XML_BUFFER_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  XML Node structure
//  
//   Represents a node of text content in xml.
//  
struct _WS_XML_TEXT {
    WS_XML_TEXT_TYPE textType;
};


//  XML Node structure
//  
//   Represents text encoded as UTF-8 bytes.
//  
struct _WS_XML_UTF8_TEXT {
    WS_XML_TEXT text;
    WS_XML_STRING value;
};


//  XML Node structure
//  
//   Represents text encoded as UTF-16 bytes.
//  
struct _WS_XML_UTF16_TEXT {
    WS_XML_TEXT text;
    BYTE* bytes;
    ULONG byteCount;
};


//  XML Node structure
//  
//   Represents base64 encoded data. (e.g. The three bytes { 0, 0, 0 } represent the text "AAAA".)
//  
struct _WS_XML_BASE64_TEXT {
    WS_XML_TEXT text;
    BYTE* bytes;
    ULONG length;
};


//  XML Node structure
//  
//   A boolean that represents the text "true" or "false".
//  
struct _WS_XML_BOOL_TEXT {
    WS_XML_TEXT text;
    BOOL value;
};


//  XML Node structure
//  
//   Represents a signed 32 bit integer.  (e.g. The value 255 represents the text "255")
//  
struct _WS_XML_INT32_TEXT {
    WS_XML_TEXT text;
    __int32 value;
};


//  XML Node structure
//  
//   Represents a signed 64 bit integer.  (e.g. The value 255 represents the text "255")
//  
struct _WS_XML_INT64_TEXT {
    WS_XML_TEXT text;
    __int64 value;
};


//  XML Node structure
//  
//   Represents an unsigned 64 bit integer.  (e.g. The value 255 represents the text "255")
//  
struct _WS_XML_UINT64_TEXT {
    WS_XML_TEXT text;
    unsigned __int64 value;
};


//  XML Node structure
//  
//   Represents a 4 byte floating point value.  (e.g. The value 0.0 represents the text "0")
//  
struct _WS_XML_FLOAT_TEXT {
    WS_XML_TEXT text;
    float value;
};


//  XML Node structure
//  
//   Represents an 8 byte floating point value.  (e.g. The value 0.0 represents the text "0")
//  
struct _WS_XML_DOUBLE_TEXT {
    WS_XML_TEXT text;
    double value;
};


//  XML Node structure
//  
//   Represents a 12 byte fixed point value.  (e.g. The value 1.23 represents the text "1.23")
//  
struct _WS_XML_DECIMAL_TEXT {
    WS_XML_TEXT text;
    DECIMAL value;
};


//  XML Node structure
//  
//   Represents a guid formatted as the text "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx".
//  
struct _WS_XML_GUID_TEXT {
    WS_XML_TEXT text;
    GUID value;
};


//  XML Node structure
//  
//   Represents a guid formatted as the text "urn:uuid:xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx".
//  
struct _WS_XML_UNIQUE_ID_TEXT {
    WS_XML_TEXT text;
    GUID value;
};


//  Utilities structure
//  
//   This structure is used to represent dates and times.
//  
//   Represents dates and times with values ranging from 12:00:00 midnight,
//  January 1, 0001 Anno Domini (Common Era) through 11:59:59 P.M.,
//  December 31, 9999 A.D. (C.E.) to an accuracy of 100 nanoseconds.
//  
//   The functions WsDateTimeToFileTime and WsFileTimeToDateTime
//   can be used to convert a WS_DATETIME to and from a FILETIME.
//  
struct _WS_DATETIME {
    unsigned __int64 ticks;
    WS_DATETIME_FORMAT format;
};


//  XML Node structure
//  
//   Represents a datetime formatted as an
//   (http://www.w3.org/TR/xmlschema-2/#dateTime) xsd:dateTime.
//  
//   Negative datetime values are not supported.
//  
struct _WS_XML_DATETIME_TEXT {
    WS_XML_TEXT text;
    WS_DATETIME value;
};


//  Utilities structure
//  
//   Represents a signed 64-bit time interval in 100 nanosecond units.
//  
struct _WS_TIMESPAN {
    __int64 ticks;
};


//  XML Node structure
//  
//   Represents a time span formatted as the text "[+|-][d?.]HH:mm:ss[.fffffff]"
//  
//  .d is a series of digits representing the day.
//  
//  .HH is a two digit number representing the hour of the day, from to 0 to 23.
//  
//  .mm is a two digit number representing the minute of the hour, from to 0 to 59.
//  
//  .ss is a two digit number representing the second of the minute, from to 0 to 59.
//  
//  .fffffff is up to 7 decimal digits representing the fraction of a second.
//  
struct _WS_XML_TIMESPAN_TEXT {
    WS_XML_TEXT text;
    WS_TIMESPAN value;
};


//  XML Node structure
//  
//   Represents a qname formatted as the text "prefix:localName"
//  
struct _WS_XML_QNAME_TEXT {
    WS_XML_TEXT text;
    WS_XML_STRING* prefix;
    WS_XML_STRING* localName;
    WS_XML_STRING* ns;
};


//  XML Node structure
//  
//   Represents a list of text values separated by a single whitespace character.
//  
//   (e.g. The list { { WS_XML_TEXT_TYPE_INT32 }, 123},
//  { { WS_XML_TEXT_TYPE_BOOL }, 1 } represents the text "123 true")
//  
struct _WS_XML_LIST_TEXT {
    WS_XML_TEXT text;
    ULONG itemCount;
    WS_XML_TEXT** items;
};


//  XML Node structure
//  
//   An xml node is unit of data in xml.  This structure is the base type
//  for all the different kinds of nodes.
//  
struct _WS_XML_NODE {
    WS_XML_NODE_TYPE nodeType;
};


//  XML Node structure
//  
//   Represents an attribute (e.g. <a:purchaseOrder xmlns:a="http://tempuri.org" id="5">)
//  
struct _WS_XML_ATTRIBUTE {
    BYTE singleQuote;
    BYTE isXmlNs;
    WS_XML_STRING* prefix;
    WS_XML_STRING* localName;
    WS_XML_STRING* ns;
    WS_XML_TEXT* value;
};


//  XML Node structure
//  
//   Represents a start element in xml (e.g.
//  "<a:purchaseOrder xmlns:a="http://tempuri.org" id="5">")
//  
struct _WS_XML_ELEMENT_NODE {
    WS_XML_NODE node;
    WS_XML_STRING* prefix;
    WS_XML_STRING* localName;
    WS_XML_STRING* ns;
    ULONG attributeCount;
    WS_XML_ATTRIBUTE** attributes;
    BOOL isEmpty;
};


//  XML Node structure
//  
//   Represents an element, attribute, or CDATA content.
//  
struct _WS_XML_TEXT_NODE {
    WS_XML_NODE node;
    WS_XML_TEXT* text;
};


//  XML Node structure
//  
//   Represents a comment.  (e.g. "<!--The message follows-->")
//  
struct _WS_XML_COMMENT_NODE {
    WS_XML_NODE node;
    WS_XML_STRING value;
};


//  XML Reader structure
//  
//   Specifies where the reader should obtain the bytes that comprise the xml document.
//  
struct _WS_XML_READER_INPUT {
    WS_XML_READER_INPUT_TYPE inputType;
};


//  XML Reader structure
//  
//   Specifies that the source of the xml input is a buffer.
//  
struct _WS_XML_READER_BUFFER_INPUT {
    WS_XML_READER_INPUT input;
    void* encodedData;
    ULONG encodedDataSize;
};


//  XML Reader structure
//  
//   Specifies that the source of the xml should be obtained from a callback.
//  
struct _WS_XML_READER_STREAM_INPUT {
    WS_XML_READER_INPUT input;
    WS_READ_CALLBACK readCallback;
    void* readCallbackState;
};


//  XML Reader structure
//  
//   This structure is the base type for all the different kinds of reader encodings.
//  
struct _WS_XML_READER_ENCODING {
    WS_XML_READER_ENCODING_TYPE encodingType;
};


//  XML Reader structure
//  
//   Used to indicate that the reader should interpret the bytes it reads as textual xml.
//  
struct _WS_XML_READER_TEXT_ENCODING {
    WS_XML_READER_ENCODING encoding;
    WS_CHARSET charSet;
};


//  XML Reader structure
//  
//   Used to indicate that the reader should interpret the bytes it reads as binary xml.
//  
struct _WS_XML_READER_BINARY_ENCODING {
    WS_XML_READER_ENCODING encoding;
    WS_XML_DICTIONARY* staticDictionary;
    WS_XML_DICTIONARY* dynamicDictionary;
};


//  Utilities structure
//  
//   An array of unicode characters and a length.
//  
struct _WS_STRING {
    ULONG length;
    WCHAR* chars;
};


//  XML Reader structure
//  
//   Used to indicate that the reader should interpret the bytes it reads as in MTOM format.
//  
struct _WS_XML_READER_MTOM_ENCODING {
    WS_XML_READER_ENCODING encoding;
    WS_XML_READER_ENCODING* textEncoding;
    BOOL readMimeHeader;
    WS_STRING startInfo;
    WS_STRING boundary;
    WS_STRING startUri;
};


//  XML Reader structure
//  
//   Used to indicate that the reader should surface the bytes of the document as base64 encoded characters.
//  
struct _WS_XML_READER_RAW_ENCODING {
    WS_XML_READER_ENCODING encoding;
};


//  XML Writer structure
//  
//   This structure is the base type for all the different kinds of writer encodings.
//  
struct _WS_XML_WRITER_ENCODING {
    WS_XML_WRITER_ENCODING_TYPE encodingType;
};


//  XML Writer structure
//  
//   Used to indicate that the reader should emit bytes as textual xml.
//  
struct _WS_XML_WRITER_TEXT_ENCODING {
    WS_XML_WRITER_ENCODING encoding;
    WS_CHARSET charSet;
};


//  XML Writer structure
//  
//   Used to indicate that the writer should emit bytes as binary xml.
//  
struct _WS_XML_WRITER_BINARY_ENCODING {
    WS_XML_WRITER_ENCODING encoding;
    WS_XML_DICTIONARY* staticDictionary;
    WS_DYNAMIC_STRING_CALLBACK dynamicStringCallback;
    void* dynamicStringCallbackState;
};


//  XML Writer structure
//  
//   Used to indicate that the reader should emit bytes in MTOM format.
//  The MTOM format will represent bytes written to it as binary mime
//  parts rather than embedded base64 encoded text.
//  
struct _WS_XML_WRITER_MTOM_ENCODING {
    WS_XML_WRITER_ENCODING encoding;
    WS_XML_WRITER_ENCODING* textEncoding;
    BOOL writeMimeHeader;
    WS_STRING boundary;
    WS_STRING startInfo;
    WS_STRING startUri;
    ULONG maxInlineByteCount;
};


//  XML Writer structure
//  
//   Used to indicate that the writer should emit bytes from decoded base64 characters.
//  
struct _WS_XML_WRITER_RAW_ENCODING {
    WS_XML_WRITER_ENCODING encoding;
};


//  XML Writer structure
//  
//   Specifies where the writer should emit the bytes that comprise the xml document.
//  
struct _WS_XML_WRITER_OUTPUT {
    WS_XML_WRITER_OUTPUT_TYPE outputType;
};


//  XML Writer structure
//  
//   Specifies that the generated bytes should be placed in a buffer.
//  
struct _WS_XML_WRITER_BUFFER_OUTPUT {
    WS_XML_WRITER_OUTPUT output;
};


//  XML Writer structure
//  
//   Specifies that the generated bytes should be sent to callback.
//  
struct _WS_XML_WRITER_STREAM_OUTPUT {
    WS_XML_WRITER_OUTPUT output;
    WS_WRITE_CALLBACK writeCallback;
    void* writeCallbackState;
};


//  XML Writer structure
//  
//   A structure that is used to specify a set of WS_XML_WRITER_PROPERTYs.
//  
struct _WS_XML_WRITER_PROPERTIES {
    WS_XML_WRITER_PROPERTY* properties;
    ULONG propertyCount;
};


//  XML Reader structure
//  
//   A structure that is used to specify a set of WS_XML_READER_PROPERTYs.
//  
struct _WS_XML_READER_PROPERTIES {
    WS_XML_READER_PROPERTY* properties;
    ULONG propertyCount;
};


//  Async Model structure
//  
//   Used with the Async Model to specify the async callback and
//  a pointer which will be passed to the async callback.
//  
struct _WS_ASYNC_CONTEXT {
    WS_ASYNC_CALLBACK callback;
    void* callbackState;
};


//  Async Model structure
//  
//   Used by WsAsyncExecute to manage the state of an asynchronous operation.
//  
struct _WS_ASYNC_STATE {
    void* internal0;
    void* internal1;
    void* internal2;
    void* internal3;
    void* internal4;
};


//  Async Model structure
//  
//   Used with the WsAsyncExecute to specify the next function
//  to invoke in a series of async operations.
//  
struct _WS_ASYNC_OPERATION {
    WS_ASYNC_FUNCTION function;
};


//  Channel structure
//  
//   Specifies a channel specific setting.
//  
struct _WS_CHANNEL_PROPERTY {
    WS_CHANNEL_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Channel structure
//  
//   A structure that is used to specify the custom proxy for the channel, using
//  the WS_CHANNEL_PROPERTY_CUSTOM_HTTP_PROXY.
//  
struct _WS_CUSTOM_HTTP_PROXY {
    WS_STRING servers;
    WS_STRING bypass;
};


//  Channel structure
//  
//   A structure that is used to specify a set of WS_CHANNEL_PROPERTYs.
//  
struct _WS_CHANNEL_PROPERTIES {
    WS_CHANNEL_PROPERTY* properties;
    ULONG propertyCount;
};


//  Channel structure
//  
//   A structure that is used to specify a set of callbacks
//  that form the implementation of a custom channel.
//  
struct _WS_CUSTOM_CHANNEL_CALLBACKS {
    WS_CREATE_CHANNEL_CALLBACK createChannelCallback;
    WS_FREE_CHANNEL_CALLBACK freeChannelCallback;
    WS_RESET_CHANNEL_CALLBACK resetChannelCallback;
    WS_OPEN_CHANNEL_CALLBACK openChannelCallback;
    WS_CLOSE_CHANNEL_CALLBACK closeChannelCallback;
    WS_ABORT_CHANNEL_CALLBACK abortChannelCallback;
    WS_GET_CHANNEL_PROPERTY_CALLBACK getChannelPropertyCallback;
    WS_SET_CHANNEL_PROPERTY_CALLBACK setChannelPropertyCallback;
    WS_WRITE_MESSAGE_START_CALLBACK writeMessageStartCallback;
    WS_WRITE_MESSAGE_END_CALLBACK writeMessageEndCallback;
    WS_READ_MESSAGE_START_CALLBACK readMessageStartCallback;
    WS_READ_MESSAGE_END_CALLBACK readMessageEndCallback;
    WS_ABANDON_MESSAGE_CALLBACK abandonMessageCallback;
    WS_SHUTDOWN_SESSION_CHANNEL_CALLBACK shutdownSessionChannelCallback;
};


//  Channel structure
//  
//   Specifies an individual header that is mapped as part of WS_HTTP_MESSAGE_MAPPING.
//  
struct _WS_HTTP_HEADER_MAPPING {
    WS_XML_STRING headerName;
    ULONG headerMappingOptions;
};


//  Channel structure
//  
//   Specifies information about how an HTTP request or response should be
//  represented in a message object.
//  
struct _WS_HTTP_MESSAGE_MAPPING {
    ULONG requestMappingOptions;
    ULONG responseMappingOptions;
    WS_HTTP_HEADER_MAPPING** requestHeaderMappings;
    ULONG requestHeaderMappingCount;
    WS_HTTP_HEADER_MAPPING** responseHeaderMappings;
    ULONG responseHeaderMappingCount;
};


//  Serialization structure
//  
//   Represents a mapping between a C data type and an XML element.
//  
struct _WS_ELEMENT_DESCRIPTION {
    WS_XML_STRING* elementLocalName;
    WS_XML_STRING* elementNs;
    WS_TYPE type;
    void* typeDescription;
};


//  Channel structure
//  
//   The description of the format of a message.
//  
struct _WS_MESSAGE_DESCRIPTION {
    WS_XML_STRING* action;
    WS_ELEMENT_DESCRIPTION* bodyElementDescription;
};


//  Channel structure
//  
//   A structure that is used to specify a set of callbacks
//  that can transform the content type and encoded bytes of a sent message.
//  
struct _WS_CHANNEL_ENCODER {
    void* createContext;
    WS_CREATE_ENCODER_CALLBACK createEncoderCallback;
    WS_ENCODER_GET_CONTENT_TYPE_CALLBACK encoderGetContentTypeCallback;
    WS_ENCODER_START_CALLBACK encoderStartCallback;
    WS_ENCODER_ENCODE_CALLBACK encoderEncodeCallback;
    WS_ENCODER_END_CALLBACK encoderEndCallback;
    WS_FREE_ENCODER_CALLBACK freeEncoderCallback;
};


//  Channel structure
//  
//   A structure that is used to specify a set of callbacks
//  that can transform the content type and encoded bytes of a received message.
//  
struct _WS_CHANNEL_DECODER {
    void* createContext;
    WS_CREATE_DECODER_CALLBACK createDecoderCallback;
    WS_DECODER_GET_CONTENT_TYPE_CALLBACK decoderGetContentTypeCallback;
    WS_DECODER_START_CALLBACK decoderStartCallback;
    WS_DECODER_DECODE_CALLBACK decoderDecodeCallback;
    WS_DECODER_END_CALLBACK decoderEndCallback;
    WS_FREE_DECODER_CALLBACK freeDecoderCallback;
};


//  Channel structure
//  
//   Specifies the callback function and state for controlling the HTTP auto redirection behavior.
//  
//   See also, WS_HTTP_REDIRECT_CALLBACK_CONTEXT
//   and WS_CHANNEL_PROPERTY_HTTP_REDIRECT_CALLBACK_CONTEXT.
//  
struct _WS_HTTP_REDIRECT_CALLBACK_CONTEXT {
    WS_HTTP_REDIRECT_CALLBACK callback;
    void* state;
};


//  Endpoint Identity structure
//  
//   The base type for all endpoint identities.
//  
struct _WS_ENDPOINT_IDENTITY {
    WS_ENDPOINT_IDENTITY_TYPE identityType;
};


//  Endpoint Address structure
//  
//   Represents the network address of an endpoint.
//  
struct _WS_ENDPOINT_ADDRESS {
    WS_STRING url;
    WS_XML_BUFFER* headers;
    WS_XML_BUFFER* extensions;
    WS_ENDPOINT_IDENTITY* identity;
};


//  Endpoint Identity structure
//  
//   Type for specifying an endpoint identity represented by a DNS name.
//  
struct _WS_DNS_ENDPOINT_IDENTITY {
    WS_ENDPOINT_IDENTITY identity;
    WS_STRING dns;
};


//  Endpoint Identity structure
//  
//  
//   Type for specifying an endpoint identity represented by a UPN (user principal name).
//  
//  
struct _WS_UPN_ENDPOINT_IDENTITY {
    WS_ENDPOINT_IDENTITY identity;
    WS_STRING upn;
};


//  Endpoint Identity structure
//  
//   Type for specifying an endpoint identity represented by an SPN (service principal name).
//  
struct _WS_SPN_ENDPOINT_IDENTITY {
    WS_ENDPOINT_IDENTITY identity;
    WS_STRING spn;
};


//  Utilities structure
//  A structure used to serialize and deserialize an array of bytes.
struct _WS_BYTES {
    ULONG length;
    BYTE* bytes;
};


//  Endpoint Identity structure
//  
//   Type for RSA endpoint identity.
//  
struct _WS_RSA_ENDPOINT_IDENTITY {
    WS_ENDPOINT_IDENTITY identity;
    WS_BYTES modulus;
    WS_BYTES exponent;
};


//  Endpoint Identity structure
//  
//   Type for certificate endpoint identity
//  
struct _WS_CERT_ENDPOINT_IDENTITY {
    WS_ENDPOINT_IDENTITY identity;
    WS_BYTES rawCertificateData;
};


//  Endpoint Identity structure
//  
//   Type for unknown endpoint identity.  This type is only used to represent
//  an endpoint identity type that was deserialized but was not understood.
//  
struct _WS_UNKNOWN_ENDPOINT_IDENTITY {
    WS_ENDPOINT_IDENTITY identity;
    WS_XML_BUFFER* element;
};


//  Errors structure
//  
//   Specifies an error specific setting.
//  
struct _WS_ERROR_PROPERTY {
    WS_ERROR_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Faults structure
//  
//   A fault reason is a human-readable description of the failure conveyed
//  by the fault.  This structure is used within the WS_FAULT structure.
//  For more information about faults, see Faults.
//  
struct _WS_FAULT_REASON {
    WS_STRING text;
    WS_STRING lang;
};


//  Faults structure
//  
//   A fault code identifies the type of failure conveyed by a fault message.
//  This structure is used within the WS_FAULT structure.
//  For more information about faults, see Faults.
//  
struct _WS_FAULT_CODE {
    WS_XML_QNAME value;
    struct _WS_FAULT_CODE* subCode;
};


//  Faults structure
//  
//   A Fault is a value carried in the body of a message which conveys a
//  processing failure.  Faults are modeled using the WS_FAULT structure.
//  See Faults for more information.
//  
struct _WS_FAULT {
    WS_FAULT_CODE* code;
    WS_FAULT_REASON* reasons;
    ULONG reasonCount;
    WS_STRING actor;
    WS_STRING node;
    WS_XML_BUFFER* detail;
};


//  Faults structure
//  
//   A description of the detail element of a fault message.
//  
struct _WS_FAULT_DETAIL_DESCRIPTION {
    WS_XML_STRING* action;
    WS_ELEMENT_DESCRIPTION* detailElementDescription;
};


//  Heap structure
//  
//   Specifies a heap specific setting.
//  
struct _WS_HEAP_PROPERTY {
    WS_HEAP_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Heap structure
//  
//   A structure that is used to specify a set of WS_HEAP_PROPERTYs.
//  
struct _WS_HEAP_PROPERTIES {
    WS_HEAP_PROPERTY* properties;
    ULONG propertyCount;
};


//  Listener structure
//  
//   Specifies a listener specific setting.
//  
struct _WS_LISTENER_PROPERTY {
    WS_LISTENER_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Listener structure
//  
//   Specifies the list of blocked UserAgent sub-string's. This is
//  used with the WS_LISTENER_PROPERTY_DISALLOWED_USER_AGENT
//   listener property.
//  
struct _WS_DISALLOWED_USER_AGENT_SUBSTRINGS {
    ULONG subStringCount;
    WS_STRING** subStrings;
};


//  Listener structure
//  
//   A structure that is used to specify a set of WS_LISTENER_PROPERTYs.
//  
struct _WS_LISTENER_PROPERTIES {
    WS_LISTENER_PROPERTY* properties;
    ULONG propertyCount;
};


//  Listener structure
//  
//   A structure containing a list of host names.
//  
struct _WS_HOST_NAMES {
    WS_STRING* hostNames;
    ULONG hostNameCount;
};


//  Listener structure
//  
//   A structure that is used to specify a set of callbacks
//  that form the implementation of a custom
//  listener.
//  
struct _WS_CUSTOM_LISTENER_CALLBACKS {
    WS_CREATE_LISTENER_CALLBACK createListenerCallback;
    WS_FREE_LISTENER_CALLBACK freeListenerCallback;
    WS_RESET_LISTENER_CALLBACK resetListenerCallback;
    WS_OPEN_LISTENER_CALLBACK openListenerCallback;
    WS_CLOSE_LISTENER_CALLBACK closeListenerCallback;
    WS_ABORT_LISTENER_CALLBACK abortListenerCallback;
    WS_GET_LISTENER_PROPERTY_CALLBACK getListenerPropertyCallback;
    WS_SET_LISTENER_PROPERTY_CALLBACK setListenerPropertyCallback;
    WS_CREATE_CHANNEL_FOR_LISTENER_CALLBACK createChannelForListenerCallback;
    WS_ACCEPT_CHANNEL_CALLBACK acceptChannelCallback;
};


//  Message structure
//  
//   Specifies a message specific setting.
//  
struct _WS_MESSAGE_PROPERTY {
    WS_MESSAGE_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Message structure
//  
//   A structure that is used to specify a set of WS_MESSAGE_PROPERTYs.
//  
struct _WS_MESSAGE_PROPERTIES {
    WS_MESSAGE_PROPERTY* properties;
    ULONG propertyCount;
};


//  Security Channel Settings structure
//  
//   Specifies a crypto algorithm setting.
//  
struct _WS_SECURITY_ALGORITHM_PROPERTY {
    WS_SECURITY_ALGORITHM_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Security Channel Settings structure
//  
//  Defines the security algorithms and key lengths to be used with
//  WS-Security.  This setting is relevant to message security bindings
//  and mixed-mode security bindings.
//  
struct _WS_SECURITY_ALGORITHM_SUITE {
    WS_SECURITY_ALGORITHM_ID canonicalizationAlgorithm;
    WS_SECURITY_ALGORITHM_ID digestAlgorithm;
    WS_SECURITY_ALGORITHM_ID symmetricSignatureAlgorithm;
    WS_SECURITY_ALGORITHM_ID asymmetricSignatureAlgorithm;
    WS_SECURITY_ALGORITHM_ID encryptionAlgorithm;
    WS_SECURITY_ALGORITHM_ID keyDerivationAlgorithm;
    WS_SECURITY_ALGORITHM_ID symmetricKeyWrapAlgorithm;
    WS_SECURITY_ALGORITHM_ID asymmetricKeyWrapAlgorithm;
    ULONG minSymmetricKeyLength;
    ULONG maxSymmetricKeyLength;
    ULONG minAsymmetricKeyLength;
    ULONG maxAsymmetricKeyLength;
    WS_SECURITY_ALGORITHM_PROPERTY* properties;
    ULONG propertyCount;
};


//  Security Channel Settings structure
//  
//   Specifies a channel-wide security setting.
//  
struct _WS_SECURITY_PROPERTY {
    WS_SECURITY_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Security Channel Settings structure
//  
//   Specifies an array of channel-wide security settings.
//  
struct _WS_SECURITY_PROPERTIES {
    WS_SECURITY_PROPERTY* properties;
    ULONG propertyCount;
};


//  Security Binding Settings structure
//  
//   Specifies a security binding specific setting.
//  
struct _WS_SECURITY_BINDING_PROPERTY {
    WS_SECURITY_BINDING_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Security Channel Settings structure
//  
//   Specifies an array of security binding settings.
//  
struct _WS_SECURITY_BINDING_PROPERTIES {
    WS_SECURITY_BINDING_PROPERTY* properties;
    ULONG propertyCount;
};


//  Extended Protection structure
//  
//   A list of Server Principal Names (SPNs) that are used to validate Extended Protection.
//  
//   Only available on the server.
//  
struct _WS_SERVICE_SECURITY_IDENTITIES {
    WS_STRING* serviceIdentities;
    ULONG serviceIdentityCount;
};


//  Security Credentials structure
//  
//  The abstract base type for all certificate credential types.
//  
struct _WS_CERT_CREDENTIAL {
    WS_CERT_CREDENTIAL_TYPE credentialType;
};


//  Security Credentials structure
//  
//  The type for specifying a certificate credential using the
//  certificate's subject name, store location and store name.  The
//  specified credential is loaded when the containing channel or listener
//  is opened.
//  
struct _WS_SUBJECT_NAME_CERT_CREDENTIAL {
    WS_CERT_CREDENTIAL credential;
    ULONG storeLocation;
    WS_STRING storeName;
    WS_STRING subjectName;
};


//  Security Credentials structure
//  
//  The type for specifying a certificate credential using the
//  certificate's thumbprint, store location and store name.  The
//  specified credential is loaded when the containing channel or listener
//  is opened.
//  
//  The thumbprint is the best option for specifying a certificate when
//  subject name based specification is expected to be ambiguous due to
//  the presence of multiple certificates with matching subject names in
//  the cert store being specified.
//  
struct _WS_THUMBPRINT_CERT_CREDENTIAL {
    WS_CERT_CREDENTIAL credential;
    ULONG storeLocation;
    WS_STRING storeName;
    WS_STRING thumbprint;
};


//  Security Credentials structure
//  
//  The type for specifying a certificate credential that is to be
//  supplied by a callback to the application.  This callback is invoked
//  to get the certificate during WsOpenChannel on the client
//  side and during WsOpenListener on the server side.  It is
//  always invoked (WS_SHORT_CALLBACK) short.
//  
struct _WS_CUSTOM_CERT_CREDENTIAL {
    WS_CERT_CREDENTIAL credential;
    WS_GET_CERT_CALLBACK getCertCallback;
    void* getCertCallbackState;
    WS_CERT_ISSUER_LIST_NOTIFICATION_CALLBACK certIssuerListNotificationCallback;
    void* certIssuerListNotificationCallbackState;
};


//  Security Credentials structure
//  
//  The abstract base type for all credential types used with Windows
//  Integrated Authentication.
//  
struct _WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL {
    WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL_TYPE credentialType;
};


//  Security Credentials structure
//  
//  Type for supplying a Windows credential as username, password, domain strings.
//  
struct _WS_STRING_WINDOWS_INTEGRATED_AUTH_CREDENTIAL {
    WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL credential;
    WS_STRING username;
    WS_STRING password;
    WS_STRING domain;
};


//  Security Credentials structure
//  
//   Type for supplying a Windows Integrated Authentication credential based on the current Windows identity.
//  If this credential subtype is used for a security binding, the current thread token on the thread that calls
//   WsOpenChannel or WsOpenServiceProxy is used as the Windows
//  identity when sending messages or making service calls. WsAcceptChannel and WsOpenServiceHost do not support this credential type when called
//  from an impersonating thread.
//  
struct _WS_DEFAULT_WINDOWS_INTEGRATED_AUTH_CREDENTIAL {
    WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL credential;
};


//  Security Credentials structure
//  
//  Type for supplying a Windows Integrated Authentication credential as an opaque handle created by
//  SspiPromptForCredentials and the related family of APIs.  This feature
//  is available only on Windows 7 and later.
//  
struct _WS_OPAQUE_WINDOWS_INTEGRATED_AUTH_CREDENTIAL {
    WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL credential;
    void* opaqueAuthIdentity;
};


//  Security Credentials structure
//  
//  The abstract base type for all username/password credentials.
//  
//  Note that WS_USERNAME_CREDENTIAL and its concrete subtypes
//  are used with the WS-Security WS_USERNAME_MESSAGE_SECURITY_BINDING.
//  They are best suitable for application-level username/password pairs, such as
//  those used for online customer accounts.  The usernames and passwords specified
//  are not interpreted by the security runtime, and are merely carried
//  client-to-server for authentication by the specified server-side
//  username/password validator specified by the application.
//  
//  In contrast, the WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL and
//  its concrete subtypes are used for Windows Integrated Authentication
//  and the security bindings that use it.
//  
struct _WS_USERNAME_CREDENTIAL {
    WS_USERNAME_CREDENTIAL_TYPE credentialType;
};


//  Security Credentials structure
//  
//  The type for supplying a username/password pair as strings.
//  
struct _WS_STRING_USERNAME_CREDENTIAL {
    WS_USERNAME_CREDENTIAL credential;
    WS_STRING username;
    WS_STRING password;
};


//  Security Bindings structure
//  
//  The abstract base type for all types that specify a cryptographic key.
//  Such a key is typically specified for a generic XML security token or
//  a custom security token.
//  
struct _WS_SECURITY_KEY_HANDLE {
    WS_SECURITY_KEY_HANDLE_TYPE keyHandleType;
};


//  Security Bindings structure
//  
//  The type for specifying a symmetric cryptographic key as raw bytes.
//  
struct _WS_RAW_SYMMETRIC_SECURITY_KEY_HANDLE {
    WS_SECURITY_KEY_HANDLE keyHandle;
    WS_BYTES rawKeyBytes;
};


//  Security Bindings structure
//  
//  The type for specifying asymmetric cryptographic keys as a CryptoNG
//  NCRYPT_KEY_HANDLE.
//  
//  When this structure is used in an API (such as with
//   (WsCreateXmlSecurityToken) XML token creation) and subsequent
//   (WS_XML_TOKEN_MESSAGE_SECURITY_BINDING) use of that XML
//  token for a channel), the application is responsible for making
//  sure that the NCRYPT_KEY_HANDLE remains valid as long as the key is in
//  use.  The application is also responsible for freeing the handle when
//  it is no longer in use.
//  
//  This type is supported only on Windows Vista and later platforms.
//  
struct _WS_NCRYPT_ASYMMETRIC_SECURITY_KEY_HANDLE {
    WS_SECURITY_KEY_HANDLE keyHandle;
    NCRYPT_KEY_HANDLE asymmetricKey;
};


//  Security Bindings structure
//  
//  The type for specifying asymmetric cryptographic keys as CAPI 1.0 key
//  handles.
//  
//  When this structure is used in an API (such as
//  with (WsCreateXmlSecurityToken) XML token creation and subsequent
//   (WS_XML_TOKEN_MESSAGE_SECURITY_BINDING) use of that XML
//  token for a channel), the application is responsible for making
//  sure that the HCRYPTPROV remains valid as long as the key is in
//  use.  The application is also responsible for freeing the handle when
//  it is no longer in use.
//  
//  This type is supported only on pre-Windows Vista platforms: for
//  Windows Vista and later, please use WS_NCRYPT_ASYMMETRIC_SECURITY_KEY_HANDLE.
//  
struct _WS_CAPI_ASYMMETRIC_SECURITY_KEY_HANDLE {
    WS_SECURITY_KEY_HANDLE keyHandle;
    HCRYPTPROV provider;
    ULONG keySpec;
};


//  Security Bindings structure
//  
//  The abstract base type for all security bindings.  One or more
//  concrete subtypes of this are specified in the
//   (WS_SECURITY_DESCRIPTION) security description that is
//  supplied during channel and listener creation.  Each concrete subtype
//  of this corresponds to a security protocol and a way of using it to
//  provide authentication and/or protection to a channel.
//  
//  Each security binding subtype instance in the security description
//  contributes one security token at runtime.  Thus, the fields of this
//  type can be viewed as specifying a security token, how to obtain it,
//  how to use it for channel security, and how to modify its behavior
//  using the optional settings.
//  
struct _WS_SECURITY_BINDING {
    WS_SECURITY_BINDING_TYPE bindingType;
    WS_SECURITY_BINDING_PROPERTY* properties;
    ULONG propertyCount;
};


//  Security Bindings structure
//  
//   The security binding subtype for specifying the use of SSL/TLS
//  protocol based transport security.
//  
//   This security binding is supported only with the
//   WS_HTTP_CHANNEL_BINDING.
//  
//   With this security binding, the following security binding property may be specified:
//  
//  . WS_SECURITY_BINDING_PROPERTY_CERT_FAILURES_TO_IGNORE (client side only)
//  
//  . WS_SECURITY_BINDING_PROPERTY_DISABLE_CERT_REVOCATION_CHECK (client side only)
//  
//  . WS_SECURITY_BINDING_PROPERTY_REQUIRE_SSL_CLIENT_CERT (server side only)
//  
//  
struct _WS_SSL_TRANSPORT_SECURITY_BINDING {
    WS_SECURITY_BINDING binding;
    WS_CERT_CREDENTIAL* localCertCredential;
};


//  Security Bindings structure
//  
//  The security binding subtype for specifying the use of the Windows
//  Integrated Authentication protocol (such as Kerberos, NTLM or SPNEGO)
//  with the TCP transport.  A specific SSP package may be chosen using
//  the security binding property
//   WS_SECURITY_BINDING_PROPERTY_WINDOWS_INTEGRATED_AUTH_PACKAGE;
//  if that property is not specified, SPNEGO is used by default.  The use
//  of NTLM is strongly discouraged due to its security weakness
//  (specifically, lack of server authentication).  If NTLM is to be
//  allowed, the security binding property WS_SECURITY_BINDING_PROPERTY_REQUIRE_SERVER_AUTH
//  must be set to FALSE.
//  
//  This security binding operates at the transport security level and is
//  supported only with the WS_TCP_CHANNEL_BINDING.  The
//  TCP/Windows SSPI combination uses the wire form defined by the
//   (http://msdn.microsoft.com/en-us/library/cc219293.aspx) NegotiateStream
//  protocol and the (http://msdn.microsoft.com/en-us/library/cc236723.aspx) .Net Message Framing specification.
//  
//  On the client side, the security identity of the target server is
//  specified using the identity field of the WS_ENDPOINT_ADDRESS
//  parameter supplied during WsOpenChannel.  If the identity is a
//   WS_SPN_ENDPOINT_IDENTITY or a WS_UPN_ENDPOINT_IDENTITY,
//  that string identity value is used directly with the SSP.  If the identity is a
//   WS_DNS_ENDPOINT_IDENTITY and the value of its dns field is
//  'd1', or if no identity is specified in the WS_ENDPOINT_ADDRESS
//  and the host component (according to Section 3.2.2 of
//   (http://tools.ietf.org/html/rfc2396) RFC2396) the address URI
//  is 'd1', then the form 'host/d1' is used as the server SPN.
//  Specifying any other WS_ENDPOINT_IDENTITY subtype in
//   WS_ENDPOINT_ADDRESS will cause WsOpenChannel to fail.
//  
//  With this security binding, the following security binding properties may be specified:
//  
//  . WS_SECURITY_BINDING_PROPERTY_WINDOWS_INTEGRATED_AUTH_PACKAGE
//  . WS_SECURITY_BINDING_PROPERTY_REQUIRE_SERVER_AUTH (client side only)
//  
//  . WS_SECURITY_BINDING_PROPERTY_ALLOW_ANONYMOUS_CLIENTS (server side only)
//  
//  . WS_SECURITY_BINDING_PROPERTY_ALLOWED_IMPERSONATION_LEVEL (client side only)
//  
struct _WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING {
    WS_SECURITY_BINDING binding;
    WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL* clientCredential;
};


//  Security Bindings structure
//  
//   The security binding subtype for specifying the use of HTTP header authentication against a target service or a HTTP proxy server
//  based on the basic, digest ( (http://tools.ietf.org/html/rfc2617) RFC 2617) and the SPNEGO ( (http://tools.ietf.org/html/rfc4559) RFC4559) protocols.
//  Since this security binding operates at the HTTP header level, it is supported only with the WS_HTTP_CHANNEL_BINDING.
//  By default, this security binding is used for the target service. However WS_SECURITY_BINDING_PROPERTY_HTTP_HEADER_AUTH_TARGET
//   security binding property can be specified to use it for a HTTP proxy server. This binding provides client authentication, but not message protection
//  since the HTTP body is unaffected by this binding. While this security binding can be used alone, such usage is not recommended;
//  more typically, HTTP header authentication is done in conjunction with transport level security provided by a security binding such as the
//   WS_SSL_TRANSPORT_SECURITY_BINDING. To use this binding without SSL, the the security description property
//   WS_SECURITY_PROPERTY_TRANSPORT_PROTECTION_LEVEL must be explicitly set to WS_PROTECTION_LEVEL_NONE or WS_PROTECTION_LEVEL_SIGN.
//  
//  With this security binding, the following security binding properties may be specified:
//  
//  . WS_SECURITY_BINDING_PROPERTY_HTTP_HEADER_AUTH_SCHEME
//  . WS_SECURITY_BINDING_PROPERTY_HTTP_HEADER_AUTH_TARGET (client side only)
//  
//  . WS_SECURITY_BINDING_PROPERTY_HTTP_HEADER_AUTH_BASIC_REALM (server side only)
//  
//  . WS_SECURITY_BINDING_PROPERTY_HTTP_HEADER_AUTH_DIGEST_REALM (server side only)
//  
//  . WS_SECURITY_BINDING_PROPERTY_HTTP_HEADER_AUTH_DIGEST_DOMAIN (server side only)
//  
struct _WS_HTTP_HEADER_AUTH_SECURITY_BINDING {
    WS_SECURITY_BINDING binding;
    WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL* clientCredential;
};


//  Security Bindings structure
//  
//   The security binding subtype for specifying the use of the Kerberos
//  AP_REQ ticket as a direct (i.e., without establishing a session)
//  security token with WS-Security.
//  
//   Only one instance of this binding may be present in a (WS_SECURITY_DESCRIPTION) security description.
//  
//   With this security binding, the following security binding properties may be specified:
//  
//  . WS_SECURITY_BINDING_PROPERTY_ALLOWED_IMPERSONATION_LEVEL (client side only)
//  
//  . WS_SECURITY_BINDING_PROPERTY_ALLOW_ANONYMOUS_CLIENTS (server side only)
//  
//   Client side on Vista and above, using this binding with HTTP will result in the message being sent using chunked transfer.
//  
struct _WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING {
    WS_SECURITY_BINDING binding;
    WS_MESSAGE_SECURITY_USAGE bindingUsage;
    WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL* clientCredential;
};


//  Security Bindings structure
//  
//   The security binding subtype for specifying the use of an application
//  supplied username / password pair as a direct (i.e., one-shot)
//  security token.  This security binding may be used only with message
//  security.  It provides client authentication, but not traffic signing
//  or encryption.  So, it is used in conjunction with another transport
//  security or message security binding that provides message protection.
//  
//   Only one instance of this binding may be present in a (WS_SECURITY_DESCRIPTION) security description.
//  
//   With this security binding, no security binding properties may be specified.
//  
struct _WS_USERNAME_MESSAGE_SECURITY_BINDING {
    WS_SECURITY_BINDING binding;
    WS_MESSAGE_SECURITY_USAGE bindingUsage;
    WS_USERNAME_CREDENTIAL* clientCredential;
    WS_VALIDATE_PASSWORD_CALLBACK passwordValidator;
    void* passwordValidatorCallbackState;
};


//  Security Description structure
//  
//  
//  The top-level structure used to specify the security requirements for
//  a (WsCreateChannel) channel (on the client side) or a (WsCreateListener) listener (on the server side).
//  
//  
struct _WS_SECURITY_DESCRIPTION {
    WS_SECURITY_BINDING** securityBindings;
    ULONG securityBindingCount;
    WS_SECURITY_PROPERTY* properties;
    ULONG propertyCount;
};


//  Security Bindings structure
//  
//   The security binding subtype for specifying the use of a security context
//  token negotiated between the client and server using
//  WS-SecureConversation. This security binding may be used only with
//  message security. It is used to establish a message-level security
//  context. Another set of one or more security bindings, specified in the
//  bootstrapSecurityDescription field, is used to the bootstrap the context.
//  
//   Only one instance of this binding may be present in a (WS_SECURITY_DESCRIPTION) security description.
//  
//   When this binding is used, the channel must complete the receive of at least one
//  message before it can be used to send messages.
//  
//   With this security binding, the following security binding properties may be specified:
//  
//  . WS_SECURITY_BINDING_PROPERTY_SECURITY_CONTEXT_KEY_SIZE
//  . WS_SECURITY_BINDING_PROPERTY_SECURITY_CONTEXT_KEY_ENTROPY_MODE
//  . WS_SECURITY_BINDING_PROPERTY_MESSAGE_PROPERTIES
//  . WS_SECURITY_BINDING_PROPERTY_SECURE_CONVERSATION_VERSION
//  . WS_SECURITY_BINDING_PROPERTY_SECURITY_CONTEXT_SUPPORT_RENEW
//  . WS_SECURITY_BINDING_PROPERTY_SECURITY_CONTEXT_RENEWAL_INTERVAL
//  . WS_SECURITY_BINDING_PROPERTY_SECURITY_CONTEXT_ROLLOVER_INTERVAL
struct _WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING {
    WS_SECURITY_BINDING binding;
    WS_MESSAGE_SECURITY_USAGE bindingUsage;
    WS_SECURITY_DESCRIPTION* bootstrapSecurityDescription;
};


//  Security Context structure
//  
//   Defines a property of a WS_SECURITY_CONTEXT
struct _WS_SECURITY_CONTEXT_PROPERTY {
    WS_SECURITY_CONTEXT_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Security Channel Settings structure
//  
//   Specifies a property for an XML security token.
//  
struct _WS_XML_SECURITY_TOKEN_PROPERTY {
    WS_XML_SECURITY_TOKEN_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Security Bindings structure
//  
//  The security binding subtype for specifying the use of a security
//  token that is already available to the application in XML form.  The
//  security token that is supplied by the application in this binding is
//  presented to a service in a WS-Security header according to the
//  bindingUsage specified.  This security binding may be included in a
//   (WS_SECURITY_DESCRIPTION) security description only on the
//  client side.
//  
//  Although this binding can be used with any token available in XML
//  form, this is commonly used in (Federation) federation
//  scenarios.  For example, a client side token provider such as
//  CardSpace may be used to get a token from a security token service,
//  and that token may then be presented to a Web Service using this
//  security binding.
//  
//  Security note: As with other security tokens and credentials, the
//  application is in charge of the risk assessment decision to disclose a
//  given XML token (supplied by the application in a
//   (WS_SECURITY_DESCRIPTION) security description) to a given
//  server (supplied by the application when
//   (WsOpenChannel) opening the channel).  In particular, the
//  application should consider the threat that the server might use the
//  XML token it receives from the client, in turn, to pretend to be the
//  client to a 3rd party.  For this threat, the following mitigations
//  exist: (A) the server authentication process makes sure that the
//  message (and hence the token) is sent only to a server that can speak
//  for the address specified by the client application; (B) keyless
//  (bearer) tokens are typically usable only at one server (e.g.,
//  contoso.com gains little from passing on a contoso.com
//  username/password token to another site -- the application security
//  design should make sure this property holds); (C) symmetric keyed
//  tokens are unusable at any server that doesn't share the same
//  symmetric key; (D) asymmetric keyed tokens will sign the timestamp and
//  the 'To' header, limiting their applicability to the intended 'To' for
//  a narrow time duration.
//  
//  With this security binding, no security binding properties may be specified:
//  
struct _WS_XML_TOKEN_MESSAGE_SECURITY_BINDING {
    WS_SECURITY_BINDING binding;
    WS_MESSAGE_SECURITY_USAGE bindingUsage;
    WS_SECURITY_TOKEN* xmlToken;
};


//  Security Bindings structure
//  
//  The abstract base type for all SAML authenticators used on the server
//  side to validate incoming SAML tokens.
//  
struct _WS_SAML_AUTHENTICATOR {
    WS_SAML_AUTHENTICATOR_TYPE authenticatorType;
};


//  Security Bindings structure
//  
//  The type for specifying a SAML token authenticator based on an array
//  of expected issuer certificates.  When an authenticator of this type
//  is used, an incoming SAML token will be accepted if only if it has a
//  valid XML signature created with any one of the specified X.509
//  certificates.  Thus, the specified X.509 certificates represent a
//  'allow list' of trusted SAML issuers.
//  
//  No revocation or chain trust checks are done by the runtime on the
//  specified certificates: so, it is up to the application to make sure
//  that the certificates are valid before they are specified in this
//  structure.
//  
//  As indicated above, the validation of the received SAML is limited to
//  making sure that it was signed correctly by one of the specified
//  certificates.  The application may then extract the SAML assertion
//  using WsGetMessageProperty with the key
//   WS_MESSAGE_PROPERTY_SAML_ASSERTION and do
//  additional validator or processing.
//  
struct _WS_CERT_SIGNED_SAML_AUTHENTICATOR {
    WS_SAML_AUTHENTICATOR authenticator;
    const struct _CERT_CONTEXT** trustedIssuerCerts;
    ULONG trustedIssuerCertCount;
    const struct _CERT_CONTEXT* decryptionCert;
    WS_VALIDATE_SAML_CALLBACK samlValidator;
    void* samlValidatorCallbackState;
};


//  Security Bindings structure
//  
//   The security binding subtype for specifying the use of a SAML
//  assertion as a message security token.  The SAML token is expected to
//  be presented to a service in a WS-Security header according to the
//  bindingUsage specified.  This security binding may be included in a
//   (WS_SECURITY_DESCRIPTION) security description only on the
//  server side.
//  
//   Only one instance of this binding may be present in a (WS_SECURITY_DESCRIPTION) security description.
//  
//   For a (Federation) federated security scenario that
//  involves getting a security token from an issuer and then presenting
//  it to a service, one may use WsRequestSecurityToken
//   together with the WS_XML_TOKEN_MESSAGE_SECURITY_BINDING on
//  the client side, and this binding on the server side.
//  
//   The extent of validation performed on the received SAML depends on the
//  authenticator specified.  If additional validation is required, the
//  application may get the received SAML assertion using
//   WsGetMessageProperty with the key WS_MESSAGE_PROPERTY_SAML_ASSERTION
//   and do further processing.
//  
//   With this security binding, no security binding properties may be specified:
//  
struct _WS_SAML_MESSAGE_SECURITY_BINDING {
    WS_SECURITY_BINDING binding;
    WS_MESSAGE_SECURITY_USAGE bindingUsage;
    WS_SAML_AUTHENTICATOR* authenticator;
};


//  Security Channel Settings structure
//  
//   Specifies a property for requesting a security token from an issuer.
//  
struct _WS_REQUEST_SECURITY_TOKEN_PROPERTY {
    WS_REQUEST_SECURITY_TOKEN_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Serialization structure
//  
//   This type is used to store an attribute
//  that has not been directly mapped to a field.
//  
struct _WS_ANY_ATTRIBUTE {
    WS_XML_STRING localName;
    WS_XML_STRING ns;
    WS_XML_TEXT* value;
};


//  Serialization structure
//  
//   This type is used to store a set of attributes
//  that have not been directly mapped to field of
//  a structure.
//  
struct _WS_ANY_ATTRIBUTES {
    WS_ANY_ATTRIBUTE* attributes;
    ULONG attributeCount;
};


//  Serialization structure
//  
//   This type description is used with WS_BOOL_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_BOOL_DESCRIPTION {
    BOOL value;
};


//  Serialization structure
//  
//   This type description is used with WS_GUID_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_GUID_DESCRIPTION {
    GUID value;
};


//  Serialization structure
//  
//   This type description is used with WS_DATETIME_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
//   Only the ticks field of the WS_DATETIME is compared.
//  
struct _WS_DATETIME_DESCRIPTION {
    WS_DATETIME minValue;
    WS_DATETIME maxValue;
};


//  Utilities structure
//  
//   Represents a (http://www.w3.org/TR/xmlschema-2/#duration) xsd:duration.
//  
struct _WS_DURATION {
    BOOL negative;
    ULONG years;
    ULONG months;
    ULONG days;
    ULONG hours;
    ULONG minutes;
    ULONG seconds;
    ULONG milliseconds;
    ULONG ticks;
};


//  Serialization structure
//  
//   This type description is used with WS_DURATION_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_DURATION_DESCRIPTION {
    WS_DURATION minValue;
    WS_DURATION maxValue;
    WS_DURATION_COMPARISON_CALLBACK comparer;
};


//  Serialization structure
//  
//   This type description is used with WS_TIMESPAN_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_TIMESPAN_DESCRIPTION {
    WS_TIMESPAN minValue;
    WS_TIMESPAN maxValue;
};


//  Serialization structure
//  
//   This type description is used with WS_UNIQUE_ID_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_UNIQUE_ID_DESCRIPTION {
    ULONG minCharCount;
    ULONG maxCharCount;
};


//  Serialization structure
//  
//   This type description is used with WS_STRING_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_STRING_DESCRIPTION {
    ULONG minCharCount;
    ULONG maxCharCount;
};


//  Serialization structure
//  
//   This type description is used with WS_XML_STRING_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_XML_STRING_DESCRIPTION {
    ULONG minByteCount;
    ULONG maxByteCount;
};


//  Serialization structure
//  
//   This type description is used with WS_XML_QNAME_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_XML_QNAME_DESCRIPTION {
    ULONG minLocalNameByteCount;
    ULONG maxLocalNameByteCount;
    ULONG minNsByteCount;
    ULONG maxNsByteCount;
};


//  Serialization structure
//  
//   This type description is used with WS_CHAR_ARRAY_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_CHAR_ARRAY_DESCRIPTION {
    ULONG minCharCount;
    ULONG maxCharCount;
};


//  Serialization structure
//  
//   This type description is used with WS_BYTE_ARRAY_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_BYTE_ARRAY_DESCRIPTION {
    ULONG minByteCount;
    ULONG maxByteCount;
};


//  Serialization structure
//  
//   This type description is used with WS_UTF8_ARRAY_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_UTF8_ARRAY_DESCRIPTION {
    ULONG minByteCount;
    ULONG maxByteCount;
};


//  Serialization structure
//  
//   This type description is used with WS_WSZ_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_WSZ_DESCRIPTION {
    ULONG minCharCount;
    ULONG maxCharCount;
};


//  Serialization structure
//  
//   This type description is used with WS_INT8_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_INT8_DESCRIPTION {
    char minValue;
    char maxValue;
};


//  Serialization structure
//  
//   This type description is used with WS_UINT8_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_UINT8_DESCRIPTION {
    BYTE minValue;
    BYTE maxValue;
};


//  Serialization structure
//  
//   This type description is used with WS_INT16_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_INT16_DESCRIPTION {
    short minValue;
    short maxValue;
};


//  Serialization structure
//  
//   This type description is used with WS_UINT16_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_UINT16_DESCRIPTION {
    USHORT minValue;
    USHORT maxValue;
};


//  Serialization structure
//  
//   This type description is used with WS_INT32_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_INT32_DESCRIPTION {
    int minValue;
    int maxValue;
};


//  Serialization structure
//  
//   This type description is used with WS_UINT32_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_UINT32_DESCRIPTION {
    ULONG minValue;
    ULONG maxValue;
};


//  Serialization structure
//  
//   This type description is used with WS_INT64_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_INT64_DESCRIPTION {
    __int64 minValue;
    __int64 maxValue;
};


//  Serialization structure
//  
//   This type description is used with WS_UINT64_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_UINT64_DESCRIPTION {
    unsigned __int64 minValue;
    unsigned __int64 maxValue;
};


//  Serialization structure
//  
//   This type description is used with WS_FLOAT_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_FLOAT_DESCRIPTION {
    float minValue;
    float maxValue;
};


//  Serialization structure
//  
//   This type description is used with WS_DOUBLE_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_DOUBLE_DESCRIPTION {
    double minValue;
    double maxValue;
};


//  Serialization structure
//  
//   This type description is used with WS_DECIMAL_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_DECIMAL_DESCRIPTION {
    DECIMAL minValue;
    DECIMAL maxValue;
};


//  Serialization structure
//  
//   This type description is used with WS_BYTES_TYPE and is optional.
//  It is used to specify constraints on the set of values
//  which can be deserialized.
//  
struct _WS_BYTES_DESCRIPTION {
    ULONG minByteCount;
    ULONG maxByteCount;
};


//  Serialization structure
//  
//   Provides serialization information about a single value that
//  is part of an enumeration ( WS_ENUM_DESCRIPTION).
//  
struct _WS_ENUM_VALUE {
    int value;
    WS_XML_STRING* name;
};


//  Serialization structure
//  
//   This type description is used with WS_ENUM_TYPE and is required.
//  It provides information used in serializing and deserializing
//  values of an enumeration.
//  
struct _WS_ENUM_DESCRIPTION {
    WS_ENUM_VALUE* values;
    ULONG valueCount;
    ULONG maxByteCount;
    ULONG* nameIndices;
};


//  Serialization structure
//  
//   Defines the minimum and maximum number of items that may appear
//  when using WS_REPEATING_ELEMENT_FIELD_MAPPING,
//   WS_REPEATING_ELEMENT_CHOICE_FIELD_MAPPING,
//  or WS_REPEATING_ANY_ELEMENT_FIELD_MAPPING within
//  a WS_FIELD_DESCRIPTION.  The constraint is only
//  enforced during deserialization.
//  
struct _WS_ITEM_RANGE {
    ULONG minItemCount;
    ULONG maxItemCount;
};


//  Serialization structure
//  
//   Defines a default value for a field.  This is used
//  in a WS_FIELD_DESCRIPTION.
//  
struct _WS_DEFAULT_VALUE {
    void* value;
    ULONG valueSize;
};


//  Serialization structure
//  
//   Used within a WS_STRUCT_DESCRIPTION to represent a field
//  of a structure that is mapped to XML content according to a particular
//   WS_FIELD_MAPPING.
//  
struct _WS_FIELD_DESCRIPTION {
    WS_FIELD_MAPPING mapping;
    WS_XML_STRING* localName;
    WS_XML_STRING* ns;
    WS_TYPE type;
    void* typeDescription;
    ULONG offset;
    ULONG options;
    WS_DEFAULT_VALUE* defaultValue;
    ULONG countOffset;
    WS_XML_STRING* itemLocalName;
    WS_XML_STRING* itemNs;
    WS_ITEM_RANGE* itemRange;
};


//  Serialization structure
//  
//   Represents serialization information about a field within a union.
//  See WS_UNION_DESCRIPTION.
//  
struct _WS_UNION_FIELD_DESCRIPTION {
    int value;
    WS_FIELD_DESCRIPTION field;
};


//  Serialization structure
//  
//   Information about C struct type, and how it maps to an XML element.
//  This is used with WS_STRUCT_TYPE.
//  
struct _WS_STRUCT_DESCRIPTION {
    ULONG size;
    ULONG alignment;
    WS_FIELD_DESCRIPTION** fields;
    ULONG fieldCount;
    WS_XML_STRING* typeLocalName;
    WS_XML_STRING* typeNs;
    WS_STRUCT_DESCRIPTION* parentType;
    WS_STRUCT_DESCRIPTION** subTypes;
    ULONG subTypeCount;
    ULONG structOptions;
};


//  Serialization structure
//  
//   Information about the choices within a union type.
//  This is used with WS_UNION_TYPE.
//  
struct _WS_UNION_DESCRIPTION {
    ULONG size;
    ULONG alignment;
    WS_UNION_FIELD_DESCRIPTION** fields;
    ULONG fieldCount;
    ULONG enumOffset;
    int noneEnumValue;
    ULONG* valueIndices;
};


//  Serialization structure
//  
//   Information about a mapping between an WS_ENDPOINT_ADDRESS
//   and an XML element.
//  
struct _WS_ENDPOINT_ADDRESS_DESCRIPTION {
    WS_ADDRESSING_VERSION addressingVersion;
};


//  Serialization structure
//  
//   Information about a mapping between an WS_FAULT and an XML element.
//  
struct _WS_FAULT_DESCRIPTION {
    WS_ENVELOPE_VERSION envelopeVersion;
};


//  Serialization structure
//  
//   Specifies information about a field which is neither serialized nor
//  deserialized.
//  
//   This is used with WS_VOID_TYPE and WS_NO_FIELD_MAPPING
//   within a WS_FIELD_DESCRIPTION.
//  
//   This type description is only required when WS_FIELD_POINTER is not
//  being used.
//  
struct _WS_VOID_DESCRIPTION {
    ULONG size;
};


//  Serialization structure
//  
//   Represents a custom mapping between a C data type and an XML element.
//  User-defined callbacks are invoked to do the actual reading and
//  writing.
//  
struct _WS_CUSTOM_TYPE_DESCRIPTION {
    ULONG size;
    ULONG alignment;
    WS_READ_TYPE_CALLBACK readCallback;
    WS_WRITE_TYPE_CALLBACK writeCallback;
    void* descriptionData;
    WS_IS_DEFAULT_VALUE_CALLBACK isDefaultValueCallback;
};


//  Serialization structure
//  
//   Represents a mapping between a C data type and an XML attribute.
//  
struct _WS_ATTRIBUTE_DESCRIPTION {
    WS_XML_STRING* attributeLocalName;
    WS_XML_STRING* attributeNs;
    WS_TYPE type;
    void* typeDescription;
};


//  Service Operation structure
//  
//   The index of the parameters in the incoming/outgoing messages field descriptions.
//  
struct _WS_PARAMETER_DESCRIPTION {
    WS_PARAMETER_TYPE parameterType;
    USHORT inputMessageIndex;
    USHORT outputMessageIndex;
};


//  Service Operation structure
//  
//   Metadata for the  service operation.
//  
struct _WS_OPERATION_DESCRIPTION {
    ULONG versionInfo;
    WS_MESSAGE_DESCRIPTION* inputMessageDescription;
    WS_MESSAGE_DESCRIPTION* outputMessageDescription;
    ULONG inputMessageOptions;
    ULONG outputMessageOptions;
    USHORT parameterCount;
    WS_PARAMETER_DESCRIPTION* parameterDescription;
    WS_SERVICE_STUB_CALLBACK stubCallback;
    WS_OPERATION_STYLE style;
};


//  Contract structure
//  
//   The metadata for a service contract for service model.
//  
struct _WS_CONTRACT_DESCRIPTION {
    ULONG operationCount;
    WS_OPERATION_DESCRIPTION** operations;
};


//  Contract structure
//  
//   Used to specify a service contract on an (WS_SERVICE_ENDPOINT) endpoint.
//  
struct _WS_SERVICE_CONTRACT {
    const WS_CONTRACT_DESCRIPTION* contractDescription;
    WS_SERVICE_MESSAGE_RECEIVE_CALLBACK defaultMessageHandlerCallback;
    const void* methodTable;
};


//  Service Host structure
//  
//   Specifies a service specific setting.
//  
struct _WS_SERVICE_PROPERTY {
    WS_SERVICE_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Service Host structure
//  
//   Specifies a service specific setting.
//  
struct _WS_SERVICE_ENDPOINT_PROPERTY {
    WS_SERVICE_ENDPOINT_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Service Host structure
//  
//   Specifies the callback which is called when a channel is successfully accepted.
//  
struct _WS_SERVICE_PROPERTY_ACCEPT_CALLBACK {
    WS_SERVICE_ACCEPT_CHANNEL_CALLBACK callback;
};


//  Service Metadata structure
//  
//   Specifies the individual documents that make up the service metadata.
//  
struct _WS_SERVICE_METADATA_DOCUMENT {
    WS_XML_STRING* content;
    WS_STRING* name;
};


//  Service Metadata structure
//  
//   Specifies the service metadata documents array. This can be a collection of
//  WSDL/XSD documents represented as an array of WS_STRING.
//  
struct _WS_SERVICE_METADATA {
    ULONG documentCount;
    WS_SERVICE_METADATA_DOCUMENT** documents;
    WS_XML_STRING* serviceName;
    WS_XML_STRING* serviceNs;
};


//  Service Host structure
//  
//   Specifies the callback which is called when a channel is about to be closed.
//  See, WS_SERVICE_CLOSE_CHANNEL_CALLBACK for details.
//  
struct _WS_SERVICE_PROPERTY_CLOSE_CALLBACK {
    WS_SERVICE_CLOSE_CHANNEL_CALLBACK callback;
};


//  Service Metadata structure
//  
//   Represents the port element for the endpoint. The port element is
//  generated for the service element as specified by serviceName and
//  serviceNs for WS_SERVICE_PROPERTY_METADATA property
//  on the WS_SERVICE_HOST.
//  
//   Note, the port type will only be generated into the WSDL document if the service
//  element is indeed generated by the runtime.
//  
struct _WS_SERVICE_ENDPOINT_METADATA {
    WS_XML_STRING* portName;
    WS_XML_STRING* bindingName;
    WS_XML_STRING* bindingNs;
};


//  Service Host structure
//  
//   Represents an individual endpoint on a service host. The properties on the endpoint
//  are used to specify the address, binding and contract.
//  
struct _WS_SERVICE_ENDPOINT {
    WS_ENDPOINT_ADDRESS address;
    WS_CHANNEL_BINDING channelBinding;
    WS_CHANNEL_TYPE channelType;
    const WS_SECURITY_DESCRIPTION* securityDescription;
    const WS_SERVICE_CONTRACT* contract;
    WS_SERVICE_SECURITY_CALLBACK authorizationCallback;
    const WS_SERVICE_ENDPOINT_PROPERTY* properties;
    ULONG propertyCount;
    WS_CHANNEL_PROPERTIES channelProperties;
};


//  Service Proxy structure
//  
//   Specifies a proxy property.
//  
struct _WS_PROXY_PROPERTY {
    WS_PROXY_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Service Proxy structure
//  
//   Specifies the callback function and state for an application that wishes
//  to associate or inspect headers in an input or an output message respectively.
//  
//   See also, WS_CALL_PROPERTY_SEND_MESSAGE_CONTEXT and
//   WS_CALL_PROPERTY_RECEIVE_MESSAGE_CONTEXT.
//  
struct _WS_PROXY_MESSAGE_CALLBACK_CONTEXT {
    WS_PROXY_MESSAGE_CALLBACK callback;
    void* state;
};


//  Service Proxy structure
//  
//   Specifies a proxy property.
//  
struct _WS_CALL_PROPERTY {
    WS_CALL_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Url structure
//  
//   The abstract base type for all URL schemes used with WsDecodeUrl and WsEncodeUrl APIs.
//  
struct _WS_URL {
    WS_URL_SCHEME_TYPE scheme;
};


//  Url structure
//  
//   The URL subtype for specifying an http URL.
//  
struct _WS_HTTP_URL {
    WS_URL url;
    WS_STRING host;
    USHORT port;
    WS_STRING portAsString;
    WS_STRING path;
    WS_STRING query;
    WS_STRING fragment;
};


//  Url structure
//  
//   The URL subtype for specifying an https URL.
//  
struct _WS_HTTPS_URL {
    WS_URL url;
    WS_STRING host;
    USHORT port;
    WS_STRING portAsString;
    WS_STRING path;
    WS_STRING query;
    WS_STRING fragment;
};


//  Url structure
//  
//   The URL subtype for specifying an net.tcp URL.
//  
struct _WS_NETTCP_URL {
    WS_URL url;
    WS_STRING host;
    USHORT port;
    WS_STRING portAsString;
    WS_STRING path;
    WS_STRING query;
    WS_STRING fragment;
};


//  Url structure
//  
//   The URL subtype for specifying an soap.udp URL.
//  
struct _WS_SOAPUDP_URL {
    WS_URL url;
    WS_STRING host;
    USHORT port;
    WS_STRING portAsString;
    WS_STRING path;
    WS_STRING query;
    WS_STRING fragment;
};


//  Utilities structure
//  
//   Represents a unique ID URI.
//  
struct _WS_UNIQUE_ID {
    WS_STRING uri;
    GUID guid;
};


//  Utilities structure
//  A structure used to represent a discontiguous array of WS_BYTES.
struct _WS_BUFFERS {
    ULONG bufferCount;
    WS_BYTES* buffers;
};


//  Metadata Import structure
//  
//   Information about a single endpoint that was
//  read from metadata documents.
//  
struct _WS_METADATA_ENDPOINT {
    WS_ENDPOINT_ADDRESS endpointAddress;
    WS_POLICY* endpointPolicy;
    WS_XML_STRING* portName;
    WS_XML_STRING* serviceName;
    WS_XML_STRING* serviceNs;
    WS_XML_STRING* bindingName;
    WS_XML_STRING* bindingNs;
    WS_XML_STRING* portTypeName;
    WS_XML_STRING* portTypeNs;
};


//  Metadata Import structure
//  
//   Information about all endpoints that were
//  read from metadata documents.
//  
struct _WS_METADATA_ENDPOINTS {
    WS_METADATA_ENDPOINT* endpoints;
    ULONG endpointCount;
};


//  Metadata Import structure
//  
//   Specifies a metadata object setting.
//  
struct _WS_METADATA_PROPERTY {
    WS_METADATA_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Metadata Import structure
//  
//   Specifies a policy object setting.
//  
struct _WS_POLICY_PROPERTY {
    WS_POLICY_PROPERTY_ID id;
    void* value;
    ULONG valueSize;
};


//  Metadata Import structure
//  
//   A structure that is used to specify a set of WS_POLICY_PROPERTYs.
//  
struct _WS_POLICY_PROPERTIES {
    WS_POLICY_PROPERTY* properties;
    ULONG propertyCount;
};


//  Metadata Import structure
//  
//   This structure is used to specify a set of constraints
//  for a particular security binding property.
//  Any property constraints that are not specified will use
//  the default constraints.
//  
struct _WS_SECURITY_BINDING_PROPERTY_CONSTRAINT {
    WS_SECURITY_BINDING_PROPERTY_ID id;
    void* allowedValues;
    ULONG allowedValuesSize;
    struct
    {
        WS_SECURITY_BINDING_PROPERTY securityBindingProperty;
    } out;
};


//  Metadata Import structure
//  
//   The base class for all security binding constraint structures.
//  
struct _WS_SECURITY_BINDING_CONSTRAINT {
    WS_SECURITY_BINDING_CONSTRAINT_TYPE type;
    WS_SECURITY_BINDING_PROPERTY_CONSTRAINT* propertyConstraints;
    ULONG propertyConstraintCount;
};


//  Metadata Import structure
//  
//   A security binding constraint that corresponds to the
//   WS_SSL_TRANSPORT_SECURITY_BINDING.
//  
struct _WS_SSL_TRANSPORT_SECURITY_BINDING_CONSTRAINT {
    WS_SECURITY_BINDING_CONSTRAINT bindingConstraint;
    struct
    {
        BOOL clientCertCredentialRequired;
    } out;
};


//  Metadata Import structure
//  
//   A security binding constraint that corresponds to the
//   WS_USERNAME_MESSAGE_SECURITY_BINDING.
//  
struct _WS_USERNAME_MESSAGE_SECURITY_BINDING_CONSTRAINT {
    WS_SECURITY_BINDING_CONSTRAINT bindingConstraint;
    WS_MESSAGE_SECURITY_USAGE bindingUsage;
};


//  Metadata Import structure
//  
//   A security binding constraint that corresponds to the
//   WS_HTTP_HEADER_AUTH_SECURITY_BINDING.
//  
struct _WS_HTTP_HEADER_AUTH_SECURITY_BINDING_CONSTRAINT {
    WS_SECURITY_BINDING_CONSTRAINT bindingConstraint;
};


//  Metadata Import structure
//  
//   A security binding constraint that corresponds to the
//   WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING.
//  
struct _WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING_CONSTRAINT {
    WS_SECURITY_BINDING_CONSTRAINT bindingConstraint;
};


//  Metadata Import structure
//  
//   A security binding constraint that can be used with
//   WS_XML_TOKEN_MESSAGE_SECURITY_BINDING.
//  
struct _WS_CERT_MESSAGE_SECURITY_BINDING_CONSTRAINT {
    WS_SECURITY_BINDING_CONSTRAINT bindingConstraint;
    WS_MESSAGE_SECURITY_USAGE bindingUsage;
};


//  Metadata Import structure
//  
//   A security binding constraint that corresponds to the
//   WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING.
//  
struct _WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_CONSTRAINT {
    WS_SECURITY_BINDING_CONSTRAINT bindingConstraint;
    WS_MESSAGE_SECURITY_USAGE bindingUsage;
};


//  Metadata Import structure
//  
//   This structure is used to specify a set of constraints
//  for a particular request security token property.
//  Any property constraints that are not specified will use
//  the default constraints.
//  
struct _WS_REQUEST_SECURITY_TOKEN_PROPERTY_CONSTRAINT {
    WS_REQUEST_SECURITY_TOKEN_PROPERTY_ID id;
    void* allowedValues;
    ULONG allowedValuesSize;
    struct
    {
        WS_REQUEST_SECURITY_TOKEN_PROPERTY requestSecurityTokenProperty;
    } out;
};


//  Metadata Import structure
//  
//   A security binding constraint that can be used to extract information
//  about how to obtain an issued token from an issuing party.
//  
struct _WS_ISSUED_TOKEN_MESSAGE_SECURITY_BINDING_CONSTRAINT {
    WS_SECURITY_BINDING_CONSTRAINT bindingConstraint;
    WS_MESSAGE_SECURITY_USAGE bindingUsage;
    WS_XML_STRING* claimConstraints;
    ULONG claimConstraintCount;
    WS_REQUEST_SECURITY_TOKEN_PROPERTY_CONSTRAINT* requestSecurityTokenPropertyConstraints;
    ULONG requestSecurityTokenPropertyConstraintCount;
    struct
    {
        WS_ENDPOINT_ADDRESS* issuerAddress;
        WS_XML_BUFFER* requestSecurityTokenTemplate;
    } out;
};


//  Metadata Import structure
//  
//   This structure is used to specify a set of constraints
//  for a particular security property.
//  Any property constraints that are not specified will use
//  the default constraints.
//  
struct _WS_SECURITY_PROPERTY_CONSTRAINT {
    WS_SECURITY_PROPERTY_ID id;
    void* allowedValues;
    ULONG allowedValuesSize;
    struct
    {
        WS_SECURITY_PROPERTY securityProperty;
    } out;
};


//  Metadata Import structure
//  
//   This structure specifies the security related constraints
//  as part of WS_POLICY_CONSTRAINTS.
//  
struct _WS_SECURITY_CONSTRAINTS {
    WS_SECURITY_PROPERTY_CONSTRAINT* securityPropertyConstraints;
    ULONG securityPropertyConstraintCount;
    WS_SECURITY_BINDING_CONSTRAINT** securityBindingConstraints;
    ULONG securityBindingConstraintCount;
};


//  Metadata Import structure
//  
//   A security binding constraint that corresponds to
//  the WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING.
//  
struct _WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING_CONSTRAINT {
    WS_SECURITY_BINDING_CONSTRAINT bindingConstraint;
    WS_MESSAGE_SECURITY_USAGE bindingUsage;
    WS_SECURITY_CONSTRAINTS* bootstrapSecurityConstraint;
};


//  Metadata Import structure
//  
//   This structure is used to specify a set of constraints
//  for a particular channel property.
//  Any property constraints that are not specified will use
//  the default constraints.
//  
struct _WS_CHANNEL_PROPERTY_CONSTRAINT {
    WS_CHANNEL_PROPERTY_ID id;
    void* allowedValues;
    ULONG allowedValuesSize;
    struct
    {
        WS_CHANNEL_PROPERTY channelProperty;
    } out;
};


//  Metadata Import structure
//  
//   The base class for all policy extension structures. Policy extensions
//  are assertions that are directly handled by applications such as custom assertions.
//  
struct _WS_POLICY_EXTENSION {
    WS_POLICY_EXTENSION_TYPE type;
};


//  Metadata Import structure
//  
//   This structure is used to specify an endpoint policy extension.
//  
struct _WS_ENDPOINT_POLICY_EXTENSION {
    WS_POLICY_EXTENSION policyExtension;
    WS_XML_STRING* assertionName;
    WS_XML_STRING* assertionNs;
    struct
    {
        WS_XML_BUFFER* assertionValue;
    } out;
};


//  Metadata Import structure
//  
//   This structure is used to specify policy constraints for a channel.
//  
struct _WS_POLICY_CONSTRAINTS {
    WS_CHANNEL_BINDING channelBinding;
    WS_CHANNEL_PROPERTY_CONSTRAINT* channelPropertyConstraints;
    ULONG channelPropertyConstraintCount;
    WS_SECURITY_CONSTRAINTS* securityConstraints;
    WS_POLICY_EXTENSION** policyExtensions;
    ULONG policyExtensionCount;
};


//  Policy Support structure
//  
//   Describes the policy specifying http channel binding.
//  
struct _WS_HTTP_POLICY_DESCRIPTION {
    WS_CHANNEL_PROPERTIES channelProperties;
};


//  Policy Support structure
//  
//   This type description is used with template APIs to describe
//  the templates generated accordingly to input policy setting.
//  
//   See also,
//   WsCreateServiceProxyFromTemplate,
//   WsCreateServiceEndpointFromTemplate
struct _WS_SSL_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION {
    WS_SECURITY_BINDING_PROPERTIES securityBindingProperties;
};


//  Policy Support structure
//  
//   Describes the policy specifying http channel binding.
//  
struct _WS_HTTP_SSL_POLICY_DESCRIPTION {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSL_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION sslTransportSecurityBinding;
};


//  Policy Support structure
//  
//   This type description is used with template APIs to describe
//  the templates generated accordingly to input policy setting.
//  
//   See also,
//   WsCreateServiceProxyFromTemplate,
//   WsCreateServiceEndpointFromTemplate
struct _WS_HTTP_HEADER_AUTH_SECURITY_BINDING_POLICY_DESCRIPTION {
    WS_SECURITY_BINDING_PROPERTIES securityBindingProperties;
};


//  Policy Support structure
//  
//   Describes the policy specifying http channel binding.
//  
struct _WS_HTTP_HEADER_AUTH_POLICY_DESCRIPTION {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_HTTP_HEADER_AUTH_SECURITY_BINDING_POLICY_DESCRIPTION httpHeaderAuthSecurityBinding;
};


//  Policy Support structure
//  
//   Describes the policy specifying http channel binding with SSL transport security and
//  header authentication.
//  
struct _WS_HTTP_SSL_HEADER_AUTH_POLICY_DESCRIPTION {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSL_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION sslTransportSecurityBinding;
    WS_HTTP_HEADER_AUTH_SECURITY_BINDING_POLICY_DESCRIPTION httpHeaderAuthSecurityBinding;
};


//  Policy Support structure
//  
//   This type description is used with template APIs to describe
//  the templates generated accordingly to input policy setting.
//  
//   See also,
//   WsCreateServiceProxyFromTemplate,
//   WsCreateServiceEndpointFromTemplate
struct _WS_USERNAME_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION {
    WS_SECURITY_BINDING_PROPERTIES securityBindingProperties;
    WS_MESSAGE_SECURITY_USAGE bindingUsage;
};


//  Policy Support structure
//  
//   Describes the policy specifying http channel binding with SSL transport security and
//  username/password message security.
//  
struct _WS_HTTP_SSL_USERNAME_POLICY_DESCRIPTION {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSL_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION sslTransportSecurityBinding;
    WS_USERNAME_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION usernameMessageSecurityBinding;
};


//  Policy Support structure
//  
//   This type description is used with template APIs to describe
//  the templates generated accordingly to input policy setting.
//  
//   See also,
//   WsCreateServiceProxyFromTemplate,
//   WsCreateServiceEndpointFromTemplate
struct _WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION {
    WS_SECURITY_BINDING_PROPERTIES securityBindingProperties;
    WS_MESSAGE_SECURITY_USAGE bindingUsage;
};


//  Policy Support structure
//  
//   Describes the policy specifying http channel binding with SSL transport security
//  and KERBEROS AP_REQ message security.
//  
struct _WS_HTTP_SSL_KERBEROS_APREQ_POLICY_DESCRIPTION {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSL_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION sslTransportSecurityBinding;
    WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION kerberosApreqMessageSecurityBinding;
};


//  Policy Support structure
//  
//   Describes the policy specifying http channel binding.
//  
struct _WS_TCP_POLICY_DESCRIPTION {
    WS_CHANNEL_PROPERTIES channelProperties;
};


//  Policy Support structure
//  
//   This type description is used with template APIs to describe
//  the templates generated accordingly to input policy setting.
//  
//   See also,
//   WsCreateServiceProxyFromTemplate,
//   WsCreateServiceEndpointFromTemplate
struct _WS_SSPI_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION {
    WS_SECURITY_BINDING_PROPERTIES securityBindingProperties;
};


//  Policy Support structure
//  
//   Describes the policy specifying TCP channel binding with windows SSPI.
//  
struct _WS_TCP_SSPI_POLICY_DESCRIPTION {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSPI_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION sspiTransportSecurityBinding;
};


//  Policy Support structure
//  
//   Describes the policy specifying TCP channel binding with windows SSPI transport
//  security and username/password message security.
//  
struct _WS_TCP_SSPI_USERNAME_POLICY_DESCRIPTION {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSPI_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION sspiTransportSecurityBinding;
    WS_USERNAME_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION usernameMessageSecurityBinding;
};


//  Policy Support structure
//  
//   Describes the policy specifying TCP channel binding with windows SSPI transport
//  security, and kerberos message security.
//  
struct _WS_TCP_SSPI_KERBEROS_APREQ_POLICY_DESCRIPTION {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSPI_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION sspiTransportSecurityBinding;
    WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION kerberosApreqMessageSecurityBinding;
};


//  Policy Support structure
//  
//   This type description is used with template APIs to describe
//  the templates generated accordingly to input policy setting.
//  
struct _WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION {
    WS_SECURITY_BINDING_PROPERTIES securityBindingProperties;
    WS_MESSAGE_SECURITY_USAGE bindingUsage;
};


//  Policy Support structure
//  
//   This type description is used with template APIs to describe
//  the security context related templates generated accordingly to input policy setting.
//  
struct _WS_SECURITY_CONTEXT_SECURITY_BINDING_POLICY_DESCRIPTION {
    WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION securityContextMessageSecurityBinding;
    WS_SECURITY_PROPERTIES securityProperties;
};


//  Policy Support structure
//  
//   Describes the policy specifying security context message binding using TCP channel binding
//  with windows SSPI transport security. The bootstrap channel uses TCP channel binding with
//  windows SSPI transport security and kerberos message security.
//  
struct _WS_TCP_SSPI_KERBEROS_APREQ_SECURITY_CONTEXT_POLICY_DESCRIPTION {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSPI_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION sspiTransportSecurityBinding;
    WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION kerberosApreqMessageSecurityBinding;
    WS_SECURITY_CONTEXT_SECURITY_BINDING_POLICY_DESCRIPTION securityContextSecurityBinding;
};


//  Policy Support structure
//  
//   Describes the policy specifying security context message binding using TCP channel binding with windows SSPI transport
//  security. The bootstrap channel uses TCP channel binding with windows SSPI transport
//  security and username/password message security.
//  
struct _WS_TCP_SSPI_USERNAME_SECURITY_CONTEXT_POLICY_DESCRIPTION {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSPI_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION sspiTransportSecurityBinding;
    WS_USERNAME_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION usernameMessageSecurityBinding;
    WS_SECURITY_CONTEXT_SECURITY_BINDING_POLICY_DESCRIPTION securityContextSecurityBinding;
};


//  Policy Support structure
//  
//   Describes the policy specifying security context message binding over http channel binding, with SSL
//  transport security. The bootstrap channel uses http channel binding with SSL transport security
//  and username/password message security.
//  
struct _WS_HTTP_SSL_USERNAME_SECURITY_CONTEXT_POLICY_DESCRIPTION {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSL_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION sslTransportSecurityBinding;
    WS_USERNAME_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION usernameMessageSecurityBinding;
    WS_SECURITY_CONTEXT_SECURITY_BINDING_POLICY_DESCRIPTION securityContextSecurityBinding;
};


//  Policy Support structure
//  
//   Describes the policy specifying security context message binding over http channel binding, with SSL
//  transport security. The bootstrap channel uses http channel binding with SSL transport security
//  and KERBEROS AP_REQ message security.
//  
struct _WS_HTTP_SSL_KERBEROS_APREQ_SECURITY_CONTEXT_POLICY_DESCRIPTION {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSL_TRANSPORT_SECURITY_BINDING_POLICY_DESCRIPTION sslTransportSecurityBinding;
    WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_POLICY_DESCRIPTION kerberosApreqMessageSecurityBinding;
    WS_SECURITY_CONTEXT_SECURITY_BINDING_POLICY_DESCRIPTION securityContextSecurityBinding;
};


//  Policy Support structure
//  
//   HTTP template structure to be filled in by application for http binding.
//  
struct _WS_HTTP_BINDING_TEMPLATE {
    WS_CHANNEL_PROPERTIES channelProperties;
};


//  Policy Support structure
//  
//   TCP template structure to be filled in by application for TCP binding.
//  
struct _WS_TCP_BINDING_TEMPLATE {
    WS_CHANNEL_PROPERTIES channelProperties;
};


//  Policy Support structure
//  
//   The security binding template for specifying the use of SSL/TLS
//  protocol based transport security.
//  See Also WS_SSL_TRANSPORT_SECURITY_BINDING
//   This security binding is supported only with WS_HTTP_CHANNEL_BINDING.
//  
struct _WS_SSL_TRANSPORT_SECURITY_BINDING_TEMPLATE {
    WS_SECURITY_BINDING_PROPERTIES securityBindingProperties;
    WS_CERT_CREDENTIAL* localCertCredential;
};


//  Policy Support structure
//  
//   SSL security template information to be filled in by application.
//  Associated with WS_HTTP_SSL_BINDING_TEMPLATE_TYPE.
//  
struct _WS_HTTP_SSL_BINDING_TEMPLATE {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSL_TRANSPORT_SECURITY_BINDING_TEMPLATE sslTransportSecurityBinding;
};


//  Policy Support structure
//  
//   The security binding template for specifying the use of HTP header authentication
//  protocol based security.
//  See also WS_HTTP_HEADER_AUTH_SECURITY_BINDING
struct _WS_HTTP_HEADER_AUTH_SECURITY_BINDING_TEMPLATE {
    WS_SECURITY_BINDING_PROPERTIES securityBindingProperties;
    WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL* clientCredential;
};


//  Policy Support structure
//  
//   HTTP header authentication security template information to be filled in by application.
//  Associated with WS_HTTP_HEADER_AUTH_BINDING_TEMPLATE_TYPE.
//  
struct _WS_HTTP_HEADER_AUTH_BINDING_TEMPLATE {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_HTTP_HEADER_AUTH_SECURITY_BINDING_TEMPLATE httpHeaderAuthSecurityBinding;
};


//  Policy Support structure
//  
//   The security binding template for specifying the use of Windows SSPI
//  protocol based transport security.
//  
//   See also WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING.
//  
struct _WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING_TEMPLATE {
    WS_SECURITY_BINDING_PROPERTIES securityBindingProperties;
    WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL* clientCredential;
};


//  Policy Support structure
//  
//   HTTP header authentication security template information to be filled in by application.
//  Associated with WS_TCP_SSPI_BINDING_TEMPLATE_TYPE.
//  
struct _WS_TCP_SSPI_BINDING_TEMPLATE {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING_TEMPLATE sspiTransportSecurityBinding;
};


//  Policy Support structure
//  
//   Username/password security template information to be filled in by application.
//  Associated with WS_HTTP_SSL_HEADER_AUTH_BINDING_TEMPLATE_TYPE.
//  
struct _WS_HTTP_SSL_HEADER_AUTH_BINDING_TEMPLATE {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSL_TRANSPORT_SECURITY_BINDING_TEMPLATE sslTransportSecurityBinding;
    WS_HTTP_HEADER_AUTH_SECURITY_BINDING_TEMPLATE httpHeaderAuthSecurityBinding;
};


//  Policy Support structure
//  
//   The security binding template for specifying the use of an application
//  supplied username / password pair as a direct (i.e., one-shot)
//  security token.  This security binding may be used only with message
//  security.  It provides client authentication, but not traffic signing
//  or encryption.  So, it is used in conjunction with another transport
//  security or message security binding that provides message protection.
//  See also WS_USERNAME_MESSAGE_SECURITY_BINDING
struct _WS_USERNAME_MESSAGE_SECURITY_BINDING_TEMPLATE {
    WS_SECURITY_BINDING_PROPERTIES securityBindingProperties;
    WS_USERNAME_CREDENTIAL* clientCredential;
    WS_VALIDATE_PASSWORD_CALLBACK passwordValidator;
    void* passwordValidatorCallbackState;
};


//  Policy Support structure
//  
//   Username/password security template information to be filled in by application.
//  Associated with WS_HTTP_SSL_USERNAME_BINDING_TEMPLATE_TYPE.
//  
struct _WS_HTTP_SSL_USERNAME_BINDING_TEMPLATE {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSL_TRANSPORT_SECURITY_BINDING_TEMPLATE sslTransportSecurityBinding;
    WS_USERNAME_MESSAGE_SECURITY_BINDING_TEMPLATE usernameMessageSecurityBinding;
};


//  Policy Support structure
//  
//   The security binding template for specifying the use of the Kerberos
//  AP_REQ ticket as a direct (i.e., without establishing a session)
//  security token with WS-Security.
//  See also WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING
struct _WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_TEMPLATE {
    WS_SECURITY_BINDING_PROPERTIES securityBindingProperties;
    WS_WINDOWS_INTEGRATED_AUTH_CREDENTIAL* clientCredential;
};


//  Policy Support structure
//  
//   Username/password security template information to be filled in by application.
//  Associated with WS_HTTP_SSL_KERBEROS_APREQ_BINDING_TEMPLATE_TYPE.
//  
struct _WS_HTTP_SSL_KERBEROS_APREQ_BINDING_TEMPLATE {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSL_TRANSPORT_SECURITY_BINDING_TEMPLATE sslTransportSecurityBinding;
    WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_TEMPLATE kerberosApreqMessageSecurityBinding;
};


//  Policy Support structure
//  
//   Username/password security template information to be filled in by application.
//  Associated with WS_TCP_SSPI_USERNAME_BINDING_TEMPLATE_TYPE.
//  
struct _WS_TCP_SSPI_USERNAME_BINDING_TEMPLATE {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING_TEMPLATE sspiTransportSecurityBinding;
    WS_USERNAME_MESSAGE_SECURITY_BINDING_TEMPLATE usernameMessageSecurityBinding;
};


//  Policy Support structure
//  
//   Username/password security template information to be filled in by application.
//  Associated with WS_TCP_SSPI_KERBEROS_APREQ_BINDING_TEMPLATE_TYPE.
//  
struct _WS_TCP_SSPI_KERBEROS_APREQ_BINDING_TEMPLATE {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING_TEMPLATE sspiTransportSecurityBinding;
    WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_TEMPLATE kerberosApreqMessageSecurityBinding;
};


//  Policy Support structure
//  
//   The security binding template for specifying the use of an application
//  supplied security context security binding.  This security binding may
//  be used only with message security. So, it is used in conjunction with another transport
//  security or message security binding that provides message protection.
//  
//   See also WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING
struct _WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING_TEMPLATE {
    WS_SECURITY_BINDING_PROPERTIES securityBindingProperties;
};


//  Policy Support structure
//  
//   The security binding template for specifying the use of an application
//  supplied security context security binding.  This security binding may
//  be used only with message security. So, it is used in conjunction with another transport
//  security binding that provides message protection. The security properties are
//  used to establish the secure conversation.
//  
//   See also WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING
struct _WS_SECURITY_CONTEXT_SECURITY_BINDING_TEMPLATE {
    WS_SECURITY_CONTEXT_MESSAGE_SECURITY_BINDING_TEMPLATE securityContextMessageSecurityBinding;
    WS_SECURITY_PROPERTIES securityProperties;
};


//  Policy Support structure
//  
//   Security template information to be filled in by application.
//  Associated with WS_HTTP_SSL_USERNAME_SECURITY_CONTEXT_BINDING_TEMPLATE_TYPE.
//  
struct _WS_HTTP_SSL_USERNAME_SECURITY_CONTEXT_BINDING_TEMPLATE {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSL_TRANSPORT_SECURITY_BINDING_TEMPLATE sslTransportSecurityBinding;
    WS_USERNAME_MESSAGE_SECURITY_BINDING_TEMPLATE usernameMessageSecurityBinding;
    WS_SECURITY_CONTEXT_SECURITY_BINDING_TEMPLATE securityContextSecurityBinding;
};


//  Policy Support structure
//  
//   Security template information to be filled in by application.
//  Associated with WS_HTTP_SSL_KERBEROS_APREQ_SECURITY_CONTEXT_BINDING_TEMPLATE_TYPE.
//  
struct _WS_HTTP_SSL_KERBEROS_APREQ_SECURITY_CONTEXT_BINDING_TEMPLATE {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_SSL_TRANSPORT_SECURITY_BINDING_TEMPLATE sslTransportSecurityBinding;
    WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_TEMPLATE kerberosApreqMessageSecurityBinding;
    WS_SECURITY_CONTEXT_SECURITY_BINDING_TEMPLATE securityContextSecurityBinding;
};


//  Policy Support structure
//  
//   Security template information to be filled in by application.
//  Associated with WS_TCP_SSPI_USERNAME_SECURITY_CONTEXT_BINDING_TEMPLATE_TYPE.
//  
struct _WS_TCP_SSPI_USERNAME_SECURITY_CONTEXT_BINDING_TEMPLATE {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING_TEMPLATE sspiTransportSecurityBinding;
    WS_USERNAME_MESSAGE_SECURITY_BINDING_TEMPLATE usernameMessageSecurityBinding;
    WS_SECURITY_CONTEXT_SECURITY_BINDING_TEMPLATE securityContextSecurityBinding;
};


//  Policy Support structure
//  
//   Security template information to be filled in by application.
//  Associated with WS_TCP_SSPI_KERBEROS_APREQ_SECURITY_CONTEXT_BINDING_TEMPLATE_TYPE.
//  
struct _WS_TCP_SSPI_KERBEROS_APREQ_SECURITY_CONTEXT_BINDING_TEMPLATE {
    WS_CHANNEL_PROPERTIES channelProperties;
    WS_SECURITY_PROPERTIES securityProperties;
    WS_TCP_SSPI_TRANSPORT_SECURITY_BINDING_TEMPLATE sspiTransportSecurityBinding;
    WS_KERBEROS_APREQ_MESSAGE_SECURITY_BINDING_TEMPLATE kerberosApreqMessageSecurityBinding;
    WS_SECURITY_CONTEXT_SECURITY_BINDING_TEMPLATE securityContextSecurityBinding;
};

//  MACRO DEFINITIONS

//  XML Node macro
//  
//   Provides an initializer for a WS_XML_STRING structure when there is an associated dictionary ID.
//  
#define WS_XML_STRING_DICTIONARY_VALUE(S, D, I) { sizeof(S)-1, (BYTE*)RTL_CONST_CAST(char*)(S), RTL_CONST_CAST(WS_XML_DICTIONARY*)(D), I }


//  XML Node macro
//  
//   Provides an initializer for a WS_XML_STRING structure when there is no associated dictionary ID.
//  
#define WS_XML_STRING_VALUE(S) { sizeof(S)-1, (BYTE*)RTL_CONST_CAST(char*)(S), NULL, 0 }


//  XML Node macro
//  
//   Provides an an empty string initializer for a WS_XML_STRING structure.
//  
#define WS_XML_STRING_NULL { 0, NULL, NULL, NULL }


//  Utilities macro
//  
//   A macro to initialize a WS_STRING structure given a constant string.
//  
#define WS_STRING_VALUE(S) { WsCountOf(S) - 1, S }


//  Utilities macro
//  
//   A macro to initialize a WS_STRING structure to a zero-length string.
//  
#define WS_STRING_EMPTY { 0, NULL }


//  Utilities macro
//  
//   Returns the number of elements of an array.
//  
#define WsCountOf(arrayValue) RTL_NUMBER_OF(arrayValue)


//  Utilities macro
//  
//   Returns the offset, in bytes, of a field within a contained structure, given the name
//  of the structure and the name of the field.
//  
#define WsOffsetOf(type, field) FIELD_OFFSET(type, field)


//  FUNCTION DEFINITIONS

//  XML Canonicalization function
//  
//   Starts canonicalization on the specified XML reader.
//  
HRESULT WINAPI WsStartReaderCanonicalization(
    __in WS_XML_READER* reader, 
    __in WS_WRITE_CALLBACK writeCallback, 
    __in void* writeCallbackState, 
    __in_ecount_opt(propertyCount) const WS_XML_CANONICALIZATION_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __in_opt WS_ERROR* error);


//  XML Canonicalization function
//  
//   Stops XML canonicalization started by the preceding WsStartReaderCanonicalization call.
//  
HRESULT WINAPI WsEndReaderCanonicalization(
    __in WS_XML_READER* reader, 
    __in_opt WS_ERROR* error);


//  XML Canonicalization function
//  
//   Starts canonicalization on the specified XML writer.
//  
HRESULT WINAPI WsStartWriterCanonicalization(
    __in WS_XML_WRITER* writer, 
    __in WS_WRITE_CALLBACK writeCallback, 
    __in void* writeCallbackState, 
    __in_ecount_opt(propertyCount) const WS_XML_CANONICALIZATION_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __in_opt WS_ERROR* error);


//  XML Canonicalization function
//  
//   Stops XML canonicalization started by the preceding WsStartWriterCanonicalization call.
//  
HRESULT WINAPI WsEndWriterCanonicalization(
    __in WS_XML_WRITER* writer, 
    __in_opt WS_ERROR* error);


//  XML Buffer function
//  
//   Creates an XML Buffer which can be used to process xml data in-memory.  It can be
//  navigated through, written to, and read from.
//  
HRESULT WINAPI WsCreateXmlBuffer(
    __in WS_HEAP* heap, 
    __in_ecount_opt(propertyCount) const WS_XML_BUFFER_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __deref_out WS_XML_BUFFER** buffer, 
    __in_opt WS_ERROR* error);


//  XML Buffer function
//  
//   Removes the node at the specified position from the xml buffer.  If positioned
//  on an element it will remove the element including all of its children and its
//  corresponding end element, otherwise it will remove a single node.
//  
//   The use of any API with a WS_XML_READER or WS_XML_WRITER that
//  currently depends on this position or a child of this position will fail. The
//   WS_XML_READER or WS_XML_WRITER must be repositioned
//  before using further.
//  
//   It will return WS_E_INVALID_OPERATION if the node is positioned on an end
//  element or the root of the document.
//  
//   Calling WsSetReaderPosition or WsSetWriterPosition after calling WsRemoveNode will fail.
//  
HRESULT WINAPI WsRemoveNode(
    __in const WS_XML_NODE_POSITION* nodePosition, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Creates an instance of a WS_XML_READER.  Use WsSetInput or WsSetInputToBuffer
//   to choose the encoding of the reader and to indicate the source of the input.
//  
HRESULT WINAPI WsCreateReader(
    __in_ecount_opt(propertyCount) const WS_XML_READER_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __deref_out WS_XML_READER** reader, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Sets the encoding and input sources for the reader.
//  
HRESULT WINAPI WsSetInput(
    __in WS_XML_READER* reader, 
    __in_opt const WS_XML_READER_ENCODING* encoding, 
    __in_opt const WS_XML_READER_INPUT* input, 
    __in_ecount_opt(propertyCount) const WS_XML_READER_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Sets the reader to use a specified xml buffer as the input source.
//  
HRESULT WINAPI WsSetInputToBuffer(
    __in WS_XML_READER* reader, 
    __in WS_XML_BUFFER* buffer, 
    __in_ecount_opt(propertyCount) const WS_XML_READER_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Releases the memory associated with the WS_XML_READER object.
//  
void WINAPI WsFreeReader(__in WS_XML_READER* reader);


//  XML Reader function
//  Returns a property of the specified xml reader.
HRESULT WINAPI WsGetReaderProperty(
    __in WS_XML_READER* reader, 
    __in WS_XML_READER_PROPERTY_ID id, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Returns the (WS_XML_NODE) node that the (WS_XML_READER) reader is currently positioned on.
//  
HRESULT WINAPI WsGetReaderNode(
    __in WS_XML_READER* xmlReader, 
    __deref_out const WS_XML_NODE** node, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Ensures that the reader has at least a specified amount of data available to it for reading.
//  
HRESULT WINAPI WsFillReader(
    __in WS_XML_READER* reader, 
    __in ULONG minSize, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Advances the reader past a start element skipping any whitespace in front of it.
//  
HRESULT WINAPI WsReadStartElement(
    __in WS_XML_READER* reader, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Advances the reader to the next start element skipping whitespace and comments if necessary.  Optionally,
//  it may also verify the localName and namespace of the element.
//  
HRESULT WINAPI WsReadToStartElement(
    __in WS_XML_READER* reader, 
    __in_opt const WS_XML_STRING* localName, 
    __in_opt const WS_XML_STRING* ns, 
    __out_opt BOOL* found, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Moves the reader to the specified attribute so that its content may be read using ReadValue, ReadChars, or ReadBytes.
//  
HRESULT WINAPI WsReadStartAttribute(
    __in WS_XML_READER* reader, 
    __in ULONG attributeIndex, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Moves the reader back to the element node containing the attribute that was read.
//  
HRESULT WINAPI WsReadEndAttribute(
    __in WS_XML_READER* reader, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Advances the reader to the next (WS_XML_NODE) node in the input stream.
//  
HRESULT WINAPI WsReadNode(
    __in WS_XML_READER* reader, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Advances the reader in the input stream.  If the current node is an element,
//  all of the children of that element are skipped, and the reader is positioned
//  on the node following its end element.  Otherwise, the reader is positioned
//  on the next node in the same manner as WsReadNode.
//  
HRESULT WINAPI WsSkipNode(
    __in WS_XML_READER* reader, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Checks that the current (WS_XML_NODE) node of reader is an end element,
//  and advances the reader to the next (WS_XML_NODE) node.
//  
HRESULT WINAPI WsReadEndElement(
    __in WS_XML_READER* reader, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Searches the attributes of the current element for an attribute with the
//  specified name and namespace and returns its index which may be passed
//  to WsReadStartAttribute.
//  
HRESULT WINAPI WsFindAttribute(
    __in WS_XML_READER* reader, 
    __in const WS_XML_STRING* localName, 
    __in const WS_XML_STRING* ns, 
    __in BOOL required, 
    __out ULONG* attributeIndex, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Reads text from the reader and parses it according to the specified value type.
//  
HRESULT WINAPI WsReadValue(
    __in WS_XML_READER* reader, 
    __in WS_VALUE_TYPE valueType, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Reads a specified number of text characters from the reader.
//  
HRESULT WINAPI WsReadChars(
    __in WS_XML_READER* reader, 
    __out_ecount_part(maxCharCount, *actualCharCount) WCHAR* chars, 
    __in ULONG maxCharCount, 
    __out ULONG* actualCharCount, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Reads a specified number of text characters from the reader and returns them encoded in UTF-8.
//  
HRESULT WINAPI WsReadCharsUtf8(
    __in WS_XML_READER* reader, 
    __out_ecount_part(maxByteCount, *actualByteCount) BYTE* bytes, 
    __in ULONG maxByteCount, 
    __out ULONG* actualByteCount, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Reads text from the reader and decodes the characters as bytes according to the base64 specification.
//  
HRESULT WINAPI WsReadBytes(
    __in WS_XML_READER* reader, 
    __out_bcount_part(maxByteCount, *actualByteCount) void* bytes, 
    __in ULONG maxByteCount, 
    __out ULONG* actualByteCount, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Reads a series of elements from the reader and interprets their
//  content according to the specified value type.
//  
HRESULT WINAPI WsReadArray(
    __in WS_XML_READER* reader, 
    __in const WS_XML_STRING* localName, 
    __in const WS_XML_STRING* ns, 
    __in WS_VALUE_TYPE valueType, 
    __out_bcount_opt(arraySize) void* array, 
    __in ULONG arraySize, 
    __in ULONG itemOffset, 
    __in ULONG itemCount, 
    __out ULONG* actualItemCount, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Returns the current position of the reader.  This can only be used on a reader
//  that is set to an XmlBuffer.
//  
HRESULT WINAPI WsGetReaderPosition(
    __in WS_XML_READER* reader, 
    __out WS_XML_NODE_POSITION* nodePosition, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Sets the current position of the reader.  The position must have been obtained by a call to
//   WsGetReaderPosition or WsGetWriterPosition.
//  
HRESULT WINAPI WsSetReaderPosition(
    __in WS_XML_READER* reader, 
    __in const WS_XML_NODE_POSITION* nodePosition, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Moves the current position of the reader as specified by the moveTo parameter.
//  
HRESULT WINAPI WsMoveReader(
    __in WS_XML_READER* reader, 
    __in WS_MOVE_TO moveTo, 
    __out_opt BOOL* found, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Creates an instance of a WS_XML_WRITER.  Use WsSetOutput or WsSetOutputToBuffer
//   to choose the encoding of the writer and to indicate where to direct the output.
//  
HRESULT WINAPI WsCreateWriter(
    __in_ecount_opt(propertyCount) const WS_XML_WRITER_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __deref_out WS_XML_WRITER** writer, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Releases the memory associated with the WS_XML_WRITER object.
//  
void WINAPI WsFreeWriter(__in WS_XML_WRITER* writer);


//  XML Writer function
//  
//   Sets the encoding and output callbacks for the writer.  The callbacks are used to
//  provides buffers to the writer and to perform asynchronous i/o.
//  
HRESULT WINAPI WsSetOutput(
    __in WS_XML_WRITER* writer, 
    __in_opt const WS_XML_WRITER_ENCODING* encoding, 
    __in_opt const WS_XML_WRITER_OUTPUT* output, 
    __in_ecount_opt(propertyCount) const WS_XML_WRITER_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Sets the writer to emit xml data at the end of the specified buffer.
//  
HRESULT WINAPI WsSetOutputToBuffer(
    __in WS_XML_WRITER* writer, 
    __in WS_XML_BUFFER* buffer, 
    __in_ecount_opt(propertyCount) const WS_XML_WRITER_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  Returns a property of the specified xml writer.
HRESULT WINAPI WsGetWriterProperty(
    __in WS_XML_WRITER* writer, 
    __in WS_XML_WRITER_PROPERTY_ID id, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Instructs the writer to invoke the (WS_WRITE_CALLBACK) callback
//   specified in WS_XML_WRITER_STREAM_OUTPUT if sufficient data has been buffered.
//  
HRESULT WINAPI WsFlushWriter(
    __in WS_XML_WRITER* writer, 
    __in ULONG minSize, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Writes a start element to the writer.
//  
HRESULT WINAPI WsWriteStartElement(
    __in WS_XML_WRITER* writer, 
    __in_opt const WS_XML_STRING* prefix, 
    __in const WS_XML_STRING* localName, 
    __in const WS_XML_STRING* ns, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Forces the writer to commit the current element and prevent further attributes
//  from being written to the element.
//  
HRESULT WINAPI WsWriteEndStartElement(
    __in WS_XML_WRITER* writer, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Writes an xmlns attribute to the current element.
//  
HRESULT WINAPI WsWriteXmlnsAttribute(
    __in WS_XML_WRITER* writer, 
    __in_opt const WS_XML_STRING* prefix, 
    __in const WS_XML_STRING* ns, 
    __in BOOL singleQuote, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Starts writing an attribute to the current element.
//  
HRESULT WINAPI WsWriteStartAttribute(
    __in WS_XML_WRITER* writer, 
    __in_opt const WS_XML_STRING* prefix, 
    __in const WS_XML_STRING* localName, 
    __in const WS_XML_STRING* ns, 
    __in BOOL singleQuote, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Finishes writing an attribute to the current element.
//  
HRESULT WINAPI WsWriteEndAttribute(
    __in WS_XML_WRITER* writer, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Writes a primitive value to the writer.
//  
HRESULT WINAPI WsWriteValue(
    __in WS_XML_WRITER* writer, 
    __in WS_VALUE_TYPE valueType, 
    __in_bcount(valueSize) const void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  XML Buffer function
//  
//   Writes a WS_XML_BUFFER to a writer.
//  
HRESULT WINAPI WsWriteXmlBuffer(
    __in WS_XML_WRITER* writer, 
    __in WS_XML_BUFFER* xmlBuffer, 
    __in_opt WS_ERROR* error);


//  XML Buffer function
//  
//   Reads the current node from a reader into a WS_XML_BUFFER.
//  
HRESULT WINAPI WsReadXmlBuffer(
    __in WS_XML_READER* reader, 
    __in WS_HEAP* heap, 
    __deref_out WS_XML_BUFFER** xmlBuffer, 
    __in_opt WS_ERROR* error);


//  XML Buffer function
//  
//   Uses a writer to convert a WS_XML_BUFFER to an encoded set of bytes.
//  
HRESULT WINAPI WsWriteXmlBufferToBytes(
    __in WS_XML_WRITER* writer, 
    __in WS_XML_BUFFER* xmlBuffer, 
    __in_opt const WS_XML_WRITER_ENCODING* encoding, 
    __in_ecount_opt(propertyCount) const WS_XML_WRITER_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __in WS_HEAP* heap, 
    __deref_out_bcount(*byteCount) void** bytes, 
    __out ULONG* byteCount, 
    __in_opt WS_ERROR* error);


//  XML Buffer function
//  
//   Uses a reader to convert a set of encoded bytes to a WS_XML_BUFFER.
//  
HRESULT WINAPI WsReadXmlBufferFromBytes(
    __in WS_XML_READER* reader, 
    __in_opt const WS_XML_READER_ENCODING* encoding, 
    __in_ecount_opt(propertyCount) const WS_XML_READER_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __in_bcount(byteCount) const void* bytes, 
    __in ULONG byteCount, 
    __in WS_HEAP* heap, 
    __deref_out WS_XML_BUFFER** xmlBuffer, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Writes a series of elements to the writer.
//  
HRESULT WINAPI WsWriteArray(
    __in WS_XML_WRITER* writer, 
    __in const WS_XML_STRING* localName, 
    __in const WS_XML_STRING* ns, 
    __in WS_VALUE_TYPE valueType, 
    __in_bcount_opt(arraySize) const void* array, 
    __in ULONG arraySize, 
    __in ULONG itemOffset, 
    __in ULONG itemCount, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Writes an xml qualified name to the writer.
//  
HRESULT WINAPI WsWriteQualifiedName(
    __in WS_XML_WRITER* writer, 
    __in_opt const WS_XML_STRING* prefix, 
    __in const WS_XML_STRING* localName, 
    __in_opt const WS_XML_STRING* ns, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Writes a series of characters to an element or attribute.
//  
HRESULT WINAPI WsWriteChars(
    __in WS_XML_WRITER* writer, 
    __in_ecount(charCount) const WCHAR* chars, 
    __in ULONG charCount, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Writes a series of characters encoded as UTF-8 to an element or attribute.
//  
HRESULT WINAPI WsWriteCharsUtf8(
    __in WS_XML_WRITER* writer, 
    __in_ecount(byteCount) const BYTE* bytes, 
    __in ULONG byteCount, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Writes bytes to the writer in a format optimized for the encoding.  When writing
//  in a text encoding, it will emit the bytes encoded in base64.  When writing to
//  a binary format, it will emit the bytes directly.
//  
HRESULT WINAPI WsWriteBytes(
    __in WS_XML_WRITER* writer, 
    __in_bcount(byteCount) const void* bytes, 
    __in ULONG byteCount, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Sets up a callback to be invoked to write bytes within an element.  In some encodings this can
//  be more efficient by eliminating a copy of the data.
//  
HRESULT WINAPI WsPushBytes(
    __in WS_XML_WRITER* writer, 
    __in WS_PUSH_BYTES_CALLBACK callback, 
    __in_opt void* callbackState, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Sets up a callback to be invoked to obtain the bytes to be written within an element.
//  In some encodings this can be more efficient by eliminating a copy of the data.
//  
HRESULT WINAPI WsPullBytes(
    __in WS_XML_WRITER* writer, 
    __in WS_PULL_BYTES_CALLBACK callback, 
    __in_opt void* callbackState, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Writes an end element to the writer.
//  
HRESULT WINAPI WsWriteEndElement(
    __in WS_XML_WRITER* writer, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Writes the specified text the XML writer.
//  
HRESULT WINAPI WsWriteText(
    __in WS_XML_WRITER* writer, 
    __in const WS_XML_TEXT* text, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Starts a CDATA section in the writer.
//  
HRESULT WINAPI WsWriteStartCData(
    __in WS_XML_WRITER* writer, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Ends a CDATA section in the writer.
//  
HRESULT WINAPI WsWriteEndCData(
    __in WS_XML_WRITER* writer, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Writes the specified node to the XML Writer.
//  
HRESULT WINAPI WsWriteNode(
    __in WS_XML_WRITER* writer, 
    __in const WS_XML_NODE* node, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Returns a prefix to which the namespace is bound.
//  
HRESULT WINAPI WsGetPrefixFromNamespace(
    __in WS_XML_WRITER* writer, 
    __in const WS_XML_STRING* ns, 
    __in BOOL required, 
    __deref_out const WS_XML_STRING** prefix, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Returns the current position of the writer.  This can only be used on a
//  writer that is set to an XmlBuffer. When writing to a buffer, the position
//  represents the xml node before which new data will be placed.
//  
HRESULT WINAPI WsGetWriterPosition(
    __in WS_XML_WRITER* writer, 
    __out WS_XML_NODE_POSITION* nodePosition, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Sets the current position of the writer.  The position must have been obtained by a
//  call to WsGetReaderPosition or WsGetWriterPosition.
//  
HRESULT WINAPI WsSetWriterPosition(
    __in WS_XML_WRITER* writer, 
    __in const WS_XML_NODE_POSITION* nodePosition, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Moves the current position of the writer as specified by the moveTo parameter.
//  
HRESULT WINAPI WsMoveWriter(
    __in WS_XML_WRITER* writer, 
    __in WS_MOVE_TO moveTo, 
    __out_opt BOOL* found, 
    __in_opt WS_ERROR* error);


//  XML Node function
//  
//   Removes leading and trailing whitespace from a sequence of characters.
//  
HRESULT WINAPI WsTrimXmlWhitespace(
    __in_ecount(charCount) WCHAR* chars, 
    __in ULONG charCount, 
    __deref_out_ecount(*trimmedCount) WCHAR** trimmedChars, 
    __out ULONG* trimmedCount, 
    __in_opt WS_ERROR* error);


//  XML Node function
//  
//   Verifies whether the input string is a valid XML NCName.
//  
HRESULT WINAPI WsVerifyXmlNCName(
    __in_ecount(ncNameCharCount) const WCHAR* ncNameChars, 
    __in ULONG ncNameCharCount, 
    __in_opt WS_ERROR* error);


//  XML Node function
//  
//   Compares two WS_XML_STRING's for equality by performing an ordinal comparison
//  of the character values.
//  
HRESULT WINAPI WsXmlStringEquals(
    __in const WS_XML_STRING* string1, 
    __in const WS_XML_STRING* string2, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Returns the namespace to which the prefix is bound.
//  
HRESULT WINAPI WsGetNamespaceFromPrefix(
    __in WS_XML_READER* reader, 
    __in const WS_XML_STRING* prefix, 
    __in BOOL required, 
    __deref_out const WS_XML_STRING** ns, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Reads a qualified name and separates it into its prefix, localName
//  and namespace based on the current namespace scope of the XML_READER.
//  If the ns parameter is specified, then the namespace that the prefix
//  is bound to will be returned, or WS_E_INVALID_FORMAT
//   will be returned. The strings are placed in the specified heap.
//  
HRESULT WINAPI WsReadQualifiedName(
    __in WS_XML_READER* reader, 
    __in WS_HEAP* heap, 
    __out_opt WS_XML_STRING* prefix, 
    __out WS_XML_STRING* localName, 
    __out_opt WS_XML_STRING* ns, 
    __in_opt WS_ERROR* error);


//  XML Reader function
//  
//   Finds the nearest xml attribute in scope with the specified localName and returns its value.
//  The returned value is placed on the specified heap.
//  
HRESULT WINAPI WsGetXmlAttribute(
    __in WS_XML_READER* reader, 
    __in const WS_XML_STRING* localName, 
    __in WS_HEAP* heap, 
    __deref_out_ecount_opt(*valueCharCount) WCHAR** valueChars, 
    __out ULONG* valueCharCount, 
    __in_opt WS_ERROR* error);


//  XML Writer function
//  
//   Copies the current node from the specified reader to the specified writer.
//  
HRESULT WINAPI WsCopyNode(
    __in WS_XML_WRITER* writer, 
    __in WS_XML_READER* reader, 
    __in_opt WS_ERROR* error);


//  Async Model function
//  
//   WsAsyncExecute is a helper that can be used to implement an asynchronous operation.
//  
HRESULT WINAPI WsAsyncExecute(
    __in WS_ASYNC_STATE* asyncState, 
    __in WS_ASYNC_FUNCTION operation, 
    __in WS_CALLBACK_MODEL callbackModel, 
    __in void* callbackState, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Create a channel used to initiate a message exchange to some endpoint.
//  
HRESULT WINAPI WsCreateChannel(
    __in WS_CHANNEL_TYPE channelType, 
    __in WS_CHANNEL_BINDING channelBinding, 
    __in_ecount_opt(propertyCount) const WS_CHANNEL_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __in_opt const WS_SECURITY_DESCRIPTION* securityDescription, 
    __deref_out WS_CHANNEL** channel, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Open a channel to an endpoint.
//  
HRESULT WINAPI WsOpenChannel(
    __in WS_CHANNEL* channel, 
    __in const WS_ENDPOINT_ADDRESS* endpointAddress, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Send a message on a channel using serialization to write the body element.
//  
HRESULT WINAPI WsSendMessage(
    __in WS_CHANNEL* channel, 
    __in WS_MESSAGE* message, 
    __in const WS_MESSAGE_DESCRIPTION* messageDescription, 
    __in WS_WRITE_OPTION writeOption, 
    __in_bcount_opt(bodyValueSize) const void* bodyValue, 
    __in ULONG bodyValueSize, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Receive a message and deserialize the body of the message as a value.
//  
HRESULT WINAPI WsReceiveMessage(
    __in WS_CHANNEL* channel, 
    __in WS_MESSAGE* message, 
    __in_ecount(messageDescriptionCount) const WS_MESSAGE_DESCRIPTION** messageDescriptions, 
    __in ULONG messageDescriptionCount, 
    __in WS_RECEIVE_OPTION receiveOption, 
    __in WS_READ_OPTION readBodyOption, 
    __in_opt WS_HEAP* heap, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __out_opt ULONG* index, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Used to send a request message and receive a correlated reply message.
//  
HRESULT WINAPI WsRequestReply(
    __in WS_CHANNEL* channel, 
    __in WS_MESSAGE* requestMessage, 
    __in const WS_MESSAGE_DESCRIPTION* requestMessageDescription, 
    __in WS_WRITE_OPTION writeOption, 
    __in_bcount_opt(requestBodyValueSize) const void* requestBodyValue, 
    __in ULONG requestBodyValueSize, 
    __in WS_MESSAGE* replyMessage, 
    __in const WS_MESSAGE_DESCRIPTION* replyMessageDescription, 
    __in WS_READ_OPTION readOption, 
    __in_opt WS_HEAP* heap, 
    __out_bcount_opt(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Sends a message which is a reply to a received message.
//  
HRESULT WINAPI WsSendReplyMessage(
    __in WS_CHANNEL* channel, 
    __in WS_MESSAGE* replyMessage, 
    __in const WS_MESSAGE_DESCRIPTION* replyMessageDescription, 
    __in WS_WRITE_OPTION writeOption, 
    __in_bcount_opt(replyBodyValueSize) const void* replyBodyValue, 
    __in ULONG replyBodyValueSize, 
    __in WS_MESSAGE* requestMessage, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Sends a fault message given a WS_ERROR object.
//  
HRESULT WINAPI WsSendFaultMessageForError(
    __in WS_CHANNEL* channel, 
    __in WS_MESSAGE* replyMessage, 
    __in WS_ERROR* faultError, 
    __in HRESULT faultErrorCode, 
    __in WS_FAULT_DISCLOSURE faultDisclosure, 
    __in WS_MESSAGE* requestMessage, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Retrieve a property of the channel.
//  
HRESULT WINAPI WsGetChannelProperty(
    __in WS_CHANNEL* channel, 
    __in WS_CHANNEL_PROPERTY_ID id, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Set a property of the channel.
//  
HRESULT WINAPI WsSetChannelProperty(
    __in WS_CHANNEL* channel, 
    __in WS_CHANNEL_PROPERTY_ID id, 
    __in_bcount(valueSize) const void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Write out all the headers of the message to the channel, and prepare to write the body elements.
//  
HRESULT WINAPI WsWriteMessageStart(
    __in WS_CHANNEL* channel, 
    __in WS_MESSAGE* message, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Write the closing elements of the message to the channel.
//  
HRESULT WINAPI WsWriteMessageEnd(
    __in WS_CHANNEL* channel, 
    __in WS_MESSAGE* message, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Read the headers of the next message from the channel, and prepare to read the body elements.
//  
HRESULT WINAPI WsReadMessageStart(
    __in WS_CHANNEL* channel, 
    __in WS_MESSAGE* message, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Read the closing elements of a message from a channel.
//  
HRESULT WINAPI WsReadMessageEnd(
    __in WS_CHANNEL* channel, 
    __in WS_MESSAGE* message, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Close a channel.
//  
HRESULT WINAPI WsCloseChannel(
    __in WS_CHANNEL* channel, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Abort all pending IO for a channel.
//  
HRESULT WINAPI WsAbortChannel(
    __in WS_CHANNEL* channel, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Free a channel.
//  
void WINAPI WsFreeChannel(__in WS_CHANNEL* channel);


//  Channel function
//  
//   Reset a channel so it can be reused.
//  
HRESULT WINAPI WsResetChannel(
    __in WS_CHANNEL* channel, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Used to skip the remainder of a message for a channel.
//  
HRESULT WINAPI WsAbandonMessage(
    __in WS_CHANNEL* channel, 
    __in WS_MESSAGE* message, 
    __in_opt WS_ERROR* error);


//  Channel function
//  
//   Used to signal the end of messages for a session channel.
//  
HRESULT WINAPI WsShutdownSessionChannel(
    __in WS_CHANNEL* channel, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Context function
//  
//   Returns a property of the specified operation context. It should be noted that the
//  validity of these property is limited to the lifetime of the operation context itself.
//  See Operation Context Lifetime and Threading for details around accessing
//  these properties and the lifetime of the operation context.
//  
HRESULT WINAPI WsGetOperationContextProperty(
    __in const WS_OPERATION_CONTEXT* context, 
    __in const WS_OPERATION_CONTEXT_PROPERTY_ID id, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Dictionaries function

HRESULT WINAPI WsGetDictionary(
    __in WS_ENCODING encoding, 
    __deref_out_opt WS_XML_DICTIONARY** dictionary, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Reads an extension of the WS_ENDPOINT_ADDRESS.
//  
HRESULT WINAPI WsReadEndpointAddressExtension(
    __in WS_XML_READER* reader, 
    __in WS_ENDPOINT_ADDRESS* endpointAddress, 
    __in WS_ENDPOINT_ADDRESS_EXTENSION_TYPE extensionType, 
    __in WS_READ_OPTION readOption, 
    __in WS_HEAP* heap, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Errors function
//  
//   Creates an error object that can passed to functions to in order to
//  record rich error information.
//  
HRESULT WINAPI WsCreateError(
    __in_ecount_opt(propertyCount) const WS_ERROR_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __deref_out WS_ERROR** error);


//  Errors function
//  
//   Add an error string to the error object.
//  
HRESULT WINAPI WsAddErrorString(
    __in WS_ERROR* error, 
    __in const WS_STRING* string);


//  Errors function
//  
//   Retrieves an error string from an error object.
//  
HRESULT WINAPI WsGetErrorString(
    __in WS_ERROR* error, 
    __in ULONG index, 
    __out WS_STRING* string);


//  Errors function
//  
//   Copies the error object from source to destination.
//  
HRESULT WINAPI WsCopyError(
    __in WS_ERROR* source, 
    __in WS_ERROR* destination);


//  Errors function
//  
//   Retrieve a property of the error.
//  
HRESULT WINAPI WsGetErrorProperty(
    __in WS_ERROR* error, 
    __in WS_ERROR_PROPERTY_ID id, 
    __out_bcount(bufferSize) void* buffer, 
    __in ULONG bufferSize);


//  Errors function
//  
//   Set a property of the error.
//  
HRESULT WINAPI WsSetErrorProperty(
    __in WS_ERROR* error, 
    __in WS_ERROR_PROPERTY_ID id, 
    __in_bcount(valueSize) const void* value, 
    __in ULONG valueSize);


//  Errors function
//  
//   Frees the contents of the error object, but does not free the error object itself.
//  
HRESULT WINAPI WsResetError(__in WS_ERROR* error);


//  Errors function
//  
//   Free the error object created by WsCreateError.
//  
void WINAPI WsFreeError(__in WS_ERROR* error);


//  Faults function
//  
//   Retrieve a fault-related property of the error object.
//  
HRESULT WINAPI WsGetFaultErrorProperty(
    __in WS_ERROR* error, 
    __in WS_FAULT_ERROR_PROPERTY_ID id, 
    __out_bcount(bufferSize) void* buffer, 
    __in ULONG bufferSize);


//  Faults function
//  
//   Set a fault-related property of the error object.
//  
HRESULT WINAPI WsSetFaultErrorProperty(
    __in WS_ERROR* error, 
    __in WS_FAULT_ERROR_PROPERTY_ID id, 
    __in_bcount(valueSize) const void* value, 
    __in ULONG valueSize);


//  Faults function
//  
//   Construct a WS_FAULT given an error object.
//  
HRESULT WINAPI WsCreateFaultFromError(
    __in WS_ERROR* error, 
    __in HRESULT faultErrorCode, 
    __in WS_FAULT_DISCLOSURE faultDisclosure, 
    __in WS_HEAP* heap, 
    __out WS_FAULT* fault);


//  Faults function
//  
//   Write the fault detail stored in a WS_ERROR object.
//  
HRESULT WINAPI WsSetFaultErrorDetail(
    __in WS_ERROR* error, 
    __in const WS_FAULT_DETAIL_DESCRIPTION* faultDetailDescription, 
    __in WS_WRITE_OPTION writeOption, 
    __in_bcount_opt(valueSize) const void* value, 
    __in ULONG valueSize);


//  Faults function
//  
//   Read the fault detail stored in a WS_ERROR object.
//  
HRESULT WINAPI WsGetFaultErrorDetail(
    __in WS_ERROR* error, 
    __in const WS_FAULT_DETAIL_DESCRIPTION* faultDetailDescription, 
    __in WS_READ_OPTION readOption, 
    __in_opt WS_HEAP* heap, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize);


//  Heap function
//  
//   Create a heap object.
//  
HRESULT WINAPI WsCreateHeap(
    __in SIZE_T maxSize, 
    __in SIZE_T trimSize, 
    __in_opt const WS_HEAP_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __deref_out WS_HEAP** heap, 
    __in_opt WS_ERROR* error);


//  Heap function
//  Allocate a chunk of data from the heap.
HRESULT WINAPI WsAlloc(
    __in WS_HEAP* heap, 
    __in SIZE_T size, 
    __deref_out_bcount(size) void** ptr, 
    __in_opt WS_ERROR* error);


//  Heap function
//  Returns a property of the specified heap.
HRESULT WINAPI WsGetHeapProperty(
    __in WS_HEAP* heap, 
    __in WS_HEAP_PROPERTY_ID id, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Heap function
//  
//   This resets the heap to have no allocations.  All allocations made on the heap
//  using WsAlloc are no longer valid.  However, this call does not actually
//  free the heap object.
//  
HRESULT WINAPI WsResetHeap(
    __in WS_HEAP* heap, 
    __in_opt WS_ERROR* error);


//  Heap function
//  
//   This frees the heap object, and the memory associated with any allocations
//  made on it using WsAlloc.
//  
void WINAPI WsFreeHeap(__in WS_HEAP* heap);


//  Listener function
//  
//   Create a listener object.
//  
HRESULT WINAPI WsCreateListener(
    __in WS_CHANNEL_TYPE channelType, 
    __in WS_CHANNEL_BINDING channelBinding, 
    __in_ecount_opt(propertyCount) const WS_LISTENER_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __in_opt const WS_SECURITY_DESCRIPTION* securityDescription, 
    __deref_out WS_LISTENER** listener, 
    __in_opt WS_ERROR* error);


//  Listener function
//  
//   Start listening.
//  
HRESULT WINAPI WsOpenListener(
    __in WS_LISTENER* listener, 
    __in const WS_STRING* url, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Listener function
//  
//   Accepts the next incoming message exchange from a listener.
//  
HRESULT WINAPI WsAcceptChannel(
    __in WS_LISTENER* listener, 
    __in WS_CHANNEL* channel, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Listener function
//  
//   Stop listening.
//  
HRESULT WINAPI WsCloseListener(
    __in WS_LISTENER* listener, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Listener function
//  
//   Cancel any pending IO for the listener.
//  
HRESULT WINAPI WsAbortListener(
    __in WS_LISTENER* listener, 
    __in_opt WS_ERROR* error);


//  Listener function
//  
//   Reset a listener so it can be reused.
//  
HRESULT WINAPI WsResetListener(
    __in WS_LISTENER* listener, 
    __in_opt WS_ERROR* error);


//  Listener function
//  
//   Free the listener.
//  
void WINAPI WsFreeListener(__in WS_LISTENER* listener);


//  Listener function
//  
//   Retrieve a property of the listener.
//  
HRESULT WINAPI WsGetListenerProperty(
    __in WS_LISTENER* listener, 
    __in WS_LISTENER_PROPERTY_ID id, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Listener function
//  
//   Set a property of the listener.
//  
HRESULT WINAPI WsSetListenerProperty(
    __in WS_LISTENER* listener, 
    __in WS_LISTENER_PROPERTY_ID id, 
    __in_bcount(valueSize) const void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Listener function
//  
//   Create a channel that is used to accept incoming message exchanges from a listener.
//  
HRESULT WINAPI WsCreateChannelForListener(
    __in WS_LISTENER* listener, 
    __in_ecount_opt(propertyCount) const WS_CHANNEL_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __deref_out WS_CHANNEL** channel, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Creates a message object.
//  
HRESULT WINAPI WsCreateMessage(
    __in WS_ENVELOPE_VERSION envelopeVersion, 
    __in WS_ADDRESSING_VERSION addressingVersion, 
    __in_ecount_opt(propertyCount) const WS_MESSAGE_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __deref_out WS_MESSAGE** message, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Creates a message that is appropriate for use with a particular channel.
//  
HRESULT WINAPI WsCreateMessageForChannel(
    __in WS_CHANNEL* channel, 
    __in_ecount_opt(propertyCount) const WS_MESSAGE_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __deref_out WS_MESSAGE** message, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Sets up the initial set of headers for the message in preparation for
//  sending/writing the message.
//  
HRESULT WINAPI WsInitializeMessage(
    __in WS_MESSAGE* message, 
    __in WS_MESSAGE_INITIALIZATION initialization, 
    __in_opt WS_MESSAGE* sourceMessage, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Prepare the message for reuse.
//  
HRESULT WINAPI WsResetMessage(
    __in WS_MESSAGE* message, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Releases the memory associated with the message object.
//  
void WINAPI WsFreeMessage(__in WS_MESSAGE* message);


//  Message function
//  
//   Returns the WS_HEADER_ATTRIBUTES for the header element the reader is positioned on.  The
//  envelope version of the message is used to determine which attributes to return.
//  
HRESULT WINAPI WsGetHeaderAttributes(
    __in WS_MESSAGE* message, 
    __in WS_XML_READER* reader, 
    __out ULONG* headerAttributes, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Finds a particular standard header in the message and deserializes it.
//  
HRESULT WINAPI WsGetHeader(
    __in WS_MESSAGE* message, 
    __in WS_HEADER_TYPE headerType, 
    __in WS_TYPE valueType, 
    __in WS_READ_OPTION readOption, 
    __in_opt WS_HEAP* heap, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Finds an application-defined header of the message and deserializes it.
//  
HRESULT WINAPI WsGetCustomHeader(
    __in WS_MESSAGE* message, 
    __in const WS_ELEMENT_DESCRIPTION* customHeaderDescription, 
    __in WS_REPEATING_HEADER_OPTION repeatingOption, 
    __in ULONG headerIndex, 
    __in WS_READ_OPTION readOption, 
    __in_opt WS_HEAP* heap, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __out_opt ULONG* headerAttributes, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Removes all instances of the specified standard header from the message.
//  
HRESULT WINAPI WsRemoveHeader(
    __in WS_MESSAGE* message, 
    __in WS_HEADER_TYPE headerType, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Adds or replaces the specified standard header in the message.
//  
HRESULT WINAPI WsSetHeader(
    __in WS_MESSAGE* message, 
    __in WS_HEADER_TYPE headerType, 
    __in WS_TYPE valueType, 
    __in WS_WRITE_OPTION writeOption, 
    __in_bcount(valueSize) const void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Removes all instances of the application defined header from the message.
//  
HRESULT WINAPI WsRemoveCustomHeader(
    __in WS_MESSAGE* message, 
    __in const WS_XML_STRING* headerName, 
    __in const WS_XML_STRING* headerNs, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Adds the specified application defined header to the message.
//  
HRESULT WINAPI WsAddCustomHeader(
    __in WS_MESSAGE* message, 
    __in const WS_ELEMENT_DESCRIPTION* headerDescription, 
    __in WS_WRITE_OPTION writeOption, 
    __in_bcount(valueSize) const void* value, 
    __in ULONG valueSize, 
    __in ULONG headerAttributes, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Adds a specified mapped header to the message.
//  
HRESULT WINAPI WsAddMappedHeader(
    __in WS_MESSAGE* message, 
    __in const WS_XML_STRING* headerName, 
    __in WS_TYPE valueType, 
    __in WS_WRITE_OPTION writeOption, 
    __in_bcount(valueSize) const void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Removes all instances of a mapped header from the message.
//  
HRESULT WINAPI WsRemoveMappedHeader(
    __in WS_MESSAGE* message, 
    __in const WS_XML_STRING* headerName, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Finds a mapped header in the message and deserializes it.
//  
HRESULT WINAPI WsGetMappedHeader(
    __in WS_MESSAGE* message, 
    __in const WS_XML_STRING* headerName, 
    __in WS_REPEATING_HEADER_OPTION repeatingOption, 
    __in ULONG headerIndex, 
    __in WS_TYPE valueType, 
    __in WS_READ_OPTION readOption, 
    __in_opt WS_HEAP* heap, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Serialize a value in the body of the message.
//  
HRESULT WINAPI WsWriteBody(
    __in WS_MESSAGE* message, 
    __in const WS_ELEMENT_DESCRIPTION* bodyDescription, 
    __in WS_WRITE_OPTION writeOption, 
    __in_bcount(valueSize) const void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Deserialize a value from the body of the message.
//  
HRESULT WINAPI WsReadBody(
    __in WS_MESSAGE* message, 
    __in const WS_ELEMENT_DESCRIPTION* bodyDescription, 
    __in WS_READ_OPTION readOption, 
    __in_opt WS_HEAP* heap, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Write out all the headers of the message and prepare to write the body elements.
//  
HRESULT WINAPI WsWriteEnvelopeStart(
    __in WS_MESSAGE* message, 
    __in WS_XML_WRITER* writer, 
    __in_opt WS_MESSAGE_DONE_CALLBACK doneCallback, 
    __in_opt void* doneCallbackState, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Write the closing elements of the message.
//  
HRESULT WINAPI WsWriteEnvelopeEnd(
    __in WS_MESSAGE* message, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Read the headers of the message and prepare to read the body elements.
//  
HRESULT WINAPI WsReadEnvelopeStart(
    __in WS_MESSAGE* message, 
    __in WS_XML_READER* reader, 
    __in_opt WS_MESSAGE_DONE_CALLBACK doneCallback, 
    __in_opt void* doneCallbackState, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Read the closing elements of a message.
//  
HRESULT WINAPI WsReadEnvelopeEnd(
    __in WS_MESSAGE* message, 
    __in_opt WS_ERROR* error);


//  Message function
//  Returns a property of the specified message.
HRESULT WINAPI WsGetMessageProperty(
    __in WS_MESSAGE* message, 
    __in WS_MESSAGE_PROPERTY_ID id, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Set a property of the message.
//  
HRESULT WINAPI WsSetMessageProperty(
    __in WS_MESSAGE* message, 
    __in WS_MESSAGE_PROPERTY_ID id, 
    __in_bcount(valueSize) const void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Addresses a message given an Endpoint Address.
//  
HRESULT WINAPI WsAddressMessage(
    __in WS_MESSAGE* message, 
    __in_opt const WS_ENDPOINT_ADDRESS* address, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Verifies that all headers that were specified to be required to be
//  understood by the receiver were actually understood.
//  
HRESULT WINAPI WsCheckMustUnderstandHeaders(
    __in WS_MESSAGE* message, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Marks a header as one that was understood by the application.
//  
HRESULT WINAPI WsMarkHeaderAsUnderstood(
    __in WS_MESSAGE* message, 
    __in const WS_XML_NODE_POSITION* headerPosition, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Ensures that the message has at least a specified amount of body data available to it for reading.
//  
HRESULT WINAPI WsFillBody(
    __in WS_MESSAGE* message, 
    __in ULONG minSize, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Message function
//  
//   Flushes all accumulated body data that has been written for the message.
//  
HRESULT WINAPI WsFlushBody(
    __in WS_MESSAGE* message, 
    __in ULONG minSize, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Security Bindings function
//  
//   Get a security token from a security token service (STS) that acts as
//  the token issuer in a (Federation) federation scenario.
//  This function is used on the client side, and performs the WS-Trust
//  based negotiation steps with the STS until the security token is
//  obtained or the negotiation process fails.
//  
HRESULT WINAPI WsRequestSecurityToken(
    __in WS_CHANNEL* channel, 
    __in_ecount_opt(propertyCount) const WS_REQUEST_SECURITY_TOKEN_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __deref_out WS_SECURITY_TOKEN** token, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Security Processing Results function
//  
//   Extract a field or a property from a security token. If the queried property does not use the 'heap' parameter, the returned
//  data is owned by the security token and remains valid as long as the security token itself remains valid. Specifically, for
//  security tokens extracted from a received message, the security token and fields extracted from it are valid only as long as
//  the message is not reset or freed.
//   If the 'heap' parameter is required by the property, then the returned data is stored on the heap, with its lifetime
//  detached from the underlying token.
//  
HRESULT WINAPI WsGetSecurityTokenProperty(
    __in WS_SECURITY_TOKEN* securityToken, 
    __in WS_SECURITY_TOKEN_PROPERTY_ID id, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_HEAP* heap, 
    __in_opt WS_ERROR* error);


//  Security Bindings function
//  
//  Create a security token from its XML form.
//  
HRESULT WINAPI WsCreateXmlSecurityToken(
    __in_opt WS_XML_BUFFER* tokenXml, 
    __in_opt WS_SECURITY_KEY_HANDLE* tokenKey, 
    __in_ecount_opt(propertyCount) const WS_XML_SECURITY_TOKEN_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __deref_out WS_SECURITY_TOKEN** token, 
    __in_opt WS_ERROR* error);


//  Security Bindings function
//  
//   Free a security token.
//  
void WINAPI WsFreeSecurityToken(__in WS_SECURITY_TOKEN* token);


//  Security Context function
//  
//   Revokes a security context. Can only be called on the server side.
//  
//   This function can be used when the server knows that no more messages are
//  coming and does not want to wait for the client or the context timeouts to
//  trigger the reclaiming of resources, or when the server wants to engage in
//  active context management.
//  
HRESULT WINAPI WsRevokeSecurityContext(
    __in WS_SECURITY_CONTEXT* securityContext, 
    __in_opt WS_ERROR* error);


//  Security Context function
//  
//   Gets a property of the specified security context.
//  
HRESULT WINAPI WsGetSecurityContextProperty(
    __in WS_SECURITY_CONTEXT* securityContext, 
    __in WS_SECURITY_CONTEXT_PROPERTY_ID id, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Serialization function
//  
//   Read an element producing a value of the specified WS_TYPE.
//  
HRESULT WINAPI WsReadElement(
    __in WS_XML_READER* reader, 
    __in const WS_ELEMENT_DESCRIPTION* elementDescription, 
    __in WS_READ_OPTION readOption, 
    __in_opt WS_HEAP* heap, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Serialization function
//  
//   Read an attribute producing a value of the specified WS_TYPE.
//  
HRESULT WINAPI WsReadAttribute(
    __in WS_XML_READER* reader, 
    __in const WS_ATTRIBUTE_DESCRIPTION* attributeDescription, 
    __in WS_READ_OPTION readOption, 
    __in_opt WS_HEAP* heap, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Serialization function
//  
//   Read a value of a given WS_TYPE from XML according to the WS_TYPE_MAPPING.
//  
HRESULT WINAPI WsReadType(
    __in WS_XML_READER* reader, 
    __in WS_TYPE_MAPPING typeMapping, 
    __in WS_TYPE type, 
    __in_opt const void* typeDescription, 
    __in WS_READ_OPTION readOption, 
    __in_opt WS_HEAP* heap, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Serialization function
//  
//   Write a typed value as an XML element.
//  
HRESULT WINAPI WsWriteElement(
    __in WS_XML_WRITER* writer, 
    __in const WS_ELEMENT_DESCRIPTION* elementDescription, 
    __in WS_WRITE_OPTION writeOption, 
    __in_bcount_opt(valueSize) const void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Serialization function
//  
//   Write a typed value as an XML attribute.
//  
HRESULT WINAPI WsWriteAttribute(
    __in WS_XML_WRITER* writer, 
    __in const WS_ATTRIBUTE_DESCRIPTION* attributeDescription, 
    __in WS_WRITE_OPTION writeOption, 
    __in_bcount_opt(valueSize) const void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Serialization function
//  
//   Write a value of a given WS_TYPE to XML according to the WS_TYPE_MAPPING.
//  
HRESULT WINAPI WsWriteType(
    __in WS_XML_WRITER* writer, 
    __in WS_TYPE_MAPPING typeMapping, 
    __in WS_TYPE type, 
    __in_opt const void* typeDescription, 
    __in WS_WRITE_OPTION writeOption, 
    __in_bcount_opt(valueSize) const void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Call cancellation function
//  
//   A service operation can use this function to register for a cancel notification.
//  It is only valid to call this API when the service operation is executing. The behavior
//  for calling it after the completion of Service Operation is not supported.
//  
//   While this API is being called and the runtime has determined that the cancellation of the
//  service operation is necessary, it can call the callback during the call to this API by the application.
//  
//   The caller should therefore assume that the runtime may call on the callback
//   WS_OPERATION_CANCEL_CALLBACK as soon as the WsRegisterOperationForCancel is called.
//  
HRESULT WINAPI WsRegisterOperationForCancel(
    __in const WS_OPERATION_CONTEXT* context, 
    __in WS_OPERATION_CANCEL_CALLBACK cancelCallback, 
    __in_opt WS_OPERATION_FREE_STATE_CALLBACK freestateCallback, 
    __in_opt void* userState, 
    __in_opt WS_ERROR* error);


//  Service Host function
//  
//   Retrieve a property of the service host.
//  
HRESULT WINAPI WsGetServiceHostProperty(
    __in WS_SERVICE_HOST* serviceHost, 
    __in const WS_SERVICE_PROPERTY_ID id, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Service Host function
//  
//   Create a service host.
//  
HRESULT WINAPI WsCreateServiceHost(
    __in_ecount_opt(endpointCount) const WS_SERVICE_ENDPOINT** endpoints, 
    __in const USHORT endpointCount, 
    __in_ecount_opt(servicePropertyCount) const WS_SERVICE_PROPERTY* serviceProperties, 
    __in ULONG servicePropertyCount, 
    __deref_out WS_SERVICE_HOST** serviceHost, 
    __in_opt WS_ERROR* error);


//  Service Host function
//  
//   Open a service host for communication. Starts the listeners on all the endpoints.
//  
HRESULT WINAPI WsOpenServiceHost(
    __in WS_SERVICE_HOST* serviceHost, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Service Host function
//  
//   Closes down a service host for communication.
//  
//   During WsCloseServiceHost all the listeners are closed such that no new
//  channels are accepted from the client. Work on  channels already accepted
//  before WsCloseServiceHost closed the listeners, is allowed to complete.
//  This has special implications for endpoints configured to run with session
//  based channel binding. If a client has a session opened to the service, the
//  close will not complete till the client closes the session with the service.
//  
HRESULT WINAPI WsCloseServiceHost(
    __in WS_SERVICE_HOST* serviceHost, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Service Host function
//  
//   Aborts the current operation on the service host.
//  
HRESULT WINAPI WsAbortServiceHost(
    __in WS_SERVICE_HOST* serviceHost, 
    __in_opt WS_ERROR* error);


//  Service Host function
//  Free's the service host.
void WINAPI WsFreeServiceHost(__in WS_SERVICE_HOST* serviceHost);


//  Service Host function
//  
//   Resets service host so that it can be opened again.
//  
//   Rather the creating a new service host from scratch WsResetServiceHost
//  provides a convenient way to reuse service host. Specifically in a scenario
//  where a service host has to go through close and open on a regular basis,
//  this allows for an efficient way for reusing the same service host. It resets
//  the underlying channel and listeners for reuse.
//  
HRESULT WINAPI WsResetServiceHost(
    __in WS_SERVICE_HOST* serviceHost, 
    __in_opt WS_ERROR* error);


//  Service Proxy function
//  
//   Retrieve a property of service proxy.
//  
HRESULT WINAPI WsGetServiceProxyProperty(
    __in WS_SERVICE_PROXY* serviceProxy, 
    __in const WS_PROXY_PROPERTY_ID id, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Service Proxy function
//  
//   Creates a service proxy.
//  
HRESULT WINAPI WsCreateServiceProxy(
    __in const WS_CHANNEL_TYPE channelType, 
    __in const WS_CHANNEL_BINDING channelBinding, 
    __in_opt const WS_SECURITY_DESCRIPTION* securityDescription, 
    __in_ecount_opt(propertyCount) const WS_PROXY_PROPERTY* properties, 
    __in const ULONG propertyCount, 
    __in_ecount_opt(channelPropertyCount) const WS_CHANNEL_PROPERTY* channelProperties, 
    __in const ULONG channelPropertyCount, 
    __deref_out WS_SERVICE_PROXY** serviceProxy, 
    __in_opt WS_ERROR* error);


//  Service Proxy function
//  
//   Opens the service proxy to a service endpoint.
//  
//   Once the operation succeeds, application can now go ahead and make calls on the service proxy.
//  
HRESULT WINAPI WsOpenServiceProxy(
    __in WS_SERVICE_PROXY* serviceProxy, 
    __in const WS_ENDPOINT_ADDRESS* address, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Service Proxy function
//  
//   Closes a service proxy for communication.
//  
//   Close performs the following tasks in given order
//  
//  .If a service operation call is pending on the service proxy, close will wait for each call to complete.
//  
//  .If the proxy was created with session based channel binding this will close the underlying channel.
//  
//   During this calls are accepted by the service proxy.
//  
HRESULT WINAPI WsCloseServiceProxy(
    __in WS_SERVICE_PROXY* serviceProxy, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Service Proxy function
//  
//   Aborts the service proxy.
//  
//   Aborts cancel all I/O if any on the service proxy.
//  WsAbortServiceProxy: During Open or WS_SERVICE_PROXY_STATE_OPENING state
//   WsAbortServiceProxy can be used to abort the open operation. The service proxy will
//  cancel all pending I/O and transition back to WS_SERVICE_PROXY_STATE_CREATED state.
//  WsAbortServiceProxy: While making calls or WS_SERVICE_PROXY_STATE_OPEN state
//   WsAbortServiceProxy will abort all the underlying channels. The service proxy is transitioned to
//  to WS_SERVICE_PROXY_STATE_FAULTED. Once abort is initiated service proxy will
//  not accept any new calls. The application can call WsCloseServiceProxy to close it.
//  WsAbortServiceProxy: During Close or WS_SERVICE_PROXY_STATE_CLOSING state
//   During close, all underlying channels are aborted. The service proxy is transitioned to the
//   WS_SERVICE_PROXY_STATE_CLOSED state.
//  
HRESULT WINAPI WsAbortServiceProxy(
    __in WS_SERVICE_PROXY* serviceProxy, 
    __in_opt WS_ERROR* error);


//  Service Proxy function
//  Free's a service proxy.
void WINAPI WsFreeServiceProxy(__in WS_SERVICE_PROXY* serviceProxy);


//  Service Proxy function
//  Resets service proxy.
//   WsResetServiceProxy provides a convenient way to reuse the service proxy.
//  Once the proxy is (WS_SERVICE_PROXY_STATE) closed,
//  the application can call WsResetServiceProxy to reuse it.
//  
//   Reusing the service proxy is helpful in scenarios where an application connects
//  to the same service time and time again. The cost of initialization is only paid
//  once during the initial creation of the service proxy.
//  
HRESULT WINAPI WsResetServiceProxy(
    __in WS_SERVICE_PROXY* serviceProxy, 
    __in_opt WS_ERROR* error);


//  Service Proxy function
//  
//   Abandons a call identified by the callId on the given (Service Proxy) service proxy.
//  
//   An applications must be careful with the usage of this operation. Since the actual I/O specific
//  to the call is not canceled. The service proxy will keep the resources for the abandoned call
//  around to complete call.
//  
//   This consumption of resources can be aggravated if the application continues to abandon more
//  and more calls. This aggravation usually results if the server is slow to respond back to the
//  client. Mean while if the application continues to make more calls on the service proxy that
//  can further aggravate the situation.
//  
HRESULT WINAPI WsAbandonCall(
    __in WS_SERVICE_PROXY* serviceProxy, 
    __in ULONG callId, 
    __in_opt WS_ERROR* error);


//  Service Proxy function
//  
//   Using the passed in (WS_OPERATION_DESCRIPTION) operation parameter packs
//  the arguments into a message and sends it over the channel.
//  
//   This function is internally used by proxy service operation. The application should
//  never call it directly.
//  
HRESULT WINAPI WsCall(
    __in WS_SERVICE_PROXY* serviceProxy, 
    __in const WS_OPERATION_DESCRIPTION* operation, 
    __in_opt const void** arguments, 
    __in WS_HEAP* heap, 
    __in_ecount_opt(callPropertyCount) const WS_CALL_PROPERTY* callProperties, 
    __in const ULONG callPropertyCount, 
    __in_opt const WS_ASYNC_CONTEXT* asyncContext, 
    __in_opt WS_ERROR* error);


//  Url function
//  Decodes an URL into its component parts.
HRESULT WINAPI WsDecodeUrl(
    __in const WS_STRING* url, 
    __in ULONG flags, 
    __in WS_HEAP* heap, 
    __deref_out WS_URL** outUrl, 
    __in_opt WS_ERROR* error);


//  Url function
//  Encodes an URL into a string given its component parts.
HRESULT WINAPI WsEncodeUrl(
    __in const WS_URL* url, 
    __in ULONG flags, 
    __in WS_HEAP* heap, 
    __out WS_STRING* outUrl, 
    __in_opt WS_ERROR* error);


//  Url function
//  
//   Produces an absolute URL given a URL reference (absolute or relative URL) and an absolute base URL.
//  
HRESULT WINAPI WsCombineUrl(
    __in const WS_STRING* baseUrl, 
    __in const WS_STRING* referenceUrl, 
    __in ULONG flags, 
    __in WS_HEAP* heap, 
    __out WS_STRING* resultUrl, 
    __in_opt WS_ERROR* error);


//  Utilities function
//  
//   Converts a WS_DATETIME to a FILETIME.
//  
HRESULT WINAPI WsDateTimeToFileTime(
    __in const WS_DATETIME* dateTime, 
    __out FILETIME* fileTime, 
    __in_opt WS_ERROR* error);


//  Utilities function
//  
//   Converts a FILETIME to a WS_DATETIME.
//  
HRESULT WINAPI WsFileTimeToDateTime(
    __in const FILETIME* fileTime, 
    __out WS_DATETIME* dateTime, 
    __in_opt WS_ERROR* error);


//  Metadata Import function
//  
//   Create a metadata object which is used to collect and process metadata documents.
//  
HRESULT WINAPI WsCreateMetadata(
    __in_ecount_opt(propertyCount) const WS_METADATA_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __deref_out WS_METADATA** metadata, 
    __in_opt WS_ERROR* error);


//  Metadata Import function
//  
//   Read a metadata element and add it to the set of metadata
//  documents stored in the metadata object.
//  
HRESULT WINAPI WsReadMetadata(
    __in WS_METADATA* metadata, 
    __in WS_XML_READER* reader, 
    __in const WS_STRING* url, 
    __in_opt WS_ERROR* error);


//  Metadata Import function
//  
//   Free a metadata object.
//  
void WINAPI WsFreeMetadata(__in WS_METADATA* metadata);


//  Metadata Import function
//  
//   Reset a metadata object so it can be reused.
//  
HRESULT WINAPI WsResetMetadata(
    __in WS_METADATA* metadata, 
    __in_opt WS_ERROR* error);


//  Metadata Import function
//  
//   Retrieve a property of the metadata object.
//  
HRESULT WINAPI WsGetMetadataProperty(
    __in WS_METADATA* metadata, 
    __in WS_METADATA_PROPERTY_ID id, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Metadata Import function
//  
//   Returns the address of a missing document that is referenced by the metadata object.
//  
HRESULT WINAPI WsGetMissingMetadataDocumentAddress(
    __in WS_METADATA* metadata, 
    __deref_out_opt WS_ENDPOINT_ADDRESS** address, 
    __in_opt WS_ERROR* error);


//  Metadata Import function
//  
//   Returns the endpoints that were defined in the metadata documents
//  that were added to the metadata object.
//  
HRESULT WINAPI WsGetMetadataEndpoints(
    __in WS_METADATA* metadata, 
    __out WS_METADATA_ENDPOINTS* endpoints, 
    __in_opt WS_ERROR* error);


//  Metadata Import function
//  
//   This function tests to see if a particular policy alternative is compatible
//  with the specified policy constraint structures.  If the alternative is compatible,
//  then the "out" fields within the constraint structures are filled with information
//  from the policy.
//  
HRESULT WINAPI WsMatchPolicyAlternative(
    __in WS_POLICY* policy, 
    __in ULONG alternativeIndex, 
    __in WS_POLICY_CONSTRAINTS* policyConstraints, 
    __in BOOL matchRequired, 
    __in WS_HEAP* heap, 
    __in_opt WS_ERROR* error);


//  Metadata Import function
//  
//   Retrieve a property of the policy object.
//  
HRESULT WINAPI WsGetPolicyProperty(
    __in WS_POLICY* policy, 
    __in WS_POLICY_PROPERTY_ID id, 
    __out_bcount(valueSize) void* value, 
    __in ULONG valueSize, 
    __in_opt WS_ERROR* error);


//  Metadata Import function
//  
//   Retrieve the number of alternatives available in the policy object.
//  
HRESULT WINAPI WsGetPolicyAlternativeCount(
    __in WS_POLICY* policy, 
    __out ULONG* count, 
    __in_opt WS_ERROR* error);


//  Policy Support function
//  
//   Helper routine to create channel from policy templates.
//  
HRESULT WINAPI WsCreateServiceProxyFromTemplate(
    __in WS_CHANNEL_TYPE channelType, 
    __in_ecount_opt(propertyCount) const WS_PROXY_PROPERTY* properties, 
    __in const ULONG propertyCount, 
    __in WS_BINDING_TEMPLATE_TYPE templateType, 
    __in_bcount_opt(templateSize) void* templateValue, 
    __in ULONG templateSize, 
    __in const void* templateDescription, 
    __in ULONG templateDescriptionSize, 
    __deref_out WS_SERVICE_PROXY** serviceProxy, 
    __in_opt WS_ERROR* error);


//  Policy Support function
//  
//   Helper routine to create channel from policy templates.
//  
HRESULT WINAPI WsCreateServiceEndpointFromTemplate(
    __in WS_CHANNEL_TYPE channelType, 
    __in const WS_SERVICE_ENDPOINT_PROPERTY* properties, 
    __in ULONG propertyCount, 
    __in_opt const WS_STRING* addressUrl, 
    __in const WS_SERVICE_CONTRACT* contract, 
    __in WS_SERVICE_SECURITY_CALLBACK authorizationCallback, 
    __in WS_HEAP* heap, 
    __in WS_BINDING_TEMPLATE_TYPE templateType, 
    __in_bcount_opt(templateSize) void* templateValue, 
    __in ULONG templateSize, 
    __in const void* templateDescription, 
    __in ULONG templateDescriptionSize, 
    __deref_out WS_SERVICE_ENDPOINT** serviceEndpoint, 
    __in_opt WS_ERROR* error);


//  ERROR DEFINITIONS
#ifndef FACILITY_WEBSERVICES
#define FACILITY_WEBSERVICES                    0x3d
#define WS_S_ASYNC                              0x003D0000
#define WS_S_END                                0x003D0001
#define WS_E_INVALID_FORMAT                     0x803D0000
#define WS_E_OBJECT_FAULTED                     0x803D0001
#define WS_E_NUMERIC_OVERFLOW                   0x803D0002
#define WS_E_INVALID_OPERATION                  0x803D0003
#define WS_E_OPERATION_ABORTED                  0x803D0004
#define WS_E_ENDPOINT_ACCESS_DENIED             0x803D0005
#define WS_E_OPERATION_TIMED_OUT                0x803D0006
#define WS_E_OPERATION_ABANDONED                0x803D0007
#define WS_E_QUOTA_EXCEEDED                     0x803D0008
#define WS_E_NO_TRANSLATION_AVAILABLE           0x803D0009
#define WS_E_SECURITY_VERIFICATION_FAILURE      0x803D000A
#define WS_E_ADDRESS_IN_USE                     0x803D000B
#define WS_E_ADDRESS_NOT_AVAILABLE              0x803D000C
#define WS_E_ENDPOINT_NOT_FOUND                 0x803D000D
#define WS_E_ENDPOINT_NOT_AVAILABLE             0x803D000E
#define WS_E_ENDPOINT_FAILURE                   0x803D000F
#define WS_E_ENDPOINT_UNREACHABLE               0x803D0010
#define WS_E_ENDPOINT_ACTION_NOT_SUPPORTED      0x803D0011
#define WS_E_ENDPOINT_TOO_BUSY                  0x803D0012
#define WS_E_ENDPOINT_FAULT_RECEIVED            0x803D0013
#define WS_E_ENDPOINT_DISCONNECTED              0x803D0014
#define WS_E_PROXY_FAILURE                      0x803D0015
#define WS_E_PROXY_ACCESS_DENIED                0x803D0016
#define WS_E_NOT_SUPPORTED                      0x803D0017
#define WS_E_PROXY_REQUIRES_BASIC_AUTH          0x803D0018
#define WS_E_PROXY_REQUIRES_DIGEST_AUTH         0x803D0019
#define WS_E_PROXY_REQUIRES_NTLM_AUTH           0x803D001A
#define WS_E_PROXY_REQUIRES_NEGOTIATE_AUTH      0x803D001B
#define WS_E_SERVER_REQUIRES_BASIC_AUTH         0x803D001C
#define WS_E_SERVER_REQUIRES_DIGEST_AUTH        0x803D001D
#define WS_E_SERVER_REQUIRES_NTLM_AUTH          0x803D001E
#define WS_E_SERVER_REQUIRES_NEGOTIATE_AUTH     0x803D001F
#define WS_E_INVALID_ENDPOINT_URL               0x803D0020
#define WS_E_OTHER                              0x803D0021
#define WS_E_SECURITY_TOKEN_EXPIRED             0x803D0022
#define WS_E_SECURITY_SYSTEM_FAILURE            0x803D0023
#endif
#ifdef __cplusplus
}
#endif

#endif

