#pragma once
#include "otherfunctions.h"
#include "ListBoxST.h"
#include "TreePropSheet.h"

#include "PPgGeneral.h"
#include "PPgConnection.h"
#include "PPgServer.h"
#include "PPgDirectories.h"
#include "PPgFiles.h"
#include "PPgStats.h"
#include "PPgNotify.h"
#include "PPgTweaks.h"
#include "PPgDisplay.h"
#include "PPgSecurity.h"
#include "PPgWebServer.h"
#include "PPgProxy.h"
#include "PPgMessages.h"
#include "PPgSpikeCon.h" // Spike2 - Connection Management
#include "PPgSpikeUp.h" // Spike2 - Upload Management
#include "PPgSpikeDown.h" // Spike2 - Download Management
#include "PPgSpikeLook.h" // Spike2 - Look and Feel
#include "PPgSpikeSec.h" // Spike2 - Security Options
#include "PPgSpikeUpdate.h" // Spike2 - Update Page

#include "KCSideBannerWnd.h" // Spike2 - Prefs Side Banner
#include "PrefSlider/SlideBar.h" // X-Ray :: PrefSlider
// ...and now for the tabbed Prefs ;)
#include "PPgSpikeAHL.h" // Spike2 - Connection Management 2
#include "PPgSpikeCredits.h" // Spike2 - Credit Tweaks
#include "PPgSpikeSCC.h" // Spike2 - SCC
#include "PPgIPFilter.h" // Spike2 - IPFilter-Update

#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
#include "PPgDebug.h"
#endif

#define LastPage PW_UPDATES
//<<< shadow2004::Tabbed Prefs [TPT] reworked

#define IDC_PREFS_SLIDEBAR	111	// X-Ray :: PrefSlider
#define PREF_PARENT_CLASS	CPropertySheet // Tabbed Prefs

class CPreferencesDlg : public PREF_PARENT_CLASS
{
	DECLARE_DYNAMIC(CPreferencesDlg)

public:
	CPreferencesDlg();
	virtual ~CPreferencesDlg();
	
	CPPgGeneral		m_wndGeneral;
	CPPgConnection	m_wndConnection;
	CPPgServer		m_wndServer;
	CPPgDirectories	m_wndDirectories;
	CPPgFiles		m_wndFiles;
	CPPgStats		m_wndStats;
	CPPgNotify		m_wndNotify;
	CPPgTweaks		m_wndTweaks;
	CPPgDisplay		m_wndDisplay;
	CPPgSecurity	m_wndSecurity;
	CPPgWebServer	m_wndWebServer;
	CPPgProxy		m_wndProxy;
	CPPgMessages	m_wndMessages;
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	CPPgDebug		m_wndDebug;
#endif
	CPPgSpikeCon	m_wndSpikeCon;
	CPPgSpikeUp		m_wndSpikeUp;
	CPPgSpikeDown	m_wndSpikeDown;	
	CPPgSpikeLook	m_wndSpikeLook;	
	CPPgSpikeSec	m_wndSpikeSec;
	CPPgSpikeUpdate m_wndSpikeUpdate;

	CPPgSpikeAHL	m_wndSpikeAHL;
    CPPgSpikeCredits m_wndSpikeCredits;
	CPPgSpikeSCC	m_wndSpikeSCC;
	CPPgIPFilter    m_wndIPFilter;

	CImageList		ImageList;
	CSlideBar	 	m_slideBar; // X-Ray :: PrefSlider

	void Localize();
	void SetStartPage(UINT uStartPageID);
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	void SwitchTab(int page);

	int	StartPageConnection;
	int StartPageLook;
	int StartPageUpload;
	int	StartPageUpdates;
//<<< shadow2004::Tabbed Prefs [TPT] reworked

protected:
	INT m_nActiveWnd;
	bool m_bSaveIniFile;

	virtual BOOL OnInitDialog();
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnDestroy();
	afx_msg LRESULT	OnSlideBarSelChanged(WPARAM wParam, LPARAM lParam); // X-Ray :: PrefSlider
public:
	CKCSideBannerWnd m_banner; // Spike2 - Prefs Side Banner
};
