//this file is part of eMule
//Copyright (C)2002-2007 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PreferencesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Spike2 - Slided Prefs / Tabbed Prefs - START
enum EnumPreferencesListItems
{
	PW_PREFERENCES = 0,
	PW_DISPLAY,
	PW_CONNECTION,
	PW_PROXY,
	PW_SERVER,
	PW_FOLDERS,
	PW_SHAREDFILES,
	PW_NOTIFICATIONS,
	PW_STATISTICS,
	PW_MESSAGES,
	PW_SECURITY,
	PW_WEB,
	PW_TWEAK,
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	PW_EMPTY,
#endif
	// Begin: Mod Prefs
	PW_SPIKECON,
	PW_SPIKEUP,
	PW_SPIKEDOWN,
	PW_SPIKELOOK,
	PW_SPIKESEC,
	PW_SPIKEUPDATE,

	// Double pages must be on the very end of the list!!!
	// no Category, tabbed pages
	PW_SPIKEAHL,
    PW_SPIKECREDITS,
	PW_SPIKESCC,
	PW_IPFILTER
	// X-Ray :: End
// Spike2 - Slided Prefs / Tabbed PRefs - END
};

IMPLEMENT_DYNAMIC(CPreferencesDlg, PREF_PARENT_CLASS)

BEGIN_MESSAGE_MAP(CPreferencesDlg, PREF_PARENT_CLASS)
	ON_WM_DESTROY()
	ON_MESSAGE(WM_SBN_SELCHANGED, OnSlideBarSelChanged) // X-Ray :: PrefSlider
END_MESSAGE_MAP()

CPreferencesDlg::CPreferencesDlg()
{
	m_psh.dwFlags &= ~PSH_HASHELP;
	m_wndGeneral.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndDisplay.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndConnection.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndServer.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndDirectories.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndFiles.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndStats.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndMessages.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndWebServer.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndTweaks.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndSecurity.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndProxy.m_psp.dwFlags &= ~PSH_HASHELP;

#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	m_wndDebug.m_psp.dwFlags &= ~PSH_HASHELP;
#endif
	m_wndSpikeCon.m_psp.dwFlags &= ~PSH_HASHELP; //Spike2 - Connection Management Page
	m_wndSpikeUp.m_psp.dwFlags &= ~PSH_HASHELP; //Spike2 - Upload Management Page
	m_wndSpikeDown.m_psp.dwFlags &= ~PSH_HASHELP; //Spike2 - Download Management Page
	m_wndSpikeLook.m_psp.dwFlags &= ~PSH_HASHELP; //Spike2 - Look and Feel Page
	m_wndSpikeSec.m_psp.dwFlags &= ~PSH_HASHELP; //Spike2 - Security Options Page
	m_wndSpikeUpdate.m_psp.dwFlags &= ~PSH_HASHELP; // Spike2 - Update Page

	m_wndSpikeAHL.m_psp.dwFlags &= ~PSH_HASHELP; // Spike2 - Connection Management 2
	m_wndSpikeCredits.m_psp.dwFlags &= ~PSH_HASHELP; // Spike2 - Credit Tweaks
	m_wndSpikeSCC.m_psp.dwFlags &= ~PSH_HASHELP; // Spike2 - SCC
	m_wndIPFilter.m_psp.dwFlags &= ~PSH_HASHELP;	//>>> shadow2004::IPFilter-Prefspage

	EnableStackedTabs(FALSE); // X-Ray :: PrefSlider

	//	WARNING: Pages must be added with the same order as the slidebar group items.
	AddPage(&m_wndGeneral);
	AddPage(&m_wndDisplay);
	AddPage(&m_wndConnection);
	AddPage(&m_wndProxy);
	AddPage(&m_wndServer);
	AddPage(&m_wndDirectories);
	AddPage(&m_wndFiles);
	AddPage(&m_wndNotify);
	AddPage(&m_wndStats);
	AddPage(&m_wndMessages);
	AddPage(&m_wndSecurity);
	AddPage(&m_wndWebServer);
	AddPage(&m_wndTweaks);
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	AddPage(&m_wndDebug);
#endif

	AddPage(&m_wndSpikeCon); // Spike2 - Connection Management Page
	AddPage(&m_wndSpikeUp); // Spike2 - Upload Management Page
	AddPage(&m_wndSpikeDown); // Spike2 - Download Management Page
	AddPage(&m_wndSpikeLook); // Spike2 - Look and Feel Page
	AddPage(&m_wndSpikeSec); // Spike2 - Security Options Page
	AddPage(&m_wndSpikeUpdate); // Spike2 - Update Page

//>>> shadow2004::Tabbed Prefs [TPT] reworked
// Add tabbed pages here
	// Double pages must be on the very end of the list!!!
	AddPage(&m_wndSpikeAHL); // Spike2 - Connection Management 2
	AddPage(&m_wndSpikeCredits); // Spike2 - Credit Tweaks
	AddPage(&m_wndSpikeSCC); // Spike2 - SCC
	AddPage(&m_wndIPFilter);	//>>> shadow2004::IPFilter-Prefspage	// Updates - 2

	StartPageConnection = 0;
	StartPageLook = 0;
	StartPageUpload = 0;
	StartPageUpdates = 0;
//<<< shadow2004::Tabbed Prefs [TPT] reworked

	m_nActiveWnd = 0;
	m_bSaveIniFile = false;
}

CPreferencesDlg::~CPreferencesDlg()
{
	ImageList.DeleteImageList(); // X-Ray :: PrefSlider
}

void CPreferencesDlg::OnDestroy()
{
	CPropertySheet::OnDestroy();
	if (m_bSaveIniFile)
	{
		thePrefs.Save();
		m_bSaveIniFile = false;
	}
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	m_nActiveWnd = GetActiveIndex();

	if(m_nActiveWnd == PW_SPIKEAHL)
		m_nActiveWnd = PW_SPIKECON;

	if(m_nActiveWnd == PW_SPIKECREDITS)
		m_nActiveWnd = PW_SPIKEUP;

	if(m_nActiveWnd == PW_SPIKESCC)
		m_nActiveWnd = PW_SPIKELOOK;

	if(m_nActiveWnd == PW_IPFILTER)
		m_nActiveWnd = PW_SPIKEUPDATE;

//>>> shadow2004::Tabbed Prefs [TPT] reworked
}

BOOL CPreferencesDlg::OnInitDialog()
{
	ASSERT( !m_bSaveIniFile );
	// X-Ray :: PrefSlider
	m_slideBar.CreateEx(WS_EX_CLIENTEDGE, WS_CHILD | WS_VISIBLE | WS_BORDER, CRect(0, 0, 0, 0), this, IDC_PREFS_SLIDEBAR);
	m_slideBar.SetImageList(&ImageList);
	m_slideBar.SetHAlignCaption(DT_CENTER);

//	Sets a bold font for the group buttons
	CFont* pGroupFont = m_slideBar.GetGroupFont();
	ASSERT_VALID(pGroupFont);
	LOGFONT logFont;
	pGroupFont->GetLogFont(&logFont);
	logFont.lfWeight *= 2;
	if (logFont.lfWeight > FW_BLACK)
		logFont.lfWeight = FW_BLACK;
	pGroupFont->DeleteObject();
	pGroupFont->CreateFontIndirect(&logFont);
	ASSERT_VALID(pGroupFont);

	BOOL bResult = CPropertySheet::OnInitDialog();
// X-Ray :: End

	SetActivePage(m_nActiveWnd);

// Spike2 from X-Ray - START
	Localize();
	m_slideBar.SetFocus();
// X-Ray :: End
	// Spike2 - Prefs Side Banner START
	CBitmap bmp;
	bmp.LoadBitmap(IDB_BANNER);
	m_banner.SetTexture((HBITMAP)bmp.Detach());	
	m_banner.SetFillFlag(KCSB_FILL_TEXTURE);
	m_banner.SetSize(75);
	m_banner.SetTitle(_T(""));
	m_banner.SetCaption(_T(""));
	m_banner.Attach(this, KCSB_ATTACH_RIGHT);	
	// Spike2 - Prefs Side Banner END

	return bResult;
}

// X-Ray :: PrefSlider
LRESULT CPreferencesDlg::OnSlideBarSelChanged(WPARAM /*wParam*/, LPARAM /*lParam*/)
{
	int iCurrentGlobalSel = m_slideBar.GetGlobalSelectedItem();

//>>> shadow2004::Tabbed Prefs [TPT] reworked
	if(iCurrentGlobalSel == PW_SPIKECON && StartPageConnection == 1)
		iCurrentGlobalSel = PW_SPIKEAHL;

	if(iCurrentGlobalSel == PW_SPIKEUP && StartPageUpload == 1)
		iCurrentGlobalSel = PW_SPIKECREDITS;

	if(iCurrentGlobalSel == PW_SPIKELOOK && StartPageLook == 1)
		iCurrentGlobalSel = PW_SPIKESCC;

	if(iCurrentGlobalSel == PW_SPIKEUPDATE && StartPageUpdates == 1)
		iCurrentGlobalSel = PW_IPFILTER;
//<<< shadow2004::Tabbed Prefs [TPT] reworked

	SetActivePage(iCurrentGlobalSel);

	CListBoxST* pListBox = m_slideBar.GetGroupListBox(m_slideBar.GetSelectedGroupIndex());
	ASSERT_VALID(pListBox);

	CString strCurrentItemText;
	pListBox->GetText(pListBox->GetCurSel(), strCurrentItemText);

	CString strCurrentGroupText = m_slideBar.GetGroupName(m_slideBar.GetSelectedGroupIndex());
	strCurrentGroupText.Remove('&');

	CString strTitle = GetResString(IDS_EM_PREFS);
	strTitle.Remove('&');
	SetWindowText(strTitle + _T(" -> ") + strCurrentGroupText + _T(" -> ") + strCurrentItemText);

	pListBox->SetFocus();

	return TRUE;
}
// X-Ray :: End

void CPreferencesDlg::Localize()
{
// Spike2 from X-Ray: Slided Prefs / Tabbed Prefs - START
	ImageList.DeleteImageList();
	ImageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 0, 1);
	ImageList.Add(CTempIconLoader(_T("S2GENERAL")));
	ImageList.Add(CTempIconLoader(_T("DISPLAY")));
	ImageList.Add(CTempIconLoader(_T("CONNECTION")));
	ImageList.Add(CTempIconLoader(_T("PROXY")));
	ImageList.Add(CTempIconLoader(_T("SERVER")));
	ImageList.Add(CTempIconLoader(_T("FOLDERS")));
	ImageList.Add(CTempIconLoader(_T("SharedFiles")));
	ImageList.Add(CTempIconLoader(_T("NOTIFICATIONS")));
	ImageList.Add(CTempIconLoader(_T("STATISTICS")));
	ImageList.Add(CTempIconLoader(_T("MESSAGES")));
	ImageList.Add(CTempIconLoader(_T("SECURITY")));
	ImageList.Add(CTempIconLoader(_T("WEB")));
	ImageList.Add(CTempIconLoader(_T("TWEAK")));
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	ImageList.Add(CTempIconLoader(_T("Preferences")));
#endif

	//Begin Mod-PrefPages
	ImageList.Add(CTempIconLoader(_T("S2CONMAN")));
	ImageList.Add(CTempIconLoader(_T("UP1DOWN0")));
	ImageList.Add(CTempIconLoader(_T("UP0DOWN1")));
	ImageList.Add(CTempIconLoader(_T("S2LOOKANDFEEL")));
	ImageList.Add(CTempIconLoader(_T("S2SECURITY")));
	ImageList.Add(CTempIconLoader(_T("UPDATE")));

	CString title = GetResString(IDS_EM_PREFS); 
	title.Remove(_T('&')); 
	SetTitle(title); 
// Spike2 from X-Ray: Slided Prefs / Tabbed Prefs - END

	m_wndGeneral.Localize();
	m_wndDisplay.Localize();
	m_wndConnection.Localize();
	m_wndServer.Localize();
	m_wndDirectories.Localize();
	m_wndFiles.Localize();
	m_wndStats.Localize();
	m_wndNotify.Localize();
	m_wndMessages.Localize();
	m_wndSecurity.Localize();
	m_wndTweaks.Localize();
	m_wndWebServer.Localize();
	m_wndProxy.Localize();

	m_wndSpikeCon.Localize(); // Spike2 - Connection Management Page
	m_wndSpikeUp.Localize(); // Spike2 - Upload Management Page
	m_wndSpikeDown.Localize(); // Spike2 - Download Management Page
	m_wndSpikeLook.Localize(); // Spike2 - Look and Feel Page
	m_wndSpikeSec.Localize(); // Spike2 - Security Options Page
	m_wndSpikeUpdate.Localize(); // Spike2 - Update Page

	m_wndSpikeAHL.Localize(); // Spike2 - Connection Management 2
	m_wndSpikeCredits.Localize(); // Spike2 - Credit Tweaks
	m_wndSpikeSCC.Localize(); // Spike2 - SCC
    m_wndIPFilter.Localize(); // Spike2 - IP-Filter-Update

	// X-Ray :: PrefSlider
	m_slideBar.ResetContent();

	int iGroupNormal = m_slideBar.AddGroup(_T("Official Preferences"));
	m_slideBar.AddGroupItem(GetResString(IDS_PW_GENERAL), iGroupNormal, PW_PREFERENCES); 
	m_slideBar.AddGroupItem(GetResString(IDS_PW_DISPLAY), iGroupNormal, PW_DISPLAY); 
	m_slideBar.AddGroupItem(GetResString(IDS_PW_CONNECTION), iGroupNormal, PW_CONNECTION); 
	m_slideBar.AddGroupItem(GetResString(IDS_PW_PROXY), iGroupNormal, PW_PROXY); 
	m_slideBar.AddGroupItem(GetResString(IDS_PW_SERVER), iGroupNormal,PW_SERVER); 
	m_slideBar.AddGroupItem(GetResString(IDS_PW_DIR), iGroupNormal, PW_FOLDERS); 
	m_slideBar.AddGroupItem(GetResString(IDS_PW_FILES), iGroupNormal, PW_SHAREDFILES); 
	m_slideBar.AddGroupItem(GetResString(IDS_PW_EKDEV_OPTIONS), iGroupNormal, PW_NOTIFICATIONS); 
	m_slideBar.AddGroupItem(GetResString(IDS_STATSSETUPINFO), iGroupNormal, PW_STATISTICS); 
	m_slideBar.AddGroupItem(GetResString(IDS_MESSAGESCOMMENTS), iGroupNormal, PW_MESSAGES);
	m_slideBar.AddGroupItem(GetResString(IDS_SECURITY), iGroupNormal, PW_SECURITY); 
	m_slideBar.AddGroupItem(GetResString(IDS_PW_WS), iGroupNormal, PW_WEB);
	m_slideBar.AddGroupItem(GetResString(IDS_PW_TWEAK), iGroupNormal, PW_TWEAK); 

#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	m_slideBar.AddGroupItem(_T("Debug"), iGroupNormal, PW_TWEAK);
#endif

	// Begin ModPrefs
	int iGroupSpike = m_slideBar.AddGroup(_T("Spike2 Mod-Tweaks"));
	m_slideBar.AddGroupItem(GetResString(IDS_PW_SPIKECON), iGroupSpike, PW_SPIKECON);
	m_slideBar.AddGroupItem(GetResString(IDS_PW_SPIKEUP), iGroupSpike, PW_SPIKEUP);
	m_slideBar.AddGroupItem(GetResString(IDS_PW_SPIKEDOWN), iGroupSpike, PW_SPIKEDOWN);
	m_slideBar.AddGroupItem(GetResString(IDS_PW_SPIKELOOK), iGroupSpike, PW_SPIKELOOK);
	m_slideBar.AddGroupItem(GetResString(IDS_PW_SPIKESEC), iGroupSpike, PW_SPIKESEC);
	m_slideBar.AddGroupItem(GetResString(IDS_PW_SPIKEUPDATE), iGroupSpike, PW_SPIKEUPDATE);
	
	int width = m_slideBar.GetGreaterStringWidth();
	width+=60;

	CRect rectOld;
	m_slideBar.GetWindowRect(rectOld);
	// X-Ray :: End

	int xoffset, yoffset;
	if(IsWindowVisible())
	{
		yoffset=0;
		xoffset=width-rectOld.Width();
	}
	else
	{
		xoffset=width-rectOld.Width()+10;
		// X-Ray :: PrefSlider
		GetActivePage()->GetWindowRect(rectOld);
		ScreenToClient (rectOld);
		yoffset = -rectOld.top;
		// X-Ray :: End
	}
	GetWindowRect(rectOld);
	SetWindowPos(NULL,0,0,rectOld.Width()+xoffset,rectOld.Height()+yoffset,SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE);
	CTabCtrl* tab = GetTabControl(); // X-Ray :: PrefSlider
	tab->GetWindowRect (rectOld);
	ScreenToClient (rectOld);
	tab->SetWindowPos(NULL,rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
	CPropertyPage* activepage = GetActivePage();
	activepage->GetWindowRect(rectOld);
	ScreenToClient (rectOld);
	activepage->SetWindowPos(NULL,rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
	// X-Ray :: PrefSlider
	GetClientRect(rectOld);
	m_slideBar.SetWindowPos(NULL, 6, 6, width, rectOld.Height() - 12, SWP_NOZORDER | SWP_NOACTIVATE);
	// X-Ray :: End
	int _PropSheetButtons[] = {IDOK, IDCANCEL, ID_APPLY_NOW, IDHELP };
	CWnd* PropSheetButton;
	for (int i = 0; i < sizeof (_PropSheetButtons) / sizeof(_PropSheetButtons[0]); i++)
	{
		if ((PropSheetButton = GetDlgItem(_PropSheetButtons[i])) != NULL)
		{
			PropSheetButton->GetWindowRect (rectOld);
			ScreenToClient (rectOld);
			PropSheetButton->SetWindowPos (NULL, rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
		}
	}
	tab->ShowWindow(SW_HIDE);
	// X-Ray :: PrefSlider
	m_slideBar.SelectGlobalItem(m_nActiveWnd);
	OnSlideBarSelChanged(NULL, NULL);
	// X-Ray :: End
	CenterWindow();

	m_banner.UpdateSize(); // Spike2 - Prefs Side Banner	

	Invalidate();
	RedrawWindow();
}

BOOL CPreferencesDlg::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == IDOK || wParam == ID_APPLY_NOW)
		m_bSaveIniFile = true;
	return __super::OnCommand(wParam, lParam);
}

void CPreferencesDlg::SetStartPage(UINT uStartPageID)
{
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	m_nActiveWnd = uStartPageID;
	//m_pPshStartPage = MAKEINTRESOURCE(uStartPageID);
//<<< shadow2004::Tabbed Prefs [TPT] reworked
}

//>>> shadow2004::Tabbed Prefs [TPT] reworked
void CPreferencesDlg::SwitchTab(int Page)
{
	if(m_hWnd && IsWindowVisible())
	{
		CPropertyPage* activepage = GetActivePage();

		if (activepage == &m_wndSpikeUpdate || activepage == &m_wndIPFilter)
		{
			StartPageUpdates = Page;
			if (Page == 0) 
			{
				SetActivePage(&m_wndSpikeUpdate);
				m_wndSpikeUpdate.InitTab(false,0);
			}
			else if (Page == 1) 
			{
				SetActivePage(&m_wndIPFilter);
				m_wndIPFilter.InitTab(false,1);
			}
		}
		
		if (activepage == &m_wndSpikeUp || activepage == &m_wndSpikeCredits)
		{
			StartPageUpload = Page;
			if (Page == 0) 
			{
				SetActivePage(&m_wndSpikeUp);
				m_wndSpikeUp.InitTab(false,0);
			}
			else if (Page == 1) 
			{
				SetActivePage(&m_wndSpikeCredits);
				m_wndSpikeCredits.InitTab(false,1);
			}
		}

		if (activepage == &m_wndSpikeCon || activepage == &m_wndSpikeAHL)
		{
			StartPageConnection = Page;
			if (Page == 0) 
			{
				SetActivePage(&m_wndSpikeCon);
				m_wndSpikeCon.InitTab(false,0);
			}
			else if (Page == 1) 
			{
				SetActivePage(&m_wndSpikeAHL);
				m_wndSpikeAHL.InitTab(false,1);
			}
		}

		if (activepage == &m_wndSpikeLook || activepage == &m_wndSpikeSCC)
		{
			StartPageLook = Page;
			if (Page == 0)
			{
				SetActivePage(&m_wndSpikeLook);
				m_wndSpikeLook.InitTab(false,0);
			}
			else if (Page == 1)
			{
				SetActivePage(&m_wndSpikeSCC);
				m_wndSpikeSCC.InitTab(false,1);
			}
		}
	}
}
//<<< shadow2004::Tabbed Prefs [TPT] reworked