//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//>>> shadow2004::Updates-Prefspage
#include "stdafx.h"
#include "emule.h"
#include "PPgSpikeUpdate.h"
#include "OtherFunctions.h"
#include "emuledlg.h"
//>>> shadow2004::IP2Country [EastShare]
#include "Preferences.h"
#include "IP2Country/IP2Country.h"
//<<< shadow2004::IP2Country [EastShare]
#include "ModIcon/ModIconMapping.h"	//>>> shadow2004::ModIconDLL Update
#include "preferencesdlg.h"		//>>> shadow2004::Tabbed Prefs [TPT] reworked

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPgSpikeUpdate, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgSpikeUpdate, CPropertyPage)
//>>> shadow2004::IP2Country [EastShare]
	ON_BN_CLICKED(IDC_UPDATES_I2CSTARTUP, OnSettingsChange)
	ON_EN_CHANGE(IDC_UPDATES_URLFORI2C, OnSettingsChange)
	ON_EN_CHANGE(IDC_UPDATES_URLFORI2CVERFILE, OnSettingsChange)
	ON_BN_CLICKED(IDC_UPDATES_I2CUPDATE, OnBnClickedI2CUpdate)
	ON_BN_CLICKED(IDC_UPDATES_I2CRESET, OnBnClickedResetI2CURL)
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::ModIconDLL Update
	ON_BN_CLICKED(IDC_UPDATES_MIMSTARTUP, OnSettingsChange)
	ON_EN_CHANGE(IDC_UPDATES_URLFORMIM, OnSettingsChange)
	ON_BN_CLICKED(IDC_UPDATES_MIMUPDATE, OnBnClickedMIMUpdate)
	ON_BN_CLICKED(IDC_UPDATES_MIMRESET, OnBnClickedResetMIMURL)
//<<< shadow2004::ModIconDLL Update
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_UPDATES_1, OnTcnSelchangeTabUpdates1)	//>>> shadow2004::Tabbed Prefs [TPT] reworked
END_MESSAGE_MAP()

CPPgSpikeUpdate::CPPgSpikeUpdate()
	: CPropertyPage(CPPgSpikeUpdate::IDD)
{
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	m_imageList.DeleteImageList();
	m_imageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 14+1, 0);
	m_imageList.Add(CTempIconLoader(_T("WEB")));
	m_imageList.Add(CTempIconLoader(_T("IPFILTER")));
//<<< shadow2004::Tabbed Prefs [TPT] reworked
}

CPPgSpikeUpdate::~CPPgSpikeUpdate()
{
}

void CPPgSpikeUpdate::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB_UPDATES_1, m_tabCtr);	//>>> shadow2004::Tabbed Prefs [TPT] reworked
}

BOOL CPPgSpikeUpdate::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	InitTab(true);
	m_tabCtr.SetCurSel(0);
//<<< shadow2004::Tabbed Prefs [TPT] reworked
	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgSpikeUpdate::LoadSettings(void)
{
	if(m_hWnd)
	{
		CString strBuffer;
//>>> shadow2004::IP2Country [EastShare]
		CheckDlgButton(IDC_UPDATES_I2CSTARTUP, thePrefs.IsAutoUpdateIP2CountryEnabled());
		GetDlgItem(IDC_UPDATES_URLFORI2C)->SetWindowText(thePrefs.GetIP2CountryUpdateURL());
		GetDlgItem(IDC_UPDATES_URLFORI2CVERFILE)->SetWindowText(thePrefs.GetIP2CountryUpdateVerURL());
		strBuffer.Format(_T("v%u"), thePrefs.GetIP2CountryVersion());
		GetDlgItem(IDC_UPDATES_I2CVERSION)->SetWindowText(strBuffer);
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::ModIconDLL Update
		CheckDlgButton(IDC_UPDATES_MIMSTARTUP, thePrefs.IsAutoUpdateModIconDllEnabled());
		GetDlgItem(IDC_UPDATES_URLFORMIM)->SetWindowText(thePrefs.GetModIconDllUpdateURL());
		GetDlgItem(IDC_UPDATES_MIMVERSION)->SetWindowText(theApp.theModIconMap->GetVersionString());
//<<< shadow2004::ModIconDLL Update
	}
}

BOOL CPPgSpikeUpdate::OnApply()
{
	CString buffer;

//>>> shadow2004::IP2Country [EastShare]
	thePrefs.SetAutoUpdateIP2Country(IsDlgButtonChecked(IDC_UPDATES_I2CSTARTUP)!=0);
	if(GetDlgItem(IDC_UPDATES_URLFORI2C)->GetWindowTextLength())
	{
		GetDlgItem(IDC_UPDATES_URLFORI2C)->GetWindowText(buffer);
		_tcscpy(thePrefs.m_strIP2CountryUpdateURL, buffer);
	}
	if(GetDlgItem(IDC_UPDATES_URLFORI2CVERFILE)->GetWindowTextLength())
	{
		GetDlgItem(IDC_UPDATES_URLFORI2CVERFILE)->GetWindowText(buffer);
		_tcscpy(thePrefs.m_strIP2CountryUpdateVerURL, buffer);
	}
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::ModIconDLL Update
	thePrefs.SetAutoUpdateModIconDll(IsDlgButtonChecked(IDC_UPDATES_MIMSTARTUP)!=0);
	if(GetDlgItem(IDC_UPDATES_URLFORMIM)->GetWindowTextLength())
	{
		GetDlgItem(IDC_UPDATES_URLFORMIM)->GetWindowText(buffer);
		_tcscpy(thePrefs.m_strModIconDllUpdateURL, buffer);
	}
//>>> shadow2004::ModIconDLL Update

	SetModified(FALSE);
	
	LoadSettings();
	return CPropertyPage::OnApply();
}

void CPPgSpikeUpdate::Localize(void)
{
	if(m_hWnd)
	{
		SetWindowText(_T("Updates"));
//>>> shadow2004::IP2Country [EastShare]
		GetDlgItem(IDC_UPDATES_I2CGROUP)->SetWindowText(GetResString(IDS_UPDATES_I2CLABEL));
		GetDlgItem(IDC_UPDATES_I2CSTARTUP)->SetWindowText(GetResString(IDS_UPDATES_I2CAUTO));
		GetDlgItem(IDC_UPDATES_URLFORI2CLABEL)->SetWindowText(GetResString(IDS_UPDATES_I2CURLLABEL));
		GetDlgItem(IDC_UPDATES_URLFORI2CVERFILELABEL)->SetWindowText(GetResString(IDS_UPDATES_I2CURLVERLABEL));
		GetDlgItem(IDC_UPDATES_I2CRESET)->SetWindowText(GetResString(IDS_PW_RESET));
		GetDlgItem(IDC_UPDATES_I2CUPDATE)->SetWindowText(GetResString(IDS_SV_UPDATE));
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::ModIconDLL Update
		GetDlgItem(IDC_UPDATES_MIMGROUP)->SetWindowText(GetResString(IDS_UPDATES_MIMLABEL));
		GetDlgItem(IDC_UPDATES_MIMSTARTUP)->SetWindowText(GetResString(IDS_UPDATES_MIMAUTO));
		GetDlgItem(IDC_UPDATES_URLFORMIMLABEL)->SetWindowText(GetResString(IDS_UPDATES_MIMURLLABEL));
		GetDlgItem(IDC_UPDATES_MIMRESET)->SetWindowText(GetResString(IDS_PW_RESET));
		GetDlgItem(IDC_UPDATES_MIMUPDATE)->SetWindowText(GetResString(IDS_SV_UPDATE));
//<<< shadow2004::ModIconDLL Update
	}
}

//>>> shadow2004::IP2Country [EastShare]
void CPPgSpikeUpdate::OnBnClickedI2CUpdate()
{
	OnApply();
	theApp.ip2country->UpdateIP2CountryURL();
	CString strBuffer;
	strBuffer.Format(_T("v%u"), thePrefs.GetIP2CountryVersion());
	GetDlgItem(IDC_UPDATES_I2CVERSION)->SetWindowText(strBuffer);
}

void CPPgSpikeUpdate::OnBnClickedResetI2CURL()
{
	CString strBuffer = _T("http://ip-to-country.webhosting.info/downloads/ip-to-country.csv.zip");
	GetDlgItem(IDC_UPDATES_URLFORI2C)->SetWindowText(strBuffer);
	strBuffer = _T("http://ip-to-country.webhosting.info/downloads/latest");
	GetDlgItem(IDC_UPDATES_URLFORI2CVERFILE)->SetWindowText(strBuffer);
	thePrefs.SetIP2CountryVersion(0);
	strBuffer.Format(_T("v%u"), thePrefs.GetIP2CountryVersion());
	GetDlgItem(IDC_UPDATES_I2CVERSION)->SetWindowText(strBuffer);
}
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::ModIconDLL Update
void CPPgSpikeUpdate::OnBnClickedMIMUpdate()
{
	OnApply();
	theApp.theModIconMap->Update();
	GetDlgItem(IDC_UPDATES_MIMVERSION)->SetWindowText(theApp.theModIconMap->GetVersionString());
}

void CPPgSpikeUpdate::OnBnClickedResetMIMURL()
{
	GetDlgItem(IDC_UPDATES_URLFORMIM)->SetWindowText(MODICONDLL_DEFAULT_URL);
}
//<<< shadow2004::ModIconDLL Update

//>>> shadow2004::Tabbed Prefs [TPT] reworked
void CPPgSpikeUpdate::InitTab(bool firstinit, int Page)
{
	if (firstinit) 
	{
		m_tabCtr.DeleteAllItems();
		m_tabCtr.SetImageList(&m_imageList);
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Updates1, _T("Updates"), 0, (LPARAM)Updates1); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Updates2, GetResString(IDS_IPFILTER), 1, (LPARAM)Updates2); 
	}

	m_tabCtr.SetCurSel(Page);
}
void CPPgSpikeUpdate::OnTcnSelchangeTabUpdates1(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int cur_sel = m_tabCtr.GetCurSel();
	theApp.emuledlg->preferenceswnd->SwitchTab(cur_sel);
	*pResult = 0;
}
//<<< shadow2004::Tabbed Prefs [TPT] reworked