#pragma once
#include "preferences.h"
#include "afxwin.h"

// CPPgSpikeUp dialog

class CPPgSpikeUp : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPgSpikeUp)

public:
	CPPgSpikeUp();
	virtual ~CPPgSpikeUp();

	void SetPrefs(CPreferences* in_prefs) {	app_prefs = in_prefs; }

// Dialog Data
	enum { IDD = IDD_PPG_SPIKEUP };
protected:
	CPreferences *app_prefs;

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
// X-Ray :: PPgPrefTabs
private:
	enum eTab	{NONE, Upload1, Upload2};
	CTabCtrl	m_tabCtr;
	eTab		m_currentTab;
	CImageList	m_imageList;
	void		SetTab(eTab tab);

public:
	afx_msg void OnTcnSelchangeTabUpload1(NMHDR *pNMHDR, LRESULT *pResult);
	void	InitTab(bool firstinit, int Page = 0);
// X-Ray :: End
	afx_msg void OnBnClickedFullChunkOff(); // Spike2 - FullChunk switchable
	afx_msg void OnBnClickedFullChunkVQB(); // Spike2 - FullChunk switchable
public:
	virtual BOOL OnInitDialog();
	void LoadSettings(void);
	virtual BOOL OnApply();
	afx_msg void OnSettingsChange()		{ SetModified(); }
	afx_msg void OnFCChange();  // Spike2 - FullChunk switchable
	void Localize(void);
private:
public:
	void CheckFullChunk(); // Spike2 - FullChunk switchable
};
	