// PPgSpikeUp.cpp : implementation file

#include "stdafx.h"
#include "Preferences.h"
#include "emule.h"
#include "PPgSpikeUp.h"
#include ".\ppgspikeup.h"
#include "OtherFunctions.h"
#include "UploadQueue.h" // VQB: fullChunk
#include "emuleDlg.h" // X-Ray :: PPgPrefTabs
#include "PreferencesDlg.h" // X-Ray :: PPgPrefTabs

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// CPPgSpikeUp dialog

IMPLEMENT_DYNAMIC(CPPgSpikeUp, CPropertyPage)

CPPgSpikeUp::CPPgSpikeUp()
	: CPropertyPage(CPPgSpikeUp::IDD)
{
	// X-Ray :: PPgPrefTabs
	m_imageList.DeleteImageList();
	m_imageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 14+1, 0);
	m_imageList.Add(CTempIconLoader(_T("UPLOAD")));
	m_imageList.Add(CTempIconLoader(_T("CREDITS")));
	// X-Ray :: End
}

void CPPgSpikeUp::DoDataExchange(CDataExchange* pDX)
{

	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PRF_UPLOAD_TAB_NO1, m_tabCtr); // X-Ray :: PPgPrefTabs
}

BEGIN_MESSAGE_MAP(CPPgSpikeUp, CPropertyPage)
		ON_NOTIFY(TCN_SELCHANGE, IDC_PRF_UPLOAD_TAB_NO1, OnTcnSelchangeTabUpload1) // X-Ray :: PPgPrefTabs
		ON_EN_CHANGE(IDS_MAXUPCLIENTSALLOWED, OnSettingsChange)  // [ionix] min/max Slot
		ON_EN_CHANGE(IDS_MINUPCLIENTSALLOWED, OnSettingsChange) //  [ionix] min/max Slot
		ON_BN_CLICKED(IDC_DONTCOMPRESSAVI, OnSettingsChange) // Spike2 - Xman Code Improvement for choosing to use compression
		ON_BN_CLICKED(IDC_VARCOMPR, OnSettingsChange) // Spike2 - Variable Compression
		ON_BN_CLICKED(IDC_FULLCHUNK, OnFCChange)				// Spike2 - FullChunk switchable
		ON_BN_CLICKED(IDC_FULLCHUNKOFF, OnBnClickedFullChunkOff)// Spike2 - FullChunk switchable
		ON_BN_CLICKED(IDC_FULLCHUNKVQB, OnBnClickedFullChunkVQB)// Spike2 - FullChunk switchable
		ON_BN_CLICKED(IDC_SLOTFOCUS, OnSettingsChange) // Spike2 - (very simple) SlotFocus
		ON_BN_CLICKED(IDC_ASFU, OnSettingsChange) // Spike2 - ASFU
END_MESSAGE_MAP()

	// CPPgSpikeUp message handlers

BOOL CPPgSpikeUp::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	InitTab(true, theApp.emuledlg->preferenceswnd->StartPageUpload); // X-Ray :: PPgPrefTabs

		((CEdit*)GetDlgItem(IDS_MAXUPCLIENTSALLOWED))->SetLimitText(3); // [ionix] min/max Slot
		((CEdit*)GetDlgItem(IDS_MINUPCLIENTSALLOWED))->SetLimitText(2); // [ionix] min/max Slot

	// Spike2 - FullChunk switchable - START
	int iBtnID;
	if (thePrefs.FullChunkType == fcOff)
		iBtnID = IDC_FULLCHUNKOFF;
	else 
	{
		ASSERT( thePrefs.FullChunkType == fcVQB );
		iBtnID = IDC_FULLCHUNKVQB;
	}
	ASSERT( IDC_FULLCHUNKOFF < IDC_FULLCHUNKVQB );
	CheckRadioButton(IDC_FULLCHUNKOFF, IDC_FULLCHUNKVQB, iBtnID);
	// Spike2 - FullChunk switchable - END

	LoadSettings();
	CheckFullChunk(); // Spike2 - FullChunk switchable
	Localize();

	return TRUE;
}

void CPPgSpikeUp::CheckFullChunk()
{
		GetDlgItem(IDC_FULLCHUNKOFF)->EnableWindow(IsDlgButtonChecked(IDC_FULLCHUNK)); // Spike2 - FullChunk switchable
		GetDlgItem(IDC_FULLCHUNKVQB)->EnableWindow(IsDlgButtonChecked(IDC_FULLCHUNK)); // Spike2 - FullChunk switchable
}

void CPPgSpikeUp::LoadSettings(void)
{

if(m_hWnd)
	{
		CString strBuffer;
		// Spike2 - Min./Max.-Slots (from iONiX) - START
				strBuffer.Format(_T("%d"), thePrefs.Getmaxupclientsallowed()); 
				GetDlgItem(IDS_MAXUPCLIENTSALLOWED)->SetWindowText(strBuffer); 
				strBuffer.Format(_T("%d"), thePrefs.Getminupclientsallowed());
				GetDlgItem(IDS_MINUPCLIENTSALLOWED)->SetWindowText(strBuffer);
		// Spike2 - Min./Max.-Slots (from iONiX) - END
		// Spike2 - Xman Code Improvement for choosing to use compression - START
		if (thePrefs.GetDontCompressAvi())
			CheckDlgButton(IDC_DONTCOMPRESSAVI,1);
		else
			CheckDlgButton(IDC_DONTCOMPRESSAVI,0);
		// Spike2 - Xman Code Improvement for choosing to use compression - END
		// Spike2 - Variable Compression - START
		if (thePrefs.IsVarCompression())
			CheckDlgButton(IDC_VARCOMPR,1);
		else
			CheckDlgButton(IDC_VARCOMPR,0);
		// Spike2 - Variable Compression - END
		// Spike2 - (very simple) SlotFocus - START
		if (thePrefs.IsSlotFocus())
			CheckDlgButton(IDC_SLOTFOCUS,1);
		else
			CheckDlgButton(IDC_SLOTFOCUS,0);
		// Spike2 - (very simple) SlotFocus - END
		// Spike2 - FullChunk switchable - START
		if (thePrefs.m_btransferfullchunks)
			CheckDlgButton(IDC_FULLCHUNK,1);
		else
			CheckDlgButton(IDC_FULLCHUNK,0);
		// Spike2 - FullChunk switchable - END
		// Spike2 - ASFU - START
		if (thePrefs.GetDirectoryWatcher())
			CheckDlgButton(IDC_ASFU,1);
		else
			CheckDlgButton(IDC_ASFU,0);
		// Spike2 - ASFU - END
	}
}

BOOL CPPgSpikeUp::OnApply(){

	CString sBuffer;
	TCHAR buffer[510];

		// Spike2 - Min./Max.-Slots (from iONiX)
		   GetDlgItem(IDS_MAXUPCLIENTSALLOWED)->GetWindowText(sBuffer); 
				app_prefs->Setmaxupclientsallowed(_tstoi(sBuffer));
				if(app_prefs->Getmaxupclientsallowed() < 2)  
				{ 
				app_prefs->Setmaxupclientsallowed(2); 
				_stprintf(buffer, _T("%d"),app_prefs->Getmaxupclientsallowed()); 
				GetDlgItem(IDS_MAXUPCLIENTSALLOWED)->SetWindowText(buffer); 
				} 
				else if(app_prefs->Getmaxupclientsallowed() >250) 
				{ 
				app_prefs->Setmaxupclientsallowed(250); 
				_stprintf(buffer, _T("%d"),app_prefs->Getmaxupclientsallowed()); 
				GetDlgItem(IDS_MINUPCLIENTSALLOWED)->SetWindowText(buffer); 
				} 
				GetDlgItem(IDS_MINUPCLIENTSALLOWED)->GetWindowText(sBuffer); 
					
				app_prefs->Setminupclientsallowed(_tstoi(sBuffer));
				if(app_prefs->Getminupclientsallowed() < 1) 
				{ 
				app_prefs->Setminupclientsallowed(1); 
				_stprintf(buffer, _T("%d"),app_prefs->Getminupclientsallowed()); 
				GetDlgItem(IDS_MINUPCLIENTSALLOWED)->SetWindowText(buffer); 
				} 
				else if(app_prefs->Getminupclientsallowed() >200)
				{ 
				app_prefs->Setminupclientsallowed(200); 
				_stprintf(buffer, _T("%d"),app_prefs->Getminupclientsallowed()); 
				GetDlgItem(IDS_MINUPCLIENTSALLOWED)->SetWindowText(buffer); 
				}
		// Spike2 - Min./Max.-Slots (from iONiX)

		// Spike2 - Xman Code Improvement for choosing to use compression - START
		if(IsDlgButtonChecked(IDC_DONTCOMPRESSAVI))
			thePrefs.dontcompressavi = true;
		else
			thePrefs.dontcompressavi = false;
		// Spike2 - Xman Code Improvement for choosing to use compression - END

		// Spike2 - Variable Compression - START
		if(IsDlgButtonChecked(IDC_VARCOMPR))
			thePrefs.m_bVarCompression = true;
		else
			thePrefs.m_bVarCompression = false;
		// Spike2 - Variable Compression - END

		// Spike2 - (very simple) SlotFocus - START
		if(IsDlgButtonChecked(IDC_SLOTFOCUS))
			thePrefs.m_bSlotFocus = true;
		else
			thePrefs.m_bSlotFocus = false;
		// Spike2 - (very simple) SlotFocus - END

		// Spike2 - ASFU - START
		thePrefs.SetDirectoryWatcher(IsDlgButtonChecked(IDC_ASFU));

		// Spike2 - FullChunk switchable - START
		if (IsDlgButtonChecked(IDC_FULLCHUNKOFF))
			thePrefs.FullChunkType = fcOff;
		else
		{
			ASSERT(IsDlgButtonChecked(IDC_FULLCHUNKVQB)); // else this would mean that no control is selected... sth. went wrong, so terminate here
			thePrefs.FullChunkType = fcVQB;
		}
		// Spike2 - FullChunk switchable - END

	LoadSettings();
	return CPropertyPage::OnApply();
}

void CPPgSpikeUp::OnBnClickedFullChunkOff()
{
	CheckFullChunk();
	SetModified();
}

void CPPgSpikeUp::OnBnClickedFullChunkVQB()
{
	CheckFullChunk();
	SetModified();
}

void CPPgSpikeUp::OnFCChange()
{
		if(IsDlgButtonChecked(IDC_FULLCHUNK))
			thePrefs.m_btransferfullchunks = true;
		else
			thePrefs.m_btransferfullchunks = false;

		CheckFullChunk();
}
// Spike2 - FullChunk switchable - END

void CPPgSpikeUp::Localize(void){
}
CPPgSpikeUp::~CPPgSpikeUp(void){
}

// X-Ray :: PPgPrefTabs
void CPPgSpikeUp::InitTab(bool firstinit, int Page)
{
	if (firstinit) {
		m_tabCtr.DeleteAllItems();
		m_tabCtr.SetImageList(&m_imageList);
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Upload1, _T("Upload Tweaks"), 0, (LPARAM)Upload1); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Upload2, _T("Credit Tweaks"), 1, (LPARAM)Upload2); 
	}

	m_tabCtr.SetCurSel(Page);
}
void CPPgSpikeUp::OnTcnSelchangeTabUpload1(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int cur_sel = m_tabCtr.GetCurSel();
	theApp.emuledlg->preferenceswnd->SwitchTab(cur_sel);
	*pResult = 0;
}
// X-Ray :: End