// PPgSpikeSec.cpp : implementation file
// Thanx to Br4No

#include "stdafx.h"
#include "Preferences.h"
#include "emule.h"
#include "PPgSpikeSec.h"
#include ".\ppgspikesec.h"
#include "OtherFunctions.h"

// CPPgSpikeSec dialog

IMPLEMENT_DYNAMIC(CPPgSpikeSec, CPropertyPage)
CPPgSpikeSec::CPPgSpikeSec()

	: CPropertyPage(CPPgSpikeSec::IDD)
{
}

void CPPgSpikeSec::DoDataExchange(CDataExchange* pDX){

	CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPPgSpikeSec, CPropertyPage)
	ON_EN_CHANGE(IDC_BANTHRES, OnSettingsChange)
	ON_EN_CHANGE(IDC_CLIENTBANTIME, OnSettingsChange) // AntiLeecher
	ON_BN_CLICKED(IDC_ANTILEECHERMOD, OnSettingsChange) // AntiLeecher
	ON_BN_CLICKED(IDC_ANTINICKTHIEF, OnSettingsChange) // AntiLeecher
	ON_BN_CLICKED(IDC_ANTIMODTHIEF, OnSettingsChange) // AntiLeecher
	ON_BN_CLICKED(IDC_SNAFU, OnSettingsChange) // SNAFU_V3
	ON_BN_CLICKED(IDC_ANALYZER, OnSettingsChange) //>>> [Spike2] WiZaRd's ClientAnalyzer
END_MESSAGE_MAP()

	// CPPgSpikeSec message handlers

BOOL CPPgSpikeSec::OnInitDialog(){

	CPropertyPage::OnInitDialog();

	LoadSettings();
	Localize();

	return TRUE;
}

void CPPgSpikeSec::LoadSettings(void){

		if(m_hWnd)
		{	
		      {
              CString buffer;
		      buffer.Format(_T("%i"), thePrefs.BANTHRES); 
		      GetDlgItem(IDC_BANTHRES)->SetWindowText(buffer); 
	          }
			  {
			  CString buffer;
			  buffer.Format(_T("%i"), thePrefs.Clientbantime);
			  GetDlgItem(IDC_CLIENTBANTIME)->SetWindowText(buffer);
			  }
        // Spike2 - AntiLeecher - START 
		if (thePrefs.IsLeecherSecure())
			CheckDlgButton(IDC_ANTILEECHERMOD,1);
		else
			CheckDlgButton(IDC_ANTILEECHERMOD,0);

		if (thePrefs.IsAntiNickThief())
			CheckDlgButton(IDC_ANTINICKTHIEF,1);
		else
			CheckDlgButton(IDC_ANTINICKTHIEF,0);

		if (thePrefs.IsAntiModIdFaker())
			CheckDlgButton(IDC_ANTIMODTHIEF,1);
		else
			CheckDlgButton(IDC_ANTIMODTHIEF,0);
		// Spike2 - AntiLeecher - END

		// eWombat SNAFU_V3
		if (thePrefs.GetAntiSnafu())
				CheckDlgButton(IDC_SNAFU,1);
				else
				CheckDlgButton(IDC_SNAFU,0);
		// eWombat SNAFU_V3
		//>>> [Spike2] WiZaRd's ClientAnalyzer
		if(thePrefs.IsClientAnalyzer())
		{
			CheckDlgButton(IDC_ANALYZER,1);
			CheckDlgButton(IDC_ANTILEECHERMOD,0);
			CheckDlgButton(IDC_ANTINICKTHIEF,0);
			CheckDlgButton(IDC_ANTIMODTHIEF,0);
			CheckDlgButton(IDC_SNAFU,0);
		}
		else
			CheckDlgButton(IDC_ANALYZER,0);
		//<<< [Spike2] WiZaRd's ClientAnalyzer
                }
}

BOOL CPPgSpikeSec::OnApply(){

	//CString sBuffer;
	//char buffer[510];
	TCHAR buffer[510];

	if(m_hWnd)
	{
		if (GetDlgItem(IDC_BANTHRES)->GetWindowTextLength())
		{
			GetDlgItem(IDC_BANTHRES)->GetWindowText(buffer,20);
			thePrefs.SetBANTHRES( ((_tstoi(buffer)>=1)&& _tstoi(buffer)<=100) ? _tstoi(buffer) : 32 );
		}
		if (GetDlgItem(IDC_CLIENTBANTIME)->GetWindowTextLength())
		{
			GetDlgItem(IDC_CLIENTBANTIME)->GetWindowText(buffer,20);
			thePrefs.SetClientbantime( ((_tstoi(buffer)>=1)&& _tstoi(buffer)<=24) ? _tstoi(buffer) : 2 );
		}
		// Spike2 - AntiLeecher - START
		if(IsDlgButtonChecked(IDC_ANTILEECHERMOD))
			thePrefs.m_bAntiLeecherMod = true;
		else
			thePrefs.m_bAntiLeecherMod = false;

		if(IsDlgButtonChecked(IDC_ANTINICKTHIEF))
			thePrefs.m_bAntiNickThief = true;
		else
			thePrefs.m_bAntiNickThief = false;

		if(IsDlgButtonChecked(IDC_ANTIMODTHIEF))
			thePrefs.m_bAntiModThief = true;
		else
			thePrefs.m_bAntiModThief = false;
		// Spike2 - AntiLeecher - END

		// eWombat SNAFU_V3
		if(IsDlgButtonChecked(IDC_SNAFU))
			thePrefs.m_bSnafu = true;
		else
			thePrefs.m_bSnafu = false;
		// eWombat SNAFU_V3
		//>>> [Spike2] WiZaRd's ClientAnalyzer
		if(IsDlgButtonChecked(IDC_ANALYZER))
		{
			thePrefs.m_bAnalyzer = true;
			thePrefs.m_bAntiLeecherMod = false;
			thePrefs.m_bAntiNickThief = false;
			thePrefs.m_bAntiModThief = false;
		}
		else
			thePrefs.m_bAnalyzer = false;
		//>>> [Spike2] WiZaRd's ClientAnalyzer 

	}

	LoadSettings();
	return CPropertyPage::OnApply();
}

void CPPgSpikeSec::Localize(void){
}
CPPgSpikeSec::~CPPgSpikeSec(void){
}