// PPgSpikeSCC.cpp : implementation file

#include "stdafx.h"
#include "Preferences.h"
#include "emule.h"
#include "PPgSpikeSCC.h"
#include "OtherFunctions.h"
#include "emuleDlg.h" // X-Ray :: PPgPrefTabs
#include "PreferencesDlg.h" // X-Ray :: PPgPrefTabs

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// CPPgSpikeSCC dialog

IMPLEMENT_DYNAMIC(CPPgSpikeSCC, CPropertyPage)

CPPgSpikeSCC::CPPgSpikeSCC()
	: CPropertyPage(CPPgSpikeSCC::IDD)
{
	// X-Ray :: PPgPrefTabs
	m_imageList.DeleteImageList();
	m_imageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 14+1, 0);
	m_imageList.Add(CTempIconLoader(_T("SMILEY_INTEREST")));
	m_imageList.Add(CTempIconLoader(_T("SCC")));
	// X-Ray :: End
}

void CPPgSpikeSCC::DoDataExchange(CDataExchange* pDX)
{

	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PRF_LOOK_TAB_NO2, m_tabCtr); // X-Ray :: PPgPrefTabs
}

BEGIN_MESSAGE_MAP(CPPgSpikeSCC, CPropertyPage)
	ON_NOTIFY(TCN_SELCHANGE, IDC_PRF_LOOK_TAB_NO2, OnTcnSelchangeTabLook2) // X-Ray :: PPgPrefTabs
	ON_BN_CLICKED(IDC_SCC_NONE, OnSettingsChange)  // Spike2 - SCC
	ON_BN_CLICKED(IDC_SCC_ALPH, OnSettingsChange) // Spike2 - SCC
	ON_BN_CLICKED(IDC_SCC_LP, OnSettingsChange) // Spike2 - SCC
	ON_BN_CLICKED(IDC_SHOWFULLCAT, OnSettingsChange)
	ON_BN_CLICKED(IDC_SHOWSELCAT, OnSettingsChange)
	ON_BN_CLICKED(IDC_CATFILTER, OnSettingsChange)
	ON_BN_CLICKED(IDC_DEFAULTCAT, OnSettingsChange)
	ON_BN_CLICKED(IDC_AUTOLP, OnSettingsChange)
	ON_BN_CLICKED(IDC_SMALLFIRST, OnSettingsChange)
	ON_EN_CHANGE(IDC_SCCSTART, OnSettingsChange)
END_MESSAGE_MAP()

	// CPPgSpikeSCC message handlers

BOOL CPPgSpikeSCC::OnInitDialog()
{

	CPropertyPage::OnInitDialog();

	InitTab(true, theApp.emuledlg->preferenceswnd->StartPageLook); // X-Ray :: PPgPrefTabs

	LoadSettings();
	Localize();

	return TRUE;
}

void CPPgSpikeSCC::LoadSettings(void)
{
	if(m_hWnd)
	{
		{
              CString buffer;
			  buffer.Format(_T("%i"), thePrefs.m_iStartDLInEmptyCats); 
		      GetDlgItem(IDC_SCCSTART)->SetWindowText(buffer); 
	    }
		// Spike2 - SCC resume order - START
		if (thePrefs.GetDlMode() == 0)
		{
			CheckDlgButton(IDC_SCC_NONE,1);
			CheckDlgButton(IDC_SCC_ALPH,0);
			CheckDlgButton(IDC_SCC_LP,0);
		}
		else if (thePrefs.GetDlMode() == 1)
		{
			CheckDlgButton(IDC_SCC_NONE,0);
			CheckDlgButton(IDC_SCC_ALPH,1);
			CheckDlgButton(IDC_SCC_LP,0);
		}
		else if (thePrefs.GetDlMode() == 2)
		{
			CheckDlgButton(IDC_SCC_NONE,0);
			CheckDlgButton(IDC_SCC_ALPH,0);
			CheckDlgButton(IDC_SCC_LP,1);
		}
		// Spike2 - SCC resume order - END
		// Spike2 - SCC - START
		if (thePrefs.ShowCatNameInDownList())
			CheckDlgButton(IDC_SHOWFULLCAT,1);
		else
			CheckDlgButton(IDC_SHOWFULLCAT,0);

		if (thePrefs.SelectCatForNewDL())
			CheckDlgButton(IDC_SHOWSELCAT,1);
		else
			CheckDlgButton(IDC_SHOWSELCAT,0);

		if (thePrefs.UseAutoCat())
			CheckDlgButton(IDC_CATFILTER,1);
		else
			CheckDlgButton(IDC_CATFILTER,0);

		if (thePrefs.UseActiveCatForLinks())
			CheckDlgButton(IDC_DEFAULTCAT,1);
		else
			CheckDlgButton(IDC_DEFAULTCAT,0);

		if (thePrefs.AutoSetResumeOrder())
			CheckDlgButton(IDC_AUTOLP,1);
		else
			CheckDlgButton(IDC_AUTOLP,0);

		if (thePrefs.SmallFileDLPush())
			CheckDlgButton(IDC_SMALLFIRST,1);
		else
			CheckDlgButton(IDC_SMALLFIRST,0);
		// Spike2 - SCC - END
	} 
} 

BOOL CPPgSpikeSCC::OnApply()
{
	TCHAR buffer[510];

	if (GetDlgItem(IDC_SCCSTART)->GetWindowTextLength())
	{
		GetDlgItem(IDC_SCCSTART)->GetWindowText(buffer,20);
		thePrefs.m_iStartDLInEmptyCats = ( ((_tstoi(buffer)>=0)&& _tstoi(buffer)<=20) ? _tstoi(buffer) : 0 );
	}
	// Spike2 - SCC resume order - START
	if (IsDlgButtonChecked(IDC_SCC_NONE))
		thePrefs.dlMode = 0;
	else if (IsDlgButtonChecked(IDC_SCC_ALPH))
		thePrefs.dlMode = 1;
	else if (IsDlgButtonChecked(IDC_SCC_LP))
		thePrefs.dlMode = 2;
	// Spike2 - SCC resume order - END
	// Spike2 - SCC - START
	if (IsDlgButtonChecked(IDC_SHOWFULLCAT))
		thePrefs.m_bShowCatNames = true;
	else
		thePrefs.m_bShowCatNames = false;

	if (IsDlgButtonChecked(IDC_SHOWSELCAT))
		thePrefs.m_bSelCatOnAdd = true;
	else
		thePrefs.m_bSelCatOnAdd = false;

	if (IsDlgButtonChecked(IDC_CATFILTER))
		thePrefs.m_bUseAutoCat = true;
	else
		thePrefs.m_bUseAutoCat = false;

	if (IsDlgButtonChecked(IDC_DEFAULTCAT))
		thePrefs.m_bActiveCatDefault = true;
	else
		thePrefs.m_bActiveCatDefault = false;

	if (IsDlgButtonChecked(IDC_AUTOLP))
		thePrefs.m_bAutoSetResumeOrder = true;
	else
		thePrefs.m_bAutoSetResumeOrder = false;

	if (IsDlgButtonChecked(IDC_SMALLFIRST))
		thePrefs.m_bSmallFileDLPush = true;
	else
		thePrefs.m_bSmallFileDLPush = false;
	// Spike2 - SCC - END

	return CPropertyPage::OnApply();
}

void CPPgSpikeSCC::Localize(void)
{
}

CPPgSpikeSCC::~CPPgSpikeSCC(void)
{
}

// X-Ray :: PPgPrefTabs
void CPPgSpikeSCC::InitTab(bool firstinit, int Page)
{
	if (firstinit) {
		m_tabCtr.DeleteAllItems();
		m_tabCtr.SetImageList(&m_imageList);
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Look1, _T("General"), 0, (LPARAM)Look1); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Look2, _T("SCC"), 1, (LPARAM)Look2); 
	}

	m_tabCtr.SetCurSel(Page);
}
void CPPgSpikeSCC::OnTcnSelchangeTabLook2(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int cur_sel = m_tabCtr.GetCurSel();
	theApp.emuledlg->preferenceswnd->SwitchTab(cur_sel);
	*pResult = 0;
}
// X-Ray :: End