// PPgSpikeLook.cpp : implementation file

#include "stdafx.h"
#include "Preferences.h"
#include "emule.h"
#include "PPgSpikeLook.h"
#include ".\ppgspikelook.h"
#include "OtherFunctions.h"
#include "emuleDlg.h" // X-Ray :: PPgPrefTabs
#include "PreferencesDlg.h" // X-Ray :: PPgPrefTabs

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// CPPgSpikeLook dialog

IMPLEMENT_DYNAMIC(CPPgSpikeLook, CPropertyPage)

CPPgSpikeLook::CPPgSpikeLook()
	: CPropertyPage(CPPgSpikeLook::IDD)
{
	// X-Ray :: PPgPrefTabs
	m_imageList.DeleteImageList();
	m_imageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 14+1, 0);
	m_imageList.Add(CTempIconLoader(_T("SMILEY_INTEREST")));
	m_imageList.Add(CTempIconLoader(_T("SCC")));
	// X-Ray :: End
}

void CPPgSpikeLook::DoDataExchange(CDataExchange* pDX)
{

	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PRF_LOOK_TAB_NO1, m_tabCtr); // X-Ray :: PPgPrefTabs
}

BEGIN_MESSAGE_MAP(CPPgSpikeLook, CPropertyPage)
		ON_NOTIFY(TCN_SELCHANGE, IDC_PRF_LOOK_TAB_NO1, OnTcnSelchangeTabLook1) // X-Ray :: PPgPrefTabs
		ON_BN_CLICKED(IDC_MARKLOWID, OnSettingsChange) // Spike2 - MarkLowIDs
		ON_BN_CLICKED(IDC_LOGALCEVENTS, OnSettingsChange) // Spike2 - Log AntiLeechClassEvents
		ON_BN_CLICKED(IDC_LOGBANEVENTS, OnSettingsChange) // Spike2 - Log Banning Events
		ON_BN_CLICKED(IDC_LOGDROPEVENTS, OnSettingsChange) // Spike2 - Log Dropping Events
		ON_BN_CLICKED(IDC_LOGEMUEVENTS, OnSettingsChange) // Spike2 - Log Emulate Events
		ON_BN_CLICKED(IDC_LOGSLSEVENTS, OnSettingsChange) // Spike2 - Log SLS Events
		ON_BN_CLICKED(IDC_LOGSNAFUEVENTS, OnSettingsChange) // Spike2 - Log SNAFU Events
		ON_BN_CLICKED(IDC_DOWNLOADBOLD, OnSettingsChange) // Spike2 - control for showing active downloads in bold
		ON_BN_CLICKED(IDC_TRANSFERARROW, OnSettingsChange) // Spike2 - use Arrow-keys without ALT
		ON_BN_CLICKED(IDC_FAKEALYZER, OnSettingsChange) // Spike2 - Fakealyzer switchable
		ON_BN_CLICKED(IDC_MULTI, OnSettingsChange) // Spike2 - Multiple Instances
		ON_BN_CLICKED(IDC_CLIENTPERCENTAGE, OnSettingsChange) // Spike2 - Show Client Percentage
		ON_BN_CLICKED(IDC_IP2CFLAGS, OnSettingsChange) // Spike2 - IP2Country - Show country flags
		ON_BN_CLICKED(IDC_IP2C2, OnSettingsChange) // Spike2 - IP2Country - Show 2 letters
		ON_BN_CLICKED(IDC_IP2C3, OnSettingsChange) // Spike2 - IP2Country - Show 3 letters
		ON_BN_CLICKED(IDC_IP2CF, OnSettingsChange) // Spike2 - IP2Country - Show full country name
END_MESSAGE_MAP()

	// CPPgSpikeLook message handlers

BOOL CPPgSpikeLook::OnInitDialog()
{

	CPropertyPage::OnInitDialog();

	InitTab(true, theApp.emuledlg->preferenceswnd->StartPageLook); // X-Ray :: PPgPrefTabs

	LoadSettings();
	Localize();

	return TRUE;
}

void CPPgSpikeLook::LoadSettings(void)
{

if(m_hWnd)
	{
	CString strBuffer;
// Spike2 from Xtreme - Mark LowIDs - START
	if (thePrefs.IsMarkLowID())
		CheckDlgButton(IDC_MARKLOWID,1);
    else
        CheckDlgButton(IDC_MARKLOWID,0);
// Spike2 from Xtreme - Mark LowIDs - END

// Spike2 - Logging Options - START
    if (thePrefs.IsLogALCEvents())
		CheckDlgButton(IDC_LOGALCEVENTS,1);
	else
		CheckDlgButton(IDC_LOGALCEVENTS,0);

	if (thePrefs.IsLogBanEvents())
		CheckDlgButton(IDC_LOGBANEVENTS,1);
	else
		CheckDlgButton(IDC_LOGBANEVENTS,0);

	if (thePrefs.IsLogDropEvents())
		CheckDlgButton(IDC_LOGDROPEVENTS,1);
	else
		CheckDlgButton(IDC_LOGDROPEVENTS,0);

	if (thePrefs.IsLogEmuEvents())
		CheckDlgButton(IDC_LOGEMUEVENTS,1);
	else
		CheckDlgButton(IDC_LOGEMUEVENTS,0);

	if (thePrefs.IsLogSLSEvents())
		CheckDlgButton(IDC_LOGSLSEVENTS,1);
	else
		CheckDlgButton(IDC_LOGSLSEVENTS,0);

	if (thePrefs.IsLogSNAFUEvents())
		CheckDlgButton(IDC_LOGSNAFUEVENTS,1);
	else
		CheckDlgButton(IDC_LOGSNAFUEVENTS,0);
// Spike2 - Logging Options - END
// Spike2 - control for showing active downloads in bold - START
	if (thePrefs.GetShowActiveDownloadsBold())
		CheckDlgButton(IDC_DOWNLOADBOLD,1);
	else
		CheckDlgButton(IDC_DOWNLOADBOLD,0);
// Spike2 - control for showing active downloads in bold - END
// Spike2 - use Arrow-keys without ALT - START
	if (thePrefs.IsOldArrow())
		CheckDlgButton(IDC_TRANSFERARROW,1);
	else
		CheckDlgButton(IDC_TRANSFERARROW,0);
// Spike2 - use Arrow-keys without ALT - END
// Spike2 - Fakealyzer switchable - START
	if (thePrefs.IsFakealyzer())
		CheckDlgButton(IDC_FAKEALYZER,1);
	else
		CheckDlgButton(IDC_FAKEALYZER,0);
// Spike2 - Fakealyzer switchable - END
// Spike2 - Multiple Instances - START
	if (thePrefs.GetAllowMultipleInstances())
        CheckDlgButton(IDC_MULTI,1);
	else
		CheckDlgButton(IDC_MULTI,0);
// Spike2 - Multiple Instances - END
// Spike2 - Show Client percentage - START
	if (thePrefs.GetUseClientPercentage())
		CheckDlgButton(IDC_CLIENTPERCENTAGE,1);
	else
		CheckDlgButton(IDC_CLIENTPERCENTAGE,0);
// Spike2 - Show Client percentage - END
// Spike2 - IP2Country - START
	if (thePrefs.GetIP2CountryNameMode() == 0)
		{
			CheckDlgButton(IDC_IP2C2,1);
			CheckDlgButton(IDC_IP2C3,0);
			CheckDlgButton(IDC_IP2CF,0);
		}
	else if (thePrefs.GetIP2CountryNameMode() == 1)
		{
			CheckDlgButton(IDC_IP2C2,0);
			CheckDlgButton(IDC_IP2C3,1);
			CheckDlgButton(IDC_IP2CF,0);
		}
	else if (thePrefs.GetIP2CountryNameMode() == 2)
		{
			CheckDlgButton(IDC_IP2C2,0);
			CheckDlgButton(IDC_IP2C3,0);
			CheckDlgButton(IDC_IP2CF,1);
		}
	if (thePrefs.IsIP2CountryShowFlag())
		CheckDlgButton(IDC_IP2CFLAGS,1);
	else
		CheckDlgButton(IDC_IP2CFLAGS,0);
// Spike2 - IP2Country - END
	}
}

BOOL CPPgSpikeLook::OnApply(){

	CString sBuffer;
       // TCHAR buffer[510];

        // Spike2 from Xtreme - Mark LowIDs - START
        if(IsDlgButtonChecked(IDC_MARKLOWID))
              thePrefs.m_bMarkLowID = true;
        else
              thePrefs.m_bMarkLowID = false;
        // Spike2 from Xtreme - Mark LowIDs - END

		// Spike2 - Logging Options - START
		if(IsDlgButtonChecked(IDC_LOGALCEVENTS))
			thePrefs.m_bLogALCEvents = true;
		else
			thePrefs.m_bLogALCEvents = false;

		if(IsDlgButtonChecked(IDC_LOGBANEVENTS))
			thePrefs.m_bLogBanEvents = true;
		else
			thePrefs.m_bLogBanEvents = false;

		if(IsDlgButtonChecked(IDC_LOGDROPEVENTS))
			thePrefs.m_bLogDropEvents = true;
		else
			thePrefs.m_bLogDropEvents = false;

		if(IsDlgButtonChecked(IDC_LOGEMUEVENTS))
			thePrefs.m_bLogEmuEvents = true;
		else
			thePrefs.m_bLogEmuEvents = false;

		if(IsDlgButtonChecked(IDC_LOGSLSEVENTS))
			thePrefs.m_bLogSLSEvents = true;
		else
			thePrefs.m_bLogSLSEvents = false;

		if(IsDlgButtonChecked(IDC_LOGSNAFUEVENTS))
			thePrefs.m_bLogSNAFUEvents = true;
		else
			thePrefs.m_bLogSNAFUEvents = false;
		// Spike2 - Logging Options - END
		// Spike2 - control for showing active downloads in bold - START
		if(IsDlgButtonChecked(IDC_DOWNLOADBOLD))
			thePrefs.m_bShowActiveDownloadsBold = true;
		else
			thePrefs.m_bShowActiveDownloadsBold = false;
		// Spike2 - control for showing active downloads in bold - END
		// Spike2 - use Arrow-keys without ALT - START
		if(IsDlgButtonChecked(IDC_TRANSFERARROW))
			thePrefs.m_bOldArrow = true;
		else
			thePrefs.m_bOldArrow = false;
		// Spike2 - use Arrow-keys without ALT - END
		// Spike2 - Fakealyzer switchable - START
		if(IsDlgButtonChecked(IDC_FAKEALYZER))
			thePrefs.m_bFakealyzer = true;
		else
			thePrefs.m_bFakealyzer = false;
		// Spike2 - Fakealyzer switchable - END
		// Spike2 - Multiple Instances - START
		if(IsDlgButtonChecked(IDC_MULTI))
			thePrefs.m_bAllowMultipleInstances = true;
		else
			thePrefs.m_bAllowMultipleInstances = false;
		// Spike2 - Multiple Instances - END
		// Spike2 - Show Client percentage - START
		if(IsDlgButtonChecked(IDC_CLIENTPERCENTAGE))
			thePrefs.m_bClientPercentage = true;
		else
			thePrefs.m_bClientPercentage = false;
		// Spike2 - Show Client percentage - END
		// Spike2 - IP2Country - START
		if (IsDlgButtonChecked(IDC_IP2C2))
			thePrefs.SetIP2CountryNameMode(0);
		else if (IsDlgButtonChecked(IDC_IP2C3))
			thePrefs.SetIP2CountryNameMode(1);
		else if (IsDlgButtonChecked(IDC_IP2CF))
			thePrefs.SetIP2CountryNameMode(2);

		if(IsDlgButtonChecked(IDC_IP2CFLAGS))
			thePrefs.m_bIP2CountryShowFlag = true;
		else
			thePrefs.m_bIP2CountryShowFlag = false;
		// Spike2 - IP2Country - END

	LoadSettings();
	return CPropertyPage::OnApply();
}

void CPPgSpikeLook::Localize(void){
}
CPPgSpikeLook::~CPPgSpikeLook(void){
}

// X-Ray :: PPgPrefTabs
void CPPgSpikeLook::InitTab(bool firstinit, int Page)
{
	if (firstinit) {
		m_tabCtr.DeleteAllItems();
		m_tabCtr.SetImageList(&m_imageList);
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Look1, _T("General"), 0, (LPARAM)Look1); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Look2, _T("SCC"), 1, (LPARAM)Look2); 
	}

	m_tabCtr.SetCurSel(Page);
}
void CPPgSpikeLook::OnTcnSelchangeTabLook1(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int cur_sel = m_tabCtr.GetCurSel();
	theApp.emuledlg->preferenceswnd->SwitchTab(cur_sel);
	*pResult = 0;
}
// X-Ray :: End