// PPgSpikeDown.cpp : implementation file
// Thanx to Br4No

#include "stdafx.h"
#include "Preferences.h"
#include "emule.h"
#include "PPgSpikeDown.h"
#include ".\ppgspikedown.h"
#include "OtherFunctions.h"

// CPPgSpikeDown dialog

IMPLEMENT_DYNAMIC(CPPgSpikeDown, CPropertyPage)
CPPgSpikeDown::CPPgSpikeDown()

	: CPropertyPage(CPPgSpikeDown::IDD)
{
}

void CPPgSpikeDown::DoDataExchange(CDataExchange* pDX){

	CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPPgSpikeDown, CPropertyPage)
		ON_BN_CLICKED(IDC_DROPNNP, OnSettingsChange) // Spike2 - Drop System
		ON_BN_CLICKED(IDC_DROPFQR, OnSettingsChange) // Spike2 - Drop System
		ON_BN_CLICKED(IDC_DROPHQR, OnSettingsChange) // Spike2 - Drop System
		ON_EN_CHANGE(IDC_TIMERNNP, OnSettingsChange) // Spike2 - Drop System
		ON_EN_CHANGE(IDC_TIMERFQR, OnSettingsChange) // Spike2 - Drop System
		ON_EN_CHANGE(IDC_TIMERHQR, OnSettingsChange) // Spike2 - Drop System
		ON_EN_CHANGE(IDC_DROPHQRMAX, OnSettingsChange) // Spike2 - Drop System
		ON_EN_CHANGE(IDC_LODATI, OnSettingsChange) // Spike2 - List of don't ask this IPs
		ON_EN_CHANGE(IDC_DROPACTIVATE, OnSettingsChange) // Spike2 - Activation Limit for Dropping
		ON_BN_CLICKED(IDC_SLS, OnSettingsChange) // Spike2 - SLS
		ON_EN_CHANGE(IDC_SLSMINSRC, OnSettingsChange) // Spike2 - SLS
		ON_EN_CHANGE(IDC_SAVESRC, OnSettingsChange) // Spike2 - SLS
		ON_BN_CLICKED(IDC_ICS, OnSettingsChange) // Spike2 - ICS switchable
END_MESSAGE_MAP()

	// CPPgSpikeDown message handlers

BOOL CPPgSpikeDown::OnInitDialog(){

	CPropertyPage::OnInitDialog();

	LoadSettings();
	Localize();

	return TRUE;
}

void CPPgSpikeDown::LoadSettings(void){

		if(m_hWnd)
		{
		      // Spike2 - Drop System - START
			  {
              CString buffer;
		      buffer.Format(_T("%i"), thePrefs.GetDropSourcesTimerNNP()); 
		      GetDlgItem(IDC_TIMERNNP)->SetWindowText(buffer); 
	          }
			  {
              CString buffer;
		      buffer.Format(_T("%i"), thePrefs.GetDropSourcesTimerFQ()); 
		      GetDlgItem(IDC_TIMERFQR)->SetWindowText(buffer); 
	          }			  
			  {
              CString buffer;
		      buffer.Format(_T("%i"), thePrefs.GetDropSourcesTimerHQR()); 
		      GetDlgItem(IDC_TIMERHQR)->SetWindowText(buffer); 
	          }			  
			  {
              CString buffer;
		      buffer.Format(_T("%i"), thePrefs.GetDropSourcesHQRVal()); 
		      GetDlgItem(IDC_DROPHQRMAX)->SetWindowText(buffer); 
	          }
			  // Spike2 - List of don't ask this IPs - START
			  {
              CString buffer;
		      buffer.Format(_T("%i"), thePrefs.GetLODATITimer()); 
		      GetDlgItem(IDC_LODATI)->SetWindowText(buffer); 
	          }
			  // Spike2 - List of don't ask this IPs - END
			  // Spike2 - Activation Limit for Dropping - START
			  {
			  CString buffer;
			  buffer.Format(_T("%i"), thePrefs.GetActivationLimitDrop());
			  GetDlgItem(IDC_DROPACTIVATE)->SetWindowText(buffer);
			  }
			  // Spike2 - Activation Limit for Dropping - END
			  // Spike2 - Drop System - END
			  // Spike2 - SLS - START
			  {
              CString buffer;
		      buffer.Format(_T("%i"), thePrefs.GetActivationLimitSLS()); 
		      GetDlgItem(IDC_SLSMINSRC)->SetWindowText(buffer); 
	          }
			  {
			  CString buffer;
			  buffer.Format(_T("%i"), thePrefs.GetSourcesToSaveSLS());
			  GetDlgItem(IDC_SAVESRC)->SetWindowText(buffer);
			  }
			  // Spike2 - SLS - END
		// Spike2 - Drop System - START
				if (thePrefs.GetDropSourcesNNP())
					CheckDlgButton(IDC_DROPNNP,1);
				else
					CheckDlgButton(IDC_DROPNNP,0);

				if (thePrefs.GetDropSourcesFQ())
					CheckDlgButton(IDC_DROPFQR,1);
				else
					CheckDlgButton(IDC_DROPFQR,0);

				if (thePrefs.GetDropSourcesHQR())
					CheckDlgButton(IDC_DROPHQR,1);
				else
					CheckDlgButton(IDC_DROPHQR,0);
		// Spike2 - Drop System - END
		// Spike2 - SLS - START
				if (thePrefs.UseSaveLoadSources())
					CheckDlgButton(IDC_SLS,1);
				else
					CheckDlgButton(IDC_SLS,0);
		// Spike2 - SLS - END
		// Spike2 - ICS switchable - START
				if (thePrefs.IsICS())
					CheckDlgButton(IDC_ICS,1);
				else
					CheckDlgButton(IDC_ICS,0);
		// Spike2 - ICS switchable - END
		}
}

BOOL CPPgSpikeDown::OnApply(){

	CString buffer;
	//char buffer[510];
	//TCHAR buffer[510];

	if(m_hWnd)
	{
		// Spike2 - Drop System - START
		if (GetDlgItem(IDC_TIMERNNP)->GetWindowTextLength())
		{
			GetDlgItem(IDC_TIMERNNP)->GetWindowText(buffer);
			thePrefs.m_iDropSourcesTimerNNP = ((_tstoi(buffer)>=10)&& (_tstoi(buffer)<=180) ? _tstoi(buffer) : 10);
		}
		if (GetDlgItem(IDC_TIMERFQR)->GetWindowTextLength())
		{
			GetDlgItem(IDC_TIMERFQR)->GetWindowText(buffer);
			thePrefs.m_iDropSourcesTimerFQ = ((_tstoi(buffer)>=10)&& (_tstoi(buffer)<=180) ? _tstoi(buffer) : 20);
		}
		if (GetDlgItem(IDC_TIMERHQR)->GetWindowTextLength())
		{
			GetDlgItem(IDC_TIMERHQR)->GetWindowText(buffer);
			thePrefs.m_iDropSourcesTimerHQR = ((_tstoi(buffer)>=10)&& (_tstoi(buffer)<=180) ? _tstoi(buffer) : 30);
		}
		if (GetDlgItem(IDC_DROPHQRMAX)->GetWindowTextLength())
		{
			GetDlgItem(IDC_DROPHQRMAX)->GetWindowText(buffer);
			thePrefs.m_iDropSourcesHQRVal = ((_tstoi(buffer)>=1500) ? _tstoi(buffer) : 1500);
		}
		// Spike2 - List of don't ask this IPs - START
		if (GetDlgItem(IDC_LODATI)->GetWindowTextLength())
		{
			GetDlgItem(IDC_LODATI)->GetWindowText(buffer);
			thePrefs.m_iLODATITimer = ((_tstoi(buffer)>=2)&& (_tstoi(buffer)<=4) ? _tstoi(buffer) : 4);
		}
		// Spike2 - List of don't ask this IPs - END
		// Spike2 - Activation Limit for Dropping - START
		if (GetDlgItem(IDC_DROPACTIVATE)->GetWindowTextLength())
		{
			GetDlgItem(IDC_DROPACTIVATE)->GetWindowText(buffer);
			thePrefs.m_iActivationLimitDrop = ((_tstoi(buffer)>=0) && (_tstoi(buffer)<=200) ? _tstoi(buffer) : 50);
		}
		// Spike2 - Activation Limit for Dropping - END
		// Spike2 - Drop System - END
		// Spike2 - SLS - START
		if (GetDlgItem(IDC_SLSMINSRC)->GetWindowTextLength())
		{
			GetDlgItem(IDC_SLSMINSRC)->GetWindowText(buffer);
			thePrefs.m_iActivationLimitSLS = (_tstoi(buffer)<=200) ? _tstoi(buffer) : 200;
		}
		if (GetDlgItem(IDC_SAVESRC)->GetWindowTextLength())
		{
			GetDlgItem(IDC_SAVESRC)->GetWindowText(buffer);
			thePrefs.m_iSourcesToSaveSLS = (_tstoi(buffer)<=50) ? _tstoi(buffer) : 50;
		}
		// Spike2 - SLS - END
		// Spike2 - Drop System - START
		if(IsDlgButtonChecked(IDC_DROPNNP))
			thePrefs.m_bDropSourcesNNP = true;
		else
			thePrefs.m_bDropSourcesNNP = false;

		if(IsDlgButtonChecked(IDC_DROPFQR))
			thePrefs.m_bDropSourcesFQ = true;
		else
			thePrefs.m_bDropSourcesFQ = false;

		if(IsDlgButtonChecked(IDC_DROPHQR))
			thePrefs.m_bDropSourcesHQR = true;
		else
			thePrefs.m_bDropSourcesHQR = false;
		// Spike2 - Drop System - END
		// Spike2 - SLS - START
		if(IsDlgButtonChecked(IDC_SLS))
			thePrefs.m_bUseSaveLoadSources = true;
		else
			thePrefs.m_bUseSaveLoadSources = false;
		// Spike2 - SLS - END
		// Spike2 - ICS switchable - START
		if(IsDlgButtonChecked(IDC_ICS))
			thePrefs.m_bICS = true;
		else
			thePrefs.m_bICS = false;
		// Spike2 - ICS switchable - END
	}

	LoadSettings();
	return CPropertyPage::OnApply();
}

void CPPgSpikeDown::Localize(void){
}
CPPgSpikeDown::~CPPgSpikeDown(void){
}