// PPgSpikeCredits.cpp : implementation file

#include "stdafx.h"
#include "Preferences.h"
#include "emule.h"
#include "PPgSpikeCredits.h"
#include "OtherFunctions.h"
#include "emuleDlg.h" // X-Ray :: PPgPrefTabs
#include "PreferencesDlg.h" // X-Ray :: PPgPrefTabs

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__; //'cause everytime we touch I feel so static
#endif

// CPPgSpikeCredits dialog

IMPLEMENT_DYNAMIC(CPPgSpikeCredits, CPropertyPage)
CPPgSpikeCredits::CPPgSpikeCredits()
	: CPropertyPage(CPPgSpikeCredits::IDD)
{
	// X-Ray :: PPgPrefTabs
	m_imageList.DeleteImageList();
	m_imageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 14+1, 0);
	m_imageList.Add(CTempIconLoader(_T("UPLOAD")));
	m_imageList.Add(CTempIconLoader(_T("CREDITS")));
	// X-Ray :: End
}

void CPPgSpikeCredits::DoDataExchange(CDataExchange* pDX){

	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PRF_UPLOAD_TAB_NO2, m_tabCtr); // X-Ray :: PPgPrefTabs
}

BEGIN_MESSAGE_MAP(CPPgSpikeCredits, CPropertyPage)
	ON_NOTIFY(TCN_SELCHANGE, IDC_PRF_UPLOAD_TAB_NO2, OnTcnSelchangeTabUpload2) // X-Ray :: PPgPrefTabs
	ON_BN_CLICKED(IDC_ANTINONSI, OnSettingsChange) // Spike2 - 80% score for non-SI-clients
	ON_BN_CLICKED(IDC_ANTISHAPE, OnSettingsChange) // Spike2 - netF's AntiShape
	ON_BN_CLICKED(IDC_PBFOFF, OnSettingsChange)  // Spike2 - WiZaRd's PaybackFirst
	ON_BN_CLICKED(IDC_PBFSLOT, OnSettingsChange) // Spike2 - WiZaRd's PaybackFirst
	ON_BN_CLICKED(IDC_PBFONCE, OnSettingsChange) // Spike2 - WiZaRd's PaybackFirst
	ON_BN_CLICKED(IDC_PBFAUTO, OnSettingsChange) // Spike2 - WiZaRd's PaybackFirst
	ON_BN_CLICKED(IDC_KNOWNBONUS, OnSettingsChange) // Spike2 - Known Client Bonus switchable
END_MESSAGE_MAP()

	// CPPgSpikeCredits message handlers

BOOL CPPgSpikeCredits::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	InitTab(true, theApp.emuledlg->preferenceswnd->StartPageUpload); // X-Ray :: PPgPrefTabs

	LoadSettings();
	Localize();

	return TRUE;
}

void CPPgSpikeCredits::LoadSettings(void)
{
	if(m_hWnd)
	{
		CString strBuffer;
		// Spike2 - 80% score for non-SI-clients - START
		if (thePrefs.IsAntiNonSI())
			CheckDlgButton(IDC_ANTINONSI,1);
		else
			CheckDlgButton(IDC_ANTINONSI,0);
		// Spike2 - 80% score for non-SI-clients - END
		// Spike2 - netF's AntiShape - START
		if (thePrefs.IsAntiShape())
			CheckDlgButton(IDC_ANTISHAPE,1);
		else
			CheckDlgButton(IDC_ANTISHAPE,0);
		// Spike2 - netF's AntiShape - END
		// Spike2 - Known Client Bonus switchable - START
		if (thePrefs.IsKnownBonus())
			CheckDlgButton(IDC_KNOWNBONUS,1);
		else
			CheckDlgButton(IDC_KNOWNBONUS,0);
		// Spike2 - Known Client Bonus switchable - END
		// Spike2 - WiZaRd's PaybackFirst - START
		if (thePrefs.GetPaybackFirst() == 0)
		{
			CheckDlgButton(IDC_PBFOFF,1);
			CheckDlgButton(IDC_PBFSLOT,0);
			CheckDlgButton(IDC_PBFONCE,0);
			CheckDlgButton(IDC_PBFAUTO,0);
		}
		else if (thePrefs.GetPaybackFirst() == 1)
		{
			CheckDlgButton(IDC_PBFOFF,0);
			CheckDlgButton(IDC_PBFSLOT,1);
			CheckDlgButton(IDC_PBFONCE,0);
			CheckDlgButton(IDC_PBFAUTO,0);
		}
		else if (thePrefs.GetPaybackFirst() == 2)
		{
			CheckDlgButton(IDC_PBFOFF,0);
			CheckDlgButton(IDC_PBFSLOT,0);
			CheckDlgButton(IDC_PBFONCE,1);
			CheckDlgButton(IDC_PBFAUTO,0);
		}
		else if (thePrefs.GetPaybackFirst() == 3)
		{
			CheckDlgButton(IDC_PBFOFF,0);
			CheckDlgButton(IDC_PBFSLOT,0);
			CheckDlgButton(IDC_PBFONCE,0);
			CheckDlgButton(IDC_PBFAUTO,1);
		}
		// Spike2 - WiZaRd's PaybackFirst - END
	} 
} 

BOOL CPPgSpikeCredits::OnApply()
{
	CString sBuffer;
	

        // Spike2 - 80% score for non-SI-clients - START
        if(IsDlgButtonChecked(IDC_ANTINONSI))
              thePrefs.m_bAntiNonSI = true;
        else
              thePrefs.m_bAntiNonSI = false;
        // Spike2 - 80% score for non-SI-clients - END

		// Spike2 - netF's AntiShape - START
		if(IsDlgButtonChecked(IDC_ANTISHAPE))
			thePrefs.m_bAntiShape = true;
		else
			thePrefs.m_bAntiShape = false;
		// Spike2 - netF's AntiShape - END

		// Spike2 - Known Clients Bonus switchable - START
		if(IsDlgButtonChecked(IDC_KNOWNBONUS))
			thePrefs.m_bKnownBonus = true;
		else
			thePrefs.m_bKnownBonus = false;
		// Spike2 - Known Clients Bonus switchable - END
		
		// Spike2 - WiZaRd's PaybackFirst - START
		if (IsDlgButtonChecked(IDC_PBFOFF))
			thePrefs.SetPaybackFirst(0);
		else if (IsDlgButtonChecked(IDC_PBFSLOT))
			thePrefs.SetPaybackFirst(1);
		else if (IsDlgButtonChecked(IDC_PBFONCE))
			thePrefs.SetPaybackFirst(2);
		else if (IsDlgButtonChecked(IDC_PBFAUTO))
			thePrefs.SetPaybackFirst(3);
		// Spike2 - WiZaRd's PaybackFirst - END

	return CPropertyPage::OnApply();
}

void CPPgSpikeCredits::Localize(void)
{
}

CPPgSpikeCredits::~CPPgSpikeCredits(void)
{
}

// X-Ray :: PPgPrefTabs
void CPPgSpikeCredits::InitTab(bool firstinit, int Page)
{
	if (firstinit) {
		m_tabCtr.DeleteAllItems();
		m_tabCtr.SetImageList(&m_imageList);
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Upload1, _T("Upload Tweaks"), 0, (LPARAM)Upload1); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Upload2, _T("Credit Tweaks"), 1, (LPARAM)Upload2); 
	}

	m_tabCtr.SetCurSel(Page);
}
void CPPgSpikeCredits::OnTcnSelchangeTabUpload2(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int cur_sel = m_tabCtr.GetCurSel();
	theApp.emuledlg->preferenceswnd->SwitchTab(cur_sel);
	*pResult = 0;
}
// X-Ray :: End