// PPgSpikeCon.cpp : implementation file
// Thanx to Br4No

#include "stdafx.h"
#include "Preferences.h"
#include "emule.h"
#include "PPgSpikeCon.h"
#include "OtherFunctions.h"
#include "sockets.h" // Spooky-Mode
#include "emuleDlg.h" // X-Ray :: PPgPrefTabs
#include "PreferencesDlg.h" // X-Ray :: PPgPrefTabs
#include ".\ppgspikecon.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// CPPgSpikeCon dialog

IMPLEMENT_DYNAMIC(CPPgSpikeCon, CPropertyPage)

CPPgSpikeCon::CPPgSpikeCon()
	: CPropertyPage(CPPgSpikeCon::IDD)
{
	// X-Ray :: PPgPrefTabs
	m_imageList.DeleteImageList();
	m_imageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 14+1, 0);
	m_imageList.Add(CTempIconLoader(_T("CONNECTION")));
	m_imageList.Add(CTempIconLoader(_T("AHL")));
	// X-Ray :: End
}

void CPPgSpikeCon::DoDataExchange(CDataExchange* pDX){

	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PRF_CONNECTION_TAB_NO1, m_tabCtr); // X-Ray :: PPgPrefTabs
}

BEGIN_MESSAGE_MAP(CPPgSpikeCon, CPropertyPage)
		ON_NOTIFY(TCN_SELCHANGE, IDC_PRF_CONNECTION_TAB_NO1, OnTcnSelchangeTabConnection1) // X-Ray :: PPgPrefTabs
		ON_BN_CLICKED(IDC_EMUMLDONKEY, OnSettingsChange) 	// Spike2 from [ionix] - emulate MLdonkey
		ON_BN_CLICKED(IDC_EMUEDONKEY, OnSettingsChange) // Spike2 from [ionix] - emulate eDonkey
		ON_BN_CLICKED(IDC_EMUHYBRID, OnSettingsChange) // Spike2 from [ionix] - emulate eDonkeyHybrid
		ON_BN_CLICKED(IDC_EMUSHAREAZA, OnSettingsChange) // Spike2 - emulate Shareaza
		ON_BN_CLICKED(IDC_EMULPHANT, OnSettingsChange) // Spike2 - emulate lPhant
		ON_BN_CLICKED(IDC_USEDOUBLESENDSIZE, OnSettingsChange) // Spike2 from XMan - Use double sendsize (MTU-Setting)
	    // [ionix] Fenderman - Spooky Mode [eWombat]	
	    ON_BN_CLICKED(IDC_ReconSpooky, OnSettingsChange) 						
	    ON_BN_CLICKED(IDC_SpookyFailed, OnSpookyFailedChange)					
	    ON_EN_CHANGE(IDC_SpookyFailedCount, OnSettingsChange)				
	    // [ionix] Fenderman - Spooky Mode [eWombat]
	    //>>> WiZaRd: Spooky Mode ConChecker Addon
	    ON_BN_CLICKED(IDC_GetCheckCon, OnConCheckerChange)
	    ON_BN_CLICKED(IDC_GetICMP, OnSettingsChange)
	    ON_EN_CHANGE(IDC_GetPingTimeout, OnSettingsChange)
	    ON_EN_CHANGE(IDC_GetPingTTL, OnSettingsChange)
	    //<<< WiZaRd: Spooky Mode ConChecker Addon
		ON_BN_CLICKED(IDC_RASAIC, OnSettingsChange) // Spike2 from Stullemule: Reask sources after IP-Change
		ON_BN_CLICKED(IDC_INFORMQUEUED, OnSettingsChange) // Spike2 from Stullemule: Inform queued clients after IP-Change
		ON_BN_CLICKED(IDC_L2HAC, OnSettingsChange) // Spike2 - L2HAC
END_MESSAGE_MAP()

	// CPPgSpikeCon message handlers

BOOL CPPgSpikeCon::OnInitDialog(){

	CPropertyPage::OnInitDialog();

	InitTab(true, theApp.emuledlg->preferenceswnd->StartPageConnection); // X-Ray :: PPgPrefTabs

	LoadSettings();
	Localize();

	return TRUE;
}

void CPPgSpikeCon::LoadSettings(void){

		if(m_hWnd)
		{
		CString strBuffer;
		// Spike2 emulate other START
				if (thePrefs.IsEmuMLDonkey())
				CheckDlgButton(IDC_EMUMLDONKEY,1);
				else
				CheckDlgButton(IDC_EMUMLDONKEY,0);
				
				if (thePrefs.IsEmueDonkey())
				CheckDlgButton(IDC_EMUEDONKEY,1);
				else
				CheckDlgButton(IDC_EMUEDONKEY,0);
				
				if (thePrefs.IsEmueDonkeyHybrid())
				CheckDlgButton(IDC_EMUHYBRID,1);
				else
				CheckDlgButton(IDC_EMUHYBRID,0);

				if (thePrefs.IsEmuShareaza())
				CheckDlgButton(IDC_EMUSHAREAZA,1);
				else
				CheckDlgButton(IDC_EMUSHAREAZA,0);

				if (thePrefs.IsEmuLphant())
				CheckDlgButton(IDC_EMULPHANT,1);
				else
				CheckDlgButton(IDC_EMULPHANT,0);
		// Spike2 emulate other END
		// Spike2 Use double sendsize START
				if (thePrefs.IsDoubleSendSize())
				CheckDlgButton(IDC_USEDOUBLESENDSIZE,1);
				else
				CheckDlgButton(IDC_USEDOUBLESENDSIZE,0);
		// Spike2 Use double sendsize END
		// Spike2 from Stullemule: Reask sources... START
				if (thePrefs.IsRASAIC())
					CheckDlgButton(IDC_RASAIC,1);
				else
					CheckDlgButton(IDC_RASAIC,0);
		// Spike2 from Stullemule: Reask sources... END
		// Spike2 from Stullemule: Inform queued... START
				if (thePrefs.IsInformQueued())
					CheckDlgButton(IDC_INFORMQUEUED,1);
				else
					CheckDlgButton(IDC_INFORMQUEUED,0);
		// Spike2 from Stullemule: Inform queued... END
		// Spike2 - L2HAC - START
				if (thePrefs.UseLowID2HighIDAutoCallback())
					CheckDlgButton(IDC_L2HAC,1);
				else
					CheckDlgButton(IDC_L2HAC,0);
		// Spike2 - L2HAC - END
		// [ionix] Fenderman - Spooky Mode [eWombat]
		CheckDlgButton(IDC_ReconSpooky, thePrefs.GetReconSpooky());
		CheckDlgButton(IDC_SpookyFailed, thePrefs.GetSpookyFailed());
		GetDlgItem(IDC_SpookyFailedCount)->EnableWindow(thePrefs.GetSpookyFailed()); 
		strBuffer.Format(_T("%u"), thePrefs.m_iSpookyFailedCount);
		GetDlgItem(IDC_SpookyFailedCount)->SetWindowText(strBuffer);		
		// [ionix] Fenderman - Spooky Mode [eWombat]
		//>>> WiZaRd: Spooky Mode ConChecker Addon 
		CheckDlgButton(IDC_GetCheckCon, thePrefs.GetCheckCon());
		CheckDlgButton(IDC_GetICMP, thePrefs.GetICMP());

		strBuffer.Format(_T("%u"), thePrefs.GetPingTimeout());
		GetDlgItem(IDC_GetPingTimeout)->SetWindowText(strBuffer);

		strBuffer.Format(_T("%u"), thePrefs.GetPingTTL());
		GetDlgItem(IDC_GetPingTTL)->SetWindowText(strBuffer);
		OnConCheckerChange(); // [ionix]: added
		//<<< WiZaRd: Spooky Mode ConChecker Addon 
	}
}

BOOL CPPgSpikeCon::OnApply(){

	CString sBuffer;
	// TCHAR buffer[510];
		
	// Spike2 - emulate other START
	if(IsDlgButtonChecked(IDC_EMUMLDONKEY))
		thePrefs.m_bEmuMLDonkey = true;
	else
		thePrefs.m_bEmuMLDonkey = false;

	if(IsDlgButtonChecked(IDC_EMUEDONKEY))
		thePrefs.m_bEmueDonkey = true;
	else
		thePrefs.m_bEmueDonkey = false;

	if(IsDlgButtonChecked(IDC_EMUHYBRID))
		thePrefs.m_bEmueDonkeyHybrid = true;
	else
		thePrefs.m_bEmueDonkeyHybrid = false;

	if(IsDlgButtonChecked(IDC_EMUSHAREAZA))
		thePrefs.m_bEmuShareaza = true;
	else
		thePrefs.m_bEmuShareaza = false;

	if(IsDlgButtonChecked(IDC_EMULPHANT))
		thePrefs.m_bEmuLphant = true;
	else
		thePrefs.m_bEmuLphant = false;
	// Spike2 - emulate other END
	// Spike2 from XMan - Double Sendsize (MTU) START
	if(IsDlgButtonChecked(IDC_USEDOUBLESENDSIZE))
		thePrefs.usedoublesendsize = true;
	else
		thePrefs.usedoublesendsize = false;
	// Spike2 from XMan - Double Sendsize (MTU) END
	// Spike2 from Stullemule - Reask sources... START
	if(IsDlgButtonChecked(IDC_RASAIC))
		thePrefs.m_bRASAIC = true;
	else
		thePrefs.m_bRASAIC = false;
	// Spike2 from Stullemule - Reask sources... END
	// Spike2 from Stullemule - Inform queued... START
	if(IsDlgButtonChecked(IDC_INFORMQUEUED))
		thePrefs.m_bInformQueued = true;
	else
		thePrefs.m_bInformQueued = false;
	// Spike2 from Stullemule - Inform queued... END
	// Spike2 - L2HAC - START
	if(IsDlgButtonChecked(IDC_L2HAC))
		thePrefs.m_bL2HAC = true;
	else
		thePrefs.m_bL2HAC = false;
	// Spike2 - L2HAC - END
	// [ionix] Fenderman - Spooky Mode [eWombat]
	thePrefs.m_bReconSpooky = IsDlgButtonChecked(IDC_ReconSpooky)!=0;
	thePrefs.m_bSpookyFailed = IsDlgButtonChecked(IDC_SpookyFailed)!=0;

	if(GetDlgItem(IDC_SpookyFailedCount)->GetWindowTextLength())
	{
		GetDlgItem(IDC_SpookyFailedCount)->GetWindowText(sBuffer);
		thePrefs.m_iSpookyFailedCount = (_tstoi(sBuffer)) ? _tstoi(sBuffer) : 5;
	}
	// [ionix] Fenderman - Spooky Mode [eWombat]
	//>>> WiZaRd: Spooky Mode ConChecker Addon 
	bool m_bTest = thePrefs.m_bCheckCon;
	thePrefs.m_bCheckCon = IsDlgButtonChecked(IDC_GetCheckCon)!=0;
	if(m_bTest != thePrefs.m_bCheckCon)
	{
		//wasn't activated? start now...
		if (!m_bTest) 
			theApp.conchecker.Process((DWORD)0);
		//was running? shut down...
		else
		{
			theApp.conchecker.SetForceMode(CONFORCE_NULL);
			if (theApp.serverconnect->IsSpooky())
				theApp.serverconnect->DisconnectSpooky();
			if (theApp.GetConnectionState()==CONSTATE_OFFLINE)
				theApp.SetConnectionState(CONSTATE_ONLINE);
		}
	}

	thePrefs.m_bICMP = IsDlgButtonChecked(IDC_GetICMP)!=0;

	if(GetDlgItem(IDC_GetPingTimeout)->GetWindowTextLength())
	{
		GetDlgItem(IDC_GetPingTimeout)->GetWindowText(sBuffer);
		thePrefs.m_uiPingTimeOut = (_tstoi(sBuffer)) ? _tstoi(sBuffer) : 5;
	}

	if(GetDlgItem(IDC_GetPingTTL)->GetWindowTextLength())
	{
		GetDlgItem(IDC_GetPingTTL)->GetWindowText(sBuffer);
		thePrefs.m_uiPingTTL = (_tstoi(sBuffer)) ? _tstoi(sBuffer) : 5;
	}
	//<<< WiZaRd: Spooky Mode ConChecker Addon 

 
	LoadSettings();
	return CPropertyPage::OnApply();
}

void CPPgSpikeCon::Localize(void){
}
CPPgSpikeCon::~CPPgSpikeCon(void){
}

// X-Ray :: PPgPrefTabs
void CPPgSpikeCon::InitTab(bool firstinit, int Page)
{
	if (firstinit) {
		m_tabCtr.DeleteAllItems();
		m_tabCtr.SetImageList(&m_imageList);
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Connection1, _T("General"), 0, (LPARAM)Connection1); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Connection2, _T("Auto HardLimit"), 1, (LPARAM)Connection2); 
	}

	m_tabCtr.SetCurSel(Page);
}
void CPPgSpikeCon::OnTcnSelchangeTabConnection1(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int cur_sel = m_tabCtr.GetCurSel();
	theApp.emuledlg->preferenceswnd->SwitchTab(cur_sel);
	*pResult = 0;
}
// X-Ray :: End

void CPPgSpikeCon::OnSpookyFailedChange()
{	
	GetDlgItem(IDC_SpookyFailedCount)->EnableWindow(IsDlgButtonChecked(IDC_SpookyFailed)!=0); 
	SetModified();
}

void CPPgSpikeCon::OnConCheckerChange()
{	
	if(IsDlgButtonChecked(IDC_GetCheckCon)!=0)
	{
		GetDlgItem(IDC_GetICMP)->EnableWindow(true);
		GetDlgItem(IDC_GetPingTimeout)->EnableWindow(true);
		GetDlgItem(IDC_GetPingTTL)->EnableWindow(true);
	}
	else
	{
		GetDlgItem(IDC_GetICMP)->EnableWindow(false);
		GetDlgItem(IDC_GetPingTimeout)->EnableWindow(false);
		GetDlgItem(IDC_GetPingTTL)->EnableWindow(false);
	}
	SetModified();
}