// PPgSpikeAHL.cpp : implementation file

#include "stdafx.h"
#include "emule.h"
#include "PPgSpikeAHL.h"
#include "OtherFunctions.h"
#include "emuleDlg.h" // X-Ray :: PPgPrefTabs
#include "PreferencesDlg.h" // X-Ray :: PPgPrefTabs
#include ".\ppgspikeahl.h"
#include "DownloadQueue.h" //WiZaRd's AutoHL
#include "PartFile.h" //WiZaRd's AutoHL

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// CPPgSpikeAHL dialog

IMPLEMENT_DYNAMIC(CPPgSpikeAHL, CPropertyPage)
CPPgSpikeAHL::CPPgSpikeAHL()

	: CPropertyPage(CPPgSpikeAHL::IDD)
{
	// X-Ray :: PPgPrefTabs
	m_imageList.DeleteImageList();
	m_imageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 14+1, 0);
	m_imageList.Add(CTempIconLoader(_T("CONNECTION")));
	m_imageList.Add(CTempIconLoader(_T("AHL")));
	// X-Ray :: End
}

void CPPgSpikeAHL::DoDataExchange(CDataExchange* pDX){

	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PRF_CONNECTION_TAB_NO2, m_tabCtr); // X-Ray :: PPgPrefTabs
}

BEGIN_MESSAGE_MAP(CPPgSpikeAHL, CPropertyPage)
	ON_NOTIFY(TCN_SELCHANGE, IDC_PRF_CONNECTION_TAB_NO2, OnTcnSelchangeTabConnection2) // X-Ray :: PPgPrefTabs
	ON_BN_CLICKED(IDC_AHL_PERFILE, OnSettingsChange)  // Spike2 - WiZaRd's AutoHL
	ON_BN_CLICKED(IDC_AHL_OFF, OnSettingsChange) // Spike2 - WiZaRd's AutoHL
	ON_BN_CLICKED(IDC_AHL_ON, OnSettingsChange) // Spike2 - WiZaRd's AutoHL
	ON_EN_CHANGE(IDC_MAXSRC_GLOBAL, OnSettingsChange) // Spike2 - WiZaRd's AutoHL
	ON_EN_CHANGE(IDC_MAXSRC_FILE, OnSettingsChange) // Spike2 - WiZaRd's AutoHL
	ON_EN_CHANGE(IDC_MINSRC_FILE, OnSettingsChange) // Spike2 - WiZaRd's AutoHL
	ON_EN_CHANGE(IDC_AHL_TIMER, OnSettingsChange) // Spike2 - WiZaRd's AutoHL
END_MESSAGE_MAP()

	// CPPgSpikeAHL message handlers

BOOL CPPgSpikeAHL::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	InitTab(true, theApp.emuledlg->preferenceswnd->StartPageConnection); // X-Ray :: PPgPrefTabs

	LoadSettings();
	Localize();

	return TRUE;
}

void CPPgSpikeAHL::LoadSettings(void)
{
	if(m_hWnd)
	{
		CString strBuffer;
		// Spike2 - WiZaRd's AutoHL - START
		if (thePrefs.IsUseAutoHL() == 0)
		{
			CheckDlgButton(IDC_AHL_PERFILE,1);
			CheckDlgButton(IDC_AHL_OFF,0);
			CheckDlgButton(IDC_AHL_ON,0);
		}
		else if (thePrefs.IsUseAutoHL() == 1)
		{
			CheckDlgButton(IDC_AHL_PERFILE,0);
			CheckDlgButton(IDC_AHL_OFF,1);
			CheckDlgButton(IDC_AHL_ON,0);
		}
		else if (thePrefs.IsUseAutoHL() == 2)
		{
			CheckDlgButton(IDC_AHL_PERFILE,0);
			CheckDlgButton(IDC_AHL_OFF,0);
			CheckDlgButton(IDC_AHL_ON,1);
		}
		{
            CString buffer;
		    buffer.Format(_T("%i"), thePrefs.GetAutoHLUpdateTimer()); 
		    GetDlgItem(IDC_AHL_TIMER)->SetWindowText(buffer); 
	    }
		{
            CString buffer;
		    buffer.Format(_T("%i"), thePrefs.GetMinAutoHL()); 
		    GetDlgItem(IDC_MINSRC_FILE)->SetWindowText(buffer); 
	    }
		{
            CString buffer;
		    buffer.Format(_T("%i"), thePrefs.GetMaxAutoHL()); 
		    GetDlgItem(IDC_MAXSRC_FILE)->SetWindowText(buffer); 
	    }
		{
            CString buffer;
		    buffer.Format(_T("%i"), thePrefs.GetMaxSourcesHL()); 
		    GetDlgItem(IDC_MAXSRC_GLOBAL)->SetWindowText(buffer); 
	    }
		// Spike2 - WiZaRd's AutoHL - END
	} 
} 

BOOL CPPgSpikeAHL::OnApply()
{
	CString buffer;
	//TCHAR buffer[510];

	// Spike2 - WiZaRd's AutoHL - START
	if (IsDlgButtonChecked(IDC_AHL_PERFILE))
		thePrefs.SetUseAutoHL(0);
	else if (IsDlgButtonChecked(IDC_AHL_OFF))
	{
		for(UINT i = 0; i < (UINT)theApp.downloadqueue->GetFileCount(); i++)
			theApp.downloadqueue->GetFileByIndex(i)->SetPrivateMaxSources(thePrefs.GetMaxSourcePerFileDefault());
		thePrefs.SetUseAutoHL(1);
	}
	else if (IsDlgButtonChecked(IDC_AHL_ON))
		thePrefs.SetUseAutoHL(2);
	
	if (GetDlgItem(IDC_AHL_TIMER)->GetWindowTextLength())
	{
		GetDlgItem(IDC_AHL_TIMER)->GetWindowText(buffer);
		//thePrefs.SetAutoHLUpdateTimer(_tstoi(buffer));
		thePrefs.m_iAutoHLUpdateTimer = (_tstoi(buffer));
	}
	if (GetDlgItem(IDC_MINSRC_FILE)->GetWindowTextLength())
	{
		GetDlgItem(IDC_MINSRC_FILE)->GetWindowText(buffer);
		thePrefs.SetMinAutoHL(_tstoi(buffer));
	}
	if (GetDlgItem(IDC_MAXSRC_FILE)->GetWindowTextLength())
	{
		GetDlgItem(IDC_MAXSRC_FILE)->GetWindowText(buffer);
		thePrefs.SetMaxAutoHL(_tstoi(buffer));
	}
	if (GetDlgItem(IDC_MAXSRC_GLOBAL)->GetWindowTextLength())
	{
		GetDlgItem(IDC_MAXSRC_GLOBAL)->GetWindowText(buffer);
		thePrefs.SetMaxSourcesHL(_tstoi(buffer));
	}
	// Spike2 - WiZaRd's AutoHL - END

	return CPropertyPage::OnApply();
}

void CPPgSpikeAHL::Localize(void)
{
}

CPPgSpikeAHL::~CPPgSpikeAHL(void)
{
}

// X-Ray :: PPgPrefTabs
void CPPgSpikeAHL::InitTab(bool firstinit, int Page)
{
	if (firstinit) {
		m_tabCtr.DeleteAllItems();
		m_tabCtr.SetImageList(&m_imageList);
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Connection1, _T("General"), 0, (LPARAM)Connection1); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Connection2, _T("Auto HardLimit"), 1, (LPARAM)Connection2); 
	}

	m_tabCtr.SetCurSel(Page);
}
void CPPgSpikeAHL::OnTcnSelchangeTabConnection2(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int cur_sel = m_tabCtr.GetCurSel();
	theApp.emuledlg->preferenceswnd->SwitchTab(cur_sel);
	*pResult = 0;
}
// X-Ray :: End