#pragma once
#include "ResizableLib\ResizableDialog.h"
#include "IconStatic.h"
#include "kademlia/routing/contact.h"

class CKadContactListCtrl;
class CKadContactHistogramCtrl;
class CKadSearchListCtrl;
class CCustomAutoComplete;

class CKademliaWnd : public CResizableDialog
{
	DECLARE_DYNAMIC(CKademliaWnd)

public:
	CKademliaWnd(CWnd* pParent = NULL);   // standard constructor
	virtual ~CKademliaWnd();

	// Dialog Data
	enum { IDD = IDD_KADEMLIAWND };

	// Contacts
	UINT GetContactCount() const;
	void UpdateKadContactCount();
	void ShowContacts();
	void HideContacts();

// By Taz - KadBootStrap
	// NEO: KBS - [KadBootStrap] -- Xanatos -->
	bool UpdateNodesDatFromURL(CString strURL);
	BOOL SaveNodesDatStrings();
	void ResetHistory();
	// NEO: KBS END <-- Xanatos --
// <------- KadBootStrap

	bool ContactAdd(const Kademlia::CContact* contact);
	void ContactRem(const Kademlia::CContact* contact);
	void ContactRef(const Kademlia::CContact* contact);

	// Searches
	CKadSearchListCtrl* searchList;

	void Localize();
	void UpdateControlsState();
	BOOL SaveAllSettings();

protected:
	CStatic kadContactLab;
	CStatic kadSearchLab;
	CIconStatic m_ctrlBootstrap;

// By Taz - KadBootStrap
	// NEO: KBS - [KadBootStrap] -- Xanatos -->
	CIconStatic m_ctrlUpdateNodesFrm;
	CCustomAutoComplete* m_pacNodesDatURL;
	// NEO: KBS END <-- Xanatos --
// <------- KadBootStrap

	CKadContactListCtrl* m_contactListCtrl;
	CKadContactHistogramCtrl* m_contactHistogramCtrl;
	CCustomAutoComplete* m_pacONBSIPs;
	HICON icon_kadcont;
	HICON icon_kadsea;

	void SetAllIcons();

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual BOOL PreTranslateMessage(MSG* pMsg);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnBnClickedBootstrapbutton();

// By Taz - KadBootStrap
	// NEO: KBS - [KadBootStrap] -- Xanatos -->
	afx_msg void OnBnClickedUpdateNodesDatFromUrl();
	afx_msg void OnNodTextChange();
	afx_msg void OnDDClicked();
	// NEO: KBS END <-- Xanatos --
// <------- KadBootStrap

	afx_msg void OnBnConnect();
	afx_msg void OnBnClickedFirewallcheckbutton();
	afx_msg void OnSysColorChange();
	afx_msg void OnEnSetfocusBootstrapip();

// By Taz - IP2Country
//>>> WiZaRd::IP2Country [EastShare]
public:
	void		ResetIP2Country();
//<<< WiZaRd::IP2Country [EastShare]
// <------- IP2Country

};
