// X-Ray :: RollUpCtrl :: Start
//this file is part of eMule
//Copyright (C)2002-2005 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once
#include "ResizableLib\ResizableDialog.h"
#include "SplitterControl.h"
#include "BtnST.h"
#include "TabCtrl.hpp"
#include "UploadListCtrl.h"
#include "DownloadListCtrl.h"
#include "QueueListCtrl.h"
#include "ClientListCtrl.h"
#include "DownloadClientsCtrl.h"
#include "opcodes.h"
#include "share.h"
#include "AddOns\RollUpCtrl\RollupCtrl.h"

class CDropDownButton;
class CToolTipCtrlX;
class CUploadListCtrl;
class CDownloadListCtrl;
class CDownloadClientsCtrl;
class CQueueListCtrl;
class CClientListCtrl;
class CDummyForTabs;

enum EnumDownPanelWindows
{
	DPW_DOWNLOADLIST = 0,
	DPW_DOWNLOADCLIENTLIST,
};

enum EnumMiddlePanelWindows
{
	MPW_UPLOADLIST = 0,
	MPW_UPLOADQUEUELIST,
	MPW_UPLOADCLIENTLIST,
};

enum EnumExtPanelWindows
{
	EPW_LIST1 = 0,
	EPW_LIST2,
};

enum EnumPanelWindows
{
	PW_DOWN = 0,
	PW_MIDDLE,
	PW_EXT
};

class CTransferWnd : public CResizableDialog
{
	DECLARE_DYNAMIC(CTransferWnd)

public:
	CTransferWnd(CWnd* pParent = NULL);   // standard constructor
	virtual ~CTransferWnd();

	void	SwitchUploadList();
	//void	SwitchExtList();
	void	Localize();
	void	UpdateCatTabTitles(bool force = true);
	void	VerifyCatTabSize();
	void	SetToolTipsDelay(DWORD dwDelay);
	bool	downloadlistactive;

	void	InitRollupItemHeights();
	void	SaveRollupItemHeights();
	void	UpdateDownloadHeader();
	void	UpdateUploadHeader();
	void	UpdateExtendedHeader();	
	void	OnDisableList();

	// Dialog Data
	enum { IDD = IDD_TRANSFER };
	EnumDownPanelWindows	m_nActiveDownWnd;
	EnumMiddlePanelWindows	m_nActiveUpWnd;
	EnumExtPanelWindows		m_nActiveExtWnd;
	
	CRollupCtrl				m_ctlRollup;
	CDummyForTabs			*m_pwndDummyForDownloadList;
	CDummyForTabs			*m_pwndDummyForDownloadList2;
	
	CUploadListCtrl			uploadlistctrl;
	CDownloadListCtrl		downloadlistctrl;
	CQueueListCtrl			queuelistctrl;
	CClientListCtrl			clientlistctrl;
	CDownloadClientsCtrl	downloadclientsctrl;

	void SetDlgItemFocus(int nID);
	int AddCategory(CString strNewTitle, CString strNewIncoming, CString strNewComment, CString strNewAutoCat, bool bAddTab = true);

private:
	void		OnDblClickDltab();
	uint8		windowtransferstate;
	CButtonST	m_uplBtn;
	TabControl	m_dlTab;
	int			rightclickindex;
	void		EditCatTabLabel(int index, CString newlabel);
	void		EditCatTabLabel(int index);
	void		UpdateTabToolTips() {UpdateTabToolTips(-1);}
	void		UpdateTabToolTips(int tab);
	CString		GetTabStatistic(int tab);
	
	CFont		m_fontCat;
	bool		m_bFirstShow;
	int			m_nDragIndex;
	int			m_nDropIndex;
	int			m_nLastCatTT;
	int			m_isetcatmenu;
	bool		m_bIsDragging;
	CImageList* m_pDragImage;
	CImageList	m_ImageList;
	HICON		icon_download;
	POINT		m_pLastMousePoint;
	CToolTipCtrlX* m_tooltipCats;
	int			GetTabUnderMouse(CPoint* point);
	int			GetItemUnderMouse(CListCtrl* ctrl);

protected:
	void DoSplitResize(int delta);
	CSplitterControl m_wndSplitter;
	CString GetCatTitle(int catid);

	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg void OnHoverDownloadList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnHoverUploadList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLvnBeginDragDownloadList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnKeydownDownloadList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnNmRClickDltab(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnSysColorChange();
	afx_msg void OnTabMovement(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg BOOL OnToolTipNotify(UINT id, NMHDR *pNMH, LRESULT *pResult);
	afx_msg void OnTcnSelchangeDltab(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnDestroy();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnMeasureItem(int nIDCtl, LPMEASUREITEMSTRUCT lpMeasureItemStruct); // X-Ray :: XPMenus
};
// X-Ray :: RollUpCtrl :: End