//this file is part of eMule
//Copyright (C)2002-2005 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "emuleDlg.h"
#include "SharedFilesWnd.h"
#include "OtherFunctions.h"
#include "SharedFileList.h"
#include "KnownFileList.h"
#include "KnownFile.h"
#include "UserMsgs.h"
#include "HelpIDs.h"
#include "PreferencesDlg.h"	// X-Ray :: PrefSlider

// X-Ray :: QueueListPerFile :: Start
#include "DropDownButton.h"
#include "MenuCmds.h"
#include "UploadQueue.h"
#include "updownclient.h"
// X-Ray :: QueueListPerFile :: End


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define	SPLITTER_RANGE_MIN		100
#define	SPLITTER_RANGE_MAX		350

// X-Ray :: QueueListPerFile :: Start
#define	DETAIL_SPLITTER_BOTTOM		107
#define	DETAIL_SPLITTER_TOP			87
#define	DETAIL_TOOLBAR_OFFSET		WNDS_BUTTON_WIDTH+NUMS_WINA_BUTTONS*DFLT_TOOLBAR_BTN_WIDTH

#define	DFLT_TOOLBAR_BTN_WIDTH	27

#define	WNDS_BUTTON_XOFF	8
#define	WNDS_BUTTON_WIDTH	90
#define	WNDS_BUTTON_HEIGHT	22	// don't set the height do something different than 22 unless you know exactly what you are doing!
#define	NUMS_WINA_BUTTONS	2
// X-Ray :: QueueListPerFile :: End

#define	SPLITTER_MARGIN			0
#define	SPLITTER_WIDTH			4


// CSharedFilesWnd dialog

IMPLEMENT_DYNAMIC(CSharedFilesWnd, CDialog)

BEGIN_MESSAGE_MAP(CSharedFilesWnd, CResizableDialog)
	// X-Ray :: QueueListPerFile :: Start
	/*
	ON_BN_CLICKED(IDC_RELOADSHAREDFILES, OnBnClickedReloadSharedFiles)
	*/
	// X-Ray :: QueueListPerFile :: End
	ON_MESSAGE(UM_DELAYED_EVALUATE, OnChangeFilter)
	ON_NOTIFY(LVN_ITEMACTIVATE, IDC_SFLIST, OnLvnItemActivateSharedFiles)
	ON_NOTIFY(NM_CLICK, IDC_SFLIST, OnNmClickSharedFiles)
	ON_NOTIFY(TVN_SELCHANGED, IDC_SHAREDDIRSTREE, OnTvnSelChangedSharedDirsTree)
	ON_NOTIFY(TBN_DROPDOWN, IDC_SHAREDFILES_DETAIL_TOOLBAR, OnDetailBtnClick) // X-Ray :: QueueListPerFile
	ON_STN_DBLCLK(IDC_FILES_ICO, OnStnDblClickFilesIco)
	ON_WM_CTLCOLOR()
	ON_WM_HELPINFO()
	ON_WM_SYSCOLORCHANGE()
END_MESSAGE_MAP()

CSharedFilesWnd::CSharedFilesWnd(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CSharedFilesWnd::IDD, pParent)
{
	icon_files = NULL;
	m_nFilterColumn = 0;
	m_btnDetail = new CDropDownButton; // X-Ray :: QueueListPerFile
}

CSharedFilesWnd::~CSharedFilesWnd()
{
	m_ctlSharedListHeader.Detach();
	if (icon_files)
		VERIFY( DestroyIcon(icon_files) );
	delete m_btnDetail; // X-Ray :: QueueListPerFile
}

void CSharedFilesWnd::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SFLIST, sharedfilesctrl);
	DDX_Control(pDX, IDC_POPBAR, pop_bar);
	DDX_Control(pDX, IDC_POPBAR2, pop_baraccept);
	DDX_Control(pDX, IDC_POPBAR3, pop_bartrans);
	// X-Ray :: QueueListPerFile :: Start
	/*
	DDX_Control(pDX, IDC_STATISTICS, m_ctrlStatisticsFrm);
	*/
	// X-Ray :: QueueListPerFile :: End
	DDX_Control(pDX, IDC_SHAREDDIRSTREE, m_ctlSharedDirTree);
	DDX_Control(pDX, IDC_SHAREDFILES_FILTER, m_ctlFilter);
	// X-Ray :: QueueListPerFile :: Start
	DDX_Control(pDX, IDC_SHAREDFILES_DETAIL_TOOLBAR, *m_btnDetail);
	DDX_Control(pDX, IDC_SHAREDFILES_DETAIL_QUEUELIST, m_ctlQueuelistctrl);
	// X-Ray :: QueueListPerFile :: End
}

BOOL CSharedFilesWnd::OnInitDialog()
{
	CResizableDialog::OnInitDialog();
	InitWindowStyles(this);
	SetAllIcons();
	sharedfilesctrl.Init();
	m_ctlQueuelistctrl.Init(); // X-Ray :: QueueListPerFile
	m_ctlSharedDirTree.Initalize(&sharedfilesctrl);
	if (thePrefs.GetUseSystemFontForMainControls())
		m_ctlSharedDirTree.SendMessage(WM_SETFONT, NULL, FALSE);

	m_ctlSharedListHeader.Attach(sharedfilesctrl.GetHeaderCtrl()->Detach());
	CArray<int, int> aIgnore; // ignored no-text columns for filter edit
	aIgnore.Add(8); // shared parts
	aIgnore.Add(11); // shared ed2k/kad
	m_ctlFilter.OnInit(&m_ctlSharedListHeader, &aIgnore);

	pop_bar.SetGradientColors(RGB(255,255,240),RGB(255,255,0));
	pop_bar.SetTextColor(RGB(20,70,255));
	pop_baraccept.SetGradientColors(RGB(255,255,240),RGB(255,255,0));
	pop_baraccept.SetTextColor(RGB(20,70,255));
	pop_bartrans.SetGradientColors(RGB(255,255,240),RGB(255,255,0));
	pop_bartrans.SetTextColor(RGB(20,70,255));

	CRect rcSpl;
	m_ctlSharedDirTree.GetWindowRect(rcSpl);
	ScreenToClient(rcSpl);
	rcSpl.left = rcSpl.right + SPLITTER_MARGIN;
	rcSpl.right = rcSpl.left + SPLITTER_WIDTH;
	m_wndSplitter.Create(WS_CHILD | WS_VISIBLE, rcSpl, this, IDC_SPLITTER_SHAREDFILES);

	AddAnchor(m_wndSplitter, TOP_LEFT);
	AddAnchor(sharedfilesctrl, TOP_LEFT, BOTTOM_RIGHT);
	// X-Ray :: QueueListPerFile :: Start
	/*
	AddAnchor(m_ctrlStatisticsFrm, BOTTOM_LEFT, BOTTOM_RIGHT);
	*/
	// X-Ray :: QueueListPerFile :: End
	AddAnchor(IDC_CURSESSION_LBL, BOTTOM_LEFT);
	AddAnchor(IDC_FSTATIC4, BOTTOM_LEFT);
	AddAnchor(IDC_SREQUESTED, BOTTOM_LEFT);
	AddAnchor(IDC_FSTATIC5, BOTTOM_LEFT);
	AddAnchor(IDC_SACCEPTED, BOTTOM_LEFT);
	AddAnchor(IDC_FSTATIC6, BOTTOM_LEFT);
	AddAnchor(IDC_STRANSFERRED, BOTTOM_LEFT);
	AddAnchor(m_ctlSharedDirTree, TOP_LEFT, BOTTOM_LEFT);
	AddAnchor(pop_bar, BOTTOM_LEFT, BOTTOM_RIGHT);
	AddAnchor(pop_baraccept, BOTTOM_LEFT, BOTTOM_RIGHT);
	AddAnchor(pop_bartrans, BOTTOM_LEFT, BOTTOM_RIGHT);
	AddAnchor(m_ctlFilter, TOP_LEFT);
	AddAnchor(IDC_FILES_ICO, TOP_LEFT);
	AddAnchor(IDC_RELOADSHAREDFILES, TOP_RIGHT);
	AddAnchor(IDC_TOTAL_LBL, BOTTOM_RIGHT);
	AddAnchor(IDC_SREQUESTED2,BOTTOM_RIGHT);
	AddAnchor(IDC_FSTATIC7,BOTTOM_RIGHT);
	AddAnchor(IDC_FSTATIC8,BOTTOM_RIGHT);
	AddAnchor(IDC_FSTATIC9,BOTTOM_RIGHT);
	AddAnchor(IDC_STRANSFERRED2,BOTTOM_RIGHT);
	AddAnchor(IDC_SACCEPTED2,BOTTOM_RIGHT);
	AddAnchor(IDC_TRAFFIC_TEXT, TOP_LEFT);

	// X-Ray :: QueueListPerFile :: Start
	// init the HSplitter
	CRect rcSFList;
	GetDlgItem(IDC_SFLIST)->GetWindowRect(rcSFList);
	ScreenToClient(rcSFList);

	CRect rcSW;
	GetWindowRect(rcSW);
	ScreenToClient(rcSW);

	CRect rcDSpl;
	rcDSpl.left = rcSFList.left + DETAIL_TOOLBAR_OFFSET;
	rcDSpl.right = rcSFList.right;
	rcDSpl.top = rcSW.bottom - DETAIL_SPLITTER_BOTTOM;
	rcDSpl.bottom = rcSW.bottom - DETAIL_SPLITTER_BOTTOM + SPLITTER_WIDTH;
	m_wndDetailSplitter.Create(WS_CHILD | WS_VISIBLE, rcDSpl, this, IDC_SHAREDFILES_DETAIL_SPLITTER);
	// X-Ray :: QueueListPerFile :: End

	int iPosStatInit = rcSpl.left;
	int iPosStatNew = thePrefs.GetSplitterbarPositionShared();
	if (iPosStatNew > SPLITTER_RANGE_MAX)
		iPosStatNew = SPLITTER_RANGE_MAX;
	else if (iPosStatNew < SPLITTER_RANGE_MIN)
		iPosStatNew = SPLITTER_RANGE_MIN;
	rcSpl.left = iPosStatNew;
	rcSpl.right = iPosStatNew + SPLITTER_WIDTH;
	if (iPosStatNew != iPosStatInit)
	{
		m_wndSplitter.MoveWindow(rcSpl);
		DoResize(iPosStatNew - iPosStatInit);
	}

	// X-Ray :: QueueListPerFile :: Start
	SwitchTabs(ST_STATISTICS);
	ResetShareDetailToolbar();
	m_btnDetail->CheckButton(MP_VIEW_STATISTICS);
	m_btnDetail->SetWindowText(GetResString(IDS_SF_STATISTICS));

	// init the queuelist
	CRect rc;
	m_ctlSharedDirTree.GetWindowRect(rc);
	ScreenToClient(rc);

	CRect rcQueue;
	rcQueue.left = rcSFList.left;
	rcQueue.right = rcSFList.right;
	rcQueue.top = rcSFList.bottom + WNDS_BUTTON_HEIGHT;
	rcQueue.bottom = rc.bottom;
	m_ctlQueuelistctrl.MoveWindow(rcQueue);
	// X-Ray :: QueueListPerFile :: End

	Localize();

	GetDlgItem(IDC_CURSESSION_LBL)->SetFont(&theApp.m_fontDefaultBold);
	GetDlgItem(IDC_TOTAL_LBL)->SetFont(&theApp.m_fontDefaultBold);

	return TRUE;
}

void CSharedFilesWnd::DoResize(int iDelta)
{
	CSplitterControl::ChangeWidth(&m_ctlSharedDirTree, iDelta);
	CSplitterControl::ChangeWidth(&m_ctlFilter, iDelta);
	CSplitterControl::ChangePos(GetDlgItem(IDC_CURSESSION_LBL), -iDelta, 0);
	CSplitterControl::ChangePos(GetDlgItem(IDC_FSTATIC4), -iDelta, 0);
	CSplitterControl::ChangePos(GetDlgItem(IDC_SREQUESTED), -iDelta, 0);
	CSplitterControl::ChangePos(GetDlgItem(IDC_FSTATIC5), -iDelta, 0);
	CSplitterControl::ChangePos(GetDlgItem(IDC_SACCEPTED), -iDelta, 0);
	CSplitterControl::ChangePos(GetDlgItem(IDC_FSTATIC6), -iDelta, 0);
	CSplitterControl::ChangePos(GetDlgItem(IDC_STRANSFERRED), -iDelta, 0);
	// X-Ray :: QueueListPerFile :: Start
	/*
	CSplitterControl::ChangePos(&m_ctrlStatisticsFrm, -iDelta, 0);
	*/
	// X-Ray :: QueueListPerFile :: End
	CSplitterControl::ChangePos(&sharedfilesctrl, -iDelta, 0);
	// X-Ray :: QueueListPerFile :: Start
	/*
	CSplitterControl::ChangeWidth(&m_ctrlStatisticsFrm, -iDelta);
	*/
	// X-Ray :: QueueListPerFile :: End
	CSplitterControl::ChangeWidth(&sharedfilesctrl, -iDelta);
	CSplitterControl::ChangePos(&pop_bar, -iDelta, 0);
	CSplitterControl::ChangePos(&pop_baraccept, -iDelta, 0);
	CSplitterControl::ChangePos(&pop_bartrans, -iDelta, 0);
	CSplitterControl::ChangeWidth(&pop_bar, -iDelta);
	CSplitterControl::ChangeWidth(&pop_baraccept, -iDelta);
	CSplitterControl::ChangeWidth(&pop_bartrans, -iDelta);

	// X-Ray :: QueueListPerFile :: Start
	CSplitterControl::ChangePos(GetDlgItem(IDC_SHAREDFILES_DETAIL_TOOLBAR), -iDelta, 0);
	CSplitterControl::ChangePos(&m_ctlQueuelistctrl, -iDelta, 0);
	CSplitterControl::ChangeWidth(&m_ctlQueuelistctrl, -iDelta);
	// X-Ray :: QueueListPerFile :: End

	CRect rcSpl;
	m_wndSplitter.GetWindowRect(rcSpl);
	ScreenToClient(rcSpl);
	thePrefs.SetSplitterbarPositionShared(rcSpl.left);

	RemoveAnchor(m_wndSplitter);
	AddAnchor(m_wndSplitter, TOP_LEFT);
	RemoveAnchor(sharedfilesctrl);
	// X-Ray :: QueueListPerFile :: Start
	/*
	RemoveAnchor(m_ctrlStatisticsFrm);
	*/
	// X-Ray :: QueueListPerFile :: End
	RemoveAnchor(IDC_CURSESSION_LBL);
	RemoveAnchor(IDC_FSTATIC4);
	RemoveAnchor(IDC_SREQUESTED);
	RemoveAnchor(pop_bar);
	RemoveAnchor(IDC_FSTATIC5);
	RemoveAnchor(IDC_SACCEPTED);
	RemoveAnchor(pop_baraccept);
	RemoveAnchor(IDC_FSTATIC6);
	RemoveAnchor(IDC_STRANSFERRED);
	RemoveAnchor(pop_bartrans);
	RemoveAnchor(m_ctlSharedDirTree);
	RemoveAnchor(m_ctlFilter);

	// X-Ray :: QueueListPerFile :: Start
	RemoveAnchor(IDC_SHAREDFILES_DETAIL_TOOLBAR);
	RemoveAnchor(m_ctlQueuelistctrl);
	// X-Ray :: QueueListPerFile :: End


	// X-Ray :: QueueListPerFile :: Start
	/*
	AddAnchor(sharedfilesctrl, TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(m_ctrlStatisticsFrm, BOTTOM_LEFT, BOTTOM_RIGHT);
	*/
	AddAnchor(sharedfilesctrl, TOP_LEFT, CSize(100, thePrefs.GetSplitterbarPositionSharedDetail()));
	AddAnchor(m_ctlQueuelistctrl, CSize(0, thePrefs.GetSplitterbarPositionSharedDetail()), BOTTOM_RIGHT);
	// X-Ray :: QueueListPerFile :: End
	AddAnchor(IDC_CURSESSION_LBL, BOTTOM_LEFT);
	AddAnchor(IDC_FSTATIC4, BOTTOM_LEFT);
	AddAnchor(IDC_SREQUESTED, BOTTOM_LEFT);
	AddAnchor(IDC_FSTATIC5, BOTTOM_LEFT);
	AddAnchor(IDC_SACCEPTED, BOTTOM_LEFT);
	AddAnchor(IDC_FSTATIC6, BOTTOM_LEFT);
	AddAnchor(IDC_STRANSFERRED, BOTTOM_LEFT);
	AddAnchor(m_ctlSharedDirTree, TOP_LEFT, BOTTOM_LEFT);
	AddAnchor(pop_bar, BOTTOM_LEFT, BOTTOM_RIGHT);
	AddAnchor(pop_baraccept, BOTTOM_LEFT, BOTTOM_RIGHT);
	AddAnchor(pop_bartrans, BOTTOM_LEFT, BOTTOM_RIGHT);
	AddAnchor(m_ctlFilter, TOP_LEFT);

	CRect rcWnd;
	GetWindowRect(rcWnd);
	ScreenToClient(rcWnd);
	m_wndSplitter.SetRange(rcWnd.left + SPLITTER_RANGE_MIN, rcWnd.left + SPLITTER_RANGE_MAX);

	// X-Ray :: QueueListPerFile :: Start
	m_ctlQueuelistctrl.Invalidate();
	m_ctlQueuelistctrl.UpdateWindow();
	// X-Ray :: QueueListPerFile :: End

	Invalidate();
	UpdateWindow();
}

// X-Ray :: QueueListPerFile :: Start
void CSharedFilesWnd::DoResizeH(int iDelta)
{
	CSplitterControl::ChangePos(&m_ctlQueuelistctrl, 0, iDelta);
	CSplitterControl::ChangeHeight(&m_ctlQueuelistctrl, -iDelta);
	CSplitterControl::ChangeHeight(&sharedfilesctrl, iDelta);
	CSplitterControl::ChangePos(GetDlgItem(IDC_SHAREDFILES_DETAIL_TOOLBAR), 0, iDelta);

	UpdateHSplitterRange();

	m_ctlQueuelistctrl.Invalidate();
	m_ctlQueuelistctrl.UpdateWindow();

	Invalidate();
	UpdateWindow();
}
// X-Ray :: QueueListPerFile :: End

void CSharedFilesWnd::Reload(bool bForceTreeReload)
{	
	sharedfilesctrl.SetDirectoryFilter(NULL, false);
	m_ctlSharedDirTree.Reload(bForceTreeReload); // force a reload of the tree to update the 'accessible' state of each directory
	sharedfilesctrl.SetDirectoryFilter(m_ctlSharedDirTree.GetSelectedFilter(), false);
	theApp.sharedfiles->Reload();

	ShowSelectedFilesSummary();
}

void CSharedFilesWnd::OnStnDblClickFilesIco()
{
	// X-Ray :: PrefSlider :: Start
	/*
	theApp.emuledlg->ShowPreferences(IDD_PPG_DIRECTORIES);
	*/
	theApp.emuledlg->ShowPreferences(PW_SHAREDFILES);
	// X-Ray :: PrefSlider :: End
}

// X-Ray :: QueueListPerFile :: Start
/*
void CSharedFilesWnd::OnBnClickedReloadSharedFiles()
{
	CWaitCursor curWait;
#ifdef _DEBUG
	if (GetAsyncKeyState(VK_CONTROL) < 0) {
		theApp.sharedfiles->RebuildMetaData();
		sharedfilesctrl.Invalidate();
		sharedfilesctrl.UpdateWindow();
		return;
	}
#endif
	Reload(true);
}
*/
// X-Ray :: QueueListPerFile :: End

void CSharedFilesWnd::OnLvnItemActivateSharedFiles(NMHDR* /*pNMHDR*/, LRESULT* /*pResult*/)
{
	ShowSelectedFilesSummary();
}

void CSharedFilesWnd::ShowSelectedFilesSummary()
{
	const CKnownFile* pTheFile = NULL;
	int iFiles = 0;
	uint64 uTransferred = 0;
	UINT uRequests = 0;
	UINT uAccepted = 0;
	uint64 uAllTimeTransferred = 0;
	UINT uAllTimeRequests = 0;
	UINT uAllTimeAccepted = 0;
	POSITION pos = sharedfilesctrl.GetFirstSelectedItemPosition();
	CList<CKnownFile *, CKnownFile *> filelist; // X-Ray :: QueueListPerFile
	while (pos)
	{
		int iItem = sharedfilesctrl.GetNextSelectedItem(pos);
		// X-Ray :: SharedParts :: Start
		/*
		if (!((CObject*)sharedfilesctrl.GetItemData(iItem))->IsKindOf(RUNTIME_CLASS(CKnownFile)))
			continue;

		const CKnownFile* pFile = (CKnownFile*)sharedfilesctrl.GetItemData(iItem);
		*/
		if (!((CSharedItem*)sharedfilesctrl.GetItemData(iItem))->pFile->IsKindOf(RUNTIME_CLASS(CKnownFile)))
			continue;

		const CKnownFile* pFile = (CKnownFile*)((CSharedItem*)sharedfilesctrl.GetItemData(iItem))->pFile;
		// X-Ray :: SharedParts :: End

		filelist.AddTail((CKnownFile*)pFile); // X-Ray :: QueueListPerFile

		iFiles++;
		if (iFiles == 1)
			pTheFile = pFile;

		uTransferred += pFile->statistic.GetTransferred();
		uRequests += pFile->statistic.GetRequests();
		uAccepted += pFile->statistic.GetAccepts();

		uAllTimeTransferred += pFile->statistic.GetAllTimeTransferred();
		uAllTimeRequests += pFile->statistic.GetAllTimeRequests();
		uAllTimeAccepted += pFile->statistic.GetAllTimeAccepts();
	}

	if (iFiles != 0)
	{
		pop_bartrans.SetRange32(0, (int)(theApp.knownfiles->transferred/1024));
		pop_bartrans.SetPos((int)(uTransferred/1024));
		pop_bartrans.SetShowPercent();
		SetDlgItemText(IDC_STRANSFERRED, CastItoXBytes(uTransferred, false, false));

		pop_bar.SetRange32(0, theApp.knownfiles->requested);
		pop_bar.SetPos(uRequests);
		pop_bar.SetShowPercent();
		SetDlgItemInt(IDC_SREQUESTED, uRequests, FALSE);

		pop_baraccept.SetRange32(0, theApp.knownfiles->accepted);
		pop_baraccept.SetPos(uAccepted);
		pop_baraccept.SetShowPercent();
		SetDlgItemInt(IDC_SACCEPTED, uAccepted, FALSE);

		SetDlgItemText(IDC_STRANSFERRED2, CastItoXBytes(uAllTimeTransferred, false, false));
		SetDlgItemInt(IDC_SREQUESTED2, uAllTimeRequests, FALSE);
		SetDlgItemInt(IDC_SACCEPTED2, uAllTimeAccepted, FALSE);

		CString str(GetResString(IDS_SF_STATISTICS));
		if (iFiles == 1 && pTheFile != NULL)
			str += _T(" (") + MakeStringEscaped(pTheFile->GetFileName()) +_T(")");
		// X-Ray :: QueueListPerFile :: Start
		/*
		m_ctrlStatisticsFrm.SetWindowText(str);
		*/
		m_ctlQueuelistctrl.DeleteAllItems();
		
		for (POSITION posClient = theApp.uploadqueue->waitinglist.GetHeadPosition(); posClient != 0;){
			bool bFileFound = false;
			CUpDownClient* client = theApp.uploadqueue->waitinglist.GetNext(posClient);
			const CKnownFile* reqFile = theApp.sharedfiles->GetFileByID(client->GetUploadFileID());
			for(POSITION posFile = filelist.GetHeadPosition(); posFile != 0;){
				CKnownFile* curFile;
				curFile = filelist.GetNext(posFile);
				
				if(curFile == reqFile){
					bFileFound = true;
					break;
				}
			}
			if(bFileFound)
				m_ctlQueuelistctrl.AddClient(client);
		}
		// X-Ray :: QueueListPerFile :: End
	}
	else
	{
		pop_bartrans.SetRange32(0, 100);
		pop_bartrans.SetPos(0);
		pop_bartrans.SetTextFormat(_T(""));
		SetDlgItemText(IDC_STRANSFERRED, _T("-"));

		pop_bar.SetRange32(0, 100);
		pop_bar.SetPos(0);
		pop_bar.SetTextFormat(_T(""));
		SetDlgItemText(IDC_SREQUESTED, _T("-"));

		pop_baraccept.SetRange32(0, 100);
		pop_baraccept.SetPos(0);
		pop_baraccept.SetTextFormat(_T(""));
		SetDlgItemText(IDC_SACCEPTED, _T("-"));

		SetDlgItemText(IDC_STRANSFERRED2, _T("-"));
		SetDlgItemText(IDC_SREQUESTED2, _T("-"));
		SetDlgItemText(IDC_SACCEPTED2, _T("-"));

		// X-Ray :: QueueListPerFile :: Start
		/*
		m_ctrlStatisticsFrm.SetWindowText(GetResString(IDS_SF_STATISTICS));
		*/
		m_ctlQueuelistctrl.DeleteAllItems();
		// X-Ray :: QueueListPerFile :: End
	}
}

void CSharedFilesWnd::OnNmClickSharedFiles(NMHDR *pNMHDR, LRESULT *pResult)
{
	OnLvnItemActivateSharedFiles(pNMHDR, pResult);
	*pResult = 0;
}

BOOL CSharedFilesWnd::PreTranslateMessage(MSG* pMsg)
{
	if (pMsg->message == WM_KEYDOWN)
	{
		// Don't handle Ctrl+Tab in this window. It will be handled by main window.
		if (pMsg->wParam == VK_TAB && GetAsyncKeyState(VK_CONTROL) < 0)
			return FALSE;
		if (pMsg->wParam == VK_ESCAPE)
			return FALSE;
	}
	else if (pMsg->message == WM_KEYUP)
	{
		if (pMsg->hwnd == sharedfilesctrl.m_hWnd)
			OnLvnItemActivateSharedFiles(0, 0);
	}
	else if (!thePrefs.GetStraightWindowStyles() && pMsg->message == WM_MBUTTONUP)
	{
		POINT point;
		::GetCursorPos(&point);
		CPoint p = point; 
		sharedfilesctrl.ScreenToClient(&p); 
		int it = sharedfilesctrl.HitTest(p); 
		if (it == -1)
			return FALSE;

		sharedfilesctrl.SetItemState(-1, 0, LVIS_SELECTED);
		sharedfilesctrl.SetItemState(it, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
		sharedfilesctrl.SetSelectionMark(it);   // display selection mark correctly!
		// X-Ray :: SharedParts :: Start
		/*
		sharedfilesctrl.ShowComments((CKnownFile*)sharedfilesctrl.GetItemData(it));
		*/
		sharedfilesctrl.ShowComments((CKnownFile*)((CSharedItem*)sharedfilesctrl.GetItemData(it))->pFile);
		// X-Ray :: SharedParts :: End

		return TRUE;
	}

	return CResizableDialog::PreTranslateMessage(pMsg);
}

void CSharedFilesWnd::OnSysColorChange()
{
	pop_bar.SetBkColor(GetSysColor(COLOR_3DFACE));
	pop_baraccept.SetBkColor(GetSysColor(COLOR_3DFACE));
	pop_bartrans.SetBkColor(GetSysColor(COLOR_3DFACE));
	CResizableDialog::OnSysColorChange();
	SetAllIcons();
	m_btnDetail->Invalidate(); // X-Ray :: QueueListPerFile
}

void CSharedFilesWnd::SetAllIcons()
{
	// X-Ray :: QueueListPerFile :: Start
	/*
	m_ctrlStatisticsFrm.SetIcon(_T("StatsDetail"));
	*/
	// X-Ray :: QueueListPerFile :: End

	if (icon_files)
		VERIFY( DestroyIcon(icon_files) );
	icon_files = theApp.LoadIcon(_T("SharedFilesList"), 16, 16);
	((CStatic*)GetDlgItem(IDC_FILES_ICO))->SetIcon(icon_files);

	SetToolbarIcons(); // X-Ray :: QueueListPerFile
}

void CSharedFilesWnd::Localize()
{
	sharedfilesctrl.Localize();
	m_ctlSharedDirTree.Localize();
	m_ctlQueuelistctrl.Localize(); // X-Ray :: QueueListPerFile
	m_ctlFilter.ShowColumnText(true);
	sharedfilesctrl.SetDirectoryFilter(NULL,true);

	GetDlgItem(IDC_TRAFFIC_TEXT)->SetWindowText(GetResString(IDS_SF_FILES));
	GetDlgItem(IDC_RELOADSHAREDFILES)->SetWindowText(GetResString(IDS_SF_RELOAD));
	// X-Ray :: QueueListPerFile :: Start
	/*
	m_ctrlStatisticsFrm.SetWindowText(GetResString(IDS_SF_STATISTICS));
	*/
	// X-Ray :: QueueListPerFile :: End
	GetDlgItem(IDC_CURSESSION_LBL)->SetWindowText(GetResString(IDS_SF_CURRENT));
	GetDlgItem(IDC_TOTAL_LBL)->SetWindowText(GetResString(IDS_SF_TOTAL));
	GetDlgItem(IDC_FSTATIC6)->SetWindowText(GetResString(IDS_SF_TRANS));
	GetDlgItem(IDC_FSTATIC5)->SetWindowText(GetResString(IDS_SF_ACCEPTED));
	GetDlgItem(IDC_FSTATIC4)->SetWindowText(GetResString(IDS_SF_REQUESTS)+_T(":"));
	GetDlgItem(IDC_FSTATIC9)->SetWindowText(GetResString(IDS_SF_TRANS));
	GetDlgItem(IDC_FSTATIC8)->SetWindowText(GetResString(IDS_SF_ACCEPTED));
	GetDlgItem(IDC_FSTATIC7)->SetWindowText(GetResString(IDS_SF_REQUESTS)+_T(":"));
}

void CSharedFilesWnd::OnTvnSelChangedSharedDirsTree(NMHDR* /*pNMHDR*/, LRESULT* pResult)
{
	sharedfilesctrl.SetDirectoryFilter(m_ctlSharedDirTree.GetSelectedFilter(), !m_ctlSharedDirTree.IsCreatingTree());
	*pResult = 0;
}

LRESULT CSharedFilesWnd::DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	switch (message)
	{
		case WM_PAINT:
			if (m_wndSplitter)
			{
				CRect rcWnd;
				GetWindowRect(rcWnd);
				if (rcWnd.Width() > 0)
				{
					CRect rcSpl;
					m_ctlSharedDirTree.GetWindowRect(rcSpl);
					ScreenToClient(rcSpl);
					rcSpl.left = rcSpl.right + SPLITTER_MARGIN;
					rcSpl.right = rcSpl.left + SPLITTER_WIDTH;

					CRect rcFilter;
					m_ctlFilter.GetWindowRect(rcFilter);
					ScreenToClient(rcFilter);
					rcSpl.top = rcFilter.top;
					m_wndSplitter.MoveWindow(rcSpl, TRUE);
				}
			}
			// X-Ray :: QueueListPerFile :: Start
			if(m_wndDetailSplitter){
				CRect rcW;
				GetWindowRect(rcW);
				ScreenToClient(rcW);
				if (rcW.Width() > 0){
					CRect rcSFList;
					GetDlgItem(IDC_SFLIST)->GetWindowRect(rcSFList);
					ScreenToClient(rcSFList);

					CRect rcSpl;
					rcSpl.left = rcSFList.left + DETAIL_TOOLBAR_OFFSET;
					rcSpl.right = rcSFList.right;
					rcSpl.top = rcSFList.bottom;
					rcSpl.bottom = rcSFList.bottom + SPLITTER_WIDTH;
					m_wndDetailSplitter.MoveWindow(rcSpl, TRUE);
					UpdateHSplitterRange();
				}
			}
			// X-Ray :: QueueListPerFile :: End
			break;

		case WM_NOTIFY:
			if (wParam == IDC_SPLITTER_SHAREDFILES)
			{ 
				SPC_NMHDR* pHdr = (SPC_NMHDR*)lParam;
				DoResize(pHdr->delta);
			}
			// X-Ray :: QueueListPerFile :: Start
			else if (wParam == IDC_SHAREDFILES_DETAIL_SPLITTER){
				SPC_NMHDR* pHdr = (SPC_NMHDR*)lParam;
				DoResizeH(pHdr->delta);
			}
			// X-Ray :: QueueListPerFile :: End
			break;

		case WM_SIZE:
			if (m_wndSplitter)
			{
				CRect rcWnd;
				GetWindowRect(rcWnd);
				ScreenToClient(rcWnd);
				m_wndSplitter.SetRange(rcWnd.left + SPLITTER_RANGE_MIN, rcWnd.left + SPLITTER_RANGE_MAX);
			}
			break;
	}
	return CResizableDialog::DefWindowProc(message, wParam, lParam);
}

LRESULT CSharedFilesWnd::OnChangeFilter(WPARAM wParam, LPARAM lParam)
{
	CWaitCursor curWait; // this may take a while

	bool bColumnDiff = (m_nFilterColumn != (uint32)wParam);
	m_nFilterColumn = (uint32)wParam;

	CStringArray astrFilter;
	CString strFullFilterExpr = (LPCTSTR)lParam;
	int iPos = 0;
	CString strFilter(strFullFilterExpr.Tokenize(_T(" "), iPos));
	while (!strFilter.IsEmpty()) {
		if (strFilter != _T("-"))
			astrFilter.Add(strFilter);
		strFilter = strFullFilterExpr.Tokenize(_T(" "), iPos);
	}

	bool bFilterDiff = (astrFilter.GetSize() != m_astrFilter.GetSize());
	if (!bFilterDiff) {
		for (int i = 0; i < astrFilter.GetSize(); i++) {
			if (astrFilter[i] != m_astrFilter[i]) {
				bFilterDiff = true;
				break;
			}
		}
	}

	if (!bColumnDiff && !bFilterDiff)
		return 0;
	m_astrFilter.RemoveAll();
	m_astrFilter.Append(astrFilter);

	sharedfilesctrl.ReloadFileList();
	return 0;
}

BOOL CSharedFilesWnd::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	theApp.ShowHelp(eMule_FAQ_GUI_SharedFiles);
	return TRUE;
}

HBRUSH CSharedFilesWnd::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = theApp.emuledlg->GetCtlColor(pDC, pWnd, nCtlColor);
	if (hbr)
		return hbr;
	return __super::OnCtlColor(pDC, pWnd, nCtlColor);
}

void CSharedFilesWnd::SetToolTipsDelay(DWORD dwDelay)
{
	sharedfilesctrl.SetToolTipsDelay(dwDelay);
}

// X-Ray :: QueueListPerFile :: Start
void CSharedFilesWnd::SwitchTabs(EShareTabs eInput)
{
	switch(eInput) {
		case ST_QUEUE:
		{
			m_stActive = ST_QUEUE;

			// init the queuelist
			CRect rcSFList;
			GetDlgItem(IDC_SFLIST)->GetWindowRect(rcSFList);
			ScreenToClient(rcSFList);
			CRect rc;
			GetDlgItem(IDC_SHAREDDIRSTREE)->GetWindowRect(rc);
			ScreenToClient(rc);
			CRect rcQueue;
			rcQueue.left = rcSFList.left;
			rcQueue.right = rcSFList.right;
			rcQueue.top = rcSFList.bottom + WNDS_BUTTON_HEIGHT;
			rcQueue.bottom = rc.bottom;
			m_ctlQueuelistctrl.MoveWindow(rcQueue);

			GetDlgItem(IDC_CURSESSION_LBL)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_FSTATIC4)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_FSTATIC5)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_FSTATIC6)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_SREQUESTED)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_SACCEPTED)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_STRANSFERRED)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_POPBAR)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_POPBAR2)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_POPBAR3)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_FSTATIC7)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_FSTATIC8)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_FSTATIC9)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_SREQUESTED2)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_SACCEPTED2)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_STRANSFERRED2)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_TOTAL_LBL)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_SHAREDFILES_DETAIL_SPLITTER)->ShowWindow(SW_SHOW);
			m_ctlQueuelistctrl.Show();
			break;
		}
		case ST_STATISTICS:
		{
			m_stActive = ST_STATISTICS;

			CRect rcW, rcSpl;
			GetWindowRect(rcW);
			ScreenToClient(rcW);
			GetDlgItem(IDC_SHAREDFILES_DETAIL_SPLITTER)->GetWindowRect(rcSpl);
			ScreenToClient(rcSpl);

			const uint32 uOldRect = rcSpl.top;
			rcSpl.top = rcW.bottom - DETAIL_SPLITTER_BOTTOM;
			rcSpl.bottom = rcW.bottom - DETAIL_SPLITTER_BOTTOM + SPLITTER_WIDTH;
			m_wndDetailSplitter.MoveWindow(rcSpl);
			DoResizeH(rcSpl.top - uOldRect);

			GetDlgItem(IDC_CURSESSION_LBL)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_FSTATIC4)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_FSTATIC5)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_FSTATIC6)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_SREQUESTED)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_SACCEPTED)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_STRANSFERRED)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_POPBAR)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_POPBAR2)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_POPBAR3)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_FSTATIC7)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_FSTATIC8)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_FSTATIC9)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_SREQUESTED2)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_SACCEPTED2)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_STRANSFERRED2)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_TOTAL_LBL)->ShowWindow(SW_SHOW);
			GetDlgItem(IDC_SHAREDFILES_DETAIL_SPLITTER)->ShowWindow(SW_HIDE);
			m_ctlQueuelistctrl.Hide();
			break;
		}
		default:
			ASSERT(0);
			break;
	}
}

void CSharedFilesWnd::UpdateHSplitterRange()
{
	CRect rcW;
	GetWindowRect(rcW);
	ScreenToClient(rcW);

	CRect rcSpl;
	GetDlgItem(IDC_SHAREDFILES_DETAIL_SPLITTER)->GetWindowRect(rcSpl);

	ScreenToClient(rcSpl);
	if(m_stActive == ST_QUEUE){
		CRect rcSFList;
		GetDlgItem(IDC_SFLIST)->GetClientRect(rcSFList);
		ScreenToClient(rcSFList);

		if((rcW.bottom - rcSpl.top) < DETAIL_SPLITTER_BOTTOM){
			const uint32 uOldRect = rcSpl.top;
			rcSpl.top = rcW.bottom - DETAIL_SPLITTER_BOTTOM;
			rcSpl.bottom = rcW.bottom - DETAIL_SPLITTER_BOTTOM + SPLITTER_WIDTH;
			m_wndDetailSplitter.MoveWindow(rcSpl);
			DoResizeH(rcSpl.top - uOldRect);
		} else if(rcSpl.top < DETAIL_SPLITTER_TOP){
			const uint32 uOldRect = rcSpl.top;
			rcSpl.top = DETAIL_SPLITTER_TOP;
			rcSpl.bottom = DETAIL_SPLITTER_TOP + SPLITTER_WIDTH;
			m_wndDetailSplitter.MoveWindow(rcSpl);
			DoResizeH(rcSpl.top - uOldRect);
		} else if(rcSpl.top != DETAIL_SPLITTER_TOP && (rcW.bottom - rcSpl.top) != DETAIL_SPLITTER_BOTTOM)
			thePrefs.SetSplitterbarPositionSharedDetail((rcSFList.bottom * 100) / rcW.Height());

		RemoveAnchor(IDC_SFLIST);
		RemoveAnchor(*m_btnDetail);
		RemoveAnchor(m_ctlQueuelistctrl);
		AddAnchor(IDC_SFLIST, TOP_LEFT, CSize(100, thePrefs.GetSplitterbarPositionSharedDetail()));
		AddAnchor(*m_btnDetail, CSize(0, thePrefs.GetSplitterbarPositionSharedDetail()));
		AddAnchor(m_ctlQueuelistctrl, CSize(0, thePrefs.GetSplitterbarPositionSharedDetail()), BOTTOM_RIGHT);

		m_wndDetailSplitter.SetRange(rcW.top + DETAIL_SPLITTER_TOP, rcW.bottom - DETAIL_SPLITTER_BOTTOM + SPLITTER_WIDTH);
	} else {
		if((rcW.bottom - rcSpl.top) > DETAIL_SPLITTER_BOTTOM){
			const uint32 uOldRect = rcSpl.top;
			rcSpl.top = rcW.bottom - DETAIL_SPLITTER_BOTTOM;
			rcSpl.bottom = rcW.bottom - DETAIL_SPLITTER_BOTTOM + SPLITTER_WIDTH;
			m_wndDetailSplitter.MoveWindow(rcSpl);
			DoResizeH(rcSpl.top - uOldRect);
		}

		RemoveAnchor(IDC_SFLIST);
		RemoveAnchor(*m_btnDetail);
		AddAnchor(IDC_SFLIST, TOP_LEFT, BOTTOM_RIGHT);
		AddAnchor(*m_btnDetail, BOTTOM_LEFT);
	}
}

void CSharedFilesWnd::SetToolbarIcons()
{
	CImageList iml;
	iml.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 1, 1);
	iml.Add(CTempIconLoader(_T("StatsDetail")));
	iml.Add(CTempIconLoader(_T("ClientsOnQueue")));
	CImageList* pImlOld = m_btnDetail->SetImageList(&iml);
	iml.Detach();
	if (pImlOld)
		pImlOld->DeleteImageList();
}

BOOL CSharedFilesWnd::OnCommand(WPARAM wParam, LPARAM /*lParam*/)
{
	switch (wParam)
	{ 
		case IDC_RELOADSHAREDFILES:
		{
			CWaitCursor curWait;
#ifdef _DEBUG
			if (GetAsyncKeyState(VK_CONTROL) < 0) {
				theApp.sharedfiles->RebuildMetaData();
				sharedfilesctrl.Invalidate();
				sharedfilesctrl.UpdateWindow();
				break;
			}
#endif
			Reload(true);
			break;
		}

		case IDC_SHAREDFILES_DETAIL_TOOLBAR:
			if(m_stActive == ST_STATISTICS){
				SwitchTabs(ST_QUEUE);
				ChangeIcon(ST_QUEUE);
				m_btnDetail->CheckButton(MP_VIEW_QUEUE);
				m_btnDetail->SetWindowText(GetResString(IDS_ONQUEUE));
			} else if(m_stActive == ST_QUEUE){
				SwitchTabs(ST_STATISTICS);
				ChangeIcon(ST_STATISTICS);
				m_btnDetail->CheckButton(MP_VIEW_STATISTICS);
				m_btnDetail->SetWindowText(GetResString(IDS_SF_STATISTICS));
			}
			break;

		case MP_VIEW_STATISTICS:
			SwitchTabs(ST_STATISTICS);
			ChangeIcon(ST_STATISTICS);
			m_btnDetail->SetWindowText(GetResString(IDS_SF_STATISTICS));
			break;

		case MP_VIEW_QUEUE:
			SwitchTabs(ST_QUEUE);
			ChangeIcon(ST_QUEUE);
			m_btnDetail->SetWindowText(GetResString(IDS_ONQUEUE));
			break;
	}

	return TRUE;
}

void CSharedFilesWnd::ResetShareDetailToolbar()
{
	if(m_btnDetail->m_hWnd)
		RemoveAnchor(*m_btnDetail);

	CRect rcSTree;
	GetDlgItem(IDC_SHAREDDIRSTREE)->GetWindowRect(rcSTree);
	ScreenToClient(rcSTree);

	CRect rcSFList;
	GetDlgItem(IDC_SFLIST)->GetWindowRect(rcSFList);
	ScreenToClient(rcSFList);

	CRect rc;
	rc.top = rcSFList.bottom;
	rc.left = rcSTree.right + SPLITTER_WIDTH;
	rc.right = rc.left + WNDS_BUTTON_WIDTH + NUMS_WINA_BUTTONS*DFLT_TOOLBAR_BTN_WIDTH;
	rc.bottom = rc.top + WNDS_BUTTON_HEIGHT;
	m_btnDetail->Init(false);
	m_btnDetail->MoveWindow(&rc);
	SetToolbarIcons();

	m_btnDetail->ModifyStyle(0, TBSTYLE_TOOLTIPS);
	m_btnDetail->SetExtendedStyle(m_btnDetail->GetExtendedStyle() | TBSTYLE_EX_MIXEDBUTTONS);

	TBBUTTON btnDetail[1+NUMS_WINA_BUTTONS] = {0};
	btnDetail[0].iBitmap = ST_STATISTICS;
	btnDetail[0].idCommand = IDC_SHAREDFILES_DETAIL_TOOLBAR;
	btnDetail[0].fsState = TBSTATE_ENABLED;
	btnDetail[0].fsStyle = BTNS_BUTTON | BTNS_SHOWTEXT;
	btnDetail[0].iString = -1;

	btnDetail[1].iBitmap = ST_STATISTICS;
	btnDetail[1].idCommand = MP_VIEW_STATISTICS;
	btnDetail[1].fsState = TBSTATE_ENABLED;
	btnDetail[1].fsStyle = BTNS_BUTTON | BTNS_CHECKGROUP | BTNS_AUTOSIZE;
	btnDetail[1].iString = -1;

	btnDetail[2].iBitmap = ST_QUEUE;
	btnDetail[2].idCommand = MP_VIEW_QUEUE;
	btnDetail[2].fsState = TBSTATE_ENABLED;
	btnDetail[2].fsStyle = BTNS_BUTTON | BTNS_CHECKGROUP | BTNS_AUTOSIZE;
	btnDetail[2].iString = -1;
	m_btnDetail->AddButtons(ARRSIZE(btnDetail), btnDetail);

	TBBUTTONINFO tbbi = {0};
	tbbi.cbSize = sizeof tbbi;
	tbbi.dwMask = TBIF_SIZE | TBIF_BYINDEX;
	tbbi.cx = WNDS_BUTTON_WIDTH;
	m_btnDetail->SetButtonInfo(0, &tbbi);

	if(m_stActive == ST_STATISTICS)
		AddAnchor(*m_btnDetail, BOTTOM_LEFT);
	else if(m_stActive == ST_QUEUE)
		AddAnchor(*m_btnDetail, CSize(0, thePrefs.GetSplitterbarPositionSharedDetail()));
}

void CSharedFilesWnd::OnDetailBtnClick(NMHDR* /*pNMHDR*/, LRESULT* /*pResult*/)
{
	CTitleMenu menu;
	menu.CreatePopupMenu();
	menu.AddMenuTitle(NULL); // X-Ray :: XPMenus
	menu.EnableIcons();

	menu.AppendMenu(MF_STRING | (m_stActive == ST_STATISTICS ? MF_GRAYED : 0), MP_VIEW_STATISTICS, GetResString(IDS_SF_STATISTICS), _T("StatsDetail"));
	menu.AppendMenu(MF_STRING | (m_stActive == ST_QUEUE ? MF_GRAYED : 0), MP_VIEW_QUEUE, GetResString(IDS_ONQUEUE), _T("ClientsOnQueue"));

	CRect rc;
	m_btnDetail->GetWindowRect(&rc);
	menu.TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, rc.left, rc.bottom, this);
	VERIFY( menu.DestroyMenu() );
}

void CSharedFilesWnd::ChangeIcon(uint8 iIcon)
{
	TBBUTTONINFO tbbi = {0};
	tbbi.cbSize = sizeof tbbi;
	tbbi.dwMask = TBIF_IMAGE;
	tbbi.iImage = iIcon;
	m_btnDetail->SetButtonInfo(GetWindowLong(*m_btnDetail, GWL_ID), &tbbi);
}
// X-Ray :: QueueListPerFile :: End