//this file is part of eMule
//Copyright (C)2002-2008 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "emuledlg.h"
#include "DownloadClientsCtrl.h"
#include "ClientDetailDialog.h"
#include "MemDC.h"
#include "MenuCmds.h"
#include "FriendList.h"
#include "TransferWnd.h"
#include "ChatWnd.h"
#include "UpDownClient.h"
#include "UploadQueue.h"
#include "ClientCredits.h"
#include "PartFile.h"
#include "Kademlia/Kademlia/Kademlia.h"
#include "SharedFileList.h"
#include "Addons/Argos/Argos.h" // X-Ray :: Argos

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CDownloadClientsCtrl, CMuleListCtrl)

BEGIN_MESSAGE_MAP(CDownloadClientsCtrl, CMuleListCtrl)
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnLvnColumnClick)
	ON_NOTIFY_REFLECT(LVN_GETDISPINFO, OnLvnGetDispInfo)
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnNmDblClk)
	ON_WM_CONTEXTMENU()
	ON_WM_SYSCOLORCHANGE()
END_MESSAGE_MAP()

CDownloadClientsCtrl::CDownloadClientsCtrl()
	: CListCtrlItemWalk(this)
{
	SetGeneralPurposeFind(true);
	SetSkinKey(L"DownloadingLv");
}

void CDownloadClientsCtrl::Init()
{
	SetPrefsKey(_T("DownloadClientsCtrl"));
	SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_INFOTIP);

	InsertColumn(0,	GetResString(IDS_QL_USERNAME),		LVCFMT_LEFT,  DFLT_CLIENTNAME_COL_WIDTH);
	InsertColumn(1,	GetResString(IDS_CD_CSOFT),			LVCFMT_LEFT,  DFLT_CLIENTSOFT_COL_WIDTH);
	InsertColumn(2,	GetResString(IDS_FILE),				LVCFMT_LEFT,  DFLT_FILENAME_COL_WIDTH);
	InsertColumn(3,	GetResString(IDS_DL_SPEED),			LVCFMT_RIGHT, DFLT_DATARATE_COL_WIDTH);
	InsertColumn(4, GetResString(IDS_AVAILABLEPARTS),	LVCFMT_LEFT,  DFLT_PARTSTATUS_COL_WIDTH);
	InsertColumn(5,	GetResString(IDS_CL_TRANSFDOWN),	LVCFMT_RIGHT, DFLT_SIZE_COL_WIDTH);
	InsertColumn(6,	GetResString(IDS_CL_TRANSFUP),		LVCFMT_RIGHT, DFLT_SIZE_COL_WIDTH);
	InsertColumn(7,	GetResString(IDS_META_SRCTYPE),		LVCFMT_LEFT,  100);
	InsertColumn(8,	GetResString(IDS_COUNTRY),			LVCFMT_LEFT,  100); // X-Ray :: IP2Country
	InsertColumn(9, GetResString(IDS_ARGOS),			LVCFMT_LEFT,  100); // X-Ray :: Argos
	InsertColumn(10,GetResString(IDS_CHUNK),			LVCFMT_LEFT,  220); // X-Ray :: DownloadChunkDisplay

	SetAllIcons();
	Localize();
	LoadSettings();
	SetSortArrow();
	SortItems(SortProc, GetSortItem() + (GetSortAscending() ? 0 : 100));

	// X-Ray :: Argos :: Start
	if (!thePrefs.UseArgosSystem())
		HideColumn(9);
	// X-Ray :: Argos :: End
}

void CDownloadClientsCtrl::Localize()
{
	CHeaderCtrl *pHeaderCtrl = GetHeaderCtrl();
	HDITEM hdi;
	hdi.mask = HDI_TEXT;

	CString strRes;
	strRes = GetResString(IDS_QL_USERNAME);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(0, &hdi);

	strRes = GetResString(IDS_CD_CSOFT);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(1, &hdi);

	strRes = GetResString(IDS_FILE);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(2, &hdi);

	strRes = GetResString(IDS_DL_SPEED);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(3, &hdi);
	
	strRes = GetResString(IDS_AVAILABLEPARTS);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(4, &hdi);

	strRes = GetResString(IDS_CL_TRANSFDOWN);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(5, &hdi);

	strRes = GetResString(IDS_CL_TRANSFUP);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(6, &hdi);

	strRes = GetResString(IDS_META_SRCTYPE);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(7, &hdi);

	// X-Ray :: IP2Country :: Start
	strRes = GetResString(IDS_COUNTRY);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(8, &hdi);
	// X-Ray :: IP2Country :: End

	// X-Ray :: Argos :: Start
	strRes = GetResString(IDS_ARGOS);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(9, &hdi);
	// X-Ray :: Argos :: End

	// X-Ray :: DownloadChunkDisplay :: Start
	strRes = GetResString(IDS_CHUNK);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(10, &hdi);
	// X-Ray :: DownloadChunkDisplay :: End
}

void CDownloadClientsCtrl::OnSysColorChange()
{
	CMuleListCtrl::OnSysColorChange();
	SetAllIcons();
}

void CDownloadClientsCtrl::SetAllIcons()
{
	ApplyImageList(NULL);
	m_ImageList.DeleteImageList();
	m_ImageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 0, 1);
	m_ImageList.Add(CTempIconLoader(_T("ClientEDonkey")));
	m_ImageList.Add(CTempIconLoader(_T("ClientCompatible")));
	m_ImageList.Add(CTempIconLoader(_T("ClientEDonkeyPlus")));
	m_ImageList.Add(CTempIconLoader(_T("ClientCompatiblePlus")));
	m_ImageList.Add(CTempIconLoader(_T("Friend")));
	m_ImageList.Add(CTempIconLoader(_T("ClientMLDonkey")));
	m_ImageList.Add(CTempIconLoader(_T("ClientMLDonkeyPlus")));
	m_ImageList.Add(CTempIconLoader(_T("ClientEDonkeyHybrid")));
	m_ImageList.Add(CTempIconLoader(_T("ClientEDonkeyHybridPlus")));
	m_ImageList.Add(CTempIconLoader(_T("ClientShareaza")));
	m_ImageList.Add(CTempIconLoader(_T("ClientShareazaPlus")));
	m_ImageList.Add(CTempIconLoader(_T("ClientAMule")));
	m_ImageList.Add(CTempIconLoader(_T("ClientAMulePlus")));
	m_ImageList.Add(CTempIconLoader(_T("ClientLPhant")));
	m_ImageList.Add(CTempIconLoader(_T("ClientLPhantPlus")));
	m_ImageList.Add(CTempIconLoader(_T("ExtendedProtocolOvl"))); // X-Ray :: CorrectAppIcons
	// X-Ray :: EnhancedClientRecognization :: Start
	m_ImageList.Add(CTempIconLoader(_T("CLIENTHYRANODE")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENTHYRANODEPLUS")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENTPLUS")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENTPLUSPLUS")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENTTRUSTYFILES")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENTTRUSTYFILESPLUS")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENTXMULE")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENTXMULEPLUS")));
	// X-Ray :: EnhancedClientRecognization :: End
	// X-Ray :: Argos :: Start
	m_ImageList.Add(CTempIconLoader(_T("ARGOS_BANNED_SOFT")));
	m_ImageList.Add(CTempIconLoader(_T("ARGOS_BANNED_SOFT2")));
	m_ImageList.Add(CTempIconLoader(_T("ARGOS_LEECHER")));
	m_ImageList.Add(CTempIconLoader(_T("ARGOS_BANNED")));
	// X-Ray :: Argos :: End
	m_ImageList.SetOverlayImage(m_ImageList.Add(CTempIconLoader(_T("ClientSecureOvl"))), 1);
	m_ImageList.SetOverlayImage(m_ImageList.Add(CTempIconLoader(_T("OverlayObfu"))), 2);
	m_ImageList.SetOverlayImage(m_ImageList.Add(CTempIconLoader(_T("OverlaySecureObfu"))), 3);
	// Apply the image list also to the listview control, even if we use our own 'DrawItem'.
	// This is needed to give the listview control a chance to initialize the row height.
	ASSERT( (GetStyle() & LVS_SHAREIMAGELISTS) != 0 );
	VERIFY( ApplyImageList(m_ImageList) == NULL );
}

void CDownloadClientsCtrl::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	if (!theApp.emuledlg->IsRunning())
		return;
	if (!lpDrawItemStruct->itemData)
		return;

	CMemDC dc(CDC::FromHandle(lpDrawItemStruct->hDC), &lpDrawItemStruct->rcItem);
	BOOL bCtrlFocused;
	InitItemMemDC(dc, lpDrawItemStruct, bCtrlFocused);
	CRect cur_rec(lpDrawItemStruct->rcItem);
	CRect rcClient;
	GetClientRect(&rcClient);
	const CUpDownClient *client = (CUpDownClient *)lpDrawItemStruct->itemData;
	COLORREF crOldBackColor = dc->GetBkColor(); // X-Ray :: Optimizations - FillSolidRect

	CHeaderCtrl *pHeaderCtrl = GetHeaderCtrl();
	int iCount = pHeaderCtrl->GetItemCount();
	cur_rec.right = cur_rec.left - sm_iLabelOffset;
	cur_rec.left += sm_iIconOffset;
	for (int iCurrent = 0; iCurrent < iCount; iCurrent++)
	{
		int iColumn = pHeaderCtrl->OrderToIndex(iCurrent);
		if (!IsColumnHidden(iColumn))
		{
			UINT uDrawTextAlignment;
			int iColumnWidth = GetColumnWidth(iColumn, uDrawTextAlignment);
			cur_rec.right += iColumnWidth;
			if (cur_rec.left < cur_rec.right && HaveIntersection(rcClient, cur_rec))
			{
				TCHAR szItem[1024];
				GetItemDisplayText(client, iColumn, szItem, _countof(szItem));
				switch (iColumn)
				{
					case 0:{
						int iImage;
						if (client->credits != NULL)
						{
							// X-Ray :: Argos :: Start
							/*
							if (client->IsFriend())
							*/
							if (client->IsBanned()) 
								iImage = 27;
							else if(theApp.argos->IsArgos(client->GetConnectIP())){
								if (theApp.argos->GetPunishment(client) == 0) 
									iImage = 24;
								else if (theApp.argos->GetPunishment(client) == 1) 
									iImage = 26;
								else
									iImage = 25;
							}
							else if (client->IsFriend())
							// X-Ray :: Argos :: End
								iImage = 4;
							// X-Ray :: CorrectAppIcons :: Start
							else if (client->GetClientSoft() == SO_EMULE){
								if (client->credits->GetScoreRatio(client->GetIP()) > 1)
									iImage = 2;
								else
									iImage = 0;
							}
							// X-Ray :: CorrectAppIcons :: End
							else if (client->GetClientSoft() == SO_EDONKEYHYBRID) {
								if (client->credits->GetScoreRatio(client->GetIP()) > 1)
									iImage = 8;
								else
									iImage = 7;
							}
							// X-Ray :: EnhancedClientRecognization :: Start
							/*
							else if (client->GetClientSoft() == SO_MLDONKEY) {
							*/
							else if (client->GetClientSoft() == SO_MLDONKEY || client->GetClientSoft() == SO_MLDONKEY2 || client->GetClientSoft() == SO_MLDONKEY3) {
							// X-Ray :: EnhancedClientRecognization :: End
								if (client->credits->GetScoreRatio(client->GetIP()) > 1)
									iImage = 6;
								else
									iImage = 5;
							}
							// X-Ray :: EnhancedClientRecognization :: Start
							/*
							else if (client->GetClientSoft() == SO_SHAREAZA) {
							*/
							else if (client->GetClientSoft() == SO_SHAREAZA || client->GetClientSoft() == SO_SHAREAZA2 || client->GetClientSoft() == SO_SHAREAZA3 || client->GetClientSoft() == SO_SHAREAZA4) {
							// X-Ray :: EnhancedClientRecognization :: End
								if (client->credits->GetScoreRatio(client->GetIP()) > 1)
									iImage = 10;
								else
									iImage = 9;
							}
							else if (client->GetClientSoft() == SO_AMULE) {
								if (client->credits->GetScoreRatio(client->GetIP()) > 1)
									iImage = 12;
								else
									iImage = 11;
							}
							else if (client->GetClientSoft() == SO_LPHANT) {
								if (client->credits->GetScoreRatio(client->GetIP()) > 1)
									iImage = 14;
								else
									iImage = 13;
							}
							// X-Ray :: EnhancedClientRecognization :: Start
							else if (client->GetClientSoft() == SO_EMULEPLUS) {
								if (client->credits->GetScoreRatio(client->GetIP()) > 1)
									iImage = 19;
								else
									iImage = 18;
							}
							else if (client->GetClientSoft() == SO_HYDRANODE) {
								if (client->credits->GetScoreRatio(client->GetIP()) > 1)
									iImage = 17;
								else
									iImage = 16;
							}
							else if (client->GetClientSoft() == SO_TRUSTYFILES) {
								if (client->credits->GetScoreRatio(client->GetIP()) > 1)
									iImage = 21;
								else
									iImage = 20;
							}
							else if (client->GetClientSoft() == SO_XMULE) {
								if (client->credits->GetScoreRatio(client->GetIP()) > 1)
									iImage = 23;
								else
									iImage = 22;
							}
							// X-Ray :: EnhancedClientRecognization :: End

							// X-Ray :: CorrectAppIcons :: Start
							/*
							else if (client->ExtProtocolAvailable()) {
								if (client->credits->GetScoreRatio(client->GetIP()) > 1)
									iImage = 3;
								else
									iImage = 1;
							}
							else {
								if (client->credits->GetScoreRatio(client->GetIP()) > 1)
									iImage = 2;
								else
									iImage = 0;
							}
							*/
							// changed to Compatible Icons because if it's none of the App's above we don't have icons for it
							else {
								if (client->credits->GetScoreRatio(client->GetIP()) > 1)
									iImage = 3; 
								else
									iImage = 1;
							}
							// X-Ray :: CorrectAppIcons :: End
						}
						else
							iImage = 0;

						UINT nOverlayImage = 0;
						if ((client->Credits() && client->Credits()->GetCurrentIdentState(client->GetIP()) == IS_IDENTIFIED))
							nOverlayImage |= 1;
						if (client->IsObfuscatedConnectionEstablished())
							nOverlayImage |= 2;
						int iIconPosY = (cur_rec.Height() > 16) ? ((cur_rec.Height() - 16) / 2) : 1;
						POINT point = { cur_rec.left, cur_rec.top + iIconPosY };
						m_ImageList.Draw(dc, iImage, point, ILD_NORMAL | INDEXTOOVERLAYMASK(nOverlayImage));

						// X-Ray :: CorrectAppIcons :: Start
						if(client->ExtProtocolAvailable())
							m_ImageList.Draw(dc, 15, point, ILD_TRANSPARENT);
						// X-Ray :: CorrectAppIcons :: End

						// X-Ray :: IP2Country :: Start
						if(theApp.ip2country->ShowCountryFlag()){
							cur_rec.left += 20;
							POINT point2 = { cur_rec.left, cur_rec.top + 3 };
							theApp.ip2country->GetFlagImageList()->Draw(dc, client->GetCountryFlagIndex(), point2, ILD_NORMAL);
							cur_rec.left += sm_iLabelOffset;
						}
						// X-Ray :: IP2Country :: End

						cur_rec.left += 16 + sm_iLabelOffset;
						dc.DrawText(szItem, -1, &cur_rec, MLC_DT_TEXT | uDrawTextAlignment);
						cur_rec.left -= 16;
						cur_rec.right -= sm_iSubItemInset;

						// X-Ray :: IP2Country :: Start
						if(theApp.ip2country->ShowCountryFlag())
							cur_rec.left -= 20 + sm_iLabelOffset;
						// X-Ray :: IP2Country :: End
						break;
					}

					case 4:
						cur_rec.bottom--;
						cur_rec.top++;
						// X-Ray :: MultiFileStatusbars :: Start
						/*
						client->DrawStatusBar(dc, &cur_rec, false, thePrefs.UseFlatBar());
						*/
						client->DrawStatusBar(dc, cur_rec, client->GetRequestFile(), thePrefs.UseFlatBar());
						// X-Ray :: MultiFileStatusbars
						dc.SetBkColor(crOldBackColor); // X-Ray :: Optimizations - FillSolidRect
						cur_rec.bottom++;
						cur_rec.top--;
						break;

					// X-Ray :: DownloadChunkDisplay :: Start
					case 10:
						cur_rec.bottom--;
						cur_rec.top++;
						client->DrawStatusBarChunk(dc, &cur_rec, client->GetRequestFile(),thePrefs.UseFlatBar());
						dc.SetBkColor(crOldBackColor); // X-Ray :: Optimizations - FillSolidRect
						cur_rec.bottom++;
						cur_rec.top--;
						break;
					// X-Ray :: DownloadChunkDisplay :: End

					default:
						dc.DrawText(szItem, -1, &cur_rec, MLC_DT_TEXT | uDrawTextAlignment);
						dc.SetBkColor(crOldBackColor); // X-Ray :: Optimizations - FillSolidRect
						break;
				}
			}
			cur_rec.left += iColumnWidth;
		}
	}

	DrawFocusRect(dc, lpDrawItemStruct->rcItem, lpDrawItemStruct->itemState & ODS_FOCUS, bCtrlFocused, lpDrawItemStruct->itemState & ODS_SELECTED);
}

void CDownloadClientsCtrl::GetItemDisplayText(const CUpDownClient *client, int iSubItem, LPTSTR pszText, int cchTextMax)
{
	if (pszText == NULL || cchTextMax <= 0) {
		ASSERT(0);
		return;
	}
	pszText[0] = _T('\0');
	switch (iSubItem)
	{
		case 0:
			if (client->GetUserName() == NULL)
				_sntprintf(pszText, cchTextMax, _T("(%s)"), GetResString(IDS_UNKNOWN));
			else
				_tcsncpy(pszText, client->GetUserName(), cchTextMax);
			break;

		case 1:
			_tcsncpy(pszText, client->GetClientSoftVer(), cchTextMax);

			// X-Ray :: ModID :: Start
			if (pszText[0] == _T('\0'))
				_tcsncpy(pszText, GetResString(IDS_UNKNOWN), cchTextMax);
			else if (!client->GetClientModVer().IsEmpty())
				_sntprintf(pszText, cchTextMax, L"%s [%s]", client->GetClientSoftVer(), client->GetClientModVer());
			// X-Ray :: ModID :: End
			break;

		case 2:
			_tcsncpy(pszText, client->GetRequestFile()->GetFileName(), cchTextMax);
			break;
		
		case 3:
			_tcsncpy(pszText, CastItoXBytes((float)client->GetDownloadDatarate(), false, true), cchTextMax);
			break;
		
		case 4:
			_tcsncpy(pszText, GetResString(IDS_AVAILABLEPARTS), cchTextMax);
			break;

		case 5:
			if (client->credits && client->GetSessionDown() < client->credits->GetDownloadedTotal())
				_sntprintf(pszText, cchTextMax, _T("%s (%s)"), CastItoXBytes(client->GetSessionDown()), CastItoXBytes(client->credits->GetDownloadedTotal()));
			else
				_tcsncpy(pszText, CastItoXBytes(client->GetSessionDown()), cchTextMax);
			break;
		
		case 6:
			if (client->credits && client->GetSessionUp() < client->credits->GetUploadedTotal())
				_sntprintf(pszText, cchTextMax, _T("%s (%s)"), CastItoXBytes(client->GetSessionUp()), CastItoXBytes(client->credits->GetUploadedTotal()));
			else
				_tcsncpy(pszText, CastItoXBytes(client->GetSessionUp()), cchTextMax);
			break;
		
		case 7:
			switch (client->GetSourceFrom())
			{
				case SF_SERVER:
					_tcsncpy(pszText, _T("eD2K Server"), cchTextMax);
					break;
				case SF_KADEMLIA:
					_tcsncpy(pszText, GetResString(IDS_KADEMLIA), cchTextMax);
					break;
				case SF_SOURCE_EXCHANGE:
					_tcsncpy(pszText, GetResString(IDS_SE), cchTextMax);
					break;
				case SF_PASSIVE:
					_tcsncpy(pszText, GetResString(IDS_PASSIVE), cchTextMax);
					break;
				case SF_LINK:
					_tcsncpy(pszText, GetResString(IDS_SW_LINK), cchTextMax);
					break;
				// X-Ray :: SearchCatch :: Start
				case SF_SEARCH:
					_tcsncpy(pszText, GetResString(IDS_SW_SEARCHBOX), cchTextMax);
					break;
				// X-Ray :: SearchCatch :: End
				// X-Ray :: Sourcecache :: Start
				case SF_CACHE:
					_tcsncpy(pszText, GetResString(IDS_SOURCECACHE), cchTextMax);
					break;
				// X-Ray :: Sourcecache :: End
				// X-Ray :: SLS :: Start
				case SF_SLS:
					_tcsncpy(pszText, GetResString(IDS_SLS), cchTextMax);
					break;
				// X-Ray :: SLS :: End
				default:
					_tcsncpy(pszText, GetResString(IDS_UNKNOWN), cchTextMax);
					break;
			}
			break;

		// X-Ray :: IP2Country :: Start
		case 8:
			_tcsncpy(pszText, client->GetCountryName(), cchTextMax);
			break;
		// X-Ray :: IP2Country :: End

		// X-Ray :: Argos :: Start
		case 9:
			if(thePrefs.UseArgosSystem())
				_tcsncpy(pszText, theApp.argos->GetArgosString(client), cchTextMax);
			break;
		// X-Ray :: Argos :: End
	}
	pszText[cchTextMax - 1] = _T('\0');
}

void CDownloadClientsCtrl::OnLvnGetDispInfo(NMHDR *pNMHDR, LRESULT *pResult)
{
	if (theApp.emuledlg->IsRunning()) {
		// Although we have an owner drawn listview control we store the text for the primary item in the listview, to be
		// capable of quick searching those items via the keyboard. Because our listview items may change their contents,
		// we do this via a text callback function. The listview control will send us the LVN_DISPINFO notification if
		// it needs to know the contents of the primary item.
		//
		// But, the listview control sends this notification all the time, even if we do not search for an item. At least
		// this notification is only sent for the visible items and not for all items in the list. Though, because this
		// function is invoked *very* often, do *NOT* put any time consuming code in here.
		//
		// Vista: That callback is used to get the strings for the label tips for the sub(!) items.
		//
		NMLVDISPINFO *pDispInfo = reinterpret_cast<NMLVDISPINFO*>(pNMHDR);
		if (pDispInfo->item.mask & LVIF_TEXT) {
			const CUpDownClient* pClient = reinterpret_cast<CUpDownClient*>(pDispInfo->item.lParam);
			if (pClient != NULL)
				GetItemDisplayText(pClient, pDispInfo->item.iSubItem, pDispInfo->item.pszText, pDispInfo->item.cchTextMax);
		}
	}
	*pResult = 0;
}

void CDownloadClientsCtrl::OnLvnColumnClick(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLISTVIEW *pNMListView = (NMLISTVIEW *)pNMHDR;
	bool sortAscending;
	if (GetSortItem() != pNMListView->iSubItem)
	{
		switch (pNMListView->iSubItem)
		{
			case 1: // Client Software
			case 3: // Download Rate
			case 4: // Part Count
			case 5: // Session Down
			case 6: // Session Up
				sortAscending = false;
				break;
			default:
				sortAscending = true;
				break;
		}
	}
	else
		sortAscending = !GetSortAscending();

	// Sort table
	UpdateSortHistory(pNMListView->iSubItem + (sortAscending ? 0 : 100));
	SetSortArrow(pNMListView->iSubItem, sortAscending);
	SortItems(SortProc, pNMListView->iSubItem + (sortAscending ? 0 : 100));

	*pResult = 0;
}

int CDownloadClientsCtrl::SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	const CUpDownClient *item1 = (CUpDownClient *)lParam1;
	const CUpDownClient *item2 = (CUpDownClient *)lParam2;
	int iColumn = (lParamSort >= 100) ? lParamSort - 100 : lParamSort;
	int iResult = 0;
	switch (iColumn)
	{
		case 0:
			if (item1->GetUserName() && item2->GetUserName())
				iResult = CompareLocaleStringNoCase(item1->GetUserName(), item2->GetUserName());
			else if (item1->GetUserName() == NULL)
				iResult = 1; // place clients with no usernames at bottom
			else if (item2->GetUserName() == NULL)
				iResult = -1; // place clients with no usernames at bottom
			break;

		case 1:
			// X-Ray :: ModID :: Start
			/*
			if (item1->GetClientSoft() == item2->GetClientSoft())
				iResult = item1->GetVersion() - item2->GetVersion();
			else 
				iResult = -(item1->GetClientSoft() - item2->GetClientSoft()); // invert result to place eMule's at top
			break;
			*/
			if (item1->GetClientSoft() == item2->GetClientSoft())
			{
				if (item1->GetVersion() == item2->GetVersion() && item1->GetClientSoft() == SO_EMULE)
					iResult = CompareLocaleStringNoCase(item1->GetClientModVer(), item2->GetClientModVer());
				else
					iResult = item1->GetVersion() - item2->GetVersion();
			}
			else 
				iResult = -(item1->GetClientSoft() - item2->GetClientSoft()); // invert result to place eMule's at top
			// X-Ray :: ModID :: End
			break;

		case 2: {
			const CKnownFile *file1 = item1->GetRequestFile();
			const CKnownFile *file2 = item2->GetRequestFile();
			if( (file1 != NULL) && (file2 != NULL))
				iResult = CompareLocaleStringNoCase(file1->GetFileName(), file2->GetFileName());
			else if (file1 == NULL)
				iResult = 1;
			else
				iResult = -1;
			break;
		}

		case 3:
			iResult = CompareUnsigned(item1->GetDownloadDatarate(), item2->GetDownloadDatarate());
			break;

		case 4:
			iResult = CompareUnsigned(item1->GetPartCount(), item2->GetPartCount());
			break;

		case 5:
			iResult = CompareUnsigned(item1->GetSessionDown(), item2->GetSessionDown());
			break;

		case 6:
			iResult = CompareUnsigned(item1->GetSessionUp(), item2->GetSessionUp());
			break;

		case 7:
			iResult = item1->GetSourceFrom() - item2->GetSourceFrom();
			break;

		// X-Ray :: IP2Country :: Start
		case 8:
			iResult = CompareLocaleStringNoCase(item1->GetCountryName(true), item2->GetCountryName(true));
			break;
		// X-Ray :: IP2Country :: End

		// X-Ray :: Argos :: Start
		case 9:
			iResult=wcscmp(theApp.argos->GetArgosString(item1), theApp.argos->GetArgosString(item2));
			break;
		// X-Ray :: Argos :: End
	}

	if (lParamSort >= 100)
		iResult = -iResult;

	//call secondary sortorder, if this one results in equal
	int dwNextSort;
	if (iResult == 0 && (dwNextSort = theApp.emuledlg->transferwnd->downloadclientsctrl.GetNextSortOrder(lParamSort)) != -1)
		iResult = SortProc(lParam1, lParam2, dwNextSort);

	return iResult;
}

void CDownloadClientsCtrl::OnNmDblClk(NMHDR* /*pNMHDR*/, LRESULT* pResult)
{
	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	if (iSel != -1) {
		CUpDownClient* client = (CUpDownClient*)GetItemData(iSel);
		if (client){
			// X-Ray :: ModelessDialogs :: Start
			/*
			CClientDetailDialog dialog(client, this);
			dialog.DoModal();
			*/
			CClientDetailDialog* dlg = new CClientDetailDialog(client, this);
			dlg->OpenDialog();
			// X-Ray :: ModelessDialogs :: End
		}
	}
	*pResult = 0;
}

void CDownloadClientsCtrl::OnContextMenu(CWnd* /*pWnd*/, CPoint point)
{
	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	const CUpDownClient* client = (iSel != -1) ? (CUpDownClient*)GetItemData(iSel) : NULL;

	CTitleMenu ClientMenu;
	ClientMenu.CreatePopupMenu();
	// X-Ray :: XPMenus :: Start
	/*
	ClientMenu.AddMenuTitle(GetResString(IDS_CLIENTS), true);
	*/
	ClientMenu.AddMenuTitle(GetResString(IDS_CLIENTS), true, false, true);
	// X-Ray :: XPMenus :: End
	ClientMenu.AppendMenu(MF_STRING | (client ? MF_ENABLED : MF_GRAYED), MP_DETAIL, GetResString(IDS_SHOWDETAILS), _T("CLIENTDETAILS"));
	ClientMenu.SetDefaultItem(MP_DETAIL);
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && !client->IsFriend()) ? MF_ENABLED : MF_GRAYED), MP_ADDFRIEND, GetResString(IDS_ADDFRIEND), _T("ADDFRIEND"));
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient()) ? MF_ENABLED : MF_GRAYED), MP_MESSAGE, GetResString(IDS_SEND_MSG), _T("SENDMESSAGE"));
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && client->GetViewSharedFilesSupport()) ? MF_ENABLED : MF_GRAYED), MP_SHOWLIST, GetResString(IDS_VIEWFILES), _T("VIEWFILES"));
	if (Kademlia::CKademlia::IsRunning() && !Kademlia::CKademlia::IsConnected())
		ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && client->GetKadPort()!=0) ? MF_ENABLED : MF_GRAYED), MP_BOOT, GetResString(IDS_BOOTSTRAP));
	ClientMenu.AppendMenu(MF_STRING | (GetItemCount() > 0 ? MF_ENABLED : MF_GRAYED), MP_FIND, GetResString(IDS_FIND), _T("Search"));

	// X-Ray :: StopDownload :: Start
	if (client && client->GetDownloadState() == DS_DOWNLOADING){
		ClientMenu.AppendMenu(MF_SEPARATOR);
		ClientMenu.AppendMenu(MF_STRING, MP_STOP_CLIENT, GetResString(IDS_STOP_CLIENT), _T("STOPDOWNLOAD"));
	}
	// X-Ray :: StopDownload :: End

	GetPopupMenuPos(*this, point);
	ClientMenu.TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y, this);
	VERIFY( ClientMenu.DestroyMenu() ); // X-Ray :: XPMenus
}

BOOL CDownloadClientsCtrl::OnCommand(WPARAM wParam, LPARAM /*lParam*/)
{
	wParam = LOWORD(wParam);

	switch (wParam)
	{
		case MP_FIND:
			OnFindStart();
			return TRUE;
	}

	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	if (iSel != -1){
		CUpDownClient* client = (CUpDownClient*)GetItemData(iSel);
		switch (wParam){
			case MP_SHOWLIST:
				client->RequestSharedFileList();
				break;
			case MP_MESSAGE:
				theApp.emuledlg->chatwnd->StartSession(client);
				break;
			case MP_ADDFRIEND:
				if (theApp.friendlist->AddFriend(client))
					Update(iSel);
				break;
			// X-Ray :: StopDownload :: Start
			case MP_STOP_CLIENT: 
				StopSingleClient(client);
				break;
			// X-Ray :: StopDownload :: End
			case MP_DETAIL:
			case MPG_ALTENTER:
			case IDA_ENTER:
			{
				// X-Ray :: ModelessDialogs :: Start
				/*
				CClientDetailDialog dialog(client, this);
				dialog.DoModal();
				*/
				CClientDetailDialog* dlg = new CClientDetailDialog(client, this);
				dlg->OpenDialog();
				// X-Ray :: ModelessDialogs :: End
				break;
			}
			case MP_BOOT:
				if (client->GetKadPort())
					Kademlia::CKademlia::Bootstrap(ntohl(client->GetIP()), client->GetKadPort(), (client->GetKadVersion() > 1));
				break;
		}
	}
	return true;
}

void CDownloadClientsCtrl::AddClient(const CUpDownClient *client)
{
	if (!theApp.emuledlg->IsRunning())
		return;

	int iItemCount = GetItemCount();
	InsertItem(LVIF_TEXT | LVIF_PARAM, iItemCount, LPSTR_TEXTCALLBACK, 0, 0, 0, (LPARAM)client);
	// X-Ray :: RollUpCtrl :: Start
	/*
	theApp.emuledlg->transferwnd->UpdateListCount(CTransferWnd::wnd2Downloading, iItemCount + 1);
	*/
	theApp.emuledlg->transferwnd->UpdateExtendedHeader();
	// X-Ray :: RollUpCtrl :: End
}

void CDownloadClientsCtrl::RemoveClient(const CUpDownClient *client)
{
	if (!theApp.emuledlg->IsRunning())
		return;

	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)client;
	int result = FindItem(&find);
	if (result != -1) {
		DeleteItem(result);
		// X-Ray :: RollUpCtrl :: Start
		/*
		theApp.emuledlg->transferwnd->UpdateListCount(CTransferWnd::wnd2Downloading, GetItemCount()); 
		*/
		theApp.emuledlg->transferwnd->UpdateExtendedHeader();
		// X-Ray :: RollUpCtrl :: End
	}
}

void CDownloadClientsCtrl::RefreshClient(const CUpDownClient *client)
{
	if (!theApp.emuledlg->IsRunning())
		return;

	if (theApp.emuledlg->activewnd != theApp.emuledlg->transferwnd || !theApp.emuledlg->transferwnd->downloadclientsctrl.IsWindowVisible())
		return;

	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)client;
	int result = FindItem(&find);
	if (result != -1)
		Update(result);
}

void CDownloadClientsCtrl::ShowSelectedUserDetails()
{
	POINT point;
	::GetCursorPos(&point);
	CPoint p = point; 
    ScreenToClient(&p); 
    int it = HitTest(p); 
    if (it == -1)
		return;

	SetItemState(-1, 0, LVIS_SELECTED);
	SetItemState(it, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
	SetSelectionMark(it);   // display selection mark correctly!

	CUpDownClient* client = (CUpDownClient*)GetItemData(GetSelectionMark());
	if (client){
		// X-Ray :: ModelessDialogs :: Start
		/*
		CClientDetailDialog dialog(client, this);
		dialog.DoModal();
		*/
		CClientDetailDialog* dlg = new CClientDetailDialog(client, this);
		dlg->OpenDialog();
		// X-Ray :: ModelessDialogs :: End
	}
}

// X-Ray :: StopDownload :: Start
void CDownloadClientsCtrl::StopSingleClient(CUpDownClient* pClient)  
{
	if(pClient != NULL && pClient->GetDownloadState() == DS_DOWNLOADING) {
		if(pClient->socket != NULL)
			pClient->SendCancelTransfer();
		pClient->SetDownloadState(DS_ONQUEUE, _T("Download aborted by User"));
	}
}
// X-Ray :: StopDownload :: End