//this file is part of eMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once
#include "Addons/TreeControl/TreeOptionsCtrl.h"

class CPPg_X_Argos : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPg_X_Argos)

public:
	CPPg_X_Argos();
	virtual ~CPPg_X_Argos();

// Dialog Data
	enum { IDD = IDD_PPG_X_ARGOS };

protected:
	CTreeOptionsCtrl m_ctrlTreeOptions;
	bool m_bInitializedTreeOpts;

	HTREEITEM m_htiUseArgosSystem;
		HTREEITEM m_htiArgosTrustTime;
		HTREEITEM m_htiArgosProcessTime;
		HTREEITEM m_htiArgosTrackTime;
		HTREEITEM m_htiArgosGenericBanTime;
		HTREEITEM m_htiCloseMaellaBackdoor;
		HTREEITEM m_htiCreditCompensation;
		HTREEITEM m_htiDontBanFriends;
		HTREEITEM m_htiArgosLogLeechers;
	
	HTREEITEM m_htiArgosLeecherDetection;
		HTREEITEM m_htiArgosLeecherModDetection;
		HTREEITEM m_htiArgosLeecherNickDetection;
		HTREEITEM m_htiArgosOpcodeDetection;
		HTREEITEM m_htiArgosLeecherHashDetection;
			HTREEITEM m_htiArgosFincanHashDetection;
		HTREEITEM m_htiArgosOpCodeTime;
		HTREEITEM m_htiArgosDetectionLevel;
			HTREEITEM m_htiArgosDetectionReload;
		HTREEITEM m_htiArgosGPLBreakerPunishment;
		HTREEITEM m_htiArgosHardLeecherPunishment;
		HTREEITEM m_htiArgosNormalLeecherPunishment;
		HTREEITEM m_htiArgosSoftLeecherPunishment;
		HTREEITEM m_htiArgosBadModPunishment;
	HTREEITEM m_htiArgosNickThiefDetection;
		HTREEITEM m_htiPlainAntiNickThief;
		HTREEITEM m_htiArgosNickThiefPunishment;
	HTREEITEM m_htiArgosModThiefDetection;
		HTREEITEM m_htiArgosModThiefPunishment;
	HTREEITEM m_htiArgosHashThiefDetection;
		HTREEITEM m_htiTrustUnArgosHashThief;
		HTREEITEM m_htiArgosHashThiefPunishment;
	HTREEITEM m_htiArgosCreditHackDetection;
		HTREEITEM m_htiArgosCreditHackPunishment;
	HTREEITEM m_htiHashChangeDetection;
		HTREEITEM m_htiArgosHashChangedTime;
		HTREEITEM m_htiTrustUnArgosHashChanged;
		HTREEITEM m_htiArgosHashChangedPunishment;
	HTREEITEM m_htiArgosGhostModDetection;
		HTREEITEM m_htiArgosGhostModeTime;	
		HTREEITEM m_htiTrustUnArgosGhostMode;
		HTREEITEM m_htiArgosGhostModePunishment;
	HTREEITEM m_htiArgosFakeClientDetection;
		HTREEITEM m_htiArgosFakeClientPunishment;
	HTREEITEM m_htiAgressionDetection;
		HTREEITEM m_htiAgressionIntervals;
		HTREEITEM m_htiAgressionThreshold;
		HTREEITEM m_htiArgosAgressionBanTime;
		HTREEITEM m_htiTrustUnArgosAgressiv;
		HTREEITEM m_htiArgosAgressonPunishment;
	HTREEITEM m_htiFileScannerDetection;
		HTREEITEM m_htiArgosFileScannerTime;
		HTREEITEM m_htiArgosFileScannerPunishment;
	HTREEITEM m_htiFileFakerDetection;
		HTREEITEM m_htiArgosFileFakerTime;
		HTREEITEM m_htiArgosFileFakerPunishment;
	HTREEITEM m_htiBadSenderDetection;
		HTREEITEM m_htiArgosCorruptedSenderTime;
		HTREEITEM m_htiArgosCorruptedSenderPunishment;
	HTREEITEM m_htiRankFloodDetection;
		HTREEITEM m_htiArgosRankFlooderTime;
		HTREEITEM m_htiArgosRankFlooderPunishment;
	HTREEITEM m_htiFailedDetection;
		HTREEITEM m_htiFailedTries;
		HTREEITEM m_htiFailedThreshold;
		HTREEITEM m_htiArgosFailedTime;
		HTREEITEM m_htiArgosFailedPunishment;
	HTREEITEM m_htiXSExploitDetection;
		HTREEITEM m_htiXSExploitIntervals;
		HTREEITEM m_htiXSExploitThreshold;
		HTREEITEM m_htiArgosXSExploitTime;
		HTREEITEM m_htiArgosXSExploitPunishment;
	HTREEITEM m_htiNickChangerDetection;
		HTREEITEM m_htiNickChangeIntervals;
		HTREEITEM m_htiNickChangeThreshold;
		HTREEITEM m_htiArgosNickChangerTime;
		HTREEITEM m_htiArgosNickChangerPunishment;
	HTREEITEM m_htiModChangerDetection;
		HTREEITEM m_htiModChangeIntervals;
		HTREEITEM m_htiModChangeThreshold;
		HTREEITEM m_htiArgosModChangerTime;
		HTREEITEM m_htiArgosModChangerPunishment;
	HTREEITEM m_htiNullNickDetection;
		HTREEITEM m_htiArgosNullNickTime;
		HTREEITEM m_htiArgosNullNickPunishment;
	HTREEITEM m_htiSpamDetection;
		HTREEITEM m_htiArgosSpamTime;
		HTREEITEM m_htiArgosSpamPunishment;
	HTREEITEM m_htiBadHelloDetection;
		HTREEITEM m_htieMCryptDetection;
		HTREEITEM m_htiArgosBadHelloTime;
		HTREEITEM m_htiArgosBadHelloPunishment;
	HTREEITEM m_htiBadProtDetection;
		HTREEITEM m_htiArgosBadProtTime;
		HTREEITEM m_htiArgosBadProtPunishment;
	HTREEITEM m_htiDLPDetection;
		HTREEITEM m_htiDLPDetectionReload;

	bool	m_bUseArgosSystem;

	int		m_iCreditCompensation;

	bool	m_bTrustUnArgosHashThief;
	bool	m_bTrustUnArgosHashChanged;
	bool	m_bTrustUnArgosGhostMode;
	bool	m_bTrustUnArgosAgressiv;
	int		m_iArgosTrustTime;

	UINT	m_uCloseMaellaBackdoor;

	UINT	m_uDontBanFriends;

	int		m_iArgosProcessTime;
	int		m_iArgosTrackTime;
	int		m_iArgosGenericBanTime;
	int		m_iArgosCorruptedSenderTime;
	int		m_iArgosFileScannerTime;
	int		m_iArgosFileFakerTime;
	int		m_iArgosAgressionBanTime;
	int		m_iArgosOpCodeTime;
	int		m_iArgosHashChangedTime;
	int		m_iArgosRankFlooderTime;
	int		m_iArgosGhostModeTime;	
	int		m_iArgosFailedTime;
	int		m_iArgosXSExploitTime;
	int		m_iArgosNickChangerTime;
	int		m_iArgosModChangerTime;
	int		m_iArgosNullNickTime;
	int		m_iArgosSpamTime;
	int		m_iArgosBadHelloTime;
	int		m_iArgosBadProtTime;


	int		m_iArgosGPLBreakerPunishment;
	int		m_iArgosHardLeecherPunishment;
	int		m_iArgosNormalLeecherPunishment;
	int		m_iArgosSoftLeecherPunishment;
	int		m_iArgosBadModPunishment;
	int		m_iArgosNickThiefPunishment;
	int		m_iArgosModThiefPunishment;
	int		m_iArgosHashThiefPunishment;
	int		m_iArgosCreditHackPunishment;
	int		m_iArgosHashChangedPunishment;
	int		m_iArgosGhostModePunishment;
	int		m_iArgosFakeClientPunishment;
	int		m_iArgosAgressonPunishment;
	int		m_iArgosFileScannerPunishment;
	int		m_iArgosFileFakerPunishment;
	int		m_iArgosCorruptedSenderPunishment;
	int		m_iArgosRankFlooderPunishment;
	int		m_iArgosFailedPunishment;
	int		m_iArgosXSExploitPunishment;
	int		m_iArgosNickChangerPunishment;
	int		m_iArgosModChangerPunishment;
	int		m_iArgosNullNickPunishment;
	int		m_iArgosSpamPunishment;
	int		m_iArgosBadHelloPunishment;
	int		m_iArgosBadProtPunishment;

	bool	m_bArgosLeecherModDetection;
	UINT	m_uArgosLeecherNickDetection;
	int		m_iArgosDetectionLevel;
	bool	m_bArgosOpcodeDetection;
	bool	m_bArgosLeecherHashDetection;
	bool	m_bArgosFincanHashDetection;
	bool	m_bArgosNickThiefDetection;
	bool	m_bPlainAntiNickThief;
	bool	m_bArgosModThiefDetection;
	bool	m_bArgosHashThiefDetection;
	bool	m_bArgosCreditHackDetection;
	bool	m_bHashChangeDetection;
	bool	m_bArgosGhostModDetection;
	UINT	m_uArgosFakeClientDetection;
	UINT	m_uAgressionDetection;
	int 	m_iAgressionIntervals;
	int 	m_iAgressionThreshold;
	bool	m_bFileScannerDetection;
	bool	m_bFileFakerDetection;
	bool	m_bBadSenderDetection;
	bool	m_bRankFloodDetection;
	bool	m_bFailedDetection;
	int 	m_iFailedTries;
	int 	m_iFailedThreshold;
	bool	m_bXSExploitDetection;
	int 	m_iXSExploitIntervals;
	int 	m_iXSExploitThreshold;
	bool	m_bNickChangerDetection;
	int 	m_iNickChangeIntervals;
	int 	m_iNickChangeThreshold;
	bool	m_bModChangerDetection;
	int 	m_iModChangeIntervals;
	int 	m_iModChangeThreshold;
	bool	m_bNullNickDetection;
	bool	m_bSpamDetection;
	bool	m_bBadHelloDetection;
	UINT	m_ueMCryptDetection;
	bool	m_bBadProtDetection;
	UINT	m_uDLPDetection;

	bool	m_bArgosLogLeechers;


	void ClearAllMembers();
	void LoadSettings();

	virtual BOOL OnInitDialog();
	virtual BOOL OnApply();
	virtual BOOL OnKillActive();
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
	afx_msg void OnDestroy();
	afx_msg LRESULT OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT DrawTreeItemHelp(WPARAM wParam, LPARAM lParam);
	afx_msg void OnHelp();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);

private:
	void CheckEnable();
};