//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PPg_X_Upload.h"
#include "opcodes.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "Log.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPg_X_Upload, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPg_X_Upload, CPropertyPage)
	ON_BN_CLICKED(IDC_PRF_UP_DROP_BLOCKERS_CHK, OnSettingsChange) // X-Ray :: SlotControl
	ON_WM_HSCROLL()
END_MESSAGE_MAP()

CPPg_X_Upload::CPPg_X_Upload()
	: CPropertyPage(CPPg_X_Upload::IDD)
{
}

CPPg_X_Upload::~CPPg_X_Upload()
{
}

void CPPg_X_Upload::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BOOL CPPg_X_Upload::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPg_X_Upload::OnApply()
{
	// X-Ray :: SlotControl :: Start
	CalculateMaxSlotSpeed();
	thePrefs.SetSlotSpeed((float)(((CSliderCtrl*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))->GetPos()/10.0f));
	thePrefs.SetDropBlockers(IsDlgButtonChecked(IDC_PRF_UP_DROP_BLOCKERS_CHK) ? true : false);
	// X-Ray :: SlotControl :: End

	LoadSettings();
	return TRUE;
}

void CPPg_X_Upload::LoadSettings()
{
	// X-Ray :: SlotControl :: Start
	CalculateMaxSlotSpeed();
	float fSlotspeed = thePrefs.GetSlotSpeed()*10.0f;
	((CSliderCtrl*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))->SetPos((int)fSlotspeed);
	ShowSlotSpeed();
	CheckDlgButton(IDC_PRF_UP_DROP_BLOCKERS_CHK, thePrefs.IsDropBlockers());
	// X-Ray :: SlotControl :: End
}

void CPPg_X_Upload::Localize()
{
	if (m_hWnd)
	{
		// X-Ray :: SlotControl :: Start
		GetDlgItem(IDC_PRF_UP_SLOTCTRL_GRP)->SetWindowText(GetResString(IDS_PRF_UP_SLOTCTRL_GRP));
		GetDlgItem(IDC_PRF_UP_DROP_BLOCKERS_CHK)->SetWindowText(GetResString(IDS_PRF_UP_DROP_BLOCKERS_CHK));
		// X-Ray :: SlotControl :: End
	}
}

void CPPg_X_Upload::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SetModified();
	// X-Ray :: SlotControl :: Start
	if(pScrollBar == (CScrollBar*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))
		ShowSlotSpeed();
	// X-Ray :: SlotControl :: End
	UpdateData(false); 
	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}

// X-Ray :: SlotControl :: Start
void CPPg_X_Upload::ShowSlotSpeed()
{
	CString buffer;
	buffer.Format(_T("%.1f %s"), (float)((CSliderCtrl*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))->GetPos()/10.0f, GetResString(IDS_KBYTESPERSEC));
	GetDlgItem(IDC_PRF_UP_SLOTCTRL_LBL)->SetWindowText(buffer);
}

void CPPg_X_Upload::CalculateMaxSlotSpeed()
{
	float fMaxUp = 10.0f;
	float fMaxSlotSpeed = 3.0f;
	if(thePrefs.GetMaxUpload() > 0)
		fMaxUp = (float)thePrefs.GetMaxUpload();
	if(fMaxUp <= 6.0f)
		fMaxSlotSpeed = 2.0f;
	if(fMaxUp >= 10.0f)
		fMaxSlotSpeed = fMaxUp/(3.0f+(fMaxUp-10.0f)/20.0f);
	if(fMaxSlotSpeed > VAL_MAXSLOTSPEED)
		fMaxSlotSpeed = VAL_MAXSLOTSPEED;
	fMaxSlotSpeed *= 10.0f;
	if((float)((CSliderCtrl*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))->GetPos() > fMaxSlotSpeed)
		((CSliderCtrl*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))->SetPos((int)fMaxSlotSpeed);
	((CSliderCtrl*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))->SetRange(20, (int)fMaxSlotSpeed, true);
}
// X-Ray :: SlotControl :: End
