//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PPg_X_General.h"
#include "opcodes.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "Log.h"
#include "Addons/defaults.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPg_X_General, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPg_X_General, CPropertyPage)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_PRF_GEN_MISC_DKSTATICSERV, OnSettingsChange) // X-Ray :: StaticServerHandling
	// X-Ray :: ProcessPrio
	ON_BN_CLICKED(IDC_PRF_GEN_PROCESS_RADIO1, OnBnClickedrioRadio)
	ON_BN_CLICKED(IDC_PRF_GEN_PROCESS_RADIO2, OnBnClickedrioRadio)
	ON_BN_CLICKED(IDC_PRF_GEN_PROCESS_RADIO3, OnBnClickedrioRadio)
	// X-Ray :: End
END_MESSAGE_MAP()

CPPg_X_General::CPPg_X_General()
	: CPropertyPage(CPPg_X_General::IDD)
{
}

CPPg_X_General::~CPPg_X_General()
{
}

void CPPg_X_General::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BOOL CPPg_X_General::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPg_X_General::OnApply()
{
	// X-Ray :: ProcessPrio
	thePrefs.SetMainProcessPriority(processprio);
	SetPriorityClass(GetCurrentProcess(), thePrefs.GetMainProcessPriority());
	// X-Ray :: End

	thePrefs.SetNiceHashWeight((uint8)((CSliderCtrl*)GetDlgItem(IDC_PRF_GEN_NICEHASH_SLIDER))->GetPos()); // X-Ray :: NiceHash
	thePrefs.SetDontRemoveStaticServers(IsDlgButtonChecked(IDC_PRF_GEN_MISC_DKSTATICSERV) ? true : false); // X-Ray :: StaticServerHandling

	LoadSettings();
	return TRUE;
}

void CPPg_X_General::LoadSettings()
{
	// X-Ray :: ProcessPrio
	processprio = thePrefs.GetMainProcessPriority();
	switch (thePrefs.GetWindowsVersion()){
		case _WINVER_98_:
		case _WINVER_95_:	
		case _WINVER_ME_:
			GetDlgItem(IDC_PRF_GEN_PROCESS_RADIO2)->EnableWindow(false);
			break;
		default: 
			GetDlgItem(IDC_PRF_GEN_PROCESS_RADIO2)->EnableWindow(true);
		}
	switch(processprio){
		case NORMAL_PRIORITY_CLASS:
			CheckDlgButton(IDC_PRF_GEN_PROCESS_RADIO3, true);
			break;
		case ABOVE_NORMAL_PRIORITY_CLASS:
			CheckDlgButton(IDC_PRF_GEN_PROCESS_RADIO2, true);
			break;
		case HIGH_PRIORITY_CLASS:
			CheckDlgButton(IDC_PRF_GEN_PROCESS_RADIO1, true);
			break;
	}
	// X-Ray :: End

	// X-Ray :: NiceHash
	((CSliderCtrl*)GetDlgItem(IDC_PRF_GEN_NICEHASH_SLIDER))->SetRange(0, 100, true); 
	((CSliderCtrl*)GetDlgItem(IDC_PRF_GEN_NICEHASH_SLIDER))->SetPos(thePrefs.GetNiceHashWeight()); 
	((CSliderCtrl*)GetDlgItem(IDC_PRF_GEN_NICEHASH_SLIDER))->SetTicFreq(10);                     
	// X-Ray :: End

	CheckDlgButton(IDC_PRF_GEN_MISC_DKSTATICSERV, thePrefs.GetDontRemoveStaticServers()); // X-Ray :: StaticServerHandling
}

void CPPg_X_General::Localize()
{
	if (m_hWnd)
	{
		GetDlgItem(IDC_PRF_GEN_MISC_GRP)->SetWindowText(GetResString(IDS_MISC));
		GetDlgItem(IDC_PRF_GEN_MISC_DKSTATICSERV)->SetWindowText(GetResString(IDS_PRF_GEN_MISC_DKSTATICSERV)); // X-Ray :: StaticServerHandling
		// X-Ray :: ProcessPrio
		GetDlgItem(IDC_PRF_GEN_PROCESS_GRP)->SetWindowText(GetResString(IDS_PRF_GEN_PROCESS_GRP));
		GetDlgItem(IDC_PRF_GEN_PROCESS_RADIO1)->SetWindowText(GetResString(IDS_PRF_GEN_PROCESS_RADIO1));
		GetDlgItem(IDC_PRF_GEN_PROCESS_RADIO2)->SetWindowText(GetResString(IDS_PRF_GEN_PROCESS_RADIO2));
		GetDlgItem(IDC_PRF_GEN_PROCESS_RADIO3)->SetWindowText(GetResString(IDS_PRF_GEN_PROCESS_RADIO3));
		// X-Ray :: End

		// X-Ray :: NiceHash
		CString temp;
		temp.Format(GetResString(IDS_PRF_GEN_NICEHASH_STATIC), MS2SEC((float)((CSliderCtrl*)GetDlgItem(IDC_PRF_GEN_NICEHASH_SLIDER))->GetPos()*10)); 
		GetDlgItem(IDC_PRF_GEN_NICEHASH_STATIC)->SetWindowText(temp);
		GetDlgItem(IDC_PRF_GEN_NICEHASH_RIGHT_LBL)->SetWindowText(GetResString(IDS_PRF_GEN_NICEHASH_RIGHT_LBL));
		GetDlgItem(IDC_PRF_GEN_NICEHASH_LEFT_LBL)->SetWindowText(GetResString(IDS_PRF_GEN_NICEHASH_LEFT_LBL));
		GetDlgItem(IDC_PRF_GEN_NICEHASH_GRP)->SetWindowText(GetResString(IDS_PRF_GEN_NICEHASH_GRP)); 
		// X-Ray :: End
	}
}

void CPPg_X_General::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SetModified(TRUE);
	// X-Ray :: NiceHash
	if( pScrollBar == (CScrollBar*)GetDlgItem(IDC_PRF_GEN_NICEHASH_SLIDER))
		ShowNiceHashValue();
	// X-Ray :: End

	UpdateData(false); 
	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}

// X-Ray :: NiceHash
void CPPg_X_General::ShowNiceHashValue()
{
	CString strTemp;
	strTemp.Format(GetResString(IDS_PRF_GEN_NICEHASH_STATIC), MS2SEC((float)((CSliderCtrl*)GetDlgItem(IDC_PRF_GEN_NICEHASH_SLIDER))->GetPos()*10)); 
	GetDlgItem(IDC_PRF_GEN_NICEHASH_STATIC)->SetWindowText(strTemp);
}
// X-Ray :: End

// X-Ray :: ProcessPrio
void CPPg_X_General::OnBnClickedrioRadio()
{
	if(IsDlgButtonChecked(IDC_PRF_GEN_PROCESS_RADIO3))
		processprio = NORMAL_PRIORITY_CLASS;
	else if(IsDlgButtonChecked(IDC_PRF_GEN_PROCESS_RADIO2))
		processprio = ABOVE_NORMAL_PRIORITY_CLASS;
	else if(IsDlgButtonChecked(IDC_PRF_GEN_PROCESS_RADIO1))
		processprio = HIGH_PRIORITY_CLASS;
	SetModified();
}
// X-Ray :: End