//this file is part of eMule
//Copyright (C)2002-2005 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once
#include "ResizableLib\ResizableDialog.h"
#include "SharedFilesCtrl.h"
#include "ProgressCtrlX.h"
#include "IconStatic.h"
#include "SharedDirsTreeCtrl.h"
#include "SplitterControl.h"
#include "EditDelayed.h"
#include "QueueListCtrl.h" // X-Ray :: QueueListPerFile

// X-Ray :: QueueListPerFile :: Start
class CDropDownButton;
enum EShareTabs{
	ST_STATISTICS = 0,
	ST_QUEUE
};
// X-Ray :: QueueListPerFile :: End

class CSharedFilesWnd : public CResizableDialog
{
	DECLARE_DYNAMIC(CSharedFilesWnd)

public:
	CSharedFilesWnd(CWnd* pParent = NULL);   // standard constructor
	virtual ~CSharedFilesWnd();

	void Localize();
	void ShowSelectedFilesSummary();
	void Reload();
	uint32	GetFilterColumn() const				{ return m_nFilterColumn; }

// Dialog Data
	enum { IDD = IDD_FILES };

	CSharedFilesCtrl sharedfilesctrl;
	CStringArray m_astrFilter;
	CSharedDirsTreeCtrl m_ctlSharedDirTree; // X-Ray :: XPMenus
	CQueueListCtrl m_ctlQueuelistctrl; // X-Ray :: QueueListPerFile

private:
	CProgressCtrlX pop_bar;
	CProgressCtrlX pop_baraccept;
	CProgressCtrlX pop_bartrans;
	CFont bold;
	// X-Ray :: QueueListPerFile :: Start
	/*
	CIconStatic m_ctrlStatisticsFrm;
	*/
	// X-Ray :: QueueListPerFile :: End
	// X-Ray :: XPMenus :: Start
	// moved up
	/*
	CSharedDirsTreeCtrl m_ctlSharedDirTree;
	*/
	// X-Ray :: XPMenus :: End
	HICON icon_files;
	CSplitterControl m_wndSplitter;
	CEditDelayed	m_ctlFilter;
	CHeaderCtrl		m_ctlSharedListHeader;
	uint32			m_nFilterColumn;

	// X-Ray :: QueueListPerFile :: Start
	CSplitterControl m_wndDetailSplitter;
	CDropDownButton* m_btnDetail;
	EShareTabs m_stActive;
	// X-Ray :: QueueListPerFile :: End

protected:
	void SetAllIcons();
	void DoResize(int delta);

	// X-Ray :: QueueListPerFile :: Start
	void DoResizeH(int iDelta);
	void SwitchTabs(EShareTabs eInput);
	void UpdateHSplitterRange();
	void SetToolbarIcons();
	void ResetShareDetailToolbar();
	void ChangeIcon(uint8 iIcon);
	// X-Ray :: QueueListPerFile :: End

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual LRESULT DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	virtual BOOL OnCommand(WPARAM wParam, LPARAM /*lParam*/); // X-Ray :: QueueListPerFile

	DECLARE_MESSAGE_MAP()
	// X-Ray :: QueueListPerFile :: Start
	/*
	afx_msg void OnBnClickedReloadSharedFiles();
	*/
	// X-Ray :: QueueListPerFile :: End
	afx_msg void OnLvnItemActivateSharedFiles(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMClickSharedFiles(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnSysColorChange();
	afx_msg void OnStnDblClickFilesIco();
	afx_msg void OnTvnSelChangedSharedDirsTree(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg LRESULT OnChangeFilter(WPARAM wParam, LPARAM lParam);
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg void OnDetailBtnClick(NMHDR *pNMHDR, LRESULT *pResult); // X-Ray :: QueueListPerFile
};
