//this file is part of eMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://NeoMule.tk )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once

enum ELeecherType{
	LT_NO = 0,	// Its NOT a leecher
	LT_BREAKER,	// GPL breaked
	LT_HARD,	// hard leehcer
	LT_NORMAL,	// normal leehcer
	LT_SOFT,	// soft leehcer
	LT_MOD		// Bad mod only
};

enum ELeecherIdent{
	IT_NO = 0,	// Its NOT a leecher
	IT_MOD,		// Is a leecher identyfied by Mod String
	IT_NICK,	// Is a leecher identyfied by Nick Name
	IT_SOFTWARE,// Is a leecher identyfied by Software
	IT_HASH,	// Is a leecher identyfied by hash
	IT_OPCODE,	// Is a leecher identyfied by opcode
	IT_MESSAGE	// Is a leecher identyfied by spam
};

enum EOpcodeProc{
	OC_NULL = 0,
	OC_HELLO,
	OC_INFO,
	OC_PACKET,
	OC_PACKET_EX,
	OC_PACKET_UDP,
	OC_RAW_TCP,
	OC_RAW_UDP
};

struct TOpCode{
	unsigned char	OpCode;
	EOpcodeProc		OpSource;
	unsigned int	OpValue;
};

struct TLeecherInfo{
	ELeecherType	LeecherType;
	ELeecherIdent	Identified;
	BOOL			IdentifiedEx;
	CString			Comment;

	UINT			DetectionLevel;

	TOpCode			DetectedOpCode;
};

struct TArgosResult{
	DWORD			IP;
	TLeecherInfo	Info;
};

class Cdlp 
{
public:
	//BOOL WINAPI DllMain(HINSTANCE hinstDLL,DWORD,LPVOID);

	unsigned int __declspec(dllexport) dlpGetVersion();

	bool __declspec(dllexport) dlpInitialise(UINT preferences, void(*log)(int,CStringW) = NULL);

	TArgosResult __declspec(dllexport) dlpCheckClient(CString strNick, CString strMod, CString strSoft, unsigned char abyHash[16], TOpCode* Opcode, UINT uIP);
};

//////////////////////////////////////////////////////////////////////
//
// The Part bellow is taken from the Xtreme made by Xman
//

//DLP = Dynamic Leecher Protection
//this code is part of Xtreme-Mod
//author: Xman

class CDLP
{
public:
	CDLP(/*CString appdir_in*/);
	~CDLP();
	bool IsDLPavailable()		{return dlpavailable;}
	bool Reload();

	typedef DWORD (__cdecl *GETDLPVERSION)();
	GETDLPVERSION GetDLPVersion;

	typedef LPCTSTR (__cdecl *DLPCHECKMODSTRING_HARD)(LPCTSTR modversion, LPCTSTR clientversion);
	DLPCHECKMODSTRING_HARD DLPCheckModstring_Hard;
	typedef LPCTSTR (__cdecl *DLPCHECKMODSTRING_SOFT)(LPCTSTR modversion, LPCTSTR clientversion);
	DLPCHECKMODSTRING_SOFT DLPCheckModstring_Soft;

	typedef LPCTSTR (__cdecl *DLPCHECKUSERNAME_HARD)(LPCTSTR username);
	DLPCHECKUSERNAME_HARD DLPCheckUsername_Hard;
	typedef LPCTSTR (__cdecl *DLPCHECKUSERNAME_SOFT)(LPCTSTR username);
	DLPCHECKUSERNAME_SOFT DLPCheckUsername_Soft;
	
	typedef LPCTSTR (__cdecl *DLPCHECKNAMEANDHASHANDMOD)(CString username, CString& userhash, CString& modversion);
	DLPCHECKNAMEANDHASHANDMOD DLPCheckNameAndHashAndMod;

	typedef LPCTSTR (__cdecl *DLPCHECKUSERHASH)(const PBYTE userhash);
	DLPCHECKUSERHASH DLPCheckUserhash;

	typedef LPCTSTR (__cdecl *DLPCHECKHELLOTAG)(UINT tagnumber);
	DLPCHECKHELLOTAG DLPCheckHelloTag;
	typedef LPCTSTR (__cdecl *DLPCHECKINFOTAG)(UINT tagnumber);
	DLPCHECKINFOTAG DLPCheckInfoTag;

	//typedef void (WINAPI*TESTFUNC)();
	//TESTFUNC testfunc;

private:
	HINSTANCE dlpInstance;
	bool	dlpavailable;
	CString appdir;
};
