//this file is part of eMule
//Copyright (C)2002-2008 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "ClientListCtrl.h"
#include "otherfunctions.h"
#include "MenuCmds.h"
#include "ClientDetailDialog.h"
#include "KademliaWnd.h"
#include "ClientList.h"
#include "emuledlg.h"
#include "FriendList.h"
#include "TransferWnd.h"
#include "MemDC.h"
#include "UpDownClient.h"
#include "ClientCredits.h"
#include "ListenSocket.h"
#include "ChatWnd.h"
#include "Kademlia/Kademlia/Kademlia.h"
#include "Kademlia/net/KademliaUDPListener.h"
#include "Addons/Argos/Argos.h" // X-Ray :: Argos

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// CClientListCtrl

IMPLEMENT_DYNAMIC(CClientListCtrl, CMuleListCtrl)

BEGIN_MESSAGE_MAP(CClientListCtrl, CMuleListCtrl)
	ON_WM_CONTEXTMENU()
	ON_WM_SYSCOLORCHANGE()
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnClick)
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnNMDblclk)
	ON_NOTIFY_REFLECT(LVN_GETDISPINFO, OnGetDispInfo)
END_MESSAGE_MAP()

CClientListCtrl::CClientListCtrl()
	: CListCtrlItemWalk(this)
{
	SetGeneralPurposeFind(true, false);
}

void CClientListCtrl::Init()
{
	SetName(_T("ClientListCtrl"));

	CImageList ilDummyImageList; //dummy list for getting the proper height of listview entries
	ilDummyImageList.Create(1, theApp.GetSmallSytemIconSize().cy,theApp.m_iDfltImageListColorFlags|ILC_MASK, 1, 1); 
	SetImageList(&ilDummyImageList, LVSIL_SMALL);
	ASSERT( (GetStyle() & LVS_SHAREIMAGELISTS) == 0 );
	ilDummyImageList.Detach();

	SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_INFOTIP);

	InsertColumn(0,GetResString(IDS_QL_USERNAME),LVCFMT_LEFT,150,0);
	InsertColumn(1,GetResString(IDS_CL_UPLOADSTATUS),LVCFMT_LEFT,150,1);
	InsertColumn(2,GetResString(IDS_CL_TRANSFUP),LVCFMT_LEFT,150,2);
	InsertColumn(3,GetResString(IDS_CL_DOWNLSTATUS),LVCFMT_LEFT,150,3);
	InsertColumn(4,GetResString(IDS_CL_TRANSFDOWN),LVCFMT_LEFT,150,4);
	InsertColumn(5,GetResString(IDS_CD_CSOFT),LVCFMT_LEFT,150,5);
	InsertColumn(6,GetResString(IDS_CONNECTED),LVCFMT_LEFT,150,6);
	CString coltemp;
	coltemp=GetResString(IDS_CD_UHASH);coltemp.Remove(':');
	InsertColumn(7,coltemp,LVCFMT_LEFT,150,7);
	InsertColumn(8,GetResString(IDS_COUNTRY),LVCFMT_LEFT,100,8); // X-Ray :: IP2Country
	InsertColumn(9,GetResString(IDS_ARGOS),LVCFMT_LEFT,100,9); // X-Ray :: Argos
	
	SetAllIcons();
	Localize();
	LoadSettings();
	SetSortArrow();
	SortItems(SortProc, GetSortItem()+ (GetSortAscending()? 0:100));

	// X-Ray :: Argos :: Start
	if (!thePrefs.UseArgosSystem())
		HideColumn(9);
	// X-Ray :: Argos :: End
}

CClientListCtrl::~CClientListCtrl()
{
}

void CClientListCtrl::OnSysColorChange()
{
	CMuleListCtrl::OnSysColorChange();
	SetAllIcons();
}

void CClientListCtrl::SetAllIcons()
{
	imagelist.DeleteImageList();
	imagelist.Create(16,16,theApp.m_iDfltImageListColorFlags|ILC_MASK,0,1);
	imagelist.SetBkColor(CLR_NONE);
	imagelist.Add(CTempIconLoader(_T("ClientEDonkey")));
	imagelist.Add(CTempIconLoader(_T("ClientCompatible")));
	imagelist.Add(CTempIconLoader(_T("Friend")));
	imagelist.Add(CTempIconLoader(_T("ClientMLDonkey")));
	imagelist.Add(CTempIconLoader(_T("ClientEDonkeyHybrid")));
	imagelist.Add(CTempIconLoader(_T("ClientShareaza")));
	imagelist.Add(CTempIconLoader(_T("Server")));
	imagelist.Add(CTempIconLoader(_T("ClientAMule")));
	imagelist.Add(CTempIconLoader(_T("ClientLPhant")));
	imagelist.Add(CTempIconLoader(_T("ExtendedProtocolOvl"))); // X-Ray :: CorrectAppIcons
	// X-Ray :: EnhancedClientRecognization :: Start
	imagelist.Add(CTempIconLoader(_T("CLIENTHYRANODE")));
	imagelist.Add(CTempIconLoader(_T("CLIENTPLUS")));
	imagelist.Add(CTempIconLoader(_T("CLIENTTRUSTYFILES")));
	imagelist.Add(CTempIconLoader(_T("CLIENTXMULE")));
	// X-Ray :: EnhancedClientRecognization :: End
	// X-Ray :: Argos :: Start
	imagelist.Add(CTempIconLoader(_T("ARGOS_BANNED_SOFT")));
	imagelist.Add(CTempIconLoader(_T("ARGOS_BANNED_SOFT2")));
	imagelist.Add(CTempIconLoader(_T("ARGOS_LEECHER")));
	imagelist.Add(CTempIconLoader(_T("ARGOS_BANNED")));
	// X-Ray :: Argos :: End
	imagelist.SetOverlayImage(imagelist.Add(CTempIconLoader(_T("ClientSecureOvl"))), 1);
	imagelist.SetOverlayImage(imagelist.Add(CTempIconLoader(_T("OverlayObfu"))), 2);
	imagelist.SetOverlayImage(imagelist.Add(CTempIconLoader(_T("OverlaySecureObfu"))), 3);
}

void CClientListCtrl::Localize()
{
	CHeaderCtrl* pHeaderCtrl = GetHeaderCtrl();
	HDITEM hdi;
	hdi.mask = HDI_TEXT;

	if(pHeaderCtrl->GetItemCount() != 0) {
		CString strRes;

		strRes = GetResString(IDS_QL_USERNAME);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(0, &hdi);

		strRes = GetResString(IDS_CL_UPLOADSTATUS);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(1, &hdi);

		strRes = GetResString(IDS_CL_TRANSFUP);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(2, &hdi);

		strRes = GetResString(IDS_CL_DOWNLSTATUS);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(3, &hdi);

		strRes = GetResString(IDS_CL_TRANSFDOWN);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(4, &hdi);

		strRes = GetResString(IDS_CD_CSOFT);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(5, &hdi);

		strRes = GetResString(IDS_CONNECTED);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(6, &hdi);

		strRes = GetResString(IDS_CD_UHASH);
		strRes.Remove(':');
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(7, &hdi);

		// X-Ray :: IP2Country :: Start
		strRes = GetResString(IDS_COUNTRY);
		strRes.Remove(':');
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(8, &hdi);
		// X-Ray :: IP2Country :: End

		// X-Ray :: Argos :: Start
		strRes = GetResString(IDS_ARGOS);
		hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
		pHeaderCtrl->SetItem(9, &hdi);
		// X-Ray :: Argos :: End
	}
}

void CClientListCtrl::ShowKnownClients()
{
	DeleteAllItems();
	int iItemCount = 0;
	for(POSITION pos = theApp.clientlist->list.GetHeadPosition(); pos != NULL;){
		const CUpDownClient* cur_client = theApp.clientlist->list.GetNext(pos);
		int iItem = InsertItem(LVIF_TEXT|LVIF_PARAM,iItemCount,LPSTR_TEXTCALLBACK,0,0,0,(LPARAM)cur_client);
		Update(iItem);
		iItemCount++;
	}
	// X-Ray :: RollUpCtrl :: Start
	/*
	theApp.emuledlg->transferwnd->UpdateListCount(CTransferWnd::wnd2Clients, iItemCount);
	*/
	theApp.emuledlg->transferwnd->UpdateUploadHeader();
	// X-Ray :: RollUpCtrl :: End
}

void CClientListCtrl::AddClient(const CUpDownClient* client)
{
	if (!theApp.emuledlg->IsRunning())
		return;
	if (thePrefs.IsKnownClientListDisabled())
		return;

	int iItemCount = GetItemCount();
	int iItem = InsertItem(LVIF_TEXT|LVIF_PARAM,iItemCount,LPSTR_TEXTCALLBACK,0,0,0,(LPARAM)client);
	Update(iItem);
	// X-Ray :: RollUpCtrl :: Start
	/*
	theApp.emuledlg->transferwnd->UpdateListCount(CTransferWnd::wnd2Clients, iItemCount+1);
	*/
	theApp.emuledlg->transferwnd->UpdateUploadHeader();
	// X-Ray :: RollUpCtrl :: End
}

void CClientListCtrl::RemoveClient(const CUpDownClient* client)
{
	if (!theApp.emuledlg->IsRunning())
		return;

	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)client;
	int result = FindItem(&find);
	if (result != -1) {
		DeleteItem(result);
		// X-Ray :: RollUpCtrl :: Start
		/*
		theApp.emuledlg->transferwnd->UpdateListCount(CTransferWnd::wnd2Clients);
		*/
		theApp.emuledlg->transferwnd->UpdateUploadHeader();
		// X-Ray :: RollUpCtrl :: End
	}
}

void CClientListCtrl::RefreshClient(const CUpDownClient* client)
{
	// There is some type of timing issue here.. If you click on item in the queue or upload and leave
	// the focus on it when you exit the cient, it breaks on line 854 of emuleDlg.cpp.. 
	// I added this IsRunning() check to this function and the DrawItem method and
	// this seems to keep it from crashing. This is not the fix but a patch until
	// someone points out what is going wrong.. Also, it will still assert in debug mode..
	if (!theApp.emuledlg->IsRunning())
		return;

	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)client;
	int result = FindItem(&find);
	if (result != -1)
		Update(result);
}

#define DLC_DT_TEXT (DT_LEFT|DT_SINGLELINE|DT_VCENTER|DT_NOPREFIX|DT_END_ELLIPSIS)

void CClientListCtrl::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	if (!theApp.emuledlg->IsRunning())
		return;
	if (!lpDrawItemStruct->itemData)
		return;

	// X-Ray :: Optimizations :: Start - Don't draw hidden Rect
	RECT clientRect;
	GetClientRect(&clientRect);
	CRect cur_rec(lpDrawItemStruct->rcItem);
	if ((cur_rec.top < clientRect.top || cur_rec.top > clientRect.bottom) && (cur_rec.bottom < clientRect.top || cur_rec.bottom > clientRect.bottom))
		return;
	// X-Ray :: Optimizations :: End - Don't draw hidden Rect

	CDC* odc = CDC::FromHandle(lpDrawItemStruct->hDC);
	BOOL bCtrlFocused = ((GetFocus() == this) || (GetStyle() & LVS_SHOWSELALWAYS));
	if (lpDrawItemStruct->itemState & ODS_SELECTED) {
		if (bCtrlFocused)
			odc->SetBkColor(m_crHighlight);
		else
			odc->SetBkColor(m_crNoHighlight);
	}
	else
		odc->SetBkColor(GetBkColor());
	const CUpDownClient* client = (CUpDownClient*)lpDrawItemStruct->itemData;
	CMemDC dc(odc, &lpDrawItemStruct->rcItem);
	CFont* pOldFont = dc.SelectObject(GetFont());
	// CRect cur_rec(lpDrawItemStruct->rcItem); // X-Ray :: Optimizations - Don't draw hidden Rect
	COLORREF crOldTextColor = dc.SetTextColor((lpDrawItemStruct->itemState & ODS_SELECTED) ? m_crHighlightText : m_crWindowText);

	int iOldBkMode;
	if (m_crWindowTextBk == CLR_NONE){
		DefWindowProc(WM_ERASEBKGND, (WPARAM)(HDC)dc, 0);
		iOldBkMode = dc.SetBkMode(TRANSPARENT);
	}
	else
		iOldBkMode = OPAQUE;

	CHeaderCtrl *pHeaderCtrl = GetHeaderCtrl();
	int iCount = pHeaderCtrl->GetItemCount();
	cur_rec.right = cur_rec.left - 8;
	cur_rec.left += 4;
	CString Sbuffer;
	for(int iCurrent = 0; iCurrent < iCount; iCurrent++){
		int iColumn = pHeaderCtrl->OrderToIndex(iCurrent);
		if( !IsColumnHidden(iColumn) ){
			cur_rec.right += GetColumnWidth(iColumn);
			if (cur_rec.left < clientRect.right && cur_rec.right > clientRect.left){ // X-Ray :: Optimizations - Only draw item if inside the display area
				switch(iColumn){
					case 0:{
						uint8 image;
						// X-Ray :: Argos :: Start
						if (client->IsBanned()) 
							image = 17;
						else if(theApp.argos->IsArgos(client->GetConnectIP())){
							if (theApp.argos->GetPunishment(client) == 0) 
								image = 14;
							else if (theApp.argos->GetPunishment(client) == 1) 
								image = 16;
							else
								image = 15;
						}
						// X-Ray :: Argos :: End
						else if (client->IsFriend())
							image = 2;
						// X-Ray :: CorrectAppIcons :: Start
						else if (client->GetClientSoft() == SO_EMULE)
							image = 0;
						// X-Ray :: CorrectAppIcons :: End
						else if (client->GetClientSoft() == SO_EDONKEYHYBRID)
							image = 4;
						else if (client->GetClientSoft() == SO_MLDONKEY)
							image = 3;
						else if (client->GetClientSoft() == SO_SHAREAZA)
							image = 5;
						else if (client->GetClientSoft() == SO_URL)
							image = 6;
						else if (client->GetClientSoft() == SO_AMULE)
							image = 7;
						else if (client->GetClientSoft() == SO_LPHANT)
							image = 8;
						// X-Ray :: EnhancedClientRecognization :: Start
						else if (client->GetClientSoft() == SO_EMULEPLUS)
							image = 11;
						else if (client->GetClientSoft() == SO_HYDRANODE)
							image = 10;
						else if (client->GetClientSoft() == SO_TRUSTYFILES)
							image = 12;
						else if (client->GetClientSoft() == SO_XMULE)
							image = 13;
						// X-Ray :: EnhancedClientRecognization :: End

						// X-Ray :: CorrectAppIcons :: Start
						/*
						else if (client->ExtProtocolAvailable())
							image = 1;
						else
							image = 0;
						*/
						else
							image = 1; // changed to Compatible Icon because if it's none of the App's above we don't have an icon for it
						// X-Ray :: CorrectAppIcons :: End

						uint32 nOverlayImage = 0;
						if ((client->Credits() && client->Credits()->GetCurrentIdentState(client->GetIP()) == IS_IDENTIFIED))
							nOverlayImage |= 1;
						if (client->IsObfuscatedConnectionEstablished())
							nOverlayImage |= 2;
						int iIconPosY = (cur_rec.Height() > 16) ? ((cur_rec.Height() - 16) / 2) : 1;
						POINT point = {cur_rec.left, cur_rec.top + iIconPosY};
						imagelist.Draw(dc,image, point, ILD_NORMAL | INDEXTOOVERLAYMASK(nOverlayImage));

						// X-Ray :: CorrectAppIcons :: Start
						if(client->ExtProtocolAvailable())
							imagelist.Draw(dc, 9, point, ILD_TRANSPARENT);
						// X-Ray :: CorrectAppIcons :: End

						if (client->GetUserName()==NULL)
							Sbuffer.Format(_T("(%s)"), GetResString(IDS_UNKNOWN));
						else
							Sbuffer = client->GetUserName();

						// X-Ray :: IP2Country :: Start
						if(theApp.ip2country->ShowCountryFlag()){
							cur_rec.left+=20;
							POINT point2= {cur_rec.left,cur_rec.top+1};
							theApp.ip2country->GetFlagImageList()->Draw(dc, client->GetCountryFlagIndex(), point2, ILD_NORMAL);
						}
						// X-Ray :: IP2Country :: End

						cur_rec.left +=20;
						dc.DrawText(Sbuffer,Sbuffer.GetLength(),&cur_rec,DLC_DT_TEXT);
						cur_rec.left -=20;

						// X-Ray :: IP2Country :: Start
						if(theApp.ip2country->ShowCountryFlag()){
							cur_rec.left-=20;
						}
						// X-Ray :: IP2Country :: End
						break;
					}
					case 1:{
						Sbuffer = client->GetUploadStateDisplayString();
						break;
					}
					case 2:{
						if(client->credits)
							Sbuffer = CastItoXBytes(client->credits->GetUploadedTotal(), false, false);
						else
							Sbuffer.Empty();
						break;
					}
					case 3:{
						Sbuffer = client->GetDownloadStateDisplayString();
						break;
					}
					case 4:{
						if(client->credits)
							Sbuffer = CastItoXBytes(client->credits->GetDownloadedTotal(), false, false);
						else
							Sbuffer.Empty();
						break;
					}
					case 5:{
						Sbuffer = client->GetClientSoftVer();
						if (Sbuffer.IsEmpty())
							Sbuffer = GetResString(IDS_UNKNOWN);
						// X-Ray :: ModID :: Start
						else if (!client->GetClientModVer().IsEmpty())
							Sbuffer.AppendFormat(L" [%s]", client->GetClientModVer());
						// X-Ray :: ModID :: End
						break;
					}
					case 6:{
						if(client->socket){
							if(client->socket->IsConnected()){
								Sbuffer = GetResString(IDS_YES);
								break;
							}
						}
						Sbuffer = GetResString(IDS_NO);
						break;
					}
					case 7:
						Sbuffer = md4str(client->GetUserHash());
						break;
					// X-Ray :: IP2Country :: Start
					case 8:
					{
						Sbuffer.Format(_T("%s"), client->GetCountryName());
						dc->DrawText(Sbuffer,Sbuffer.GetLength(),&cur_rec,DLC_DT_TEXT);
						break;
					}
					// X-Ray :: IP2Country :: End
					// X-Ray :: Argos :: Start
					case 9:
						if(thePrefs.UseArgosSystem())
							Sbuffer = theApp.argos->GetArgosString(client);
						break;
					// X-Ray :: Argos :: End
				}
				if( iColumn != 0)
					dc.DrawText(Sbuffer,Sbuffer.GetLength(),&cur_rec,DLC_DT_TEXT);
			}
			cur_rec.left += GetColumnWidth(iColumn);
		}
	}

	// draw rectangle around selected item(s)
	if (lpDrawItemStruct->itemState & ODS_SELECTED)
	{
		RECT outline_rec = lpDrawItemStruct->rcItem;

		outline_rec.top--;
		outline_rec.bottom++;
		dc.FrameRect(&outline_rec, &CBrush(GetBkColor()));
		outline_rec.top++;
		outline_rec.bottom--;
		outline_rec.left++;
		outline_rec.right--;

		if(bCtrlFocused)
			dc.FrameRect(&outline_rec, &CBrush(m_crFocusLine));
		else
			dc.FrameRect(&outline_rec, &CBrush(m_crNoFocusLine));
	}

	if (m_crWindowTextBk == CLR_NONE)
		dc.SetBkMode(iOldBkMode);
	dc.SelectObject(pOldFont);
	dc.SetTextColor(crOldTextColor);
}
	
void CClientListCtrl::OnContextMenu(CWnd* /*pWnd*/, CPoint point)
{
	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	const CUpDownClient* client = (iSel != -1) ? (CUpDownClient*)GetItemData(iSel) : NULL;

	CTitleMenu ClientMenu;
	ClientMenu.CreatePopupMenu();
	// X-Ray :: XPMenus :: Start
	/*
	ClientMenu.AddMenuTitle(GetResString(IDS_CLIENTS), true);
	*/
	ClientMenu.AddMenuTitle(GetResString(IDS_CLIENTS), true, false, true);
	// X-Ray :: XPMenus :: End
	ClientMenu.AppendMenu(MF_STRING | (client ? MF_ENABLED : MF_GRAYED), MP_DETAIL, GetResString(IDS_SHOWDETAILS), _T("CLIENTDETAILS"));
	ClientMenu.SetDefaultItem(MP_DETAIL);
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && !client->IsFriend()) ? MF_ENABLED : MF_GRAYED), MP_ADDFRIEND, GetResString(IDS_ADDFRIEND), _T("ADDFRIEND"));
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient()) ? MF_ENABLED : MF_GRAYED), MP_MESSAGE, GetResString(IDS_SEND_MSG), _T("SENDMESSAGE"));
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && client->GetViewSharedFilesSupport()) ? MF_ENABLED : MF_GRAYED), MP_SHOWLIST, GetResString(IDS_VIEWFILES), _T("VIEWFILES"));
	if (Kademlia::CKademlia::IsRunning() && !Kademlia::CKademlia::IsConnected())
		ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && client->GetKadPort()!=0) ? MF_ENABLED : MF_GRAYED), MP_BOOT, GetResString(IDS_BOOTSTRAP));
	ClientMenu.AppendMenu(MF_STRING | (GetItemCount() > 0 ? MF_ENABLED : MF_GRAYED), MP_FIND, GetResString(IDS_FIND), _T("Search"));
	// X-Ray :: Argos :: Start
	if (thePrefs.IsExtControlsEnabled()) {
		ClientMenu.AppendMenu(MF_SEPARATOR);
		ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && (client->IsBanned() || theApp.argos->IsArgos(client->GetConnectIP()))) ? MF_ENABLED : MF_GRAYED), MP_UNBAN, GetResString(IDS_UNBAN), _T("STATSCLIENTS"));
	}
	// X-Ray :: Argos :: End
	GetPopupMenuPos(*this, point);
	ClientMenu.TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y, this);
	VERIFY( ClientMenu.DestroyMenu() ); // X-Ray :: XPMenus
}

BOOL CClientListCtrl::OnCommand(WPARAM wParam, LPARAM /*lParam*/)
{
	wParam = LOWORD(wParam);

	switch (wParam)
	{
		case MP_FIND:
			OnFindStart();
			return TRUE;
	}

	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	if (iSel != -1){
		CUpDownClient* client = (CUpDownClient*)GetItemData(iSel);
		switch (wParam){
			case MP_SHOWLIST:
				client->RequestSharedFileList();
				break;
			case MP_MESSAGE:
				theApp.emuledlg->chatwnd->StartSession(client);
				break;
			case MP_ADDFRIEND:
				if (theApp.friendlist->AddFriend(client))
					Update(iSel);
				break;
			case MP_UNBAN:
				// X-Ray :: Argos :: Start
				if(thePrefs.UseArgosSystem())
					theApp.argos->UnArgos(client->GetConnectIP(), AR_NULL);
				// X-Ray :: Argos :: End
				if (client->IsBanned()){
					client->UnBan();
					Update(iSel);
				}
				break;
			case MP_DETAIL:
			case MPG_ALTENTER:
			case IDA_ENTER:
			{
				// X-Ray :: ModelessDialogs :: Start
				/*
				CClientDetailDialog dialog(client, this);
				dialog.DoModal();
				*/
				CClientDetailDialog* dlg = new CClientDetailDialog(client, this);
				dlg->OpenDialog(); 
				// X-Ray :: ModelessDialogs :: End
				break;
			}
			case MP_BOOT:
				if (client->GetKadPort())
					Kademlia::CKademlia::Bootstrap(ntohl(client->GetIP()), client->GetKadPort(), (client->GetKadVersion() > 1));
				break;
		}
	}
	return true;
} 

void CClientListCtrl::OnColumnClick( NMHDR* pNMHDR, LRESULT* pResult){

	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// Barry - Store sort order in preferences
	// Determine ascending based on whether already sorted on this column
	bool sortAscending = (GetSortItem()!= pNMListView->iSubItem) ? true : !GetSortAscending();

	// Sort table
	UpdateSortHistory(pNMListView->iSubItem + (sortAscending ? 0:100), 100);
	SetSortArrow(pNMListView->iSubItem, sortAscending);
	SortItems(SortProc, pNMListView->iSubItem + (sortAscending ? 0:100));

	*pResult = 0;
}

int CClientListCtrl::SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	const CUpDownClient* item1 = (CUpDownClient*)lParam1;
	const CUpDownClient* item2 = (CUpDownClient*)lParam2;
	
	int iResult=0;
	switch (lParamSort) {
	    case 0:
			if (item1->GetUserName() && item2->GetUserName())
				iResult=CompareLocaleStringNoCase(item1->GetUserName(), item2->GetUserName());
			else if (!item1->GetUserName() && !item2->GetUserName())
				iResult=0;
			else {
				// place clients with no usernames at bottom
				if (!item1->GetUserName())
					iResult=1;
				else
					iResult=-1;
			}
			break;
	    case 100:
			if (item1->GetUserName() && item2->GetUserName())
				iResult=CompareLocaleStringNoCase(item2->GetUserName(), item1->GetUserName());
			else if (!item1->GetUserName() && !item2->GetUserName())
				iResult=0;
			else {
				// place clients with no usernames at bottom
				if (!item1->GetUserName())
					iResult=1;
				else
					iResult=-1;
			}
			break;

		case 1:
		    iResult=item1->GetUploadState() - item2->GetUploadState();
			break;
	    case 101:
		    iResult=item2->GetUploadState() - item1->GetUploadState();
			break;

		case 2:
			if (item1->credits && item2->credits)
				iResult=CompareUnsigned64(item1->credits->GetUploadedTotal(), item2->credits->GetUploadedTotal());
			else if (!item1->credits)
			    iResult=1;
			else
				iResult=-1;
			break;
	    case 102:
			if (item1->credits && item2->credits)
				iResult=CompareUnsigned64(item2->credits->GetUploadedTotal(), item1->credits->GetUploadedTotal());
			else if (!item1->credits)
				iResult=1;
			else
			    iResult=-1;
			break;

		case 3:
		    if (item1->GetDownloadState() == item2->GetDownloadState()) {
			    if (item1->IsRemoteQueueFull() && item2->IsRemoteQueueFull())
				    iResult=0;
			    else if (item1->IsRemoteQueueFull())
				    iResult=1;
			    else if (item2->IsRemoteQueueFull())
				    iResult=-1;
			    else
				    iResult=0;
		    } else
				iResult=item1->GetDownloadState() - item2->GetDownloadState();
			break;
	    case 103:
		    if (item2->GetDownloadState() == item1->GetDownloadState()) {
			    if (item2->IsRemoteQueueFull() && item1->IsRemoteQueueFull())
				    iResult=0;
			    else if (item2->IsRemoteQueueFull())
				    iResult=1;
			    else if (item1->IsRemoteQueueFull())
				    iResult=-1;
			    else
				    iResult=0;
		    } else
				iResult=item2->GetDownloadState() - item1->GetDownloadState();
			break;

		case 4:
		    if (item1->credits && item2->credits)
				iResult=CompareUnsigned64(item1->credits->GetDownloadedTotal(), item2->credits->GetDownloadedTotal());
		    else if (!item1->credits)
			    iResult=1;
		    else
				iResult=-1;
			break;
	    case 104:
		    if (item1->credits && item2->credits)
				iResult=CompareUnsigned64(item2->credits->GetDownloadedTotal(), item1->credits->GetDownloadedTotal());
		    else if (!item1->credits)
			    iResult=1;
		    else
			    iResult=-1;
			break;

		case 5:
			// X-Ray :: ModID :: Start
			/*
	                if (item1->GetClientSoft() == item2->GetClientSoft())
			   iResult=item2->GetVersion() - item1->GetVersion();
	                else 
				iResult=item1->GetClientSoft() - item2->GetClientSoft();
			break;
			*/
			if (item1->GetClientSoft() != item2->GetClientSoft())
				iResult=item1->GetClientSoft() - item2->GetClientSoft();
			else if (item1->GetVersion() != item2->GetVersion())
				iResult=item2->GetVersion() - item1->GetVersion();
			else 
				iResult=item2->GetClientModVer().CompareNoCase(item1->GetClientModVer());
			// X-Ray :: ModID :: End
			break;

		case 105:
			// X-Ray :: ModID :: Start
			/*
			if (item1->GetClientSoft() == item2->GetClientSoft())
			    iResult=item1->GetVersion() - item2->GetVersion();
			else
				iResult=item2->GetClientSoft() - item1->GetClientSoft();
			break;
			*/
			if (item1->GetClientSoft() != item2->GetClientSoft())
				iResult=item2->GetClientSoft() - item1->GetClientSoft();
			else if (item1->GetVersion() != item2->GetVersion())
				iResult=item1->GetVersion() - item2->GetVersion();
			else
				iResult=item1->GetClientModVer().CompareNoCase(item2->GetClientModVer());
			// X-Ray :: ModID :: End
			break;

		case 6:
		    if (item1->socket && item2->socket)
			    iResult=item1->socket->IsConnected() - item2->socket->IsConnected();
		    else if (!item1->socket)
			    iResult=-1;
		    else
			    iResult=1;
			break;
	    case 106:
		    if (item1->socket && item2->socket)
			    iResult=item2->socket->IsConnected() - item1->socket->IsConnected();
		    else if (!item2->socket)
			    iResult=-1;
		    else
			    iResult=1;
			break;

		case 7:
		    iResult=memcmp(item1->GetUserHash(), item2->GetUserHash(), 16);
			break;
	    case 107:
		    iResult=memcmp(item2->GetUserHash(), item1->GetUserHash(), 16);
			break;

		// X-Ray :: IP2Country :: Start
		case 8:
			iResult = CompareLocaleStringNoCase(item1->GetCountryName(true), item2->GetCountryName(true));
			break;
		case 108:
			iResult = CompareLocaleStringNoCase(item2->GetCountryName(true), item1->GetCountryName(true));
			break;
		// X-Ray :: IP2Country :: End

		// X-Ray :: Argos :: Start
		case 9:
			iResult=wcscmp(theApp.argos->GetArgosString(item1), theApp.argos->GetArgosString(item2));
			break;
		case 109:
			iResult=wcscmp(theApp.argos->GetArgosString(item2), theApp.argos->GetArgosString(item1));
			break;
		// X-Ray :: Argos :: End

		default:
			iResult=0;
	}

	int dwNextSort;
	//call secondary sortorder, if this one results in equal
	//(Note: yes I know this call is evil OO wise, but better than changing a lot more code, while we have only one instance anyway - might be fixed later)
	if (iResult == 0 && (dwNextSort = theApp.emuledlg->transferwnd->clientlistctrl.GetNextSortOrder(lParamSort)) != (-1)){
		iResult= SortProc(lParam1, lParam2, dwNextSort);
	}

	return iResult;
}

void CClientListCtrl::ShowSelectedUserDetails()
{
	POINT point;
	::GetCursorPos(&point);
	CPoint p = point; 
    ScreenToClient(&p); 
    int it = HitTest(p); 
    if (it == -1)
		return;

	SetItemState(-1, 0, LVIS_SELECTED);
	SetItemState(it, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
	SetSelectionMark(it);   // display selection mark correctly!

	CUpDownClient* client = (CUpDownClient*)GetItemData(GetSelectionMark());
	if (client){
		// X-Ray :: ModelessDialogs :: Start
		/*
		CClientDetailDialog dialog(client, this);
		dialog.DoModal();
		*/
		CClientDetailDialog* dlg = new CClientDetailDialog(client, this);
		dlg->OpenDialog();
		// X-Ray :: ModelessDialogs :: End
	}
}

void CClientListCtrl::OnNMDblclk(NMHDR* /*pNMHDR*/, LRESULT* pResult)
{
	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	if (iSel != -1) {
		CUpDownClient* client = (CUpDownClient*)GetItemData(iSel);
		if (client){
			// X-Ray :: ModelessDialogs :: Start
			/*
			CClientDetailDialog dialog(client, this);
			dialog.DoModal();
			*/
			CClientDetailDialog* dlg = new CClientDetailDialog(client, this);
			dlg->OpenDialog();
			// X-Ray :: ModelessDialogs :: End
		}
	}
	*pResult = 0;
}

void CClientListCtrl::OnGetDispInfo(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLVDISPINFO *pDispInfo = reinterpret_cast<NMLVDISPINFO*>(pNMHDR);

	if (theApp.emuledlg->IsRunning()){
		// Although we have an owner drawn listview control we store the text for the primary item in the listview, to be
		// capable of quick searching those items via the keyboard. Because our listview items may change their contents,
		// we do this via a text callback function. The listview control will send us the LVN_DISPINFO notification if
		// it needs to know the contents of the primary item.
		//
		// But, the listview control sends this notification all the time, even if we do not search for an item. At least
		// this notification is only sent for the visible items and not for all items in the list. Though, because this
		// function is invoked *very* often, no *NOT* put any time consuming code here in.

		if (pDispInfo->item.mask & LVIF_TEXT){
			const CUpDownClient* pClient = reinterpret_cast<CUpDownClient*>(pDispInfo->item.lParam);
			if (pClient != NULL){
				switch (pDispInfo->item.iSubItem){
					case 0:
						if (pClient->GetUserName() != NULL && pDispInfo->item.cchTextMax > 0){
							_tcsncpy(pDispInfo->item.pszText, pClient->GetUserName(), pDispInfo->item.cchTextMax);
							pDispInfo->item.pszText[pDispInfo->item.cchTextMax-1] = _T('\0');
						}
						break;
					default:
						// shouldn't happen
						pDispInfo->item.pszText[0] = _T('\0');
						break;
				}
			}
		}
	}
	*pResult = 0;
}
