//DLP = Dynamic Leecher Protection
//this code is part of Silversurfer & X-Ray
//author: Xman modified by dlarge, Stulle, WiZaRd & JvA

//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <atlstr.h>
#include "antiLeech.h"
#include "libald.h"

#define AJ_MD5_BUFFER_SIZE	92				// The buffer is always this length exactly

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

//>>> eWombat [SNAFU_V3]
LPCTSTR apszSnafuTag[]=
{
	L"[DodgeBoards]",										//0
	L"[DodgeBoards & DarkMule eVorteX]",					//1
	L"[DarkMule v6 eVorteX]",								//2
	L"[eMuleReactor]",										//3
	L"[Bionic]",											//4
	L"[LSD7c]",												//5
	L"[0x8d] unknown Leecher - (client version:60)",		//6
	L"[RAMMSTEIN]",											//7
	L"[MD5 Community]",										//8
	L"[new DarkMule]",										//9
	L"[OMEGA v.07 Heiko]",									//10
	L"[eMule v0.26 Leecher]",								//11
	L"[Hunter]",											//12
	L"[Bionic 0.20 Beta]",									//13
	L"[Rumata (rus)(Plus v1f)]",							//14
	L"[Fusspi]",											//15
	L"[donkey2002]",										//16
	L"[md4]",											    //17
	L"[SpeedMule]",											//18 Xman
	L"[pimp]",												//19 Xman
	L"[xunlei]"												//20 JvA
};


BOOL WINAPI DllMain(HANDLE hModule, DWORD dwFunction, LPVOID lpNot)
{
	switch(dwFunction)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
	}

	return TRUE;
}


void __declspec(dllexport) TestFunc()
{
	::MessageBox(NULL, L"Inside the DLL!", L"Nix", 0);
}

bool IsTypicalHex(CString& addon)
{
	if(addon.GetLength() > 25 || addon.GetLength() < 5)
		return false;

	short bigalpha = 0;
	short smallalpha = 0;
	short numeric = 0;

	int endpos=addon.GetLength();
	for(int i=0; i<endpos;i++){
		if( (addon.GetAt(i)>=_T('0') && addon.GetAt(i)<=_T('9')) )
			numeric++;
		else if( (addon.GetAt(i)>=_T('A') && addon.GetAt(i)<=_T('F')) )
			bigalpha++;
		else if( (addon.GetAt(i)>=_T('a') && addon.GetAt(i)<=_T('f')) )
			smallalpha++;
		else
			break;
	}
	if(i == endpos && (numeric > 0 && (smallalpha > 0 && bigalpha == 0 || smallalpha == 0 && bigalpha > 0)))
		return true;

	return false;
}

LPCTSTR __declspec(dllexport) DLPCheckUserhash(const PBYTE userhash)
{
	int buflen;
	BOOL bIsApplejuice = FALSE;
	BYTE AJByte;
	BYTE md5_hashval[16];
	BYTE buffer[AJ_MD5_BUFFER_SIZE + 2];	// Need 2 extra bytes because _tprintf()
	_TCHAR FormatString[] =	L"@ppl"			// adds a terminating UNICODE NULL char
		L"%.2X%.2X%.2X%.2X%.2X%.2X%.2X%.2X"
		L" ufablE "
		L"%.2X%.2X%.2X%.2X%.2X%.2X%.2X"
		L" 89";

	buflen = _stprintf((TCHAR *)buffer,
		FormatString,
		userhash[0], userhash[1], userhash[2], userhash[3],
		userhash[4], userhash[5], userhash[6], userhash[7],
		userhash[9], userhash[10], userhash[11], userhash[12],
		userhash[13], userhash[14], userhash[15]
		);

		// Hash the data in the buffer using the MD5 algorithm
		if (MD5_FUNCTION(buffer, buflen * sizeof(TCHAR), md5_hashval)) {
			AJByte = ((md5_hashval[4] & 0x0F) << 4) | (md5_hashval[12] & 0x0F);
			bIsApplejuice = (userhash[8] == AJByte);
		}

		//return bIsApplejuice;
		if(bIsApplejuice)
			return L"Applejuice Community";
		else
			return NULL;
}

//new versions
LPCTSTR __declspec(dllexport) DLPCheckModstring_Hard(LPCTSTR modversion, LPCTSTR clientversion)
{
	if(modversion == NULL || clientversion == NULL)
		return NULL;

	// added by WiZaRd
	if(StrStrI(modversion, L"eMule Compat v0.26.2"))
		return L"Flashget";

	if (StrStrI(modversion, L"FXeMule") ||
		StrStrI(modversion, L"FX eMule") ||
		StrStrI(modversion, L"RIAA") ||
		StrStrI(modversion, L"SpeedLoad") ||
		StrStrI(modversion, L"Element") || 
		StrStrI(modversion, L"Rappi") ||
		StrStrI(modversion, L"EastShare") && StrStrI(clientversion, L"0.29") ||
		StrStrI(modversion, L"eChanblard v7.0") ||
		StrStrI(modversion, L"          ") ||
		StrStrI(modversion, L"@RAPTOR") ||
		StrStr(modversion, L"pwNd muLe") ||
		StrStrI(modversion, L"HARDPAW") ||
		StrStrI(modversion, L"LSD") ||			
		StrStrI(modversion, L"Bad Donkey") || //WiZaRd
		StrStrI(modversion, L"DSL-Light-Client") || //WiZaRd
		StrStrI(modversion, L"Elben") || //WiZaRd
		StrStr(modversion, L"PROeMule") || //WiZaRd
		StrStrI(modversion, L"Devil") ||
		StrStrI(modversion, L"Elfen") ||
		StrStrI(modversion, L"Ef-mod 2.0") || //Xman this mod can be abused as a full leecher
		StrStrI(modversion, L"Xtreme Xtended") || //Xman 15.08.05
		StrStrI(modversion, L"MirageMod") ||
		StrStrI(modversion, L"SpeedX") ||
		StrStrI(modversion, L"AIDEADSL") ||
		StrStrI(modversion, L"Hypnotix") ||
		StrStrI(modversion, L"BLACKMULE") || 
		StrStrI(modversion, L"blackviper") ||
		StrStrI(modversion, L"BlackAngel") ||
		StrStrI(modversion, L"rabbit") || 
		StrStrI(modversion, L"rabb_it") || 
		StrStrI(modversion, L"Raptor") || 
		StrStrI(modversion, L"Hawkstar") || 
		StrStrI(modversion, L"ServerClient") || 
		StrStrI(modversion, L"Love-Angel") || 
		StrStrI(modversion, L"SuperKiller") || 
		StrStrI(modversion, L"ZamBoR") ||
		StrStrI(modversion, L"Morph") && (StrStrI(modversion, L"Max") || StrStrI(modversion, L"+") || StrStrI(modversion, L"")) ||
		StrStrI(modversion, L"Morph XT") ||	//very bad mod (MPAA ?)
		StrStrI(modversion, L"Mrph") ||
		StrStrI(modversion, L"BlueHex") ||
		StrStrI(modversion, L"FlowerPower") ||
		StrStrI(modversion, L"Fincan") ||
		StrStrI(modversion, L"OO.de") ||	//WiZaRd		
		StrStrI(modversion, L"00.de") || //WiZaRd
		StrStrI(modversion, L"OOde") || //WiZaRd
		StrStrI(modversion, L"00de") ||
		StrStrI(modversion, L"Heartbreaker") ||
		StrStrI(modversion, L"Arabella") ||
		StrStrI(modversion, L"Administrator") ||
		StrStrI(modversion, L"B@d-D3vi7") ||
		StrStrI(modversion, L"Dying Angel") ||
		StrStrI(modversion, L"FREAK MOD VENOM") ||
		StrStrI(modversion, L"CryptedSpeed") ||
		StrStrI(modversion, L"h34r7b34k3r") ||
		StrStrI(modversion, L"Exorzist") ||
		StrStrI(modversion, L"A.i.d.e-A.D.S.L") ||
		StrStrI(modversion, L"albaR") ||
		StrStrI(modversion, L"AngelDr") ||	//5/2006
		StrStrI(modversion, L"Tombstone Reloaded") || //5/2006
		StrStrI(modversion, L"Tombstone Next") || //10/2006
		StrStrI(modversion, L"pP.r8b") || //5/2006
		StrStrI(modversion, L"x0Rz!$T") || //E/xorzist
		StrStrI(modversion, L"xORz!T") ||
		StrStrI(clientversion, L"eMule Compat v0.40") || //7/2006
		StrStrI(clientversion, L"eMule Compat v127.") || //8/2006
		StrStrI(modversion, L"No Ratio") || //based on scarangel 7/2006
		StrStrI(modversion, L"DeathAngel") || //based on Xtreme 8/2006
		StrStrI(modversion, L"PROemule") ||	//9/2006
		StrStrI(modversion, L"Simple Leecher") ||	//9/2006
		StrStrI(modversion, L"oFF *+*") ||	//10/2006
		StrStrI(modversion, L"0FF ") ||	//6/2007
		StrStrI(modversion, L"SmartMuli") ||	//12/2006
		StrStrI(modversion, L"D10T") ||	//12/2006
		StrStrI(modversion, L"the fonz") ||	//12/2006
		StrStrI(modversion, L"Hyperdrive") ||	//1/2007
		StrStrI(modversion, L"NextEvolution") ||	//1/2007
		StrStrI(modversion, L"Pimp") ||	//3/2007
		StrStrI(modversion, L"AeOnFlux") ||	//8/2007
		//8/2007 from dlarge:
		StrStrI(modversion, L"Final Fight") || //added dlarge
		StrStrI(modversion, L"SuperKiller") || //added dlarge
		StrStrI(modversion, L"X-Cite") || //added dlarge
		StrStrI(modversion, L"waZZa") || //added dlarge
		StrStrI(modversion, L"Merza") || //added dlarge
		StrStrI(modversion, L"K.O.T.") || //added dlarge
		StrStrI(modversion, L"Licokine") || //added dlarge
		StrStrI(modversion, L"BlackStar") || //added dlarge
		StrStrI(modversion, L"nEwLoGic") || //added dlarge
		//end
		StrStrI(modversion, L"SPEED EMULE") || //MyTh	
		StrStrI(modversion, L"SPIKE2 +") || //MyTh hard leecher
		StrStrI(modversion, L"Adunanza") || //MyTh italian ISP-spec com user
		StrStrI(modversion, L"Asiklar") || //MyTh apple-com
		StrStrI(modversion, L"SunPower") || //MyTh apple-com
		StrStrI(modversion, L"Fireball") || //MyTh "
		StrStrI(modversion, L"Shadow") || //MyTh
		StrStrI(modversion, L"XdP") || //MyTh
		StrStrI(modversion, L"EPB") || //MyTh
		StrStrI(modversion, L"Tyrantmule") || //MyTh
		StrStrI(modversion, L"Turkmule") || //MyTh
		StrStrI(modversion, L"APRC") || //MyTh
		StrStrI(modversion, L"Hardstyle") || //MyTh
		StrStrI(modversion, L"pP.r12b") || //MyTh
		StrStrI(modversion, L"Simple Life") || //MyTh
		StrStrI(modversion, L"PRO") || //MyTh eMule 0.49a PRO (+ONO)
		StrStrI(modversion, L"TYRANUS") || //MyTh
		StrStrI(modversion, L"Dein Modstring") || // JvA: moved up from soft because also used by Applejuice
		StrStrI(modversion, L"Angelmule") || // JvA: no sources, no changelog, community username,...
		StrStrI(modversion, L"TR-P2P-MoD") || // JvA: bad client
		StrStrI(modversion, L"Esekci") || // JvA: no sources, no changelog, ...
		StrStrI(modversion, L"OS_") || //Xman most are found via other checks, but not all
		StrStrI(modversion, L"TM0910") || // WiZaRd: Chinese Leecher
		StrStrI(modversion, L"Wikinger-Mod") || // WiZaRd: apple-com
		StrStrI(modversion, L"ROCKFORCE") || // WiZaRd: apple-com
		StrStrI(modversion, L"RC-ATLANTIS") || // WiZaRd: apple-com
		StrStrI(modversion, L"RapCom Mod") || //added dlarge 
		StrStrI(modversion, L"SBI leecher") || //added dlarge 
		StrStrI(modversion, L"TS Next Lite") || //added dlarge  
		StrStrI(modversion, L"Applejuice") || //6/2007 now ban instead score reduce
		_tcslen(modversion) > 0 && (StrStrI(clientversion, L"edonkey") || modversion[0] == L'[') ||  //1. donkey user with modstring, 2. modstring begins with [ this is a known leecher
		(StrStrI(modversion, L"Xtreme") && StrStrI(modversion, L"]"))  //bad Xtreme mod
		)
		return L"Bad MODSTRING";

	if(StrStr(modversion, L"xtreme")) //case sensitive!
		return L"Fake Xtreme";


	return NULL;
}

LPCTSTR __declspec(dllexport) DLPCheckModstring_Soft(LPCTSTR modversion, LPCTSTR clientversion)
{
	if(modversion == NULL || clientversion == NULL)
		return NULL;

	if (StrStrI(modversion, L"Rockesel") || 
		StrStrI(modversion, L"HARDMULE") ||
		StrStrI(modversion, L"Community") || 
		StrStrI(modversion, L"IcE-MoD") ||
		StrStrI(modversion, L"a-eDit") ||
		StrStrI(modversion, L"Ultimativ") ||
		StrStrI(modversion, L"Ultimate") ||
		StrStrI(modversion, L"Ulti F") ||
		StrStrI(modversion, L"Enter MoD Name") ||
		StrStrI(modversion, L"choose your modstring") || // 3/2007
		//8/2007 from dlarge:
		StrStrI(modversion, L"Enter Your Modstring") || //added dlarge
		StrStrI(modversion, L"C-E-R-E-B-R-O") || //added dlarge
		//end
		StrStrI(modversion, L"NewMule") ||
		StrStrI(modversion, L"smart- muli") ||
		StrStrI(modversion, L"TCMatic 3") || //1/2007  //version 3 is the public version and used as leecher
		StrStrI(clientversion, L"eMule v2.0") || //6/2007 fake Xtreme / GPL-breaker
		StrStrI(modversion, L"uptempo")
		)
		return L"Bad MODSTRING";


	return NULL;
}

LPCTSTR __declspec(dllexport) DLPCheckUsername_Hard(LPCTSTR username)
{
	if(username == NULL)
		return NULL;

	if (StrStrI(username, L"emule-speed") ||
		StrStrI(username, L"Intuition") ||
		StrStrI(username, L"emule-element") ||
		StrStrI(username, L"Ketamine") ||
		StrStrI(username, L"www.emuleech.com") ||
		StrStr(username, L"UnKnOwN pOiSoN") ||
		StrStrI(username, L"EGOmule") ||
		StrStrI(username, L"-=EGOist=-") ||
		StrStrI(username, L"Muli_Checka") ||
		StrStrI(username, L"00de.de") || 
		StrCmpI(username, L"Muse") == 0 || //ketamine mod
		StrStrI(username, L"futurezone-reloaded") ||
		StrStrI(username, L"Gate-To-Darkness.com") ||
		StrStrI(username, L"www.emule.razorback3.com") ||
		StrStrI(username, L"www.Titanesel.tk") ||
		StrStrI(username, L"www.bigbang.to") ||
		StrStrI(username, L"leecherclients.org") ||  //Xman 10/06
		StrStrI(username, L"futuremods.de") ||  //Xman 10/06
		StrStrI(username, L"futuremod.de") || // JvA: apple-com adress
		StrStrI(username, L".::Stenoco-Zone::.") ||
		StrStrI(username, L"emule-mods.cc") || //Xman 01/07
		StrStrI(username, L"www.leecher-mod.net") || //Xman 02/07
		//08/2007 from dlarge:
		StrStrI(username, L"www.leecher-world.com") || //added dlarge
		StrStrI(username, L"www.leecher.biz") || //added dlarge
		//end
		StrStrI(username, L"dianlei.com") || // WiZaRd: Chinese Leecher
		StrStrI(username, L"[eMuleBT]") || // WiZaRd: Chinese Leecher
		StrStrI(username, L"[PPMule]") || // WiZaRd: Chinese Leecher
		StrStrI(username, L"[TUOTU]") || // WiZaRd: Chinese Leecher
		StrStrI(username, L"kaggo.com") || // WiZaRd: Chinese Leecher
		StrStrI(username, L"[Chinfo]") || // WiZaRd: Chinese Leecher
		StrStrI(username, L"vgo.21cn") || // WiZaRd: Chinese Leecher
		StrStrI(username, L"@ Raptor") ||     //added dlarge
		StrStrI(username, L"FUCKLW") ||         //added dlarge
		//Xman 6/2007:
		// changed by WiZaRd to detect more apple-com mods
		( StrStrI(username, L"[") && StrStrI(username, L"]")
		&& (
			StrStrI(username, L"Applejuice") ||
			StrStrI(username, L"Wikinger") ||
			StrStrI(username, L"ROCKFORCE") ||
			StrStrI(username, L"RC-ATLANTIS") ||
			StrStrI(username, L"Fireball") ||
			StrStrI(username, L"SunPower")
			)
		) ||
		StrStrI(username, L"[LSD.19")	//Xman 21.06.2005 definitive not a good mod, with protocol bugs
		)
		return L"Bad USERNAME";


	//new ketamine
	if(_tcslen(username) >= 14){
		LPCTSTR tempstr = StrStr(username, L"[ePlus]");
		if(tempstr && _tcslen(tempstr) >= 7 && StrStr(tempstr + 7, L"[ePlus]"))
			return L"New Ketamine";
	}

	return NULL;
}

LPCTSTR __declspec(dllexport) DLPCheckUsername_Soft(LPCTSTR username)
{
	if(username == NULL)
		return NULL;

	if (StrStrI(username, L">>Power-Mod"))
		return L"Bad Username";

	//bad mods, where every second sign is
	//enough to check two places

	if(_tcslen(username) >= 4 && username[3] <= 0x1F && username[1] <= 0x1F)
		return L"Community-Username"; //community (based on LSD or it's smasher)

	if(_tcslen(username) >= 4 && username[0] == L'v' && StrStr(username, L":com "))
		return L"X-Treme";

	return NULL;
}

LPCTSTR __declspec(dllexport) DLPCheckNameAndHashAndMod(CString username, CString& userhash, CString& modversion)
{
	if(username.IsEmpty() || userhash.IsEmpty())
		return NULL;

	//Check for aedit
	//remark: a unmodded emule can't send a space at last sign
	if(modversion.IsEmpty() && username.Right(1) == 32)
		return L"AEdit";

	//Check for Hex-Modstring
	if(IsTypicalHex(modversion))
		return L"Hex-Modstring";

	//community check
	if(username.GetLength() >= 7 && username.Right(1) == L"]"){
		//check for special nickaddon
		int find = username.ReverseFind(L'[');
		if(find >= 0){
			CString addon = username.Mid(find+1);
			int endpos = addon.GetLength()-1;
			if(addon.GetLength() > 2 && IsTypicalHex(addon.Left(addon.GetLength()-1))) //Check for Hex (e.g. X-Treme)
				return L"Hex-Code-Addon";
		}
	}

	//thx cyrex
	if(modversion.GetLength() == 10 && username.GetLength() > 4 && StrStr(username.Right(4), L"/]") && StrStr(username, L"[SE]"))
		return L"Mystery ModString";

	return NULL;
}

LPCTSTR __declspec(dllexport) DLPCheckHelloTag(UINT tagnumber)
{
	LPCTSTR strSnafuTag = NULL;
	switch(tagnumber)
	{
		case CT_UNKNOWNx12:
		case CT_UNKNOWNx13:
		case CT_UNKNOWNx14:
		case CT_UNKNOWNx16:
		case CT_UNKNOWNx17:
		case CT_UNKNOWNxE6:			strSnafuTag = apszSnafuTag[0]; break;//buffer=_T("DodgeBoards");break;
		case CT_UNKNOWNx15:			strSnafuTag = apszSnafuTag[1]; break;//buffer=_T("DodgeBoards & DarkMule |eVorte|X|");break;
		case CT_UNKNOWNx22:			strSnafuTag = apszSnafuTag[2]; break;//buffer=_T("DarkMule v6 |eVorte|X|");break;
		case CT_UNKNOWNx5D:
		case CT_UNKNOWNx6B:
		case CT_UNKNOWNx6C:			strSnafuTag = apszSnafuTag[17]; break;
		case CT_UNKNOWNx74:
		case CT_UNKNOWNx87:			strSnafuTag = apszSnafuTag[17]; break;
		case CT_UNKNOWNxF0:
		case CT_UNKNOWNxF4:			strSnafuTag = apszSnafuTag[17]; break;
		case CT_UNKNOWNx79:			strSnafuTag = apszSnafuTag[4]; break;//buffer=_T("Bionic");break;
		case CT_UNKNOWNx83:			strSnafuTag = apszSnafuTag[15]; break;//buffer=_T("Fusspi");break;
		case CT_UNKNOWNx76:
		case CT_UNKNOWNxCD:			strSnafuTag = apszSnafuTag[16]; break;//buffer=_T("www.donkey2002.to");break;
		case CT_UNKNOWNx88:			strSnafuTag = apszSnafuTag[5]; break;//[LSD7c]
		case CT_UNKNOWNx8c:			strSnafuTag = apszSnafuTag[5]; break;//buffer=_T("[LSD7c]");break; 
		case CT_UNKNOWNx8d:			strSnafuTag = apszSnafuTag[6]; break;//buffer=_T("[0x8d] unknown Leecher - (client version:60)");break;
		case CT_UNKNOWNx99:			strSnafuTag = apszSnafuTag[7]; break;//buffer=_T("[RAMMSTEIN]");break;		//STRIKE BACK
		case CT_UNKNOWNx97:
		case CT_UNKNOWNx98:
		case CT_UNKNOWNx9C:
		case CT_UNKNOWNxDA:			strSnafuTag = apszSnafuTag[3]; break;//buffer=_T("eMuleReactor");break;
		case CT_UNKNOWNxC8:			//Xman x4
		case CT_UNKNOWNxCE:			//Xman 20.08.05
		case CT_UNKNOWNxCF:			//Xman 20.08.05
		case CT_UNKNOWNx94:			//Xman 20.08.05
		case CT_UNKNOWNxc4:			strSnafuTag = apszSnafuTag[8]; break;//buffer=_T("[MD5 Community]");break;	//USED BY NEW BIONIC => 0x12 Sender
		case CT_UNKNOWNxEC:			strSnafuTag = apszSnafuTag[18]; break; //Xman x4 Speedmule
		case CT_DARK:				//STRIKE BACK
		case CT_UNKNOWNx7A:
		case CT_UNKNOWNxCA:			strSnafuTag = apszSnafuTag[9]; break;//buffer=_T("new DarkMule");
		case CT_UNKNOWNx4D:			strSnafuTag = apszSnafuTag[19]; break;// pimp my mule misuse an official tag in hello
		case CT_UNKNOWNxd2:			strSnafuTag = apszSnafuTag[20]; break;// Xunei/Thunder
	}

	return strSnafuTag;
}

LPCTSTR __declspec(dllexport) DLPCheckInfoTag(UINT tagnumber)
{
	LPCTSTR strSnafuTag = NULL;
	switch(tagnumber)
	{
		case ET_MOD_UNKNOWNx12:
		case ET_MOD_UNKNOWNx13:
		case ET_MOD_UNKNOWNx14:
		case ET_MOD_UNKNOWNx17:		strSnafuTag = apszSnafuTag[0]; break;//("[DodgeBoards]")
		case ET_MOD_UNKNOWNx2F:		strSnafuTag = apszSnafuTag[10]; break;//buffer=_T("[OMEGA v.07 Heiko]");break;
		case ET_MOD_UNKNOWNx36:
		case ET_MOD_UNKNOWNx5B:
		case ET_MOD_UNKNOWNxA6:		strSnafuTag = apszSnafuTag[11]; break;//buffer=_T("eMule v0.26 Leecher");break;
		case ET_MOD_UNKNOWNx60:		strSnafuTag = apszSnafuTag[12]; break;//buffer=_T("[Hunter]");break; //STRIKE BACK
		case ET_MOD_UNKNOWNx76:		strSnafuTag = apszSnafuTag[0]; break;//buffer=_T("[DodgeBoards]");break;
		case ET_MOD_UNKNOWNx50:
		case ET_MOD_UNKNOWNxB1:
		case ET_MOD_UNKNOWNxB4:
		case ET_MOD_UNKNOWNxC8:
		case ET_MOD_UNKNOWNxC9:		strSnafuTag = apszSnafuTag[13]; break;//buffer=_T("[Bionic 0.20 Beta]");break;
		case ET_MOD_UNKNOWNxDA:		strSnafuTag = apszSnafuTag[14]; break;//buffer=_T("[Rumata (rus)(Plus v1f)]");break;
	}

	return strSnafuTag;
}
