//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PPg_X_Share.h"
#include "opcodes.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "Log.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPg_X_Share, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPg_X_Share, CPropertyPage)
	ON_BN_CLICKED(IDC_PRF_SHARE_TWEAKS_QPF_CHK, OnSettingsChange) // X-Ray :: QPFPush
	ON_BN_CLICKED(IDC_PRF_SHARE_TWEAKS_SUQWT_CHK, OnBnClickedSUQWT) // X-Ray :: SUQWT
	ON_BN_CLICKED(IDC_PRF_SHARE_TWEAKS_INFQUEUE_CHK, OnSettingsChange) // X-Ray :: InfiniteQueue
	// X-Ray :: ReleaseBonus :: Start
	ON_BN_CLICKED(IDC_PRF_SHARE_RELBONUS_CHK, OnBnClickedReleaseBonus)
	ON_BN_CLICKED(IDC_PRF_SHARE_RELBONUS_6H, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_SHARE_RELBONUS_12H, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_SHARE_RELBONUS_1D, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_SHARE_RELBONUS_2D, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_SHARE_RELBONUS_4D, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_SHARE_RELBONUS_8D, OnSettingsChange)
	// X-Ray :: ReleaseBonus :: End
	// X-Ray :: PaybackFirst :: Start
	ON_BN_CLICKED(IDC_PRF_SHARE_PBF_SUI_CHK, OnBnClickedPBFSUI)
	ON_BN_CLICKED(IDC_PRF_SHARE_PBF_NONSUI_CHK, OnBnClickedPBFNonSUI)
	ON_EN_CHANGE(IDC_PRF_SHARE_PBF_SUI_VALUE, OnSettingsChange)
	ON_EN_CHANGE(IDC_PBF_SHARE_PBF_NONSUI_VALUE, OnSettingsChange)
	// X-Ray :: PaybackFirst :: End
	// X-Ray :: Powershare :: Start
	ON_BN_CLICKED(IDC_PRF_SHARE_PS_CHK, OnBnClickedPS)
	ON_BN_CLICKED(IDC_PRF_SHARE_PS_ON_RADIO, OnBnClickedPSRadio)
	ON_BN_CLICKED(IDC_PRF_SHARE_PS_AUTO_RADIO, OnBnClickedPSRadio)
	ON_BN_CLICKED(IDC_PRF_SHARE_PS_LIM_RADIO, OnBnClickedPSRadio)
	ON_EN_CHANGE(IDC_PRF_SHARE_PS_LIM_SRC_VALUE, OnSettingsChange)
	// X-Ray :: Powershare :: End
END_MESSAGE_MAP()

CPPg_X_Share::CPPg_X_Share()
	: CPropertyPage(CPPg_X_Share::IDD)
{
}

CPPg_X_Share::~CPPg_X_Share()
{
}

void CPPg_X_Share::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BOOL CPPg_X_Share::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	// X-Ray :: PaybackFirst :: Start
	((CEdit*)GetDlgItem(IDC_PRF_SHARE_PBF_SUI_VALUE))->SetLimitText(3);
	((CEdit*)GetDlgItem(IDC_PBF_SHARE_PBF_NONSUI_VALUE))->SetLimitText(4);
	// X-Ray :: PaybackFirst :: End

	((CEdit*)GetDlgItem(IDC_PRF_SHARE_PS_LIM_SRC_VALUE))->SetLimitText(3); // X-Ray :: Powershare

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPg_X_Share::OnApply()
{
	thePrefs.SetIsQPFpushEnabled(IsDlgButtonChecked(IDC_PRF_SHARE_TWEAKS_QPF_CHK) ? true : false); // X-Ray :: QPFPush
	thePrefs.SetSaveUploadQueueWaitTime(IsDlgButtonChecked(IDC_PRF_SHARE_TWEAKS_SUQWT_CHK) ? true : false); // X-Ray :: SUQWT
	thePrefs.SetIsInfiniteQueueEnabled(IsDlgButtonChecked(IDC_PRF_SHARE_TWEAKS_INFQUEUE_CHK) ? true : false); // X-Ray :: InfiniteQueue

	// X-Ray :: ReleaseBonus :: Start
	if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_CHK)){
		thePrefs.SetUseReleaseBonus(true);
		if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_8D))
			thePrefs.SetReleaseBonus(32);
		else if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_4D))
			thePrefs.SetReleaseBonus(16);
		else if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_2D))
			thePrefs.SetReleaseBonus(8);
		else if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_1D))
			thePrefs.SetReleaseBonus(4);
		else if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_12H))
			thePrefs.SetReleaseBonus(2);
		else if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_6H))
			thePrefs.SetReleaseBonus(1);
		else
			thePrefs.SetReleaseBonus(0);
	} else {
		thePrefs.SetUseReleaseBonus(false);
		thePrefs.SetReleaseBonus(0);
	}
	// X-Ray :: ReleaseBonus :: End

	// X-Ray :: PaybackFirst :: Start
	if(IsDlgButtonChecked(IDC_PRF_SHARE_PBF_SUI_CHK)){
		thePrefs.SetPayBackFirst(true);
		CString strBuffer;
		uint8 iBuffer = thePrefs.GetPayBackFirstLimit();
		((CEdit*)GetDlgItem(IDC_PRF_SHARE_PBF_SUI_VALUE))->GetWindowText(strBuffer);
		if (_tstoi(strBuffer) >= VAL_PBF_SUI_MIN && _tstoi(strBuffer) <= VAL_PBF_SUI_MAX)
			iBuffer = (uint8)_tstoi(strBuffer);
		thePrefs.SetPayBackFirstLimit(iBuffer);
	} else
		thePrefs.SetPayBackFirst(false);

	if(IsDlgButtonChecked(IDC_PRF_SHARE_PBF_NONSUI_CHK)){
		thePrefs.SetPayBackFirst2(true);
		CString strBuffer;
		uint16 iBuffer = thePrefs.GetPayBackFirstLimit2();
		((CEdit*)GetDlgItem(IDC_PBF_SHARE_PBF_NONSUI_VALUE))->GetWindowText(strBuffer);
		if (_tstoi(strBuffer) >= VAL_PBF_NONSUI_MIN && _tstoi(strBuffer) <= VAL_PBF_NONSUI_MAX)
			iBuffer = (uint16)_tstoi(strBuffer);
		thePrefs.SetPayBackFirstLimit2(iBuffer);
	} else
		thePrefs.SetPayBackFirst2(false);
	// X-Ray :: PaybackFirst :: End

	// X-Ray :: Powershare :: Start
	uint8 iPSMode = 0;
	if(IsDlgButtonChecked(IDC_PRF_SHARE_PS_CHK)){
		if(IsDlgButtonChecked(IDC_PRF_SHARE_PS_ON_RADIO))
			iPSMode = 1;
		else if(IsDlgButtonChecked(IDC_PRF_SHARE_PS_AUTO_RADIO))
			iPSMode = 2;
		else {
			iPSMode = 3;

			CString strBuffer;
			uint8 iBuffer = thePrefs.GetPowerShareLimit();
			((CEdit*)GetDlgItem(IDC_PRF_SHARE_PS_LIM_SRC_VALUE))->GetWindowText(strBuffer);
			if (_tstoi(strBuffer) >= VAL_PS_LIMIT_MIN && _tstoi(strBuffer) <= VAL_PS_LIMIT_MAX)
				iBuffer = (uint8)_tstoi(strBuffer);
			thePrefs.SetPowerShareLimit(iBuffer);
		}
	}
	thePrefs.SetPowerShareMode(iPSMode);
	// X-Ray :: Powershare :: End

	LoadSettings();
	return TRUE;
}

void CPPg_X_Share::LoadSettings()
{
	CheckDlgButton(IDC_PRF_SHARE_TWEAKS_QPF_CHK, thePrefs.IsQPFpushEnabled()); // X-Ray :: QPFPush
	CheckDlgButton(IDC_PRF_SHARE_TWEAKS_SUQWT_CHK, thePrefs.SaveUploadQueueWaitTime()); // X-Ray :: SUQWT
	CheckDlgButton(IDC_PRF_SHARE_TWEAKS_INFQUEUE_CHK, thePrefs.IsInfiniteQueueEnabled()); // X-Ray :: InfiniteQueue

	// X-Ray :: ReleaseBonus :: Start
	const bool bRelBonus = thePrefs.GetUseReleaseBonus() && thePrefs.SaveUploadQueueWaitTime();
	switch(thePrefs.GetReleaseBonus()){
		case 1:
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, bRelBonus);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_6H, bRelBonus);
			break;
		case 2:
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, bRelBonus);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_12H, bRelBonus);
			break;
		case 4:
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, bRelBonus);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_1D, bRelBonus);
			break;
		case 8:
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, bRelBonus);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_2D, bRelBonus);
			break;
		case 16:
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, bRelBonus);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_4D, bRelBonus);
			break;
		case 32:
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, bRelBonus);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_8D, bRelBonus);
			break;
		default:
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, bRelBonus);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_6H, bRelBonus);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_12H, bRelBonus);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_1D, bRelBonus);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_2D, bRelBonus);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_4D, bRelBonus);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_8D, bRelBonus);
			break;
	}

	GetDlgItem(IDC_PRF_SHARE_RELBONUS_6H)->EnableWindow(bRelBonus);
	GetDlgItem(IDC_PRF_SHARE_RELBONUS_12H)->EnableWindow(bRelBonus);
	GetDlgItem(IDC_PRF_SHARE_RELBONUS_1D)->EnableWindow(bRelBonus);
	GetDlgItem(IDC_PRF_SHARE_RELBONUS_2D)->EnableWindow(bRelBonus);
	GetDlgItem(IDC_PRF_SHARE_RELBONUS_4D)->EnableWindow(bRelBonus);
	GetDlgItem(IDC_PRF_SHARE_RELBONUS_8D)->EnableWindow(bRelBonus);
	// X-Ray :: ReleaseBonus :: End

	// X-Ray :: PaybackFirst :: Start
	CString strBuffer;
	if(thePrefs.IsPayBackFirst()){
		CheckDlgButton(IDC_PRF_SHARE_PBF_SUI_CHK, true);
		GetDlgItem(IDC_PRF_SHARE_PBF_SUI_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_PBF_SUI_VALUE)->EnableWindow(true);
	} else {
		CheckDlgButton(IDC_PRF_SHARE_PBF_SUI_CHK, false);
		GetDlgItem(IDC_PRF_SHARE_PBF_SUI_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_PBF_SUI_VALUE)->EnableWindow(false);
	}
	strBuffer.Format(_T("%d"), thePrefs.GetPayBackFirstLimit());
	((CEdit*)GetDlgItem(IDC_PRF_SHARE_PBF_SUI_VALUE))->SetWindowText(strBuffer);

	if(thePrefs.IsPayBackFirst2()){
		CheckDlgButton(IDC_PRF_SHARE_PBF_NONSUI_CHK, true);
		GetDlgItem(IDC_PRF_SHARE_PBF_NONSUI_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PBF_SHARE_PBF_NONSUI_VALUE)->EnableWindow(true);
	} else {
		CheckDlgButton(IDC_PRF_SHARE_PBF_NONSUI_CHK, false);
		GetDlgItem(IDC_PRF_SHARE_PBF_NONSUI_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PBF_SHARE_PBF_NONSUI_VALUE)->EnableWindow(false);
	}
	strBuffer.Format(_T("%d"), thePrefs.GetPayBackFirstLimit2());
	((CEdit*)GetDlgItem(IDC_PBF_SHARE_PBF_NONSUI_VALUE))->SetWindowText(strBuffer);
	// X-Ray :: PaybackFirst :: End

	// X-Ray :: Powershare :: Start
	const bool bPowerShare = thePrefs.GetPowerShareMode() > 0;
	const bool bPowerShareLimited = thePrefs.GetPowerShareMode() == 3;
	switch(thePrefs.GetPowerShareMode()){
		case 1:
			CheckDlgButton(IDC_PRF_SHARE_PS_CHK, bPowerShare);
			CheckDlgButton(IDC_PRF_SHARE_PS_ON_RADIO, bPowerShare);
			break;
		case 2:
			CheckDlgButton(IDC_PRF_SHARE_PS_CHK, bPowerShare);
			CheckDlgButton(IDC_PRF_SHARE_PS_AUTO_RADIO, bPowerShare);
			break;
		case 3:
			CheckDlgButton(IDC_PRF_SHARE_PS_CHK, bPowerShare);
			CheckDlgButton(IDC_PRF_SHARE_PS_LIM_RADIO, bPowerShare);
			break;
		default:
			CheckDlgButton(IDC_PRF_SHARE_PS_CHK, bPowerShare);
			CheckDlgButton(IDC_PRF_SHARE_PS_ON_RADIO, bPowerShare);
			CheckDlgButton(IDC_PRF_SHARE_PS_AUTO_RADIO, bPowerShare);
			CheckDlgButton(IDC_PRF_SHARE_PS_LIM_RADIO, bPowerShare);
			break;
	}
	strBuffer.Format(_T("%d"), thePrefs.GetPowerShareLimit());
	((CEdit*)GetDlgItem(IDC_PRF_SHARE_PS_LIM_SRC_VALUE))->SetWindowText(strBuffer);

	GetDlgItem(IDC_PRF_SHARE_PS_ON_RADIO)->EnableWindow(bPowerShare);
	GetDlgItem(IDC_PRF_SHARE_PS_AUTO_RADIO)->EnableWindow(bPowerShare);
	GetDlgItem(IDC_PRF_SHARE_PS_LIM_RADIO)->EnableWindow(bPowerShare);
	GetDlgItem(IDC_PRF_SHARE_PS_LIM_SRC_LBL)->EnableWindow(bPowerShareLimited);
	GetDlgItem(IDC_PRF_SHARE_PS_LIM_SRC_VALUE)->EnableWindow(bPowerShareLimited);
	// X-Ray :: Powershare :: End
}

void CPPg_X_Share::Localize()
{
	if (m_hWnd)
	{
		GetDlgItem(IDC_PRF_SHARE_TWEAKS_GRP)->SetWindowText(GetResString(IDS_PRF_SHARE_TWEAKS_GRP));
		GetDlgItem(IDC_PRF_SHARE_TWEAKS_QPF_CHK)->SetWindowText(GetResString(IDS_PRF_SHARE_TWEAKS_QPF_CHK)); // X-Ray :: QPFPush
		GetDlgItem(IDC_PRF_SHARE_TWEAKS_SUQWT_CHK)->SetWindowText(GetResString(IDS_PRF_SHARE_TWEAKS_SUQWT_CHK)); // X-Ray :: SUQWT
		GetDlgItem(IDC_PRF_SHARE_TWEAKS_INFQUEUE_CHK)->SetWindowText(GetResString(IDS_PRF_SHARE_TWEAKS_INFQUEUE_CHK)); // X-Ray :: InfiniteQueue

		// X-Ray :: ReleaseBonus :: Start
		GetDlgItem(IDC_PRF_SHARE_RELEASEBONUS_GRP)->SetWindowText(GetResString(IDS_PRF_SHARE_RELEASEBONUS_GRP));
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_CHK)->SetWindowText(GetResString(IDS_PRF_SHARE_RELBONUS_CHK));
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_6H)->SetWindowText(GetResString(IDS_PRF_SHARE_RELBONUS_6H));
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_12H)->SetWindowText(GetResString(IDS_PRF_SHARE_RELBONUS_12H));
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_1D)->SetWindowText(GetResString(IDS_PRF_SHARE_RELBONUS_1D));
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_2D)->SetWindowText(GetResString(IDS_PRF_SHARE_RELBONUS_2D));
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_4D)->SetWindowText(GetResString(IDS_PRF_SHARE_RELBONUS_4D));
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_8D)->SetWindowText(GetResString(IDS_PRF_SHARE_RELBONUS_8D));
		// X-Ray :: ReleaseBonus :: End

		// X-Ray :: PaybackFirst :: Start
		GetDlgItem(IDC_PRF_SHARE_PBF_GRP)->SetWindowText(GetResString(IDS_PRF_SHARE_PBF_GRP));
		GetDlgItem(IDC_PRF_SHARE_PBF_SUI_CHK)->SetWindowText(GetResString(IDS_PRF_SHARE_PBF_SUI_CHK));
		GetDlgItem(IDC_PRF_SHARE_PBF_SUI_LBL)->SetWindowText(GetResString(IDS_PRF_SHARE_PBF_LBL));
		GetDlgItem(IDC_PRF_SHARE_PBF_NONSUI_CHK)->SetWindowText(GetResString(IDS_PRF_SHARE_PBF_NONSUI_CHK));
		GetDlgItem(IDC_PRF_SHARE_PBF_NONSUI_LBL)->SetWindowText(GetResString(IDS_PRF_SHARE_PBF_LBL));
		// X-Ray :: PaybackFirst :: End

		// X-Ray :: Powershare :: Start
		GetDlgItem(IDC_PRF_SHARE_PS_GRP)->SetWindowText(GetResString(IDS_POWERSHARE));
		GetDlgItem(IDC_PRF_SHARE_PS_CHK)->SetWindowText(GetResString(IDS_PRF_SHARE_PS_CHK));
		GetDlgItem(IDC_PRF_SHARE_PS_ON_RADIO)->SetWindowText(GetResString(IDS_POWERSHARE_ACTIVATED_LABEL));
		GetDlgItem(IDC_PRF_SHARE_PS_AUTO_RADIO)->SetWindowText(GetResString(IDS_POWERSHARE_AUTO_LABEL));
		GetDlgItem(IDC_PRF_SHARE_PS_LIM_RADIO)->SetWindowText(GetResString(IDS_POWERSHARE_LIMITED));
		GetDlgItem(IDC_PRF_SHARE_PS_LIM_SRC_LBL)->SetWindowText(GetResString(IDS_POWERSHARE_LIMIT) + _T(":"));
		// X-Ray :: Powershare :: End
	}
}

// X-Ray :: ReleaseBonus :: Start
void CPPg_X_Share::OnBnClickedReleaseBonus()
{
	if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_CHK)) {
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_6H)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_12H)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_1D)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_2D)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_4D)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_8D)->EnableWindow(true);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_6H, true);
	} else {
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_6H, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_12H, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_1D, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_2D, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_4D, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_8D, false);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_6H)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_12H)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_1D)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_2D)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_4D)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_8D)->EnableWindow(false);
	}
	SetModified();
}
// X-Ray :: ReleaseBonus :: End

// X-Ray :: SUQWT :: Start
void CPPg_X_Share::OnBnClickedSUQWT()
{
	if(IsDlgButtonChecked(IDC_PRF_SHARE_TWEAKS_SUQWT_CHK)){
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_CHK)->EnableWindow(true);
		SetModified();
	} else {
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, false);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_CHK)->EnableWindow(false);
		OnBnClickedReleaseBonus();
	}
}
// X-Ray :: SUQWT :: End

// X-Ray :: PaybackFirst :: Start
void CPPg_X_Share::OnBnClickedPBFSUI()
{
	if(IsDlgButtonChecked(IDC_PRF_SHARE_PBF_SUI_CHK)){
		GetDlgItem(IDC_PRF_SHARE_PBF_SUI_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_PBF_SUI_VALUE)->EnableWindow(true);
	} else {
		GetDlgItem(IDC_PRF_SHARE_PBF_SUI_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_PBF_SUI_VALUE)->EnableWindow(false);
	}
	SetModified();
}

void CPPg_X_Share::OnBnClickedPBFNonSUI()
{
	if(IsDlgButtonChecked(IDC_PRF_SHARE_PBF_NONSUI_CHK)){
		GetDlgItem(IDC_PRF_SHARE_PBF_NONSUI_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PBF_SHARE_PBF_NONSUI_VALUE)->EnableWindow(true);
	} else {
		GetDlgItem(IDC_PRF_SHARE_PBF_NONSUI_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PBF_SHARE_PBF_NONSUI_VALUE)->EnableWindow(false);
	}
	SetModified();
}
// X-Ray :: PaybackFirst :: End

// X-Ray :: Powershare :: Start
void CPPg_X_Share::OnBnClickedPS()
{
	if(IsDlgButtonChecked(IDC_PRF_SHARE_PS_CHK)){
		GetDlgItem(IDC_PRF_SHARE_PS_ON_RADIO)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_PS_AUTO_RADIO)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_PS_LIM_RADIO)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_PS_LIM_SRC_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_PS_LIM_SRC_VALUE)->EnableWindow(false);
		CheckDlgButton(IDC_PRF_SHARE_PS_ON_RADIO, true);
		SetModified();
	} else {
		CheckDlgButton(IDC_PRF_SHARE_PS_ON_RADIO, false);
		CheckDlgButton(IDC_PRF_SHARE_PS_AUTO_RADIO, false);
		CheckDlgButton(IDC_PRF_SHARE_PS_LIM_RADIO, false);
		GetDlgItem(IDC_PRF_SHARE_PS_ON_RADIO)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_PS_AUTO_RADIO)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_PS_LIM_RADIO)->EnableWindow(false);
		OnBnClickedPSRadio();
	}
}

void CPPg_X_Share::OnBnClickedPSRadio()
{
	if(IsDlgButtonChecked(IDC_PRF_SHARE_PS_LIM_RADIO)){
		GetDlgItem(IDC_PRF_SHARE_PS_LIM_SRC_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_PS_LIM_SRC_VALUE)->EnableWindow(true);
	} else {
		GetDlgItem(IDC_PRF_SHARE_PS_LIM_SRC_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_PS_LIM_SRC_VALUE)->EnableWindow(false);
	}
	SetModified();
}
// X-Ray :: Powershare :: End