//this file is part of eMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h" 
#include "emule.h"
#include "ArgosInfo.h"
#include "OtherFunctions.h"
#include "ClientList.h"
#include "DownloadQueue.h"
#include "UpDownClient.h"
#include "PartFile.h"
#include "UserMsgs.h"
#include "SharedFileList.h"
#include "ClientCredits.h"
#include "Preferences.h"
#include "Addons/Argos/Argos.h"
#include "Addons/functions.h"
#include "Addons/defaults.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

///////////////////////////////////////////////////////////////////////////////
// CClientArgosInfoPage

IMPLEMENT_DYNAMIC(CClientArgosInfoPage, CResizablePage)

BEGIN_MESSAGE_MAP(CClientArgosInfoPage, CResizablePage)
	ON_MESSAGE(UM_DATA_CHANGED, OnDataChanged)
END_MESSAGE_MAP()

CClientArgosInfoPage::CClientArgosInfoPage()
	: CResizablePage(CClientArgosInfoPage::IDD,0)
{
	m_paClients = NULL;
	m_bDataChanged = false;
	m_strCaption = GetResString(IDS_ARGOS);
	m_psp.pszTitle = m_strCaption;
	m_psp.dwFlags |= PSP_USETITLE;
}

CClientArgosInfoPage::~CClientArgosInfoPage()
{
}

void CClientArgosInfoPage::DoDataExchange(CDataExchange* pDX)
{
	CResizablePage::DoDataExchange(pDX);
}

BOOL CClientArgosInfoPage::OnInitDialog()
{
	CResizablePage::OnInitDialog();
	InitWindowStyles(this);

	AddAnchor(IDC_AI_DETECTION, TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_AI_SUMMARY, TOP_LEFT, TOP_RIGHT);

	Localize();
	return TRUE;
}

BOOL CClientArgosInfoPage::OnSetActive()
{
	if (!CResizablePage::OnSetActive())
		return FALSE;

	if (m_bDataChanged){
		CUpDownClient* client = STATIC_DOWNCAST(CUpDownClient, (*m_paClients)[0]);
		TArgosClient* aClient = theApp.argos->GetArgosClient(client->GetConnectIP());

		if(aClient == NULL){
			DisableDialog();
			return TRUE;
		}

		DisableDialog(false);

		CString strBuffer;

		GetDlgItem(IDC_AI_LMODCTRL)->SetWindowText(thePrefs.IsArgosLeecherModDetection() ? (aClient->m_bArgosIsLeecherMod ? client->GetClientModVer() : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_LNICKCTRL)->SetWindowText(thePrefs.IsArgosLeecherNickDetection() ? (aClient->m_bArgosIsLeecherNick ? (client->GetUserName() ? client->GetUserName() : GetResString(IDS_UNKNOWN)) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_OPCODECTRL)->SetWindowText(thePrefs.IsArgosOpcodeDetection() ? (aClient->m_bArgosIsLeecherOpCode ? StrLine(L"%ux%02X", aClient->m_bArgosIsLeecherOpCode, aClient->m_uLeecherOpCode) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_LHASHCTRL)->SetWindowText(thePrefs.IsArgosLeecherHashDetection() ? (aClient->m_bArgosIsLeecherHash ? md4str(client->GetUserHash()) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_NICKTHIEFCTRL)->SetWindowText(thePrefs.IsArgosNickThiefDetection() ? (aClient->m_bArgosIsNickThief ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_MODTHIEFCTRL)->SetWindowText(thePrefs.IsArgosModThiefDetection() ? (aClient->m_bArgosIsModThief ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));

		strBuffer.Empty();
		if(aClient->m_bArgosIsHashThief){
			strBuffer.AppendFormat(GetResString(IDS_YES));
			if(aClient->m_bArgosIsHashThief & 1)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_TRUST));
			if(aClient->m_bArgosIsHashThief & 2)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_SUI));
		}
		GetDlgItem(IDC_AI_HASHTHIEFCTRL)->SetWindowText(thePrefs.IsArgosHashThiefDetection() ? (strBuffer.IsEmpty() ? GetResString(IDS_NO) : strBuffer) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_CREDITHACKCTRL)->SetWindowText(thePrefs.IsArgosCreditHackDetection() ? (aClient->m_bArgosIsCreditHack ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));

		strBuffer.Empty();
		if(aClient->m_bArgosIsHashChanged){
			strBuffer.AppendFormat(GetResString(IDS_YES));
			if(aClient->m_bArgosIsHashChanged & 1)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_DIRECT));
			if(aClient->m_bArgosIsHashChanged & 2)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_TRACK_LIST));
		}
		GetDlgItem(IDC_AI_HASHCHANGECTRL)->SetWindowText(thePrefs.IsHashChangeDetection() ? (strBuffer.IsEmpty() ? GetResString(IDS_NO) : strBuffer) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_GHOSTMODCTRL)->SetWindowText(thePrefs.IsArgosGhostModDetection() ? (aClient->m_bArgosIsGhostMode ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));

		strBuffer.Empty();
		if(aClient->m_bArgosIsFakeClient){
			strBuffer.AppendFormat(GetResString(IDS_YES));
			if(aClient->m_bArgosIsFakeClient & 1)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_PROTOCOL));
			if(aClient->m_bArgosIsFakeClient & 2)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_SOFTWARE));
		}
		GetDlgItem(IDC_AI_FAKECLIENTCTRL)->SetWindowText(thePrefs.IsArgosFakeClientDetection() ? (strBuffer.IsEmpty() ? GetResString(IDS_NO) : strBuffer) : GetResString(IDS_UNKNOWN));

		strBuffer.Empty();
		if(aClient->m_bArgosIsAgressiv){
			strBuffer.AppendFormat(GetResString(IDS_YES));
			if(aClient->m_bArgosIsAgressiv & 1)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_FAST_TCP));
			if(aClient->m_bArgosIsAgressiv & 2)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_FAST_UDP));
		}
		GetDlgItem(IDC_AI_AGGRESSIVECTRL)->SetWindowText(thePrefs.IsAgressionDetection() ? (strBuffer.IsEmpty() ? GetResString(IDS_NO) : strBuffer) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_FILESCANNERCTRL)->SetWindowText(thePrefs.IsFileScannerDetection() ? (aClient->m_bArgosIsFileScanner ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_FILEFAKERCTRL)->SetWindowText(thePrefs.IsFileFakerDetection() ? (aClient->m_bArgosIsFileFaker ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_CORRUPTEDSENDERCTRL)->SetWindowText(thePrefs.IsBadSenderDetection() ? (aClient->m_bArgosIsCorruptedSender ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_RANKFLOODERCTRL)->SetWindowText(thePrefs.IsRankFloodDetection() ? (aClient->m_bArgosIsRankFlooder ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_FAILEDSOURCECTRL)->SetWindowText(thePrefs.IsFailedDetection() ? (aClient->m_bArgosIsFailed ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));

		strBuffer.Empty();
		if(aClient->m_bArgosIsSpam){
			strBuffer.AppendFormat(GetResString(IDS_YES));
			if(aClient->m_bArgosIsSpam & 1)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_MESSAGESPAM));
			if(aClient->m_bArgosIsSpam & 2)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_COMMENTSPAM));
		}
		GetDlgItem(IDC_AI_SPAMERCTRL)->SetWindowText(thePrefs.IsArgosSpamDetection() ? (strBuffer.IsEmpty() ? GetResString(IDS_NO) : strBuffer) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_NULLNICKCTRL)->SetWindowText(thePrefs.IsArgosNullNickDetection() ? (aClient->m_bArgosIsNullNick ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));

		strBuffer.Empty();
		if(aClient->m_bArgosIsXSExploit){
			strBuffer.AppendFormat(GetResString(IDS_YES));
			if(aClient->m_bArgosIsXSExploit & 1)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_ASK_FAST));
			if(aClient->m_bArgosIsXSExploit & 2)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_DONT_ANSWER));
		}
		GetDlgItem(IDC_AI_XSEXPLOITERCTRL)->SetWindowText(thePrefs.IsArgosXSExploitDetection() ? (strBuffer.IsEmpty() ? GetResString(IDS_NO) : strBuffer) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_NICKCHANGERCTRL)->SetWindowText(thePrefs.IsArgosNickChangerDetection() ? (aClient->m_bArgosIsNickChanger ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_MODCHANGERCTRL)->SetWindowText(thePrefs.IsArgosModChangerDetection() ? (aClient->m_bArgosIsModChanger ? GetResString(IDS_YES) : GetResString(IDS_NO)) : GetResString(IDS_UNKNOWN));

		strBuffer.Empty();
		if(aClient->m_bArgosIsBadHello){
			strBuffer.AppendFormat(GetResString(IDS_YES));
			if(aClient->m_bArgosIsBadHello & 1)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_EXTRA_BYTES));
			if(aClient->m_bArgosIsBadHello & 2)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_BAD_ORDER));
			if(aClient->m_bArgosIsBadHello & 4)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_BAD_TAG));
			if(aClient->m_bArgosIsBadHello & 8)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_BAD_PORT));
			if(aClient->m_bArgosIsBadHello & 16)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_EMCRYPT));
		}
		GetDlgItem(IDC_AI_SUSPECTHELLOCTRL)->SetWindowText(thePrefs.IsArgosBadHelloDetection() ? (strBuffer.IsEmpty() ? GetResString(IDS_NO) : strBuffer) : GetResString(IDS_UNKNOWN));

		strBuffer.Empty();
		if(aClient->m_bArgosIsBadProt){
			strBuffer.AppendFormat(GetResString(IDS_YES));
			if(aClient->m_bArgosIsBadProt & 1)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_BAD_HASH_SIZE));
			if(aClient->m_bArgosIsBadProt & 2)
				strBuffer.AppendFormat(L"; %s", GetResString(IDS_ARGOS_BAD_PACKET));
		}
		GetDlgItem(IDC_AI_SUSPECTPROTCTRL)->SetWindowText(thePrefs.IsArgosBadProtDetection() ? (strBuffer.IsEmpty() ? GetResString(IDS_NO) : strBuffer) : GetResString(IDS_UNKNOWN));
		GetDlgItem(IDC_AI_LASTSEENCTRL)->SetWindowText(CastSecondsToHM(MS2SEC(::GetTickCount() - aClient->m_uLastSeenTime)));
		GetDlgItem(IDC_AI_LASTDETECTIONCTRL)->SetWindowText(aClient->m_uLastDetectionTime ? (CastSecondsToHM(MS2SEC(::GetTickCount() - aClient->m_uLastDetectionTime))) : GetResString(IDS_ARGOS_NONE));
		GetDlgItem(IDC_AI_PUNISHMENTCTRL)->SetWindowText(aClient->m_uPunishment >= 100 ? GetResString(IDS_ARGOS_IP_BAN) : (aClient->m_uPunishment == 10 ? GetResString(IDS_ARGOS_UL_BAN) : (aClient->m_uPunishment == 0 ? GetResString(IDS_ARGOS_NO_BAN) : (StrLine(GetResString(IDS_ARGOS_SCORE), 10 - aClient->m_uPunishment)))));

		if(thePrefs.GetCreditCompensation())
			GetDlgItem(IDC_AI_COMPENSATIONCTRL)->SetWindowText(aClient->m_uPunishment == 0 ? GetResString(client->IsFriend() ? IDS_ARGOS_FRIEND : IDS_NO) : ((aClient->m_uPunishment == 10 && (thePrefs.GetCreditCompensation() < 10 || !theApp.argos->IsNullCompensation(client))) ? GetResString(IDS_ARGOS_UL_LOCK) : StrLine(_T("%.2f"),theApp.argos->GetCompensation(client))));

		GetDlgItem(IDC_AI_LEECHERTYPECTRL)->SetWindowText(aClient->m_eLeecherType == LT_NO ? GetResString(IDS_ARGOS_NONE) : theApp.argos->GetLeecherTypeStr((ELeecherType)aClient->m_eLeecherType));
		GetDlgItem(IDC_AI_COMMENTCTRL)->SetWindowText(aClient->Comment ? *aClient->Comment : GetResString(IDS_ARGOS_NONE));

		m_bDataChanged = false;
	}
	return TRUE;
}

LRESULT CClientArgosInfoPage::OnDataChanged(WPARAM, LPARAM)
{
	m_bDataChanged = true;
	return 1;
}

void CClientArgosInfoPage::Localize()
{
	GetDlgItem(IDC_AI_DETECTION)->SetWindowText(GetResString(IDS_ARGOS_DETECTION));
	GetDlgItem(IDC_AI_SUMMARY)->SetWindowText(GetResString(IDS_ARGOS_SUMMARY));
	GetDlgItem(IDC_AI_LMOD)->SetWindowText(GetResString(IDS_ARGOS_LEECHER_MOD));
	GetDlgItem(IDC_AI_LNICK)->SetWindowText(GetResString(IDS_ARGOS_LEECHER_NICK));
	GetDlgItem(IDC_AI_OPCODE)->SetWindowText(GetResString(IDS_ARGOS_LEECHER_OPCODE));
	GetDlgItem(IDC_AI_LHASH)->SetWindowText(GetResString(IDS_ARGOS_LEECHER_HASH));
	GetDlgItem(IDC_AI_NICKTHIEF)->SetWindowText(GetResString(IDS_ARGOS_NICKTHIEF));
	GetDlgItem(IDC_AI_MODTHIEF)->SetWindowText(GetResString(IDS_ARGOS_MODTHIEF));
	GetDlgItem(IDC_AI_HASHTHIEF)->SetWindowText(GetResString(IDS_ARGOS_HASHTHIEF));
	GetDlgItem(IDC_AI_CREDITHACK)->SetWindowText(GetResString(IDS_ARGOS_CREDITHACKSRC));
	GetDlgItem(IDC_AI_HASHCHANGE)->SetWindowText(GetResString(IDS_ARGOS_HASHCHANGE));
	GetDlgItem(IDC_AI_GHOSTMOD)->SetWindowText(GetResString(IDS_ARGOS_GHOSTMODSRC));
	GetDlgItem(IDC_AI_FAKECLIENT)->SetWindowText(GetResString(IDS_ARGOS_FAKE_CLIENTSRC));
	GetDlgItem(IDC_AI_AGGRESSIVE)->SetWindowText(GetResString(IDS_ARGOS_ASKAGGRESSIVE));
	GetDlgItem(IDC_AI_FILESCANNER)->SetWindowText(GetResString(IDS_ARGOS_FILE_SCANNER));
	GetDlgItem(IDC_AI_FILEFAKER)->SetWindowText(GetResString(IDS_ARGOS_FILE_FAKER));
	GetDlgItem(IDC_AI_CORRUPTEDSENDER)->SetWindowText(GetResString(IDS_ARGOS_BADSENDER));
	GetDlgItem(IDC_AI_RANKFLOODER)->SetWindowText(GetResString(IDS_ARGOS_RANK_FLOODER));
	GetDlgItem(IDC_AI_FAILEDSOURCE)->SetWindowText(GetResString(IDS_ARGOS_FAILEDSRC));
	GetDlgItem(IDC_AI_XSEXPLOITER)->SetWindowText(GetResString(IDS_ARGOS_XSEXPLOITSRC));
	GetDlgItem(IDC_AI_NULLNICK)->SetWindowText(GetResString(IDS_ARGOS_NULLNICKSRC));
	GetDlgItem(IDC_AI_SPAMER)->SetWindowText(GetResString(IDS_ARGOS_SPAM_SRC));
	GetDlgItem(IDC_AI_SUSPECTHELLO)->SetWindowText(GetResString(IDS_ARGOS_SUSPECTHELLOSRC));
	GetDlgItem(IDC_AI_SUSPECTPROT)->SetWindowText(GetResString(IDS_ARGOS_SUSPECTPROTSRC));
	GetDlgItem(IDC_AI_NICKCHANGER)->SetWindowText(GetResString(IDS_ARGOS_NICKCHANGERSRC));
	GetDlgItem(IDC_AI_MODCHANGER)->SetWindowText(GetResString(IDS_ARGOS_MODCHANGERSRC));
	GetDlgItem(IDC_AI_LASTSEEN)->SetWindowText(GetResString(IDS_ARGOS_LASTSEEN));
	GetDlgItem(IDC_AI_LASTDETECTION)->SetWindowText(GetResString(IDS_ARGOS_LASTDETECTION));
	GetDlgItem(IDC_AI_PUNISHMENT)->SetWindowText(GetResString(IDS_ARGOS_PUNISHMENT));
	GetDlgItem(IDC_AI_COMPENSATION)->SetWindowText(GetResString(IDS_ARGOS_COMPENSATION));
	GetDlgItem(IDC_AI_LEECHERTYPE)->SetWindowText(GetResString(IDS_ARGOS_LEECHERTYPE));
	GetDlgItem(IDC_AI_COMMENT)->SetWindowText(GetResString(IDS_ARGOS_COMMENT));
}

void CClientArgosInfoPage::DisableDialog(bool bDisable){
	GetDlgItem(IDC_AI_DETECTION)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_LNICK)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_LMOD)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_NICKTHIEF)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_OPCODE)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_HASHTHIEF)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_MODTHIEF)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_HASHCHANGE)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_CREDITHACK)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_FAKECLIENT)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_GHOSTMOD)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_FILESCANNER)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_AGGRESSIVE)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_RANKFLOODER)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_CORRUPTEDSENDER)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_SUMMARY)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_PUNISHMENT)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_LASTSEEN)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_LASTDETECTION)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_LEECHERTYPE)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_COMMENT)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_COMPENSATION)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_FAILEDSOURCE)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_NULLNICK)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_SPAMER)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_SUSPECTHELLO)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_LHASH)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_XSEXPLOITER)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_FILEFAKER)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_SUSPECTPROT)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_NICKCHANGER)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_MODCHANGER)->EnableWindow(!bDisable);

	GetDlgItem(IDC_AI_LNICKCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_LMODCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_NICKTHIEFCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_OPCODECTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_HASHTHIEFCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_MODTHIEFCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_HASHCHANGECTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_CREDITHACKCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_FAKECLIENTCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_GHOSTMODCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_FILESCANNERCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_AGGRESSIVECTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_RANKFLOODERCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_CORRUPTEDSENDERCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_PUNISHMENTCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_LASTSEENCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_LASTDETECTIONCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_LEECHERTYPECTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_COMMENTCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_COMPENSATIONCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_FAILEDSOURCECTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_NULLNICKCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_SPAMERCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_SUSPECTHELLOCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_LHASHCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_XSEXPLOITERCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_FILEFAKERCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_SUSPECTPROTCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_NICKCHANGERCTRL)->EnableWindow(!bDisable);
	GetDlgItem(IDC_AI_MODCHANGERCTRL)->EnableWindow(!bDisable);

	if(!bDisable)
		return;

	GetDlgItem(IDC_AI_LMODCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_LNICKCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_OPCODECTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_LHASHCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_NICKTHIEFCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_MODTHIEFCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_HASHTHIEFCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_CREDITHACKCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_HASHCHANGECTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_GHOSTMODCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_FAKECLIENTCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_AGGRESSIVECTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_FILESCANNERCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_FILEFAKERCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_CORRUPTEDSENDERCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_RANKFLOODERCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_FAILEDSOURCECTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_XSEXPLOITERCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_NICKCHANGERCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_MODCHANGERCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_NULLNICKCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_SPAMERCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_SUSPECTHELLOCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_SUSPECTPROTCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_LASTSEENCTRL)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_AI_LASTDETECTIONCTRL)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_AI_PUNISHMENTCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_COMPENSATIONCTRL)->SetWindowText(GetResString(IDS_NO));
	GetDlgItem(IDC_AI_LEECHERTYPECTRL)->SetWindowText(GetResString(IDS_UNKNOWN));
	GetDlgItem(IDC_AI_COMMENTCTRL)->SetWindowText(GetResString(IDS_ARGOS_NONE));
}