// X-Ray :: PrefSlider :: Start
//this file is part of eMule
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once

#include "otherfunctions.h"
#include "ListBoxST.h"
// X-Ray :: ModelessDialogs :: Start
/*
#include "TreePropSheet.h"
*/
#include "Addons/ModelessDialogs/Modeless.h"
// X-Ray :: ModelessDialogs :: End

#include "PPgGeneral.h"
#include "PPgConnection.h"
#include "PPgServer.h"
#include "PPgDirectories.h"
#include "PPgFiles.h"
#include "PPgStats.h"
#include "PPgNotify.h"
#include "PPgIRC.h"
#include "PPgTweaks.h"
#include "PPgDisplay.h"
#include "PPgSecurity.h"
#include "PPgWebServer.h"
#include "PPgScheduler.h"
#include "PPgProxy.h"
#include "PPgMessages.h"

#include "Addons/PrefSlider/SlideBar.h" // X-Ray :: PrefSlider
#include "Addons/PrefBanner/KCSideBannerWnd.h" // X-Ray :: PrefBanner

// X-Ray :: MOD-Prefs :: Start
#include "Addons/PPG/PPG_X_General.h"		// General
#include "Addons/PPG/PPG_X_GUI.h"			// GUI
#include "Addons/PPG/PPG_X_Connection.h"	// Connection
#include "Addons/PPG/PPG_X_Upload.h"		// Upload
#include "Addons/PPG/PPG_X_Download.h"		// Download
#include "Addons/PPG/PPG_X_Share.h"			// Share
#include "Addons/PPG/PPG_X_Argos.h"			// Argos
#include "Addons/PPG/PPg_X_Update.h"		// Update

#include "Addons/PPG/PPG_X_Drop.h"			// DropSystem
// X-Ray :: MOD-Prefs :: End


#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
#include "PPgDebug.h"
#endif


#define IDC_PREFS_SLIDEBAR	111	// X-Ray :: PrefSlider

enum EnumPreferencesListItems
{
	PW_PREFERENCES = 0,
	PW_DISPLAY,
	PW_CONNECTION,
	PW_SERVER,
	PW_SHAREDFILES,
	PW_FOLDERS,
	PW_PROXY,
	PW_NOTIFICATIONS,
	PW_STATISTICS,
	PW_IRC,
	PW_MESSAGES,
	PW_SECURITY,
	PW_SCHEDULER,
	PW_WEB,
	PW_TWEAK,
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	PW_EMPTY,
#endif
	// X-Ray :: MOD-Prefs
	PW_X_GENERAL,	// General
	PW_X_GUI,		// GUI
	PW_X_CON,		// Connection
	PW_X_UPLOAD,	// Upload
	PW_X_DOWNLOAD,	// Download
	PW_X_SHARE,		// Share
	PW_X_ARGOS,		// Argos
	PW_X_UPDATE,	// Update

	// Double pages must be on the very end of the list!!!
	PW_X_DROP		// DropSystem
	// X-Ray :: End
};

// X-Ray :: ModelessDialogs :: Start
/*
class CPreferencesDlg : public CPropertySheet
*/
class CPreferencesDlg : public CModPropertySheet
// X-Ray :: ModelessDialogs :: End
{
	DECLARE_DYNAMIC(CPreferencesDlg)

public:
	CPreferencesDlg();
	virtual ~CPreferencesDlg();
	
	CPPgGeneral			m_wndGeneral;
	CPPgConnection		m_wndConnection;
	CPPgServer			m_wndServer;
	CPPgDirectories		m_wndDirectories;
	CPPgFiles			m_wndFiles;
	CPPgStats			m_wndStats;
	CPPgNotify			m_wndNotify;
	CPPgIRC				m_wndIRC;
	CPPgTweaks			m_wndTweaks;
	CPPgDisplay			m_wndDisplay;
	CPPgSecurity		m_wndSecurity;
	CPPgWebServer		m_wndWebServer;
	CPPgScheduler		m_wndScheduler;
	CPPgProxy			m_wndProxy;
	CPPgMessages		m_wndMessages;
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	CPPgDebug			m_wndDebug;
#endif

	// X-Ray :: MOD-Prefs :: Start
	CPPg_X_General		m_wndX_General;		// General
	CPPg_X_GUI			m_wndX_Gui;			// GUI
	CPPg_X_Connection	m_wndX_Con;			// Connection
	CPPg_X_Upload		m_wndX_Upload;		// Upload
	CPPg_X_Download		m_wndX_Download;	// Download
	CPPg_X_Share		m_wndX_Share;		// Share
	CPPg_X_Argos		m_wndX_Argos;		// Argos
	CPPg_X_Update		m_wndX_Update;		// Update

	CPPg_X_Drop			m_wndX_Drop;		// DropSystem
	// X-Ray :: MOD-Prefs :: End

	CImageList		ImageList;
	CSlideBar	 	m_slideBar; // X-Ray :: PrefSlider

	void Localize();
	void SetStartPage(UINT uStartPageID)	{m_nActiveWnd = uStartPageID;}

	// X-Ray :: PPgPrefTabs :: Start
	void SwitchTab(int page);
	int GetStartPageDownload()	{return m_iStartPageDownload;}
	// X-Ray :: PPgPrefTabs :: End

protected:
	int m_nActiveWnd;
	int	m_iStartPageDownload; // X-Ray :: PPgPrefTabs
	bool m_bSaveIniFile;

	virtual BOOL OnInitDialog();
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
	
	afx_msg void OnDestroy();
	afx_msg LRESULT	OnSlideBarSelChanged(WPARAM wParam, LPARAM lParam); // X-Ray :: PrefSlider
	afx_msg void OnHelp();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);

	CKCSideBannerWnd m_banner; // X-Ray :: PrefBanner
};
// X-Ray :: PrefSlider :: End