//this file is part of eMule
//Copyright (C)2002-2008 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "DownloadListCtrl.h"
#include "otherfunctions.h" 
#include "updownclient.h"
#include "MenuCmds.h"
#include "ClientDetailDialog.h"
#include "FileDetailDialog.h"
#include "commentdialoglst.h"
#include "MetaDataDlg.h"
#include "InputBox.h"
#include "KademliaWnd.h"
#include "emuledlg.h"
#include "DownloadQueue.h"
#include "FriendList.h"
#include "PartFile.h"
#include "ClientCredits.h"
#include "MemDC.h"
#include "ChatWnd.h"
#include "TransferWnd.h"
#include "Kademlia/Kademlia/Kademlia.h"
#include "Kademlia/Kademlia/Prefs.h"
#include "Kademlia/net/KademliaUDPListener.h"
#include "WebServices.h"
#include "Preview.h"
#include "StringConversion.h"
#include "AddSourceDlg.h"
#include "ToolTipCtrlX.h"
#include "CollectionViewDialog.h"
#include "SearchDlg.h"
#include "SharedFileList.h"
#include "opcodes.h" // X-Ray :: QRETA
#include "Addons/Argos/Argos.h" // X-Ray :: Argos
#include "Addons/MassRename/MassRename.h" // X-Ray :: MassRename

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// CDownloadListCtrl

#define DLC_DT_TEXT (DT_LEFT|DT_SINGLELINE|DT_VCENTER|DT_NOPREFIX|DT_END_ELLIPSIS)
#define DLC_BARUPDATE 512

#define	FILE_ITEM_MARGIN_X	4
#define RATING_ICON_WIDTH	16


IMPLEMENT_DYNAMIC(CtrlItem_Struct, CObject)

IMPLEMENT_DYNAMIC(CDownloadListCtrl, CMuleListCtrl)

BEGIN_MESSAGE_MAP(CDownloadListCtrl, CMuleListCtrl)
	ON_WM_CONTEXTMENU()
	ON_WM_SYSCOLORCHANGE()
	ON_NOTIFY_REFLECT(LVN_ITEMACTIVATE, OnItemActivate)
	ON_NOTIFY_REFLECT(LVN_ITEMCHANGED, OnListModified)
	ON_NOTIFY_REFLECT(LVN_INSERTITEM, OnListModified)
	ON_NOTIFY_REFLECT(LVN_DELETEITEM, OnListModified)
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnClick)
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnNMDblclkDownloadlist)
	ON_NOTIFY_REFLECT(LVN_GETDISPINFO, OnGetDispInfo)
	ON_NOTIFY_REFLECT(LVN_GETINFOTIP, OnLvnGetInfoTip)
END_MESSAGE_MAP()

CDownloadListCtrl::CDownloadListCtrl()
	: CDownloadListListCtrlItemWalk(this)
{
	m_tooltip = new CToolTipCtrlX;
	SetGeneralPurposeFind(true, false);
}

CDownloadListCtrl::~CDownloadListCtrl()
{
	// X-Ray :: DropSystem :: Start
	if (m_DropMenu)
		VERIFY( m_DropMenu.DestroyMenu() );
	// X-Ray :: DropSystem :: End

	// X-Ray :: DLULPrioExtension :: Start
	if (m_PrioUpMenu)
		VERIFY( m_PrioUpMenu.DestroyMenu() );
	// X-Ray :: DLULPrioExtension :: End

	// X-Ray :: ManualClientManagement :: Start
	if (m_A4AFMenu)
		VERIFY( m_A4AFMenu.DestroyMenu() );
	// X-Ray :: ManualClientManagement :: End

	if (m_PrioMenu)
		VERIFY( m_PrioMenu.DestroyMenu() );
    if (m_SourcesMenu)
		VERIFY( m_SourcesMenu.DestroyMenu() );
	if (m_FileMenu)
		VERIFY( m_FileMenu.DestroyMenu() );
	
	while (m_ListItems.empty() == false) {
		delete m_ListItems.begin()->second; // second = CtrlItem_Struct*
		m_ListItems.erase(m_ListItems.begin());
	}
	delete m_tooltip;
}

void CDownloadListCtrl::Init()
{
	SetName(_T("DownloadListCtrl"));

	CImageList ilDummyImageList; //dummy list for getting the proper height of listview entries
	ilDummyImageList.Create(1, theApp.GetSmallSytemIconSize().cy, theApp.m_iDfltImageListColorFlags|ILC_MASK, 1, 1); 
	SetImageList(&ilDummyImageList, LVSIL_SMALL);
	ASSERT( (GetStyle() & LVS_SHAREIMAGELISTS) == 0 );
	ilDummyImageList.Detach();

	SetStyle();
	// X-Ray :: RollUpCtrl :: Start
	/*
	ASSERT( (GetStyle() & LVS_SINGLESEL) == 0 );
	*/
	ModifyStyle(LVS_SINGLESEL, 0);
	// X-Ray :: RollUpCtrl :: End
	
	CToolTipCtrl* tooltip = GetToolTips();
	if (tooltip){
		m_tooltip->SetFileIconToolTip(true);
		m_tooltip->SubclassWindow(*tooltip);
		tooltip->ModifyStyle(0, TTS_NOPREFIX);
		tooltip->SetDelayTime(TTDT_AUTOPOP, 20000);
		tooltip->SetDelayTime(TTDT_INITIAL, thePrefs.GetToolTipDelay()*1000);
	}

	InsertColumn(0,GetResString(IDS_DL_FILENAME),LVCFMT_LEFT, 260);
	InsertColumn(1,GetResString(IDS_DL_SIZE),LVCFMT_LEFT, 60);
	InsertColumn(2,GetResString(IDS_DL_TRANSF),LVCFMT_LEFT, 65);
	InsertColumn(3,GetResString(IDS_DL_TRANSFCOMPL),LVCFMT_LEFT, 65);
	InsertColumn(4,GetResString(IDS_DL_SPEED),LVCFMT_LEFT, 65);
	InsertColumn(5,GetResString(IDS_DL_PROGRESS),LVCFMT_LEFT, 170);
	InsertColumn(6,GetResString(IDS_DL_SOURCES),LVCFMT_LEFT, 50);
	InsertColumn(7,GetResString(IDS_PRIORITY),LVCFMT_LEFT, 55);
	InsertColumn(8,GetResString(IDS_STATUS),LVCFMT_LEFT, 70);
	InsertColumn(9,GetResString(IDS_DL_REMAINS),LVCFMT_LEFT, 110);
	CString lsctitle=GetResString(IDS_LASTSEENCOMPL);
	lsctitle.Remove(_T(':'));
	InsertColumn(10, lsctitle,LVCFMT_LEFT, 220);
	lsctitle=GetResString(IDS_FD_LASTCHANGE);
	lsctitle.Remove(_T(':'));
	InsertColumn(11, lsctitle,LVCFMT_LEFT, 220);
	InsertColumn(12, GetResString(IDS_CAT) ,LVCFMT_LEFT, 100);
	InsertColumn(13, GetResString(IDS_COUNTRY),LVCFMT_LEFT, 100); // X-Ray :: IP2Country
	InsertColumn(14, GetResString(IDS_SOURCECACHEAMOUNT), LVCFMT_LEFT, 100); // X-Ray :: Sourcecache

	SetAllIcons();
	Localize();
	LoadSettings();
	curTab=0;

	// X-Ray :: MOD :: Start
	CFont* pFont = GetFont();
	LOGFONT lfFont = {0};
	pFont->GetLogFont(&lfFont);
	// X-Ray :: MOD :: End

	if (thePrefs.GetShowActiveDownloadsBold())
	{
		// X-Ray :: MOD :: Start
		// moved up
		/*
		CFont* pFont = GetFont();
		LOGFONT lfFont = {0};
		pFont->GetLogFont(&lfFont);
		*/
		// X-Ray :: MOD :: End
		lfFont.lfWeight = FW_BOLD;
		m_fontBold.CreateFontIndirect(&lfFont);
	}

	// X-Ray :: ClientPercentage :: Start
	lfFont.lfHeight = 11;
	m_fontBoldSmaller.CreateFontIndirect(&lfFont);
	// X-Ray :: ClientPercentage :: End

	// X-Ray :: DownloadChunkDisplay :: Start
	lfFont.lfWeight = FW_NORMAL;
	m_fontSmaller.CreateFontIndirect(&lfFont);
	// X-Ray :: DownloadChunkDisplay :: End

	// Barry - Use preferred sort order from preferences
	m_bRemainSort=thePrefs.TransferlistRemainSortStyle();

	uint8 adder=0;
	if (GetSortItem()!=9 || !m_bRemainSort)
		SetSortArrow();
	else {
		SetSortArrow(GetSortItem(), GetSortAscending()?arrowDoubleUp : arrowDoubleDown);
		adder=81;
	}
	
	SortItems(SortProc, GetSortItem() + (GetSortAscending()? 0:100) + adder);

}

void CDownloadListCtrl::OnSysColorChange()
{
	CMuleListCtrl::OnSysColorChange();
	SetAllIcons();
	CreateMenues();
}

void CDownloadListCtrl::SetAllIcons()
{
	m_ImageList.DeleteImageList();
	m_ImageList.Create(16,16,theApp.m_iDfltImageListColorFlags|ILC_MASK,0,1);
	m_ImageList.SetBkColor(CLR_NONE);
	m_ImageList.Add(CTempIconLoader(_T("SrcDownloading")));
	m_ImageList.Add(CTempIconLoader(_T("SrcOnQueue")));
	m_ImageList.Add(CTempIconLoader(_T("SrcConnecting")));
	m_ImageList.Add(CTempIconLoader(_T("SrcNNPQF")));
	m_ImageList.Add(CTempIconLoader(_T("SrcUnknown")));
	m_ImageList.Add(CTempIconLoader(_T("ClientCompatible")));
	m_ImageList.Add(CTempIconLoader(_T("Friend")));
	m_ImageList.Add(CTempIconLoader(_T("ClientEDonkey")));
	m_ImageList.Add(CTempIconLoader(_T("ClientMLDonkey")));
	m_ImageList.Add(CTempIconLoader(_T("ClientEDonkeyHybrid")));
	m_ImageList.Add(CTempIconLoader(_T("ClientShareaza")));
	m_ImageList.Add(CTempIconLoader(_T("Server")));
	m_ImageList.Add(CTempIconLoader(_T("ClientAMule")));
	m_ImageList.Add(CTempIconLoader(_T("ClientLPhant")));
	m_ImageList.Add(CTempIconLoader(_T("Rating_NotRated")));
	m_ImageList.Add(CTempIconLoader(_T("Rating_Fake")));
	m_ImageList.Add(CTempIconLoader(_T("Rating_Poor")));
	m_ImageList.Add(CTempIconLoader(_T("Rating_Fair")));
	m_ImageList.Add(CTempIconLoader(_T("Rating_Good")));
	m_ImageList.Add(CTempIconLoader(_T("Rating_Excellent")));
	m_ImageList.Add(CTempIconLoader(_T("Collection_Search"))); // rating for comments are searched on kad
	m_ImageList.Add(CTempIconLoader(_T("ExtendedProtocolOvl"))); // X-Ray :: CorrectAppIcons
	// X-Ray :: EnhancedClientRecognization :: Start
	// 22 - 25
	m_ImageList.Add(CTempIconLoader(_T("CLIENTHYRANODEPLUS")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENTPLUSPLUS")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENTTRUSTYFILESPLUS")));
	m_ImageList.Add(CTempIconLoader(_T("CLIENTXMULEPLUS")));
	// X-Ray :: EnhancedClientRecognization :: End
	// X-Ray :: QRdiff :: Start
	// 26 - 28
	m_ImageList.Add(CTempIconLoader(_T("QR_EQUAL")));
	m_ImageList.Add(CTempIconLoader(_T("QR_UP")));
	m_ImageList.Add(CTempIconLoader(_T("QR_DOWN")));
	// X-Ray :: QRdiff :: End
	// X-Ray :: Argos :: Start
	// 29 - 32
	m_ImageList.Add(CTempIconLoader(_T("ARGOS_BANNED_SOFT")));
	m_ImageList.Add(CTempIconLoader(_T("ARGOS_BANNED_SOFT2")));
	m_ImageList.Add(CTempIconLoader(_T("ARGOS_LEECHER")));
	m_ImageList.Add(CTempIconLoader(_T("ARGOS_BANNED")));
	// X-Ray :: Argos :: End
	// X-Ray :: FileStatusIcons :: Start
	// 33 - 44
	m_ImageList.Add(CTempIconLoader(_T("STATUS_COMPLETE")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_COMPLETING")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_DOWNLOADING")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_IMPORTING"))); // X-Ray :: PartImportExport
	m_ImageList.Add(CTempIconLoader(_T("STATUS_ERRONEOUS")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_HASHING")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_PAUSED")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_STALLED"))); // X-Ray :: OnlyDownloadCompleteFiles
	m_ImageList.Add(CTempIconLoader(_T("STATUS_STOPPED")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_WAITING")));
	m_ImageList.Add(CTempIconLoader(_T("STATUS_STANDBY"))); // X-Ray :: StandbyDownload
	m_ImageList.Add(CTempIconLoader(_T("STATUS_SUSPEND"))); // X-Ray :: SuspendCollecting
	// X-Ray :: FileStatusIcons :: End
	m_ImageList.SetOverlayImage(m_ImageList.Add(CTempIconLoader(_T("ClientSecureOvl"))), 1);
	m_ImageList.SetOverlayImage(m_ImageList.Add(CTempIconLoader(_T("OverlayObfu"))), 2);
	m_ImageList.SetOverlayImage(m_ImageList.Add(CTempIconLoader(_T("OverlaySecureObfu"))), 3);
}

void CDownloadListCtrl::Localize()
{
	CHeaderCtrl* pHeaderCtrl = GetHeaderCtrl();
	HDITEM hdi;
	hdi.mask = HDI_TEXT;
	CString strRes;

	strRes = GetResString(IDS_DL_FILENAME);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(0, &hdi);

	strRes = GetResString(IDS_DL_SIZE);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(1, &hdi);

	strRes = GetResString(IDS_DL_TRANSF);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(2, &hdi);

	strRes = GetResString(IDS_DL_TRANSFCOMPL);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(3, &hdi);

	strRes = GetResString(IDS_DL_SPEED);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(4, &hdi);

	strRes = GetResString(IDS_DL_PROGRESS);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(5, &hdi);

	strRes = GetResString(IDS_DL_SOURCES);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(6, &hdi);

	strRes = GetResString(IDS_PRIORITY);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(7, &hdi);

	strRes = GetResString(IDS_STATUS);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(8, &hdi);

	strRes = GetResString(IDS_DL_REMAINS);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(9, &hdi);

	strRes = GetResString(IDS_LASTSEENCOMPL);
	strRes.Remove(_T(':'));
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(10, &hdi);

	strRes = GetResString(IDS_FD_LASTCHANGE);
	strRes.Remove(_T(':'));
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(11, &hdi);

	strRes = GetResString(IDS_CAT);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(12, &hdi);

	// X-Ray :: IP2Country :: Start
	strRes = GetResString(IDS_COUNTRY);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(13, &hdi);
	// X-Ray :: IP2Country :: End

	CreateMenues();
	ShowFilesCount();
}

void CDownloadListCtrl::AddFile(CPartFile* toadd)
{
	// Create new Item
    CtrlItem_Struct* newitem = new CtrlItem_Struct;
    int itemnr = GetItemCount();
    newitem->owner = NULL;
    newitem->type = FILE_TYPE;
    newitem->value = toadd;
    newitem->parent = NULL;
	newitem->dwUpdated = 0; 

	// The same file shall be added only once
	ASSERT(m_ListItems.find(toadd) == m_ListItems.end());
	m_ListItems.insert(ListItemsPair(toadd, newitem));

	if (toadd->CheckShowItemInGivenCat(curTab))
		InsertItem(LVIF_PARAM|LVIF_TEXT,itemnr,LPSTR_TEXTCALLBACK,0,0,0,(LPARAM)newitem);

	ShowFilesCount();
}

void CDownloadListCtrl::AddSource(CPartFile* owner, CUpDownClient* source, bool notavailable)
{
	// Create new Item
    CtrlItem_Struct* newitem = new CtrlItem_Struct;
    newitem->owner = owner;
    newitem->type = (notavailable) ? UNAVAILABLE_SOURCE : AVAILABLE_SOURCE;
    newitem->value = source;
	newitem->dwUpdated = 0; 
	newitem->dwUpdatedchunk = 0; // X-Ray :: DownloadChunkDisplay

	// Update cross link to the owner
	ListItems::const_iterator ownerIt = m_ListItems.find(owner);
	ASSERT(ownerIt != m_ListItems.end());
	CtrlItem_Struct* ownerItem = ownerIt->second;
	ASSERT(ownerItem->value == owner);
	newitem->parent = ownerItem;

	// The same source could be added a few time but only one time per file 
	{
		// Update the other instances of this source
		bool bFound = false;
		std::pair<ListItems::const_iterator, ListItems::const_iterator> rangeIt = m_ListItems.equal_range(source);
		for(ListItems::const_iterator it = rangeIt.first; it != rangeIt.second; it++){
			CtrlItem_Struct* cur_item = it->second;

			// Check if this source has been already added to this file => to be sure
			if(cur_item->owner == owner){
				// Update this instance with its new setting
				cur_item->type = newitem->type;
				cur_item->dwUpdated = 0;
				cur_item->dwUpdatedchunk = 0; // X-Ray :: DownloadChunkDisplay
				bFound = true;
			}
			else if(notavailable == false){
				// The state 'Available' is exclusive
				cur_item->type = UNAVAILABLE_SOURCE;
				cur_item->dwUpdated = 0;
			}
		}

		if(bFound == true){
			delete newitem; 
			return;
		}
	}
	m_ListItems.insert(ListItemsPair(source, newitem));

	if (owner->srcarevisible) {
		// find parent from the CListCtrl to add source
		LVFINDINFO find;
		find.flags = LVFI_PARAM;
		find.lParam = (LPARAM)ownerItem;
		int result = FindItem(&find);
		if (result != -1)
			InsertItem(LVIF_PARAM|LVIF_TEXT,result+1,LPSTR_TEXTCALLBACK,0,0,0,(LPARAM)newitem);
	}
}

void CDownloadListCtrl::RemoveSource(CUpDownClient* source, CPartFile* owner)
{
	if (!theApp.emuledlg->IsRunning())
		return;

	// Retrieve all entries matching the source
	std::pair<ListItems::iterator, ListItems::iterator> rangeIt = m_ListItems.equal_range(source);
	for(ListItems::iterator it = rangeIt.first; it != rangeIt.second; ){
		CtrlItem_Struct* delItem  = it->second;
		if(owner == NULL || owner == delItem->owner){
			// Remove it from the m_ListItems			
			it = m_ListItems.erase(it);

			// Remove it from the CListCtrl
 			LVFINDINFO find;
			find.flags = LVFI_PARAM;
			find.lParam = (LPARAM)delItem;
			int result = FindItem(&find);
			if (result != -1)
				DeleteItem(result);

			// finally it could be delete
			delete delItem;
		}
		else{
			it++;
		}
	}
}

bool CDownloadListCtrl::RemoveFile(const CPartFile* toremove)
{
	bool bResult = false;
	if (!theApp.emuledlg->IsRunning())
		return bResult;
	// Retrieve all entries matching the File or linked to the file
	// Remark: The 'asked another files' clients must be removed from here
	ASSERT(toremove != NULL);
	for(ListItems::iterator it = m_ListItems.begin(); it != m_ListItems.end(); ){
		CtrlItem_Struct* delItem = it->second;
		if(delItem->owner == toremove || delItem->value == (void*)toremove){
			// Remove it from the m_ListItems
			it = m_ListItems.erase(it);

			// Remove it from the CListCtrl
			LVFINDINFO find;
			find.flags = LVFI_PARAM;
			find.lParam = (LPARAM)delItem;
			int result = FindItem(&find);
			if (result != -1)
				DeleteItem(result);

			// finally it could be delete
			delete delItem;
			bResult = true;
		}
		else {
			it++;
		}
	}
	ShowFilesCount();
	return bResult;
}

void CDownloadListCtrl::UpdateItem(void* toupdate)
{
	if (!theApp.emuledlg->IsRunning())
		return;

	// Retrieve all entries matching the source
	std::pair<ListItems::const_iterator, ListItems::const_iterator> rangeIt = m_ListItems.equal_range(toupdate);
	for(ListItems::const_iterator it = rangeIt.first; it != rangeIt.second; it++){
		CtrlItem_Struct* updateItem  = it->second;

		// Find entry in CListCtrl and update object
 		LVFINDINFO find;
		find.flags = LVFI_PARAM;
		find.lParam = (LPARAM)updateItem;
		int result = FindItem(&find);
		if (result != -1){
			updateItem->dwUpdated = 0;
			updateItem->dwUpdatedchunk = 0; // X-Ray :: DownloadChunkDisplay
			Update(result);
		}
	}
}

void CDownloadListCtrl::DrawFileItem(CDC *dc, int nColumn, LPCRECT lpRect, CtrlItem_Struct *lpCtrlItem)
{
	if(lpRect->left < lpRect->right)
	{
		CString buffer;
		/*const*/ CPartFile *lpPartFile = (CPartFile*)lpCtrlItem->value;
		switch(nColumn)
		{
		case 0:{	// file name
			CRect rcDraw(lpRect);

			// X-Ray :: FileStatusIcons :: Start
			if (thePrefs.IsFileStatusIcons()){
				uint8 iIcon;
				switch (lpPartFile->GetPartFileStatus()){
					case PS_COMPLETING:
						iIcon = 34;
						break;
					case PS_COMPLETE:
						iIcon = 33;
						break;
					case PS_DOWNLOADING:
						iIcon = 35;
						break;
					// X-Ray :: PartImportExport :: Start
					case PS_IMPORTING:
						iIcon = 36;
						break;
					// X-Ray :: PartImportExport :: End
					// X-Ray :: StandbyDownload :: Start
					case PS_STANDBY:
						iIcon = 43;
						break;
					// X-Ray :: StandbyDownload :: End
					// X-Ray :: SuspendCollecting :: Start
					case PS_SUSPEND:
						iIcon = 44;
						break;
					// X-Ray :: SuspendCollecting :: End
					case PS_WAITINGFORSOURCE:
						iIcon = 42;
						break;
					case PS_HASHING:
						iIcon = 38;
						break;
					case PS_PAUSED:
						iIcon = 39;
						break;
					// X-Ray :: OnlyDownloadCompleteFiles :: Start
					case PS_STALLED:
						iIcon = 40;
						break;
					// X-Ray :: OnlyDownloadCompleteFiles :: End
					case PS_STOPPED:
						iIcon = 41;
						break;
					case PS_ERROR:
					default:
						iIcon = 37;
						break;
				}
				POINT ipoint= {rcDraw.left-5,rcDraw.top+1};
				m_ImageList.Draw(dc, iIcon, ipoint, ILD_NORMAL);

				rcDraw.left += 17;
			}
			// X-Ray :: FileStatusIcons :: End

			int iIconPosY = (rcDraw.Height() > theApp.GetSmallSytemIconSize().cy) ? ((rcDraw.Height() - theApp.GetSmallSytemIconSize().cy) / 2) : 0;
			int iImage = theApp.GetFileTypeSystemImageIdx(lpPartFile->GetFileName());
			if (theApp.GetSystemImageList() != NULL)
				::ImageList_Draw(theApp.GetSystemImageList(), iImage, dc->GetSafeHdc(), rcDraw.left, rcDraw.top + iIconPosY, ILD_NORMAL | ILD_TRANSPARENT);
			rcDraw.left += theApp.GetSmallSytemIconSize().cx;

			if (thePrefs.ShowRatingIndicator() && (lpPartFile->HasComment() || lpPartFile->HasRating() || lpPartFile->IsKadCommentSearchRunning())){
				m_ImageList.Draw(dc, lpPartFile->UserRating(true) + 14, CPoint(rcDraw.left, rcDraw.top + iIconPosY), ILD_NORMAL);
				rcDraw.left += RATING_ICON_WIDTH;
			}

			rcDraw.left += 3;
			dc->DrawText(lpPartFile->GetFileName(), lpPartFile->GetFileName().GetLength(), &rcDraw, DLC_DT_TEXT);
			break;
		}

		case 1:		// size
			buffer = CastItoXBytes(lpPartFile->GetFileSize(), false, false);
			dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT | DT_RIGHT);
			break;

		case 2:		// transferred
			// X-Ray :: SessionDownload :: Start
			/*
			buffer = CastItoXBytes(lpPartFile->GetTransferred(), false, false);
			*/
			if (thePrefs.GetUseSessionDownload()){
				buffer.Format(_T("%s (%s)"), CastItoXBytes(lpPartFile->GetTransferred(), false, false), CastItoXBytes(lpPartFile->GetTransferredSession(), false, false));
			} else {
				buffer.Format(_T("%s"), CastItoXBytes(lpPartFile->GetTransferred(), false, false));
			}
			// X-Ray :: SessionDownload :: End
			dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT | DT_RIGHT);
			break;

		case 3:		// transferred complete
			buffer = CastItoXBytes(lpPartFile->GetCompletedSize(), false, false);
			dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT | DT_RIGHT);
			break;

		case 4:		// speed
			if (lpPartFile->GetTransferringSrcCount())
				buffer.Format(_T("%s"), CastItoXBytes(lpPartFile->GetDatarate(), false, true));
			dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT | DT_RIGHT);
			break;

		case 5:		// progress
			{
				CRect rcDraw(*lpRect);
				rcDraw.bottom--;
				rcDraw.top++;

				// added
				int iWidth = rcDraw.Width();
				int iHeight = rcDraw.Height();
				if (lpCtrlItem->status == (HBITMAP)NULL)
					VERIFY(lpCtrlItem->status.CreateBitmap(1, 1, 1, 8, NULL));
				CDC cdcStatus;
				HGDIOBJ hOldBitmap;
				cdcStatus.CreateCompatibleDC(dc);
				int cx = lpCtrlItem->status.GetBitmapDimension().cx; 
				DWORD dwTicks = GetTickCount();
				if(lpCtrlItem->dwUpdated + DLC_BARUPDATE < dwTicks || cx !=  iWidth || !lpCtrlItem->dwUpdated) {
					lpCtrlItem->status.DeleteObject(); 
					lpCtrlItem->status.CreateCompatibleBitmap(dc,  iWidth, iHeight); 
					lpCtrlItem->status.SetBitmapDimension(iWidth,  iHeight); 
					hOldBitmap = cdcStatus.SelectObject(lpCtrlItem->status); 

					RECT rec_status; 
					rec_status.left = 0; 
					rec_status.top = 0; 
					rec_status.bottom = iHeight; 
					rec_status.right = iWidth; 
					lpPartFile->DrawStatusBar(&cdcStatus,  &rec_status, thePrefs.UseFlatBar()); 

					lpCtrlItem->dwUpdated = dwTicks + (rand() % 128); 
				} else 
					hOldBitmap = cdcStatus.SelectObject(lpCtrlItem->status); 

				dc->BitBlt(rcDraw.left, rcDraw.top, iWidth, iHeight,  &cdcStatus, 0, 0, SRCCOPY); 
				cdcStatus.SelectObject(hOldBitmap);
				//added end

				if (thePrefs.GetUseDwlPercentage()) {
					// HoaX_69: BEGIN Display percent in progress bar
					COLORREF oldclr = dc->SetTextColor(RGB(0, 0, 0)); // X-Ray :: OutlinedPercentage
					int iOMode = dc->SetBkMode(TRANSPARENT);
					// X-Ray :: SessionDownload :: Start
					if(!thePrefs.GetUseSessionDownload())
						buffer.Format(_T("%.1f%%"), lpPartFile->GetPercentCompleted());
					else
						buffer.Format(_T("%.1f%% / %.1f%%"), lpPartFile->GetPercentCompleted(), (lpPartFile->GetPercentCompleted() - lpPartFile->GetPercentCompletedInitial()));
					// X-Ray :: SessionDownload :: End

					// X-Ray :: OutlinedPercentage :: Start
					/*
					dc->DrawText(buffer, buffer.GetLength(), &rcDraw, (DLC_DT_TEXT & ~DT_LEFT) | DT_CENTER);
					dc->SetBkMode(iOMode);
					dc->SetTextColor(oldclr);
					*/
					CFont *pOldFont = dc->SelectObject(&m_fontBold);
					rcDraw.OffsetRect(-1,0);
					dc->DrawText(buffer, buffer.GetLength(), &rcDraw, (DLC_DT_TEXT & ~DT_LEFT) | DT_CENTER);
					rcDraw.OffsetRect(2,0);
					dc->DrawText(buffer, buffer.GetLength(), &rcDraw, (DLC_DT_TEXT & ~DT_LEFT) | DT_CENTER);
					rcDraw.OffsetRect(-1,-1);
					dc->DrawText(buffer, buffer.GetLength(), &rcDraw, (DLC_DT_TEXT & ~DT_LEFT) | DT_CENTER);
					rcDraw.OffsetRect(0,2);
					dc->DrawText(buffer, buffer.GetLength(), &rcDraw, (DLC_DT_TEXT & ~DT_LEFT) | DT_CENTER);
					rcDraw.OffsetRect(0,-1);
					dc->SetTextColor(RGB(255, 255, 255));
					dc->DrawText(buffer, buffer.GetLength(), &rcDraw, (DLC_DT_TEXT & ~DT_LEFT) | DT_CENTER);
					dc->SelectObject(pOldFont);
					dc->SetBkMode(iOMode);
					dc->SetTextColor(oldclr);
					// X-Ray :: OutlinedPercentage :: End
					// HoaX_69: END
				}
			}
			break;

		case 6:		// sources
			{
				UINT sc = lpPartFile->GetSourceCount();
				UINT ncsc = lpPartFile->GetNotCurrentSourcesCount();
// ZZ:DownloadManager -->
                if(!(lpPartFile->GetStatus() == PS_PAUSED && sc == 0) && lpPartFile->GetStatus() != PS_COMPLETE) {
                    buffer.Format(_T("%i"), sc-ncsc);
				    if(ncsc>0) buffer.AppendFormat(_T("/%i"), sc);
                    if(thePrefs.IsExtControlsEnabled() && lpPartFile->GetSrcA4AFCount() > 0) buffer.AppendFormat(_T("+%i"), lpPartFile->GetSrcA4AFCount());
				    if(lpPartFile->GetTransferringSrcCount() > 0) buffer.AppendFormat(_T(" (%i)"), lpPartFile->GetTransferringSrcCount());
                } else {
                    buffer = _T("");
				}
// <-- ZZ:DownloadManager
				// X-Ray :: Global Hardlimit :: Start
				/*
				if (thePrefs.IsExtControlsEnabled() && lpPartFile->GetPrivateMaxSources() != 0)
					buffer.AppendFormat(_T(" [%i]"), lpPartFile->GetPrivateMaxSources());
				*/
				if (thePrefs.IsUseGlobalHL() && thePrefs.IsExtControlsEnabled())  
					buffer.AppendFormat(_T(" [%i]"), lpPartFile->GetMaxSources());  
				else if (thePrefs.IsExtControlsEnabled() && lpPartFile->GetPrivateMaxSources() != 0)  
					buffer.AppendFormat(_T(" [%i]"), lpPartFile->GetPrivateMaxSources()); 
				// X-Ray :: Global Hardlimit :: End
				dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT | DT_RIGHT);
			}
			break;

		case 7:		// prio
			switch(lpPartFile->GetDownPriority()) {
			case PR_LOW:
				if( lpPartFile->IsAutoDownPriority() )
					dc->DrawText(GetResString(IDS_PRIOAUTOLOW),GetResString(IDS_PRIOAUTOLOW).GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
				else
					dc->DrawText(GetResString(IDS_PRIOLOW),GetResString(IDS_PRIOLOW).GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
				break;
			case PR_NORMAL:
				if( lpPartFile->IsAutoDownPriority() )
					dc->DrawText(GetResString(IDS_PRIOAUTONORMAL),GetResString(IDS_PRIOAUTONORMAL).GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
				else
					dc->DrawText(GetResString(IDS_PRIONORMAL),GetResString(IDS_PRIONORMAL).GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
				break;
			case PR_HIGH:
				if( lpPartFile->IsAutoDownPriority() )
					dc->DrawText(GetResString(IDS_PRIOAUTOHIGH),GetResString(IDS_PRIOAUTOHIGH).GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
				else
					dc->DrawText(GetResString(IDS_PRIOHIGH),GetResString(IDS_PRIOHIGH).GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
				break;
			}
			break;

		case 8:		// <<--9/21/02
			buffer = lpPartFile->getPartfileStatus();
			dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
			break;

		case 9:		// remaining time & size
			{
				if (lpPartFile->GetStatus()!=PS_COMPLETING && lpPartFile->GetStatus()!=PS_COMPLETE ){
					// time 
					time_t restTime;
					if (!thePrefs.UseSimpleTimeRemainingComputation())
						restTime = lpPartFile->getTimeRemaining();
					else
						restTime = lpPartFile->getTimeRemainingSimple();

					buffer.Format(_T("%s (%s)"), CastSecondsToHM(restTime), CastItoXBytes((lpPartFile->GetFileSize() - lpPartFile->GetCompletedSize()), false, false));
				}
				dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
			}
			break;
		case 10: // last seen complete
			{
				CString tempbuffer;
				if (lpPartFile->m_nCompleteSourcesCountLo == 0)
				{
					tempbuffer.Format(_T("< %u"), lpPartFile->m_nCompleteSourcesCountHi);
				}
				else if (lpPartFile->m_nCompleteSourcesCountLo == lpPartFile->m_nCompleteSourcesCountHi)
				{
					tempbuffer.Format(_T("%u"), lpPartFile->m_nCompleteSourcesCountLo);
				}
				else
				{
					tempbuffer.Format(_T("%u - %u"), lpPartFile->m_nCompleteSourcesCountLo, lpPartFile->m_nCompleteSourcesCountHi);
				}
				if (lpPartFile->lastseencomplete==NULL)
					buffer.Format(_T("%s (%s)"),GetResString(IDS_NEVER),tempbuffer);
				else
					buffer.Format(_T("%s (%s)"),lpPartFile->lastseencomplete.Format( thePrefs.GetDateTimeFormat()),tempbuffer);
				dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
			}
			break;
		case 11: // last receive
			if (!IsColumnHidden(11)) {
				if(lpPartFile->GetFileDate()!=NULL && lpPartFile->GetCompletedSize() > (uint64)0)
					buffer=lpPartFile->GetCFileDate().Format( thePrefs.GetDateTimeFormat());
				else
					buffer.Format(_T("%s"),GetResString(IDS_NEVER));

				dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
			}
			break;
		case 12: // cat
			if (!IsColumnHidden(12)) {
				buffer=(lpPartFile->GetCategory()!=0)?
					thePrefs.GetCategory(lpPartFile->GetCategory())->strTitle:_T("");
				dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
			}
			break;
		// X-Ray :: Sourcecache :: Start
		case 14: // sourcecache
			if (!IsColumnHidden(13)){
				buffer.Format(_T("%i"), lpPartFile->GetSourceCacheAmount());
				dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
			}
			break;
		// X-Ray :: Sourcecache :: End
		}
	}
}

void CDownloadListCtrl::DrawSourceItem(CDC *dc, int nColumn, LPCRECT lpRect, CtrlItem_Struct *lpCtrlItem) {
	if(lpRect->left < lpRect->right) { 

		CString buffer;
		CUpDownClient *lpUpDownClient = (CUpDownClient*)lpCtrlItem->value;
		switch(nColumn) {

		case 0:		// icon, name, status
			{
				CRect cur_rec(*lpRect);
				int iIconPosY = (cur_rec.Height() > 16) ? ((cur_rec.Height() - 16) / 2) : 1;
				POINT point = {cur_rec.left, cur_rec.top + iIconPosY};
				if (lpCtrlItem->type == AVAILABLE_SOURCE){
					switch (lpUpDownClient->GetDownloadState()) {
					case DS_CONNECTING:
						m_ImageList.Draw(dc, 2, point, ILD_NORMAL);
						break;
					// X-Ray :: StandbyDownload :: Start
					case DS_HALTED:
						m_ImageList.Draw(dc, 2, point, ILD_NORMAL);
						break;
					// X-Ray :: StandbyDownload :: End
					case DS_CONNECTED:
						m_ImageList.Draw(dc, 2, point, ILD_NORMAL);
						break;
					case DS_WAITCALLBACKKAD:
					case DS_WAITCALLBACK:
						m_ImageList.Draw(dc, 2, point, ILD_NORMAL);
						break;
					case DS_ONQUEUE:
						if(lpUpDownClient->IsRemoteQueueFull())
							m_ImageList.Draw(dc, 3, point, ILD_NORMAL);
						else
							m_ImageList.Draw(dc, 1, point, ILD_NORMAL);
						break;
					case DS_DOWNLOADING:
						m_ImageList.Draw(dc, 0, point, ILD_NORMAL);
						break;
					case DS_REQHASHSET:
						m_ImageList.Draw(dc, 0, point, ILD_NORMAL);
						break;
					case DS_NONEEDEDPARTS:
						m_ImageList.Draw(dc, 3, point, ILD_NORMAL);
						break;
					case DS_ERROR:
						m_ImageList.Draw(dc, 3, point, ILD_NORMAL);
						break;
					case DS_TOOMANYCONNS:
					case DS_TOOMANYCONNSKAD:
						m_ImageList.Draw(dc, 2, point, ILD_NORMAL);
						break;
					default:
						m_ImageList.Draw(dc, 4, point, ILD_NORMAL);
					}
				}
				else {
					m_ImageList.Draw(dc, 3, point, ILD_NORMAL);
				}
				cur_rec.left += 20;

				UINT uOvlImg = 0;
				if ((lpUpDownClient->Credits() && lpUpDownClient->Credits()->GetCurrentIdentState(lpUpDownClient->GetIP()) == IS_IDENTIFIED))
					uOvlImg |= 1;
				if (lpUpDownClient->IsObfuscatedConnectionEstablished())
					uOvlImg |= 2;

				POINT point2 = {cur_rec.left, cur_rec.top + iIconPosY};
				// X-Ray :: Argos :: Start
				if (lpUpDownClient->IsBanned()) 
					m_ImageList.Draw(dc, 32, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				else if(theApp.argos->IsArgos(lpUpDownClient->GetConnectIP())){
					if (theApp.argos->GetPunishment(lpUpDownClient) == 0) 
						m_ImageList.Draw(dc, 29, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
					else if (theApp.argos->GetPunishment(lpUpDownClient) == 1) 
						m_ImageList.Draw(dc, 31, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
					else
						m_ImageList.Draw(dc, 30, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				}
				// X-Ray :: Argos :: End
				else if (lpUpDownClient->IsFriend())
					m_ImageList.Draw(dc, 6, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				// X-Ray :: CorrectAppIcons :: Start
				else if (lpUpDownClient->GetClientSoft() == SO_EMULE)
					m_ImageList.Draw(dc, 7, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				// X-Ray :: CorrectAppIcons :: End
				else if (lpUpDownClient->GetClientSoft() == SO_EDONKEYHYBRID)
					m_ImageList.Draw(dc, 9, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				else if (lpUpDownClient->GetClientSoft() == SO_MLDONKEY)
					m_ImageList.Draw(dc, 8, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				else if (lpUpDownClient->GetClientSoft() == SO_SHAREAZA)
					m_ImageList.Draw(dc, 10, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				else if (lpUpDownClient->GetClientSoft() == SO_URL)
					m_ImageList.Draw(dc, 11, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				else if (lpUpDownClient->GetClientSoft() == SO_AMULE)
					m_ImageList.Draw(dc, 12, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				else if (lpUpDownClient->GetClientSoft() == SO_LPHANT)
					m_ImageList.Draw(dc, 13, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				// X-Ray :: EnhancedClientRecognization :: Start
				else if (lpUpDownClient->GetClientSoft() == SO_EMULEPLUS)
					m_ImageList.Draw(dc, 23, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				else if (lpUpDownClient->GetClientSoft() == SO_HYDRANODE)
					m_ImageList.Draw(dc, 22, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				else if (lpUpDownClient->GetClientSoft() == SO_TRUSTYFILES)
					m_ImageList.Draw(dc, 24, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				else if (lpUpDownClient->GetClientSoft() == SO_XMULE)
					m_ImageList.Draw(dc, 25, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				// X-Ray :: EnhancedClientRecognization :: End

				// X-Ray :: CorrectAppIcons :: Start
				/*
				else if (lpUpDownClient->ExtProtocolAvailable())
					m_ImageList.Draw(dc, 5, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				else
					m_ImageList.Draw(dc, 7, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg));
				*/
				else
					m_ImageList.Draw(dc, 5, point2, ILD_NORMAL | INDEXTOOVERLAYMASK(uOvlImg)); // changed to Compatible Icon because if it's none of the App's above we don't have an icon for it
				// X-Ray :: CorrectAppIcons :: End

				// X-Ray :: CorrectAppIcons :: Start
				if(lpUpDownClient->ExtProtocolAvailable())
					m_ImageList.Draw(dc, 21, point2, ILD_TRANSPARENT);
				// X-Ray :: CorrectAppIcons :: End

				cur_rec.left += 20;

				// X-Ray :: IP2Country :: Start
				if(theApp.ip2country->ShowCountryFlag()){
					POINT point3= {cur_rec.left,cur_rec.top+1};
					theApp.ip2country->GetFlagImageList()->Draw(dc, lpUpDownClient->GetCountryFlagIndex(), point3, ILD_NORMAL);
					cur_rec.left+=20;
				}
				// X-Ray :: IP2Country :: End

				if (!lpUpDownClient->GetUserName())
					buffer = _T("?");
				else
					buffer = lpUpDownClient->GetUserName();
				dc->DrawText(buffer,buffer.GetLength(),&cur_rec, DLC_DT_TEXT);
			}
			break;

		case 1:		// size
			switch(lpUpDownClient->GetSourceFrom()){
				case SF_SERVER:
					buffer = _T("eD2K Server");
					break;
				case SF_KADEMLIA:
					buffer = GetResString(IDS_KADEMLIA);
					break;
				case SF_SOURCE_EXCHANGE:
					buffer = GetResString(IDS_SE);
					break;
				case SF_PASSIVE:
					buffer = GetResString(IDS_PASSIVE);
					break;
				case SF_LINK:
					buffer = GetResString(IDS_SW_LINK);
					break;
				// X-Ray :: SearchCatch :: Start
				case SF_SEARCH:
					buffer = GetResString(IDS_SW_SEARCHBOX);
					break;
				// X-Ray :: SearchCatch :: End
				// X-Ray :: Sourcecache :: Start
				case SF_CACHE:
					buffer = GetResString(IDS_SOURCECACHE);
					break;
				// X-Ray :: Sourcecache :: End
				// X-Ray :: SLS :: Start
				case SF_SLS:
					buffer = GetResString(IDS_SLS);
					break;
				// X-Ray :: SLS :: End
			}
			dc->DrawText(buffer, buffer.GetLength(), const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
			break;

		case 2:		// transferred
		{
			// X-Ray :: TotalUpDown :: Start
			COLORREF crOldTxtColor = dc->GetTextColor();

			if (lpUpDownClient->Credits() && (lpUpDownClient->Credits()->GetUploadedTotal() > 0 || lpUpDownClient->Credits()->GetDownloadedTotal() > 0) ){
				COLORREF crTmpTxtColor;
				if (lpUpDownClient->Credits()->GetUploadedTotal() > lpUpDownClient->Credits()->GetDownloadedTotal()){
					crTmpTxtColor = dc->SetTextColor((COLORREF)RGB(200, 0, 0));
					buffer.Format( _T("%s/%s"),// %.1f",
						CastItoXBytes((float)lpUpDownClient->Credits()->GetUploadedTotal()),
						CastItoXBytes((float)lpUpDownClient->Credits()->GetDownloadedTotal()));
				} else {
					crTmpTxtColor = dc->SetTextColor((COLORREF)RGB(0, 200, 0));
					buffer.Format( _T("%s/%s"),// %.1f",
						CastItoXBytes((float)lpUpDownClient->Credits()->GetUploadedTotal()),
						CastItoXBytes((float)lpUpDownClient->Credits()->GetDownloadedTotal()));
				}
				dc->DrawText(buffer, buffer.GetLength(), const_cast<LPRECT>(lpRect), DLC_DT_TEXT | DT_RIGHT);
			} else {
				dc->SetTextColor(crOldTxtColor);
				dc->DrawText(_T(""), 0, const_cast<LPRECT>(lpRect), DLC_DT_TEXT | DT_RIGHT);
			}
			dc->SetTextColor(crOldTxtColor);
			break;
			// X-Ray :: TotalUpDown :: End
		}
		case 3:		// completed
			// X-Ray :: DownloadChunkDisplay :: Start
			/*
			// - 'Transferred' column: Show transferred data
			// - 'Completed' column: If 'Transferred' column is hidden, show the amount of transferred data
			//	  in 'Completed' column. This is plain wrong (at least when receiving compressed data), but
			//	  users seem to got used to it.
			if (nColumn == 2 || IsColumnHidden(2)) {
				if (lpCtrlItem->type == AVAILABLE_SOURCE && lpUpDownClient->GetTransferredDown()) {
					buffer = CastItoXBytes(lpUpDownClient->GetTransferredDown(), false, false);
					dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT | DT_RIGHT);
				}
			}
			break;
			*/
			if (lpCtrlItem->type == AVAILABLE_SOURCE && lpUpDownClient->GetDownloadState() == DS_DOWNLOADING) {
				CRect rcDraw(*lpRect);
				rcDraw.bottom--;
				rcDraw.top++; 

				int iWidth = rcDraw.Width();
				int iHeight = rcDraw.Height();
				if (lpCtrlItem->statuschunk == (HBITMAP)NULL)
					VERIFY(lpCtrlItem->statuschunk.CreateBitmap(1, 1, 1, 8, NULL)); 
				CDC cdcStatus;
				HGDIOBJ hOldBitmap;
				cdcStatus.CreateCompatibleDC(dc);
				int cx = lpCtrlItem->statuschunk.GetBitmapDimension().cx;
				DWORD dwTicks = GetTickCount();
				if(lpCtrlItem->dwUpdatedchunk + DLC_BARUPDATE < dwTicks || cx !=  iWidth  || !lpCtrlItem->dwUpdatedchunk) { 
					lpCtrlItem->statuschunk.DeleteObject(); 
					lpCtrlItem->statuschunk.CreateCompatibleBitmap(dc,  iWidth, iHeight); 
					lpCtrlItem->statuschunk.SetBitmapDimension(iWidth,  iHeight); 
					hOldBitmap = cdcStatus.SelectObject(lpCtrlItem->statuschunk); 

					RECT rec_status; 
					rec_status.left = 0; 
					rec_status.top = 0; 
					rec_status.bottom = iHeight; 
					rec_status.right = iWidth; 

					lpUpDownClient->DrawStatusBarChunk(&cdcStatus,  &rec_status,(CPartFile*)lpCtrlItem->owner, thePrefs.UseFlatBar());

					COLORREF oldclr = cdcStatus.SetTextColor(RGB(0,0,0));
					int iOMode = cdcStatus.SetBkMode(TRANSPARENT);
					if (lpUpDownClient->GetCurrentDownloadingChunk()==(UINT)-1) {
						if (lpUpDownClient->m_lastPartAsked==(uint16)-1)
							buffer = _T("?");
						else
							buffer.Format(_T("#%u"), lpUpDownClient->m_lastPartAsked);
					} else
						buffer.Format(_T("#%u"), lpUpDownClient->GetCurrentDownloadingChunk());
					CFont *pOldFont = cdcStatus.SelectObject(&m_fontSmaller);
#define	DrawClientPercentTextLeft		cdcStatus.DrawText(buffer, buffer.GetLength(),&rec_status, DLC_DT_TEXT)
					rec_status.top-=1;rec_status.bottom-=1;
					rec_status.left+=1;rec_status.right-=3;
					DrawClientPercentTextLeft;rec_status.left+=1;rec_status.right+=1;
					DrawClientPercentTextLeft;rec_status.left+=1;rec_status.right+=1;
					DrawClientPercentTextLeft;rec_status.top+=1;rec_status.bottom+=1;
					DrawClientPercentTextLeft;rec_status.top+=1;rec_status.bottom+=1;
					DrawClientPercentTextLeft;rec_status.left-=1;rec_status.right-=1;
					DrawClientPercentTextLeft;rec_status.left-=1;rec_status.right-=1;
					DrawClientPercentTextLeft;rec_status.top-=1;rec_status.bottom-=1;
					DrawClientPercentTextLeft;rec_status.left++;rec_status.right++;
					cdcStatus.SetTextColor(RGB(255,255,255));
					DrawClientPercentTextLeft;

					cdcStatus.SetTextColor(RGB(0,0,0));
					buffer.Format(_T("%s"), CastItoXBytes(lpUpDownClient->GetSessionPayloadDown(), false, false));
#define	DrawClientPercentTextRight		cdcStatus.DrawText(buffer, buffer.GetLength(),&rec_status, DLC_DT_TEXT | DT_RIGHT)
					rec_status.top-=1;rec_status.bottom-=1;
					DrawClientPercentTextRight;rec_status.left+=1;rec_status.right+=1;
					DrawClientPercentTextRight;rec_status.left+=1;rec_status.right+=1;
					DrawClientPercentTextRight;rec_status.top+=1;rec_status.bottom+=1;
					DrawClientPercentTextRight;rec_status.top+=1;rec_status.bottom+=1;
					DrawClientPercentTextRight;rec_status.left-=1;rec_status.right-=1;
					DrawClientPercentTextRight;rec_status.left-=1;rec_status.right-=1;
					DrawClientPercentTextRight;rec_status.top-=1;rec_status.bottom-=1;
					DrawClientPercentTextRight;rec_status.left++;rec_status.right++;
					cdcStatus.SetTextColor(RGB(255,255,255));
					DrawClientPercentTextRight;

					cdcStatus.SelectObject(pOldFont);
					cdcStatus.SetBkMode(iOMode);
					cdcStatus.SetTextColor(oldclr);

					lpCtrlItem->dwUpdatedchunk = dwTicks + (rand() % 128); 
				} else 
					hOldBitmap = cdcStatus.SelectObject(lpCtrlItem->statuschunk); 

				dc->BitBlt(rcDraw.left, rcDraw.top, iWidth, iHeight,  &cdcStatus, 0, 0, SRCCOPY); 
				cdcStatus.SelectObject(hOldBitmap);
			} else if (lpUpDownClient->GetSessionPayloadDown()){
				buffer.Format(_T("%s"), CastItoXBytes(lpUpDownClient->GetSessionPayloadDown(), false, false));
				dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT | DT_RIGHT);
			}
			// X-Ray :: DownloadChunkDisplay :: End
			break;

		case 4:		// speed
			if (lpCtrlItem->type == AVAILABLE_SOURCE && lpUpDownClient->GetDownloadDatarate()){
				if (lpUpDownClient->GetDownloadDatarate())
					buffer.Format(_T("%s"), CastItoXBytes(lpUpDownClient->GetDownloadDatarate(), false, true));
				dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT | DT_RIGHT);
			}
			break;

		case 5:		// file info
			{
				CRect rcDraw(*lpRect);
				rcDraw.bottom--; 
				rcDraw.top++; 

				int iWidth = rcDraw.Width();
				int iHeight = rcDraw.Height();
				if (lpCtrlItem->status == (HBITMAP)NULL)
					VERIFY(lpCtrlItem->status.CreateBitmap(1, 1, 1, 8, NULL)); 
				CDC cdcStatus;
				HGDIOBJ hOldBitmap;
				cdcStatus.CreateCompatibleDC(dc);
				int cx = lpCtrlItem->status.GetBitmapDimension().cx;
				DWORD dwTicks = GetTickCount();
				if(lpCtrlItem->dwUpdated + DLC_BARUPDATE < dwTicks || cx !=  iWidth  || !lpCtrlItem->dwUpdated) { 
					lpCtrlItem->status.DeleteObject(); 
					lpCtrlItem->status.CreateCompatibleBitmap(dc,  iWidth, iHeight); 
					lpCtrlItem->status.SetBitmapDimension(iWidth,  iHeight); 
					hOldBitmap = cdcStatus.SelectObject(lpCtrlItem->status); 

					RECT rec_status; 
					rec_status.left = 0; 
					rec_status.top = 0; 
					rec_status.bottom = iHeight; 
					rec_status.right = iWidth; 
					// X-Ray :: MultiFileStatusbars :: Start
					/*
					lpUpDownClient->DrawStatusBar(&cdcStatus,  &rec_status,(lpCtrlItem->type == UNAVAILABLE_SOURCE), thePrefs.UseFlatBar()); 
					*/
					lpUpDownClient->DrawStatusBar(&cdcStatus, &rec_status,(CPartFile*)lpCtrlItem->owner, thePrefs.UseFlatBar());
					// X-Ray :: MultiFileStatusbars :: End
					lpCtrlItem->dwUpdated = dwTicks + (rand() % 128); 
				} else 
					hOldBitmap = cdcStatus.SelectObject(lpCtrlItem->status); 

				dc->BitBlt(rcDraw.left, rcDraw.top, iWidth, iHeight,  &cdcStatus, 0, 0, SRCCOPY); 
				cdcStatus.SelectObject(hOldBitmap);
			}
			break;

		case 6:		// sources
		{
			buffer = lpUpDownClient->GetClientSoftVer();
			if (buffer.IsEmpty())
				buffer = GetResString(IDS_UNKNOWN);
			// X-Ray :: ModID :: Start
			if (!lpUpDownClient->GetClientModVer().IsEmpty())
				buffer += _T(" [") + lpUpDownClient->GetClientModVer() + _T(']');
			// X-Ray :: ModID :: End
			CRect rc(lpRect);
			dc->DrawText(buffer, buffer.GetLength(), &rc, DLC_DT_TEXT);
			break;
		}

		case 7:		// prio
			if (lpUpDownClient->GetDownloadState()==DS_ONQUEUE){
				if (lpUpDownClient->IsRemoteQueueFull()){
					buffer = GetResString(IDS_QUEUEFULL);
					dc->DrawText(buffer, buffer.GetLength(), const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
				}
				// X-Ray :: QRdiff :: Start
				/*
				else{
					if (lpUpDownClient->GetRemoteQueueRank()){
						buffer.Format(_T("QR: %u"), lpUpDownClient->GetRemoteQueueRank());
						dc->DrawText(buffer, buffer.GetLength(), const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
					}
					else{
						dc->DrawText(buffer, buffer.GetLength(), const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
					}
				}
				*/
				else {
					RECT cur_rec = *lpRect;
					if (lpUpDownClient->GetRemoteQueueRank()) {
						COLORREF dcOldTextColor = dc->GetTextColor();
						POINT point3 = {cur_rec.left, cur_rec.top+1};
						int iQRdiff = lpUpDownClient->GetDifference();

						buffer.Format(_T("QR: %u"), lpUpDownClient->GetRemoteQueueRank());
						if(iQRdiff){
							if (lpUpDownClient->GetDifference() > 0) {
								dcOldTextColor = dc->SetTextColor(RGB(200, 0, 0));
								m_ImageList.Draw(dc, 28, point3, ILD_NORMAL);
								buffer.AppendFormat(_T(" (+%d)"), iQRdiff);
							} else {
								dcOldTextColor = dc->SetTextColor(RGB(0, 200, 0));
								m_ImageList.Draw(dc, 27, point3, ILD_NORMAL);
								buffer.AppendFormat(_T(" (%d)"), iQRdiff);
							}
						} else
							m_ImageList.Draw(dc, 26, point3, ILD_NORMAL);
						cur_rec.left += 10;
						dc->DrawText(buffer, buffer.GetLength(), &cur_rec, DLC_DT_TEXT);
						if(iQRdiff)
							dc->SetTextColor(dcOldTextColor);
					} else {
						dc->DrawText(buffer, buffer.GetLength(), &cur_rec, DLC_DT_TEXT);
					}
				}
				// X-Ray :: QRdiff :: End
			}
			else{
				dc->DrawText(buffer, buffer.GetLength(), const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
			}
			break;

		case 8:	{	// status
			if (lpCtrlItem->type == AVAILABLE_SOURCE){
				buffer = lpUpDownClient->GetDownloadStateDisplayString();
			}
			else {
				buffer = GetResString(IDS_ASKED4ANOTHERFILE);

// ZZ:DownloadManager -->
                if(thePrefs.IsExtControlsEnabled()) {
                    if(lpUpDownClient->IsInNoNeededList(lpCtrlItem->owner)) {
                        buffer += _T(" (") + GetResString(IDS_NONEEDEDPARTS) + _T(")");
                    } else if(lpUpDownClient->GetDownloadState() == DS_DOWNLOADING) {
                        buffer += _T(" (") + GetResString(IDS_TRANSFERRING) + _T(")");
                    } else if(lpUpDownClient->IsSwapSuspended(lpUpDownClient->GetRequestFile())) {
                        buffer += _T(" (") + GetResString(IDS_SOURCESWAPBLOCKED) + _T(")");
                    }

                    if (lpUpDownClient && lpUpDownClient->GetRequestFile() && lpUpDownClient->GetRequestFile()->GetFileName()){
                        buffer.AppendFormat(_T(": \"%s\""),lpUpDownClient->GetRequestFile()->GetFileName());
                    }
                }
			}

            if(thePrefs.IsExtControlsEnabled() && !lpUpDownClient->m_OtherRequests_list.IsEmpty()) {
                buffer.Append(_T("*"));
            }
// ZZ:DownloadManager <--

			// X-Ray :: ColoredClientstate :: Start
			COLORREF crOldTxtColor = dc->SetTextColor((COLORREF)RGB(0, 0, 0)); // black
			if (lpCtrlItem->type == AVAILABLE_SOURCE){
				switch (lpUpDownClient->GetDownloadState()) {
					case DS_CONNECTING:
						crOldTxtColor = dc->SetTextColor((COLORREF)RGB(255, 155, 0)); // orange
						break;
					case DS_CONNECTED:
						crOldTxtColor = dc->SetTextColor((COLORREF)RGB(140, 230, 10)); // light green
						break;
					case DS_WAITCALLBACK:
						crOldTxtColor = dc->SetTextColor((COLORREF)RGB(255, 220, 0)); // light orange
						break;
					case DS_ONQUEUE:
						if( lpUpDownClient->IsRemoteQueueFull() ){
							crOldTxtColor = dc->SetTextColor((COLORREF)RGB(80, 80, 80)); // dark grey
						}
						else {
							crOldTxtColor = dc->SetTextColor((COLORREF)RGB(0, 160, 255)); // blue
						}
						break;
					case DS_DOWNLOADING:
						crOldTxtColor = dc->SetTextColor((COLORREF)RGB(0, 160, 0)); // green
						break;
					case DS_REQHASHSET:
						crOldTxtColor = dc->SetTextColor((COLORREF)RGB(245, 240, 50)); // light yellow
						break;
					case DS_NONEEDEDPARTS:
						crOldTxtColor = dc->SetTextColor((COLORREF)RGB(200, 200, 200)); // light grey
						break;
					case DS_LOWTOLOWIP:
						crOldTxtColor = dc->SetTextColor((COLORREF)RGB(135, 0, 135)); // purple
						break;
					case DS_TOOMANYCONNS:
						crOldTxtColor = dc->SetTextColor((COLORREF)RGB(135, 135, 135)); // grey
						break;
					default:
						crOldTxtColor = dc->SetTextColor((COLORREF)RGB(0, 0, 0)); // black
				}
			}
			// X-Ray :: ColoredClientstate :: End

			dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
			dc->SetTextColor(crOldTxtColor); // X-Ray :: ColoredClientstate
			break;
		}
		case 9:		// remaining time & size
		{
			// X-Ray :: QRETA :: Start
			DWORD dwQRETA = lpUpDownClient->GetQueueRankETA();
			DWORD curtime = GetTickCount();
			if (dwQRETA && dwQRETA-curtime < HR2MS(480))
				buffer.Format(_T("%s"), CastSecondsToHM((dwQRETA-GetTickCount())/1000));
			dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect), DLC_DT_TEXT);
			// X-Ray :: QRETA :: End
			break;
		}
		case 10:	// last seen complete
			break;
		case 11:	// last received
			break;
		case 12:	// category
			// X-Ray :: Argos :: Start
			if(thePrefs.UseArgosSystem())
				buffer = theApp.argos->GetArgosString(lpUpDownClient);
			// X-Ray :: Argos :: End
			break;
		// X-Ray :: IP2Country :: Start
		case 13:
			buffer.Format(_T("%s"), lpUpDownClient->GetCountryName());
			dc->DrawText(buffer,buffer.GetLength(),const_cast<LPRECT>(lpRect),DLC_DT_TEXT);
			break;
		// X-Ray :: IP2Country :: End
		}
	}
}

void CDownloadListCtrl::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	if (!theApp.emuledlg->IsRunning())
		return;
	if (!lpDrawItemStruct->itemData)
		return;

	// X-Ray :: Optimizations :: Start - Don't draw hidden Rect
	RECT clientRect;
	GetClientRect(&clientRect);
	CRect cur_rec(lpDrawItemStruct->rcItem);
	if ((cur_rec.top < clientRect.top || cur_rec.top > clientRect.bottom) && (cur_rec.bottom < clientRect.top || cur_rec.bottom > clientRect.bottom))
		return;
	// X-Ray :: Optimizations :: End - Don't draw hidden Rect

	CDC* odc = CDC::FromHandle(lpDrawItemStruct->hDC);
	BOOL bCtrlFocused = ((GetFocus() == this) || (GetStyle() & LVS_SHOWSELALWAYS));
	if (lpDrawItemStruct->itemState & ODS_SELECTED) {
		if (bCtrlFocused)
			odc->SetBkColor(m_crHighlight);
		else
			odc->SetBkColor(m_crNoHighlight);
	}
	else
		odc->SetBkColor(GetBkColor());
	CtrlItem_Struct* content = (CtrlItem_Struct*)lpDrawItemStruct->itemData;
	CMemDC dc(odc, &lpDrawItemStruct->rcItem);
	CFont* pOldFont;
	if (m_fontBold.m_hObject){
		if (content->type == FILE_TYPE){
			if (((const CPartFile*)content->value)->GetTransferringSrcCount())
				pOldFont = dc.SelectObject(&m_fontBold);
			else
				pOldFont = dc.SelectObject(GetFont());
		}
		else if (content->type == UNAVAILABLE_SOURCE || content->type == AVAILABLE_SOURCE){
			if (((const CUpDownClient*)content->value)->GetDownloadState() == DS_DOWNLOADING)
				pOldFont = dc.SelectObject(&m_fontBold);
			else
				pOldFont = dc.SelectObject(GetFont());
		}
		else
			pOldFont = dc.SelectObject(GetFont());
	}
	else
		pOldFont = dc.SelectObject(GetFont());
	// CRect cur_rec(lpDrawItemStruct->rcItem); // X-Ray :: Optimizations - Don't draw hidden Rect
	COLORREF crOldTextColor = dc.SetTextColor((lpDrawItemStruct->itemState & ODS_SELECTED) ? m_crHighlightText : m_crWindowText);

	int iOldBkMode;
	if (m_crWindowTextBk == CLR_NONE){
		DefWindowProc(WM_ERASEBKGND, (WPARAM)(HDC)dc, 0);
		iOldBkMode = dc.SetBkMode(TRANSPARENT);
	}
	else
		iOldBkMode = OPAQUE;

	BOOL notLast = lpDrawItemStruct->itemID + 1 != (UINT)GetItemCount();
	BOOL notFirst = lpDrawItemStruct->itemID != 0;
	int tree_start=0;
	int tree_end=0;

	int iTreeOffset = 6;
	CHeaderCtrl *pHeaderCtrl = GetHeaderCtrl();
	int iCount = pHeaderCtrl->GetItemCount();
	cur_rec.right = cur_rec.left;
	cur_rec.right -= FILE_ITEM_MARGIN_X;
	cur_rec.left += FILE_ITEM_MARGIN_X;

	if (content->type == FILE_TYPE)
	{
		if (!g_bLowColorDesktop || (lpDrawItemStruct->itemState & ODS_SELECTED) == 0) {
			DWORD dwCatColor = thePrefs.GetCatColor(((/*const*/ CPartFile*)content->value)->GetCategory());
			if (dwCatColor > 0)
				dc.SetTextColor(dwCatColor);
		}

		for (int iCurrent = 0; iCurrent < iCount; iCurrent++)
		{
			int iColumn = pHeaderCtrl->OrderToIndex(iCurrent);
			// X-Ray :: Optimizations :: Start - Don't draw item if not needed - WiZaRd
			if(IsColumnHidden(iColumn))
				continue;
			// X-Ray :: Optimizations :: End - Don't draw item if not needed - WiZaRd
			int cx = CListCtrl::GetColumnWidth(iColumn);
			if (iColumn == 5) {
				int iNextLeft = cur_rec.left + cx;
				//set up tree vars
				cur_rec.left = cur_rec.right + iTreeOffset;
				cur_rec.right = cur_rec.left + min(8, cx);
				tree_start = cur_rec.left + 1;
				tree_end = cur_rec.right;
				//normal column stuff
				cur_rec.left = cur_rec.right + 1;
				cur_rec.right = tree_start + cx - iTreeOffset;
				if (cur_rec.left < clientRect.right && cur_rec.right > clientRect.left) // X-Ray :: Optimizations - Only draw item if inside the display area
					DrawFileItem(dc, 5, &cur_rec, content);
				cur_rec.left = iNextLeft;
			} else {
				cur_rec.right += cx;
				if (cur_rec.left < clientRect.right && cur_rec.right > clientRect.left) // X-Ray :: Optimizations - Only draw item if inside the display area
					DrawFileItem(dc, iColumn, &cur_rec, content);
				cur_rec.left += cx;
			}
		}
	}
	else if (content->type == UNAVAILABLE_SOURCE || content->type == AVAILABLE_SOURCE)
	{
		for (int iCurrent = 0; iCurrent < iCount; iCurrent++)
		{
			int iColumn = pHeaderCtrl->OrderToIndex(iCurrent);
			// X-Ray :: Optimizations :: Start - Don't draw item if not needed - WiZaRd
			if(IsColumnHidden(iColumn))
				continue;
			// X-Ray :: Optimizations :: End - Don't draw item if not needed - WiZaRd
			int cx = CListCtrl::GetColumnWidth(iColumn);
			if (iColumn == 5) {
				int iNextLeft = cur_rec.left + cx;
				//set up tree vars
				cur_rec.left = cur_rec.right + iTreeOffset;
				cur_rec.right = cur_rec.left + min(8, cx);
				tree_start = cur_rec.left + 1;
				tree_end = cur_rec.right;
				//normal column stuff
				cur_rec.left = cur_rec.right + 1;
				cur_rec.right = tree_start + cx - iTreeOffset;
				if (cur_rec.left < clientRect.right && cur_rec.right > clientRect.left) // X-Ray :: Optimizations - Only draw item if inside the display area
					DrawSourceItem(dc, 5, &cur_rec, content);
				cur_rec.left = iNextLeft;
			} else {
				cur_rec.right += cx;
				if (cur_rec.left < clientRect.right && cur_rec.right > clientRect.left) // X-Ray :: Optimizations - Only draw item if inside the display area
					DrawSourceItem(dc, iColumn, &cur_rec, content);
				cur_rec.left += cx;
			}
		}
	}

	//draw rectangle around selected item(s)
	if (content->type == FILE_TYPE && (lpDrawItemStruct->itemState & ODS_SELECTED))
	{
		RECT outline_rec = lpDrawItemStruct->rcItem;

		outline_rec.top--;
		outline_rec.bottom++;
		dc.FrameRect(&outline_rec, &CBrush(GetBkColor()));
		outline_rec.top++;
		outline_rec.bottom--;
		outline_rec.left++;
		outline_rec.right--;

		if(notFirst && (GetItemState(lpDrawItemStruct->itemID - 1, LVIS_SELECTED))) {
			CtrlItem_Struct* prev = (CtrlItem_Struct*)this->GetItemData(lpDrawItemStruct->itemID - 1);
			if(prev->type == FILE_TYPE)
				outline_rec.top--;
		} 

		if(notLast && (GetItemState(lpDrawItemStruct->itemID + 1, LVIS_SELECTED))) {
			CtrlItem_Struct* next = (CtrlItem_Struct*)this->GetItemData(lpDrawItemStruct->itemID + 1);
			if(next->type == FILE_TYPE)
				outline_rec.bottom++;
		} 

		if(bCtrlFocused)
			dc.FrameRect(&outline_rec, &CBrush(m_crFocusLine));
		else
			dc.FrameRect(&outline_rec, &CBrush(m_crNoFocusLine));
	}
	//draw focus rectangle around non-highlightable items when they have the focus
	else if (((lpDrawItemStruct->itemState & ODS_FOCUS) == ODS_FOCUS) && (GetFocus() == this))
	{
		RECT focus_rec;
		focus_rec.top    = lpDrawItemStruct->rcItem.top;
		focus_rec.bottom = lpDrawItemStruct->rcItem.bottom;
		focus_rec.left   = lpDrawItemStruct->rcItem.left + 1;
		focus_rec.right  = lpDrawItemStruct->rcItem.right - 1;
		dc.FrameRect(&focus_rec, &CBrush(m_crNoFocusLine));
	}

	//draw tree last so it draws over selected and focus (looks better)
	if(tree_start < tree_end) {
		//set new bounds
		RECT tree_rect;
		tree_rect.top    = lpDrawItemStruct->rcItem.top;
		tree_rect.bottom = lpDrawItemStruct->rcItem.bottom;
		tree_rect.left   = tree_start;
		tree_rect.right  = tree_end;
		dc.SetBoundsRect(&tree_rect, DCB_DISABLE);

		//gather some information
		BOOL hasNext = notLast &&
			((CtrlItem_Struct*)this->GetItemData(lpDrawItemStruct->itemID + 1))->type != FILE_TYPE;
		BOOL isOpenRoot = hasNext && content->type == FILE_TYPE;
		BOOL isChild = content->type != FILE_TYPE;
		//BOOL isExpandable = !isChild && ((CPartFile*)content->value)->GetSourceCount() > 0;
		//might as well calculate these now
		int treeCenter = tree_start + 3;
		int middle = (cur_rec.top + cur_rec.bottom + 1) / 2;

		//set up a new pen for drawing the tree
		CPen pn, *oldpn;
		pn.CreatePen(PS_SOLID, 1, m_crWindowText);
		oldpn = dc.SelectObject(&pn);

		if(isChild) {
			//draw the line to the status bar
			dc.MoveTo(tree_end, middle);
			dc.LineTo(tree_start + 3, middle);

			//draw the line to the child node
			if(hasNext) {
				dc.MoveTo(treeCenter, middle);
				dc.LineTo(treeCenter, cur_rec.bottom + 1);
			}
		} else if(isOpenRoot) {
			//draw circle
			RECT circle_rec;
			COLORREF crBk = dc.GetBkColor();
			circle_rec.top    = middle - 2;
			circle_rec.bottom = middle + 3;
			circle_rec.left   = treeCenter - 2;
			circle_rec.right  = treeCenter + 3;
			dc.FrameRect(&circle_rec, &CBrush(m_crWindowText));
			dc.SetPixelV(circle_rec.left,      circle_rec.top,    crBk);
			dc.SetPixelV(circle_rec.right - 1, circle_rec.top,    crBk);
			dc.SetPixelV(circle_rec.left,      circle_rec.bottom - 1, crBk);
			dc.SetPixelV(circle_rec.right - 1, circle_rec.bottom - 1, crBk);
			//draw the line to the child node
			if(hasNext) {
				dc.MoveTo(treeCenter, middle + 3);
				dc.LineTo(treeCenter, cur_rec.bottom + 1);
			}
		} /*else if(isExpandable) {
			//draw a + sign
			dc.MoveTo(treeCenter, middle - 2);
			dc.LineTo(treeCenter, middle + 3);
			dc.MoveTo(treeCenter - 2, middle);
			dc.LineTo(treeCenter + 3, middle);
		}*/

		//draw the line back up to parent node
		if(notFirst && isChild) {
			dc.MoveTo(treeCenter, middle);
			dc.LineTo(treeCenter, cur_rec.top - 1);
		}

		//put the old pen back
		dc.SelectObject(oldpn);
		pn.DeleteObject();
	}

	//put the original objects back
	if (m_crWindowTextBk == CLR_NONE)
		dc.SetBkMode(iOldBkMode);
	dc.SelectObject(pOldFont);
	dc.SetTextColor(crOldTextColor);
}

void CDownloadListCtrl::HideSources(CPartFile* toCollapse)
{
	SetRedraw(false);
	int pre = 0;
	int post = 0;
	for (int i = 0; i < GetItemCount(); i++)
	{
		CtrlItem_Struct* item = (CtrlItem_Struct*)GetItemData(i);
		if (item->owner == toCollapse)
		{
			pre++;
			item->dwUpdated = 0;
			item->dwUpdatedchunk = 0; // X-Ray :: DownloadChunkDisplay
			item->status.DeleteObject();
			item->statuschunk.DeleteObject(); // X-Ray :: DownloadChunkDisplay
			DeleteItem(i--);
			post++;
		}
	}
	if (pre - post == 0)
		toCollapse->srcarevisible = false;
	SetRedraw(true);
}

void CDownloadListCtrl::ExpandCollapseItem(int iItem, int iAction, bool bCollapseSource)
{
	if (iItem == -1)
		return;
	CtrlItem_Struct* content = (CtrlItem_Struct*)GetItemData(iItem);

	// to collapse/expand files when one of its source is selected
	if (bCollapseSource && content->parent != NULL)
	{
		content=content->parent;
		
 		LVFINDINFO find;
		find.flags = LVFI_PARAM;
		find.lParam = (LPARAM)content;
		iItem = FindItem(&find);
		if (iItem == -1)
			return;
	}

	if (!content || content->type != FILE_TYPE)
		return;
	
	CPartFile* partfile = reinterpret_cast<CPartFile*>(content->value);
	if (!partfile)
		return;

	if (partfile->CanOpenFile()) {
		partfile->OpenFile();
		return;
	}

	// Check if the source branch is disable
	if (!partfile->srcarevisible)
	{
		if (iAction > COLLAPSE_ONLY)
		{
			SetRedraw(false);
			
			// Go throught the whole list to find out the sources for this file
			// Remark: don't use GetSourceCount() => UNAVAILABLE_SOURCE
			for (ListItems::const_iterator it = m_ListItems.begin(); it != m_ListItems.end(); it++)
			{
				const CtrlItem_Struct* cur_item = it->second;
				if (cur_item->owner == partfile)
				{
					partfile->srcarevisible = true;
					InsertItem(LVIF_PARAM|LVIF_TEXT, iItem+1, LPSTR_TEXTCALLBACK, 0, 0, 0, (LPARAM)cur_item);
				}
			}

			SetRedraw(true);
		}
	}
	else {
		if (iAction == EXPAND_COLLAPSE || iAction == COLLAPSE_ONLY)
		{
			if (GetItemState(iItem, LVIS_SELECTED | LVIS_FOCUSED) != (LVIS_SELECTED | LVIS_FOCUSED))
			{
				SetItemState(iItem, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
				SetSelectionMark(iItem);
			}
			HideSources(partfile);
		}
	}
}

void CDownloadListCtrl::OnItemActivate(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMIA = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);

	if (thePrefs.IsDoubleClickEnabled() || pNMIA->iSubItem > 0)
		ExpandCollapseItem(pNMIA->iItem, EXPAND_COLLAPSE);
	*pResult = 0;
}

void CDownloadListCtrl::OnContextMenu(CWnd* /*pWnd*/, CPoint point)
{
	int iSel = GetNextItem(-1, LVIS_SELECTED);
	if (iSel != -1)
	{
		const CtrlItem_Struct* content = (CtrlItem_Struct*)GetItemData(iSel);
		if (content->type == FILE_TYPE)
		{
			// get merged settings
			bool bFirstItem = true;
			int iSelectedItems = 0;
			int iFilesNotDone = 0;
			int iFilesToPause = 0;
			int iFilesToStop = 0;
			int iFilesToResume = 0;
			int iFilesToOpen = 0;
            int iFilesGetPreviewParts = 0;
            int iFilesPreviewType = 0;
			int iFilesToPreview = 0;
			int iFilesToCancel = 0;
			UINT uPrioMenuItem = 0;
			const CPartFile* file1 = NULL;

			int iCheckedGHL = 0; // X-Ray :: Global Hardlimit
			UINT uPrioUpMenuItem = 0; // X-Ray :: DLULPrioExtension

			POSITION pos = GetFirstSelectedItemPosition();
			while (pos)
			{
				const CtrlItem_Struct* pItemData = (CtrlItem_Struct*)GetItemData(GetNextSelectedItem(pos));
				if (pItemData->type != FILE_TYPE)
					continue;
				const CPartFile* pFile = (CPartFile*)pItemData->value;
				if (bFirstItem)
					file1 = pFile;
				iSelectedItems++;

				bool bFileDone = (pFile->GetStatus()==PS_COMPLETE || pFile->GetStatus()==PS_COMPLETING);
				iFilesToCancel += pFile->GetStatus() != PS_COMPLETING ? 1 : 0;
				iFilesNotDone += !bFileDone ? 1 : 0;
				iFilesToStop += pFile->CanStopFile() ? 1 : 0;
				iFilesToPause += pFile->CanPauseFile() ? 1 : 0;
				iFilesToResume += pFile->CanResumeFile() ? 1 : 0;
				iFilesToOpen += pFile->CanOpenFile() ? 1 : 0;
                iFilesGetPreviewParts += pFile->GetPreviewPrio() ? 1 : 0;
                iFilesPreviewType += pFile->IsPreviewableFileType() ? 1 : 0;
				iFilesToPreview += pFile->IsReadyForPreview() ? 1 : 0;
				iCheckedGHL += pFile->GetGlobalHL() ? 1 : 0; // X-Ray :: Global Hardlimit

				UINT uCurPrioMenuItem = 0;
				if (pFile->IsAutoDownPriority())
					uCurPrioMenuItem = MP_PRIOAUTO;
				else if (pFile->GetDownPriority() == PR_HIGH)
					uCurPrioMenuItem = MP_PRIOHIGH;
				else if (pFile->GetDownPriority() == PR_NORMAL)
					uCurPrioMenuItem = MP_PRIONORMAL;
				else if (pFile->GetDownPriority() == PR_LOW)
					uCurPrioMenuItem = MP_PRIOLOW;
				else
					ASSERT(0);

                if (bFirstItem)
					uPrioMenuItem = uCurPrioMenuItem;
                else if (uPrioMenuItem != uCurPrioMenuItem)
					uPrioMenuItem = 0;

				// X-Ray :: DLULPrioExtension :: Start
				UINT uCurPrioUpMenuItem = 0;
				if (pFile->IsAutoUpPriority())
					uCurPrioUpMenuItem = MP_PRIOUPAUTO;
				else if (pFile->GetUpPriority() == PR_VERYLOW)
					uCurPrioUpMenuItem = MP_PRIOUPVERYLOW;
				else if (pFile->GetUpPriority() == PR_LOW)
					uCurPrioUpMenuItem = MP_PRIOUPLOW;
				else if (pFile->GetUpPriority() == PR_NORMAL)
					uCurPrioUpMenuItem = MP_PRIOUPNORMAL;
				else if (pFile->GetUpPriority() == PR_HIGH)
					uCurPrioUpMenuItem = MP_PRIOUPHIGH;
				else if (pFile->GetUpPriority() == PR_VERYHIGH)
					uCurPrioUpMenuItem = MP_PRIOUPVERYHIGH;
				else
					ASSERT(0);

				if (bFirstItem)
					uPrioUpMenuItem = uCurPrioUpMenuItem;
				else if (uPrioUpMenuItem != uCurPrioUpMenuItem)
					uPrioUpMenuItem = 0;
				// X-Ray :: DLULPrioExtension :: End

				bFirstItem = false;
			}

			m_FileMenu.EnableMenuItem((UINT_PTR)m_PrioMenu.m_hMenu, iFilesNotDone > 0 ? MF_ENABLED : MF_GRAYED);
			m_PrioMenu.CheckMenuRadioItem(MP_PRIOLOW, MP_PRIOAUTO, uPrioMenuItem, 0);

			// X-Ray :: DLULPrioExtension :: Start
			m_FileMenu.EnableMenuItem((UINT_PTR)m_PrioUpMenu.m_hMenu, iSelectedItems > 0 ? MF_ENABLED : MF_GRAYED);
			m_PrioUpMenu.CheckMenuRadioItem(MP_PRIOUPVERYLOW, MP_PRIOUPAUTO, uPrioUpMenuItem, 0);
			// X-Ray :: DLULPrioExtension :: End

			m_FileMenu.EnableMenuItem((UINT_PTR)m_A4AFMenu.m_hMenu, iFilesToStop > 0 ? MF_ENABLED : MF_GRAYED); // X-Ray :: ManualClientManagement

			// enable commands if there is at least one item which can be used for the action
			m_FileMenu.EnableMenuItem(MP_CANCEL, iFilesToCancel > 0 ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.EnableMenuItem(MP_STOP, iFilesToStop > 0 ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.EnableMenuItem(MP_PAUSE, iFilesToPause > 0 ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.EnableMenuItem(MP_RESUME, iFilesToResume > 0 ? MF_ENABLED : MF_GRAYED);

			// X-Ray :: OnlyDownloadCompleteFiles :: Start
			m_FileMenu.EnableMenuItem(MP_FORCE, iFilesToStop > 0 ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.SetMenuBitmap(MF_STRING, MP_FORCE, GetResString(IDS_FORCE), file1->GetForced() ? _T("FORCE2") : _T("FORCE"));
			// X-Ray :: OnlyDownloadCompleteFiles :: End

			// X-Ray :: StandbyDownload :: Start
			m_FileMenu.EnableMenuItem(MP_STANDBY, iFilesToStop > 0 ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.SetMenuBitmap(MF_STRING, MP_STANDBY, GetResString(IDS_STANDBY), file1->GetStandBy() ? _T("STANDBY2") : _T("STANDBY"));
			// X-Ray :: StandbyDownload :: End

			// X-Ray :: SuspendCollecting :: Start
			m_FileMenu.EnableMenuItem(MP_SUSPEND, iFilesToStop > 0 ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.SetMenuBitmap(MF_STRING, MP_SUSPEND, GetResString(IDS_SUSPENDDL), file1->GetSuspend() ? _T("SUSPEND2") : _T("SUSPEND"));
			// X-Ray :: SuspendCollecting :: End

			m_FileMenu.EnableMenuItem((UINT_PTR)m_DropMenu.m_hMenu, iSelectedItems > 0 ? MF_ENABLED : MF_GRAYED); // X-Ray :: DropSystem
			
			bool bOpenEnabled = (iSelectedItems == 1 && iFilesToOpen == 1);
			m_FileMenu.EnableMenuItem(MP_OPEN, bOpenEnabled ? MF_ENABLED : MF_GRAYED);
			if(thePrefs.IsExtControlsEnabled() && !thePrefs.GetPreviewPrio()) {
				m_FileMenu.EnableMenuItem(MP_TRY_TO_GET_PREVIEW_PARTS, (iSelectedItems == 1 && iFilesPreviewType == 1 && iFilesToPreview == 0 && iFilesNotDone == 1) ? MF_ENABLED : MF_GRAYED);
				m_FileMenu.CheckMenuItem(MP_TRY_TO_GET_PREVIEW_PARTS, (iSelectedItems == 1 && iFilesGetPreviewParts == 1) ? MF_CHECKED : MF_UNCHECKED);
			}
			m_FileMenu.EnableMenuItem(MP_PREVIEW, (iSelectedItems == 1 && iFilesToPreview == 1) ? MF_ENABLED : MF_GRAYED);
			// X-Ray :: XPMenus :: Start
			/*
			CMenu PreviewMenu;
			PreviewMenu.CreateMenu();
			*/
			CTitleMenu PreviewMenu;
			PreviewMenu.CreateMenu();
			PreviewMenu.AddMenuTitle(NULL);
			// X-Ray :: XPMenus :: End
			int iPreviewMenuEntries = thePreviewApps.GetAllMenuEntries(PreviewMenu, (iSelectedItems == 1) ? file1 : NULL);
			if (iPreviewMenuEntries)
				m_FileMenu.InsertMenu(MP_METINFO, MF_POPUP | (iSelectedItems == 1 ? MF_ENABLED : MF_GRAYED), (UINT_PTR)PreviewMenu.m_hMenu, GetResString(IDS_DL_PREVIEW));

			bool bDetailsEnabled = (iSelectedItems > 0);
			m_FileMenu.EnableMenuItem(MP_METINFO, bDetailsEnabled ? MF_ENABLED : MF_GRAYED);
			if (thePrefs.IsDoubleClickEnabled() && bOpenEnabled)
				m_FileMenu.SetDefaultItem(MP_OPEN);
			else if (!thePrefs.IsDoubleClickEnabled() && bDetailsEnabled)
				m_FileMenu.SetDefaultItem(MP_METINFO);
			else
				m_FileMenu.SetDefaultItem((UINT)-1);
			m_FileMenu.EnableMenuItem(MP_VIEWFILECOMMENTS, (iSelectedItems >= 1 /*&& iFilesNotDone == 1*/) ? MF_ENABLED : MF_GRAYED);

			m_FileMenu.EnableMenuItem(MP_MASSRENAME, iSelectedItems > 0 ? MF_ENABLED : MF_GRAYED); // X-Ray :: MassRename
			m_FileMenu.EnableMenuItem(MP_IMPORT, (iSelectedItems == 1 && iFilesNotDone == 1) ? MF_ENABLED : MF_GRAYED); // X-Ray :: PartImportExport

			int total;
			m_FileMenu.EnableMenuItem(MP_CLEARCOMPLETED, GetCompleteDownloads(curTab, total) > 0 ? MF_ENABLED : MF_GRAYED);

			if (m_SourcesMenu && thePrefs.IsExtControlsEnabled()) {
				m_FileMenu.EnableMenuItem((UINT_PTR)m_SourcesMenu.m_hMenu, MF_ENABLED);
				m_SourcesMenu.EnableMenuItem(MP_ADDSOURCE, (iSelectedItems == 1 && iFilesToStop == 1) ? MF_ENABLED : MF_GRAYED);
				// X-Ray :: Global Hardlimit :: Start
				/*
				m_SourcesMenu.EnableMenuItem(MP_SETSOURCELIMIT, (iFilesNotDone == iSelectedItems) ? MF_ENABLED : MF_GRAYED);
				*/
				bool bActive = iFilesToStop == iSelectedItems && thePrefs.IsUseGlobalHL();
				m_SourcesMenu.EnableMenuItem(MP_SETSOURCELIMIT, (iFilesNotDone == iSelectedItems && (iCheckedGHL == 0 || thePrefs.IsUseGlobalHL()==false)) ? MF_ENABLED : MF_GRAYED);
				// X-Ray :: XPMenus :: Start
				/*
				if(iSelectedItems == 1)
					m_SourcesMenu.ModifyMenu(MP_GLOBALHL, MF_STRING, MP_GLOBALHL, GetResString(IDS_GLOBAL_HL_CONTEXT)); 
				else 
					m_SourcesMenu.ModifyMenu(MP_GLOBALHL, MF_STRING, MP_GLOBALHL, GetResString(IDS_GLOBAL_HL_CONTEXT_MULTI)); 
				*/
				if(iSelectedItems == 1){
					m_SourcesMenu.RemoveMenu(MP_GLOBALHL, MF_BYCOMMAND); 
					m_SourcesMenu.InsertMenu(MP_GLOBALHL, MF_STRING | MF_BYPOSITION, MP_GLOBALHL, GetResString(IDS_GLOBAL_HL_CONTEXT));
				} else { 
					m_SourcesMenu.RemoveMenu(MP_GLOBALHL, MF_BYCOMMAND); 
					m_SourcesMenu.InsertMenu(MP_GLOBALHL, MF_STRING | MF_BYPOSITION, MP_GLOBALHL, GetResString(IDS_GLOBAL_HL_CONTEXT_MULTI));
				}
				// X-Ray :: XPMenus :: End
				m_SourcesMenu.CheckMenuItem(MP_GLOBALHL, (iCheckedGHL == iSelectedItems && bActive) ? MF_CHECKED : MF_UNCHECKED);
				m_SourcesMenu.EnableMenuItem(MP_GLOBALHL, (bActive) ? MF_ENABLED : MF_GRAYED);
				// X-Ray :: Global Hardlimit :: End
			}

			m_FileMenu.EnableMenuItem(thePrefs.GetShowCopyEd2kLinkCmd() ? MP_GETED2KLINK : MP_SHOWED2KLINK, iSelectedItems > 0 ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.EnableMenuItem(MP_PASTE, theApp.IsEd2kFileLinkInClipboard() ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.EnableMenuItem(MP_FIND, GetItemCount() > 0 ? MF_ENABLED : MF_GRAYED);
			m_FileMenu.EnableMenuItem(MP_SEARCHRELATED, theApp.emuledlg->searchwnd->CanSearchRelatedFiles() ? MF_ENABLED : MF_GRAYED);

			CTitleMenu WebMenu;
			WebMenu.CreateMenu();
			// X-Ray :: XPMenus :: Start
			/*
			WebMenu.AddMenuTitle(NULL, true);
			*/
			WebMenu.AddMenuTitle(NULL, true, true);
			// X-Ray :: XPMenus :: End
			int iWebMenuEntries = theWebServices.GetFileMenuEntries(&WebMenu);
			UINT flag = (iWebMenuEntries == 0 || iSelectedItems != 1) ? MF_GRAYED : MF_ENABLED;
			m_FileMenu.AppendMenu(MF_POPUP | flag, (UINT_PTR)WebMenu.m_hMenu, GetResString(IDS_WEBSERVICES), _T("WEB"));

			// create cat-submenue
			// X-Ray :: XPMenus :: Start
			/*
			CMenu CatsMenu;
			CatsMenu.CreateMenu();
			*/
			CTitleMenu CatsMenu;
			CatsMenu.CreateMenu();
			CatsMenu.AddMenuTitle(NULL, false, true);
			// X-Ray :: XPMenus :: End
			flag = (thePrefs.GetCatCount() == 1) ? MF_GRAYED : MF_ENABLED;
			CString label;
			if (thePrefs.GetCatCount()>1) {
				for (int i = 0; i < thePrefs.GetCatCount(); i++){
					if (i>0) {
						label=thePrefs.GetCategory(i)->strTitle;
						label.Replace(_T("&"), _T("&&") );
					}
					CatsMenu.AppendMenu(MF_STRING,MP_ASSIGNCAT+i, (i==0)?GetResString(IDS_CAT_UNASSIGN):label);
				}
			}
			m_FileMenu.AppendMenu(MF_POPUP | flag, (UINT_PTR)CatsMenu.m_hMenu, GetResString(IDS_TOCAT), _T("CATEGORY"));

			GetPopupMenuPos(*this, point);
			m_FileMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON, point.x, point.y, this);
			VERIFY( m_FileMenu.RemoveMenu(m_FileMenu.GetMenuItemCount() - 1, MF_BYPOSITION) );
			VERIFY( m_FileMenu.RemoveMenu(m_FileMenu.GetMenuItemCount() - 1, MF_BYPOSITION) );
			if (iPreviewMenuEntries)
				VERIFY( m_FileMenu.RemoveMenu((UINT)PreviewMenu.m_hMenu, MF_BYCOMMAND) );
			VERIFY( WebMenu.DestroyMenu() );
			VERIFY( CatsMenu.DestroyMenu() );
			VERIFY( PreviewMenu.DestroyMenu() );
		}
		else{
			// X-Ray :: ManualClientManagement :: Start
			/*
			const CUpDownClient* client = (CUpDownClient*)content->value;
			*/
			CPartFile* pSingleSelFile = NULL;
			CUpDownClient* client = NULL;
			int iSelectedItems = 0;
			int iThisFileItems = 0;
			int iOtherFileItems = 0;
			int iLoadingItems = 0; // X-Ray :: StopDownload
			bool bFirstItem = true;

			POSITION pos = GetFirstSelectedItemPosition();
			while (pos)
			{
				const CtrlItem_Struct* pItemData = (CtrlItem_Struct*)GetItemData(GetNextSelectedItem(pos));
				if (pItemData->type == FILE_TYPE)
					continue;
				const CUpDownClient* pClient = (CUpDownClient*)pItemData->value;
				if (bFirstItem)
					client = const_cast <CUpDownClient*> (pClient);
				if (bFirstItem)
					pSingleSelFile = (CPartFile*)pItemData->owner;
				iSelectedItems++;

				if(pSingleSelFile == pClient->GetRequestFile())
					iThisFileItems++;
				else
					iOtherFileItems++;

				// X-Ray :: StopDownload :: Start
				if(pClient->GetDownloadState() == DS_DOWNLOADING)
					iLoadingItems++;
				// X-Ray :: StopDownload :: End

				bFirstItem = false;
			}
			// X-Ray :: ManualClientManagement :: End

			CTitleMenu ClientMenu;
			ClientMenu.CreatePopupMenu();
			// X-Ray :: XPMenus :: Start
			/*
			ClientMenu.AddMenuTitle(GetResString(IDS_CLIENTS), true);
			*/
			ClientMenu.AddMenuTitle(GetResString(IDS_CLIENTS), true, false, true);
			// X-Ray :: XPMenus :: End
			ClientMenu.AppendMenu(MF_STRING, MP_DETAIL, GetResString(IDS_SHOWDETAILS), _T("CLIENTDETAILS"));
			ClientMenu.SetDefaultItem(MP_DETAIL);
			ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && !client->IsFriend()) ? MF_ENABLED : MF_GRAYED), MP_ADDFRIEND, GetResString(IDS_ADDFRIEND), _T("ADDFRIEND"));
			ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient()) ? MF_ENABLED : MF_GRAYED), MP_MESSAGE, GetResString(IDS_SEND_MSG), _T("SENDMESSAGE"));
			ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && client->GetViewSharedFilesSupport()) ? MF_ENABLED : MF_GRAYED), MP_SHOWLIST, GetResString(IDS_VIEWFILES), _T("VIEWFILES"));

			// X-Ray :: ManualClientManagement :: Start
			CTitleMenu A4AFMenu;
			A4AFMenu.CreateMenu();
			A4AFMenu.AddMenuTitle(GetResString(IDS_SRC_MANAGEMENT), true);
			if (thePrefs.IsExtControlsEnabled()) {
				A4AFMenu.AppendMenu(MF_STRING | ((iOtherFileItems > 0 && client && client->IsEd2kClient() && content->type == UNAVAILABLE_SOURCE) ? MF_ENABLED : MF_GRAYED), MP_SWAP_TO_CLIENT, GetResString(IDS_SWAP_TO_CLIENT), _T("SWAPTO"));
				A4AFMenu.AppendMenu(MF_STRING | ((iThisFileItems > 0 && client && client->IsEd2kClient() && content->type == AVAILABLE_SOURCE) ? MF_ENABLED : MF_GRAYED), MP_SWAP_FROM_CLIENT, GetResString(IDS_SWAP_FROM_CLIENT), _T("SWAPFROM"));
				A4AFMenu.AppendMenu(MF_STRING | ((iThisFileItems > 0 && client && client->IsEd2kClient() && (content->type == AVAILABLE_SOURCE || client->IsSwapingDisabled()) ) ? MF_ENABLED : MF_GRAYED), MP_LOCK_CLIENT, GetResString((client && client->IsSwapingDisabled()) ? (content->owner == client->GetRequestFile() ? IDS_MP_UNLOCK_CLIENT : IDS_MP_UNLOCKFROM_CLIENT) : IDS_MP_LOCK_CLIENT), (client && client->IsSwapingDisabled()) ? _T("UNLOCK") : _T("LOCKTO"));
				A4AFMenu.AppendMenu(MF_STRING | ((iSelectedItems > 0 && client && client->IsEd2kClient()) ? MF_ENABLED : MF_GRAYED), MP_DROP_CLIENT, GetResString(IDS_DROP_CLIENT), _T("DROPCLIENT"));
				A4AFMenu.AppendMenu(MF_STRING | ((iLoadingItems > 0 && client && client->IsEd2kClient()) ? MF_ENABLED : MF_GRAYED), MP_STOP_CLIENT, GetResString(IDS_STOP_CLIENT), _T("STOPDOWNLOAD")); // X-Ray :: StopDownload

				ClientMenu.AppendMenu(MF_STRING | MF_POPUP, (UINT_PTR)A4AFMenu.m_hMenu, GetResString(IDS_SRC_MANAGEMENT), _T("MANAGECLIENT"));
			}
			// X-Ray :: ManualClientManagement :: End

			if (Kademlia::CKademlia::IsRunning() && !Kademlia::CKademlia::IsConnected())
				ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && client->GetKadPort()!=0) ? MF_ENABLED : MF_GRAYED), MP_BOOT, GetResString(IDS_BOOTSTRAP));
			ClientMenu.AppendMenu(MF_STRING | (GetItemCount() > 0 ? MF_ENABLED : MF_GRAYED), MP_FIND, GetResString(IDS_FIND), _T("Search"));

			// X-Ray :: ManualClientManagement :: Start
			/*
			CMenu A4AFMenu;
			A4AFMenu.CreateMenu();
			if (thePrefs.IsExtControlsEnabled()) {
// ZZ:DownloadManager -->
#ifdef _DEBUG
                if (content->type == UNAVAILABLE_SOURCE) {
                    A4AFMenu.AppendMenu(MF_STRING,MP_A4AF_CHECK_THIS_NOW,GetResString(IDS_A4AF_CHECK_THIS_NOW));
                }
# endif
// <-- ZZ:DownloadManager
				if (A4AFMenu.GetMenuItemCount()>0)
					ClientMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)A4AFMenu.m_hMenu, GetResString(IDS_A4AF));
			}
			*/
			// X-Ray :: ManualClientManagement :: End

			GetPopupMenuPos(*this, point);
			ClientMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON, point.x, point.y, this);
			
			VERIFY( A4AFMenu.DestroyMenu() );
			VERIFY( ClientMenu.DestroyMenu() );
		}
	}
	else{	// nothing selected
		int total;
		m_FileMenu.EnableMenuItem((UINT_PTR)m_PrioMenu.m_hMenu, MF_GRAYED);
		m_FileMenu.EnableMenuItem((UINT_PTR)m_PrioUpMenu.m_hMenu, MF_GRAYED); // X-Ray :: DLULPrioExtension
		m_FileMenu.EnableMenuItem((UINT_PTR)m_A4AFMenu.m_hMenu, MF_GRAYED); // X-Ray :: ManualClientManagement
		m_FileMenu.EnableMenuItem(MP_CANCEL, MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_PAUSE, MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_STOP, MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_RESUME, MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_FORCE, MF_GRAYED); // X-Ray :: OnlyDownloadCompleteFiles
		m_FileMenu.EnableMenuItem(MP_STANDBY, MF_GRAYED); // X-Ray :: StandbyDownload
		m_FileMenu.EnableMenuItem(MP_SUSPEND, MF_GRAYED); // X-Ray :: SuspendCollecting
		m_FileMenu.EnableMenuItem((UINT_PTR)m_DropMenu.m_hMenu, MF_GRAYED); // X-Ray :: DropSystem
		m_FileMenu.EnableMenuItem(MP_OPEN, MF_GRAYED);

		if (thePrefs.IsExtControlsEnabled() && !thePrefs.GetPreviewPrio()) {
			m_FileMenu.EnableMenuItem(MP_TRY_TO_GET_PREVIEW_PARTS, MF_GRAYED);
			m_FileMenu.CheckMenuItem(MP_TRY_TO_GET_PREVIEW_PARTS, MF_UNCHECKED);
        }
		m_FileMenu.EnableMenuItem(MP_PREVIEW, MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_METINFO, MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_VIEWFILECOMMENTS, MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_MASSRENAME, MF_GRAYED); // X-Ray :: MassRename
		m_FileMenu.EnableMenuItem(MP_IMPORT, MF_GRAYED); // X-Ray :: PartImportExport
		m_FileMenu.EnableMenuItem(MP_FILEFEEDBACK, MF_GRAYED); // X-Ray :: Filefeedback
		m_FileMenu.EnableMenuItem(MP_CLEARCOMPLETED, GetCompleteDownloads(curTab,total) > 0 ? MF_ENABLED : MF_GRAYED);
		m_FileMenu.EnableMenuItem(thePrefs.GetShowCopyEd2kLinkCmd() ? MP_GETED2KLINK : MP_SHOWED2KLINK, MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_PASTE, theApp.IsEd2kFileLinkInClipboard() ? MF_ENABLED : MF_GRAYED);
		m_FileMenu.SetDefaultItem((UINT)-1);
		if (m_SourcesMenu)
			m_FileMenu.EnableMenuItem((UINT_PTR)m_SourcesMenu.m_hMenu, MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_SEARCHRELATED, MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_FIND, GetItemCount() > 0 ? MF_ENABLED : MF_GRAYED);

		// also show the "Web Services" entry, even if its disabled and therefore not useable, it though looks a little 
		// less confusing this way.
		CTitleMenu WebMenu;
		WebMenu.CreateMenu();
		// X-Ray :: XPMenus :: Start
		/*
		WebMenu.AddMenuTitle(NULL, true);
		*/
		WebMenu.AddMenuTitle(NULL, true, true);
		// X-Ray :: XPMenus :: End
		theWebServices.GetFileMenuEntries(&WebMenu);
		m_FileMenu.AppendMenu(MF_POPUP | MF_GRAYED, (UINT_PTR)WebMenu.m_hMenu, GetResString(IDS_WEBSERVICES), _T("WEB"));

		GetPopupMenuPos(*this, point);
		m_FileMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON, point.x, point.y, this);
		m_FileMenu.RemoveMenu(m_FileMenu.GetMenuItemCount() - 1, MF_BYPOSITION);
		VERIFY( WebMenu.DestroyMenu() );
	}
}

BOOL CDownloadListCtrl::OnCommand(WPARAM wParam, LPARAM /*lParam*/)
{
	wParam = LOWORD(wParam);

	switch (wParam)
	{
		case MP_PASTE:
			if (theApp.IsEd2kFileLinkInClipboard())
				theApp.PasteClipboard(curTab);
			return TRUE;
		case MP_FIND:
			OnFindStart();
			return TRUE;
	}

	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	if (iSel == -1)
		iSel = GetNextItem(-1, LVIS_SELECTED);
	if (iSel != -1)
	{
		const CtrlItem_Struct* content = (CtrlItem_Struct*)GetItemData(iSel);
		if (content->type == FILE_TYPE)
		{
			//for multiple selections 
			UINT selectedCount = 0;
			CTypedPtrList<CPtrList, CPartFile*> selectedList; 
			POSITION pos = GetFirstSelectedItemPosition();
			// X-Ray :: Global Hardlimit :: Start
			UINT uGhlEnabled = 0;
			CPartFile* file = (CPartFile*)content->value;
			// X-Ray :: Global Hardlimit :: End
			while(pos != NULL) 
			{ 
				int index = GetNextSelectedItem(pos);
				if(index > -1) 
				{
					if (((const CtrlItem_Struct*)GetItemData(index))->type == FILE_TYPE)
					{
						selectedCount++;
						// X-Ray :: Global Hardlimit :: Start
						uGhlEnabled += file->GetGlobalHL() ? 1 : 0;
						// X-Ray :: Global Hardlimit :: End
						selectedList.AddTail((CPartFile*)((const CtrlItem_Struct*)GetItemData(index))->value);
					}
				} 
			} 

			// X-Ray :: Global Hardlimit :: Start
			/*
			CPartFile* file = (CPartFile*)content->value;
			*/
			// X-Ray :: Global Hardlimit :: End
			switch (wParam)
			{
				case MP_CANCEL:
				case MPG_DELETE: // keyboard del will continue to remove completed files from the screen while cancel will now also be available for complete files
				{
					if (selectedCount > 0)
					{
						SetRedraw(false);
						CString fileList;
						bool validdelete = false;
						bool removecompl = false;
						int cFiles = 0;
						for (pos = selectedList.GetHeadPosition(); pos != 0; )
						{
							CPartFile* cur_file = selectedList.GetNext(pos);
							if (cur_file->GetStatus() != PS_COMPLETING && (cur_file->GetStatus() != PS_COMPLETE || wParam == MP_CANCEL) ){
								validdelete = true;
								cFiles++;
								if (cFiles < 50)
									fileList.Append(_T("\n") + CString(cur_file->GetFileName()));
								else if(cFiles == 50)
									fileList.Append(_T("\n..."));
							}
							else if (cur_file->GetStatus() == PS_COMPLETE)
								removecompl = true;

						}
						CString quest;
						if (selectedCount == 1)
							quest = GetResString(IDS_Q_CANCELDL2);
						else
							quest = GetResString(IDS_Q_CANCELDL);
						if ((removecompl && !validdelete) || (validdelete && AfxMessageBox(quest + fileList, MB_DEFBUTTON2 | MB_ICONQUESTION | MB_YESNO) == IDYES))
						{
							bool bRemovedItems = false;
							while (!selectedList.IsEmpty())
							{
								HideSources(selectedList.GetHead());
								switch (selectedList.GetHead()->GetStatus())
								{
									case PS_WAITINGFORHASH:
									case PS_HASHING:
									case PS_COMPLETING:
									case PS_IMPORTING: // X-Ray :: PartImportExport
										selectedList.RemoveHead();
										bRemovedItems = true;
										break;
									case PS_COMPLETE:
										if (wParam == MP_CANCEL){
											BOOL delsucc = FALSE;
											if (!PathFileExists(selectedList.GetHead()->GetFilePath()))
												delsucc = TRUE;
											else{
												// Delete
												if (!thePrefs.GetRemoveToBin()){
													delsucc = DeleteFile(selectedList.GetHead()->GetFilePath());
												}
												else{
													// delete to recycle bin :(
													TCHAR todel[MAX_PATH+1];
													memset(todel, 0, sizeof todel);
													_tcsncpy(todel, selectedList.GetHead()->GetFilePath(), ARRSIZE(todel)-2);

													SHFILEOPSTRUCT fp = {0};
													fp.wFunc = FO_DELETE;
													fp.hwnd = theApp.emuledlg->m_hWnd;
													fp.pFrom = todel;
													fp.fFlags = FOF_ALLOWUNDO | FOF_NOCONFIRMATION | FOF_SILENT;// | FOF_NOERRORUI
													delsucc = (SHFileOperation(&fp) == 0);
												}
											}
											if (delsucc){
												theApp.sharedfiles->RemoveFile(selectedList.GetHead());
											}
											else{
												CString strError;
												strError.Format( GetResString(IDS_ERR_DELFILE) + _T("\r\n\r\n%s"), selectedList.GetHead()->GetFilePath(), GetErrorMessage(GetLastError()));
												AfxMessageBox(strError);
											}
										}
										RemoveFile(selectedList.GetHead());
										selectedList.RemoveHead();
										bRemovedItems = true;
										break;
									case PS_PAUSED:
										selectedList.GetHead()->DeleteFile();
										selectedList.RemoveHead();
										bRemovedItems = true;
										break;
									default:
										if (selectedList.GetHead()->GetCategory())
											theApp.downloadqueue->StartNextFileIfPrefs(selectedList.GetHead()->GetCategory());
										selectedList.GetHead()->DeleteFile();
										selectedList.RemoveHead();
										bRemovedItems = true;
										break; // X-Ray :: FiXeS :: Codefix :: WiZaRd
								}
							}
							if (bRemovedItems)
							{
								AutoSelectItem();
								theApp.emuledlg->transferwnd->UpdateCatTabTitles();
							}
						}
						SetRedraw(true);
					}
					break;
				}
				case MP_PRIOHIGH:
					SetRedraw(false);
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						partfile->SetAutoDownPriority(false);
						partfile->SetDownPriority(PR_HIGH);
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				case MP_PRIOLOW:
					SetRedraw(false);
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						partfile->SetAutoDownPriority(false);
						partfile->SetDownPriority(PR_LOW);
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				case MP_PRIONORMAL:
					SetRedraw(false);
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						partfile->SetAutoDownPriority(false);
						partfile->SetDownPriority(PR_NORMAL);
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				case MP_PRIOAUTO:
					SetRedraw(false);
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						partfile->SetAutoDownPriority(true);
						partfile->SetDownPriority(PR_HIGH);
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;

				// X-Ray :: DropSystem :: Start
				case MP_DROPLOWTOLOWIPSRCS:
				case MP_DROPUNKNOWNSRCS:
				case MP_DROPNONEEDEDSRCS:
				case MP_DROPFULLQSRCS:
				case MP_DROPHIGHQRSRCS:
				case MP_DROPTOOMANYCONNSRCS:
				case MP_DROPSENSELESSSRCS:
					SetRedraw(false);
					while(!selectedList.IsEmpty()){ 
						switch (wParam) {
							case MP_DROPLOWTOLOWIPSRCS:
								selectedList.GetHead()->RemoveLow2LowIPSourcesManual();
								break;
							case MP_DROPUNKNOWNSRCS:
								selectedList.GetHead()->RemoveUnknownSourcesManual();
								break;
							case MP_DROPNONEEDEDSRCS:
								selectedList.GetHead()->RemoveNoNeededSourcesManual();
								break;
							case MP_DROPFULLQSRCS:
								selectedList.GetHead()->RemoveFullQueueSourcesManual();
								break;
							case MP_DROPHIGHQRSRCS:
								selectedList.GetHead()->RemoveHighQRSourcesManual();
								break;
							case MP_DROPTOOMANYCONNSRCS:
								selectedList.GetHead()->RemoveTooManyConnectionsSourcesManual();
								break;
							case MP_DROPSENSELESSSRCS:
								selectedList.GetHead()->RemoveAllSenselessSourcesManual();
								break;
						}
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				// X-Ray :: DropSystem :: End

				// X-Ray :: DLULPrioExtension :: Start
				case MP_PRIOUPVERYLOW:
				case MP_PRIOUPLOW:
				case MP_PRIOUPNORMAL:
				case MP_PRIOUPHIGH:
				case MP_PRIOUPVERYHIGH:
				case MP_PRIOUPAUTO:
					SetRedraw(false);
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						switch (wParam) {
							case MP_PRIOUPVERYLOW:
								partfile->SetAutoUpPriority(false);
								partfile->SetUpPriority(PR_VERYLOW);
								break;
							case MP_PRIOUPLOW:
								partfile->SetAutoUpPriority(false);
								partfile->SetUpPriority(PR_LOW);
								break;
							case MP_PRIOUPNORMAL:
								partfile->SetAutoUpPriority(false);
								partfile->SetUpPriority(PR_NORMAL);
								break;
							case MP_PRIOUPHIGH:
								partfile->SetAutoUpPriority(false);
								partfile->SetUpPriority(PR_HIGH);
								break;
							case MP_PRIOUPVERYHIGH:
								partfile->SetAutoUpPriority(false);
								partfile->SetUpPriority(PR_VERYHIGH);
								break;	
							case MP_PRIOUPAUTO:
								partfile->SetAutoUpPriority(true);
								partfile->UpdateAutoUpPriority();
								break;
						}
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				// X-Ray :: DLULPrioExtension :: End

				// X-Ray :: PartImportExport :: Start
				case MP_IMPORT:
					if(selectedCount > 1)
						break;
					file->ImportParts();
					break;
				// X-Ray :: PartImportExport :: End

				// X-Ray :: MassRename :: Start
				case MP_MASSRENAME:
				{
					CMassRenameDialog* MRDialog = new CMassRenameDialog;
					// Add the files to the dialog
					POSITION pos = selectedList.GetHeadPosition();
					while(pos != NULL) {
						CKnownFile* file = selectedList.GetAt(pos);
						MRDialog->m_FileList.AddTail(file);
						selectedList.GetNext(pos);
					}
					MRDialog->OpenDialog();
					break;
				}
				// X-Ray :: MassRename :: End

				// X-Ray :: OnlyDownloadCompleteFiles :: Start
				case MP_FORCE:{
					SetRedraw(false);
					bool bNewState = !file->GetForced();
					while (!selectedList.IsEmpty()){
						selectedList.GetHead()->SetForced(bNewState);
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				}
				// X-Ray :: OnlyDownloadCompleteFiles :: End
				
				// X-Ray :: StandbyDownload :: Start
				case MP_STANDBY:{
					SetRedraw(false);
					bool bNewState = !file->GetStandBy();
					while (!selectedList.IsEmpty()){
						selectedList.GetHead()->SetStandBy(bNewState);
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				}
				// X-Ray :: StandbyDownload :: End

				// X-Ray :: SuspendCollecting :: Start
				case MP_SUSPEND:{
					SetRedraw(false);
					bool bNewState = !file->GetSuspend();
					while (!selectedList.IsEmpty()){
						selectedList.GetHead()->SetSuspend(bNewState);
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				}
				// X-Ray :: SuspendCollecting :: End

				// X-Ray :: Filefeedback :: Start
				case MP_FILEFEEDBACK:
					{
						CString strFeed = L"";
						POSITION pos = selectedList.GetHeadPosition();
						while (pos != NULL){
							CKnownFile* file = selectedList.GetNext(pos);
							strFeed.Append(file->GetFileFeedback());
							strFeed.Append(_T("\r\n"));
						}
						theApp.CopyTextToClipboard(strFeed);
						break;
					}
				// X-Ray :: Filefeedback :: End

				case MP_PAUSE:
					SetRedraw(false);
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						if (partfile->CanPauseFile())
							partfile->PauseFile();
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				case MP_RESUME:
					SetRedraw(false);
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						if (partfile->CanResumeFile()){
							if (partfile->GetStatus() == PS_INSUFFICIENT)
								partfile->ResumeFileInsufficient();
							else
								partfile->ResumeFile();
						}
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					break;
				case MP_STOP:
					SetRedraw(false);
					while (!selectedList.IsEmpty()){
						CPartFile *partfile = selectedList.GetHead();
						if (partfile->CanStopFile()){
							HideSources(partfile);
							partfile->StopFile();
						}
						selectedList.RemoveHead();
					}
					SetRedraw(true);
					theApp.emuledlg->transferwnd->UpdateCatTabTitles();
					break;
				case MP_CLEARCOMPLETED:
					SetRedraw(false);
					ClearCompleted();
					SetRedraw(true);
					break;
				case MPG_F2:
					if (GetAsyncKeyState(VK_CONTROL) < 0 || selectedCount > 1) {
						// when ctrl is pressed -> filename cleanup
						if (IDYES==AfxMessageBox(GetResString(IDS_MANUAL_FILENAMECLEANUP),MB_YESNO))
							while (!selectedList.IsEmpty()){
								CPartFile *partfile = selectedList.GetHead();
								if (partfile->IsPartFile()) {
									partfile->SetFileName(CleanupFilename(partfile->GetFileName()));
								}
								selectedList.RemoveHead();
							}
					} else {
						if (file->GetStatus() != PS_COMPLETE && file->GetStatus() != PS_COMPLETING)
						{
							InputBox inputbox;
							CString title = GetResString(IDS_RENAME);
							title.Remove(_T('&'));
							inputbox.SetLabels(title, GetResString(IDS_DL_FILENAME), file->GetFileName());
							inputbox.SetEditFilenameMode();
							if (inputbox.DoModal()==IDOK && !inputbox.GetInput().IsEmpty() && IsValidEd2kString(inputbox.GetInput()))
							{
								file->SetFileName(inputbox.GetInput(), true);
								file->UpdateDisplayedInfo();
								file->SavePartFile();
							}
						}
						else
							MessageBeep(MB_OK);
					}
					break;
				case MP_METINFO:
				case MPG_ALTENTER:
					ShowFileDialog(0);
					break;
				case MP_COPYSELECTED:
				case MP_GETED2KLINK:{
					CString str;
					while (!selectedList.IsEmpty()){
						if (!str.IsEmpty())
							str += _T("\r\n");
						str += CreateED2kLink(selectedList.GetHead());
						selectedList.RemoveHead();
					}
					theApp.CopyTextToClipboard(str);
					break;
				}
				case MP_SEARCHRELATED:
					theApp.emuledlg->searchwnd->SearchRelatedFiles(selectedList);
					theApp.emuledlg->SetActiveDialog(theApp.emuledlg->searchwnd);
					break;
				case MP_OPEN:
				case IDA_ENTER:
					if (selectedCount > 1)
						break;
					if (file->CanOpenFile())
						file->OpenFile();
					break;
				case MP_TRY_TO_GET_PREVIEW_PARTS:
					if (selectedCount > 1)
						break;
                    file->SetPreviewPrio(!file->GetPreviewPrio());
                    break;
				case MP_PREVIEW:
					if (selectedCount > 1)
						break;
					file->PreviewFile();
					break;
				case MP_VIEWFILECOMMENTS:
					ShowFileDialog(IDD_COMMENTLST);
					break;
				case MP_SHOWED2KLINK:
					ShowFileDialog(IDD_ED2KLINK);
					break;
				case MP_SETSOURCELIMIT: {
					CString temp;
					temp.Format(_T("%u"),file->GetPrivateMaxSources());
					InputBox inputbox;
					CString title = GetResString(IDS_SETPFSLIMIT);
					inputbox.SetLabels(title, GetResString(IDS_SETPFSLIMITEXPLAINED), temp );

					if (inputbox.DoModal() == IDOK)
					{
						temp = inputbox.GetInput();
						int newlimit = _tstoi(temp);
						while (!selectedList.IsEmpty()){
							CPartFile *partfile = selectedList.GetHead();
							partfile->SetPrivateMaxSources(newlimit);
							selectedList.RemoveHead();
							partfile->UpdateDisplayedInfo(true);
						}
					}
					break;
				}
				case MP_ADDSOURCE: {
					if (selectedCount > 1)
						break;
					// X-Ray :: ModelessDialogs :: Start
					/*
					CAddSourceDlg as;
					as.SetFile(file);
					as.DoModal();
					*/
					CAddSourceDlg* dlg = new CAddSourceDlg();
					dlg->SetFile(file);
					dlg->OpenDialog();
					// X-Ray :: ModelessDialogs :: End
					break;
				}
				// X-Ray :: Global Hardlimit :: Start
				case MP_GLOBALHL: {
					if(selectedCount > 0)
					{
						bool bNew = uGhlEnabled == selectedCount;
						while (!selectedList.IsEmpty()){
							CPartFile *partfile = selectedList.GetHead();
							partfile->SetGlobalHL(!bNew);
							selectedList.RemoveHead();
						}
					}
					break;
				}
				// X-Ray :: Global Hardlimit :: End

				// X-Ray :: ManualClientManagement :: Start
				case MP_SWAP_TO_A4AF:
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						partfile->CollectAllA4AF();
						selectedList.RemoveHead();
					}
					break;
				case MP_SWAP_FROM_A4AF:
					while (!selectedList.IsEmpty()){
						CPartFile* partfile = selectedList.GetHead();
						partfile->ReleaseAllA4AF();
						selectedList.RemoveHead();
					}
					break;
				// X-Ray :: ManualClientManagement :: End

				default:
					if (wParam>=MP_WEBURL && wParam<=MP_WEBURL+99){
						theWebServices.RunURL(file, wParam);
					}
					else if (wParam>=MP_ASSIGNCAT && wParam<=MP_ASSIGNCAT+99){
						SetRedraw(FALSE);
						while (!selectedList.IsEmpty()){
							CPartFile *partfile = selectedList.GetHead();
							partfile->SetCategory(wParam - MP_ASSIGNCAT);
							partfile->UpdateDisplayedInfo(true);
							selectedList.RemoveHead();
						}
						SetRedraw(TRUE);
						UpdateCurrentCategoryView();
						if (thePrefs.ShowCatTabInfos())
							theApp.emuledlg->transferwnd->UpdateCatTabTitles();
					}
					else if (wParam>=MP_PREVIEW_APP_MIN && wParam<=MP_PREVIEW_APP_MAX){
						thePreviewApps.RunApp(file, wParam);
					}
					break;
			}
		}
		else{
			CUpDownClient* client = (CUpDownClient*)content->value;

			// X-Ray :: ManualClientManagement :: Start
			CPartFile* file = (CPartFile*)content->owner;
			UINT selectedCount = 0;
			CTypedPtrList<CPtrList, CUpDownClient*> selectedList; 
			POSITION pos = GetFirstSelectedItemPosition();
			while(pos != NULL) 
			{ 
				int index = GetNextSelectedItem(pos);
				if(index > -1) {
					if (((const CtrlItem_Struct*)GetItemData(index))->type != FILE_TYPE){
						selectedCount++;
						selectedList.AddTail((CUpDownClient*)((const CtrlItem_Struct*)GetItemData(index))->value);
					}
				}
			}
			// X-Ray :: ManualClientManagement :: End

			switch (wParam){
				case MP_SHOWLIST:
					client->RequestSharedFileList();
					break;
				case MP_MESSAGE:
					theApp.emuledlg->chatwnd->StartSession(client);
					break;
				case MP_ADDFRIEND:
					if (theApp.friendlist->AddFriend(client))
						UpdateItem(client);
					break;
				case MP_DETAIL:
				case MPG_ALTENTER:
					ShowClientDialog(client);
					break;
				case MP_BOOT:
					if (client->GetKadPort())
						Kademlia::CKademlia::Bootstrap(ntohl(client->GetIP()), client->GetKadPort(), (client->GetKadVersion() > 1));
					break;
				// X-Ray :: StopDownload :: Start
				case MP_STOP_CLIENT: 
					while (!selectedList.IsEmpty()){
						StopSingleClient(client);
						selectedList.RemoveHead();
					}
					break;
				// X-Ray :: StopDownload :: End

				// X-Ray :: ManualClientManagement :: Start
				/*
// ZZ:DownloadManager -->
#ifdef _DEBUG
				case MP_A4AF_CHECK_THIS_NOW: {
					CPartFile* file = (CPartFile*)content->owner;
					if (file->GetStatus(false) == PS_READY || file->GetStatus(false) == PS_EMPTY)
					{
						if (client->GetDownloadState() != DS_DOWNLOADING)
						{
							client->SwapToAnotherFile(_T("Manual init of source check. Test to be like ProcessA4AFClients(). CDownloadListCtrl::OnCommand() MP_SWAP_A4AF_DEBUG_THIS"), false, false, false, NULL, true, true, true); // ZZ:DownloadManager
							UpdateItem(file);
						}
					}
					break;
				}
#endif
// <-- ZZ:DownloadManager
				*/
				case MP_SWAP_TO_CLIENT:
					while (!selectedList.IsEmpty()){
						if (selectedList.GetHead()->GetDownloadState() != DS_DOWNLOADING && selectedList.GetHead()->GetRequestFile() != file)
						{
							selectedList.GetHead()->DoSwap(file, false, _T("Manual: Swap to this File"),true); // ZZ:DownloadManager
							UpdateItem(file);
						}
						selectedList.RemoveHead();
					}
					break;
				case MP_SWAP_FROM_CLIENT:
					while (!selectedList.IsEmpty()){
						if (selectedList.GetHead()->GetDownloadState() != DS_DOWNLOADING && selectedList.GetHead()->GetRequestFile() == file)
						{
							selectedList.GetHead()->SwapToAnotherFile(_T("Manual: Swap to an Other File"), false, true, false, NULL, true, true, true); // ZZ:DownloadManager
							UpdateItem(file);
						}
						selectedList.RemoveHead();
					}
					break;
				case MP_LOCK_CLIENT:
					while (!selectedList.IsEmpty() && selectedList.GetHead()->GetRequestFile() == file){
						selectedList.GetHead()->DisableSwaping(!client->IsSwapingDisabled());
						UpdateItem(file);
						selectedList.RemoveHead();
					}
					break;
				case MP_DROP_CLIENT:
					while (!selectedList.IsEmpty()){
						theApp.downloadqueue->RemoveSource(selectedList.GetHead());
						selectedList.RemoveHead();
					}
					break;
				// X-Ray :: ManualClientManagement :: End
			}
		}
	}
	else /*nothing selected*/
	{
		switch (wParam){
			case MP_CLEARCOMPLETED:
				ClearCompleted();
				break;
		}
	}

	return TRUE;
}

void CDownloadListCtrl::OnColumnClick( NMHDR* pNMHDR, LRESULT* pResult){
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	// Barry - Store sort order in preferences
	// Determine ascending based on whether already sorted on this column
	int sortItem = GetSortItem();
	bool m_oldSortAscending = GetSortAscending();

	if (sortItem==9) {
		m_bRemainSort=(sortItem != pNMListView->iSubItem) ? false : (m_oldSortAscending?m_bRemainSort:!m_bRemainSort);
	}

	bool sortAscending = (sortItem != pNMListView->iSubItem) ? true : !m_oldSortAscending;
	
	// Item is column clicked
	sortItem = pNMListView->iSubItem;
	UpdateSortHistory(sortItem + (sortAscending ? 0:100), 100);
	
	// Save new preferences
	thePrefs.TransferlistRemainSortStyle(m_bRemainSort);
	
	// Sort table
	uint8 adder=0;
	if (sortItem!=9 || !m_bRemainSort)
		SetSortArrow(sortItem, sortAscending);
	else {
        SetSortArrow(sortItem, sortAscending?arrowDoubleUp : arrowDoubleDown);
		adder=81;
	}
	

	SortItems(SortProc, sortItem + (sortAscending ? 0:100) + adder );

	*pResult = 0;
}

int CDownloadListCtrl::SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort){
	CtrlItem_Struct* item1 = (CtrlItem_Struct*)lParam1;
	CtrlItem_Struct* item2 = (CtrlItem_Struct*)lParam2;

	int dwOrgSort = lParamSort;

	int sortMod = 1;
	if(lParamSort >= 100) 
	{
		sortMod = -1;
		lParamSort -= 100;
	}

	int comp;

	if(item1->type == FILE_TYPE && item2->type != FILE_TYPE) 
	{
		if(item1->value == item2->parent->value)
			return -1;
		comp = Compare((CPartFile*)item1->value, (CPartFile*)(item2->parent->value), lParamSort);
	}
	else if(item2->type == FILE_TYPE && item1->type != FILE_TYPE) 
	{
		if(item1->parent->value == item2->value)
			return 1;
		comp = Compare((CPartFile*)(item1->parent->value), (CPartFile*)item2->value, lParamSort);
	}
	else if (item1->type == FILE_TYPE) 
	{
		CPartFile* file1 = (CPartFile*)item1->value;
		CPartFile* file2 = (CPartFile*)item2->value;
		comp = Compare(file1, file2, lParamSort);
	}
	else
	{
		if (item1->parent->value!=item2->parent->value) 
		{
			comp = Compare((CPartFile*)(item1->parent->value), (CPartFile*)(item2->parent->value), lParamSort);
			return sortMod * comp;
		}
		if (item1->type != item2->type)
			return item1->type - item2->type;

		CUpDownClient* client1 = (CUpDownClient*)item1->value;
		CUpDownClient* client2 = (CUpDownClient*)item2->value;
		comp = Compare(client1, client2, lParamSort);
	}
	int dwNextSort;
	//call secondary sortorder, if this one results in equal
	//(Note: yes I know this call is evil OO wise, but better than changing a lot more code, while we have only one instance anyway - might be fixed later)
	if (comp == 0 && (dwNextSort = theApp.emuledlg->transferwnd->downloadlistctrl.GetNextSortOrder(dwOrgSort)) != (-1)){
		return SortProc(lParam1, lParam2, dwNextSort);
	}
	else
		return sortMod * comp;
}

void CDownloadListCtrl::ClearCompleted(int incat){
	if (incat==-2)
		incat=curTab;

	// Search for completed file(s)
	for(ListItems::iterator it = m_ListItems.begin(); it != m_ListItems.end(); ){
		CtrlItem_Struct* cur_item = it->second;
		it++; // Already point to the next iterator. 
		if(cur_item->type == FILE_TYPE){
			CPartFile* file = reinterpret_cast<CPartFile*>(cur_item->value);
			if(file->IsPartFile() == false && (file->CheckShowItemInGivenCat(incat) || incat==-1) ){
				if (RemoveFile(file))
					it = m_ListItems.begin();
			}
		}
	}
	if (thePrefs.ShowCatTabInfos())
		theApp.emuledlg->transferwnd->UpdateCatTabTitles();
}

void CDownloadListCtrl::ClearCompleted(const CPartFile* pFile)
{
	if (!pFile->IsPartFile())
	{
		for (ListItems::iterator it = m_ListItems.begin(); it != m_ListItems.end(); )
		{
			CtrlItem_Struct* cur_item = it->second;
			it++;
			if (cur_item->type == FILE_TYPE)
			{
				const CPartFile* pCurFile = reinterpret_cast<CPartFile*>(cur_item->value);
				if (pCurFile == pFile)
				{
					RemoveFile(pCurFile);
					return;
				}
			}
		}
	}
}

void CDownloadListCtrl::SetStyle()
{
	if (thePrefs.IsDoubleClickEnabled())
		SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_INFOTIP);
	else
		SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_INFOTIP | LVS_EX_ONECLICKACTIVATE);
}

void CDownloadListCtrl::OnListModified(NMHDR* pNMHDR, LRESULT* /*pResult*/)
{
	NM_LISTVIEW *pNMListView = (NM_LISTVIEW*)pNMHDR;

	//this works because true is equal to 1 and false equal to 0
	BOOL notLast = pNMListView->iItem + 1 != GetItemCount();
	BOOL notFirst = pNMListView->iItem != 0;
	RedrawItems(pNMListView->iItem - notFirst, pNMListView->iItem + notLast);
}

int CDownloadListCtrl::Compare(const CPartFile* file1, const CPartFile* file2, LPARAM lParamSort)
{
	int comp=0;
	switch(lParamSort)
	{
		case 0: //filename asc
			comp=CompareLocaleStringNoCase(file1->GetFileName(),file2->GetFileName());
			break;
		case 1: //size asc
			comp=CompareUnsigned64(file1->GetFileSize(), file2->GetFileSize());
			break;
		case 2: //transferred asc
			comp=CompareUnsigned64(file1->GetTransferred(), file2->GetTransferred());
			break;
		case 3: //completed asc
			comp=CompareUnsigned64(file1->GetCompletedSize(), file2->GetCompletedSize());
			break;
		case 4: //speed asc
			comp=CompareUnsigned(file1->GetDatarate(), file2->GetDatarate());
			break;
		case 5: //progress asc
			comp = CompareFloat(file1->GetPercentCompleted(), file2->GetPercentCompleted());
			break;
		case 6: //sources asc
			comp=CompareUnsigned(file1->GetSourceCount(), file2->GetSourceCount());
			break;
		case 7: //priority asc
			comp=CompareUnsigned(file1->GetDownPriority(), file2->GetDownPriority());
			break;
		case 8: //Status asc 
			comp=CompareUnsigned(file1->getPartfileStatusRang(),file2->getPartfileStatusRang());
			break;
		case 9: //Remaining Time asc
		{
			//Make ascending sort so we can have the smaller remaining time on the top 
			//instead of unknowns so we can see which files are about to finish better..
			time_t f1 = file1->getTimeRemaining();
			time_t f2 = file2->getTimeRemaining();
			//Same, do nothing.
			if( f1 == f2 ) 
			{
				comp=0;
				break;
			}
			//If descending, put first on top as it is unknown
			//If ascending, put first on bottom as it is unknown
			if( f1 == -1 ) 
			{
				comp=1;
				break;
			}
			//If descending, put second on top as it is unknown
			//If ascending, put second on bottom as it is unknown
			if( f2 == -1 ) 
			{
				comp=-1;
				break;
			}
			//If descending, put first on top as it is bigger.
			//If ascending, put first on bottom as it is bigger.
			comp = CompareUnsigned(f1, f2);
			break;
		}
		case 90: //Remaining SIZE asc
			comp=CompareUnsigned64(file1->GetFileSize()-file1->GetCompletedSize(), file2->GetFileSize()-file2->GetCompletedSize());
			break;
		case 10: //last seen complete asc
			if (file1->lastseencomplete > file2->lastseencomplete)
				comp=1;
			else if(file1->lastseencomplete < file2->lastseencomplete)
				comp=-1;
			else
				comp=0;
			break;
		case 11: //last received Time asc
			if (file1->GetFileDate() > file2->GetFileDate())
				comp=1;
			else if(file1->GetFileDate() < file2->GetFileDate())
				comp=-1;
			else
				comp=0;
			break;
		case 12:
			//TODO: 'GetCategory' SHOULD be a 'const' function and 'GetResString' should NOT be called..
			comp=CompareLocaleStringNoCase(	(const_cast<CPartFile*>(file1)->GetCategory()!=0)?thePrefs.GetCategory(const_cast<CPartFile*>(file1)->GetCategory())->strTitle:GetResString(IDS_ALL),
											(const_cast<CPartFile*>(file2)->GetCategory()!=0)?thePrefs.GetCategory(const_cast<CPartFile*>(file2)->GetCategory())->strTitle:GetResString(IDS_ALL) );
			break;
		// X-Ray :: Sourcecache :: Start
		case 14:
			comp = CompareUnsigned(file1->GetSourceCacheAmount(), file2->GetSourceCacheAmount());
			break;
		// X-Ray :: Sourcecache :: End
		default:
			comp=0;
	}
	return comp;
 }

int CDownloadListCtrl::Compare(const CUpDownClient *client1, const CUpDownClient *client2, LPARAM lParamSort)
{
	switch (lParamSort)
	{
	case 0: //name asc
		if (client1->GetUserName() == client2->GetUserName())
			return 0;
		else if (!client1->GetUserName())	// place clients with no usernames at bottom
			return 1;
		else if (!client2->GetUserName())	// place clients with no usernames at bottom
			return -1;
		return CompareLocaleStringNoCase(client1->GetUserName(), client2->GetUserName());

	case 1: //size but we use status asc
		return client1->GetSourceFrom() - client2->GetSourceFrom();

	case 2://transferred asc
	case 3://completed asc
		return CompareUnsigned(client1->GetTransferredDown(), client2->GetTransferredDown());

	case 4: //speed asc
		return CompareUnsigned(client1->GetDownloadDatarate(), client2->GetDownloadDatarate());

	case 5: //progress asc
		return CompareUnsigned(client1->GetAvailablePartCount(), client2->GetAvailablePartCount());

	case 6:
		// X-Ray :: ModID :: Start
		/*
		if (client1->GetClientSoft() == client2->GetClientSoft())
			return CompareUnsigned(client2->GetVersion(), client1->GetVersion());
		return CompareUnsigned(client1->GetClientSoft(), client2->GetClientSoft());
		*/
		if (client1->GetClientSoft() != client2->GetClientSoft())
			return CompareUnsigned(client1->GetClientSoft(), client2->GetClientSoft());
		if (client1->GetVersion() != client2->GetVersion())
			return CompareUnsigned(client2->GetVersion(), client1->GetVersion());
		return CompareLocaleStringNoCase(client2->GetClientModVer(), client1->GetClientModVer());
		// X-Ray :: ModID :: End
	case 7: //qr asc
		if (client1->GetDownloadState() == DS_DOWNLOADING){
			if (client2->GetDownloadState() == DS_DOWNLOADING)
				return 0;
			else
				return -1;
		}
		else if (client2->GetDownloadState() == DS_DOWNLOADING)
			return 1;
		if (client1->GetRemoteQueueRank() == 0 
			&& client1->GetDownloadState() == DS_ONQUEUE && client1->IsRemoteQueueFull() == true)
			return 1;
		if (client2->GetRemoteQueueRank() == 0 
			&& client2->GetDownloadState() == DS_ONQUEUE && client2->IsRemoteQueueFull() == true)
			return -1;
		if (client1->GetRemoteQueueRank() == 0)
			return 1;
		if (client2->GetRemoteQueueRank() == 0)
			return -1;
		return CompareUnsigned(client1->GetRemoteQueueRank(), client2->GetRemoteQueueRank());

	case 8:
		if (client1->GetDownloadState() == client2->GetDownloadState()){
			if (client1->IsRemoteQueueFull() && client2->IsRemoteQueueFull())
				return 0;
			else if (client1->IsRemoteQueueFull())
				return 1;
			else if (client2->IsRemoteQueueFull())
				return -1;
		}
		return client1->GetDownloadState() - client2->GetDownloadState();

	// X-Ray :: QRETA :: Start
	case 9:
		if (client1->GetQueueRankETA()){
			if (client2->GetQueueRankETA()){
				if (client1->GetQueueRankETA() < client2->GetQueueRankETA())
					return -1;
				else if (client1->GetQueueRankETA() > client2->GetQueueRankETA())
					return 1;
				else
					return 0;
			} else
				return 1;
		} else if (client2->GetQueueRankETA())
			return -1;
		else
			return 0;
	// X-Ray :: QRETA :: End

	// X-Ray :: Argos :: Start
	case 12:
		return wcscmp(theApp.argos->GetArgosString(client1), theApp.argos->GetArgosString(client2));
	// X-Ray :: Argos :: End

	// X-Ray :: IP2Country :: Start
	case 13:
		return CompareLocaleStringNoCase(client1->GetCountryName(true), client1->GetCountryName(true));
	// X-Ray :: IP2Country :: End

	default:
		return 0;
	}
}

void CDownloadListCtrl::OnNMDblclkDownloadlist(NMHDR* /*pNMHDR*/, LRESULT* pResult)
{
	int iSel = GetSelectionMark();
	if (iSel != -1)
	{
		const CtrlItem_Struct* content = (CtrlItem_Struct*)GetItemData(iSel);
		if (content && content->value)
		{
			if (content->type == FILE_TYPE)
			{
				if (!thePrefs.IsDoubleClickEnabled())
				{
					CPoint pt;
					::GetCursorPos(&pt);
					ScreenToClient(&pt);
					LVHITTESTINFO hit;
					hit.pt = pt;
					if (HitTest(&hit) >= 0 && (hit.flags & LVHT_ONITEM))
					{
						LVHITTESTINFO subhit;
						subhit.pt = pt;
						if (SubItemHitTest(&subhit) >= 0 && subhit.iSubItem == 0)
						{
							CPartFile* file = (CPartFile*)content->value;
							if (thePrefs.ShowRatingIndicator() 
								&& (file->HasComment() || file->HasRating() || file->IsKadCommentSearchRunning()) 
								&& pt.x >= FILE_ITEM_MARGIN_X+theApp.GetSmallSytemIconSize().cx 
								&& pt.x <= FILE_ITEM_MARGIN_X+theApp.GetSmallSytemIconSize().cx+RATING_ICON_WIDTH)
								ShowFileDialog(IDD_COMMENTLST);
							else if (thePrefs.GetPreviewOnIconDblClk()
									 && pt.x >= FILE_ITEM_MARGIN_X 
									 && pt.x < FILE_ITEM_MARGIN_X+theApp.GetSmallSytemIconSize().cx) {
								if (file->IsReadyForPreview())
									file->PreviewFile();
								else
									MessageBeep(MB_OK);
							}
							else
								ShowFileDialog(0);
						}
					}
				}
			}
			else
			{
				ShowClientDialog((CUpDownClient*)content->value);
			}
		}
	}
	
	*pResult = 0;
}

void CDownloadListCtrl::CreateMenues()
{
	// X-Ray :: DropSystem :: Start
	if (m_DropMenu)
		VERIFY( m_DropMenu.DestroyMenu() );
	// X-Ray :: DropSystem :: End

	// X-Ray :: DLULPrioExtension :: Start
	if (m_PrioUpMenu)
		VERIFY( m_PrioUpMenu.DestroyMenu() );
	// X-Ray :: DLULPrioExtension :: End

	// X-Ray :: ManualClientManagement :: Start
	if (m_A4AFMenu)
		VERIFY( m_A4AFMenu.DestroyMenu() );
	// X-Ray :: ManualClientManagement :: End

	if (m_PrioMenu)
		VERIFY( m_PrioMenu.DestroyMenu() );
	if (m_SourcesMenu)
		VERIFY( m_SourcesMenu.DestroyMenu() );
	if (m_FileMenu)
		VERIFY( m_FileMenu.DestroyMenu() );

	m_FileMenu.CreatePopupMenu();
	// X-Ray :: XPMenus :: Start
	/*
	m_FileMenu.AddMenuTitle(GetResString(IDS_DOWNLOADMENUTITLE), true);
	*/
	m_FileMenu.AddMenuTitle(GetResString(IDS_DOWNLOADMENUTITLE), true, true, true);
	// X-Ray :: XPMenus :: End

	// Add 'Download Priority' sub menu
	//
	m_PrioMenu.CreateMenu();
	m_PrioMenu.AddMenuTitle(NULL, true); // X-Ray :: MOD
	m_PrioMenu.AppendMenu(MF_STRING, MP_PRIOLOW, GetResString(IDS_PRIOLOW));
	m_PrioMenu.AppendMenu(MF_STRING, MP_PRIONORMAL, GetResString(IDS_PRIONORMAL));
	m_PrioMenu.AppendMenu(MF_STRING, MP_PRIOHIGH, GetResString(IDS_PRIOHIGH));
	m_PrioMenu.AppendMenu(MF_STRING, MP_PRIOAUTO, GetResString(IDS_PRIOAUTO));
	m_FileMenu.AppendMenu(MF_STRING|MF_POPUP, (UINT_PTR)m_PrioMenu.m_hMenu, GetResString(IDS_PRIORITY) + _T(" (") + GetResString(IDS_DOWNLOAD) + _T(")"), _T("FILEPRIORITYDOWN")); // X-Ray :: MOD

	// X-Ray :: DLULPrioExtension :: Start
	m_PrioUpMenu.CreateMenu();
	m_PrioUpMenu.AddMenuTitle(NULL, true);
	m_PrioUpMenu.AppendMenu(MF_STRING, MP_PRIOUPVERYLOW, GetResString(IDS_PRIOVERYLOW));
	m_PrioUpMenu.AppendMenu(MF_STRING, MP_PRIOUPLOW, GetResString(IDS_PRIOLOW));
	m_PrioUpMenu.AppendMenu(MF_STRING, MP_PRIOUPNORMAL, GetResString(IDS_PRIONORMAL));
	m_PrioUpMenu.AppendMenu(MF_STRING, MP_PRIOUPHIGH, GetResString(IDS_PRIOHIGH));
	m_PrioUpMenu.AppendMenu(MF_STRING, MP_PRIOUPVERYHIGH, GetResString(IDS_PRIORELEASE));
	m_PrioUpMenu.AppendMenu(MF_STRING, MP_PRIOUPAUTO, GetResString(IDS_PRIOAUTO));
	m_FileMenu.AppendMenu(MF_STRING|MF_POPUP, (UINT_PTR)m_PrioUpMenu.m_hMenu, GetResString(IDS_PRIORITY) + _T(" (") + GetResString(IDS_PW_CON_UPLBL) + _T(")"), _T("FILEPRIORITYUP"));
	// X-Ray :: DLULPrioExtension :: End

	// X-Ray :: ManualClientManagement :: Start
	m_A4AFMenu.CreateMenu();
	m_A4AFMenu.AddMenuTitle(NULL, true); 
	m_A4AFMenu.AppendMenu(MF_STRING, MP_SWAP_TO_A4AF, GetResString(IDS_SWAP_TO_A4AF), _T("ADVA4AFTO"));
	m_A4AFMenu.AppendMenu(MF_STRING, MP_SWAP_FROM_A4AF, GetResString(IDS_SWAP_FROM_A4AF), _T("ADVA4AFFROM"));
	m_FileMenu.AppendMenu(MF_STRING | MF_POPUP, (UINT_PTR)m_A4AFMenu.m_hMenu, GetResString(IDS_A4AF_MENU), _T("ADVA4AF"));
	// X-Ray :: ManualClientManagement :: End

	// X-Ray :: DropSystem :: Start
	// Add 'Drop' sub menu
	//
	m_DropMenu.CreateMenu();
	m_DropMenu.AddMenuTitle(NULL, true);
	m_DropMenu.AppendMenu(MF_STRING,MP_DROPUNKNOWNSRCS, GetResString(IDS_DROP_UNKNOWN), _T("DROP_UNKNOWN"));
	m_DropMenu.AppendMenu(MF_STRING,MP_DROPTOOMANYCONNSRCS, GetResString(IDS_DROP_TMC), _T("DROP_TOOMANY"));
	m_DropMenu.AppendMenu(MF_STRING,MP_DROPLOWTOLOWIPSRCS, GetResString(IDS_DROP_LOWIPTOLOWIP), _T("DROP_LOW2LOW"));
	m_DropMenu.AppendMenu(MF_STRING,MP_DROPNONEEDEDSRCS, GetResString(IDS_DROP_NNS), _T("DROP_NONEEDED"));
	m_DropMenu.AppendMenu(MF_STRING,MP_DROPHIGHQRSRCS, GetResString(IDS_DROP_HQS), _T("DROP_HIGHQUEUE"));
	m_DropMenu.AppendMenu(MF_STRING,MP_DROPFULLQSRCS, GetResString(IDS_DROP_FQS), _T("DROP_FULLQUEUE"));
	m_DropMenu.AppendMenu(MF_SEPARATOR);
	m_DropMenu.AppendMenu(MF_STRING,MP_DROPSENSELESSSRCS, GetResString(IDS_DROP_SENSELESSSRC), _T("DROP_CLEANUP"));
	// X-Ray :: DropSystem :: End

	// Add file commands
	//
	m_FileMenu.AppendMenu(MF_STRING, MP_PAUSE, GetResString(IDS_DL_PAUSE), _T("PAUSE"));
	m_FileMenu.AppendMenu(MF_STRING, MP_STOP, GetResString(IDS_DL_STOP), _T("STOP"));
	m_FileMenu.AppendMenu(MF_STRING, MP_RESUME, GetResString(IDS_DL_RESUME), _T("RESUME"));
	m_FileMenu.AppendMenu(MF_STRING, MP_CANCEL, GetResString(IDS_MAIN_BTN_CANCEL), _T("DELETE"));

	m_FileMenu.AppendMenu(MF_SEPARATOR); // X-Ray :: MOD
	m_FileMenu.AppendMenu(MF_STRING, MP_FORCE, GetResString(IDS_FORCE), _T("FORCE")); // X-Ray :: OnlyDownloadCompleteFiles
	m_FileMenu.AppendMenu(MF_STRING, MP_STANDBY, GetResString(IDS_STANDBY), _T("STANDBY")); // X-Ray :: StandbyDownload
	m_FileMenu.AppendMenu(MF_STRING, MP_SUSPEND, GetResString(IDS_SUSPENDDL), _T("SUSPEND")); // X-Ray :: SuspendCollecting

	// X-Ray :: DropSystem :: Start
	if (thePrefs.IsExtControlsEnabled()){
		m_FileMenu.AppendMenu(MF_SEPARATOR);
		m_FileMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_DropMenu.m_hMenu, GetResString(IDS_DROP_MENU), _T("DROP_SOURCES"));
	}
	// X-Ray :: DropSystem :: End

	m_FileMenu.AppendMenu(MF_SEPARATOR);
	m_FileMenu.AppendMenu(MF_STRING, MP_OPEN, GetResString(IDS_DL_OPEN), _T("OPENFILE"));
	if (thePrefs.IsExtControlsEnabled() && !thePrefs.GetPreviewPrio())
    	m_FileMenu.AppendMenu(MF_STRING, MP_TRY_TO_GET_PREVIEW_PARTS, GetResString(IDS_DL_TRY_TO_GET_PREVIEW_PARTS), _T("FILEDOWNLOADPREVIEW")); // X-Ray :: MOD
	m_FileMenu.AppendMenu(MF_STRING, MP_PREVIEW, GetResString(IDS_DL_PREVIEW), _T("PREVIEW"));
	m_FileMenu.AppendMenu(MF_STRING, MP_METINFO, GetResString(IDS_DL_INFO), _T("FILEINFO"));
	m_FileMenu.AppendMenu(MF_STRING, MP_VIEWFILECOMMENTS, GetResString(IDS_CMT_SHOWALL), _T("FILECOMMENTS"));
	m_FileMenu.AppendMenu(MF_SEPARATOR);
	m_FileMenu.AppendMenu(MF_STRING, MP_MASSRENAME, GetResString(IDS_MASSRENAME), _T("FILEMASSRENAME")); // X-Ray :: MassRename

	// X-Ray :: PartImportExport :: Start
	m_FileMenu.AppendMenu(MF_STRING, MP_IMPORT, GetResString(IDS_IMPORT_PARTS), _T("PARTIMPORT")); 
	m_FileMenu.AppendMenu(MF_SEPARATOR);
	// X-Ray :: PartImportExport :: End

	// X-Ray :: Filefeedback :: Start
	m_FileMenu.AppendMenu(MF_STRING, MP_FILEFEEDBACK, GetResString(IDS_FEEDBACK_COPY), _T("COPY")); 
	m_FileMenu.AppendMenu(MF_SEPARATOR);
	// X-Ray :: Filefeedback :: End

	m_FileMenu.AppendMenu(MF_STRING, MP_CLEARCOMPLETED, GetResString(IDS_DL_CLEAR), _T("CLEARCOMPLETE"));

	// Add (extended user mode) 'Source Handling' sub menu
	//
	if (thePrefs.IsExtControlsEnabled()) {
		m_SourcesMenu.CreateMenu();
		m_SourcesMenu.AddMenuTitle(NULL); // X-Ray :: XPMenus
		m_SourcesMenu.AppendMenu(MF_STRING, MP_ADDSOURCE, GetResString(IDS_ADDSRCMANUALLY), _T("ADDFRIEND"));
		m_SourcesMenu.AppendMenu(MF_STRING, MP_SETSOURCELIMIT, GetResString(IDS_SETPFSLIMIT), _T("SOURCELIMIT"));
		// X-Ray :: Global Hardlimit :: Start
		m_SourcesMenu.AppendMenu(MF_STRING, MP_GLOBALHL, GetResString(IDS_GLOBAL_HL_CONTEXT));
		// X-Ray :: Global Hardlimit :: End
		m_FileMenu.AppendMenu(MF_STRING|MF_POPUP, (UINT_PTR)m_SourcesMenu.m_hMenu, GetResString(IDS_A4AF), _T("SOURCEMANAGEMENT"));
	}
	m_FileMenu.AppendMenu(MF_SEPARATOR);

	// Add 'Copy & Paste' commands
	//
	if (thePrefs.GetShowCopyEd2kLinkCmd())
		m_FileMenu.AppendMenu(MF_STRING, MP_GETED2KLINK, GetResString(IDS_DL_LINK1), _T("ED2KLINK"));
	else
		m_FileMenu.AppendMenu(MF_STRING, MP_SHOWED2KLINK, GetResString(IDS_DL_SHOWED2KLINK), _T("ED2KLINK"));
	m_FileMenu.AppendMenu(MF_STRING, MP_PASTE, GetResString(IDS_SW_DIRECTDOWNLOAD), _T("PASTELINK"));
	m_FileMenu.AppendMenu(MF_SEPARATOR);

	// Search commands
	//
	m_FileMenu.AppendMenu(MF_STRING, MP_FIND, GetResString(IDS_FIND), _T("Search"));
	m_FileMenu.AppendMenu(MF_STRING, MP_SEARCHRELATED, GetResString(IDS_SEARCHRELATED), _T("KadFileSearch"));
	// Web-services and categories will be added on-the-fly..
}

CString CDownloadListCtrl::getTextList()
{
	CString out;

	for (ListItems::iterator it = m_ListItems.begin(); it != m_ListItems.end(); it++)
	{
		const CtrlItem_Struct* cur_item = it->second;
		if (cur_item->type == FILE_TYPE)
		{
			const CPartFile* file = reinterpret_cast<CPartFile*>(cur_item->value);

			CString temp;
			temp.Format(_T("\n%s\t [%.1f%%] %i/%i - %s"),
						file->GetFileName(),
						file->GetPercentCompleted(),
						file->GetTransferringSrcCount(),
						file->GetSourceCount(), 
						file->getPartfileStatus());

			out += temp;
		}
	}

	return out;
}

int CDownloadListCtrl::GetFilesCountInCurCat()
{
	int iCount = 0;
	for (ListItems::const_iterator it = m_ListItems.begin(); it != m_ListItems.end(); it++)
	{
		CtrlItem_Struct* cur_item = it->second;
		if (cur_item->type == FILE_TYPE)
		{
			CPartFile* file = (CPartFile*)cur_item->value;
			if (file->CheckShowItemInGivenCat(curTab))
				iCount++;
		}
	}
	return iCount;
}

void CDownloadListCtrl::ShowFilesCount()
{
	// X-Ray :: RollUpCtrl :: Start
	/*
	theApp.emuledlg->transferwnd->UpdateFilesCount(GetFilesCountInCurCat());
	*/
	theApp.emuledlg->transferwnd->UpdateDownloadHeader();
	// X-Ray :: RollUpCtrl :: End
}

void CDownloadListCtrl::ShowSelectedFileDetails()
{
	POINT point;
	::GetCursorPos(&point);
	CPoint pt = point; 
    ScreenToClient(&pt); 
    int it = HitTest(pt);
    if (it == -1)
		return;

	SetItemState(-1, 0, LVIS_SELECTED);
	SetItemState(it, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
	SetSelectionMark(it);   // display selection mark correctly! 

	CtrlItem_Struct* content = (CtrlItem_Struct*)GetItemData(GetSelectionMark());
	if (content->type == FILE_TYPE)
	{
		CPartFile* file = (CPartFile*)content->value;
		if (thePrefs.ShowRatingIndicator() 
			&& (file->HasComment() || file->HasRating() || file->IsKadCommentSearchRunning()) 
			&& pt.x >= FILE_ITEM_MARGIN_X+theApp.GetSmallSytemIconSize().cx 
			&& pt.x <= FILE_ITEM_MARGIN_X+theApp.GetSmallSytemIconSize().cx+RATING_ICON_WIDTH)
			ShowFileDialog(IDD_COMMENTLST);
		else
			ShowFileDialog(0);
	}
	else
	{
		ShowClientDialog((CUpDownClient*)content->value);
	}
}

int CDownloadListCtrl::GetCompleteDownloads(int cat, int& total)
{
	total = 0;
	int count = 0;
	for (ListItems::const_iterator it = m_ListItems.begin(); it != m_ListItems.end(); it++)
	{
		const CtrlItem_Struct* cur_item = it->second;
		if (cur_item->type == FILE_TYPE)
		{
			/*const*/ CPartFile* file = reinterpret_cast<CPartFile*>(cur_item->value);
			if (file->CheckShowItemInGivenCat(cat) || cat==-1)
			{
				total++;
				if (file->GetStatus() == PS_COMPLETE)
					count++;
			}
		}
	}
	return count;
}

void CDownloadListCtrl::UpdateCurrentCategoryView(){
	ChangeCategory(curTab);
}

void CDownloadListCtrl::UpdateCurrentCategoryView(CPartFile* thisfile) {

	ListItems::const_iterator it = m_ListItems.find(thisfile);
	if (it != m_ListItems.end()) {
		const CtrlItem_Struct* cur_item = it->second;
		if (cur_item->type == FILE_TYPE){
			CPartFile* file = reinterpret_cast<CPartFile*>(cur_item->value);
			
			if (!file->CheckShowItemInGivenCat(curTab))
				HideFile(file);
			else
				ShowFile(file);
		}
	}

}

void CDownloadListCtrl::ChangeCategory(int newsel){

	SetRedraw(FALSE);

	// remove all displayed files with a different cat and show the correct ones
	for(ListItems::const_iterator it = m_ListItems.begin(); it != m_ListItems.end(); it++){
		const CtrlItem_Struct* cur_item = it->second;
		if (cur_item->type == FILE_TYPE){
			CPartFile* file = reinterpret_cast<CPartFile*>(cur_item->value);
			
			if (!file->CheckShowItemInGivenCat(newsel))
				HideFile(file);
			else
				ShowFile(file);
		}
	}

	SetRedraw(TRUE);
	curTab=newsel;
	ShowFilesCount();
}

void CDownloadListCtrl::HideFile(CPartFile* tohide)
{
	HideSources(tohide);

	// Retrieve all entries matching the source
	std::pair<ListItems::const_iterator, ListItems::const_iterator> rangeIt = m_ListItems.equal_range(tohide);
	for(ListItems::const_iterator it = rangeIt.first; it != rangeIt.second; it++){
		CtrlItem_Struct* updateItem  = it->second;

		// Find entry in CListCtrl and update object
 		LVFINDINFO find;
		find.flags = LVFI_PARAM;
		find.lParam = (LPARAM)updateItem;
		int result = FindItem(&find);
		if (result != -1){
			DeleteItem(result);
			return;
		}
	}
}

void CDownloadListCtrl::ShowFile(CPartFile* toshow){
	// Retrieve all entries matching the source
	std::pair<ListItems::const_iterator, ListItems::const_iterator> rangeIt = m_ListItems.equal_range(toshow);
	ListItems::const_iterator it = rangeIt.first;
	if(it != rangeIt.second){
		CtrlItem_Struct* updateItem  = it->second;

		// Check if entry is already in the List
 		LVFINDINFO find;
		find.flags = LVFI_PARAM;
		find.lParam = (LPARAM)updateItem;
		int result = FindItem(&find);
		if (result == -1)
			InsertItem(LVIF_PARAM|LVIF_TEXT,GetItemCount(),LPSTR_TEXTCALLBACK,0,0,0,(LPARAM)updateItem);
	}
}

void CDownloadListCtrl::GetDisplayedFiles(CArray<CPartFile*,CPartFile*> *list){
	for(ListItems::iterator it = m_ListItems.begin(); it != m_ListItems.end(); ){
		CtrlItem_Struct* cur_item = it->second;
		it++; // Already point to the next iterator. 
		if(cur_item->type == FILE_TYPE){
			CPartFile* file = reinterpret_cast<CPartFile*>(cur_item->value);
			list->Add(file);
		}
	}	
}

void CDownloadListCtrl::MoveCompletedfilesCat(uint8 from, uint8 to)
{
	int mycat;

	for(ListItems::iterator it = m_ListItems.begin(); it != m_ListItems.end(); ){
		CtrlItem_Struct* cur_item = it->second;
		it++; // Already point to the next iterator.
		if(cur_item->type == FILE_TYPE){
			CPartFile* file = reinterpret_cast<CPartFile*>(cur_item->value);
			if (!file->IsPartFile()){
				mycat=file->GetCategory();
				if ( mycat>=min(from,to) && mycat<=max(from,to)) {
					if (mycat==from) 
						file->SetCategory(to); 
					else
						if (from<to)
							file->SetCategory(mycat-1);
						else
							file->SetCategory(mycat+1);
				}
			}
		}
	}
}

void CDownloadListCtrl::OnGetDispInfo(NMHDR* pNMHDR, LRESULT* pResult)
{
    NMLVDISPINFO* pDispInfo = (NMLVDISPINFO*)pNMHDR;
	/*TRACE("CDownloadListCtrl::OnGetDispInfo iItem=%d iSubItem=%d", pDispInfo->item.iItem, pDispInfo->item.iSubItem);
	if (pDispInfo->item.mask & LVIF_TEXT)
		TRACE(" LVIF_TEXT");
	if (pDispInfo->item.mask & LVIF_IMAGE)
		TRACE(" LVIF_IMAGE");
	if (pDispInfo->item.mask & LVIF_STATE)
		TRACE(" LVIF_STATE");
	TRACE("\n");*/

	// Although we have an owner drawn listview control we store the text for the primary item in the listview, to be
	// capable of quick searching those items via the keyboard. Because our listview items may change their contents,
	// we do this via a text callback function. The listview control will send us the LVN_DISPINFO notification if
	// it needs to know the contents of the primary item.
	//
	// But, the listview control sends this notification all the time, even if we do not search for an item. At least
	// this notification is only sent for the visible items and not for all items in the list. Though, because this
	// function is invoked *very* often, no *NOT* put any time consuming code here in.

    if (pDispInfo->item.mask & LVIF_TEXT){
        const CtrlItem_Struct* pItem = reinterpret_cast<CtrlItem_Struct*>(pDispInfo->item.lParam);
        if (pItem != NULL && pItem->value != NULL){
			if (pItem->type == FILE_TYPE){
				switch (pDispInfo->item.iSubItem){
					case 0:
						if (pDispInfo->item.cchTextMax > 0){
							_tcsncpy(pDispInfo->item.pszText, ((CPartFile*)pItem->value)->GetFileName(), pDispInfo->item.cchTextMax);
							pDispInfo->item.pszText[pDispInfo->item.cchTextMax-1] = _T('\0');
						}
						break;
					default:
						// shouldn't happen
						pDispInfo->item.pszText[0] = _T('\0');
						break;
				}
			}
			else if (pItem->type == UNAVAILABLE_SOURCE || pItem->type == AVAILABLE_SOURCE){
				switch (pDispInfo->item.iSubItem){
					case 0:
						if (((CUpDownClient*)pItem->value)->GetUserName() != NULL && pDispInfo->item.cchTextMax > 0){
							_tcsncpy(pDispInfo->item.pszText, ((CUpDownClient*)pItem->value)->GetUserName(), pDispInfo->item.cchTextMax);
							pDispInfo->item.pszText[pDispInfo->item.cchTextMax-1] = _T('\0');
						}
						break;
					default:
						// shouldn't happen
						pDispInfo->item.pszText[0] = _T('\0');
						break;
				}
			}
			else
				ASSERT(0);
        }
    }
    *pResult = 0;
}

void CDownloadListCtrl::OnLvnGetInfoTip(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLVGETINFOTIP pGetInfoTip = reinterpret_cast<LPNMLVGETINFOTIP>(pNMHDR);
	if (pGetInfoTip->iSubItem == 0)
	{
		LVHITTESTINFO hti = {0};
		::GetCursorPos(&hti.pt);
		ScreenToClient(&hti.pt);
		if (SubItemHitTest(&hti) == -1 || hti.iItem != pGetInfoTip->iItem || hti.iSubItem != 0){
			// don't show the default label tip for the main item, if the mouse is not over the main item
			if ((pGetInfoTip->dwFlags & LVGIT_UNFOLDED) == 0 && pGetInfoTip->cchTextMax > 0 && pGetInfoTip->pszText[0] != _T('\0'))
				pGetInfoTip->pszText[0] = _T('\0');
			return;
		}

		const CtrlItem_Struct* content = (CtrlItem_Struct*)GetItemData(pGetInfoTip->iItem);
		if (content && pGetInfoTip->pszText && pGetInfoTip->cchTextMax > 0)
		{
			CString info;

			// build info text and display it
			if (content->type == 1) // for downloading files
			{
				const CPartFile* partfile = (CPartFile*)content->value;
				info = partfile->GetInfoSummary();
			}
			else if (content->type == 3 || content->type == 2) // for sources
			{
				const CUpDownClient* client = (CUpDownClient*)content->value;
				if (client->IsEd2kClient())
				{
					in_addr server;
					server.S_un.S_addr = client->GetServerIP();
					info.Format(GetResString(IDS_USERINFO)
								+ GetResString(IDS_SERVER) + _T(":%s:%u\n\n")
								+ GetResString(IDS_NEXT_REASK) + _T(":%s"),
								client->GetUserName() ? client->GetUserName() : _T("?"),
								ipstr(server), client->GetServerPort(),
								CastSecondsToHM(client->GetTimeUntilReask(client->GetRequestFile()) / 1000));
					if (thePrefs.IsExtControlsEnabled())
						info.AppendFormat(_T(" (%s)"), CastSecondsToHM(client->GetTimeUntilReask(content->owner) / 1000));
					info += _T('\n');
					info.AppendFormat(GetResString(IDS_SOURCEINFO), client->GetAskedCountDown(), client->GetAvailablePartCount());
					info += _T('\n');

					if (content->type == 2)
					{
						info += GetResString(IDS_CLIENTSOURCENAME) + (!client->GetClientFilename().IsEmpty() ? client->GetClientFilename() : _T("-"));
						if (!client->GetFileComment().IsEmpty())
							info += _T('\n') + GetResString(IDS_CMT_READ) + _T(' ') + client->GetFileComment();
						if (client->GetFileRating())
							info += _T('\n') + GetResString(IDS_QL_RATING) + _T(':') + GetRateString(client->GetFileRating());
					}
					else
					{	// client asked twice
						info += GetResString(IDS_ASKEDFAF);
					if (client->GetRequestFile() && client->GetRequestFile()->GetFileName())
						info.AppendFormat(_T(":%s"), client->GetRequestFile()->GetFileName());
					}

					if (thePrefs.IsExtControlsEnabled() && !client->m_OtherRequests_list.IsEmpty())
					{
						CSimpleArray<const CString*> apstrFileNames;
						POSITION pos = client->m_OtherRequests_list.GetHeadPosition();
						while (pos)
							apstrFileNames.Add(&client->m_OtherRequests_list.GetNext(pos)->GetFileName());
						Sort(apstrFileNames);
						if (content->type == 2)
							info += _T('\n');
						info += _T('\n');
						info += GetResString(IDS_A4AF_FILES);
						info += _T(':');
						for (int i = 0; i < apstrFileNames.GetSize(); i++)
						{
							const CString* pstrFileName = apstrFileNames[i];
							if (info.GetLength() + (i > 0 ? 2 : 0) + pstrFileName->GetLength() >= pGetInfoTip->cchTextMax) {
								static const TCHAR szEllipses[] = _T("\n:...");
								if (info.GetLength() + (int)ARRSIZE(szEllipses) - 1 < pGetInfoTip->cchTextMax)
									info += szEllipses;
								break;
							}
							if (i > 0)
								info += _T("\n:");
							info += *pstrFileName;
						}
					}
				}
				else
				{
					info.Format(_T("URL:%s\nAvailable parts:%u"), client->GetUserName(), client->GetAvailablePartCount());
				}
			}

			info += TOOLTIP_AUTOFORMAT_SUFFIX_CH;
			_tcsncpy(pGetInfoTip->pszText, info, pGetInfoTip->cchTextMax);
			pGetInfoTip->pszText[pGetInfoTip->cchTextMax-1] = _T('\0');
		}
	}
	*pResult = 0;
}

void CDownloadListCtrl::ShowFileDialog(UINT uInvokePage)
{
	CSimpleArray<CPartFile*> aFiles;
	POSITION pos = GetFirstSelectedItemPosition();
	while (pos != NULL)
	{
		int iItem = GetNextSelectedItem(pos);
		if (iItem != -1)
		{
			const CtrlItem_Struct* pCtrlItem = (CtrlItem_Struct*)GetItemData(iItem);
			if (pCtrlItem->type == FILE_TYPE)
				aFiles.Add((CPartFile*)pCtrlItem->value);
		}
	}

	if (aFiles.GetSize() > 0)
	{
		CDownloadListListCtrlItemWalk::SetItemType(FILE_TYPE);
		// X-Ray :: NewFileDetailDialog :: Start
		CSimpleArray<CAbstractFile*> paFiles;
		for (int i = 0; i < aFiles.GetSize(); i++)
			paFiles.Add(aFiles[i]);
		// X-Ray :: NewFileDetailDialog :: End

		// X-Ray :: ModelessDialogs :: Start
		/*
		CFileDetailDialog dialog(&aFiles, uInvokePage, this);
		dialog.DoModal();
		*/
		CFileDetailDialog* dlg = new CFileDetailDialog(&paFiles, uInvokePage, this);
		dlg->OpenDialog();
		// X-Ray :: ModelessDialogs :: End
	}
}

CDownloadListListCtrlItemWalk::CDownloadListListCtrlItemWalk(CDownloadListCtrl* pListCtrl)
	: CListCtrlItemWalk(pListCtrl)
{
	m_pDownloadListCtrl = pListCtrl;
	m_eItemType = (ItemType)-1;
}

CObject* CDownloadListListCtrlItemWalk::GetPrevSelectableItem()
{
	ASSERT( m_pDownloadListCtrl != NULL );
	if (m_pDownloadListCtrl == NULL)
		return NULL;

	ASSERT( m_eItemType != (ItemType)-1 );

	int iItemCount = m_pDownloadListCtrl->GetItemCount();
	if (iItemCount >= 2)
	{
		POSITION pos = m_pDownloadListCtrl->GetFirstSelectedItemPosition();
		if (pos)
		{
			int iItem = m_pDownloadListCtrl->GetNextSelectedItem(pos);
			int iCurSelItem = iItem;
			while (iItem-1 >= 0)
			{
				iItem--;

				const CtrlItem_Struct* ctrl_item = (CtrlItem_Struct*)m_pDownloadListCtrl->GetItemData(iItem);
				if (ctrl_item->type == m_eItemType || (m_eItemType != FILE_TYPE && ctrl_item->type != FILE_TYPE))
				{
					m_pDownloadListCtrl->SetItemState(iCurSelItem, 0, LVIS_SELECTED | LVIS_FOCUSED);
					m_pDownloadListCtrl->SetItemState(iItem, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
					m_pDownloadListCtrl->SetSelectionMark(iItem);
					m_pDownloadListCtrl->EnsureVisible(iItem, FALSE);
					return STATIC_DOWNCAST(CObject, (CObject*)ctrl_item->value);
				}
			}
		}
	}
	return NULL;
}

CObject* CDownloadListListCtrlItemWalk::GetNextSelectableItem()
{
	ASSERT( m_pDownloadListCtrl != NULL );
	if (m_pDownloadListCtrl == NULL)
		return NULL;

	ASSERT( m_eItemType != (ItemType)-1 );

	int iItemCount = m_pDownloadListCtrl->GetItemCount();
	if (iItemCount >= 2)
	{
		POSITION pos = m_pDownloadListCtrl->GetFirstSelectedItemPosition();
		if (pos)
		{
			int iItem = m_pDownloadListCtrl->GetNextSelectedItem(pos);
			int iCurSelItem = iItem;
			while (iItem+1 < iItemCount)
			{
				iItem++;

				const CtrlItem_Struct* ctrl_item = (CtrlItem_Struct*)m_pDownloadListCtrl->GetItemData(iItem);
				if (ctrl_item->type == m_eItemType || (m_eItemType != FILE_TYPE && ctrl_item->type != FILE_TYPE))
				{
					m_pDownloadListCtrl->SetItemState(iCurSelItem, 0, LVIS_SELECTED | LVIS_FOCUSED);
					m_pDownloadListCtrl->SetItemState(iItem, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
					m_pDownloadListCtrl->SetSelectionMark(iItem);
					m_pDownloadListCtrl->EnsureVisible(iItem, FALSE);
					return STATIC_DOWNCAST(CObject, (CObject*)ctrl_item->value);
				}
			}
		}
	}
	return NULL;
}

void CDownloadListCtrl::ShowClientDialog(CUpDownClient* pClient)
{
	CDownloadListListCtrlItemWalk::SetItemType(AVAILABLE_SOURCE); // just set to something !=FILE_TYPE
	// X-Ray :: ModelessDialogs :: Start
	/*
	CClientDetailDialog dialog(pClient, this);
	dialog.DoModal();
	*/
	CClientDetailDialog* dlg = new CClientDetailDialog(pClient, this);
	dlg->OpenDialog();
	// X-Ray :: ModelessDialogs :: End
}

// X-Ray :: StopDownload :: Start
void CDownloadListCtrl::StopSingleClient(CUpDownClient* pClient)  
{
	if (pClient != NULL && pClient->GetDownloadState() == DS_DOWNLOADING){
		if(pClient->socket != NULL)
			pClient->SendCancelTransfer();
		pClient->SetDownloadState(DS_ONQUEUE, _T("Download aborted by User"));
	}
}
// X-Ray :: StopDownload :: End