//DLP = Dynamic Leecher Protection
//this code is part of Xtreme-Mod
//author: Xman

//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <atlstr.h>
#include "antiLeech.h"
#include "libald.h"

#define AJ_MD5_BUFFER_SIZE	92				// The buffer is always this length exactly

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

//>>> eWombat [SNAFU_V3]
LPCTSTR apszSnafuTag[]=
{
	_T("[DodgeBoards]"),									//0
	_T("[DodgeBoards & DarkMule eVorteX]"),					//1
	_T("[DarkMule v6 eVorteX]"),							//2
	_T("[eMuleReactor]"),									//3
	_T("[Bionic]"),											//4
	_T("[LSD7c]"),											//5
	_T("[0x8d] unknown Leecher - (client version:60)"),		//6
	_T("[RAMMSTEIN]"),										//7
	_T("[MD5 Community]"),									//8
	_T("[new DarkMule]"),									//9
	_T("[OMEGA v.07 Heiko]"),								//10
	_T("[eMule v0.26 Leecher]"),							//11
	_T("[Hunter]"),											//12
	_T("[Bionic 0.20 Beta]"),								//13
	_T("[Rumata (rus)(Plus v1f)]"),							//14
	_T("[Fusspi]"),											//15
	_T("[donkey2002]"),										//16
	_T("[md4]"),									        //17
	_T("[SpeedMule]"),										//18 Xman 
	_T("[pimp]")											//19 Xman 
};


BOOL WINAPI DllMain(HANDLE hModule, DWORD dwFunction, LPVOID lpNot)
{
	switch(dwFunction)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
	}

	return TRUE;
}


void __declspec(dllexport) TestFunc()
{
	::MessageBox(NULL, _T("Inside the DLL!"), _T("Nix"), 0);
}

//old versions just to keep compatible

LPCTSTR __declspec(dllexport) DLPCheckModstring(LPCTSTR modversion, LPCTSTR clientversion)
{
	if(modversion==NULL || clientversion==NULL)
		return NULL;

	if (StrStrI(modversion,_T("Freeza"))||
		StrStrI(modversion,_T("d-unit"))||
		StrStrI(modversion,_T("imperator"))||
		StrStrI(modversion,_T("SpeedLoad"))||
		StrStrI(modversion,_T("gt mod"))||
		StrStrI(modversion,_T("egomule"))||
		StrStrI(modversion,_T("aldo"))|| 
		StrStrI(modversion,_T("darkmule"))||
		StrStrI(modversion,_T("LegoLas"))||
		StrStrI(modversion,_T("dodgethis"))|| //Updated
		StrStrI(modversion,_T("DM-"))|| 
		StrStrI(modversion,_T("|X|"))||
		StrStrI(modversion,_T("eVorte"))||
		StrStrI(modversion,_T("Mison"))||
		StrStrI(modversion,_T("father"))||
		StrStrI(modversion,_T("Dragon"))||
		StrStrI(modversion,_T("booster"))|| //Temporaly added, must check the tag
		StrStrI(modversion,_T("$motty"))||
		StrStrI(modversion,_T("Thunder"))||
		StrStrI(modversion,_T("BuzzFuzz"))||
		StrStrI(modversion,_T("Speed-Unit"))|| 
		StrStrI(modversion,_T("Killians"))||
		StrStrI(modversion,_T("Element"))|| 
		StrStrI(modversion,_T("]"))||
		StrStrI(modversion,_T("Rappi"))||
		StrStrI(modversion,_T("EastShare")) && StrStrI(clientversion,_T("0.29"))||
		StrStrI(modversion,_T("eChanblard v7.0")) ||
		StrStrI(modversion,_T("!FREEANGEL!")) ||
		StrStrI(modversion,_T("          ")) ||
		StrStrI(modversion,_T("Stonehenge")) ||
		StrStrI(modversion,_T("@RAPTOR")) ||
		StrStrI(modversion,_T("pwNd muLe")) ||
		StrStrI(modversion,_T("HARDPAW")) ||
		StrStrI(modversion,_T("XXL")) ||
		StrStrI(modversion,_T("LSD")) ||			
		StrStrI(modversion,_T("Rockesel")) || //WiZaRd
		StrStrI(modversion,_T("Bad Donkey")) || //WiZaRd
		StrStrI(modversion,_T("DSL-Light-Client")) || //WiZaRd
		StrStrI(modversion,_T("Elben")) || //WiZaRd
		StrStrI(modversion,_T("PROeMule")) || //WiZaRd
		StrStrI(modversion,_T("OO.de")) ||	//WiZaRd		
		StrStrI(modversion,_T("00.de")) || //WiZaRd
		StrStrI(modversion,_T("OOde")) || //WiZaRd
		StrStrI(modversion,_T("00de")) ||
		StrStrI(modversion,_T("Devil")) ||
		StrStrI(modversion,_T("Elfen")) ||
		StrStrI(modversion,_T("Ef-mod 2.0 ")) || //Xman this mod can be abused as a full leecher
		StrStrI(modversion,_T("HARDMULE")) ||
		StrStrI(modversion,_T("Xtreme Xtended")) || //Xman 15.08.05
		StrStrI(modversion, _T("MirageMod"))||		 // "
		StrStrI(modversion, _T("SpeedX"))||
		StrStrI(modversion, _T("AIDEADSL"))||
		StrStrI(modversion, _T("Hypnotix"))||
		StrStrI(modversion, _T("BLACKMULE"))|| 
		StrStrI(modversion, _T("blackviper"))||
		StrStrI(modversion, _T("BlackAngel"))||
		StrStrI(modversion, _T("Community"))|| 
		StrStrI(modversion, _T("rabbit"))|| 
		StrStrI(modversion, _T("rabb_it"))|| 
		StrStrI(modversion, _T("Speedmule"))|| 
		StrStrI(modversion, _T("Raptor"))|| 
		StrStrI(modversion, _T("Hawkstar"))|| 
		StrStrI(modversion, _T("ServerClient"))|| 
		StrStrI(modversion, _T("Love-Angel"))|| 
		StrStrI(modversion, _T("SuperKiller"))|| 
		StrStrI(modversion, _T("Ultimativ"))||
		StrStrI(modversion, _T("uptempo"))||
		StrStrI(modversion, _T("ZamBoR"))||
		StrStrI(modversion, _T("Arabella"))||
		StrStrI(modversion,_T("Morph")) && (StrStrI(modversion,_T("Max")) || StrStrI(modversion,_T("+")) || StrStrI(modversion,_T(""))) ||
		StrStrI(modversion, _T("Morph XT"))||	//very bad mod (MPAA ?)
		StrStrI(modversion, _T("BlueHex"))||
		StrStrI(modversion, _T("FlowerPower"))||
		StrStrI(modversion, _T("Fincan"))||
		StrStrI(modversion, _T("Heartbreaker"))||
		StrStrI(modversion, _T("Administrator"))||
		StrStrI(modversion, _T("B@d-D3vi7"))||
		StrStrI(modversion, _T("CryptedSpeed"))||
		StrStrI(modversion, _T("DarkDragon"))||
		StrStrI(modversion, _T("OS_"))||	//Xman most are found via other checks, but not all
		_tcslen(modversion) > 0 && (StrStrI(clientversion,_T("edonkey")) || modversion[0]==_T('['))   ||  //1. donkey user with modstring, 2. modstring begins with [ this is a known leecher
		(StrStrI(modversion, _T("Xtreme")) && StrStrI(modversion, _T("]")))  //bad Xtreme mod
		)
			return _T("Bad MODSTRING");

	return NULL;
}

LPCTSTR __declspec(dllexport) DLPCheckUsername(LPCTSTR username)
{
	if(username==NULL)
		return NULL;

	if (StrStrI(username,_T("$GAM3R$"))||
		StrStrI(username,_T("G@m3r"))||
		StrStrI(username,_T("$WAREZ$"))||
		StrStrI(username,_T("Leecha"))||
		StrStr(username,_T("eDevil"))|| 
		StrStrI(username,_T("darkmule"))||
		StrStrI(username,_T("Reverse"))||
		StrStrI(username,_T("$motty"))||
		StrStrI(username,_T("emule-speed"))||
		StrStrI(username,_T("celinesexy"))||
		StrStrI(username,_T("Gate-eMule"))||
		StrStrI(username,_T("emule-element"))||
		StrStrI(username,_T("00de.de"))|| 
		StrStrI(username,_T("00de")) ||
		StrStrI(username,_T("OO.de"))|| 
		StrStrI(username,_T("OOde")) ||
		StrStrI(username,_T("emule")) && StrStrI(username,_T("booster")) ||
		StrStrI(username,_T("Rappi")) ||
		StrStrI(username,_T("Ketamine")) ||
		StrStrI(username,_T("HARDMULE")) ||
		StrStrI(username,_T("emuleech")) ||
		StrStrI(username, _T("ElfenPower"))||
		StrStrI(username, _T("eSl@d3vil"))||
		StrStrI(username, _T("rabb_it"))||
		StrStrI(username, _T("ServerClient"))||
		StrStrI(username, _T(">>Power-Mod"))||
		StrStr(username, _T("DM_X"))|| //darkmule
		StrCmpI(username, _T("Muse"))==0 || //ketamine mod
		StrStr(username, _T("ZamBoR"))||
		StrStr(username, _T("emule.razorback3.com"))||
		StrStr(username, _T("FUCKLW"))|| //added dlarge

		StrStrI(username,_T("[LSD.19"))	//Xman 21.06.2005 definitive not a good mod, with protocol bugs
		)
		return _T("Bad USERNAME");

	//bad mods, where every second sign is
	//enough to check two places

	if(_tcslen(username) >=4 
		&&	username[3]<=0x1F
		&& username[1]<=0x1F
		)
		return _T("Leecher-Username");

	return NULL;
}

LPCTSTR __declspec(dllexport) DLPCheckNameAndHash(CString username, CString& userhash)
{
	if(username.IsEmpty() || userhash.IsEmpty())
		return NULL;

	//community check
	if(username.GetLength()>=7 && username.Right(1)==_T("]"))
	{
		//check for gamer
		//two checks should be enough.
		if(username.Right(6).Left(1)==userhash.Mid(5,1)
			&& username.Right(3).Left(1)==userhash.Mid(7,1)
			)
			return _T("Gamers");
		//check for snake
		int find=username.ReverseFind(_T('['));
		if(find>=0)
		{
			CString addon=username.Mid(find+1);
			int endpos=addon.GetLength()-1;
			for(int i=0; i<endpos;i++)
			{
				if( !(addon.GetAt(i)>=_T('0') && addon.GetAt(i)<=_T('9')) )
				{
					i=endpos+1;
				}
			}
			if(i==endpos)
				return _T("Snake");
		}
	}

	return NULL;
}
//end old version ------------------------------------------


bool IsTypicalHex(CString& addon)
{
	if(addon.GetLength()>25 || addon.GetLength()<5)
		return false;
	short bigalpha=0;
	short smallalpha=0;
	short numeric=0;

	int endpos=addon.GetLength();
	for(int i=0; i<endpos;i++)
	{
		if( (addon.GetAt(i)>=_T('0') && addon.GetAt(i)<=_T('9')) )
			numeric++;
		else if( (addon.GetAt(i)>=_T('A') && addon.GetAt(i)<=_T('F')) )
			bigalpha++;
		else if( (addon.GetAt(i)>=_T('a') && addon.GetAt(i)<=_T('f')) )
			smallalpha++;
		else
			break;
	}
	if(i==endpos)
	{
		if(numeric>0 &&
			(smallalpha>0 && bigalpha==0 || smallalpha==0 && bigalpha>0)
			)
			return true;
	}
	return false;
}

LPCTSTR __declspec(dllexport) DLPCheckUserhash(const PBYTE userhash)
{
	int buflen;
	BOOL bIsApplejuice = FALSE;
	BYTE AJByte;
	BYTE md5_hashval[16];
	BYTE buffer[AJ_MD5_BUFFER_SIZE + 2];	// Need 2 extra bytes because _tprintf()
	_TCHAR FormatString[] =	L"@ppl"			// adds a terminating UNICODE NULL char
		L"%.2X%.2X%.2X%.2X%.2X%.2X%.2X%.2X"
		L" ufablE "
		L"%.2X%.2X%.2X%.2X%.2X%.2X%.2X"
		L" 89";

	buflen = _stprintf(	(TCHAR *) buffer,
		FormatString,
		userhash[0], userhash[1], userhash[2], userhash[3],
		userhash[4], userhash[5], userhash[6], userhash[7],
		userhash[9], userhash[10], userhash[11], userhash[12],
		userhash[13], userhash[14], userhash[15]
		);

		// Hash the data in the buffer using the MD5 algorithm
		if (MD5_FUNCTION(buffer, buflen * sizeof(TCHAR), md5_hashval)) {
			AJByte = ((md5_hashval[4] & 0x0F) << 4) | (md5_hashval[12] & 0x0F);
			bIsApplejuice = (userhash[8] == AJByte);
		}

		//return bIsApplejuice;
		if(bIsApplejuice)
			return _T("Applejuice Community");
		else
			return NULL;
}

//new versions
LPCTSTR __declspec(dllexport) DLPCheckModstring_Hard(LPCTSTR modversion, LPCTSTR clientversion)
{
	if(modversion==NULL || clientversion==NULL)
		return NULL;

	if (
		StrStrI(modversion,_T("FXeMule"))||
		StrStrI(modversion,_T("FX eMule"))||
		StrStrI(modversion,_T("RIAA"))||
		StrStrI(modversion,_T("SpeedLoad"))||
		StrStrI(modversion,_T("Element"))|| 
		StrStrI(modversion,_T("Rappi"))||
		StrStrI(modversion,_T("EastShare")) && StrStrI(clientversion,_T("0.29"))||
		StrStrI(modversion,_T("eChanblard v7.0")) ||
		StrStrI(modversion,_T("          ")) ||
		StrStrI(modversion,_T("@RAPTOR")) ||
		StrStr(modversion,_T("pwNd muLe")) ||
		StrStrI(modversion,_T("HARDPAW")) ||
		StrStrI(modversion,_T("LSD")) ||			
		StrStrI(modversion,_T("Bad Donkey")) || //WiZaRd
		StrStrI(modversion,_T("DSL-Light-Client")) || //WiZaRd
		StrStrI(modversion,_T("Elben")) || //WiZaRd
		StrStr(modversion,_T("PROeMule")) || //WiZaRd
		StrStrI(modversion,_T("Devil")) ||
		StrStrI(modversion,_T("Elfen")) ||
		StrStrI(modversion,_T("Ef-mod 2.0 ")) || //Xman this mod can be abused as a full leecher
		StrStrI(modversion,_T("Xtreme Xtended")) || //Xman 15.08.05
		StrStrI(modversion, _T("MirageMod"))||		 // "
		StrStrI(modversion, _T("SpeedX"))||
		StrStrI(modversion, _T("AIDEADSL"))||
		StrStrI(modversion, _T("Hypnotix"))||
		StrStrI(modversion, _T("BLACKMULE"))|| 
		StrStrI(modversion, _T("blackviper"))||
		StrStrI(modversion, _T("BlackAngel"))||
		StrStrI(modversion, _T("rabbit"))|| 
		StrStrI(modversion, _T("rabb_it"))|| 
		StrStrI(modversion, _T("Raptor"))|| 
		StrStrI(modversion, _T("Hawkstar"))|| 
		StrStrI(modversion, _T("ServerClient"))|| 
		StrStrI(modversion, _T("Love-Angel"))|| 
		StrStrI(modversion, _T("SuperKiller"))|| 
		StrStrI(modversion, _T("ZamBoR"))||
		StrStrI(modversion,_T("Morph")) && (StrStrI(modversion,_T("Max")) || StrStrI(modversion,_T("+")) || StrStrI(modversion,_T(""))) ||
		StrStrI(modversion, _T("Morph XT"))||	//very bad mod (MPAA ?)
		StrStrI(modversion, _T("Mrph"))||
		StrStrI(modversion, _T("BlueHex"))||
		StrStrI(modversion, _T("FlowerPower"))||
		StrStrI(modversion, _T("Fincan"))||
		StrStrI(modversion,_T("OO.de")) ||	//WiZaRd		
		StrStrI(modversion,_T("00.de")) || //WiZaRd
		StrStrI(modversion,_T("OOde")) || //WiZaRd
		StrStrI(modversion,_T("00de")) ||
		StrStrI(modversion, _T("OS_")) ||	//Xman most are found via other checks, but not all
		StrStrI(modversion, _T("Heartbreaker"))||
		StrStrI(modversion, _T("Arabella"))||
		StrStrI(modversion, _T("Administrator"))||
		StrStrI(modversion, _T("B@d-D3vi7"))||
		StrStrI(modversion, _T("Dying Angel"))||
		StrStrI(modversion, _T("FREAK MOD VENOM"))||
		StrStrI(modversion, _T("CryptedSpeed"))||
		StrStrI(modversion, _T("h34r7b34k3r"))||
		StrStrI(modversion, _T("Exorzist"))||
		StrStrI(modversion, _T("A.i.d.e-A.D.S.L"))||
		StrStrI(modversion, _T("albaR"))||
		StrStrI(modversion, _T("AngelDr"))||	//5/2006
		StrStrI(modversion, _T("Tombstone Reloaded"))|| //5/2006
		StrStrI(modversion, _T("Tombstone Next"))|| //10/2006
		StrStrI(modversion, _T("pP.r8b"))|| //5/2006
		StrStrI(modversion, _T("x0Rz!$T"))|| //E/xorzist
		StrStrI(modversion, _T("xORz!T"))||
		StrStrI(clientversion,_T("eMule Compat v0.40")) || //7/2006
		StrStrI(clientversion,_T("eMule Compat v127.")) || //8/2006
		StrStrI(modversion, _T("No Ratio"))|| //based on scarangel 7/2006
		StrStrI(modversion, _T("DeathAngel"))|| //based on Xtreme 8/2006
		StrStrI(modversion, _T("PROemule"))||	//9/2006
		StrStrI(modversion, _T("Simple Leecher"))||	//9/2006
		StrStrI(modversion, _T("oFF *+*"))||	//10/2006
		StrStrI(modversion, _T("0FF "))||	//6/2007
		StrStrI(modversion, _T("D10T"))||	//12/2006
		StrStrI(modversion, _T("the fonz"))||	//12/2006
		StrStrI(modversion, _T("TurkMule"))||	//1/2007
		StrStrI(modversion, _T("Hyperdrive"))||	//1/2007
		StrStrI(modversion, _T("Pimp"))||	//3/2007
		StrStrI(modversion, _T("XDP "))||	//6/2007
		StrStrI(modversion, _T("AeOnFlux"))||	//8/2007
		//8/2007 from dlarge:
		StrStrI(modversion, _T("Final Fight"))|| //added dlarge
		StrStrI(modversion, _T("Fireball"))||	//added dlarge "standart String"
		StrStrI(modversion, _T("SunPower"))||	//added dlarge "standart String"
		StrStrI(modversion, _T("SuperKiller"))|| //added dlarge
		StrStrI(modversion, _T("X-Cite"))|| //added dlarge
		StrStrI(modversion, _T("waZZa"))|| //added dlarge
		StrStrI(modversion, _T("Merza"))|| //added dlarge
		StrStrI(modversion, _T("K.O.T."))|| //added dlarge
		StrStrI(modversion, _T("Licokine"))|| //added dlarge
		StrStrI(modversion, _T("BlackStar"))|| //added dlarge
		StrStrI(modversion, _T("nEwLoGic"))|| //added dlarge
		//end
		StrStrI(modversion, _T("Applejuice"))|| //6/2007 now ban instead score reduce
		_tcslen(modversion) > 0 && (StrStrI(clientversion,_T("edonkey")) || modversion[0]==_T('['))   ||  //1. donkey user with modstring, 2. modstring begins with [ this is a known leecher
		(StrStrI(modversion, _T("Xtreme")) && StrStrI(modversion, _T("]")))  //bad Xtreme mod
		)
		return _T("Bad MODSTRING");

	if(StrStr(modversion, _T("xtreme"))) //case sensitive!
		return _T("Fake Xtreme");


	return NULL;
}

LPCTSTR __declspec(dllexport) DLPCheckModstring_Soft(LPCTSTR modversion, LPCTSTR clientversion)
{
	if(modversion==NULL || clientversion==NULL)
		return NULL;

	if (
		StrStrI(modversion,_T("Rockesel")) || 
		StrStrI(modversion,_T("HARDMULE")) ||
		StrStrI(modversion, _T("Community"))|| 
		StrStrI(modversion,_T("IcE-MoD"))||
		StrStrI(modversion,_T("a-eDit"))||
		StrStrI(modversion, _T("Ultimativ"))||
		StrStrI(modversion, _T("Ultimate"))||
		StrStrI(modversion, _T("Ulti F"))||
		StrStrI(modversion, _T("Enter MoD Name"))||	
		StrStrI(modversion, _T("Dein Modstring"))||	// 3/2007
		StrStrI(modversion, _T("choose your modstring"))|| // 3/2007
		//8/2007 from dlarge:
		StrStrI(modversion, _T("Enter Your Modstring"))|| //added dlarge
		StrStrI(modversion, _T("C-E-R-E-B-R-O")) || //added dlarge
		//end
		StrStrI(modversion, _T("NewMule"))||
		StrStrI(modversion, _T("smart- muli"))||
		StrStrI(modversion, _T("NextEvolution"))||	//1/2007
		StrStrI(modversion, _T("SmartMuli"))||	//12/2006
		StrStrI(modversion, _T("TCMatic 3"))|| //1/2007  //version 3 is the public version and used as leecher
		StrStrI(clientversion,_T("eMule v2.0")) || //6/2007 fake Xtreme / GPL-breaker
		StrStrI(modversion, _T("uptempo"))||
		StrStrI(modversion, _T("Arabella"))||
		StrStrI(modversion, _T("Spike2 +")) //added JvA
		)
		return _T("Bad MODSTRING");


	return NULL;
}

LPCTSTR __declspec(dllexport) DLPCheckUsername_Hard(LPCTSTR username)
{
	if(username==NULL)
		return NULL;

	if (
		StrStrI(username,_T("emule-speed"))||
		StrStrI(username,_T("Intuition"))||
		StrStrI(username,_T("emule-element"))||
		StrStrI(username,_T("Ketamine")) ||
		StrStrI(username,_T("www.emuleech.com")) ||
		StrStr(username, _T("UnKnOwN pOiSoN"))||
		StrStrI(username, _T("EGOmule"))||
		StrStrI(username, _T("-=EGOist=-"))||
		StrStrI(username, _T("Muli_Checka"))||
		StrStrI(username,_T("00de.de"))|| 
		StrCmpI(username, _T("Muse"))==0 || //ketamine mod
		StrStrI(username,_T("futurezone-reloaded")) ||
		StrStrI(username,_T("Gate-To-Darkness.com")) ||
		StrStrI(username,_T("www.emule.razorback3.com")) ||
		StrStrI(username,_T("www.Titanesel.tk")) ||
		StrStrI(username,_T("www.bigbang.to")) ||
		StrStrI(username,_T("leecherclients.org")) ||  //Xman 10/06
		StrStrI(username,_T("futuremods.de")) ||  //Xman 10/06
		StrStrI(username,_T("emule-mods.cc")) || //Xman 01/07
		//08/2007 from dlarge:
		StrStrI(username,_T("www.leecher-world.com")) || //added dlarge
		StrStrI(username,_T("www.leecher.biz")) || //added dlarge
		//end
		//Xman 6/2007:
		StrStrI(username,_T("AppleJuice")) && StrStrI(username,_T("[")) && StrStrI(username,_T("]")) ||
		StrStrI(username,_T("[LSD.19"))	//Xman 21.06.2005 definitive not a good mod, with protocol bugs
		)
		return _T("Bad USERNAME");


	//new ketamine
	//if(StrStrI(username, _T("[ePlus]")) != StrRStrI(username,NULL, _T("[ePlus]"))) //old version
	if(_tcslen(username) >=14)
	{
		LPCTSTR tempstr=StrStr(username, _T("[ePlus]"));
		if(tempstr && _tcslen(tempstr)>=7)
			if(StrStr(tempstr + 7, _T("[ePlus]")))
				return _T("new Ketamine");
	}

	return NULL;
}

LPCTSTR __declspec(dllexport) DLPCheckUsername_Soft(LPCTSTR username)
{
	if(username==NULL)
		return NULL;

	if (
		
		StrStrI(username, _T(">>Power-Mod")) ||
		StrStrI(username,_T(".::Stenoco-Zone::.")) 
		)
		return _T("Bad USERNAME");

	//bad mods, where every second sign is
	//enough to check two places

	if(_tcslen(username) >=4 
		&&	username[3]<=0x1F
		&& username[1]<=0x1F
		)
		return _T("Community-Username"); //community (based on LSD or it's smasher)

	if(_tcslen(username) >=4 
		&& username[0]==_T('v')
		&& StrStr(username, _T(":com "))
		)
		return _T("X-Treme");

	return NULL;
}

LPCTSTR __declspec(dllexport) DLPCheckNameAndHashAndMod(CString username, CString& userhash, CString& modversion)
{
	if(username.IsEmpty() || userhash.IsEmpty())
		return NULL;

	//Check for aedit
	//remark: a unmodded emule can't send a space at last sign
	if(modversion.IsEmpty() && username.Right(1)==32)
		return _T("AEdit");

	//Check for Hex-Modstring
	if(IsTypicalHex(modversion))
		return _T("Hex-Modstring");

	//community check
	if(username.GetLength()>=7 && username.Right(1)==_T("]"))
	{
		//check for special nickaddon
		int find=username.ReverseFind(_T('['));
		if(find>=0 )
		{
			CString addon=username.Mid(find+1);
			int endpos=addon.GetLength()-1;
			if(addon.GetLength()>2)
			{
				//Chek for Hex (e.g. X-Treme)
				if(IsTypicalHex(addon.Left(addon.GetLength()-1)))
					return _T("Hex-Code-Addon");
			}
		}
	}

	//thx cyrex
	if(modversion.GetLength() == 10 && username.GetLength()>4 &&  StrStr(username.Right(4),_T("/]"))  && StrStr(username,_T("[SE]")))
		return _T("Mystery ModString");

	return NULL;
}

LPCTSTR __declspec(dllexport) DLPCheckMessageSpam(LPCTSTR messagetext)
{
	if(messagetext==NULL)
		return NULL;


	if(
		StrStr(messagetext, _T("ZamBoR")) ||
		StrStr(messagetext, _T("DI-Emule")) ||
		StrStr(messagetext, _T("Join the L33cher")) ||
		StrStr(messagetext, _T("eMule FX")) ||
		StrStr(messagetext, _T("---> ed2k://|file|Ketamine")) ||
		StrStr(messagetext, _T("robot from RIAA, you can't fight")) ||
		StrStr(messagetext, _T("agent from PeerFactor, she advises you to stop")) ||
		StrStr(messagetext, _T("bot from MPAA, you can't do anything against her")) ||
		StrStr(messagetext, _T("[Sangue-Suga]")) || //3 /2007
		StrStr(messagetext, _T("[te@m projekt")) || //5 /2007
		StrStr(messagetext, _T("eMule PRO Ultra2")) || //8/2007
		StrStr(messagetext, _T("HyperMule")) || //8/2007
		StrStr(messagetext, _T("FXeMule")) 
		)
		return (_T("Spam-Message"));

	if(CString(messagetext).Trim().IsEmpty())
		return (_T("Spam-Message"));

	return NULL;
}

LPCTSTR __declspec(dllexport) DLPCheckHelloTag(UINT tagnumber)
{
	LPCTSTR strSnafuTag=NULL;
	switch(tagnumber)
	{
		case CT_UNKNOWNx12:
		case CT_UNKNOWNx13:
		case CT_UNKNOWNx14:
		case CT_UNKNOWNx16:
		case CT_UNKNOWNx17:
		case CT_UNKNOWNxE6:			strSnafuTag=apszSnafuTag[0];break;//buffer=_T("DodgeBoards");break;
		case CT_UNKNOWNx15:			strSnafuTag=apszSnafuTag[1];break;//buffer=_T("DodgeBoards & DarkMule |eVorte|X|");break;
		case CT_UNKNOWNx22:			strSnafuTag=apszSnafuTag[2];break;//buffer=_T("DarkMule v6 |eVorte|X|");break;
		case CT_UNKNOWNx5D:
		case CT_UNKNOWNx6B:
		case CT_UNKNOWNx6C:			strSnafuTag=apszSnafuTag[17];break;
		case CT_UNKNOWNx74:
		case CT_UNKNOWNx87:			strSnafuTag=apszSnafuTag[17];break;
		case CT_UNKNOWNxF0:
		case CT_UNKNOWNxF4:			strSnafuTag=apszSnafuTag[17];break;
			//case CT_UNKNOWNx69:			strSnafuTag=apszSnafuTag[3];break;//buffer=_T("eMuleReactor");break;
		case CT_UNKNOWNx79:			strSnafuTag=apszSnafuTag[4];break;//buffer=_T("Bionic");break;
		case CT_UNKNOWNx83:			strSnafuTag=apszSnafuTag[15];break;//buffer=_T("Fusspi");break;
		case CT_UNKNOWNx76:			
		case CT_UNKNOWNxCD:			strSnafuTag=apszSnafuTag[16];break;//buffer=_T("www.donkey2002.to");break;
		case CT_UNKNOWNx88:
				strSnafuTag=apszSnafuTag[5];//[LSD7c]
			break;
		case CT_UNKNOWNx8c:			strSnafuTag=apszSnafuTag[5];break;//buffer=_T("[LSD7c]");break; 
		case CT_UNKNOWNx8d:			strSnafuTag=apszSnafuTag[6];break;//buffer=_T("[0x8d] unknown Leecher - (client version:60)");break;
		case CT_UNKNOWNx99:			strSnafuTag=apszSnafuTag[7];break;//buffer=_T("[RAMMSTEIN]");break;		//STRIKE BACK
		case CT_UNKNOWNx97:
		case CT_UNKNOWNx98:
		case CT_UNKNOWNx9C:
		case CT_UNKNOWNxDA:			strSnafuTag=apszSnafuTag[3];break;//buffer=_T("eMuleReactor");break;
		case CT_UNKNOWNxC8:			//Xman x4
		case CT_UNKNOWNxCE:			//Xman 20.08.05
		case CT_UNKNOWNxCF:			//Xman 20.08.05
		case CT_UNKNOWNx94:			//Xman 20.08.05
		case CT_UNKNOWNxc4:			strSnafuTag=apszSnafuTag[8];break;//buffer=_T("[MD5 Community]");break;	//USED BY NEW BIONIC => 0x12 Sender
		case CT_UNKNOWNxEC:			strSnafuTag=apszSnafuTag[18];break; //Xman x4 Speedmule
		case CT_DARK:				//STRIKE BACK
		case CT_UNKNOWNx7A:
		case CT_UNKNOWNxCA:
			strSnafuTag=apszSnafuTag[9];break;//buffer=_T("new DarkMule");
		case CT_UNKNOWNx4D:
			strSnafuTag=apszSnafuTag[19];break;// pimp my mule misuse an official tag in hello
			
	}

	return strSnafuTag;
}

LPCTSTR __declspec(dllexport) DLPCheckInfoTag(UINT tagnumber)
{
	LPCTSTR strSnafuTag=NULL;

	switch(tagnumber)
	{
	case ET_MOD_UNKNOWNx12:
	case ET_MOD_UNKNOWNx13:
	case ET_MOD_UNKNOWNx14:
	case ET_MOD_UNKNOWNx17:		strSnafuTag=apszSnafuTag[0];break;//("[DodgeBoards]")
	case ET_MOD_UNKNOWNx2F:		strSnafuTag=apszSnafuTag[10];break;//buffer=_T("[OMEGA v.07 Heiko]");break;
	case ET_MOD_UNKNOWNx36:
	case ET_MOD_UNKNOWNx5B:
	case ET_MOD_UNKNOWNxA6:		strSnafuTag=apszSnafuTag[11];break;//buffer=_T("eMule v0.26 Leecher");break;
	case ET_MOD_UNKNOWNx60:		strSnafuTag=apszSnafuTag[12];break;//buffer=_T("[Hunter]");break; //STRIKE BACK
	case ET_MOD_UNKNOWNx76:		strSnafuTag=apszSnafuTag[0];break;//buffer=_T("[DodgeBoards]");break;
	case ET_MOD_UNKNOWNx50:		
	case ET_MOD_UNKNOWNxB1:		
	case ET_MOD_UNKNOWNxB4:		
	case ET_MOD_UNKNOWNxC8:		
	case ET_MOD_UNKNOWNxC9:		strSnafuTag=apszSnafuTag[13];break;//buffer=_T("[Bionic 0.20 Beta]");break;
	case ET_MOD_UNKNOWNxDA:		strSnafuTag=apszSnafuTag[14];break;//buffer=_T("[Rumata (rus)(Plus v1f)]");break;
	}

	return strSnafuTag;
}
