//this file is part of X-Ray Mule
//Copyright (C)2006 Jan van Achterin ( http://sourceforge.net/projects/x-ray-mule )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once

// Misc. Resources
#define	IDS_FORCE						6000
#define	IDS_STALLED						6001
#define	IDC_LEECHER_LOG					6002
#define	IDS_SV_LEECHER_LOG				6003
#define IDC_MOD_LOG						6004
#define	IDS_SV_MOD_LOG					6005
#define	IDB_SPLASH						6006
#define	IDS_TOTALUPDOWN					6007
#define	IDS_CHUNK						6008
#define IDS_SUQWT_LOAD                  6009
#define	IDS_SUSPEND						6010
#define	IDS_SUSPEND_SHORT				6011
#define	IDS_SUSPENDDL					6012
#define	IDS_STANDBY						6013
#define	IDS_STOP_CLIENT					6014
#define IDS_DROP_UNKNOWN                6015
#define IDS_DROP_TMC                    6016
#define IDS_DROP_LOWIPTOLOWIP           6017
#define IDS_DROP_NNS                    6018
#define IDS_DROP_HQS                    6019
#define IDS_DROP_FQS                    6020
#define IDS_DROP_SENSELESSSRC           6021
#define IDS_DROP_MENU                   6022
#define	IDS_GLOBAL_HL_CONTEXT			6026
#define IDS_GLOBAL_HL_CONTEXT_MULTI		6027
#define	IDS_VISITXVERSIONCHECK			6028
#define	IDS_XVERSIONCHECK				6029
#define	IDS_NONEWXVERVERSION			6030
#define	IDS_NEWXVERSIONAVL				6031
#define	IDS_NEWXVERSIONAVLPOPUP			6032
#define	IDS_IP2COUNTRY_DWNFILE			6033
#define IDS_LOG_ERRDWN					6034
#define IDS_IP2COUNTRY_ERROR1			6035
#define IDS_IP2COUNTRY_ERROR2			6036
#define IDS_IP2COUNTRY_ERROR3			6037
#define IDS_IP2COUNTRY_ERROR4			6038
#define IDS_IP2COUNTRY_ERROR5			6039
#define IDS_IP2COUNTRY_ERROR6			6040
#define IDS_IP2COUNTRY_ERROR7			6041
#define IDS_IP2COUNTRY_ERROR8			6042
#define IDS_IP2COUNTRY_FILELOAD			6043
#define IDS_IP2COUNTRY_FLAGLOAD			6044
#define IDS_IP2COUNTRY_FLAGUNLD			6045
#define IDS_IP2COUNTRY_INFO				6046
#define IDS_IP2COUNTRY_LOADED			6047
#define IDS_IP2COUNTRY_LOADED2			6048
#define IDS_IP2COUNTRY_MSG1				6049
#define IDS_IP2COUNTRY_MSG2				6050
#define IDS_IP2COUNTRY_NASHORT			6051
#define IDS_IP2COUNTRY_NALONG			6052
#define IDS_IP2COUNTRY_UNLOADED			6053
#define IDS_IP2COUNTRY_UPLOAD			6054
#define	IDS_IP2COUNTRY_UPUNLOAD			6055
#define	IDS_COUNTRY						6056
#define	IDS_SLS							6057
#define	IDC_LST_UP						6058
#define	IDC_CMSTATUS					6059
#define	IDC_CMSTATUS_UP					6060
#define	IDS_DOWNFILES_NONE				6061
#define	IDS_DOWNFILES_COUNT				6062
#define	IDS_REQUESTED_FILES				6063
#define	IDS_UPFILES_NONE				6064
#define	IDS_UPFILES_COUNT				6065
#define IDS_XRAY_HP_LINK				6066
#define	IDS_MISC						6067
#define	IDS_SOURCECACHE					6068
#define	IDS_SOURCECACHEAMOUNT			6069
#define	IDS_REBINDUPNP					6070
#define	IDS_SHAREDPARTS_PART_DONE		6071
#define	IDS_SHAREDPARTS_PART_INCOMPLETE	6072
#define	IDS_SHAREDPARTS					6073
#define	IDS_STANDBY_STALLED				6074
#define	IDS_UPLOADENDSSOON				6075

// Toolbar
#define IDC_TB_BTN_CONNECT				7001
#define IDC_TB_BTN_KADEMLIA				7002
#define IDC_TB_BTN_SERVER				7003
#define IDC_TB_BTN_TRANSFER				7004
#define IDC_TB_BTN_SEARCH				7005
#define IDC_TB_BTN_FILES				7006
#define IDC_TB_BTN_MESSAGES				7007
#define IDC_TB_BTN_IRC					7008
#define IDC_TB_BTN_STATISTIC			7009
#define IDC_TB_BTN_PREFERENCES			7010
#define IDC_TB_BTN_TOOLS				7011
#define IDC_TB_BTN_HELP					7012
#define IDB_TB_CONNECT_NORMAL			7013
#define IDB_TB_CONNECT_OVER				7014
#define IDB_TB_CONNECT_CLICK			7015
#define IDB_TB_KADEMLIA_NORMAL			7016
#define IDB_TB_KADEMLIA_OVER			7017
#define IDB_TB_KADEMLIA_CLICK			7018
#define IDB_TB_SERVER_NORMAL			7019
#define IDB_TB_SERVER_OVER				7020
#define IDB_TB_SERVER_CLICK				7021
#define IDB_TB_TRANSFER_NORMAL			7022
#define IDB_TB_TRANSFER_OVER			7023
#define IDB_TB_TRANSFER_CLICK			7024
#define IDB_TB_SEARCH_NORMAL			7025
#define IDB_TB_SEARCH_OVER				7026
#define IDB_TB_SEARCH_CLICK				7027
#define IDB_TB_FILES_NORMAL				7028
#define IDB_TB_FILES_OVER				7029
#define IDB_TB_FILES_CLICK				7030
#define IDB_TB_MESSAGES_NORMAL			7031
#define IDB_TB_MESSAGES_OVER			7032
#define IDB_TB_MESSAGES_CLICK			7033
#define IDB_TB_IRC_NORMAL				7034
#define IDB_TB_IRC_OVER					7035
#define IDB_TB_IRC_CLICK				7036
#define IDB_TB_STATISTIC_NORMAL			7037
#define IDB_TB_STATISTIC_OVER			7038
#define IDB_TB_STATISTIC_CLICK			7039
#define IDB_TB_PREFERENCES_NORMAL		7040
#define IDB_TB_PREFERENCES_OVER			7041
#define IDB_TB_PREFERENCES_CLICK		7042
#define IDB_TB_TOOLS_NORMAL				7043
#define IDB_TB_TOOLS_OVER				7044
#define IDB_TB_TOOLS_CLICK				7045
#define IDB_TB_HELP_NORMAL				7046
#define IDB_TB_HELP_OVER				7047
#define IDB_TB_HELP_CLICK				7048
#define IDB_TB_CONNECTED_OVER			7049
#define	IDB_TB_CONNECTED_CLICK			7050
#define IDR_TB_TOOLBAR_LEFT				7051
#define IDR_TB_TOOLBAR_CENTER			7052
#define IDR_TB_TOOLBAR_RIGHT			7053
#define IDB_TB_CONNECTING_CLICK			7054
#define IDB_TB_CONNECTING_OVER			7055
#define IDD_SPEEDGRAPH                  7056
#define	IDB_TB_CONNECTED_NORMAL			7057
#define	IDB_TB_CONNECTING_NORMAL		7058

// Preferences Strings
#define IDS_PRF_XRAY_GRP				7100
#define	IDS_PRF_X_GUI					7102
#define IDS_PRF_X_CONNECTION			7103
#define	IDS_PRF_X_UPLOAD				7104
#define	IDS_PRF_X_DOWNLOAD				7105
#define	IDS_PRF_X_SHARE					7106
#define	IDS_PRF_X_SECURITY				7107
#define	IDS_PRF_X_GENERAL				7108
#define	IDS_PRF_X_DROP					7109
#define	IDS_PRF_X_UPDATE				7110

// Additional Pages
#define	IDD_PPG_X_GUI					7200
#define	IDD_PPG_X_CONNECTION			7201
#define	IDD_PPG_X_UPLOAD				7202
#define	IDD_PPG_X_DOWNLOAD				7203
#define	IDD_PPG_X_SHARE					7204
#define	IDD_PPG_X_ARGOS					7205
#define	IDD_PPG_X_GENERAL				7206
#define	IDD_PPG_X_DROP					7207
#define	IDD_PPG_X_UPDATE				7208
#define	IDD_REQFILES					7209
#define	IDD_ARGOSCLIENT					7210
#define	IDD_MASSRENAME					7211
#define	IDD_SIMPLECLEANUP				7212

// Prefpages: GUI
#define	IDC_PRF_GUI_MISC_GRP			7300
#define	IDC_PRF_GUI_MISC_CP_CHK			7301
#define	IDS_PRF_GUI_MISC_CP_CHK			7302
#define	IDC_PRF_GUI_MISC_SDL_CHK		7303
#define	IDS_PRF_GUI_MISC_SDL_CHK		7304
#define	IDC_PRF_GUI_TOOLBAR_GRP			7305
#define	IDS_PRF_GUI_TOOLBAR_GRP			7306
#define	IDC_PRF_GUI_TB_HIDE_LBL			7307
#define	IDS_PRF_GUI_TB_HIDE_LBL			7308
#define	IDC_PRF_GUI_TB_SHOW_LBL			7309
#define	IDS_PRF_GUI_TB_SHOW_LBL			7310
#define	IDC_PRF_GUI_TB_ACTIVE_LBL		7311
#define	IDS_PRF_GUI_TB_ACTIVE_LBL		7312
#define	IDC_PRF_GUI_TB_MOVER_LBL		7313
#define	IDS_PRF_GUI_TB_MOVER_LBL		7314
#define	IDC_PRF_GUI_TB_ACTIVEMOVER_LBL	7315
#define	IDS_PRF_GUI_TB_ACTIVEMOVER_LBL	7316
#define	IDC_PRF_GUI_TB_LBL				7317
#define	IDS_PRF_GUI_TB_LBL				7318
#define	IDC_PRF_GUI_I2P_GRP				7319
#define	IDS_PRF_GUI_I2P_GRP				7320
#define	IDC_PRF_GUI_I2P_FLAGS_CHK		7321
#define	IDS_PRF_GUI_I2P_FLAGS_CHK		7322
#define	IDC_PRF_GUI_I2P_2LETTERS_RADIO	7323
#define	IDS_PRF_GUI_I2P_2LETTERS_RADIO	7324
#define	IDC_PRF_GUI_I2P_3LETTERS_RADIO	7325
#define	IDS_PRF_GUI_I2P_3LETTERS_RADIO	7326
#define	IDC_PRF_GUI_I2P_FULL_RADIO		7327
#define	IDS_PRF_GUI_I2P_FULL_RADIO		7328
#define	IDC_PRF_GUI_FSI_CHK				7329
#define	IDS_PRF_GUI_FSI_CHK				7330

// Prefpages: Upload
#define	IDC_PRF_UP_SLOTCTRL_GRP			7500
#define	IDS_PRF_UP_SLOTCTRL_GRP			7501
#define	IDC_PRF_UP_SLOTCTRL_SLIDER		7502
#define	IDC_PRF_UP_SLOTCTRL_LBL			7503

// Prefpages: Share
#define	IDC_PRF_SHARE_TWEAKS_GRP		7700
#define	IDS_PRF_SHARE_TWEAKS_GRP		7701
#define	IDC_PRF_SHARE_TWEAKS_QPF_CHK	7702
#define	IDS_PRF_SHARE_TWEAKS_QPF_CHK	7703
#define	IDC_PRF_SHARE_TWEAKS_SUQWT_CHK	7704
#define	IDS_PRF_SHARE_TWEAKS_SUQWT_CHK	7705
#define	IDC_PRF_SHARE_RELEASEBONUS_GRP	7730
#define	IDS_PRF_SHARE_RELEASEBONUS_GRP	7731
#define	IDC_PRF_SHARE_RELBONUS_CHK		7732
#define	IDS_PRF_SHARE_RELBONUS_CHK		7733
#define	IDC_PRF_SHARE_RELBONUS_6H		7734
#define	IDS_PRF_SHARE_RELBONUS_6H		7735
#define	IDC_PRF_SHARE_RELBONUS_12H		7736
#define	IDS_PRF_SHARE_RELBONUS_12H		7737
#define	IDC_PRF_SHARE_RELBONUS_1D		7738
#define	IDS_PRF_SHARE_RELBONUS_1D		7739
#define	IDC_PRF_SHARE_RELBONUS_2D		7740
#define	IDS_PRF_SHARE_RELBONUS_2D		7741
#define	IDC_PRF_SHARE_RELBONUS_4D		7742
#define	IDS_PRF_SHARE_RELBONUS_4D		7743
#define	IDC_PRF_SHARE_RELBONUS_8D		7744
#define	IDS_PRF_SHARE_RELBONUS_8D		7745
#define	IDC_PRF_SHARE_TWEAKS_INFQUEUE_CHK 7746
#define	IDS_PRF_SHARE_TWEAKS_INFQUEUE_CHK 7747
#define	IDC_PRF_SHARE_PBF_GRP			7748
#define	IDS_PRF_SHARE_PBF_GRP			7749
#define	IDC_PRF_SHARE_PBF_SUI_CHK		7750
#define	IDS_PRF_SHARE_PBF_SUI_CHK		7751
#define	IDC_PRF_SHARE_PBF_SUI_LBL		7752
#define	IDC_PRF_SHARE_PBF_SUI_VALUE		7753
#define	IDC_PRF_SHARE_PBF_NONSUI_CHK	7754
#define	IDS_PRF_SHARE_PBF_NONSUI_CHK	7755
#define	IDC_PRF_SHARE_PBF_NONSUI_LBL	7756
#define	IDC_PBF_SHARE_PBF_NONSUI_VALUE	7757
#define	IDS_PRF_SHARE_PBF_LBL			7758
#define	IDC_PRF_SHARE_PS_GRP			7759
#define	IDC_PRF_SHARE_PS_CHK			7760
#define	IDS_PRF_SHARE_PS_CHK			7761
#define	IDC_PRF_SHARE_PS_ON_RADIO		7762
#define	IDC_PRF_SHARE_PS_AUTO_RADIO		7763
#define	IDC_PRF_SHARE_PS_LIM_RADIO		7764
#define	IDC_PRF_SHARE_PS_LIM_SRC_LBL	7765
#define	IDC_PRF_SHARE_PS_LIM_SRC_VALUE	7766

// Prefpages: Connection
#define	IDC_PRF_CON_CONTROL_GRP			7900
#define	IDS_PRF_CON_CONTROL_GRP			7901
#define	IDC_PRF_CON_CONTROL_ACC_CHK		7902
#define	IDS_PRF_CON_CONTROL_ACC_CHK		7903
#define	IDC_PRF_CON_CONTROL_ASL_CHK		7904
#define	IDS_PRF_CON_CONTROL_ASL_CHK		7905
#define	IDC_PRF_CON_CONTROL_ASL_LBL		7906
#define	IDS_PRF_CON_CONTROL_ASL_LBL		7907
#define	IDC_PRF_CON_CONTROL_ASL_VALUE	7908
#define	IDC_PRF_CON_CONCHK_GRP			7909
#define	IDS_PRF_CON_CONCHK_GRP			7910
#define	IDC_PRF_CON_CONCHK_CHK			7911
#define	IDS_PRF_CON_CONCHK_CHK			7912
#define	IDC_PRF_CON_CONCHK_ICMP_CHK		7913
#define	IDS_PRF_CON_CONCHK_ICMP_CHK		7914
#define	IDC_PRF_CON_CONCHK_PING_LBL		7915
#define	IDS_PRF_CON_CONCHK_PING_LBL		7916
#define	IDC_PRF_CON_CONCHK_PING_VALUE	7917
#define	IDC_PRF_CON_CONCHK_TTL_LBL		7918
#define	IDS_PRF_CON_CONCHK_TTL_LBL		7919
#define	IDC_PRF_CON_CONCHK_TTL_VALUE	7920
#define	IDC_PRF_CON_CONTROL_RASAIPC_CHK	7921
#define	IDS_PRF_CON_CONTROL_RASAIPC_CHK	7922
#define	IDC_PRF_CON_CONTROL_RATIMER_LBL	7923
#define	IDS_PRF_CON_CONTROL_RATIMER_LBL	7924
#define	IDC_PRF_CON_CONTROL_RATIMER_SLIDER 7925
#define	IDC_PRF_CON_CONTROL_RATIMER_VALUE 7926
#define	IDC_PRF_CON_CONTROL_ASLGLOBAL_LBL 7927
#define	IDS_PRF_CON_CONTROL_ASLGLOBAL_LBL 7928
#define	IDC_PRF_CON_CONTROL_ASLGLOBAL_VALUE 7929

// Prefpages: General
#define	IDC_PRF_GEN_NICEHASH_GRP		8000
#define	IDS_PRF_GEN_NICEHASH_GRP		8001
#define	IDC_PRF_GEN_NICEHASH_SLIDER		8002
#define	IDC_PRF_GEN_NICEHASH_RIGHT_LBL	8003
#define	IDS_PRF_GEN_NICEHASH_RIGHT_LBL	8004
#define	IDC_PRF_GEN_NICEHASH_LEFT_LBL	8005
#define	IDS_PRF_GEN_NICEHASH_LEFT_LBL	8006
#define	IDC_PRF_GEN_NICEHASH_STATIC		8007
#define	IDS_PRF_GEN_NICEHASH_STATIC		8008
#define	IDC_PRF_GEN_PROCESS_GRP			8009
#define	IDS_PRF_GEN_PROCESS_GRP			8010
#define	IDC_PRF_GEN_PROCESS_RADIO1		8011
#define	IDS_PRF_GEN_PROCESS_RADIO1		8012
#define	IDC_PRF_GEN_PROCESS_RADIO2		8013
#define	IDS_PRF_GEN_PROCESS_RADIO2		8014
#define	IDC_PRF_GEN_PROCESS_RADIO3		8015
#define	IDS_PRF_GEN_PROCESS_RADIO3		8016
#define	IDC_PRF_GEN_MISC_GRP			8017
#define	IDC_PRF_GEN_MISC_DKSTATICSERV	8018
#define	IDS_PRF_GEN_MISC_DKSTATICSERV	8019

// Prefpages: DropSystem
#define	IDC_PRF_DROP_NNS_GRP			8100
#define	IDS_PRF_DROP_NNS_GRP			8101
#define	IDC_PRF_DROP_NNS_CHK			8102
#define	IDS_PRF_DROP_NNS_CHK			8103
#define	IDC_PRF_DROP_NNS_PERCENT_LBL	8104
#define	IDS_PRF_DROP_NNS_PERCENT_LBL	8105
#define	IDC_PRF_DROP_NNS_PERCENT_VALUE	8106
#define	IDC_PRF_DROP_NNS_TIMER_LBL		8107
#define	IDS_PRF_DROP_NNS_TIMER_LBL		8108
#define	IDC_PRF_DROP_NNS_TIMER_VALUE	8109
#define	IDC_PRF_DROP_NNS_BANTIME_LBL	8110
#define	IDS_PRF_DROP_NNS_BANTIME_LBL	8111
#define	IDC_PRF_DROP_NNS_BANTIME_VALUE	8112
#define	IDC_PRF_DROP_FQS_GRP			8113
#define	IDS_PRF_DROP_FQS_GRP			8114
#define	IDC_PRF_DROP_FQS_CHK			8115
#define	IDS_PRF_DROP_FQS_CHK			8116
#define	IDC_PRF_DROP_FQS_PERCENT_LBL	8117
#define	IDS_PRF_DROP_FQS_PERCENT_LBL	8118
#define	IDC_PRF_DROP_FQS_PERCENT_VALUE	8119
#define	IDC_PRF_DROP_FQS_TIMER_LBL		8120
#define	IDS_PRF_DROP_FQS_TIMER_LBL		8121
#define	IDC_PRF_DROP_FQS_TIMER_VALUE	8122
#define	IDC_PRF_DROP_FQS_BANTIME_LBL	8123
#define	IDS_PRF_DROP_FQS_BANTIME_LBL	8124
#define	IDC_PRF_DROP_FQS_BANTIME_VALUE	8125
#define	IDC_PRF_DROP_HQS_GRP			8126
#define	IDS_PRF_DROP_HQS_GRP			8127
#define	IDC_PRF_DROP_HQS_CHK			8128
#define	IDS_PRF_DROP_HQS_CHK			8129
#define	IDC_PRF_DROP_HQS_PERCENT_LBL	8130
#define	IDS_PRF_DROP_HQS_PERCENT_LBL	8131
#define	IDC_PRF_DROP_HQS_PERCENT_VALUE	8132
#define	IDC_PRF_DROP_HQS_TIMER_LBL		8133
#define	IDS_PRF_DROP_HQS_TIMER_LBL		8134
#define	IDC_PRF_DROP_HQS_TIMER_VALUE	8135
#define	IDC_PRF_DROP_HQS_BANTIME_LBL	8136
#define	IDS_PRF_DROP_HQS_BANTIME_LBL	8137
#define	IDC_PRF_DROP_HQS_BANTIME_VALUE	8138
#define	IDC_PRF_DROP_HQS_QR_LBL			8139
#define	IDS_PRF_DROP_HQS_QR_LBL			8140
#define	IDC_PRF_DROP_HQS_QR_VALUE		8141
#define	IDC_PRF_DROP_BANTIME_GRP		8142
#define	IDS_PRF_DROP_BANTIME_GRP		8143
#define	IDC_PRF_DROP_BANTIME_L2L_LBL	8144
#define	IDS_PRF_DROP_BANTIME_L2L_LBL	8145
#define	IDC_PRF_DROP_BANTIME_L2L_VALUE	8146
#define	IDC_PRF_DROP_BANTIME_UNK_LBL	8147
#define	IDS_PRF_DROP_BANTIME_UNK_LBL	8148
#define	IDC_PRF_DROP_BANTIME_UNK_VALUE	8149
#define	IDC_PRF_DROP_BANTIME_TOO_LBL	8150
#define	IDS_PRF_DROP_BANTIME_TOO_LBL	8151
#define	IDC_PRF_DROP_BANTIME_TOO_VALUE	8152
#define	IDS_PRF_DROP_BANTIME_NOBAN		8153
#define	IDS_PRF_DROP_BANTIME_30MIN		8154
#define	IDS_PRF_DROP_BANTIME_1H			8155
#define	IDS_PRF_DROP_BANTIME_2H			8156
#define	IDS_PRF_DROP_BANTIME_3H			8157
#define	IDS_PRF_DROP_BANTIME_6H			8158
#define	IDS_PRF_DROP_BANTIME_12H		8159
#define	IDS_PRF_DROP_BANTIME_24H		8160

// Prefpages: Download
#define	IDC_PRF_DOWN_GHL_GRP			8200
#define IDS_PRF_DOWN_GHL_GRP			8201
#define	IDC_PRF_DOWN_GHL_CHK			8202
#define	IDS_PRF_DOWN_GHL_CHK			8203
#define	IDC_PRF_DOWN_GHL_DEFAULT_CHK	8204
#define	IDS_PRF_DOWN_GHL_DEFAULT_CHK	8205
#define IDC_PRF_DOWN_GHL_LBL			8206
#define	IDS_PRF_DOWN_GHL_LBL			8207
#define	IDC_PRF_DOWN_GHL_VALUE_LBL		8208
#define	IDC_PRF_DOWN_GHL_SLIDER			8209
#define IDC_PRF_DOWN_IF_GRP				8210
#define	IDS_PRF_DOWN_IF_GRP				8211
#define	IDC_PRF_DOWN_IF_CHK				8212
#define	IDS_PRF_DOWN_IF_CHK				8213
#define	IDC_PRF_DOWN_IF_FLUSHTIME_LBL	8214
#define	IDS_PRF_DOWN_IF_FLUSHTIME_LBL	8215
#define	IDC_PRF_DOWN_IF_FLUSHTIME_VALUE	8216
#define	IDC_PRF_DOWN_IF_FLUSHTIME_SLIDER 8217
#define	IDC_PRF_DOWN_IF_FLUSHBUFFER_VALUE 8218
#define	IDC_PRF_DOWN_SLS_GRP			8219
#define	IDS_PRF_DOWN_SLS_GRP			8220
#define	IDC_PRF_DOWN_SLS_CHK			8221
#define	IDS_PRF_DOWN_SLS_CHK			8222
#define	IDC_PRF_DOWN_SLS_ACTIV_LBL		8223
#define	IDS_PRF_DOWN_SLS_ACTIV_LBL		8224
#define	IDC_PRF_DOWN_SLS_ACTIV_VALUE	8225
#define	IDC_PRF_DOWN_SLS_SAVE_LBL		8226
#define	IDS_PRF_DOWN_SLS_SAVE_LBL		8227
#define	IDC_PRF_DOWN_SLS_SAVE_VALUE		8228
#define	IDC_PRF_DOWN_MISC_GRP			8229
#define	IDC_PRF_DOWN_MISC_ICS_CHK		8230
#define	IDS_PRF_DOWN_MISC_ICS_CHK		8231
#define	IDC_PRF_DOWN_MISC_ODCF_CHK		8232
#define	IDS_PRF_DOWN_MISC_ODCF_CHK		8233

// Prefpages: Update
#define	IDC_PRF_UPDATE_IPF_GRP			8300
#define	IDS_PRF_UPDATE_IPF_GRP			8301
#define	IDC_PRF_UPDATE_IPF_PUSHBTN		8302
#define	IDC_PRF_UPDATE_IPF_STARTUP_CHK	8303
#define	IDS_PRF_UPDATE_IPF_STARTUP_CHK	8304
#define	IDC_PRF_UPDATE_IPF_URL_LBL		8305
#define	IDS_PRF_UPDATE_IPF_URL_LBL		8306
#define	IDC_PRF_UPDATE_IPF_URL_BOX		8307
#define	IDC_PRF_UPDATE_IPF_VERSION_LBL	8308
#define	IDC_PRF_UPDATE_IPF_RESET_PUSH	8309
#define	IDC_PRF_UPDATE_I2C_GRP			8310
#define	IDS_PRF_UPDATE_I2C_GRP			8311
#define	IDC_PRF_UPDATE_I2C_PUSHBTN		8312
#define	IDC_PRF_UPDATE_I2C_STARTUP_CHK	8313
#define	IDS_PRF_UPDATE_I2C_STARTUP_CHK	8314
#define	IDC_PRF_UPDATE_I2C_URL_LBL		8315
#define	IDS_PRF_UPDATE_I2C_URL_LBL		8316
#define	IDC_PRF_UPDATE_I2C_URL_BOX		8317
#define	IDC_PRF_UPDATE_I2C_VERSION_LBL	8318
#define	IDC_PRF_UPDATE_I2C_RESET_PUSH	8319
#define	IDC_PRF_UPDATE_I2C_URL2_LBL		8320
#define	IDS_PRF_UPDATE_I2C_URL2_LBL		8321
#define	IDC_PRF_UPDATE_I2C_URL2_BOX		8322

// Tabbed Prefs
#define	IDC_PRF_DOWNLOAD_TAB_NO1		9000
#define	IDC_PRF_DOWNLOAD_TAB_NO2		9001

// ClipStat
#define	IDS_CLIPSTAT_GHL				10000
#define	IDS_CLIPSTAT_GHL4NEW			10001
#define	IDS_CLIPSTAT_GHLSOURCES			10002
#define	IDS_CLIPSTAT_CONCHECKER			10003
#define	IDS_CLIPSTAT_INTELLIFLUSH		10004
#define	IDS_CLIPSTAT_SLS				10005
#define	IDS_CLIPSTAT_PORTS				10006
#define	IDS_CLIPSTAT_REBINDUPNP			10007
#define	IDS_CLIPSTAT_COPY				10008
#define	IDS_CLIPSTAT_ASL				10009
#define	IDS_CLIPSTAT_ACC				10010
#define	IDS_CLIPSTAT_ULSLOTS			10011
#define	IDS_CLIPSTAT_ULOPENMORE			10012
#define	IDS_CLIPSTAT_ARGOS				10013
#define	IDS_CLIPSTAT_ICS				10014
#define	IDS_CLIPSTAT_RASAIPC			10015

// Redesigned Client Detail Dialog
#define	IDC_CDD_MODVER_STATIC			11000
#define	IDC_CDD_MODVER_LBL				11001
#define	IDC_CDD_USERICON				11002
#define	IDC_CDD_TRANSFERICON			11003
#define	IDC_CDD_NETWORKICON				11004
#define	IDC_CDD_SCOREICON				11005
#define	IDC_CDD_NETWORK_HEAD			11006
#define	IDC_CDD_PROTEXT_STATIC			11007
#define	IDC_CDD_PROTEXT_LBL				11008
#define	IDC_CDD_IP2CICON				11009
#define	IDC_CDD_IP2COUNTRY_STATIC		11010
#define	IDC_CDD_IP2COUNTRY_LBL			11011
#define	IDS_CDD_MODVER_STATIC			11012
#define	IDS_CDD_PROTEXT_STATIC			11013

// Argos
#define	IDC_AI_DETECTION				11100
#define	IDC_AI_LNICK					11101
#define	IDC_AI_LNICKCTRL				11102
#define	IDC_AI_LMOD						11103
#define	IDC_AI_LMODCTRL					11104
#define	IDC_AI_NICKTHIEF				11105
#define	IDC_AI_NICKTHIEFCTRL			11106
#define	IDC_AI_OPCODE					11107
#define	IDC_AI_OPCODECTRL				11108
#define	IDC_AI_HASHTHIEF				11109
#define	IDC_AI_HASHTHIEFCTRL			11110
#define	IDC_AI_MODTHIEF					11111
#define	IDC_AI_MODTHIEFCTRL				11112
#define	IDC_AI_HASHCHANGE				11113
#define	IDC_AI_HASHCHANGECTRL			11114
#define	IDC_AI_CREDITHACK				11115
#define	IDC_AI_CREDITHACKCTRL			11116
#define	IDC_AI_FAKECLIENT				11117
#define	IDC_AI_FAKECLIENTCTRL			11118
#define	IDC_AI_GHOSTMOD					11119
#define	IDC_AI_GHOSTMODCTRL				11120
#define	IDC_AI_FILESCANNER				11121
#define	IDC_AI_FILESCANNERCTRL			11122
#define	IDC_AI_AGGRESSIVE				11123
#define	IDC_AI_AGGRESSIVECTRL			11124
#define	IDC_AI_RANKFLOODER				11125
#define	IDC_AI_RANKFLOODERCTRL			11126
#define	IDC_AI_CORRUPTEDSENDER			11127
#define	IDC_AI_CORRUPTEDSENDERCTRL		11128
#define	IDC_AI_SUMMARY					11129
#define	IDC_AI_PUNISHMENT				11130
#define	IDC_AI_PUNISHMENTCTRL			11131
#define	IDC_AI_LASTSEEN					11132
#define	IDC_AI_LASTSEENCTRL				11133
#define	IDC_AI_LASTDETECTION			11134
#define	IDC_AI_LASTDETECTIONCTRL		11135
#define	IDC_AI_LEECHERTYPE				11136
#define	IDC_AI_LEECHERTYPECTRL			11137
#define	IDC_AI_COMMENT					11138
#define	IDC_AI_COMMENTCTRL				11139
#define	IDC_AI_COMPENSATION				11140
#define	IDC_AI_COMPENSATIONCTRL			11141
#define	IDC_AI_FAILEDSOURCE				11142
#define	IDC_AI_FAILEDSOURCECTRL			11143
#define	IDC_AI_SPAMER					11144
#define	IDC_AI_SPAMERCTRL				11145
#define	IDC_AI_SUSPECTHELLO				11146
#define	IDC_AI_SUSPECTHELLOCTRL			11147
#define	IDC_AI_LHASH					11148
#define	IDC_AI_LHASHCTRL				11149
#define	IDC_AI_XSEXPLOITER				11150
#define	IDC_AI_XSEXPLOITERCTRL			11151
#define	IDC_AI_FILEFAKER				11152
#define	IDC_AI_FILEFAKERCTRL			11153
#define	IDC_AI_SUSPECTPROT				11154
#define	IDC_AI_SUSPECTPROTCTRL			11155
#define	IDC_AI_NICKCHANGER				11156
#define	IDC_AI_NICKCHANGERCTRL			11157
#define	IDC_AI_MODCHANGER				11158
#define	IDC_AI_MODCHANGERCTRL			11159
#define	IDC_PRF_ARGOS_TREECTRL			11160
#define	IDC_PRF_ARGOS_TREECTRL_INFO		11161
#define	IDC_AI_NULLNICK					11162
#define	IDC_AI_NULLNICKCTRL				11163
#define	IDC_PRF_MSG_RESET				11164
#define	IDC_PRF_COM_RESET				11165

#define	IDS_ARGOS						11200
#define	IDS_ARGOS_NONE					11201
#define	IDS_ARGOS_AGGRESSIVE			11202
#define	IDS_ARGOS_ASKAGGRESSIVE			11203
#define	IDS_ARGOS_SUSPECTHELLO			11204
#define	IDS_ARGOS_SUSPECTHELLOSRC		11205
#define	IDS_ARGOS_SUSPECTPROT			11206
#define	IDS_ARGOS_SUSPECTPROTSRC		11207
#define	IDS_ARGOS_BADSENDER				11208
#define	IDS_ARGOS_COMMENT				11209
#define	IDS_ARGOS_COMPENSATION			11210
#define	IDS_ARGOS_CORRUPTEDSENDER		11211
#define	IDS_ARGOS_CREDITHACK			11212
#define	IDS_ARGOS_CREDITHACKSRC			11213
#define	IDS_ARGOS_DETECTION				11214
#define	IDS_ARGOS_DLP_FILE_MISSING		11215
#define	IDS_ARGOS_DLP_LOAD_FAILED		11216
#define	IDS_ARGOS_DLP_LOADED			11217
#define	IDS_ARGOS_DLP_SIGN_FILE_ERROR_AUTH 11218
#define	IDS_ARGOS_DLP_SIGN_FILE_ERROR_PROC 11219
#define	IDS_ARGOS_DLP_SIGN_FILE_ERROR_SIGN_AUTH 11220
#define	IDS_ARGOS_DLP_UNLOADED			11221
#define	IDS_ARGOS_ERROR_FORMAT			11222
#define	IDS_ARGOS_ERROR_FORMATX			11223
#define	IDS_ARGOS_ERROR_TYPE			11224
#define	IDS_ARGOS_FAILED				11225
#define	IDS_ARGOS_FAILEDSRC				11226
#define	IDS_ARGOS_FAKE_CLIENT			11227
#define	IDS_ARGOS_FAKE_CLIENTSRC		11228
#define	IDS_ARGOS_FILE_ERROR			11229
#define	IDS_ARGOS_FILE_FAKER			11230
#define	IDS_ARGOS_FILE_LOADED			11231
#define	IDS_ARGOS_FILE_MISSING			11232
#define	IDS_ARGOS_FILE_SCANNER			11233
#define	IDS_ARGOS_FILEFAKER				11234
#define	IDS_ARGOS_FILESCANNER			11235
#define	IDS_ARGOS_GHOSTMOD				11236
#define	IDS_ARGOS_GHOSTMODSRC			11237
#define	IDS_ARGOS_HASH_CHANGED			11238
#define	IDS_ARGOS_HASH_THIEF			11239
#define	IDS_ARGOS_HASHCHANGE			11240
#define	IDS_ARGOS_HASHTHIEF				11241
#define	IDS_ARGOS_IP_BAN				11242
#define	IDS_ARGOS_IT_EX					11243
#define	IDS_ARGOS_IT_HASH				11244
#define	IDS_ARGOS_IT_MOD				11245
#define	IDS_ARGOS_IT_NICK				11246
#define	IDS_ARGOS_IT_NULL				11247
#define	IDS_ARGOS_IT_OPCODE				11248
#define	IDS_ARGOS_IT_SOFTWARE			11249
#define	IDS_ARGOS_LASTDETECTION			11250
#define	IDS_ARGOS_LASTSEEN				11251
#define	IDS_ARGOS_LEECHER_FOUND			11252
#define	IDS_ARGOS_LEECHER_HASH			11253
#define	IDS_ARGOS_LEECHER_MOD			11254
#define	IDS_ARGOS_LEECHER_NICK			11255
#define	IDS_ARGOS_LEECHER_OPCODE		11256
#define	IDS_ARGOS_LEECHERTYPE			11257
#define	IDS_ARGOS_LEVEL					11258
#define	IDS_ARGOS_LEVEL_HIGH			11259
#define	IDS_ARGOS_LEVEL_LOW				11260
#define	IDS_ARGOS_LEVEL_NORMAL			11261
#define	IDS_ARGOS_LT_BREAKER			11262
#define	IDS_ARGOS_LT_HARD				11263
#define	IDS_ARGOS_LT_MOD				11264
#define	IDS_ARGOS_LT_NORMAL				11265
#define	IDS_ARGOS_LT_NULL				11266
#define	IDS_ARGOS_LT_SOFT				11267
#define	IDS_ARGOS_MOD_THIEF				11268
#define	IDS_ARGOS_MODCHANGER			11269
#define	IDS_ARGOS_MODCHANGERSRC			11270
#define	IDS_ARGOS_MODTHIEF				11271
#define	IDS_ARGOS_NICK_THIEF			11272
#define	IDS_ARGOS_NICKCHANGER			11273
#define	IDS_ARGOS_NICKCHANGERSRC		11274
#define	IDS_ARGOS_NICKTHIEF				11275
#define	IDS_ARGOS_NO_BAN				11276
#define	IDS_ARGOS_PUNISHMENT			11277
#define	IDS_ARGOS_RANK_FLOODER			11278
#define	IDS_ARGOS_RANKFLOODER			11279
#define	IDS_ARGOS_SCORE					11280
#define	IDS_ARGOS_SIGN_FILE_ERROR_AUTH	11281
#define	IDS_ARGOS_SIGN_FILE_ERROR_SIGN	11282
#define	IDS_ARGOS_SIGN_FILE_ERROR_SIGN_AUTH 11283
#define	IDS_ARGOS_SPAM_SRC				11284
#define	IDS_ARGOS_SPAMER				11285
#define	IDS_ARGOS_STRING_SHORT			11286
#define	IDS_ARGOS_SUMMARY				11287
#define	IDS_ARGOS_UL_BAN				11288
#define	IDS_ARGOS_UL_LOCK				11289
#define	IDS_ARGOS_UNKNOWN_SV			11290
#define	IDS_ARGOS_UNKNOWN_UN			11291
#define	IDS_ARGOS_XSEXPLOIT				11292
#define	IDS_ARGOS_XSEXPLOITSRC			11293
#define	IDS_ARGOS_ASK_FAST				11294
#define	IDS_ARGOS_BAD_HASH_SIZE			11295
#define	IDS_ARGOS_BAD_ORDER				11296
#define	IDS_ARGOS_BAD_PACKET			11297
#define	IDS_ARGOS_BAD_PORT				11298
#define	IDS_ARGOS_BAD_TAG				11299
#define	IDS_ARGOS_DIRECT				11300
#define	IDS_ARGOS_DLP_LOG				11301
#define	IDS_ARGOS_DONT_ANSWER			11302
#define	IDS_ARGOS_DWL_LEECHERLISTFILE	11303
#define	IDS_ARGOS_DWL_LEECHERLISTFILE_FAILED 11304
#define	IDS_ARGOS_EMCRYPT				11305
#define	IDS_ARGOS_ERR_LEECHERLISTFILE_CONTENTERR 11306
#define	IDS_ARGOS_ERR_LEECHERLISTFILE_ZIPEXTR 11307
#define	IDS_ARGOS_EXTRA_BYTES			11308
#define	IDS_ARGOS_FAST_TCP				11309
#define	IDS_ARGOS_FAST_UDP				11310
#define	IDS_ARGOS_FATAL					11311
#define	IDS_ARGOS_FRIEND				11312
#define	IDS_ARGOS_GENERIC				11313
#define	IDS_ARGOS_INTERNAL				11314
#define	IDS_ARGOS_HASH_CHANGER_PUNISHMENT 11315
#define	IDS_ARGOS_NA					11316
#define	IDS_ARGOS_PROTOCOL				11317
#define	IDS_ARGOS_SOFTWARE				11318
#define	IDS_ARGOS_SUI					11319
#define	IDS_ARGOS_TRACK_LIST			11320
#define	IDS_ARGOS_TRUST					11321
#define	IDS_ARGOS_BAD_HELLO_DETECTION	11322
#define	IDS_ARGOS_BAD_MOD_PUNISHMENT	11323
#define	IDS_ARGOS_BAD_MOD_PUNISHMENT_INFO 11324
#define	IDS_ARGOS_BREAKER_PUNISHMENT	11325
#define	IDS_ARGOS_BREAKER_PUNISHMENT_INFO 11326
#define	IDS_ARGOS_CLOSE_BACKDOOR		11327
#define	IDS_ARGOS_CLOSE_BACKDOOR_INFO	11328
#define	IDS_ARGOS_CREDIT				11329
#define	IDS_ARGOS_CREDIT_HACK_DETECTION	11330
#define	IDS_ARGOS_CREDIT_HACK_DETECTION_INFO 11331
#define	IDS_ARGOS_CREDIT_HACK_PUNISHMENT 11332
#define	IDS_ARGOS_CREDIT_HACK_PUNISHMENT_INFO 11333
#define	IDS_ARGOS_DLP_DETECTION			11334
#define	IDS_ARGOS_DLP_DETECTION_INFO	11335
#define	IDS_ARGOS_ENABLE				11336
#define	IDS_ARGOS_ENABLE_INFO			11337
#define	IDS_ARGOS_GENERIC_BAN_TIME		11338
#define	IDS_ARGOS_GENERIC_BAN_TIME_INFO	11339
#define	IDS_ARGOS_GHOST_MOD_DETECTION	11340
#define	IDS_ARGOS_GHOST_MOD_DETECTION_INFO 11341
#define	IDS_ARGOS_GHOST_MOD_TIME		11342
#define	IDS_ARGOS_GHOST_MOD_TIME_INFO	11343
#define	IDS_ARGOS_HARD_PUNISHMENT		11344
#define	IDS_ARGOS_HARD_PUNISHMENT_INFO	11345
#define	IDS_ARGOS_HASH_CHANGER_DETECTION 11346
#define	IDS_ARGOS_HASH_CHANGER_DETECTION_INFO 11347
#define	IDS_ARGOS_AGRESSION_DETECTION	11348
#define	IDS_ARGOS_AGRESSION_DETECTION_INFO 11349
#define	IDS_ARGOS_AGRESSION_INTERVALS	11350
#define	IDS_ARGOS_AGRESSION_INTERVALS_INFO 11351
#define	IDS_ARGOS_AGRESSION_THRESHOLD	11352
#define	IDS_ARGOS_AGRESSION_THRESHOLD_INFO 11353
#define	IDS_ARGOS_AGRESSION_TIME		11354
#define	IDS_ARGOS_AGRESSION_TIME_INFO	11355
#define	IDS_ARGOS_AGRESSON_PUNISHMENT	11356
#define	IDS_ARGOS_AGRESSON_PUNISHMENT_INFO 11357
#define	IDS_ARGOS_BAD_SENDER_DETECTION	11358
#define	IDS_ARGOS_BAD_SENDER_DETECTION_INFO 11359
#define	IDS_ARGOS_BAD_SENDER_PUNISHMENT	11360
#define	IDS_ARGOS_BAD_SENDER_PUNISHMENT_INFO 11361
#define	IDS_ARGOS_BAD_SENDER_TIME		11362
#define	IDS_ARGOS_BAD_SENDER_TIME_INFO	11363
#define	IDS_ARGOS_FAKE_CLIENT_DETECTION	11364
#define	IDS_ARGOS_FAKE_CLIENT_DETECTION_INFO 11365
#define	IDS_ARGOS_FAILED_DETECTION		11366
#define	IDS_ARGOS_FAILED_DETECTION_INFO	11367
#define	IDS_ARGOS_FAILED_PUNISHMENT		11368
#define	IDS_ARGOS_FAILED_PUNISHMENT_INFO 11369
#define	IDS_ARGOS_FAILED_THRESHOLD		11370
#define	IDS_ARGOS_FAILED_THRESHOLD_INFO	11371
#define	IDS_ARGOS_FAILED_TIME			11372
#define	IDS_ARGOS_FAILED_TIME_INFO		11373
#define	IDS_ARGOS_FAILED_TRIES			11374
#define	IDS_ARGOS_FAILED_TRIES_INFO		11375
#define	IDS_ARGOS_FAKE_CLIENT_PUNISHMENT 11376
#define	IDS_ARGOS_FAKE_CLIENT_PUNISHMENT_INFO 11377
#define	IDS_ARGOS_FILE_FAKER_DETECTION	11378
#define	IDS_ARGOS_FILE_FAKER_DETECTION_INFO 11379
#define	IDS_ARGOS_FILE_FAKER_PUNISHMENT	11380
#define	IDS_ARGOS_FILE_FAKER_PUNISHMENT_INFO 11381
#define	IDS_ARGOS_FILE_FAKER_TIME		11382
#define	IDS_ARGOS_FILE_FAKER_TIME_INFO	11383
#define	IDS_ARGOS_FILE_SCANNER_DETECTION 11384
#define	IDS_ARGOS_FILE_SCANNER_DETECTION_INFO 11385
#define	IDS_ARGOS_FILE_SCANNER_PUNISHMENT 11386
#define	IDS_ARGOS_FILE_SCANNER_PUNISHMENT_INFO 11387
#define	IDS_ARGOS_FILE_SCANNER_TIME		11388
#define	IDS_ARGOS_FILE_SCANNER_TIME_INFO 11389
#define	IDS_ARGOS_GHOST_MOD_PUNISHMENT	11390
#define	IDS_ARGOS_GHOST_MOD_PUNISHMENT_INFO 11391
#define	IDS_ARGOS_HASH_CHANGER_PUNISHMENT_INFO 11392
#define	IDS_ARGOS_HASH_CHANGER_TIME		11393
#define	IDS_ARGOS_HASH_CHANGER_TIME_INFO 11394
#define	IDS_ARGOS_BAD_HELLO_DETECTION_INFO 11395
#define	IDS_ARGOS_EMCRYPT_DETECTION		11396
#define	IDS_ARGOS_EMCRYPT_DETECTION_INFO 11397
#define	IDS_ARGOS_HASH_THIEF_DETECTION	11398
#define	IDS_ARGOS_HASH_THIEF_DETECTION_INFO 11399
#define	IDS_ARGOS_HASH_THIEF_PUNISHMENT	11400
#define	IDS_ARGOS_HASH_THIEF_PUNISHMENT_INFO 11401
#define	IDS_ARGOS_BAD_HELLO_PUNISHMENT	11402
#define	IDS_ARGOS_BAD_HELLO_TIME		11403
#define	IDS_ARGOS_BAD_HELLO_TIME_INFO	11404
#define	IDS_ARGOS_BAD_PROT_DETECTION	11405
#define	IDS_ARGOS_BAD_PROT_DETECTION_INFO 11406
#define	IDS_ARGOS_BAD_PROT_PUNISHMENT	11407
#define	IDS_ARGOS_BAD_PROT_PUNISHMENT_INFO 11408
#define	IDS_ARGOS_BAD_PROT_TIME			11409
#define	IDS_ARGOS_BAD_PROT_TIME_INFO	11410
#define	IDS_ARGOS_LEECHER_DETECTION		11411
#define	IDS_ARGOS_LEECHER_DETECTION_INFO 11412
#define	IDS_ARGOS_LEECHER_HASH_DETECTION 11413
#define	IDS_ARGOS_LEECHER_HASH_DETECTION_INFO 11414
#define	IDS_ARGOS_LEECHER_MOD_DETECTION	11415
#define	IDS_ARGOS_LEECHER_MOD_DETECTION_INFO 11416
#define	IDS_ARGOS_LEECHER_NICK_DETECTION 11417
#define	IDS_ARGOS_LEECHER_NICK_DETECTION_INFO 11418
#define	IDS_ARGOS_LEVEL_INFO			11419
#define	IDS_ARGOS_LOG					11420
#define	IDS_ARGOS_LOG_INFO				11421
#define	IDS_ARGOS_BAD_HELLO_PUNISHMENT_INFO 11422
#define	IDS_ARGOS_MOD_CHANGER_INTERVALS	11423
#define	IDS_ARGOS_MOD_CHANGER_INTERVALS_INFO 11424
#define	IDS_ARGOS_MOD_CHANGER_THRESHOLD	11425
#define	IDS_ARGOS_MOD_CHANGER_THRESHOLD_INFO 11426
#define	IDS_ARGOS_MOD_CHANGER_DETECTION	11427
#define	IDS_ARGOS_MOD_CHANGER_DETECTION_INFO 11428
#define	IDS_ARGOS_MOD_CHANGER_PUNISHMENT 11429
#define	IDS_ARGOS_MOD_CHANGER_PUNISHMENT_INFO 11430
#define	IDS_ARGOS_MOD_CHANGER_TIME		11431
#define	IDS_ARGOS_MOD_CHANGER_TIME_INFO	11432
#define	IDS_ARGOS_MOD_THIEF_DETECTION	11433
#define	IDS_ARGOS_MOD_THIEF_DETECTION_INFO 11434
#define	IDS_ARGOS_MOD_THIEF_PUNISHMENT	11435
#define	IDS_ARGOS_MOD_THIEF_PUNISHMENT_INFO 11436
#define	IDS_ARGOS_NICK_CHANGER_INTERVALS 11437
#define	IDS_ARGOS_NICK_CHANGER_INTERVALS_INFO 11438
#define	IDS_ARGOS_NICK_CHANGER_THRESHOLD 11439
#define	IDS_ARGOS_NICK_CHANGER_THRESHOLD_INFO 11440
#define	IDS_ARGOS_NICK_CHANGER_DETECTION 11441
#define	IDS_ARGOS_NICK_CHANGER_DETECTION_INFO 11442
#define	IDS_ARGOS_NICK_CHANGER_PUNISHMENT 11443
#define	IDS_ARGOS_NICK_CHANGER_PUNISHMENT_INFO 11444
#define	IDS_ARGOS_NICK_CHANGER_TIME		11445
#define	IDS_ARGOS_NICK_CHANGER_TIME_INFO 11446
#define	IDS_ARGOS_NICK_THIEF_DETECTION	11447
#define	IDS_ARGOS_NICK_THIEF_DETECTION_INFO 11448
#define	IDS_ARGOS_NICK_THIEF_PUNISHMENT	11449
#define	IDS_ARGOS_NICK_THIEF_PUNISHMENT_INFO 11450
#define	IDS_ARGOS_NORMAL_PUNISHMENT		11451
#define	IDS_ARGOS_NORMAL_PUNISHMENT_INFO 11452
#define	IDS_ARGOS_OPCODE_DETECTION		11453
#define	IDS_ARGOS_OPCODE_DETECTION_INFO	11454
#define	IDS_ARGOS_OPCODE_TIME			11455
#define	IDS_ARGOS_OPCODE_TIME_INFO		11456
#define	IDS_ARGOS_PROCESS_TIME			11457
#define	IDS_ARGOS_PROCESS_TIME_INFO		11458
#define	IDS_ARGOS_RANK_FLOODER_DETECTION 11459
#define	IDS_ARGOS_RANK_FLOODER_DETECTION_INFO 11460
#define	IDS_ARGOS_RANK_FLOODER_PUNISHMENT 11461
#define	IDS_ARGOS_RANK_FLOODER_PUNISHMENT_INFO 11462
#define	IDS_ARGOS_RANK_FLOODER_TIME		11463
#define	IDS_ARGOS_RANK_FLOODER_TIME_INFO 11464
#define	IDS_ARGOS_RELOAD				11465
#define	IDS_ARGOS_RELOAD_INFO			11466
#define	IDS_ARGOS_SOFT_PUNISHMENT		11467
#define	IDS_ARGOS_SOFT_PUNISHMENT_INFO	11468
#define	IDS_ARGOS_SPAM_DETECTION		11469
#define	IDS_ARGOS_SPAM_DETECTION_INFO	11470
#define	IDS_ARGOS_SPAM_PUNISHMENT		11471
#define	IDS_ARGOS_SPAM_PUNISHMENT_INFO	11472
#define	IDS_ARGOS_SPAM_TIME				11473
#define	IDS_ARGOS_SPAM_TIME_INFO		11474
#define	IDS_ARGOS_TRACK_TIME			11475
#define	IDS_ARGOS_TRACK_TIME_INFO		11476
#define	IDS_ARGOS_TRUST_TIME			11477
#define	IDS_ARGOS_TRUST_TIME_INFO		11478
#define	IDS_ARGOS_TRUST_UNARGOS_AGRESSION 11479
#define	IDS_ARGOS_TRUST_UNARGOS_AGRESSION_INFO 11480
#define	IDS_ARGOS_TRUST_UNARGOS_GHOST_MOD 11481
#define	IDS_ARGOS_TRUST_UNARGOS_GHOST_MOD_INFO 11482
#define	IDS_ARGOS_TRUST_UNARGOS_HASH_CHANGER 11483
#define	IDS_ARGOS_TRUST_UNARGOS_HASH_CHANGER_INFO 11484
#define	IDS_ARGOS_TRUST_UNARGOS_HASH_THIEF 11485
#define	IDS_ARGOS_TRUST_UNARGOS_HASH_THIEF_INFO 11486
#define	IDS_ARGOS_XS_EXPLOIT_DETECTION	11487
#define	IDS_ARGOS_XS_EXPLOIT_DETECTION_INFO 11488
#define	IDS_ARGOS_XS_EXPLOIT_INTERVALS	11489
#define	IDS_ARGOS_XS_EXPLOIT_INTERVALS_INFO 11490
#define	IDS_ARGOS_XS_EXPLOIT_PUNISHMENT	11491
#define	IDS_ARGOS_XS_EXPLOIT_PUNISHMENT_INFO 11492
#define	IDS_ARGOS_XS_EXPLOIT_THRESHOLD	11493
#define	IDS_ARGOS_XS_EXPLOIT_THRESHOLD_INFO 11494
#define	IDS_ARGOS_XS_EXPLOIT_TIME		11495
#define	IDS_ARGOS_XS_EXPLOIT_TIME_INFO	11496
#define	IDS_ARGOS_CREDIT_COMPENSATION	11497
#define	IDS_ARGOS_CREDIT_COMPENSATION_INFO 11498
#define	IDS_ARGOS_DLP_RELOAD			11499
#define	IDS_ARGOS_DLP_RELOAD_INFO		11500
#define	IDS_ARGOS_DONT_BAN_FRIENDS		11501
#define	IDS_ARGOS_DONT_BAN_FRIENDS_INFO	11502
#define	IDS_ARGOS_PLAIN_ANTI_NICK_THIEF	11503
#define	IDS_ARGOS_PLAIN_ANTI_NICK_THIEF_INFO 11504
#define	IDS_ARGOS_DLP_SIGN_FILE_ERROR	11505
#define	IDS_ARGOS_ERROR_ILLEGAL_DETECTOR 11506
#define	IDS_ARGOS_ERROR_RESTRICTED_TYPE	11507
#define	IDS_ARGOS_SIGN_FILE_ERROR		11508
#define	IDS_ARGOS_NULLNICK				11509
#define	IDS_ARGOS_NULL_NICK_DETECTION	11510
#define	IDS_ARGOS_NULL_NICK_DETECTION_INFO 11511
#define	IDS_ARGOS_NULL_NICK_TIME		11512
#define	IDS_ARGOS_NULL_NICK_TIME_INFO	11513
#define	IDS_ARGOS_NULL_NICK_PUNISHMENT	11514
#define	IDS_ARGOS_NULL_NICK_PUNISHMENT_INFO 11515
#define	IDS_ARGOS_NULLNICKSRC			11516
#define	IDS_ARGOS_MESSAGESPAM			11517
#define	IDS_ARGOS_COMMENTSPAM			11518
#define	IDS_ARGOS_LEECHERLOG_DISABLED	11519

// Import-/ Export-Parts
#define	IDS_IMPORTING					12000
#define	IDS_IMPORT_PARTS				12001
#define	IDS_EXPORT_PARTS				12002
#define IDS_EXPORTPARTS_ERR_CANTOPENFILE 12003
#define	IDS_EXPORTPARTS_ERR_CANTREAD	12004
#define	IDS_EXPORTPARTS_ERR_COMPLETING	12005
#define	IDS_EXPORTPARTS_ERR_FILE		12006
#define IDS_EXPORTPARTS_ERR_FILETOOSMALL 12007
#define	IDS_EXPORTPARTS_ERR_INCOMPLETE	12008
#define IDS_EXPORTPARTS_ERR_NULL		12009
#define	IDS_EXPORTPARTS_EXPORTFINISH	12010
#define IDS_EXPORTPARTS_PARTIMPORTEDGOOD 12011
#define	IDS_IMPORTPARTS_ABORT			12012
#define	IDS_IMPORTPARTS_ABORTED			12013
#define	IDS_IMPORTPARTS_BLOCKS			12014
#define	IDS_IMPORTPARTS_ERR_ALREADYCOMPLETE 12015
#define	IDS_IMPORTPARTS_ERR_CANTOPENFILE 12016
#define	IDS_IMPORTPARTS_ERR_FILE		12017
#define	IDS_IMPORTPARTS_ERR_FILETOOSMALL 12018
#define	IDS_IMPORTPARTS_ERR_HASHSETINCOMPLETE 12019
#define	IDS_IMPORTPARTS_ERR_NULL		12020
#define	IDS_IMPORTPARTS_FOUND			12021
#define	IDS_IMPORTPARTS_IMPORTFINISH	12022
#define	IDS_IMPORTPARTS_IMPORTSTART		12023
#define	IDS_IMPORTPARTS_INCOMPLETE		12024
#define	IDS_IMPORTPARTS_NOT_FOUND		12025
#define	IDS_IMPORTPARTS_PARTIMPORTEDBAD	12026
#define	IDS_IMPORTPARTS_PARTIMPORTEDGOOD 12027
#define	IDS_IMPORTPARTS_PARTSKIPPEDALREADYCOMPLETE 12028
#define	IDS_IMPORTPARTS_PARTSKIPPEDDONTMATCH 12029

// Filefeedback
#define	IDS_FEEDBACK_FROM				13000
#define	IDS_FEEDBACK_CREATE				13001
#define	IDS_FEEDBACK_FILENAME			13002
#define	IDS_FEEDBACK_SIZE				13003
#define	IDS_FEEDBACK_UPLOADED_SESSION	13004
#define IDS_FEEDBACK_UPLOADED_FULL		13005
#define	IDS_FEEDBACK_DOWNLOADING		13006
#define	IDS_FEEDBACK_TOTAL				13007
#define	IDS_FEEDBACK_AVAILABLE			13008
#define	IDS_FEEDBACK_ONQUEUE			13009
#define	IDS_FEEDBACK_COMPLETE			13010
#define	IDS_FEEDBACK_NONEEDPART			13011
#define	IDS_FEEDBACK_FULL_SRC			13012
#define	IDS_FEEDBACK_COPY				13013

// Manual Client Management
#define	IDS_SWAPED_TO_SOURCE			14000
#define	IDS_SWAPED_FROM_SOURCE          14001
#define	IDS_DROP_CLIENT					14002
#define	IDS_MP_UNLOCK_CLIENT			14003
#define	IDS_MP_UNLOCKFROM_CLIENT		14004
#define	IDS_SRC_MANAGEMENT				14005
#define	IDS_SWAP_FROM_CLIENT			14006
#define	IDS_SWAP_TO_CLIENT				14007
#define	IDS_MP_LOCK_CLIENT				14008
#define	IDS_A4AF_MENU					14009
#define	IDS_SWAP_FROM_A4AF				14010
#define	IDS_SWAP_TO_A4AF				14011

// RollUp Control (eMule+ Transfer Window)
#define IDS_RUP_DOWNLOADS               15000
#define IDS_RUP_UPLOADS                 15001
#define IDS_RUP_EXT                     15002
#define IDS_RUP_DOWNINFO                15003
#define IDS_RUP_UPINFO                  15004
#define	IDS_RUP_UPINFO_ARGOS			15005
#define IDS_RUP_EXTINFO                 15006

// Massrename & Simple Cleanup
#define	IDS_MASSRENAME					16000
#define	IDC_BUTTONCHANGE				16001
#define	IDC_CHARDEST					16002
#define	IDC_CHARSOURCE					16003
#define	IDC_CHECKCASESENSITIVE			16004
#define	IDC_CHECKCHARACTERREPLACE		16005
#define	IDC_CHECKCONVERTAPOSTROPHES		16006
#define	IDC_CHECKCONVERTHEX				16007
#define	IDC_CHECKDOTTOSPACE				16008
#define	IDC_CHECKSEARCHANDREPLACE		16009
#define	IDC_CHECKUNDERLINETOSPACE		16010
#define	IDC_DELETECHARACTER				16011
#define	IDC_EDITREPLACEBY				16012
#define	IDC_EDITSEARCH					16013
#define	IDC_FILENAMEMASKEDITTEMPLATE	16014
#define	IDC_INSERTTEXTCOLUMN			16015
#define	IDC_LIT_MASSRENLEFT				16016
#define	IDC_LIT_MASSRENRIGHT			16017
#define	IDC_LIT_NEWFILENAMESEDITRIGHT	16018
#define	IDC_MR_STATIC1					16019
#define	IDC_MR_STATIC2					16020
#define	IDC_MR_STATIC3					16021
#define	IDC_NEWCHARACTER				16022
#define	IDC_NEWFILENAMESEDIT			16023
#define	IDC_OLDFILENAMESEDIT			16024
#define	IDC_REPLACECHARSLIST			16025
#define	IDC_RESETBUTTON					16026
#define	IDC_SC_STATIC1					16027
#define	IDC_SC_STATIC2					16028
#define	IDC_SC_STATIC3					16029
#define	IDC_SC_STATIC4					16030
#define	IDC_SIMPLECLEANUP				16031

#define	IDS_CHECKCASESENSITIVE			16032
#define	IDS_CHECKCHARACTERREPLACE		16033
#define	IDS_CHECKCONVERTAPOSTROPHES		16034
#define	IDS_CHECKCONVERTHEX				16035
#define	IDS_CHECKDOTTOSPACE				16036
#define	IDS_CHECKSEARCHANDREPLACE		16037
#define	IDS_CHECKUNDERLINETOSPACE		16038
#define	IDS_FAILED_TO_RENAME			16039
#define	IDS_IDENTICALFILENAMES			16040
#define	IDS_INSERTTEXTCOLUMN			16041
#define	IDS_MASSRENAME_TITLE			16042
#define	IDS_MASSRENAME1					16043
#define	IDS_MASSRENAME2					16044
#define	IDS_MASSRENAME3					16045
#define	IDS_NOTENOUGHFILENAMES			16046
#define	IDS_REPLACEBYCHAR				16047
#define	IDS_REPLACECHAR					16048
#define	IDS_REPLACECHARBY				16049
#define	IDS_RESETFILENAMES				16050
#define	IDS_SC_ADD						16051
#define	IDS_SC_DELETE					16052
#define	IDS_SC_EDIT						16053
#define	IDS_SC_HEADLINE					16054
#define	IDS_SC_REPLACEBY				16055
#define	IDS_SC_SEARCHFOR				16056
#define	IDS_SEARCHFORCHAR				16057
#define	IDS_SIMPLECLEANUP				16058
#define	IDS_SUCCESED_TO_RENAME			16059

// Powershare
#define IDS_POWERSHARE_ACTIVATED        17000
#define IDS_POWERSHARE_DISABLED         17001
#define IDS_POWERSHARE_ON_LABEL         17002
#define IDS_POWERSHARE_OFF_LABEL        17003
#define IDS_POWERSHARE_PREFIX           17004
#define IDS_POWERSHARE                  17005
#define IDS_POWERSHARE_DENIED_LABEL     17006
#define IDS_POWERSHARE_ADVISED_LABEL    17007
#define IDS_POWERSHARE_AUTHORIZED_LABEL 17008
#define IDS_POWERSHARE_ACTIVATED_LABEL  17009
#define IDS_POWERSHARE_DISABLED_LABEL   17010
#define IDS_POWERSHARE_AUTO_LABEL       17011
#define IDS_POWERSHARE_LIMITED          17012
#define IDS_POWERSHARE_LIMIT            17013
