//this file is part of X-Ray Mule
//Copyright (C)2006 Jan van Achterin ( http://sourceforge.net/projects/x-ray-mule )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once

#include "opcodes.h"

////////////////////////////////////////////////
// Limits & Defaults
////////////////////////////////////////////////

////////////////////////////////////////////////
// Calculation defines
////////////////////////////////////////////////

// X-Ray :: MOD :: Start
#define	MS2SEC(ms)		((ms)/1000)
#define	MS2MIN(ms)		MS2SEC((ms)/60)
#define	MS2HR(ms)		MS2MIN((ms)/60)
#define	KB2BYTE(kb)		((kb)*1024)
#define	BYTE2KB(byte)	((byte)/1024)
// X-Ray :: MOD :: End

////////////////////////////////////////////////
// Preferences defines
////////////////////////////////////////////////

// X-Ray :: Argos :: Start
#define TIM_ARGOS_TRUST_TIME_MIN		240
#define TIM_ARGOS_TRUST_TIME_DEF		360
#define TIM_ARGOS_TRUST_TIME_MAX		480

#define TIM_ARGOS_BAN_TIME_MIN			30
#define TIM_ARGOS_BAN_TIME_DEF			60
#define TIM_ARGOS_BAN_TIME_MAX			180

#define TIM_ARGOS_TRACK_TIME_MIN		60
#define TIM_ARGOS_TRACK_TIME_DEF		120
#define TIM_ARGOS_TRACK_TIME_MAX		720

#define TIM_ARGOS_GENERIC_BAN_TIME_MIN	60
#define TIM_ARGOS_GENERIC_BAN_TIME_DEF	120
#define TIM_ARGOS_GENERIC_BAN_TIME_MAX	240

#define TIM_ARGOS_BAN_BAD_TIME_MIN		60
#define TIM_ARGOS_BAN_TIME_CORRUPT_DEF	180
#define TIM_ARGOS_BAN_TIME_SCANNER_DEF	120
#define	TIM_ARGOS_BAN_TIME_FAILED_DEF	240
#define TIM_ARGOS_BAN_BAD_TIME_MAX		720

#define TIM_ARGOS_AGRESSION_INTERVALS_MIN	1
#define TIM_ARGOS_AGRESSION_INTERVALS_DEF	10
#define TIM_ARGOS_AGRESSION_INTERVALS_MAX	15

#define VAL_ARGOS_AGRESSION_THRESHOLD_MIN	2
#define VAL_ARGOS_AGRESSION_THRESHOLD_DEF	3
#define VAL_ARGOS_AGRESSION_THRESHOLD_MAX	5

#define VAL_ARGOS_FAILED_TRIES_MIN		2
#define VAL_ARGOS_FAILED_TRIES_DEF		3
#define VAL_ARGOS_FAILED_TRIES_MAX		5

#define VAL_ARGOS_FAILED_THRESHOLD_MIN	1
#define VAL_ARGOS_FAILED_THRESHOLD_DEF	12
#define VAL_ARGOS_FAILED_THRESHOLD_MAX	20

#define TIM_ARGOS_XS_EXPLOIT_INTERVALS_MIN	10
#define TIM_ARGOS_XS_EXPLOIT_INTERVALS_DEF	30
#define TIM_ARGOS_XS_EXPLOIT_INTERVALS_MAX	30

#define VAL_ARGOS_XS_EXPLOIT_THRESHOLD_MIN	2
#define VAL_ARGOS_XS_EXPLOIT_THRESHOLD_DEF	3
#define VAL_ARGOS_XS_EXPLOIT_THRESHOLD_MAX	5

#define TIM_ARGOS_NICK_CHANGE_INTERVALS_MIN	60
#define TIM_ARGOS_NICK_CHANGE_INTERVALS_DEF	180
#define TIM_ARGOS_NICK_CHANGE_INTERVALS_MAX	180

#define VAL_ARGOS_NICK_CHANGE_THRESHOLD_MIN	2
#define VAL_ARGOS_NICK_CHANGE_THRESHOLD_DEF	3
#define VAL_ARGOS_NICK_CHANGE_THRESHOLD_MAX	5

#define TIM_ARGOS_MOD_CHANGE_INTERVALS_MIN	30
#define TIM_ARGOS_MOD_CHANGE_INTERVALS_DEF	60
#define TIM_ARGOS_MOD_CHANGE_INTERVALS_MAX	90

#define VAL_ARGOS_MOD_CHANGE_THRESHOLD_MIN	2
#define VAL_ARGOS_MOD_CHANGE_THRESHOLD_DEF	4
#define VAL_ARGOS_MOD_CHANGE_THRESHOLD_MAX	5
// X-Ray :: Argos :: End

// X-Ray :: ReleaseBonus :: Start
#define VAL_RELBONUS_MIN	0
#define VAL_RELBONUS_DEF	0
#define VAL_RELBONUS_MAX	32
// X-Ray :: ReleaseBonus :: End

// X-Ray :: DropSystem :: Start
#define TIM_DROPSYS_BLOCK_MIN		0
#define TIM_DROPSYS_BLOCK_MAX		HR2MS(24)

#define TIM_DROPSYS_BLOCK_NNS_DEF	MIN2MS(30)
#define TIM_DROPSYS_BLOCK_FQS_DEF	HR2MS(6)
#define TIM_DROPSYS_BLOCK_HQS_DEF	HR2MS(3)
#define TIM_DROPSYS_BLOCK_TMC_DEF	HR2MS(1)
#define TIM_DROPSYS_BLOCK_UNK_DEF	HR2MS(2)
#define TIM_DROPSYS_BLOCK_L2L_DEF	HR2MS(12)
// X-Ray :: DropSystem :: End

// X-Ray :: Global Hardlimit :: Start
#define	VAL_GSL_MIN			1000
#define	VAL_GSL_DEF			3500
#define VAL_GSL_MAX			8000
// X-Ray :: Global Hardlimit :: End

// X-Ray :: PaybackFirst :: Start
#define	VAL_PBF_SUI_MIN		5
#define	VAL_PBF_SUI_DEF		10
#define	VAL_PBF_SUI_MAX		255

#define	VAL_PBF_NONSUI_MIN	5
#define	VAL_PBF_NONSUI_DEF	50
#define	VAL_PBF_NONSUI_MAX	1024
// X-Ray :: PaybackFirst :: End

// X-Ray :: SLS :: Start
#define	VAL_SLS_ACTIVATION_MIN	0
#define	VAL_SLS_ACTIVATION_DEF	75
#define	VAL_SLS_ACTIVATION_MAX	100

#define	VAL_SLS_SAVE_MIN	0
#define	VAL_SLS_SAVE_DEF	30
#define	VAL_SLS_SAVE_MAX	50
// X-Ray :: SLS :: End

// X-Ray :: Powershare :: Start
#define	VAL_PS_MODE_MIN		0
#define	VAL_PS_MODE_DEF		0
#define	VAL_PS_MODE_MAX		3

#define	VAL_PS_LIMIT_MIN	0
#define	VAL_PS_LIMIT_DEF	10
#define	VAL_PS_LIMIT_MAX	200
// X-Ray :: Powershare :: End

////////////////////////////////////////////////
// Misc. defines
////////////////////////////////////////////////

// X-Ray :: L2HAC :: Start
#define L2HAC_DEFAULT_EMULE			FILEREASKTIME
#define L2HAC_MIN_TIME				MIN_REQUESTTIME
#define CONNECTION_TIMEOUT_L		(CONNECTION_TIMEOUT * 2)
#define L2HAC_CALLBACK_PRECEDE		(CONNECTION_TIMEOUT_L >> 1)
#define L2HAC_PREPARE_PRECEDE		(CONNECTION_TIMEOUT_L)
// X-Ray :: L2HAC :: End

// X-Ray :: RollUpCtrl :: Start
#define USRMSG_CLEARCOMPLETED		WM_USER + 5
#define	USRMSG_SWITCHDOWNLOADLIST	WM_USER + 11
#define USRMSG_SWITCHUPLOADLIST		WM_USER + 12
#define USRMSG_SWITCHEXTLIST		WM_USER + 13
// X-Ray :: RollUpCtrl :: End

#define	VAL_MAXSLOTSPEED			15 // X-Ray :: SlotControl

// TODOXRAY: Add Defaults and Limits of other features
