#pragma once
#include "Preferences.h"

class CPPg_X_Drop : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPg_X_Drop)

public:
	CPPg_X_Drop();
	virtual ~CPPg_X_Drop();

	// Dialog Data
	enum { IDD = IDD_PPG_X_DROP };

	void Localize(void);

	afx_msg void OnSettingsChange()		{ SetModified(); }

// X-Ray :: PPgPrefTabs
private:
	enum eTab	{NONE, Download1, Download2};
	CTabCtrl	m_tabCtr;
	eTab		m_currentTab;
	CImageList	m_imageList;
	void		SetTab(eTab tab);

public:
	afx_msg void OnTcnSelchangeTabDownload2(NMHDR *pNMHDR, LRESULT *pResult);
	void	InitTab(bool firstinit, int Page = 0);
// X-Ray :: End

protected:

	void LoadSettings();

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual BOOL OnApply();

	DECLARE_MESSAGE_MAP()

private:
	// X-Ray :: DropSystem
	void FillBlockTimeBoxWithItems();
	void FillBlockTimeBox(CComboBox* pBlockTimeCombo);
	uint32 GetBlockTime(CComboBox* pComboBox);
	void SetBlockTime(CComboBox* pComboBox, uint32 uTime);
	uint8 GetEditBoxPercentageEntries(CEdit* pEditBox, uint8 iPrefBuffer);
	uint8 GetEditBoxTimerEntries(CEdit* pEditBox, uint8 iPrefBuffer);
	uint16 GetEditBoxQREntries(CEdit* pEditBox, uint16 iPrefBuffer);
	void SetEditBoxEntries(CEdit* pEditBox, uint16 strBuffer);
	void NNSDropSettingsChk();
	void FQSDropSettingsChk();
	void HQSDropSettingsChk();
	// X-Ray :: End
};
