//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PPg_X_Drop.h"
#include "opcodes.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "Log.h"
#include "Addons/defaults.h"
#include "emuleDlg.h" // X-Ray :: PPgPrefTabs
#include "PreferencesDlg.h" // X-Ray :: PPgPrefTabs

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPg_X_Drop, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPg_X_Drop, CPropertyPage)
	ON_NOTIFY(TCN_SELCHANGE, IDC_PRF_DOWNLOAD_TAB_NO2, OnTcnSelchangeTabDownload2) // X-Ray :: PPgPrefTabs
	// X-Ray :: DropSystem
	ON_CBN_SELCHANGE(IDC_PRF_DROP_NNS_BANTIME_VALUE, OnSettingsChange)
	ON_CBN_SELCHANGE(IDC_PRF_DROP_FQS_BANTIME_VALUE, OnSettingsChange)
	ON_CBN_SELCHANGE(IDC_PRF_DROP_HQS_BANTIME_VALUE, OnSettingsChange)
	ON_CBN_SELCHANGE(IDC_PRF_DROP_BANTIME_L2L_VALUE, OnSettingsChange)
	ON_CBN_SELCHANGE(IDC_PRF_DROP_BANTIME_UNK_VALUE, OnSettingsChange)
	ON_CBN_SELCHANGE(IDC_PRF_DROP_BANTIME_TOO_VALUE, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_DROP_NNS_CHK, NNSDropSettingsChk)
	ON_BN_CLICKED(IDC_PRF_DROP_FQS_CHK, FQSDropSettingsChk)
	ON_BN_CLICKED(IDC_PRF_DROP_HQS_CHK, HQSDropSettingsChk)
	ON_EN_CHANGE(IDC_PRF_DROP_NNS_PERCENT_VALUE, OnSettingsChange)
	ON_EN_CHANGE(IDC_PRF_DROP_FQS_PERCENT_VALUE, OnSettingsChange)
	ON_EN_CHANGE(IDC_PRF_DROP_HQS_PERCENT_VALUE, OnSettingsChange)
	ON_EN_CHANGE(IDC_PRF_DROP_NNS_TIMER_VALUE, OnSettingsChange)
	ON_EN_CHANGE(IDC_PRF_DROP_FQS_TIMER_VALUE, OnSettingsChange)
	ON_EN_CHANGE(IDC_PRF_DROP_HQS_TIMER_VALUE, OnSettingsChange)
	ON_EN_CHANGE(IDC_PRF_DROP_HQS_QR_VALUE, OnSettingsChange)
	// X-Ray :: End
END_MESSAGE_MAP()

CPPg_X_Drop::CPPg_X_Drop()
	: CPropertyPage(CPPg_X_Drop::IDD)
{
	// X-Ray :: PPgPrefTabs
	m_imageList.DeleteImageList();
	m_imageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 14+1, 0);
	m_imageList.Add(CTempIconLoader(_T("PRF_X_DOWNLOAD")));
	m_imageList.Add(CTempIconLoader(_T("PRF_X_DROP")));
	// X-Ray :: End
}

CPPg_X_Drop::~CPPg_X_Drop()
{
}

void CPPg_X_Drop::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PRF_DOWNLOAD_TAB_NO2, m_tabCtr); // X-Ray :: PPgPrefTabs
}

BOOL CPPg_X_Drop::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	InitTab(true, theApp.emuledlg->preferenceswnd->GetStartPageDownload()); // X-Ray :: PPgPrefTabs

	// X-Ray :: DropSystem
	((CEdit*)GetDlgItem(IDC_PRF_DROP_NNS_PERCENT_VALUE))->SetLimitText(3);
	((CEdit*)GetDlgItem(IDC_PRF_DROP_NNS_TIMER_VALUE))->SetLimitText(3);
	((CEdit*)GetDlgItem(IDC_PRF_DROP_FQS_PERCENT_VALUE))->SetLimitText(3);
	((CEdit*)GetDlgItem(IDC_PRF_DROP_FQS_TIMER_VALUE))->SetLimitText(3);
	((CEdit*)GetDlgItem(IDC_PRF_DROP_HQS_PERCENT_VALUE))->SetLimitText(3);
	((CEdit*)GetDlgItem(IDC_PRF_DROP_HQS_TIMER_VALUE))->SetLimitText(3);
	((CEdit*)GetDlgItem(IDC_PRF_DROP_HQS_QR_VALUE))->SetLimitText(5);
	// X-Ray :: End

	FillBlockTimeBoxWithItems(); // X-Ray :: DropSystem
	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPg_X_Drop::OnApply()
{
	// X-Ray :: DropSystem
	thePrefs.SetBlockTimeNNS(GetBlockTime(((CComboBox*)GetDlgItem(IDC_PRF_DROP_NNS_BANTIME_VALUE))));
	thePrefs.SetBlockTimeFQS(GetBlockTime(((CComboBox*)GetDlgItem(IDC_PRF_DROP_FQS_BANTIME_VALUE))));
	thePrefs.SetBlockTimeHQS(GetBlockTime(((CComboBox*)GetDlgItem(IDC_PRF_DROP_HQS_BANTIME_VALUE))));
	thePrefs.SetBlockTimeL2L(GetBlockTime(((CComboBox*)GetDlgItem(IDC_PRF_DROP_BANTIME_L2L_VALUE))));
	thePrefs.SetBlockTimeUNK(GetBlockTime(((CComboBox*)GetDlgItem(IDC_PRF_DROP_BANTIME_UNK_VALUE))));
	thePrefs.SetBlockTimeTMC(GetBlockTime(((CComboBox*)GetDlgItem(IDC_PRF_DROP_BANTIME_TOO_VALUE))));
	thePrefs.SetAutoDropNNS(IsDlgButtonChecked(IDC_PRF_DROP_NNS_CHK) ? true : false);
	thePrefs.SetAutoDropFQS(IsDlgButtonChecked(IDC_PRF_DROP_FQS_CHK) ? true : false);
	thePrefs.SetAutoDropHQS(IsDlgButtonChecked(IDC_PRF_DROP_HQS_CHK) ? true : false);
	thePrefs.SetAutoDropNNSPercentage(GetEditBoxPercentageEntries(((CEdit*)GetDlgItem(IDC_PRF_DROP_NNS_PERCENT_VALUE)), thePrefs.GetAutoDropNNSPercentage()));
	thePrefs.SetAutoDropNNSTimer(GetEditBoxTimerEntries(((CEdit*)GetDlgItem(IDC_PRF_DROP_NNS_TIMER_VALUE)), thePrefs.GetAutoDropNNSTimer()));
	thePrefs.SetAutoDropFQSPercentage(GetEditBoxPercentageEntries(((CEdit*)GetDlgItem(IDC_PRF_DROP_FQS_PERCENT_VALUE)), thePrefs.GetAutoDropFQSPercentage()));
	thePrefs.SetAutoDropFQSTimer(GetEditBoxTimerEntries(((CEdit*)GetDlgItem(IDC_PRF_DROP_FQS_TIMER_VALUE)), thePrefs.GetAutoDropFQSTimer()));
	thePrefs.SetAutoDropHQSPercentage(GetEditBoxPercentageEntries(((CEdit*)GetDlgItem(IDC_PRF_DROP_HQS_PERCENT_VALUE)), thePrefs.GetAutoDropHQSPercentage()));
	thePrefs.SetAutoDropHQSTimer(GetEditBoxTimerEntries(((CEdit*)GetDlgItem(IDC_PRF_DROP_HQS_TIMER_VALUE)), thePrefs.GetAutoDropHQSTimer()));
	thePrefs.SetAutoDropHQSQRValue(GetEditBoxQREntries(((CEdit*)GetDlgItem(IDC_PRF_DROP_HQS_QR_VALUE)), thePrefs.GetAutoDropHQSQRValue()));
	// X-Ray :: End

	LoadSettings();
	return TRUE;
}

void CPPg_X_Drop::LoadSettings()
{
	// X-Ray :: DropSystem
	GetDlgItem(IDC_PRF_DROP_BANTIME_L2L_LBL)->EnableWindow(theApp.IsFirewalled());
	GetDlgItem(IDC_PRF_DROP_BANTIME_L2L_VALUE)->EnableWindow(theApp.IsFirewalled());
	GetDlgItem(IDC_PRF_DROP_NNS_PERCENT_LBL)->EnableWindow(thePrefs.GetAutoDropNNS());
	GetDlgItem(IDC_PRF_DROP_NNS_PERCENT_VALUE)->EnableWindow(thePrefs.GetAutoDropNNS());
	GetDlgItem(IDC_PRF_DROP_NNS_TIMER_LBL)->EnableWindow(thePrefs.GetAutoDropNNS());
	GetDlgItem(IDC_PRF_DROP_NNS_TIMER_VALUE)->EnableWindow(thePrefs.GetAutoDropNNS());
	GetDlgItem(IDC_PRF_DROP_FQS_PERCENT_LBL)->EnableWindow(thePrefs.GetAutoDropFQS());
	GetDlgItem(IDC_PRF_DROP_FQS_PERCENT_VALUE)->EnableWindow(thePrefs.GetAutoDropFQS());
	GetDlgItem(IDC_PRF_DROP_FQS_TIMER_LBL)->EnableWindow(thePrefs.GetAutoDropFQS());
	GetDlgItem(IDC_PRF_DROP_FQS_TIMER_VALUE)->EnableWindow(thePrefs.GetAutoDropFQS());
	GetDlgItem(IDC_PRF_DROP_HQS_PERCENT_LBL)->EnableWindow(thePrefs.GetAutoDropHQS());
	GetDlgItem(IDC_PRF_DROP_HQS_PERCENT_VALUE)->EnableWindow(thePrefs.GetAutoDropHQS());
	GetDlgItem(IDC_PRF_DROP_HQS_TIMER_LBL)->EnableWindow(thePrefs.GetAutoDropHQS());
	GetDlgItem(IDC_PRF_DROP_HQS_TIMER_VALUE)->EnableWindow(thePrefs.GetAutoDropHQS());
	GetDlgItem(IDC_PRF_DROP_HQS_QR_LBL)->EnableWindow(thePrefs.GetAutoDropHQS());
	GetDlgItem(IDC_PRF_DROP_HQS_QR_VALUE)->EnableWindow(thePrefs.GetAutoDropHQS());

	SetBlockTime(((CComboBox*)GetDlgItem(IDC_PRF_DROP_NNS_BANTIME_VALUE)), thePrefs.GetBlockTimeNNS());
	SetBlockTime(((CComboBox*)GetDlgItem(IDC_PRF_DROP_FQS_BANTIME_VALUE)), thePrefs.GetBlockTimeFQS());
	SetBlockTime(((CComboBox*)GetDlgItem(IDC_PRF_DROP_HQS_BANTIME_VALUE)), thePrefs.GetBlockTimeHQS());
	SetBlockTime(((CComboBox*)GetDlgItem(IDC_PRF_DROP_BANTIME_L2L_VALUE)), thePrefs.GetBlockTimeL2L());
	SetBlockTime(((CComboBox*)GetDlgItem(IDC_PRF_DROP_BANTIME_UNK_VALUE)), thePrefs.GetBlockTimeUNK());
	SetBlockTime(((CComboBox*)GetDlgItem(IDC_PRF_DROP_BANTIME_TOO_VALUE)), thePrefs.GetBlockTimeTMC());
	CheckDlgButton(IDC_PRF_DROP_NNS_CHK, thePrefs.GetAutoDropNNS());
	CheckDlgButton(IDC_PRF_DROP_FQS_CHK, thePrefs.GetAutoDropFQS());
	CheckDlgButton(IDC_PRF_DROP_HQS_CHK, thePrefs.GetAutoDropHQS());
	SetEditBoxEntries(((CEdit*)GetDlgItem(IDC_PRF_DROP_NNS_PERCENT_VALUE)), thePrefs.GetAutoDropNNSPercentage());
	SetEditBoxEntries(((CEdit*)GetDlgItem(IDC_PRF_DROP_NNS_TIMER_VALUE)), thePrefs.GetAutoDropNNSTimer());
	SetEditBoxEntries(((CEdit*)GetDlgItem(IDC_PRF_DROP_FQS_PERCENT_VALUE)), thePrefs.GetAutoDropFQSPercentage());
	SetEditBoxEntries(((CEdit*)GetDlgItem(IDC_PRF_DROP_FQS_TIMER_VALUE)), thePrefs.GetAutoDropFQSTimer());
	SetEditBoxEntries(((CEdit*)GetDlgItem(IDC_PRF_DROP_HQS_PERCENT_VALUE)), thePrefs.GetAutoDropHQSPercentage());
	SetEditBoxEntries(((CEdit*)GetDlgItem(IDC_PRF_DROP_HQS_TIMER_VALUE)), thePrefs.GetAutoDropHQSTimer());
	SetEditBoxEntries(((CEdit*)GetDlgItem(IDC_PRF_DROP_HQS_QR_VALUE)), thePrefs.GetAutoDropHQSQRValue());
	// X-Ray :: End
}

void CPPg_X_Drop::Localize()
{
	if (m_hWnd)
	{
		// X-Ray :: DropSystem
		GetDlgItem(IDC_PRF_DROP_NNS_GRP)->SetWindowText(GetResString(IDS_PRF_DROP_NNS_GRP));
		GetDlgItem(IDC_PRF_DROP_NNS_CHK)->SetWindowText(GetResString(IDS_PRF_DROP_NNS_CHK));
		GetDlgItem(IDC_PRF_DROP_NNS_PERCENT_LBL)->SetWindowText(GetResString(IDS_PRF_DROP_NNS_PERCENT_LBL));
		GetDlgItem(IDC_PRF_DROP_NNS_TIMER_LBL)->SetWindowText(GetResString(IDS_PRF_DROP_NNS_TIMER_LBL));
		GetDlgItem(IDC_PRF_DROP_NNS_BANTIME_LBL)->SetWindowText(GetResString(IDS_PRF_DROP_NNS_BANTIME_LBL));
		GetDlgItem(IDC_PRF_DROP_FQS_GRP)->SetWindowText(GetResString(IDS_PRF_DROP_FQS_GRP));
		GetDlgItem(IDC_PRF_DROP_FQS_CHK)->SetWindowText(GetResString(IDS_PRF_DROP_FQS_CHK));
		GetDlgItem(IDC_PRF_DROP_FQS_PERCENT_LBL)->SetWindowText(GetResString(IDS_PRF_DROP_FQS_PERCENT_LBL));
		GetDlgItem(IDC_PRF_DROP_FQS_TIMER_LBL)->SetWindowText(GetResString(IDS_PRF_DROP_FQS_TIMER_LBL));
		GetDlgItem(IDC_PRF_DROP_FQS_BANTIME_LBL)->SetWindowText(GetResString(IDS_PRF_DROP_FQS_BANTIME_LBL));
		GetDlgItem(IDC_PRF_DROP_HQS_GRP)->SetWindowText(GetResString(IDS_PRF_DROP_HQS_GRP));
		GetDlgItem(IDC_PRF_DROP_HQS_CHK)->SetWindowText(GetResString(IDS_PRF_DROP_HQS_CHK));
		GetDlgItem(IDC_PRF_DROP_HQS_PERCENT_LBL)->SetWindowText(GetResString(IDS_PRF_DROP_HQS_PERCENT_LBL));
		GetDlgItem(IDC_PRF_DROP_HQS_TIMER_LBL)->SetWindowText(GetResString(IDS_PRF_DROP_HQS_TIMER_LBL));
		GetDlgItem(IDC_PRF_DROP_HQS_BANTIME_LBL)->SetWindowText(GetResString(IDS_PRF_DROP_HQS_BANTIME_LBL));
		GetDlgItem(IDC_PRF_DROP_HQS_QR_LBL)->SetWindowText(GetResString(IDS_PRF_DROP_HQS_QR_LBL));
		GetDlgItem(IDC_PRF_DROP_BANTIME_GRP)->SetWindowText(GetResString(IDS_PRF_DROP_BANTIME_GRP));
		GetDlgItem(IDC_PRF_DROP_BANTIME_L2L_LBL)->SetWindowText(GetResString(IDS_PRF_DROP_BANTIME_L2L_LBL));
		GetDlgItem(IDC_PRF_DROP_BANTIME_UNK_LBL)->SetWindowText(GetResString(IDS_PRF_DROP_BANTIME_UNK_LBL));
		GetDlgItem(IDC_PRF_DROP_BANTIME_TOO_LBL)->SetWindowText(GetResString(IDS_PRF_DROP_BANTIME_TOO_LBL));
		// X-Ray :: End
	}
}

// X-Ray :: PPgPrefTabs
void CPPg_X_Drop::InitTab(bool firstinit, int Page)
{
	if (firstinit) {
		m_tabCtr.DeleteAllItems();
		m_tabCtr.SetImageList(&m_imageList);
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Download1, GetResString(IDS_PRF_X_GENERAL), 0, (LPARAM)Download1); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Download2, GetResString(IDS_PRF_X_DROP), 1, (LPARAM)Download2); 
	}

	m_tabCtr.SetCurSel(Page);
}
void CPPg_X_Drop::OnTcnSelchangeTabDownload2(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int cur_sel = m_tabCtr.GetCurSel();
	theApp.emuledlg->preferenceswnd->SwitchTab(cur_sel);
	*pResult = 0;
}
// X-Ray :: End

// X-Ray :: DropSystem
void CPPg_X_Drop::FillBlockTimeBox(CComboBox* pBlockTimeCombo)
{  
	pBlockTimeCombo->ResetContent();
	pBlockTimeCombo->AddString(GetResString(IDS_PRF_DROP_BANTIME_NOBAN));
	pBlockTimeCombo->AddString(GetResString(IDS_PRF_DROP_BANTIME_30MIN));
	pBlockTimeCombo->AddString(GetResString(IDS_PRF_DROP_BANTIME_1H));
	pBlockTimeCombo->AddString(GetResString(IDS_PRF_DROP_BANTIME_2H));
	pBlockTimeCombo->AddString(GetResString(IDS_PRF_DROP_BANTIME_3H));
	pBlockTimeCombo->AddString(GetResString(IDS_PRF_DROP_BANTIME_6H));
	pBlockTimeCombo->AddString(GetResString(IDS_PRF_DROP_BANTIME_12H));
	pBlockTimeCombo->AddString(GetResString(IDS_PRF_DROP_BANTIME_24H));
}

uint32 CPPg_X_Drop::GetBlockTime(CComboBox* pComboBox)
{
	uint32 iTime = 0;
	switch(pComboBox->GetCurSel())
	{  
		case 0:		iTime = SEC(0);		break;
		case 1:		iTime = MIN2MS(30);	break;
		case 2:		iTime = HR2MS(1);	break;
		case 3:		iTime = HR2MS(2);	break;
		case 4:		iTime = HR2MS(3);	break;
		case 5:		iTime = HR2MS(6);	break;
		case 6:		iTime = HR2MS(12);	break;
		case 7:		iTime = HR2MS(24);	break;
		default:	iTime = MIN2MS(30);	break;
	}

	return iTime;
}

void CPPg_X_Drop::SetBlockTime(CComboBox* pComboBox, uint32 uTime)
{
	switch(MS2MIN(uTime))
	{
		case 0:		pComboBox->SetCurSel(0);	break;
		case 30:	pComboBox->SetCurSel(1);	break;
		case 60:	pComboBox->SetCurSel(2);	break;
		case 120:	pComboBox->SetCurSel(3);	break;
		case 180:	pComboBox->SetCurSel(4);	break;
		case 360:	pComboBox->SetCurSel(5);	break;
		case 720:	pComboBox->SetCurSel(6);	break;
		case 1440:	pComboBox->SetCurSel(7);	break;
		default:	pComboBox->SetCurSel(1);	break;
	}
}

uint8 CPPg_X_Drop::GetEditBoxPercentageEntries(CEdit* pEditBox, uint8 iPrefBuffer)
{
	CString strBuffer;
	uint8 iBuffer = iPrefBuffer;
	pEditBox->GetWindowText(strBuffer);
	if (_tstoi(strBuffer) >= 0 && _tstoi(strBuffer) <= 100)
		iBuffer = (uint8)_tstoi(strBuffer);

	return iBuffer;
}

uint8 CPPg_X_Drop::GetEditBoxTimerEntries(CEdit* pEditBox, uint8 iPrefBuffer)
{
	CString strBuffer;
	uint8 iBuffer = iPrefBuffer;
	pEditBox->GetWindowText(strBuffer);
	if (_tstoi(strBuffer) >= 10 && _tstoi(strBuffer) <= 120)
		iBuffer = (uint8)_tstoi(strBuffer);

	return iBuffer;
}

uint16 CPPg_X_Drop::GetEditBoxQREntries(CEdit* pEditBox, uint16 iPrefBuffer)
{
	CString strBuffer;
	uint16 iBuffer = iPrefBuffer;
	pEditBox->GetWindowText(strBuffer);
	if (_tstoi(strBuffer) >= 1000 && _tstoi(strBuffer) <= 10000)
		iBuffer = (uint16)_tstoi(strBuffer);

	return iBuffer;
}

void CPPg_X_Drop::SetEditBoxEntries(CEdit* pEditBox, uint16 iBuffer)
{
	CString strBuffer;
	strBuffer.Format(_T("%d"), iBuffer);
	pEditBox->SetWindowText(strBuffer);
}

void CPPg_X_Drop::FillBlockTimeBoxWithItems()
{
	FillBlockTimeBox(((CComboBox*)GetDlgItem(IDC_PRF_DROP_NNS_BANTIME_VALUE)));
	FillBlockTimeBox(((CComboBox*)GetDlgItem(IDC_PRF_DROP_FQS_BANTIME_VALUE)));
	FillBlockTimeBox(((CComboBox*)GetDlgItem(IDC_PRF_DROP_HQS_BANTIME_VALUE)));
	FillBlockTimeBox(((CComboBox*)GetDlgItem(IDC_PRF_DROP_BANTIME_L2L_VALUE)));
	FillBlockTimeBox(((CComboBox*)GetDlgItem(IDC_PRF_DROP_BANTIME_UNK_VALUE)));
	FillBlockTimeBox(((CComboBox*)GetDlgItem(IDC_PRF_DROP_BANTIME_TOO_VALUE)));
}

void CPPg_X_Drop::NNSDropSettingsChk()
{
	GetDlgItem(IDC_PRF_DROP_NNS_PERCENT_LBL)->EnableWindow(IsDlgButtonChecked(IDC_PRF_DROP_NNS_CHK));
	GetDlgItem(IDC_PRF_DROP_NNS_PERCENT_VALUE)->EnableWindow(IsDlgButtonChecked(IDC_PRF_DROP_NNS_CHK));
	GetDlgItem(IDC_PRF_DROP_NNS_TIMER_LBL)->EnableWindow(IsDlgButtonChecked(IDC_PRF_DROP_NNS_CHK));
	GetDlgItem(IDC_PRF_DROP_NNS_TIMER_VALUE)->EnableWindow(IsDlgButtonChecked(IDC_PRF_DROP_NNS_CHK));
	SetModified();
}

void CPPg_X_Drop::FQSDropSettingsChk()
{
	GetDlgItem(IDC_PRF_DROP_FQS_PERCENT_LBL)->EnableWindow(IsDlgButtonChecked(IDC_PRF_DROP_FQS_CHK));
	GetDlgItem(IDC_PRF_DROP_FQS_PERCENT_VALUE)->EnableWindow(IsDlgButtonChecked(IDC_PRF_DROP_FQS_CHK));
	GetDlgItem(IDC_PRF_DROP_FQS_TIMER_LBL)->EnableWindow(IsDlgButtonChecked(IDC_PRF_DROP_FQS_CHK));
	GetDlgItem(IDC_PRF_DROP_FQS_TIMER_VALUE)->EnableWindow(IsDlgButtonChecked(IDC_PRF_DROP_FQS_CHK));
	SetModified();
}

void CPPg_X_Drop::HQSDropSettingsChk()
{
	GetDlgItem(IDC_PRF_DROP_HQS_PERCENT_LBL)->EnableWindow(IsDlgButtonChecked(IDC_PRF_DROP_HQS_CHK));
	GetDlgItem(IDC_PRF_DROP_HQS_PERCENT_VALUE)->EnableWindow(IsDlgButtonChecked(IDC_PRF_DROP_HQS_CHK));
	GetDlgItem(IDC_PRF_DROP_HQS_TIMER_LBL)->EnableWindow(IsDlgButtonChecked(IDC_PRF_DROP_HQS_CHK));
	GetDlgItem(IDC_PRF_DROP_HQS_TIMER_VALUE)->EnableWindow(IsDlgButtonChecked(IDC_PRF_DROP_HQS_CHK));
	GetDlgItem(IDC_PRF_DROP_HQS_QR_LBL)->EnableWindow(IsDlgButtonChecked(IDC_PRF_DROP_HQS_CHK));
	GetDlgItem(IDC_PRF_DROP_HQS_QR_VALUE)->EnableWindow(IsDlgButtonChecked(IDC_PRF_DROP_HQS_CHK));
	SetModified();
}
// X-Ray :: End