//this file is part of eMule
//Copyright (C)2002-2007 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once

class CUpDownClient;
class CFileDataIO;

#define	FF_NAME		0x01
#define FF_FRIENDSLOT	"FU" // X-Ray :: SaveFU

// X-Ray :: OfflineFriendData :: Start
#define FF_SOFT			"SFT"
#define FF_UPLOAD		"FUL"
#define FF_DOWNLOAD		"FDL"
// X-Ray :: OfflineFriendData :: End

class CFriend
{
public:
	CFriend();
	CFriend(CUpDownClient* client);
	CFriend(const uchar* abyUserhash, uint32 dwLastSeen, uint32 dwLastUsedIP, uint16 nLastUsedPort, 
            uint32 dwLastChatted, LPCTSTR pszName, uint32 dwHasHash);
	~CFriend();

	uchar	m_abyUserhash[16];
	uint32	m_dwLastSeen;
	uint32	m_dwLastUsedIP;
	uint16	m_nLastUsedPort;
	uint32	m_dwLastChatted;
	CString m_strName;

	CUpDownClient* GetLinkedClient(bool bValidCheck = false) const;
	void SetLinkedClient(CUpDownClient* linkedClient);

	void	LoadFromFile(CFileDataIO* file);
	void	WriteToFile(CFileDataIO* file);

	void SetFriendSlot(bool newValue);
	bool GetFriendSlot() const;
	
	bool HasUserhash() const;
private:
	bool m_friendSlot;

	CUpDownClient* m_LinkedClient;

// X-Ray :: OfflineFriendData :: Start
public:
	CString	GetFriendName() const;
	CString GetFriendHash() const;
	CString	GetIdentState() const;
	CString	GetFriendSoft() const;
	CString	GetFriendUploaded() const;
	CString	GetFriendDownloaded() const;
private:
	sint64	m_uiUploaded;
	sint64	m_uiDownloaded;
	CString	m_strSoft;
// X-Ray :: OfflineFriendData :: End
};
