//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PPg_X_Download.h"
#include "opcodes.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "Log.h"
#include "Addons/defaults.h"
#include "emuleDlg.h" // X-Ray :: PPgPrefTabs
#include "PreferencesDlg.h" // X-Ray :: PPgPrefTabs

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPg_X_Download, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPg_X_Download, CPropertyPage)
	ON_WM_HSCROLL()
	ON_NOTIFY(TCN_SELCHANGE, IDC_PRF_DOWNLOAD_TAB_NO1, OnTcnSelchangeTabDownload1) // X-Ray :: PPgPrefTabs
	ON_BN_CLICKED(IDC_PRF_DOWN_IF_CHK, OnSettingsChange) // X-Ray :: IntelliFlush
	ON_BN_CLICKED(IDC_PRF_DOWN_MISC_ICS_CHK, OnSettingsChange) // X-Ray :: ICS
	ON_BN_CLICKED(IDC_PRF_DOWN_MISC_ODCF_CHK, OnSettingsChange) // X-Ray :: OnlyDownloadCompleteFiles
	// X-Ray :: Global Hardlimit :: Start
	ON_BN_CLICKED(IDC_PRF_DOWN_GHL_CHK, OnGHLChk)
	ON_BN_CLICKED(IDC_PRF_DOWN_GHL_DEFAULT_CHK, OnSettingsChange)
	// X-Ray :: Global Hardlimit :: End
	// X-Ray :: SLS :: Start
	ON_BN_CLICKED(IDC_PRF_DOWN_SLS_CHK, OnSLSChkClicked)
	ON_EN_CHANGE(IDC_PRF_DOWN_SLS_ACTIV_VALUE, OnSettingsChange)
	ON_EN_CHANGE(IDC_PRF_DOWN_SLS_SAVE_VALUE, OnSettingsChange)
	// X-Ray :: SLS :: End
END_MESSAGE_MAP()

CPPg_X_Download::CPPg_X_Download()
	: CPropertyPage(CPPg_X_Download::IDD)
{
	// X-Ray :: PPgPrefTabs
	m_imageList.DeleteImageList();
	m_imageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 14+1, 0);
	m_imageList.Add(CTempIconLoader(_T("PRF_X_DOWNLOAD")));
	m_imageList.Add(CTempIconLoader(_T("PRF_X_DROP")));
	// X-Ray :: End
}

CPPg_X_Download::~CPPg_X_Download()
{
}

void CPPg_X_Download::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PRF_DOWNLOAD_TAB_NO1, m_tabCtr); // X-Ray :: PPgPrefTabs
}

BOOL CPPg_X_Download::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	InitTab(true, theApp.emuledlg->preferenceswnd->GetStartPageDownload()); // X-Ray :: PPgPrefTabs

	// X-Ray :: Global Hardlimit :: Start
	((CSliderCtrl*)GetDlgItem(IDC_PRF_DOWN_GHL_SLIDER))->SetRange(VAL_GSL_MIN, VAL_GSL_MAX, TRUE);
	((CSliderCtrl*)GetDlgItem(IDC_PRF_DOWN_GHL_SLIDER))->SetTicFreq(1000);
	// X-Ray :: Global Hardlimit :: End

	// X-Ray :: IntelliFlush :: Start
	((CSliderCtrl*)GetDlgItem(IDC_PRF_DOWN_IF_FLUSHTIME_SLIDER))->SetRange(0, 60, TRUE);
	((CSliderCtrl*)GetDlgItem(IDC_PRF_DOWN_IF_FLUSHTIME_SLIDER))->SetTicFreq(10);
	((CSliderCtrl*)GetDlgItem(IDC_FILEBUFFERSIZE))->SetRange(256, 30720, TRUE);
	((CSliderCtrl*)GetDlgItem(IDC_FILEBUFFERSIZE))->SetTicFreq(1024);
	// X-Ray :: IntelliFlush :: End

	// X-Ray :: SLS :: Start
	((CEdit*)GetDlgItem(IDC_PRF_DOWN_SLS_ACTIV_VALUE))->SetLimitText(3);
	((CEdit*)GetDlgItem(IDC_PRF_DOWN_SLS_SAVE_VALUE))->SetLimitText(2);
	// X-Ray :: SLS :: End

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPg_X_Download::OnApply()
{
	// X-Ray :: Global Hardlimit :: Start
	if(IsDlgButtonChecked(IDC_PRF_DOWN_GHL_CHK)){
		thePrefs.SetUseGlobalHL(true);
		thePrefs.SetGlobalHL((UINT)((CSliderCtrl*)GetDlgItem(IDC_PRF_DOWN_GHL_SLIDER))->GetPos());
		if(thePrefs.IsExtControlsEnabled())
			thePrefs.SetGlobalHlDefault(IsDlgButtonChecked(IDC_PRF_DOWN_GHL_DEFAULT_CHK) ? true : false);
		else
			thePrefs.SetGlobalHlDefault(true);
	} else {
		thePrefs.SetUseGlobalHL(false);
		thePrefs.SetGlobalHL(3500); // back to the roots ;)
		thePrefs.SetGlobalHlDefault(false);
	}
	// X-Ray :: Global Hardlimit :: End

	// X-Ray :: IntelliFlush :: Start
	thePrefs.SetUseIntelliFlush(IsDlgButtonChecked(IDC_PRF_DOWN_IF_CHK) ? true : false);
	thePrefs.SetFileBufferFlushTime((UINT)MIN2MS(((CSliderCtrl*)GetDlgItem(IDC_PRF_DOWN_IF_FLUSHTIME_SLIDER))->GetPos()));
	thePrefs.SetFileBufferSize((UINT)KB2BYTE(((CSliderCtrl*)GetDlgItem(IDC_FILEBUFFERSIZE))->GetPos()));
	// X-Ray :: IntelliFlush :: End

	// X-Ray :: SLS :: Start
	if(IsDlgButtonChecked(IDC_PRF_DOWN_SLS_CHK)){
		thePrefs.SetSaveLoadSource(true);
		thePrefs.SetActivationLimitSLS(GetEditBoxSLSEntries(((CEdit*)GetDlgItem(IDC_PRF_DOWN_SLS_ACTIV_VALUE)), thePrefs.GetActivationLimitSLS()));
		thePrefs.SetSourcesToSaveSLS(GetEditBoxSLSEntries(((CEdit*)GetDlgItem(IDC_PRF_DOWN_SLS_SAVE_VALUE)), thePrefs.GetSourcesToSaveSLS()));
	} else
		thePrefs.SetSaveLoadSource(false);
	// X-Ray :: SLS :: End

	thePrefs.SetICS(IsDlgButtonChecked(IDC_PRF_DOWN_MISC_ICS_CHK) ? true : false); // X-Ray :: ICS
	thePrefs.SetOnlyCompleteFiles(IsDlgButtonChecked(IDC_PRF_DOWN_MISC_ODCF_CHK) ? true : false); // X-Ray :: OnlyDownloadCompleteFiles

	LoadSettings();
	return TRUE;
}

void CPPg_X_Download::LoadSettings()
{
	// X-Ray :: Global Hardlimit :: Start
	if(thePrefs.IsUseGlobalHL()){
		if(thePrefs.IsExtControlsEnabled()){
			GetDlgItem(IDC_PRF_DOWN_GHL_DEFAULT_CHK)->EnableWindow(true);
			CheckDlgButton(IDC_PRF_DOWN_GHL_DEFAULT_CHK, thePrefs.GetGlobalHlDefault());
		} else
			GetDlgItem(IDC_PRF_DOWN_GHL_DEFAULT_CHK)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_PRF_DOWN_GHL_DEFAULT_CHK)->EnableWindow(true);
		GetDlgItem(IDC_PRF_DOWN_GHL_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_DOWN_GHL_VALUE_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_DOWN_GHL_SLIDER)->EnableWindow(true);
		CheckDlgButton(IDC_PRF_DOWN_GHL_CHK, true);
	} else {
		if(thePrefs.IsExtControlsEnabled())
			GetDlgItem(IDC_PRF_DOWN_GHL_DEFAULT_CHK)->EnableWindow(false);
		else
			GetDlgItem(IDC_PRF_DOWN_GHL_DEFAULT_CHK)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_PRF_DOWN_GHL_DEFAULT_CHK)->EnableWindow(false);
		GetDlgItem(IDC_PRF_DOWN_GHL_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_DOWN_GHL_VALUE_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_DOWN_GHL_SLIDER)->EnableWindow(false);
		CheckDlgButton(IDC_PRF_DOWN_GHL_CHK, false);
		CheckDlgButton(IDC_PRF_DOWN_GHL_DEFAULT_CHK, false);
	}
	((CSliderCtrl*)GetDlgItem(IDC_PRF_DOWN_GHL_SLIDER))->SetPos(thePrefs.GetGlobalHL());
	ShowGHLSources();
	// X-Ray :: Global Hardlimit :: End

	// X-Ray :: IntelliFlush :: Start
	CheckDlgButton(IDC_PRF_DOWN_IF_CHK, thePrefs.IsUseIntelliFlush());
	((CSliderCtrl*)GetDlgItem(IDC_PRF_DOWN_IF_FLUSHTIME_SLIDER))->SetPos(MS2MIN(thePrefs.GetFileBufferFlushTime()));
	((CSliderCtrl*)GetDlgItem(IDC_FILEBUFFERSIZE))->SetPos(BYTE2KB(thePrefs.GetFileBufferSize()));
	ShowForcedFlushTime();
	ShowFlushbufferLimit();
	// X-Ray :: IntelliFlush :: End

	// X-Ray :: SLS :: Start
	if(thePrefs.UseSaveLoadSources()){
		CheckDlgButton(IDC_PRF_DOWN_SLS_CHK, true);
		SetEditBoxSLSEntries(((CEdit*)GetDlgItem(IDC_PRF_DOWN_SLS_ACTIV_VALUE)), thePrefs.GetActivationLimitSLS());
		SetEditBoxSLSEntries(((CEdit*)GetDlgItem(IDC_PRF_DOWN_SLS_SAVE_VALUE)), thePrefs.GetSourcesToSaveSLS());
	} else {
		CheckDlgButton(IDC_PRF_DOWN_SLS_CHK, false);
		GetDlgItem(IDC_PRF_DOWN_SLS_ACTIV_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_DOWN_SLS_ACTIV_VALUE)->EnableWindow(false);
		GetDlgItem(IDC_PRF_DOWN_SLS_SAVE_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_DOWN_SLS_SAVE_VALUE)->EnableWindow(false);
	}
	// X-Ray :: SLS :: End

	CheckDlgButton(IDC_PRF_DOWN_MISC_ICS_CHK, thePrefs.IsICS()); // X-Ray :: ICS
	CheckDlgButton(IDC_PRF_DOWN_MISC_ODCF_CHK, thePrefs.IsOnlyCompleteFiles()); // X-Ray :: OnlyDownloadCompleteFiles
}

void CPPg_X_Download::Localize()
{
	if (m_hWnd)
	{
		GetDlgItem(IDC_PRF_DOWN_MISC_GRP)->SetWindowText(GetResString(IDS_MISC));
		GetDlgItem(IDC_PRF_DOWN_MISC_ICS_CHK)->SetWindowText(GetResString(IDS_PRF_DOWN_MISC_ICS_CHK)); // X-Ray :: ICS
		GetDlgItem(IDC_PRF_DOWN_MISC_ODCF_CHK)->SetWindowText(GetResString(IDS_PRF_DOWN_MISC_ODCF_CHK)); // X-Ray :: OnlyDownloadCompleteFiles
		// X-Ray :: Global Hardlimit :: Start
		GetDlgItem(IDC_PRF_DOWN_GHL_GRP)->SetWindowText(GetResString(IDS_PRF_DOWN_GHL_GRP));
		GetDlgItem(IDC_PRF_DOWN_GHL_CHK)->SetWindowText(GetResString(IDS_PRF_DOWN_GHL_CHK));
		GetDlgItem(IDC_PRF_DOWN_GHL_DEFAULT_CHK)->SetWindowText(GetResString(IDS_PRF_DOWN_GHL_DEFAULT_CHK));
		GetDlgItem(IDC_PRF_DOWN_GHL_LBL)->SetWindowText(GetResString(IDS_PRF_DOWN_GHL_LBL));
		// X-Ray :: Global Hardlimit :: End
		// X-Ray :: IntelliFlush :: Start
		GetDlgItem(IDC_PRF_DOWN_IF_GRP)->SetWindowText(GetResString(IDS_PRF_DOWN_IF_GRP));
		GetDlgItem(IDC_PRF_DOWN_IF_CHK)->SetWindowText(GetResString(IDS_PRF_DOWN_IF_CHK));
		GetDlgItem(IDC_PRF_DOWN_IF_FLUSHTIME_LBL)->SetWindowText(GetResString(IDS_PRF_DOWN_IF_FLUSHTIME_LBL));
		GetDlgItem(IDC_FILEBUFFERSIZE_STATIC)->SetWindowText(GetResString(IDS_FILEBUFFERSIZE));
		// X-Ray :: IntelliFlush :: End
		// X-Ray :: SLS :: Start
		GetDlgItem(IDC_PRF_DOWN_SLS_GRP)->SetWindowText(GetResString(IDS_PRF_DOWN_SLS_GRP));
		GetDlgItem(IDC_PRF_DOWN_SLS_CHK)->SetWindowText(GetResString(IDS_PRF_DOWN_SLS_CHK));
		GetDlgItem(IDC_PRF_DOWN_SLS_ACTIV_LBL)->SetWindowText(GetResString(IDS_PRF_DOWN_SLS_ACTIV_LBL));
		GetDlgItem(IDC_PRF_DOWN_SLS_SAVE_LBL)->SetWindowText(GetResString(IDS_PRF_DOWN_SLS_SAVE_LBL));
		// X-Ray :: SLS :: End
	}
}

// X-Ray :: PPgPrefTabs
void CPPg_X_Download::InitTab(bool firstinit, int Page)
{
	if (firstinit) {
		m_tabCtr.DeleteAllItems();
		m_tabCtr.SetImageList(&m_imageList);
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Download1, GetResString(IDS_PRF_X_GENERAL), 0, (LPARAM)Download1); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Download2, GetResString(IDS_PRF_X_DROP), 1, (LPARAM)Download2); 
	}

	m_tabCtr.SetCurSel(Page);
}
void CPPg_X_Download::OnTcnSelchangeTabDownload1(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int cur_sel = m_tabCtr.GetCurSel();
	theApp.emuledlg->preferenceswnd->SwitchTab(cur_sel);
	*pResult = 0;
}
// X-Ray :: End

void CPPg_X_Download::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SetModified();
	// X-Ray :: Global Hardlimit :: Start
	if(pScrollBar == (CScrollBar*)GetDlgItem(IDC_PRF_DOWN_GHL_SLIDER))
		ShowGHLSources();
	// X-Ray :: Global Hardlimit :: End
	// X-Ray :: IntelliFlush :: Start
	if(pScrollBar == (CScrollBar*)GetDlgItem(IDC_PRF_DOWN_IF_FLUSHTIME_SLIDER))
		ShowForcedFlushTime();
	if(pScrollBar == (CScrollBar*)GetDlgItem(IDC_FILEBUFFERSIZE))
		ShowFlushbufferLimit();
	// X-Ray :: IntelliFlush :: End
	UpdateData(false); 
	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}

// X-Ray :: Global Hardlimit :: Start
void CPPg_X_Download::OnGHLChk()
{
	if(IsDlgButtonChecked(IDC_PRF_DOWN_GHL_CHK)){
		if(thePrefs.IsExtControlsEnabled()){
			GetDlgItem(IDC_PRF_DOWN_GHL_DEFAULT_CHK)->EnableWindow(true);
			CheckDlgButton(IDC_PRF_DOWN_GHL_DEFAULT_CHK, thePrefs.GetGlobalHlDefault());
		} else
			GetDlgItem(IDC_PRF_DOWN_GHL_DEFAULT_CHK)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_PRF_DOWN_GHL_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_DOWN_GHL_VALUE_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_DOWN_GHL_SLIDER)->EnableWindow(true);
		((CSliderCtrl*)GetDlgItem(IDC_PRF_DOWN_GHL_SLIDER))->SetPos(thePrefs.GetGlobalHL());
	} else {
		if(thePrefs.IsExtControlsEnabled()){
			GetDlgItem(IDC_PRF_DOWN_GHL_DEFAULT_CHK)->EnableWindow(false);
			CheckDlgButton(IDC_PRF_DOWN_GHL_DEFAULT_CHK, false);
		} else
			GetDlgItem(IDC_PRF_DOWN_GHL_DEFAULT_CHK)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_PRF_DOWN_GHL_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_DOWN_GHL_VALUE_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_DOWN_GHL_SLIDER)->EnableWindow(false);
	}
	SetModified();
}

void CPPg_X_Download::ShowGHLSources()
{
	CString strBuffer;
	strBuffer.Format(_T("%i %s"), ((CSliderCtrl*)GetDlgItem(IDC_PRF_DOWN_GHL_SLIDER))->GetPos(), GetResString(IDS_DL_SOURCES));
	GetDlgItem(IDC_PRF_DOWN_GHL_VALUE_LBL)->SetWindowText(strBuffer);
}
// X-Ray :: Global Hardlimit :: End

// X-Ray :: IntelliFlush :: Start
void CPPg_X_Download::ShowForcedFlushTime()
{
	CString strBuffer;
	strBuffer.Format(_T("%i %s"), ((CSliderCtrl*)GetDlgItem(IDC_PRF_DOWN_IF_FLUSHTIME_SLIDER))->GetPos(), GetResString(IDS_LONGMINS));
	GetDlgItem(IDC_PRF_DOWN_IF_FLUSHTIME_VALUE)->SetWindowText(strBuffer);
}

void CPPg_X_Download::ShowFlushbufferLimit()
{
	CString strBuffer;
	if (((CSliderCtrl*)GetDlgItem(IDC_FILEBUFFERSIZE))->GetPos() <= 1024)
		strBuffer.Format(_T("%i %s"), ((CSliderCtrl*)GetDlgItem(IDC_FILEBUFFERSIZE))->GetPos(), GetResString(IDS_KBYTES));
	else
		strBuffer.Format(_T("%.2f %s"), (float)(((CSliderCtrl*)GetDlgItem(IDC_FILEBUFFERSIZE))->GetPos())/1024, GetResString(IDS_MBYTES));
	GetDlgItem(IDC_PRF_DOWN_IF_FLUSHBUFFER_VALUE)->SetWindowText(strBuffer);
}
// X-Ray :: IntelliFlush :: End

// X-Ray :: SLS :: Start
uint8 CPPg_X_Download::GetEditBoxSLSEntries(CEdit* pEditBox, uint8 iPrefBuffer)
{
	CString strBuffer;
	uint8 iBuffer = iPrefBuffer;
	pEditBox->GetWindowText(strBuffer);
	if(pEditBox == ((CEdit*)GetDlgItem(IDC_PRF_DOWN_SLS_ACTIV_VALUE))){
		if (_tstoi(strBuffer) >= 0 && _tstoi(strBuffer) <= 100)
			iBuffer = (uint8)_tstoi(strBuffer);
	} else if(pEditBox == ((CEdit*)GetDlgItem(IDC_PRF_DOWN_SLS_SAVE_VALUE))){
		if (_tstoi(strBuffer) >= 0 && _tstoi(strBuffer) <= 50)
			iBuffer = (uint8)_tstoi(strBuffer);
	}
	return iBuffer;
}

void CPPg_X_Download::SetEditBoxSLSEntries(CEdit* pEditBox, uint8 iBuffer)
{
	CString strBuffer;
	strBuffer.Format(_T("%d"), iBuffer);
	pEditBox->SetWindowText(strBuffer);
}

void CPPg_X_Download::OnSLSChkClicked()
{
	if(IsDlgButtonChecked(IDC_PRF_DOWN_SLS_CHK)){
		CheckDlgButton(IDC_PRF_DOWN_SLS_CHK, true);
		GetDlgItem(IDC_PRF_DOWN_SLS_ACTIV_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_DOWN_SLS_ACTIV_VALUE)->EnableWindow(true);
		GetDlgItem(IDC_PRF_DOWN_SLS_SAVE_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_DOWN_SLS_SAVE_VALUE)->EnableWindow(true);
		SetEditBoxSLSEntries(((CEdit*)GetDlgItem(IDC_PRF_DOWN_SLS_ACTIV_VALUE)), thePrefs.GetActivationLimitSLS());
		SetEditBoxSLSEntries(((CEdit*)GetDlgItem(IDC_PRF_DOWN_SLS_SAVE_VALUE)), thePrefs.GetSourcesToSaveSLS());
	} else {
		CheckDlgButton(IDC_PRF_DOWN_SLS_CHK, false);
		GetDlgItem(IDC_PRF_DOWN_SLS_ACTIV_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_DOWN_SLS_ACTIV_VALUE)->EnableWindow(false);
		GetDlgItem(IDC_PRF_DOWN_SLS_SAVE_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_DOWN_SLS_SAVE_VALUE)->EnableWindow(false);
	}
	SetModified();
}
// X-Ray :: SLS :: End