//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PPg_X_Connection.h"
#include "opcodes.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "Log.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPg_X_Connection, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPg_X_Connection, CPropertyPage)
	ON_BN_CLICKED(IDC_PRF_CON_CONTROL_ACC_CHK, OnSettingsChange) // X-Ray :: ActiveConnectionControl
	ON_BN_CLICKED(IDC_PRF_CON_CONTROL_RASAIPC_CHK, OnSettingsChange) // X-Ray :: ReAskSrcAfterIPChange
	ON_WM_HSCROLL() // X-Ray :: VariableReaskTime
	// X-Ray :: AutoSoftLock :: Start
	ON_BN_CLICKED(IDC_PRF_CON_CONTROL_ASL_CHK, OnASLCheck)
	ON_EN_CHANGE(IDC_PRF_CON_CONTROL_ASL_VALUE, OnSettingsChange)
	ON_EN_CHANGE(IDC_PRF_CON_CONTROL_ASLGLOBAL_VALUE, OnSettingsChange)
	// X-Ray :: AutoSoftLock :: End
	// X-Ray :: ConChecker :: Start
	ON_BN_CLICKED(IDC_PRF_CON_CONCHK_CHK, OnConCheckerChk)
	ON_BN_CLICKED(IDC_PRF_CON_CONCHK_ICMP_CHK, OnSettingsChange)
	ON_EN_CHANGE(IDC_PRF_CON_CONCHK_PING_VALUE, OnSettingsChange)
	ON_EN_CHANGE(IDC_PRF_CON_CONCHK_TTL_VALUE, OnSettingsChange)
	// X-Ray :: ConChecker :: End
END_MESSAGE_MAP()

CPPg_X_Connection::CPPg_X_Connection()
	: CPropertyPage(CPPg_X_Connection::IDD)
{
}

CPPg_X_Connection::~CPPg_X_Connection()
{
}

void CPPg_X_Connection::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

void CPPg_X_Connection::SetAllIcons()
{
}

BOOL CPPg_X_Connection::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	((CSliderCtrl*)GetDlgItem(IDC_PRF_CON_CONTROL_RATIMER_SLIDER))->SetRange(29, 55, true); // X-Ray :: VariableReaskTime

	LoadSettings();
	SetAllIcons();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPg_X_Connection::OnApply()
{
	thePrefs.SetUseACC(IsDlgButtonChecked(IDC_PRF_CON_CONTROL_ACC_CHK) ? true : false); // X-Ray :: ActiveConnectionControl
	thePrefs.SetRASAIPC(IsDlgButtonChecked(IDC_PRF_CON_CONTROL_RASAIPC_CHK) ? true : false); // X-Ray :: ReAskSrcAfterIPChange
	thePrefs.SetReAskTimeDif((uint32)(((CSliderCtrl*)GetDlgItem(IDC_PRF_CON_CONTROL_RATIMER_SLIDER))->GetPos() - 29)*60000); // X-Ray :: VariableReaskTime

	// X-Ray :: AutoSoftLock :: Start
	if (IsDlgButtonChecked(IDC_PRF_CON_CONTROL_ASL_CHK)){
		thePrefs.SetUseASL(true);

		CString strBuffer;
		uint8 iBuffer = thePrefs.GetASLValueFile();
		((CEdit*)GetDlgItem(IDC_PRF_CON_CONTROL_ASL_VALUE))->GetWindowText(strBuffer);
		if (_tstoi(strBuffer) >= 5 && _tstoi(strBuffer) <= 30)
			iBuffer = (uint8)_tstoi(strBuffer);
		thePrefs.SetASLValueFile(iBuffer);

		iBuffer = thePrefs.GetASLValueGlobal();
		((CEdit*)GetDlgItem(IDC_PRF_CON_CONTROL_ASLGLOBAL_VALUE))->GetWindowText(strBuffer);
		if (_tstoi(strBuffer) >= 20 && _tstoi(strBuffer) <= 255)
			iBuffer = (uint8)_tstoi(strBuffer);
		thePrefs.SetASLValueGlobal(iBuffer);
	} else
		thePrefs.SetUseASL(false);
	// X-Ray :: AutoSoftLock :: End

	// X-Ray :: ConChecker :: Start
	if (IsDlgButtonChecked(IDC_PRF_CON_CONCHK_CHK) != (UINT)(thePrefs.GetCheckCon())){
		if (IsDlgButtonChecked(IDC_PRF_CON_CONCHK_CHK))
			conchecker.Start();
		else
			conchecker.Stop();
	}

	if (IsDlgButtonChecked(IDC_PRF_CON_CONCHK_CHK)){
		thePrefs.SetCheckCon(true);
		thePrefs.SetICMP(IsDlgButtonChecked(IDC_PRF_CON_CONCHK_ICMP_CHK) ? true : false);

		CString strBuffer;
		uint8 iBuffer = thePrefs.GetPingTimeout();
		((CEdit*)GetDlgItem(IDC_PRF_CON_CONCHK_PING_VALUE))->GetWindowText(strBuffer);
		if (_tstoi(strBuffer) >= 1 && _tstoi(strBuffer) <= 20)
			iBuffer = (uint8)_tstoi(strBuffer);
		thePrefs.SetPingTimeout(iBuffer);

		iBuffer = thePrefs.GetPingTTL();
		((CEdit*)GetDlgItem(IDC_PRF_CON_CONCHK_TTL_VALUE))->GetWindowText(strBuffer);
		if (_tstoi(strBuffer) >= 8 && _tstoi(strBuffer) <= 64)
			iBuffer = (uint8)_tstoi(strBuffer);
		thePrefs.SetPingTTL(iBuffer);
	} else
		thePrefs.SetCheckCon(false);
	// X-Ray :: ConChecker :: End

	LoadSettings();
	return TRUE;
}

void CPPg_X_Connection::LoadSettings()
{
	CheckDlgButton(IDC_PRF_CON_CONTROL_ACC_CHK, thePrefs.GetUseACC()); // X-Ray :: ActiveConnectionControl
	CheckDlgButton(IDC_PRF_CON_CONTROL_RASAIPC_CHK, thePrefs.GetRASAIPC()); // X-Ray :: ReAskSrcAfterIPChange

	// X-Ray :: VariableReaskTime :: Start
	((CSliderCtrl*)GetDlgItem(IDC_PRF_CON_CONTROL_RATIMER_SLIDER))->SetPos((thePrefs.GetReAskTimeDif() + FILEREASKTIME)/60000);
	ShowVariableReaskTime();
	// X-Ray :: VariableReaskTime :: End

	// X-Ray :: AutoSoftLock :: Start
	CString strBuffer;
	if (thePrefs.GetUseASL()){
		CheckDlgButton(IDC_PRF_CON_CONTROL_ASL_CHK, true);
		GetDlgItem(IDC_PRF_CON_CONTROL_ASL_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_CON_CONTROL_ASL_VALUE)->EnableWindow(true);
		GetDlgItem(IDC_PRF_CON_CONTROL_ASLGLOBAL_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_CON_CONTROL_ASLGLOBAL_VALUE)->EnableWindow(true);

		strBuffer.Format(_T("%d"), thePrefs.GetASLValueFile());
		((CEdit*)GetDlgItem(IDC_PRF_CON_CONTROL_ASL_VALUE))->SetWindowText(strBuffer);
		strBuffer.Format(_T("%d"), thePrefs.GetASLValueGlobal());
		((CEdit*)GetDlgItem(IDC_PRF_CON_CONTROL_ASLGLOBAL_VALUE))->SetWindowText(strBuffer);
	} else {
		CheckDlgButton(IDC_PRF_CON_CONTROL_ASL_CHK, false);
		GetDlgItem(IDC_PRF_CON_CONTROL_ASL_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_CON_CONTROL_ASL_VALUE)->EnableWindow(false);
		GetDlgItem(IDC_PRF_CON_CONTROL_ASLGLOBAL_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_CON_CONTROL_ASLGLOBAL_VALUE)->EnableWindow(false);
	}
	// X-Ray :: AutoSoftLock :: End

	// X-Ray :: ConChecker :: Start
	if (thePrefs.GetCheckCon()){
		GetDlgItem(IDC_PRF_CON_CONCHK_ICMP_CHK)->EnableWindow(true);
		GetDlgItem(IDC_PRF_CON_CONCHK_PING_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_CON_CONCHK_PING_VALUE)->EnableWindow(true);
		GetDlgItem(IDC_PRF_CON_CONCHK_TTL_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_CON_CONCHK_TTL_VALUE)->EnableWindow(true);

		CheckDlgButton(IDC_PRF_CON_CONCHK_CHK, true);
		CheckDlgButton(IDC_PRF_CON_CONCHK_ICMP_CHK, thePrefs.GetICMP());

		strBuffer.Format(_T("%d"), thePrefs.GetPingTimeout());
		((CEdit*)GetDlgItem(IDC_PRF_CON_CONCHK_PING_VALUE))->SetWindowText(strBuffer);

		strBuffer.Format(_T("%d"), thePrefs.GetPingTTL());
		((CEdit*)GetDlgItem(IDC_PRF_CON_CONCHK_TTL_VALUE))->SetWindowText(strBuffer);
	} else {
		GetDlgItem(IDC_PRF_CON_CONCHK_ICMP_CHK)->EnableWindow(false);
		GetDlgItem(IDC_PRF_CON_CONCHK_PING_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_CON_CONCHK_PING_VALUE)->EnableWindow(false);
		GetDlgItem(IDC_PRF_CON_CONCHK_TTL_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_CON_CONCHK_TTL_VALUE)->EnableWindow(false);

		CheckDlgButton(IDC_PRF_CON_CONCHK_CHK, false);
	}
	// X-Ray :: ConChecker :: End
}

void CPPg_X_Connection::Localize()
{
	if (m_hWnd)
	{
		GetDlgItem(IDC_PRF_CON_CONTROL_GRP)->SetWindowText(GetResString(IDS_PRF_CON_CONTROL_GRP));
		// X-Ray :: AutoSoftLock :: Start
		GetDlgItem(IDC_PRF_CON_CONTROL_ASL_CHK)->SetWindowText(GetResString(IDS_PRF_CON_CONTROL_ASL_CHK));
		GetDlgItem(IDC_PRF_CON_CONTROL_ASL_LBL)->SetWindowText(GetResString(IDS_PRF_CON_CONTROL_ASL_LBL));
		GetDlgItem(IDC_PRF_CON_CONTROL_ASLGLOBAL_LBL)->SetWindowText(GetResString(IDS_PRF_CON_CONTROL_ASLGLOBAL_LBL));
		// X-Ray :: AutoSoftLock :: End
		// X-Ray :: ConChecker :: Start
		GetDlgItem(IDC_PRF_CON_CONCHK_GRP)->SetWindowText(GetResString(IDS_PRF_CON_CONCHK_GRP));
		GetDlgItem(IDC_PRF_CON_CONCHK_CHK)->SetWindowText(GetResString(IDS_PRF_CON_CONCHK_CHK));
		GetDlgItem(IDC_PRF_CON_CONCHK_ICMP_CHK)->SetWindowText(GetResString(IDS_PRF_CON_CONCHK_ICMP_CHK));
		GetDlgItem(IDC_PRF_CON_CONCHK_PING_LBL)->SetWindowText(GetResString(IDS_PRF_CON_CONCHK_PING_LBL));
		GetDlgItem(IDC_PRF_CON_CONCHK_TTL_LBL)->SetWindowText(GetResString(IDS_PRF_CON_CONCHK_TTL_LBL));
		// X-Ray :: ConChecker :: End
		GetDlgItem(IDC_PRF_CON_CONTROL_RASAIPC_CHK)->SetWindowText(GetResString(IDS_PRF_CON_CONTROL_RASAIPC_CHK)); // X-Ray :: ReAskSrcAfterIPChange
		GetDlgItem(IDC_PRF_CON_CONTROL_RATIMER_LBL)->SetWindowText(GetResString(IDS_PRF_CON_CONTROL_RATIMER_LBL)); // X-Ray :: VariableReaskTime
		GetDlgItem(IDC_PRF_CON_CONTROL_ACC_CHK)->SetWindowText(GetResString(IDS_PRF_CON_CONTROL_ACC_CHK)); // X-Ray :: ActiveConnectionControl
	}
}

// X-Ray :: AutoSoftLock :: Start
void CPPg_X_Connection::OnASLCheck()
{
	if (IsDlgButtonChecked(IDC_PRF_CON_CONTROL_ASL_CHK)){
		GetDlgItem(IDC_PRF_CON_CONTROL_ASL_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_CON_CONTROL_ASL_VALUE)->EnableWindow(true);
		GetDlgItem(IDC_PRF_CON_CONTROL_ASLGLOBAL_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_CON_CONTROL_ASLGLOBAL_VALUE)->EnableWindow(true);

		CString strBuffer;
		strBuffer.Format(_T("%d"), thePrefs.GetASLValueFile());
		((CEdit*)GetDlgItem(IDC_PRF_CON_CONTROL_ASL_VALUE))->SetWindowText(strBuffer);
		strBuffer.Format(_T("%d"), thePrefs.GetASLValueGlobal());
		((CEdit*)GetDlgItem(IDC_PRF_CON_CONTROL_ASLGLOBAL_VALUE))->SetWindowText(strBuffer);
	} else {
		GetDlgItem(IDC_PRF_CON_CONTROL_ASL_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_CON_CONTROL_ASL_VALUE)->EnableWindow(false);
		GetDlgItem(IDC_PRF_CON_CONTROL_ASLGLOBAL_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_CON_CONTROL_ASLGLOBAL_VALUE)->EnableWindow(false);
	}
}
// X-Ray :: AutoSoftLock :: End

// X-Ray :: ConChecker :: Start
void CPPg_X_Connection::OnConCheckerChk()
{
	if (IsDlgButtonChecked(IDC_PRF_CON_CONCHK_CHK)){
		GetDlgItem(IDC_PRF_CON_CONCHK_ICMP_CHK)->EnableWindow(true);
		GetDlgItem(IDC_PRF_CON_CONCHK_PING_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_CON_CONCHK_PING_VALUE)->EnableWindow(true);
		GetDlgItem(IDC_PRF_CON_CONCHK_TTL_LBL)->EnableWindow(true);
		GetDlgItem(IDC_PRF_CON_CONCHK_TTL_VALUE)->EnableWindow(true);

		CString strBuffer;
		strBuffer.Format(_T("%d"), thePrefs.GetPingTimeout());
		((CEdit*)GetDlgItem(IDC_PRF_CON_CONCHK_PING_VALUE))->SetWindowText(strBuffer);

		strBuffer.Format(_T("%d"), thePrefs.GetPingTTL());
		((CEdit*)GetDlgItem(IDC_PRF_CON_CONCHK_TTL_VALUE))->SetWindowText(strBuffer);
	}
	else {
		GetDlgItem(IDC_PRF_CON_CONCHK_ICMP_CHK)->EnableWindow(false);
		GetDlgItem(IDC_PRF_CON_CONCHK_PING_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_CON_CONCHK_PING_VALUE)->EnableWindow(false);
		GetDlgItem(IDC_PRF_CON_CONCHK_TTL_LBL)->EnableWindow(false);
		GetDlgItem(IDC_PRF_CON_CONCHK_TTL_VALUE)->EnableWindow(false);
	}
	SetModified(true);
}
// X-Ray :: ConChecker :: End

void CPPg_X_Connection::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	SetModified(true);

	// X-Ray :: VariableReaskTime :: Start
	if(pScrollBar == (CScrollBar*)GetDlgItem(IDC_PRF_CON_CONTROL_RATIMER_SLIDER))
		ShowVariableReaskTime();
	// X-Ray :: VariableReaskTime :: End

	UpdateData(false); 
	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}

// X-Ray :: VariableReaskTime :: Start
void CPPg_X_Connection::ShowVariableReaskTime()
{
	CString strBuffer;
	strBuffer.Format(_T("%i %s"), ((CSliderCtrl*)GetDlgItem(IDC_PRF_CON_CONTROL_RATIMER_SLIDER))->GetPos(), GetResString(IDS_LONGMINS));
	GetDlgItem(IDC_PRF_CON_CONTROL_RATIMER_VALUE)->SetWindowText(strBuffer);
}
// X-Ray :: VariableReaskTime :: End