#pragma once
#include "Ping.h"
#include "Preferences.h"

#define CONSTATE_NULL			0
#define CONSTATE_ONLINE			1
#define CONSTATE_OFFLINE		2
#define CONSTATE_BLOCKED		3

#define CONFORCE_NULL			0
#define CONFORCE_OFFLINE		1
#define CONFORCE_ONLINE			2

//saves a bit of RAM :)
#define cmd_step	0
#define cmd_exit	1
#define cmd_num		2

namespace WombatAgent
{
	class CConChecker
	{
	public:
		CConChecker();
		~CConChecker(void);
		void SetPreferences();

	private:
		static UINT ThreadProc(LPVOID pParam);

	protected:
		void		Exit();
		void		Init();
		bool	m_bRun;

		DWORD	m_dwID;
		DWORD	m_dwState;

		HANDLE	m_hThread;
		HANDLE	m_hEvent[cmd_num];
		HANDLE  m_hKilled;

		CPing	ping;
		CMutex	m_StateLock;

	public:
		bool		Start();
		bool		Stop(const bool bWait = false);
		bool IsActive();
		void		Process(const DWORD& dwTime);
		DWORD GetState();	

		//
		//Pinger components
		//
	public:
		DWORD	GetIP()			  {return m_dwIP;}
		CString GetIPString()	  {return m_strIP;}
		DWORD	GetID()			  {return m_dwIP;}
		BOOL		Check(const bool bInitial = false);
//		void		SettingsChanged();

	protected:
		bool		ActivePing();
		BOOL		PassivePing();
		bool		m_bSettingsChanged;
		bool		m_bICMP;

		DWORD		m_nCounter;
		DWORD		m_dwIP;
		DWORD		m_dwLastCheck;

		uint16		m_nPingTimeout;
		uint8		m_nPingTTL;

		CString		m_strIP;
		CMutex		m_DataLock;

//>>> For internal tests only
	public:
		void SetForceMode(DWORD mode);
		DWORD GetForceMode();
		/*void		SetPingTime(const DWORD& time);
		DWORD		GetPingTime();*/

	protected:
		DWORD		m_nForceMode;
		CMutex		m_ForceLock;
		//DWORD		m_nPingTime;
		CMutex		m_PingTimeLock;
//<<< For internal tests only
	};
}

extern const UINT UWM_CONCHECKER;