// CRollupCtrl & CRollupHeader
// (c) 2002 by FoRcHa (a.k.a. NO)  [seppforcher38@hotmail.com]
//
// I would appreciate a notification of any bugs or bug fixes to help the control grow.
///////////////////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_ROLLUPCTRL_H__D92916B0_C46D_4257_8B0E_2BDB4D420BEE__INCLUDED_)
#define AFX_ROLLUPCTRL_H__D92916B0_C46D_4257_8B0E_2BDB4D420BEE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// RollupCtrl.h : header file
//

#include "RollupGripper.h"
#include "..\..\EnBitmap.h"


#define USRMSG_STATECHANGED		WM_USER + 1
#define USRMSG_RIGHTCLICK		WM_USER + 3

#define RUP_HEADERHEIGHT	20
#define RUP_BORDERSIZES		 5
#define RUP_ENTRYMINHEIGHT	40

/////////////////////////////////////////////////////////////////////////////
// CRollupHeader window

class CRollupHeader : public CWnd
{
// Construction
public:
	CRollupHeader();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CRollupHeader)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CRollupHeader();

	bool IsExpanded()
	{
		return m_bExpanded;
	}
	void Expand(bool bExpand = FALSE, bool bInvalidate = true)
	{
		m_bExpanded = bExpand;
		if(m_hWnd && bInvalidate)
			Invalidate();
	}
	void SetLeftText(CString strLeftText)
	{
		m_strLeftText = strLeftText;
		if(m_hWnd)
			Invalidate();
	}
	void SetRightText(CString strRightText)
	{
		m_strRightText = strRightText;
		if(m_hWnd)
			Invalidate();
	}
	void SetHeight(int iHeight)
	{
		m_iHeight = iHeight;
	}
	void SetBackColor(COLORREF crBackColor)
	{
		m_crBackColor = crBackColor;
	}
	void SetTextColor(COLORREF crTextColor)
	{
		m_crTextColor = crTextColor;
	}
	void SetBorderColor(COLORREF crBorderColor)
	{
		m_crBorderColor = crBorderColor;
	}



	CEnBitmap m_co_Upload;
	CEnBitmap m_co_Queue;
	CEnBitmap m_co_Clients;




	// Generated message map functions
protected:
	COLORREF m_crBackColor;
	COLORREF m_crTextColor;
	COLORREF m_crBorderColor;

	CFont	m_cfTextFont;
	CPen	m_cpBorderPen;
	CPen	m_cpArrowPen;

	CString m_strLeftText;
	CString m_strRightText;

	CDC		m_MemDC;
	CBitmap m_MemBMP;
	CBitmap *m_pOldMemBMP;

	CRect	m_rClientRect;
	CRect	m_rTextRect;
	CRect	m_rArrowRect;
	CPoint	m_cpArrowPoint;

	int		m_iHeight;
	bool	m_bInit;
	bool	m_bExpanded;

	void CreateMemDC(CDC *pDC, CRect *pRect)
	{
		if(m_pOldMemBMP && m_MemDC.m_hDC)
		{
			m_MemDC.SelectObject(m_pOldMemBMP);
#ifdef _DEBUG
			m_pOldMemBMP = NULL;
#endif
		}
		if(m_MemDC.m_hDC)
			m_MemDC.DeleteDC();
		m_MemDC.CreateCompatibleDC(pDC);
		if(m_MemBMP.m_hObject)
			m_MemBMP.DeleteObject();
		m_MemBMP.CreateCompatibleBitmap(pDC, pRect->Width(), pRect->Height());
		m_pOldMemBMP = m_MemDC.SelectObject(&m_MemBMP);
	}

	void DrawArrow(CDC* pDC, CPoint* pTopLeft, bool bDown);

	//{{AFX_MSG(CRollupHeader)
	afx_msg void OnPaint();
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnSysColorChange();
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
};

typedef struct ROLLUP_STRUCT
{
	CRollupHeader	*pHeader;
	CRollupGripper	*pGripper;
	CWnd			*pClient;
	double			*pSizes;
	int				iMinHeight;

}RollupEntry;

/////////////////////////////////////////////////////////////////////////////
// CRollupCtrl window

class CRollupCtrl : public CWnd
{

// Construction
public:
	CRollupCtrl();

// Attributes
public:

// Operations
public:
	int InsertItem(LPCTSTR strLeft, LPCTSTR strRight, CWnd *pClient,
					int iIndex = -1, bool bExpanded = FALSE);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CRollupCtrl)
	public:
	protected:
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:
	int SetItemHeights(unsigned uiItem, double *pHeights, int iCount);
	int SetText(unsigned uiItem, CString strText, bool bLeft = FALSE);
	int SetHeaderColor(unsigned uiItem, int iColor, COLORREF crColor);
	int SetItemClient(unsigned uiItem, CWnd *pClient);
	int ExpandItem(unsigned uiItem, bool bExpand = TRUE);
	virtual ~CRollupCtrl();

	int Recalc(HWND hWnd);
	CWnd* GetItemClient(unsigned uiItem);
	RollupEntry* GetItem(unsigned uiItem);
	unsigned GetCount() const { return m_List.GetCount(); }

protected:
	CArray<RollupEntry*,RollupEntry*> m_List;
	int m_iExpandedItems;
	int m_iHeaderHeight;
	BYTE m_bExpandedItems;	// max. 8 items

	//{{AFX_MSG(CRollupCtrl)
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
protected:
	void ChildStateChanged(HWND hChild, bool bInvalidate = true);
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ROLLUPCTRL_H__D92916B0_C46D_4257_8B0E_2BDB4D420BEE__INCLUDED_)
// (p) 2002 by FoRcHa (a.k.a. NO)  [seppforcher38@hotmail.com]
