//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PPg_X_Share.h"
#include "opcodes.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "Log.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPg_X_Share, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPg_X_Share, CPropertyPage)
	ON_BN_CLICKED(IDC_PRF_SHARE_TWEAKS_QPF_CHK, OnSettingsChange) // X-Ray :: QPFPush
	ON_BN_CLICKED(IDC_PRF_SHARE_TWEAKS_SUQWT_CHK, OnBnClickedSUQWT) // X-Ray :: SUQWT
	ON_BN_CLICKED(IDC_PRF_SHARE_TWEAKS_INFQUEUE_CHK, OnSettingsChange) // X-Ray :: InfiniteQueue
	// X-Ray :: ReleaseBonus :: Start
	ON_BN_CLICKED(IDC_PRF_SHARE_RELBONUS_CHK, OnBnClickedReleaseBonus)
	ON_BN_CLICKED(IDC_PRF_SHARE_RELBONUS_6H, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_SHARE_RELBONUS_12H, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_SHARE_RELBONUS_1D, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_SHARE_RELBONUS_2D, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_SHARE_RELBONUS_4D, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_SHARE_RELBONUS_8D, OnSettingsChange)
	// X-Ray :: ReleaseBonus :: End
END_MESSAGE_MAP()

CPPg_X_Share::CPPg_X_Share()
	: CPropertyPage(CPPg_X_Share::IDD)
{
}

CPPg_X_Share::~CPPg_X_Share()
{
}

void CPPg_X_Share::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BOOL CPPg_X_Share::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPg_X_Share::OnApply()
{
	thePrefs.SetIsQPFpushEnabled(IsDlgButtonChecked(IDC_PRF_SHARE_TWEAKS_QPF_CHK) ? true : false); // X-Ray :: QPFPush
	thePrefs.SetSaveUploadQueueWaitTime(IsDlgButtonChecked(IDC_PRF_SHARE_TWEAKS_SUQWT_CHK) ? true : false); // X-Ray :: SUQWT
	thePrefs.SetIsInfiniteQueueEnabled(IsDlgButtonChecked(IDC_PRF_SHARE_TWEAKS_INFQUEUE_CHK) ? true : false); // X-Ray :: InfiniteQueue

	// X-Ray :: ReleaseBonus :: Start
	if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_CHK)){
		thePrefs.SetUseReleaseBonus(true);
		if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_8D))
			thePrefs.SetReleaseBonus(32);
		else if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_4D))
			thePrefs.SetReleaseBonus(16);
		else if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_2D))
			thePrefs.SetReleaseBonus(8);
		else if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_1D))
			thePrefs.SetReleaseBonus(4);
		else if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_12H))
			thePrefs.SetReleaseBonus(2);
		else if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_6H))
			thePrefs.SetReleaseBonus(1);
		else
			thePrefs.SetReleaseBonus(0);

	} else {
		thePrefs.SetUseReleaseBonus(false);
		thePrefs.SetReleaseBonus(0);
	}
	// X-Ray :: ReleaseBonus :: End

	LoadSettings();
	return TRUE;
}

void CPPg_X_Share::LoadSettings()
{
	CheckDlgButton(IDC_PRF_SHARE_TWEAKS_QPF_CHK, thePrefs.IsQPFpushEnabled()); // X-Ray :: QPFPush
	CheckDlgButton(IDC_PRF_SHARE_TWEAKS_SUQWT_CHK, thePrefs.SaveUploadQueueWaitTime()); // X-Ray :: SUQWT
	CheckDlgButton(IDC_PRF_SHARE_TWEAKS_INFQUEUE_CHK, thePrefs.IsInfiniteQueueEnabled()); // X-Ray :: InfiniteQueue

	// X-Ray :: ReleaseBonus :: Start
	if(thePrefs.GetUseReleaseBonus() && thePrefs.SaveUploadQueueWaitTime()){
		uint8 priority = thePrefs.GetReleaseBonus();
		if(priority == 32) {
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, true);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_8D, true);
			OnLoadReleaseBonus();
		} else if(priority == 16) {
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, true);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_4D, true);
			OnLoadReleaseBonus();
		} else if(priority == 8) {
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, true);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_2D, true);
			OnLoadReleaseBonus();
		} else if(priority == 4) {
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, true);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_1D, true);
			OnLoadReleaseBonus();
		} else if(priority == 2) {
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, true);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_12H, true);
			OnLoadReleaseBonus();
		} else if(priority == 1) {
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, true);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_6H, true);
			OnLoadReleaseBonus();
		} else {
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, false);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_6H, false);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_12H, false);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_1D, false);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_2D, false);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_4D, false);
			CheckDlgButton(IDC_PRF_SHARE_RELBONUS_8D, false);
			OnLoadReleaseBonus();
		}
	} else {
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_6H, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_12H, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_1D, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_2D, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_4D, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_8D, false);
		OnLoadReleaseBonus();
	}
	// X-Ray :: ReleaseBonus :: End
}

void CPPg_X_Share::Localize()
{
	if (m_hWnd)
	{
		GetDlgItem(IDC_PRF_SHARE_TWEAKS_GRP)->SetWindowText(GetResString(IDS_PRF_SHARE_TWEAKS_GRP));
		GetDlgItem(IDC_PRF_SHARE_TWEAKS_QPF_CHK)->SetWindowText(GetResString(IDS_PRF_SHARE_TWEAKS_QPF_CHK)); // X-Ray :: QPFPush
		GetDlgItem(IDC_PRF_SHARE_TWEAKS_SUQWT_CHK)->SetWindowText(GetResString(IDS_PRF_SHARE_TWEAKS_SUQWT_CHK)); // X-Ray :: SUQWT
		GetDlgItem(IDC_PRF_SHARE_TWEAKS_INFQUEUE_CHK)->SetWindowText(GetResString(IDS_PRF_SHARE_TWEAKS_INFQUEUE_CHK)); // X-Ray :: InfiniteQueue

		// X-Ray :: ReleaseBonus :: Start
		GetDlgItem(IDC_PRF_SHARE_RELEASEBONUS_GRP)->SetWindowText(GetResString(IDS_PRF_SHARE_RELEASEBONUS_GRP));
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_CHK)->SetWindowText(GetResString(IDS_PRF_SHARE_RELBONUS_CHK));
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_6H)->SetWindowText(GetResString(IDS_PRF_SHARE_RELBONUS_6H));
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_12H)->SetWindowText(GetResString(IDS_PRF_SHARE_RELBONUS_12H));
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_1D)->SetWindowText(GetResString(IDS_PRF_SHARE_RELBONUS_1D));
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_2D)->SetWindowText(GetResString(IDS_PRF_SHARE_RELBONUS_2D));
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_4D)->SetWindowText(GetResString(IDS_PRF_SHARE_RELBONUS_4D));
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_8D)->SetWindowText(GetResString(IDS_PRF_SHARE_RELBONUS_8D));
		// X-Ray :: ReleaseBonus :: End
	}
}

// X-Ray :: ReleaseBonus :: Start
void CPPg_X_Share::OnBnClickedReleaseBonus()
{
	if(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_CHK)) {
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_6H)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_12H)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_1D)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_2D)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_4D)->EnableWindow(true);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_8D)->EnableWindow(true);
	} else {
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_6H, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_12H, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_1D, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_2D, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_4D, false);
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_8D, false);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_6H)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_12H)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_1D)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_2D)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_4D)->EnableWindow(false);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_8D)->EnableWindow(false);
	}
	SetModified();
}

void CPPg_X_Share::OnLoadReleaseBonus()
{
	GetDlgItem(IDC_PRF_SHARE_RELBONUS_6H)->EnableWindow(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_CHK));
	GetDlgItem(IDC_PRF_SHARE_RELBONUS_12H)->EnableWindow(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_CHK));
	GetDlgItem(IDC_PRF_SHARE_RELBONUS_1D)->EnableWindow(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_CHK));
	GetDlgItem(IDC_PRF_SHARE_RELBONUS_2D)->EnableWindow(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_CHK));
	GetDlgItem(IDC_PRF_SHARE_RELBONUS_4D)->EnableWindow(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_CHK));
	GetDlgItem(IDC_PRF_SHARE_RELBONUS_8D)->EnableWindow(IsDlgButtonChecked(IDC_PRF_SHARE_RELBONUS_CHK));
}
// X-Ray :: ReleaseBonus :: End

// X-Ray :: SUQWT :: Start
void CPPg_X_Share::OnBnClickedSUQWT()
{
	if(IsDlgButtonChecked(IDC_PRF_SHARE_TWEAKS_SUQWT_CHK))
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_CHK)->EnableWindow(true);
	else {
		CheckDlgButton(IDC_PRF_SHARE_RELBONUS_CHK, false);
		GetDlgItem(IDC_PRF_SHARE_RELBONUS_CHK)->EnableWindow(false);
		OnBnClickedReleaseBonus();
	}
}
// X-Ray :: SUQWT :: End