//this file is part of eMule
//Copyright (C)2002-2007 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once
#include "MuleListCtrl.h"
#include "TitleMenu.h"
#include "ListCtrlItemWalk.h"
#include "Addons/ModelessDialogs/Modeless.h" // X-Ray :: ModelessDialogs

class CSharedFileList;
class CKnownFile;
class CDirectoryItem;
class CToolTipCtrlX;

// X-Ray :: SharedParts :: Start
class CSharedFileList;
class CKnownFile;
class CSharedFilesCtrl;

///////////////////////////////////////////////////////////////////////////////
// CSharedItem

class CSharedItem: public CObject
{
	DECLARE_DYNAMIC(CSharedItem)
public:

	bool		isFile;
	bool		isOpen;
	uint16		Part;
	uint16		Parts;
	CKnownFile	*KnownFile;
};

///////////////////////////////////////////////////////////////////////////////
// CSharedFilesListCtrlItemWalk

class CSharedFilesListCtrlItemWalk : public CListCtrlItemWalk
{
public:
	CSharedFilesListCtrlItemWalk(CSharedFilesCtrl* pListCtrl);

	virtual CObject* GetNextSelectableItem();
	virtual CObject* GetPrevSelectableItem();

	void SetItemTypeParts(bool Parts) { m_iParts = Parts; }

protected:
	CSharedFilesCtrl* m_pSharedFilesListCtrl;
	bool m_iParts;
};
// X-Ray :: SharedParts :: End

///////////////////////////////////////////////////////////////////////////////
// CSharedFilesCtrl

// X-Ray :: SharedParts :: Start
/*
class CSharedFilesCtrl : public CMuleListCtrl, public CListCtrlItemWalk
*/
class CSharedFilesCtrl : public CMuleListCtrl, public CSharedFilesListCtrlItemWalk
// X-Ray :: SharedParts :: End
{
	friend class CSharedDirsTreeCtrl;
	DECLARE_DYNAMIC(CSharedFilesCtrl)

public:
	CSharedFilesCtrl();
	virtual ~CSharedFilesCtrl();

	void	Init();
	void	CreateMenues();
	void	ReloadFileList();
	void	AddFile(const CKnownFile* file);
	void	RemoveFile(const CKnownFile* file);
	void	UpdateFile(const CKnownFile* file);
	// X-Ray :: SharedParts :: Start
	void	UpdatePart(const CSharedItem* part); 
	BOOL	DeleteAllItems();
	// X-Ray :: SharedParts :: End
	void	Localize();
	void	ShowFilesCount();
	void	ShowComments(CKnownFile* file);
	void	SetAICHHashing(uint32 nVal)				{ nAICHHashing = nVal; }
	void	SetDirectoryFilter(CDirectoryItem* pNewFilter, bool bRefresh = true);

protected:
	CTitleMenu		m_SharedFilesMenu;
	CTitleMenu		m_CollectionsMenu;
	CTitleMenu		m_PrioDownMenu; // X-Ray :: DLULPrioExtension
	CTitleMenu		m_PrioMenu; // X-Ray :: MOD
	bool			sortstat[4];
	CImageList		m_ImageList;
	CDirectoryItem*	m_pDirectoryFilter;
	volatile uint32 nAICHHashing;
	CToolTipCtrlX*	m_pToolTip;

	static int CALLBACK SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort);
	// X-Ray :: SharedParts :: Start
	static int Compare(const CKnownFile* item1, const CKnownFile* item2, LPARAM lParamSort);
	static int Compare(const CSharedItem* item1, const CSharedItem* item2, LPARAM lParamSort);
	// X-Ray :: SharedParts :: End
	void OpenFile(const CKnownFile* file);
	void ShowFileDialog(CTypedPtrList<CPtrList, CKnownFile*>& aFiles, UINT uPshInvokePage = 0);
	void SetAllIcons();
	int FindFile(const CKnownFile* pFile);
	int FindPart(const CSharedItem* pPart); // X-Ray :: SharedParts

	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);

	// X-Ray :: SharedParts :: Start
	void ExpandCollapseItem(int Item);
	void DrawFileItem(CDC *dc, int iColumn, LPRECT cur_rec, CKnownFile *file);
	void DrawPartItem(CDC *dc, int iColumn, LPRECT cur_rec, CSharedItem *part);
	// X-Ray :: SharedParts :: End

	DECLARE_MESSAGE_MAP()
	afx_msg void OnSysColorChange();
	afx_msg	void OnColumnClick( NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnNMDblclk(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnGetDispInfo(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnLvnGetInfoTip(NMHDR *pNMHDR, LRESULT *pResult);
};

// X-Ray :: ModelessDialogs :: Start
class CSharedFileDetailsSheetInterface : public CListViewWalkerModelessPropertySheetInterface
{
public:
	CSharedFileDetailsSheetInterface(CKnownFile* owner);
	void	OpenDetailsSheet(CTypedPtrList<CPtrList, CKnownFile*>& aFiles, UINT uPshInvokePage = 0, CListCtrlItemWalk* pListCtrl = NULL);

protected:
	virtual CListViewWalkerModelessPropertySheet* CreatePropertySheet(va_list);
};
// X-Ray :: ModelessDialogs :: End