//this file is part of eMule
//Copyright (C)2002-2007 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "emuledlg.h"
#include "SharedFilesCtrl.h"
#include "OtherFunctions.h"
#include "FileInfoDialog.h"
// X-Ray :: ModelessDialogs :: Start
/*
#include "MetaDataDlg.h"
#include "ED2kLinkDlg.h"
#include "ArchivePreviewDlg.h"
#include "CommentDialog.h"
#include "HighColorTab.hpp"
#include "ListViewWalkerPropertySheet.h"
*/
#include "FileDetailDialog.h"
// X-Ray :: ModelessDialogs :: End
#include "UserMsgs.h"
#include "ResizableLib/ResizableSheet.h"
#include "KnownFile.h"
#include "MapKey.h"
#include "SharedFileList.h"
#include "MemDC.h"
#include "PartFile.h"
#include "MenuCmds.h"
#include "IrcWnd.h"
#include "SharedFilesWnd.h"
#include "Opcodes.h"
#include "InputBox.h"
#include "WebServices.h"
#include "TransferWnd.h"
#include "ClientList.h"
#include "UpDownClient.h"
#include "Collection.h"
#include "CollectionCreateDialog.h"
#include "CollectionViewDialog.h"
#include "SharedDirsTreeCtrl.h"
#include "SearchParams.h"
#include "SearchDlg.h"
#include "SearchResultsWnd.h"
#include "ToolTipCtrlX.h"
#include "DownloadQueue.h" // X-Ray :: SharedParts

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// X-Ray :: ModelessDialogs :: Start
/*
bool NeedArchiveInfoPage(const CSimpleArray<CObject*>* paItems);
void UpdateFileDetailsPages(CListViewWalkerPropertySheet *pSheet,
							CResizablePage *pArchiveInfo, CResizablePage *pMediaInfo);


//////////////////////////////////////////////////////////////////////////////
// CSharedFileDetailsSheet

class CSharedFileDetailsSheet : public CListViewWalkerPropertySheet
{
	DECLARE_DYNAMIC(CSharedFileDetailsSheet)

public:
	CSharedFileDetailsSheet(CTypedPtrList<CPtrList, CKnownFile*>& aFiles, UINT uPshInvokePage = 0, CListCtrlItemWalk* pListCtrl = NULL);
	virtual ~CSharedFileDetailsSheet();

protected:
	CFileInfoDialog		m_wndMediaInfo;
	CMetaDataDlg		m_wndMetaData;
	CED2kLinkDlg		m_wndFileLink;
	CCommentDialog		m_wndFileComments;
	CArchivePreviewDlg	m_wndArchiveInfo;

	UINT m_uPshInvokePage;
	static LPCTSTR m_pPshStartPage;

	void UpdateTitle();

	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	virtual BOOL OnInitDialog();

	DECLARE_MESSAGE_MAP()
	afx_msg void OnDestroy();
	afx_msg LRESULT OnDataChanged(WPARAM, LPARAM);
};

LPCTSTR CSharedFileDetailsSheet::m_pPshStartPage;

IMPLEMENT_DYNAMIC(CSharedFileDetailsSheet, CListViewWalkerPropertySheet)

BEGIN_MESSAGE_MAP(CSharedFileDetailsSheet, CListViewWalkerPropertySheet)
	ON_WM_DESTROY()
	ON_MESSAGE(UM_DATA_CHANGED, OnDataChanged)
END_MESSAGE_MAP()

CSharedFileDetailsSheet::CSharedFileDetailsSheet(CTypedPtrList<CPtrList, CKnownFile*>& aFiles, UINT uPshInvokePage, CListCtrlItemWalk* pListCtrl)
	: CListViewWalkerPropertySheet(pListCtrl)
{
	m_uPshInvokePage = uPshInvokePage;
	POSITION pos = aFiles.GetHeadPosition();
	while (pos)
		m_aItems.Add(aFiles.GetNext(pos));
	m_psh.dwFlags &= ~PSH_HASHELP;

	m_wndFileComments.m_psp.dwFlags &= ~PSP_HASHELP;
	m_wndFileComments.m_psp.dwFlags |= PSP_USEICONID;
	m_wndFileComments.m_psp.pszIcon = _T("FileComments");
	m_wndFileComments.SetFiles(&m_aItems);
	AddPage(&m_wndFileComments);

	m_wndArchiveInfo.m_psp.dwFlags &= ~PSP_HASHELP;
	m_wndArchiveInfo.m_psp.dwFlags |= PSP_USEICONID;
	m_wndArchiveInfo.m_psp.pszIcon = _T("ARCHIVE_PREVIEW");
	m_wndArchiveInfo.SetFiles(&m_aItems);
	m_wndMediaInfo.m_psp.dwFlags &= ~PSP_HASHELP;
	m_wndMediaInfo.m_psp.dwFlags |= PSP_USEICONID;
	m_wndMediaInfo.m_psp.pszIcon = _T("MEDIAINFO");
	m_wndMediaInfo.SetFiles(&m_aItems);
	if (NeedArchiveInfoPage(&m_aItems))
		AddPage(&m_wndArchiveInfo);
	else
	AddPage(&m_wndMediaInfo);

	m_wndMetaData.m_psp.dwFlags &= ~PSP_HASHELP;
	m_wndMetaData.m_psp.dwFlags |= PSP_USEICONID;
	m_wndMetaData.m_psp.pszIcon = _T("METADATA");
	if (m_aItems.GetSize() == 1 && thePrefs.IsExtControlsEnabled()) {
		m_wndMetaData.SetFiles(&m_aItems);
		AddPage(&m_wndMetaData);
	}

	m_wndFileLink.m_psp.dwFlags &= ~PSP_HASHELP;
	m_wndFileLink.m_psp.dwFlags |= PSP_USEICONID;
	m_wndFileLink.m_psp.pszIcon = _T("ED2KLINK");
	m_wndFileLink.SetFiles(&m_aItems);
	AddPage(&m_wndFileLink);

	LPCTSTR pPshStartPage = m_pPshStartPage;
	if (m_uPshInvokePage != 0)
		pPshStartPage = MAKEINTRESOURCE(m_uPshInvokePage);
	for (int i = 0; i < m_pages.GetSize(); i++)
	{
		CPropertyPage* pPage = GetPage(i);
		if (pPage->m_psp.pszTemplate == pPshStartPage)
		{
			m_psh.nStartPage = i;
			break;
		}
	}
}

CSharedFileDetailsSheet::~CSharedFileDetailsSheet()
{
}

void CSharedFileDetailsSheet::OnDestroy()
{
	if (m_uPshInvokePage == 0)
		m_pPshStartPage = GetPage(GetActiveIndex())->m_psp.pszTemplate;
	CListViewWalkerPropertySheet::OnDestroy();
}

BOOL CSharedFileDetailsSheet::OnInitDialog()
{
	EnableStackedTabs(FALSE);
	BOOL bResult = CListViewWalkerPropertySheet::OnInitDialog();
	HighColorTab::UpdateImageList(*this);
	InitWindowStyles(this);
	EnableSaveRestore(_T("SharedFileDetailsSheet")); // call this after(!) OnInitDialog
	UpdateTitle();
	return bResult;
}

LRESULT CSharedFileDetailsSheet::OnDataChanged(WPARAM, LPARAM)
{
	UpdateTitle();
	UpdateFileDetailsPages(this, &m_wndArchiveInfo, &m_wndMediaInfo);
	return 1;
}

void CSharedFileDetailsSheet::UpdateTitle()
{
	if (m_aItems.GetSize() == 1)
		SetWindowText(GetResString(IDS_DETAILS) + _T(": ") + STATIC_DOWNCAST(CKnownFile, m_aItems[0])->GetFileName());
	else
		SetWindowText(GetResString(IDS_DETAILS));
}

BOOL CSharedFileDetailsSheet::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_APPLY_NOW)
	{
		CSharedFilesCtrl* pSharedFilesCtrl = DYNAMIC_DOWNCAST(CSharedFilesCtrl, m_pListCtrl->GetListCtrl());
		if (pSharedFilesCtrl)
		{
			for (int i = 0; i < m_aItems.GetSize(); i++) {
				// so, and why does this not(!) work while the sheet is open ??
				pSharedFilesCtrl->UpdateFile(DYNAMIC_DOWNCAST(CKnownFile, m_aItems[i]));
			}
		}
	}

	return CListViewWalkerPropertySheet::OnCommand(wParam, lParam);
}
*/
// X-Ray :: ModelessDialogs :: End

//////////////////////////////////////////////////////////////////////////////
// CSharedFilesCtrl

IMPLEMENT_DYNAMIC(CSharedItem, CObject) // X-Ray :: SharedParts

IMPLEMENT_DYNAMIC(CSharedFilesCtrl, CMuleListCtrl)

BEGIN_MESSAGE_MAP(CSharedFilesCtrl, CMuleListCtrl)
	ON_WM_SYSCOLORCHANGE()
	ON_WM_CONTEXTMENU()
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnClick)
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnNMDblclk)
	ON_NOTIFY_REFLECT(LVN_GETDISPINFO, OnGetDispInfo)
	ON_NOTIFY_REFLECT(LVN_GETINFOTIP, OnLvnGetInfoTip)
	ON_WM_KEYDOWN()
END_MESSAGE_MAP()

CSharedFilesCtrl::CSharedFilesCtrl()
	// X-Ray :: SharedParts :: Start
	/*
	: CListCtrlItemWalk(this)
	*/
	: CSharedFilesListCtrlItemWalk(this)
	// X-Ray :: SharedParts :: End
{
	memset(&sortstat, 0, sizeof(sortstat));
	nAICHHashing = 0;
	m_pDirectoryFilter = NULL;
	SetGeneralPurposeFind(true, false);
	m_pToolTip = new CToolTipCtrlX;
}

CSharedFilesCtrl::~CSharedFilesCtrl()
{
	delete m_pToolTip;

	// X-Ray :: FiXeS :: Memleak :: Start :: fafner
	if (m_PrioMenu) VERIFY( m_PrioMenu.DestroyMenu() );
	if (m_CollectionsMenu) VERIFY( m_CollectionsMenu.DestroyMenu() );
	if (m_SharedFilesMenu) VERIFY( m_SharedFilesMenu.DestroyMenu() );
	// X-Ray :: FiXeS :: Memleak :: End :: fafner
}

void CSharedFilesCtrl::Init()
{
	SetName(_T("SharedFilesCtrl"));

	CImageList ilDummyImageList; //dummy list for getting the proper height of listview entries
	ilDummyImageList.Create(1, theApp.GetSmallSytemIconSize().cy,theApp.m_iDfltImageListColorFlags|ILC_MASK, 1, 1); 
	SetImageList(&ilDummyImageList, LVSIL_SMALL);
	ASSERT( (GetStyle() & LVS_SHAREIMAGELISTS) == 0 );
	ilDummyImageList.Detach();

	SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_INFOTIP);
	ASSERT( (GetStyle() & LVS_SINGLESEL) == 0 );

	InsertColumn(0, GetResString(IDS_DL_FILENAME) ,LVCFMT_LEFT,250,0);
	InsertColumn(1,GetResString(IDS_DL_SIZE),LVCFMT_LEFT,100,1);
	InsertColumn(2,GetResString(IDS_TYPE),LVCFMT_LEFT,50,2);
	InsertColumn(3,GetResString(IDS_PRIORITY),LVCFMT_LEFT,70,3);
	InsertColumn(4,GetResString(IDS_FILEID),LVCFMT_LEFT,220,4);
	InsertColumn(5,GetResString(IDS_SF_REQUESTS),LVCFMT_LEFT,100,5);
	InsertColumn(6,GetResString(IDS_SF_ACCEPTS),LVCFMT_LEFT,100,6);
	InsertColumn(7,GetResString(IDS_SF_TRANSFERRED),LVCFMT_LEFT,120,7);
	InsertColumn(8,GetResString(IDS_UPSTATUS),LVCFMT_LEFT,100,8);
	InsertColumn(9,GetResString(IDS_FOLDER),LVCFMT_LEFT,200,9);
	InsertColumn(10,GetResString(IDS_COMPLSOURCES),LVCFMT_LEFT,100,10);
	InsertColumn(11,GetResString(IDS_SHAREDTITLE),LVCFMT_LEFT,200,11);

	SetAllIcons();
	CreateMenues();
	LoadSettings();

	// Barry - Use preferred sort order from preferences
	SetSortArrow();
	SortItems(SortProc, GetSortItem() + (GetSortAscending() ? 0 : 20) + (GetSortSecondValue() ? 100 : 0));

	CToolTipCtrl* tooltip = GetToolTips();
	if (tooltip){
		m_pToolTip->SetFileIconToolTip(true);
		m_pToolTip->SubclassWindow(*tooltip);
		tooltip->ModifyStyle(0, TTS_NOPREFIX);
		tooltip->SetDelayTime(TTDT_AUTOPOP, 20000);
		tooltip->SetDelayTime(TTDT_INITIAL, thePrefs.GetToolTipDelay()*1000);
	}
}

void CSharedFilesCtrl::OnSysColorChange()
{
	CMuleListCtrl::OnSysColorChange();
	SetAllIcons();
	CreateMenues();
}

void CSharedFilesCtrl::SetAllIcons()
{
	m_ImageList.DeleteImageList();
	m_ImageList.Create(16,16,theApp.m_iDfltImageListColorFlags|ILC_MASK,0,1);
	m_ImageList.SetBkColor(CLR_NONE);
	m_ImageList.Add(CTempIconLoader(_T("EMPTY")));
	m_ImageList.Add(CTempIconLoader(_T("FileSharedServer"), 16, 16));
	m_ImageList.Add(CTempIconLoader(_T("FileSharedKad"), 16, 16));
	m_ImageList.Add(CTempIconLoader(_T("Rating_NotRated")));
	m_ImageList.Add(CTempIconLoader(_T("Rating_Fake")));
	m_ImageList.Add(CTempIconLoader(_T("Rating_Poor")));
	m_ImageList.Add(CTempIconLoader(_T("Rating_Fair")));
	m_ImageList.Add(CTempIconLoader(_T("Rating_Good")));
	m_ImageList.Add(CTempIconLoader(_T("Rating_Excellent")));
	m_ImageList.Add(CTempIconLoader(_T("Collection_Search"))); // rating for comments are searched on kad
	m_ImageList.SetOverlayImage(m_ImageList.Add(CTempIconLoader(_T("FileCommentsOvl"))), 1);
}

void CSharedFilesCtrl::Localize()
{
	CHeaderCtrl* pHeaderCtrl = GetHeaderCtrl();
	HDITEM hdi;
	hdi.mask = HDI_TEXT;
	CString strRes;

	strRes = GetResString(IDS_DL_FILENAME);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(0, &hdi);

	strRes = GetResString(IDS_DL_SIZE);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(1, &hdi);

	strRes = GetResString(IDS_TYPE);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(2, &hdi);

	strRes = GetResString(IDS_PRIORITY);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(3, &hdi);

	strRes = GetResString(IDS_FILEID);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(4, &hdi);

	strRes = GetResString(IDS_SF_REQUESTS);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(5, &hdi);

	strRes = GetResString(IDS_SF_ACCEPTS);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(6, &hdi);

	strRes = GetResString(IDS_SF_TRANSFERRED);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(7, &hdi);

	strRes = GetResString(IDS_SHARED_STATUS);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(8, &hdi);

	strRes = GetResString(IDS_FOLDER);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(9, &hdi);

	strRes = GetResString(IDS_COMPLSOURCES);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(10, &hdi);

	strRes = GetResString(IDS_SHAREDTITLE);
	hdi.pszText = const_cast<LPTSTR>((LPCTSTR)strRes);
	pHeaderCtrl->SetItem(11, &hdi);

	CreateMenues();

	int iItems = GetItemCount();
	for (int i = 0; i < iItems; i++)
		Update(i);
}

void CSharedFilesCtrl::AddFile(const CKnownFile* file)
{
	if (!theApp.emuledlg->IsRunning())
		return;
	// check filter conditions if we should show this file right now
	if (m_pDirectoryFilter != NULL){
		CString strFilePath = file->GetPath();
		if (strFilePath.Right(1) == "\\"){
			strFilePath = strFilePath.Left(strFilePath.GetLength()-1);
		}
		switch(m_pDirectoryFilter->m_eItemType){
			case SDI_ALL:
				// No filter
				break;
			case SDI_FILESYSTEMPARENT:
				return; // no files
				break;
			case SDI_NO:
				// some shared directory
			case SDI_CATINCOMING:
				// Categories with special incoming dirs
			case SDI_UNSHAREDDIRECTORY:
				// Items from the whole filesystem tree
				if (strFilePath.CompareNoCase(m_pDirectoryFilter->m_strFullPath) != 0)
					return;
				break;
			case SDI_TEMP:
				// only tempfiles
				if (!file->IsPartFile())
					return;
				else if (m_pDirectoryFilter->m_nCatFilter != -1 && (UINT)m_pDirectoryFilter->m_nCatFilter != ((CPartFile*)file)->GetCategory())
					return;
				break;
			case SDI_DIRECTORY:
				// any userselected shared dir but not incoming or temp
				if (file->IsPartFile())
					return;
				if (strFilePath.CompareNoCase(thePrefs.GetMuleDirectory(EMULE_INCOMINGDIR)) == 0)
					return;
				break;
			case SDI_INCOMING:
				// Main incoming directory
				if (strFilePath.CompareNoCase(thePrefs.GetMuleDirectory(EMULE_INCOMINGDIR)) != 0)
					return;
				// Hmm should we show all incoming files dirs or only those from the main incoming dir here?
				// hard choice, will only show the main for now
				break;

		}
	}
	if (FindFile(file) != -1)
		return;
	// X-Ray :: SharedParts :: Start
	/*
	int iItem = InsertItem(LVIF_TEXT|LVIF_PARAM, GetItemCount(), LPSTR_TEXTCALLBACK, 0, 0, 0, (LPARAM)file);
	*/
	CSharedItem *ItemData = new CSharedItem ;

	ItemData->isFile = true;
	ItemData->isOpen = false;
	ItemData->KnownFile = const_cast <CKnownFile*> (file);
	ItemData->Part = 0;
	ItemData->Parts = file->GetPartCount();

	int iItem = InsertItem(LVIF_TEXT|LVIF_PARAM, GetItemCount(), LPSTR_TEXTCALLBACK, 0, 0, 0, (LPARAM)ItemData);
	// X-Ray :: SharedParts :: End
	if (iItem >= 0)
		Update(iItem);
}

void CSharedFilesCtrl::RemoveFile(const CKnownFile* file)
{
	// X-Ray :: SharedParts :: Start
	/*
	int iItem = FindFile(file);
	if (iItem != -1)
	{
		DeleteItem(iItem);
		ShowFilesCount();
	}
	*/
	if(file == NULL)
		return;

	CSharedItem* ItemData;
	for(int nItem=0; nItem<GetItemCount(); nItem++){
		ItemData=(CSharedItem*)GetItemData(nItem);
		if(ItemData->isFile && ItemData->KnownFile == file){
			if(ItemData->isOpen){
				for(uint16 Part=0; Part<ItemData->Parts; Part++){
					CSharedItem* ItemDataPart=(CSharedItem*)GetItemData(nItem+1);
					if (ItemDataPart->isFile) 
						break;
					SetItemData(nItem+1, NULL);
					DeleteItem(nItem+1);
					if(ItemDataPart) 
						delete ItemDataPart;
				}
			}

			SetItemData(nItem, NULL);
			DeleteItem(nItem);
			if(ItemData) 
				delete ItemData;
		}
	}
	ShowFilesCount();
	// X-Ray :: SharedParts :: End
}

void CSharedFilesCtrl::UpdateFile(const CKnownFile* file)
{
	if (!file || !theApp.emuledlg->IsRunning())
		return;
	int iItem = FindFile(file);
	if (iItem != -1)
	{
		Update(iItem);
		if (GetItemState(iItem, LVIS_SELECTED))
			theApp.emuledlg->sharedfileswnd->ShowSelectedFilesSummary();
	}
}

int CSharedFilesCtrl::FindFile(const CKnownFile* pFile)
{
	// X-Ray :: SharedParts :: Start
	/*
	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)pFile;
	return FindItem(&find);
	*/
	CSharedItem* ItemData;
	for(int nItem=0; nItem<GetItemCount(); nItem++){
		ItemData=(CSharedItem*)GetItemData(nItem);
		if(ItemData->isFile && ItemData->KnownFile == pFile)
			return nItem;
	}

	return -1;
	// X-Ray :: SharedParts :: End
}

// X-Ray :: SharedParts :: Start
void CSharedFilesCtrl::UpdatePart(const CSharedItem* part)
{
	if (!part || !theApp.emuledlg->IsRunning())
		return;
	int iItem = FindPart(part);
	if (iItem != -1)
		Update(iItem);
}

int CSharedFilesCtrl::FindPart(const CSharedItem* pPart)
{
	CSharedItem* ItemData;
	for(int nItem = 0; nItem < GetItemCount(); nItem++){
		ItemData = (CSharedItem*)GetItemData(nItem);
		if(ItemData == pPart)
			return nItem;
	}

	return -1;
}
// X-Ray :: SharedParts :: End

void CSharedFilesCtrl::ReloadFileList()
{
	DeleteAllItems();
	theApp.emuledlg->sharedfileswnd->ShowSelectedFilesSummary();
	
	CCKey bufKey;
	CKnownFile* cur_file;
	for (POSITION pos = theApp.sharedfiles->m_Files_map.GetStartPosition(); pos != 0; ){
		theApp.sharedfiles->m_Files_map.GetNextAssoc(pos, bufKey, cur_file);
		AddFile(cur_file);
	}
	ShowFilesCount();
}

void CSharedFilesCtrl::ShowFilesCount()
{
	CString str;
	if (theApp.sharedfiles->GetHashingCount() + nAICHHashing)
		str.Format(_T(" (%i, %s %i)"), theApp.sharedfiles->GetCount(), GetResString(IDS_HASHING), theApp.sharedfiles->GetHashingCount() + nAICHHashing);
	else
		str.Format(_T(" (%i)"), theApp.sharedfiles->GetCount());
	theApp.emuledlg->sharedfileswnd->GetDlgItem(IDC_TRAFFIC_TEXT)->SetWindowText(GetResString(IDS_SF_FILES) + str);
}

#define DLC_DT_TEXT (DT_LEFT|DT_SINGLELINE|DT_VCENTER|DT_NOPREFIX|DT_END_ELLIPSIS)

void CSharedFilesCtrl::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	if (!theApp.emuledlg->IsRunning())
		return;
	if (!lpDrawItemStruct->itemData)
		return;

	// X-Ray :: Optimizations :: Start - Don't draw hidden Rect
	RECT clientRect;
	GetClientRect(&clientRect);
	CRect cur_rec(lpDrawItemStruct->rcItem);
	if ((cur_rec.top < clientRect.top || cur_rec.top > clientRect.bottom) && (cur_rec.bottom < clientRect.top || cur_rec.bottom > clientRect.bottom))
		return;
	// X-Ray :: Optimizations :: End - Don't draw hidden Rect

	CSharedItem* itemdata = (CSharedItem*)lpDrawItemStruct->itemData; // X-Ray :: SharedParts
	CDC* odc = CDC::FromHandle(lpDrawItemStruct->hDC);
	BOOL bCtrlFocused = ((GetFocus() == this) || (GetStyle() & LVS_SHOWSELALWAYS));
	if (lpDrawItemStruct->itemState & ODS_SELECTED) {
		if (bCtrlFocused)
			odc->SetBkColor(m_crHighlight);
		else
			odc->SetBkColor(m_crNoHighlight);
	}
	else
		odc->SetBkColor(GetBkColor());

	// X-Ray :: SharedParts :: Start
	///*const*/ CKnownFile* file = (CKnownFile*)lpDrawItemStruct->itemData;
	// X-Ray :: SharedParts :: End

	CMemDC dc(odc, &lpDrawItemStruct->rcItem);
	CFont* pOldFont = dc.SelectObject(GetFont());
	// CRect cur_rec(lpDrawItemStruct->rcItem); // X-Ray :: Optimizations - Don't draw hidden Rect
	COLORREF crOldTextColor = dc.SetTextColor((lpDrawItemStruct->itemState & ODS_SELECTED) ? m_crHighlightText : m_crWindowText);

	int iOldBkMode;
	if (m_crWindowTextBk == CLR_NONE){
		DefWindowProc(WM_ERASEBKGND, (WPARAM)(HDC)dc, 0);
		iOldBkMode = dc.SetBkMode(TRANSPARENT);
	}
	else
		iOldBkMode = OPAQUE;

	CHeaderCtrl *pHeaderCtrl = GetHeaderCtrl();
	int iCount = pHeaderCtrl->GetItemCount();
	const int iMarginX = 4;
	cur_rec.right = cur_rec.left - iMarginX*2;
	cur_rec.left += iMarginX;
	// X-Ray :: SharedParts :: Start
	/*
	CString buffer;
	int iIconDrawWidth = theApp.GetSmallSytemIconSize().cx + 3;
	*/
	// X-Ray :: SharedParts :: End
	for(int iCurrent = 0; iCurrent < iCount; iCurrent++){
		int iColumn = pHeaderCtrl->OrderToIndex(iCurrent);
		if( !IsColumnHidden(iColumn) ){
			// X-Ray :: SharedParts :: Start
			/*
			UINT uDTFlags = DLC_DT_TEXT;
			*/
			// X-Ray :: SharedParts :: End
			cur_rec.right += GetColumnWidth(iColumn);

			if (cur_rec.left < clientRect.right && cur_rec.right > clientRect.left){ // X-Ray :: Optimizations - Only draw item if inside the display area
				// X-Ray :: SharedParts :: Start
				/*
				switch(iColumn){
					case 0:{
						int iImage = theApp.GetFileTypeSystemImageIdx(file->GetFileName());
						if (theApp.GetSystemImageList() != NULL)
							::ImageList_Draw(theApp.GetSystemImageList(), iImage, dc.GetSafeHdc(), cur_rec.left, cur_rec.top, ILD_NORMAL|ILD_TRANSPARENT);
						if (!file->GetFileComment().IsEmpty() || file->GetFileRating())
							m_ImageList.Draw(dc, 0, CPoint(cur_rec.left, cur_rec.top), ILD_NORMAL | ILD_TRANSPARENT | INDEXTOOVERLAYMASK(1));
						cur_rec.left += (iIconDrawWidth - 3);

						if (thePrefs.ShowRatingIndicator() && (file->HasComment() || file->HasRating() || file->IsKadCommentSearchRunning()))
						{
							m_ImageList.Draw(dc, file->UserRating(true)+3, CPoint(cur_rec.left, cur_rec.top), ILD_NORMAL);
							cur_rec.left += 16;
							iIconDrawWidth += 16;
						}

						cur_rec.left += 3;

						buffer = file->GetFileName();
						break;
					}
					case 1:
						buffer = CastItoXBytes(file->GetFileSize(), false, false);
						uDTFlags |= DT_RIGHT;
						break;
					case 2:
						buffer = file->GetFileTypeDisplayStr();
						break;
					case 3:{
						buffer = file->GetUpPriorityDisplayString();
						// X-Ray :: SlotRelease :: Start
						if (file->IsReleaseFile())
							buffer += _T(" [") + GetResString(IDS_RELEASEFILE) + _T("]");
						// X-Ray :: SlotRelease :: End

						break;
					}
					case 4:
						buffer = md4str(file->GetFileHash());
						break;
					case 5:
						buffer.Format(_T("%u (%u)"), file->statistic.GetRequests(), file->statistic.GetAllTimeRequests());
						break;
					case 6:
						buffer.Format(_T("%u (%u)"), file->statistic.GetAccepts(), file->statistic.GetAllTimeAccepts());
						break;
					case 7:
						buffer.Format(_T("%s (%s)"), CastItoXBytes(file->statistic.GetTransferred(), false, false), CastItoXBytes(file->statistic.GetAllTimeTransferred(), false, false));
						break;
					case 8:
						if (file->GetPartCount()){
							cur_rec.bottom--;
							cur_rec.top++;
							file->DrawShareStatusBar(dc,&cur_rec,false,thePrefs.UseFlatBar());
							cur_rec.bottom++;
							cur_rec.top--;
						}
						break;
					case 9:
						buffer = file->GetPath();
						PathRemoveBackslash(buffer.GetBuffer());
						buffer.ReleaseBuffer();
						break;
					case 10:
						if (file->m_nCompleteSourcesCountLo == file->m_nCompleteSourcesCountHi)
							buffer.Format(_T("%u"), file->m_nCompleteSourcesCountLo);
						else if (file->m_nCompleteSourcesCountLo == 0)
							buffer.Format(_T("< %u"), file->m_nCompleteSourcesCountHi);
						else
							buffer.Format(_T("%u - %u"), file->m_nCompleteSourcesCountLo, file->m_nCompleteSourcesCountHi);
						break;
					case 11:{
						CPoint pt(cur_rec.left, cur_rec.top);
						m_ImageList.Draw(dc, file->GetPublishedED2K() ? 1 : 0, pt, ILD_NORMAL | ILD_TRANSPARENT);
						pt.x += 16;
						bool bSharedInKad;
						if ((uint32)time(NULL) < file->GetLastPublishTimeKadSrc())
						{
							if (theApp.IsFirewalled() && theApp.IsConnected())
							{
								if (theApp.clientlist->GetBuddy() && (file->GetLastPublishBuddy() == theApp.clientlist->GetBuddy()->GetIP()))
									bSharedInKad = true;
								else
									bSharedInKad = false;
							}
							else
								bSharedInKad = true;
						}
						else
							bSharedInKad = false;
						m_ImageList.Draw(dc, bSharedInKad ? 2 : 0, pt, ILD_NORMAL | ILD_TRANSPARENT);
						buffer.Empty();
						break;
					}
				}

				if (iColumn != 8)
					dc.DrawText(buffer, buffer.GetLength(), &cur_rec, uDTFlags);
				if (iColumn == 0)
					cur_rec.left -= iIconDrawWidth;
				*/
				if(!itemdata->isFile)
					DrawPartItem(dc,iColumn,&cur_rec,itemdata);
				else
					DrawFileItem(dc,iColumn,&cur_rec,itemdata->KnownFile);
				// X-Ray :: SharedParts :: End
			}
			cur_rec.left += GetColumnWidth(iColumn);
		}
	}
	ShowFilesCount();
	if (lpDrawItemStruct->itemState & ODS_SELECTED)
	{
		RECT outline_rec = lpDrawItemStruct->rcItem;

		outline_rec.top--;
		outline_rec.bottom++;
		dc.FrameRect(&outline_rec, &CBrush(m_crWindow));
		outline_rec.top++;
		outline_rec.bottom--;
		outline_rec.left++;
		outline_rec.right--;

		if (lpDrawItemStruct->itemID > 0 && GetItemState(lpDrawItemStruct->itemID - 1, LVIS_SELECTED))
			outline_rec.top--;

		if (lpDrawItemStruct->itemID + 1 < (UINT)GetItemCount() && GetItemState(lpDrawItemStruct->itemID + 1, LVIS_SELECTED))
			outline_rec.bottom++;

		if(bCtrlFocused)
			dc.FrameRect(&outline_rec, &CBrush(m_crFocusLine));
		else
			dc.FrameRect(&outline_rec, &CBrush(m_crNoFocusLine));
	}
	
	if (m_crWindowTextBk == CLR_NONE)
		dc.SetBkMode(iOldBkMode);
	dc.SelectObject(pOldFont);
	dc.SetTextColor(crOldTextColor);
}

// X-Ray :: SharedParts :: Start
void CSharedFilesCtrl::DrawFileItem(CDC *dc, int iColumn, LPRECT cur_rec, CKnownFile *file)
{
	int iIconDrawWidth = theApp.GetSmallSytemIconSize().cx + 3;

	if (file->IsPartFile())
		dc->SetTextColor((COLORREF)RGB(0,0,192));
	else
		dc->SetTextColor((COLORREF)RGB(0,0,0));

	UINT uDTFlags = DLC_DT_TEXT; 
	CString buffer;

	switch(iColumn){
		case 0:{
			int iImage = theApp.GetFileTypeSystemImageIdx(file->GetFileName());
			if (theApp.GetSystemImageList() != NULL)
				::ImageList_Draw(theApp.GetSystemImageList(), iImage, dc->GetSafeHdc(), cur_rec->left, cur_rec->top, ILD_NORMAL|ILD_TRANSPARENT);
			if (!file->GetFileComment().IsEmpty() || file->GetFileRating())
				m_ImageList.Draw(dc, 0, CPoint(cur_rec->left, cur_rec->top), ILD_NORMAL | ILD_TRANSPARENT | INDEXTOOVERLAYMASK(1));
			cur_rec->left += (iIconDrawWidth - 3);

			if (thePrefs.ShowRatingIndicator() && (file->HasComment() || file->HasRating() || file->IsKadCommentSearchRunning()))
			{
				m_ImageList.Draw(dc, file->UserRating(true)+3, CPoint(cur_rec->left, cur_rec->top), ILD_NORMAL);
				cur_rec->left += 16;
				iIconDrawWidth += 16;
			}

			cur_rec->left += 3;

			buffer = file->GetFileName();
			break;
		}
		case 1:
			buffer = CastItoXBytes(file->GetFileSize(), false, false);
			uDTFlags |= DT_RIGHT;
			break;
		case 2:
			buffer = file->GetFileTypeDisplayStr();
			break;
		case 3:{
			buffer = file->GetUpPriorityDisplayString();
			break;
		}
		case 4:
			buffer = md4str(file->GetFileHash());
			break;
		case 5:
            buffer.Format(_T("%u (%u)"), file->statistic.GetRequests(), file->statistic.GetAllTimeRequests());
			break;
		case 6:
			buffer.Format(_T("%u (%u)"), file->statistic.GetAccepts(), file->statistic.GetAllTimeAccepts());
			break;
		case 7:
			buffer.Format(_T("%s (%s)"), CastItoXBytes(file->statistic.GetTransferred(), false, false), CastItoXBytes(file->statistic.GetAllTimeTransferred(), false, false));
			break;
		case 8:
			if (file->GetPartCount()){
				cur_rec->bottom--;
				cur_rec->top++;
				file->DrawShareStatusBar(dc,cur_rec,false,thePrefs.UseFlatBar());
				cur_rec->bottom++;
				cur_rec->top--;
			}
			break;
		case 9:
			buffer = file->GetPath();
			PathRemoveBackslash(buffer.GetBuffer());
			buffer.ReleaseBuffer();
			break;
		case 10:
            if (file->m_nCompleteSourcesCountLo == file->m_nCompleteSourcesCountHi)
				buffer.Format(_T("%u"), file->m_nCompleteSourcesCountLo);
            else if (file->m_nCompleteSourcesCountLo == 0)
				buffer.Format(_T("< %u"), file->m_nCompleteSourcesCountHi);
			else
				buffer.Format(_T("%u - %u"), file->m_nCompleteSourcesCountLo, file->m_nCompleteSourcesCountHi);
			break;
		case 11:{
			CPoint pt(cur_rec->left, cur_rec->top);
			m_ImageList.Draw(dc, file->GetPublishedED2K() ? 1 : 0, pt, ILD_NORMAL | ILD_TRANSPARENT);
			pt.x += 16;
			bool bSharedInKad;
			if ((uint32)time(NULL) < file->GetLastPublishTimeKadSrc())
			{
				if (theApp.IsFirewalled() && theApp.IsConnected())
				{
					if (theApp.clientlist->GetBuddy() && (file->GetLastPublishBuddy() == theApp.clientlist->GetBuddy()->GetIP()))
						bSharedInKad = true;
					else
						bSharedInKad = false;
				}
				else
					bSharedInKad = true;
			}
			else
				bSharedInKad = false;
			m_ImageList.Draw(dc, bSharedInKad ? 2 : 0, pt, ILD_NORMAL | ILD_TRANSPARENT);
			buffer.Empty();
			break;
		}
	}

	if (iColumn != 8)
		dc->DrawText(buffer, buffer.GetLength(), cur_rec, uDTFlags);
	if (iColumn == 0)
		cur_rec->left -= iIconDrawWidth;
} 

void CSharedFilesCtrl::DrawPartItem(CDC *dc, int iColumn, LPRECT cur_rec, CSharedItem *part)
{
	UINT uDTFlags = DLC_DT_TEXT; 
	CString buffer;

	bool bPartDone = false;
	if(part->KnownFile->IsPartFile())
		bPartDone = ((CPartFile*)part->KnownFile)->IsComplete(PARTSIZE*part->Part, PARTSIZE*part->Part+PARTSIZE-1, true);
	else
		bPartDone = theApp.downloadqueue->IsFileExisting(part->KnownFile->GetFileHash(),false); 

	dc->SetTextColor(bPartDone ? (COLORREF)RGB(0,0,0) : (COLORREF)RGB(192,192,192));

	switch(iColumn){
		case 0:
			cur_rec->left += 19;
			buffer.Format(L"#%d", part->Part);
			break;
		case 1:
			if(!bPartDone)
				buffer = GetResString(IDS_SHAREDPARTS_PART_INCOMPLETE);
			else
				buffer = GetResString(IDS_SHAREDPARTS_PART_DONE);
			break;
		case 2:
			break;
		case 3:
			break;
		case 4:
			buffer = md4str(part->KnownFile->GetPartHash(part->Part));
			break;
		case 5:
			break;
		case 6:
			break;
		case 7:
			break;
		case 8:
			break;
		case 9:
			break;
		case 10:
			break;
		case 11:
			break;
	}

	if (iColumn != 8)
		dc->DrawText(buffer, buffer.GetLength(), cur_rec, uDTFlags);
}
// X-Ray :: SharedParts :: End

void CSharedFilesCtrl::OnContextMenu(CWnd* /*pWnd*/, CPoint point)
{
	// X-Ray :: SharedParts :: Start
	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);

	CSharedItem* pSingleSelItem  = (iSel == -1) ? NULL : (CSharedItem*)GetItemData(iSel);
	if (pSingleSelItem && !pSingleSelItem->isFile){
		int iCompletePartSelected = 0; // X-Ray :: PartImportExport
		CKnownFile* pSingleSelKnownFile = pSingleSelItem->KnownFile;
		CPartFile* pSingleSelPartFile = NULL;
		if(pSingleSelKnownFile->IsPartFile())
			pSingleSelPartFile = (CPartFile*)pSingleSelKnownFile;

		bool bFileExist = theApp.downloadqueue->IsFileExisting(pSingleSelKnownFile->GetFileHash(), false);
		POSITION pos = GetFirstSelectedItemPosition();
		while (pos){
			const CSharedItem* pItem = (CSharedItem*)GetItemData(GetNextSelectedItem(pos));

			if(pItem->isFile)
				continue;

			if(pItem->KnownFile != pSingleSelKnownFile){
				pSingleSelKnownFile = NULL;
				pSingleSelPartFile = NULL;
				bFileExist = false;
				break;
			}

			iCompletePartSelected += (!pSingleSelPartFile || pSingleSelPartFile->IsComplete(PARTSIZE*pItem->Part, PARTSIZE*pItem->Part+PARTSIZE-1, true)) ? 1 : 0; // X-Ray :: PartImportExport
		}

		CTitleMenu PartMenu;
		PartMenu.CreatePopupMenu();
		PartMenu.AddMenuTitle(GetResString(IDS_SHAREDPARTS), true);

		// X-Ray :: PartImportExport :: Start
		PartMenu.AppendMenu(MF_STRING, MP_EXPORT, GetResString(IDS_EXPORT_PARTS), _T("PARTEXPORT"));
		PartMenu.EnableMenuItem(MP_EXPORT, (bFileExist && iCompletePartSelected > 0) ? MF_ENABLED : MF_GRAYED);
		// X-Ray :: PartImportExport :: End

		GetPopupMenuPos(*this, point);
		PartMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON, point.x, point.y, this);

		VERIFY( PartMenu.DestroyMenu() );

		return;
	}
	// X-Ray :: SharedParts :: End

	// get merged settings
	bool bFirstItem = true;
	int iSelectedItems = GetSelectedCount();
	int iCompleteFileSelected = -1;
	UINT uPrioMenuItem = 0;

	// X-Ray :: SharedParts :: Start
	/*
	const CKnownFile* pSingleSelFile = NULL;
	*/
	const CKnownFile* pSingleSelFile = pSingleSelItem ? pSingleSelItem->KnownFile : NULL;
	// X-Ray :: SharedParts :: End

	// X-Ray :: SlotRelease :: Start
	bool bReleaseFileSelected = false;
	bool bNonReleaseFileSelected = false;
	// X-Ray :: SlotRelease :: End

	// X-Ray :: DLULPrioExtension :: Start
	UINT uPrioDownMenuItem = 0;
	int iCheckedPartFile = 0;
	// X-Ray :: DLULPrioExtension :: End

	POSITION pos = GetFirstSelectedItemPosition();
	while (pos)
	{
		// X-Ray :: SharedParts :: Start
		/*
		const CKnownFile* pFile = (CKnownFile*)GetItemData(GetNextSelectedItem(pos));
		if (bFirstItem)
			pSingleSelFile = pFile;
		else
			pSingleSelFile = NULL;
		*/
		const CSharedItem* pItem = (CSharedItem*)GetItemData(GetNextSelectedItem(pos));
		if(!pItem->isFile)
			continue;
		const CKnownFile* pFile = pItem->KnownFile;
		// X-Ray :: SharedParts :: End

		int iCurCompleteFile = pFile->IsPartFile() ? 0 : 1;
		iCheckedPartFile += pFile->IsPartFile() ? 1 : 0; // X-Ray :: DLULPrioExtension
		if (bFirstItem)
			iCompleteFileSelected = iCurCompleteFile;
		else if (iCompleteFileSelected != iCurCompleteFile)
			iCompleteFileSelected = -1;

		UINT uCurPrioMenuItem = 0;
		if (pFile->IsAutoUpPriority())
			uCurPrioMenuItem = MP_PRIOAUTO;
		else if (pFile->GetUpPriority() == PR_VERYLOW)
			uCurPrioMenuItem = MP_PRIOVERYLOW;
		else if (pFile->GetUpPriority() == PR_LOW)
			uCurPrioMenuItem = MP_PRIOLOW;
		else if (pFile->GetUpPriority() == PR_NORMAL)
			uCurPrioMenuItem = MP_PRIONORMAL;
		else if (pFile->GetUpPriority() == PR_HIGH)
			uCurPrioMenuItem = MP_PRIOHIGH;
		else if (pFile->GetUpPriority() == PR_VERYHIGH)
			uCurPrioMenuItem = MP_PRIOVERYHIGH;
		else
			ASSERT(0);

		if (bFirstItem)
			uPrioMenuItem = uCurPrioMenuItem;
		else if (uPrioMenuItem != uCurPrioMenuItem)
			uPrioMenuItem = 0;

		// X-Ray :: DLULPrioExtension :: Start
		UINT uCurPrioDownMenuItem = 0;
		if(pFile->IsPartFile()){
			if (((CPartFile*)pFile)->IsAutoDownPriority())
				uCurPrioDownMenuItem = MP_PRIODOWNAUTO;
			else if (((CPartFile*)pFile)->GetDownPriority() == PR_HIGH)
				uCurPrioDownMenuItem = MP_PRIODOWNHIGH;
			else if (((CPartFile*)pFile)->GetDownPriority() == PR_NORMAL)
				uCurPrioDownMenuItem = MP_PRIODOWNNORMAL;
			else if (((CPartFile*)pFile)->GetDownPriority() == PR_LOW)
				uCurPrioDownMenuItem = MP_PRIODOWNLOW;
			else
				ASSERT(0);

			if (bFirstItem)
				uPrioDownMenuItem = uCurPrioDownMenuItem;
			else if (uPrioDownMenuItem != uCurPrioDownMenuItem)
				uPrioDownMenuItem = 0;
		}
		// X-Ray :: DLULPrioExtension :: End

		bFirstItem = false;

		// X-Ray :: SlotRelease :: Start
		if (pFile->IsReleaseFile())
			bReleaseFileSelected = true;
		else
			bNonReleaseFileSelected = true;
		// X-Ray :: SlotRelease :: End
	}

	m_SharedFilesMenu.EnableMenuItem((UINT_PTR)m_PrioMenu.m_hMenu, iSelectedItems > 0 ? MF_ENABLED : MF_GRAYED);
	m_PrioMenu.CheckMenuRadioItem(MP_PRIOVERYLOW, MP_PRIOAUTO, uPrioMenuItem, 0);

	// X-Ray :: SlotRelease :: Start
	m_PrioMenu.EnableMenuItem(MP_RELEASESET, bNonReleaseFileSelected ? MF_ENABLED : MF_GRAYED);
	m_PrioMenu.EnableMenuItem(MP_RELEASEREMOVE, bReleaseFileSelected ? MF_ENABLED : MF_GRAYED);
	// X-Ray :: SlotRelease :: End

	// X-Ray :: DLULPrioExtension :: Start
	m_SharedFilesMenu.EnableMenuItem((UINT_PTR)m_PrioDownMenu.m_hMenu, iCheckedPartFile > 0 && iSelectedItems > 0 ? MF_ENABLED : MF_GRAYED);
	m_PrioDownMenu.CheckMenuRadioItem(MP_PRIODOWNLOW, MP_PRIODOWNAUTO, uPrioDownMenuItem, 0);
	// X-Ray :: DLULPrioExtension :: End

	bool bSingleCompleteFileSelected = (iSelectedItems == 1 && iCompleteFileSelected == 1);
	m_SharedFilesMenu.EnableMenuItem(MP_OPEN, bSingleCompleteFileSelected ? MF_ENABLED : MF_GRAYED);
	UINT uInsertedMenuItem = 0;

	// X-Ray :: Toolbar :: Cleanup :: Start
	/*
	static const TCHAR _szSkinPkgSuffix1[] = _T(".") EMULSKIN_BASEEXT _T(".zip");
	static const TCHAR _szSkinPkgSuffix2[] = _T(".") EMULSKIN_BASEEXT _T(".rar");
	if (bSingleCompleteFileSelected 
		&& pSingleSelFile 
		&& (   pSingleSelFile->GetFilePath().Right(ARRSIZE(_szSkinPkgSuffix1)-1).CompareNoCase(_szSkinPkgSuffix1) == 0
		    || pSingleSelFile->GetFilePath().Right(ARRSIZE(_szSkinPkgSuffix2)-1).CompareNoCase(_szSkinPkgSuffix2) == 0))
	{
		MENUITEMINFO mii = {0};
		mii.cbSize = sizeof mii;
		mii.fMask = MIIM_TYPE | MIIM_STATE | MIIM_ID;
		mii.fType = MFT_STRING;
		mii.fState = MFS_ENABLED;
		mii.wID = MP_INSTALL_SKIN;
		CString strBuff(GetResString(IDS_INSTALL_SKIN));
		mii.dwTypeData = const_cast<LPTSTR>((LPCTSTR)strBuff);
		if (::InsertMenuItem(m_SharedFilesMenu, MP_OPENFOLDER, FALSE, &mii))
			uInsertedMenuItem = mii.wID;
	}
	*/
	// X-Ray :: Toolbar :: Cleanup :: End

	m_SharedFilesMenu.EnableMenuItem(MP_OPENFOLDER, bSingleCompleteFileSelected ? MF_ENABLED : MF_GRAYED);
	m_SharedFilesMenu.EnableMenuItem(MP_RENAME, bSingleCompleteFileSelected ? MF_ENABLED : MF_GRAYED);
	m_SharedFilesMenu.EnableMenuItem(MP_REMOVE, iCompleteFileSelected > 0 ? MF_ENABLED : MF_GRAYED);
	m_SharedFilesMenu.SetDefaultItem(bSingleCompleteFileSelected ? MP_OPEN : -1);
	m_SharedFilesMenu.EnableMenuItem(MP_CMT, iSelectedItems > 0 ? MF_ENABLED : MF_GRAYED);
	m_SharedFilesMenu.EnableMenuItem(MP_DETAIL, iSelectedItems > 0 ? MF_ENABLED : MF_GRAYED);
	m_SharedFilesMenu.EnableMenuItem(thePrefs.GetShowCopyEd2kLinkCmd() ? MP_GETED2KLINK : MP_SHOWED2KLINK, iSelectedItems > 0 ? MF_ENABLED : MF_GRAYED);
	m_SharedFilesMenu.EnableMenuItem(MP_FIND, GetItemCount() > 0 ? MF_ENABLED : MF_GRAYED);

	m_CollectionsMenu.EnableMenuItem(MP_MODIFYCOLLECTION, ( pSingleSelFile != NULL && pSingleSelFile->m_pCollection != NULL ) ? MF_ENABLED : MF_GRAYED);
	m_CollectionsMenu.EnableMenuItem(MP_VIEWCOLLECTION, ( pSingleSelFile != NULL && pSingleSelFile->m_pCollection != NULL ) ? MF_ENABLED : MF_GRAYED);
	m_CollectionsMenu.EnableMenuItem(MP_SEARCHAUTHOR, ( pSingleSelFile != NULL && pSingleSelFile->m_pCollection != NULL && !pSingleSelFile->m_pCollection->GetAuthorKeyHashString().IsEmpty()) ? MF_ENABLED : MF_GRAYED);
#if defined(_DEBUG)
	if (thePrefs.IsExtControlsEnabled()){
	//JOHNTODO: Not for release as we need kad lowID users in the network to see how well this work work. Also, we do not support these links yet.
		if (iSelectedItems > 0 && theApp.IsConnected() && theApp.IsFirewalled() && theApp.clientlist->GetBuddy())
			m_SharedFilesMenu.EnableMenuItem(MP_GETKADSOURCELINK, MF_ENABLED);
		else
			m_SharedFilesMenu.EnableMenuItem(MP_GETKADSOURCELINK, MF_GRAYED);
	}
#endif
	m_SharedFilesMenu.EnableMenuItem(Irc_SetSendLink, iSelectedItems == 1 && theApp.emuledlg->ircwnd->IsConnected() ? MF_ENABLED : MF_GRAYED);
	m_SharedFilesMenu.EnableMenuItem(MP_FILEFEEDBACK, iSelectedItems > 0 ? MF_ENABLED : MF_GRAYED); // X-Ray :: Filefeedback

	CTitleMenu WebMenu;
	WebMenu.CreateMenu();
	WebMenu.AddMenuTitle(NULL, true);
	int iWebMenuEntries = theWebServices.GetFileMenuEntries(&WebMenu);
	UINT flag2 = (iWebMenuEntries == 0 || iSelectedItems != 1) ? MF_GRAYED : MF_STRING;
	m_SharedFilesMenu.AppendMenu(flag2 | MF_POPUP, (UINT_PTR)WebMenu.m_hMenu, GetResString(IDS_WEBSERVICES), _T("WEB"));

	GetPopupMenuPos(*this, point);
	m_SharedFilesMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON,point.x,point.y,this);

	m_SharedFilesMenu.RemoveMenu(m_SharedFilesMenu.GetMenuItemCount()-1,MF_BYPOSITION);
	VERIFY( WebMenu.DestroyMenu() );
	if (uInsertedMenuItem)
		VERIFY( m_SharedFilesMenu.RemoveMenu(uInsertedMenuItem, MF_BYCOMMAND) );
}

BOOL CSharedFilesCtrl::OnCommand(WPARAM wParam, LPARAM /*lParam*/)
{
	wParam = LOWORD(wParam);

	// X-Ray :: SharedParts :: Start
	CSharedItem* pSingleSelItem  = NULL;

	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	if (iSel == -1)
		iSel = GetNextItem(-1, LVIS_SELECTED);
	if (iSel != -1)
		pSingleSelItem  = (CSharedItem*)GetItemData(iSel);

	if (pSingleSelItem && !pSingleSelItem->isFile){
		CTypedPtrList<CPtrList, CSharedItem*> selectedList;
		POSITION pos = GetFirstSelectedItemPosition();
		while (pos != NULL){
			int index = GetNextSelectedItem(pos);
			if (index >= 0){
				CSharedItem* pItem = (CSharedItem*)GetItemData(index);
				if(pItem->isFile) 
					continue;
				if(pItem->KnownFile != pSingleSelItem->KnownFile)
					continue;
				selectedList.AddTail(pItem);
			}
		}
		const CSharedItem* pPart;
		switch (wParam){
			// X-Ray :: PartImportExport :: Start
			case MP_EXPORT:
			{
				CList<uint16>* ExportList = new CList<uint16>;
				while (!selectedList.IsEmpty()){
					pPart = selectedList.GetHead();
					selectedList.RemoveHead();
					ExportList->AddTail(pPart->Part);
				}

				pSingleSelItem->KnownFile->ExportParts(ExportList);
			}
			break;
			// X-Ray :: PartImportExport ;; Ebd
		}
		return TRUE;
	}
	// X-Ray :: SharedParts :: End

	CTypedPtrList<CPtrList, CKnownFile*> selectedList;
	POSITION pos = GetFirstSelectedItemPosition();
	while (pos != NULL){
		int index = GetNextSelectedItem(pos);

		// X-Ray :: SharedParts :: Start
		/*
		if (index >= 0)
			selectedList.AddTail((CKnownFile*)GetItemData(index));
		*/
		if (index >= 0){
			CSharedItem* pItem = (CSharedItem*)GetItemData(index);
			if(!pItem->isFile) 
				continue;
			selectedList.AddTail(pItem->KnownFile);
		}
		// X-Ray :: SharedParts :: End
	}

	if (   wParam == MP_CREATECOLLECTION
		|| wParam == MP_FIND
		|| selectedList.GetCount() > 0)
	{
		CKnownFile* file = NULL;
		if (selectedList.GetCount() == 1)
			file = selectedList.GetHead();

		switch (wParam){
			case Irc_SetSendLink:
				if (file)
					theApp.emuledlg->ircwnd->SetSendFileString(CreateED2kLink(file));
				break;
			case MP_GETED2KLINK:{
				CString str;
				POSITION pos = selectedList.GetHeadPosition();
				while (pos != NULL)
				{
					file = selectedList.GetNext(pos);
					if (!str.IsEmpty())
						str += _T("\r\n");
					str += CreateED2kLink(file);
				}
				theApp.CopyTextToClipboard(str);
				break;
			}
#if defined(_DEBUG)
			//JOHNTODO: Not for release as we need kad lowID users in the network to see how well this work work. Also, we do not support these links yet.
			case MP_GETKADSOURCELINK:{
				CString str;
				POSITION pos = selectedList.GetHeadPosition();
				while (pos != NULL)
				{
					file = selectedList.GetNext(pos);
					if (!str.IsEmpty())
						str += _T("\r\n");
					str += theApp.CreateKadSourceLink(file);
				}
				theApp.CopyTextToClipboard(str);
				break;
			}
#endif
			// file operations
			case MP_OPEN:
			case IDA_ENTER:
				if (file && !file->IsPartFile())
					OpenFile(file);
				break; 
			// X-Ray :: Toolbar :: Cleanup :: Start
			/*
			case MP_INSTALL_SKIN:
				if (file && !file->IsPartFile())
					InstallSkin(file->GetFilePath());
				break;
			*/
			// X-Ray :: Toolbar :: Cleanup :: End
			case MP_OPENFOLDER:
				if (file && !file->IsPartFile())
					ShellExecute(NULL, _T("open"), file->GetPath(), NULL, NULL, SW_SHOW);
				break; 
			case MP_RENAME:
			case MPG_F2:
				if (file && !file->IsPartFile()){
					InputBox inputbox;
					CString title = GetResString(IDS_RENAME);
					title.Remove(_T('&'));
					inputbox.SetLabels(title, GetResString(IDS_DL_FILENAME), file->GetFileName());
					inputbox.SetEditFilenameMode();
					inputbox.DoModal();
					CString newname = inputbox.GetInput();
					if (!inputbox.WasCancelled() && newname.GetLength()>0)
					{
						// at least prevent users from specifying something like "..\dir\file"
						static const TCHAR _szInvFileNameChars[] = _T("\\/:*?\"<>|");
						if (newname.FindOneOf(_szInvFileNameChars) != -1){
							AfxMessageBox(GetErrorMessage(ERROR_BAD_PATHNAME));
							break;
						}

						CString newpath;
						PathCombine(newpath.GetBuffer(MAX_PATH), file->GetPath(), newname);
						newpath.ReleaseBuffer();
						if (_trename(file->GetFilePath(), newpath) != 0){
							CString strError;
							strError.Format(GetResString(IDS_ERR_RENAMESF), file->GetFilePath(), newpath, _tcserror(errno));
							AfxMessageBox(strError);
							break;
						}
						
						if (file->IsKindOf(RUNTIME_CLASS(CPartFile)))
						{
							file->SetFileName(newname);
							STATIC_DOWNCAST(CPartFile, file)->SetFullName(newpath); 
						}
						else
						{
							theApp.sharedfiles->RemoveKeywords(file);
							file->SetFileName(newname);
							theApp.sharedfiles->AddKeywords(file);
						}
						file->SetFilePath(newpath);
						UpdateFile(file);
					}
				}
				else
					MessageBeep(MB_OK);
				break;
			case MP_REMOVE:
			case MPG_DELETE:
			{
				if (IDNO == AfxMessageBox(GetResString(IDS_CONFIRM_FILEDELETE),MB_ICONWARNING | MB_ICONQUESTION | MB_DEFBUTTON2 | MB_YESNO))
					return TRUE;

				SetRedraw(FALSE);
				bool bRemovedItems = false;
				while (!selectedList.IsEmpty())
				{
					CKnownFile* myfile = selectedList.RemoveHead();
					if (!myfile || myfile->IsPartFile())
						continue;
					
					BOOL delsucc = FALSE;
					if (!PathFileExists(myfile->GetFilePath()))
						delsucc = TRUE;
					else{
						// Delete
						if (!thePrefs.GetRemoveToBin()){
							delsucc = DeleteFile(myfile->GetFilePath());
						}
						else{
							// delete to recycle bin :(
							TCHAR todel[MAX_PATH+1];
							memset(todel, 0, sizeof todel);
							_tcsncpy(todel, myfile->GetFilePath(), ARRSIZE(todel)-2);

							SHFILEOPSTRUCT fp = {0};
							fp.wFunc = FO_DELETE;
							fp.hwnd = theApp.emuledlg->m_hWnd;
							fp.pFrom = todel;
							fp.fFlags = FOF_ALLOWUNDO | FOF_NOCONFIRMATION | FOF_SILENT;// | FOF_NOERRORUI
							delsucc = (SHFileOperation(&fp) == 0);
						}
					}
					if (delsucc){
						theApp.sharedfiles->RemoveFile(myfile);
						bRemovedItems = true;
						if (myfile->IsKindOf(RUNTIME_CLASS(CPartFile)))
							theApp.emuledlg->transferwnd->downloadlistctrl.ClearCompleted(static_cast<CPartFile*>(myfile));
					}
					else{
						CString strError;
						strError.Format( GetResString(IDS_ERR_DELFILE) + _T("\r\n\r\n%s"), myfile->GetFilePath(), GetErrorMessage(GetLastError()));
						AfxMessageBox(strError);
					}
				}
				SetRedraw(TRUE);
				if (bRemovedItems) {
					AutoSelectItem();
					// Depending on <no-idea> this does not always cause a
					// LVN_ITEMACTIVATE message sent. So, explicitly redraw
					// the item.
					theApp.emuledlg->sharedfileswnd->ShowSelectedFilesSummary();
				}
				break; 
			}
			case MP_CMT:
				ShowFileDialog(selectedList, IDD_COMMENT);
                break; 
			case MPG_ALTENTER:
			case MP_DETAIL:
				ShowFileDialog(selectedList);
				break;
			case MP_FIND:
				OnFindStart();
				break;
			case MP_CREATECOLLECTION:
			{
				CCollection* pCollection = new CCollection();
				POSITION pos = selectedList.GetHeadPosition();
				while (pos != NULL)
				{
					pCollection->AddFileToCollection(selectedList.GetNext(pos),true);
				}
				// X-Ray :: ModelessDialogs :: Start
				/*
				CCollectionCreateDialog dialog;
				dialog.SetCollection(pCollection,true);
				dialog.DoModal();
				//We delete this collection object because when the newly created
				//collection file is added to the sharedfile list, it is read and verified
				//and which creates the colleciton object that is attached to that file..
				delete pCollection;
				*/
				CCollectionCreateDialog* dialog = new CCollectionCreateDialog(); 
				dialog->SetCollection(pCollection,true);
				dialog->OpenDialog();
				// X-Ray :: ModelessDialogs :: End
				break;
			}
			case MP_SEARCHAUTHOR:
				if (selectedList.GetCount() == 1 && file->m_pCollection)
				{
					SSearchParams* pParams = new SSearchParams;
					pParams->strExpression = file->m_pCollection->GetCollectionAuthorKeyString();
					pParams->eType = SearchTypeKademlia;
					pParams->strFileType = ED2KFTSTR_EMULECOLLECTION;
					pParams->strSpecialTitle = file->m_pCollection->m_sCollectionAuthorName;
					if (pParams->strSpecialTitle.GetLength() > 50){
						pParams->strSpecialTitle = pParams->strSpecialTitle.Left(50) + _T("...");
					}
					theApp.emuledlg->searchwnd->m_pwndResults->StartSearch(pParams);
				}
				break;
			case MP_VIEWCOLLECTION:
				if (selectedList.GetCount() == 1 && file->m_pCollection)
				{
					// X-Ray :: ModelessDialogs :: Start
					/*
					CCollectionViewDialog dialog;
					dialog.SetCollection(file->m_pCollection);
					dialog.DoModal();
					*/
					CCollectionViewDialog* dialog = new CCollectionViewDialog(); 
					dialog->SetCollection(file->m_pCollection);
					dialog->OpenDialog();
					// X-Ray :: ModelessDialogs :: End
				}
				break;
			case MP_MODIFYCOLLECTION:
				if (selectedList.GetCount() == 1 && file->m_pCollection)
				{
					// X-Ray :: ModelessDialogs :: Start
					/*
					CCollectionCreateDialog dialog;
					CCollection* pCollection = new CCollection(file->m_pCollection);
					dialog.SetCollection(pCollection,false);
					dialog.DoModal();
					delete pCollection;
					*/
					CCollectionCreateDialog* dialog = new CCollectionCreateDialog(); 
					CCollection* pCollection = new CCollection(file->m_pCollection);
					dialog->SetCollection(pCollection,false);
					dialog->OpenDialog();
					// X-Ray :: ModelessDialogs :: End
				}
				break;
			case MP_SHOWED2KLINK:
				ShowFileDialog(selectedList, IDD_ED2KLINK);
				break;
			case MP_PRIOVERYLOW:
			case MP_PRIOLOW:
			case MP_PRIONORMAL:
			case MP_PRIOHIGH:
			case MP_PRIOVERYHIGH:
			case MP_PRIOAUTO:
				{
					POSITION pos = selectedList.GetHeadPosition();
					while (pos != NULL)
					{
						CKnownFile* file = selectedList.GetNext(pos);
						switch (wParam) {
							case MP_PRIOVERYLOW:
								file->SetAutoUpPriority(false);
								file->SetUpPriority(PR_VERYLOW);
								UpdateFile(file);
								break;
							case MP_PRIOLOW:
								file->SetAutoUpPriority(false);
								file->SetUpPriority(PR_LOW);
								UpdateFile(file);
								break;
							case MP_PRIONORMAL:
								file->SetAutoUpPriority(false);
								file->SetUpPriority(PR_NORMAL);
								UpdateFile(file);
								break;
							case MP_PRIOHIGH:
								file->SetAutoUpPriority(false);
								file->SetUpPriority(PR_HIGH);
								UpdateFile(file);
								break;
							case MP_PRIOVERYHIGH:
								file->SetAutoUpPriority(false);
								file->SetUpPriority(PR_VERYHIGH);
								UpdateFile(file);
								break;	
							case MP_PRIOAUTO:
								file->SetAutoUpPriority(true);
								file->UpdateAutoUpPriority();
								UpdateFile(file); 
								break;
						}
					}
					break;
				}

			// X-Ray :: SlotRelease :: Start
			case MP_RELEASESET:
				{
					POSITION pos = selectedList.GetHeadPosition();
					while (pos != NULL)
					{
						CKnownFile* file = selectedList.GetNext(pos);
						file->SetReleaseFile(true);
						UpdateFile(file);
					}
					break;
				}
			case MP_RELEASEREMOVE:
				{
					POSITION pos = selectedList.GetHeadPosition();
					while (pos != NULL)
					{
						CKnownFile* file = selectedList.GetNext(pos);
						file->SetReleaseFile(false);
						UpdateFile(file);
					}
					break;
				}
			// X-Ray :: SlotRelease :: End

			// X-Ray :: DLULPrioExtension :: Start
			case MP_PRIODOWNHIGH:
				SetRedraw(false);
				while (!selectedList.IsEmpty()){
					CKnownFile* file = selectedList.GetHead();
					if(file->IsPartFile()){
						((CPartFile*)file)->SetAutoDownPriority(false);
						((CPartFile*)file)->SetDownPriority(PR_HIGH);
					}
					selectedList.RemoveHead();
				}
				SetRedraw(true);
				break;
			case MP_PRIODOWNLOW:
				SetRedraw(false);
				while (!selectedList.IsEmpty()){
					CKnownFile* file = selectedList.GetHead();
					if(file->IsPartFile()){
						((CPartFile*)file)->SetAutoDownPriority(false);
						((CPartFile*)file)->SetDownPriority(PR_LOW);
					}
					selectedList.RemoveHead();
				}
				SetRedraw(true);
				break;
			case MP_PRIODOWNNORMAL:
				SetRedraw(false);
				while (!selectedList.IsEmpty()){
					CKnownFile* file = selectedList.GetHead();
					if(file->IsPartFile()){
						((CPartFile*)file)->SetAutoDownPriority(false);
						((CPartFile*)file)->SetDownPriority(PR_NORMAL);
					}
					selectedList.RemoveHead();
				}
				SetRedraw(true);
				break;
			case MP_PRIODOWNAUTO:
				SetRedraw(false);
				while (!selectedList.IsEmpty()){
					CKnownFile* file = selectedList.GetHead();
					if(file->IsPartFile()){
						((CPartFile*)file)->SetAutoDownPriority(true);
						((CPartFile*)file)->SetDownPriority(PR_HIGH);
					}
					selectedList.RemoveHead();
				}
				SetRedraw(true);
				break;
			// X-Ray :: DLULPrioExtension :: End

			// X-Ray :: Filefeedback :: Start
			case MP_FILEFEEDBACK:
				{
					CString strFeed = L"";
					POSITION pos = selectedList.GetHeadPosition();
					while (pos != NULL){
						CKnownFile* file = selectedList.GetNext(pos);
						strFeed.Append(file->GetFileFeedback());
						strFeed.Append(_T("\r\n"));
					}
					theApp.CopyTextToClipboard(strFeed);
					break;
				}
			// X-Ray :: Filefeedback :: End

			default:
				if (wParam>=MP_WEBURL && wParam<=MP_WEBURL+256){
					theWebServices.RunURL(file, wParam);
				}
				break;
		}
	}
	return TRUE;
}

void CSharedFilesCtrl::OnColumnClick( NMHDR* pNMHDR, LRESULT* pResult)
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	// Barry - Store sort order in preferences
	// Determine ascending based on whether already sorted on this column

	bool sortAscending = (GetSortItem() != pNMListView->iSubItem) ? true : !GetSortAscending();

	// Ornis 4-way-sorting
	int adder=0;
	if (pNMListView->iSubItem>=5 && pNMListView->iSubItem<=7)
	{
		ASSERT( pNMListView->iSubItem - 5 < ARRSIZE(sortstat) );
		if (!sortAscending)
			sortstat[pNMListView->iSubItem - 5] = !sortstat[pNMListView->iSubItem - 5];
		adder = sortstat[pNMListView->iSubItem-5] ? 0 : 100;
	}
	else if (pNMListView->iSubItem==11)
	{
		ASSERT( 3 < ARRSIZE(sortstat) );
		if (!sortAscending)
			sortstat[3] = !sortstat[3];
		adder = sortstat[3] ? 0 : 100;
	}

	// Sort table
	if (adder==0)	
		SetSortArrow(pNMListView->iSubItem, sortAscending); 
	else
		SetSortArrow(pNMListView->iSubItem, sortAscending ? arrowDoubleUp : arrowDoubleDown);

	UpdateSortHistory(pNMListView->iSubItem + adder + (sortAscending ? 0:20),20);
	SortItems(SortProc, pNMListView->iSubItem + adder + (sortAscending ? 0:20));

	*pResult = 0;
}

int CSharedFilesCtrl::SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	// X-Ray :: SharedParts :: Start
	/*
	const CKnownFile* item1 = (CKnownFile*)lParam1;
	const CKnownFile* item2 = (CKnownFile*)lParam2;
	
	int iResult=0;
	switch(lParamSort){
		case 0: //filename asc
			iResult=CompareLocaleStringNoCase(item1->GetFileName(),item2->GetFileName());
			break;
		case 20: //filename desc
			iResult=CompareLocaleStringNoCase(item2->GetFileName(),item1->GetFileName());
			break;

		case 1: //filesize asc
			iResult=item1->GetFileSize()==item2->GetFileSize()?0:(item1->GetFileSize()>item2->GetFileSize()?1:-1);
			break;

		case 21: //filesize desc
			iResult=item1->GetFileSize()==item2->GetFileSize()?0:(item2->GetFileSize()>item1->GetFileSize()?1:-1);
			break;

		case 2: //filetype asc
			iResult=item1->GetFileTypeDisplayStr().Compare(item2->GetFileTypeDisplayStr());
			break;
		case 22: //filetype desc
			iResult=item2->GetFileTypeDisplayStr().Compare(item1->GetFileTypeDisplayStr());
			break;

		case 3: //prio asc
		{
			uint8 p1=item1->GetUpPriority() +1;
			if(p1==5)
				p1=0;
			uint8 p2=item2->GetUpPriority() +1;
			if(p2==5)
				p2=0;

			// X-Ray :: SlotRelease :: Start
			if (item1->IsReleaseFile())
				p1+=10;
			if (item2->IsReleaseFile())
				p2+=10;
			// X-Ray :: SlotRelease :: End

			iResult=p1-p2;
			break;
		}
		case 23: //prio desc
		{
			uint8 p1=item1->GetUpPriority() +1;
			if(p1==5)
				p1=0;
			uint8 p2=item2->GetUpPriority() +1;
			if(p2==5)
				p2=0;

			// X-Ray :: SlotRelease :: Start
			if (item1->IsReleaseFile())
				p1+=10;
			if (item2->IsReleaseFile())
				p2+=10;
			// X-Ray :: SlotRelease :: End

			iResult=p2-p1;
			break;
		}

		case 4: //fileID asc
			iResult=memcmp(item1->GetFileHash(), item2->GetFileHash(), 16);
			break;
		case 24: //fileID desc
			iResult=memcmp(item2->GetFileHash(), item1->GetFileHash(), 16);
			break;

		case 5: //requests asc
			iResult=item1->statistic.GetRequests() - item2->statistic.GetRequests();
			break;
		case 25: //requests desc
			iResult=item2->statistic.GetRequests() - item1->statistic.GetRequests();
			break;
		
		case 6: //acc requests asc
			iResult=item1->statistic.GetAccepts() - item2->statistic.GetAccepts();
			break;
		case 26: //acc requests desc
			iResult=item2->statistic.GetAccepts() - item1->statistic.GetAccepts();
			break;
		
		case 7: //all transferred asc
			iResult=item1->statistic.GetTransferred()==item2->statistic.GetTransferred()?0:(item1->statistic.GetTransferred()>item2->statistic.GetTransferred()?1:-1);
			break;
		case 27: //all transferred desc
			iResult=item1->statistic.GetTransferred()==item2->statistic.GetTransferred()?0:(item2->statistic.GetTransferred()>item1->statistic.GetTransferred()?1:-1);
			break;

		case 9: //folder asc
			iResult=CompareLocaleStringNoCase(item1->GetPath(),item2->GetPath());
			break;
		case 29: //folder desc
			iResult=CompareLocaleStringNoCase(item2->GetPath(),item1->GetPath());
			break;

		case 10: //complete sources asc
			iResult=CompareUnsigned(item1->m_nCompleteSourcesCount, item2->m_nCompleteSourcesCount);
			break;
		case 30: //complete sources desc
			iResult=CompareUnsigned(item2->m_nCompleteSourcesCount, item1->m_nCompleteSourcesCount);
			break;

		case 11: //ed2k shared asc
			iResult=item1->GetPublishedED2K() - item2->GetPublishedED2K();
			break;
		case 31: //ed2k shared desc
			iResult=item2->GetPublishedED2K() - item1->GetPublishedED2K();
			break;

		case 105: //all requests asc
			iResult=CompareUnsigned(item1->statistic.GetAllTimeRequests(), item2->statistic.GetAllTimeRequests());
			break;
		case 125: //all requests desc
			iResult=CompareUnsigned(item2->statistic.GetAllTimeRequests(), item1->statistic.GetAllTimeRequests());
			break;

		case 106: //all acc requests asc
			iResult=CompareUnsigned(item1->statistic.GetAllTimeAccepts(), item2->statistic.GetAllTimeAccepts());
			break;
		case 126: //all acc requests desc
			iResult=CompareUnsigned(item2->statistic.GetAllTimeAccepts(), item1->statistic.GetAllTimeAccepts());
			break;

		case 107: //all transferred asc
			iResult=item1->statistic.GetAllTimeTransferred()==item2->statistic.GetAllTimeTransferred()?0:(item1->statistic.GetAllTimeTransferred()>item2->statistic.GetAllTimeTransferred()?1:-1);
			break;
		case 127: //all transferred desc
			iResult=item1->statistic.GetAllTimeTransferred()==item2->statistic.GetAllTimeTransferred()?0:(item2->statistic.GetAllTimeTransferred()>item1->statistic.GetAllTimeTransferred()?1:-1);
			break;

		case 111:{ //kad shared asc
			uint32 tNow = time(NULL);
			int i1 = (tNow < item1->GetLastPublishTimeKadSrc()) ? 1 : 0;
			int i2 = (tNow < item2->GetLastPublishTimeKadSrc()) ? 1 : 0;
			iResult=i1 - i2;
			break;
		}
		case 131:{ //kad shared desc
			uint32 tNow = time(NULL);
			int i1 = (tNow < item1->GetLastPublishTimeKadSrc()) ? 1 : 0;
			int i2 = (tNow < item2->GetLastPublishTimeKadSrc()) ? 1 : 0;
			iResult=i2 - i1;
			break;
		}
		default: 
			iResult=0;
			break;
	}
	*/
	const CSharedItem* item1 = (CSharedItem*)lParam1;
	const CSharedItem* item2 = (CSharedItem*)lParam2;

	int iResult = 0;

	if(item1->isFile != false && item2->isFile != false)
		iResult = Compare(item1->KnownFile, item2->KnownFile, lParamSort);
	else if(item1->isFile == false && item2->isFile == false){
		if(item1->KnownFile == item2->KnownFile) 
			iResult = Compare(item1,item2,lParamSort);
		else // different files
			iResult = 0;
	} else // compare file and part
		return 0;
	// X-Ray :: SharedParts :: End

	int dwNextSort;
	//call secondary sortorder, if this one results in equal
	//(Note: yes I know this call is evil OO wise, but better than changing a lot more code, while we have only one instance anyway - might be fixed later)
	if (iResult == 0 && (dwNextSort = theApp.emuledlg->sharedfileswnd->sharedfilesctrl.GetNextSortOrder(lParamSort)) != (-1)){
		iResult= SortProc(lParam1, lParam2, dwNextSort);
	}

	return iResult;

}

// X-Ray :: SharedParts :: Start
int CSharedFilesCtrl::Compare(const CKnownFile* item1, const CKnownFile* item2, LPARAM lParamSort)
{
	int iResult=0;
	switch(lParamSort){
		case 0: //filename asc
			iResult=CompareLocaleStringNoCase(item1->GetFileName(),item2->GetFileName());
			break;
		case 20: //filename desc
			iResult=CompareLocaleStringNoCase(item2->GetFileName(),item1->GetFileName());
			break;

		case 1: //filesize asc
			iResult=item1->GetFileSize()==item2->GetFileSize()?0:(item1->GetFileSize()>item2->GetFileSize()?1:-1);
			break;

		case 21: //filesize desc
			iResult=item1->GetFileSize()==item2->GetFileSize()?0:(item2->GetFileSize()>item1->GetFileSize()?1:-1);
			break;

		case 2: //filetype asc
			iResult=item1->GetFileTypeDisplayStr().Compare(item2->GetFileTypeDisplayStr());
			break;
		case 22: //filetype desc
			iResult=item2->GetFileTypeDisplayStr().Compare(item1->GetFileTypeDisplayStr());
			break;

		case 3: //prio asc
		{
			uint8 p1=item1->GetUpPriority() +1;
			if(p1==5)
				p1=0;
			uint8 p2=item2->GetUpPriority() +1;
			if(p2==5)
				p2=0;

			// X-Ray :: SlotRelease :: Start
			if (item1->IsReleaseFile())
				p1+=10;
			if (item2->IsReleaseFile())
				p2+=10;
			// X-Ray :: SlotRelease :: End

			iResult=p1-p2;
			break;
		}
		case 23: //prio desc
		{
			uint8 p1=item1->GetUpPriority() +1;
			if(p1==5)
				p1=0;
			uint8 p2=item2->GetUpPriority() +1;
			if(p2==5)
				p2=0;

			// X-Ray :: SlotRelease :: Start
			if (item1->IsReleaseFile())
				p1+=10;
			if (item2->IsReleaseFile())
				p2+=10;
			// X-Ray :: SlotRelease :: End

			iResult=p2-p1;
			break;
		}

		case 4: //fileID asc
			iResult=memcmp(item1->GetFileHash(), item2->GetFileHash(), 16);
			break;
		case 24: //fileID desc
			iResult=memcmp(item2->GetFileHash(), item1->GetFileHash(), 16);
			break;

		case 5: //requests asc
			iResult=item1->statistic.GetRequests() - item2->statistic.GetRequests();
			break;
		case 25: //requests desc
			iResult=item2->statistic.GetRequests() - item1->statistic.GetRequests();
			break;
		
		case 6: //acc requests asc
			iResult=item1->statistic.GetAccepts() - item2->statistic.GetAccepts();
			break;
		case 26: //acc requests desc
			iResult=item2->statistic.GetAccepts() - item1->statistic.GetAccepts();
			break;
		
		case 7: //all transferred asc
			iResult=item1->statistic.GetTransferred()==item2->statistic.GetTransferred()?0:(item1->statistic.GetTransferred()>item2->statistic.GetTransferred()?1:-1);
			break;
		case 27: //all transferred desc
			iResult=item1->statistic.GetTransferred()==item2->statistic.GetTransferred()?0:(item2->statistic.GetTransferred()>item1->statistic.GetTransferred()?1:-1);
			break;

		case 9: //folder asc
			iResult=CompareLocaleStringNoCase(item1->GetPath(),item2->GetPath());
			break;
		case 29: //folder desc
			iResult=CompareLocaleStringNoCase(item2->GetPath(),item1->GetPath());
			break;

		case 10: //complete sources asc
			iResult=CompareUnsigned(item1->m_nCompleteSourcesCount, item2->m_nCompleteSourcesCount);
			break;
		case 30: //complete sources desc
			iResult=CompareUnsigned(item2->m_nCompleteSourcesCount, item1->m_nCompleteSourcesCount);
			break;

		case 11: //ed2k shared asc
			iResult=item1->GetPublishedED2K() - item2->GetPublishedED2K();
			break;
		case 31: //ed2k shared desc
			iResult=item2->GetPublishedED2K() - item1->GetPublishedED2K();
			break;

		case 105: //all requests asc
			iResult=CompareUnsigned(item1->statistic.GetAllTimeRequests(), item2->statistic.GetAllTimeRequests());
			break;
		case 125: //all requests desc
			iResult=CompareUnsigned(item2->statistic.GetAllTimeRequests(), item1->statistic.GetAllTimeRequests());
			break;

		case 106: //all acc requests asc
			iResult=CompareUnsigned(item1->statistic.GetAllTimeAccepts(), item2->statistic.GetAllTimeAccepts());
			break;
		case 126: //all acc requests desc
			iResult=CompareUnsigned(item2->statistic.GetAllTimeAccepts(), item1->statistic.GetAllTimeAccepts());
			break;

		case 107: //all transferred asc
			iResult=item1->statistic.GetAllTimeTransferred()==item2->statistic.GetAllTimeTransferred()?0:(item1->statistic.GetAllTimeTransferred()>item2->statistic.GetAllTimeTransferred()?1:-1);
			break;
		case 127: //all transferred desc
			iResult=item1->statistic.GetAllTimeTransferred()==item2->statistic.GetAllTimeTransferred()?0:(item2->statistic.GetAllTimeTransferred()>item1->statistic.GetAllTimeTransferred()?1:-1);
			break;

		case 111:{ //kad shared asc
			uint32 tNow = time(NULL);
			int i1 = (tNow < item1->GetLastPublishTimeKadSrc()) ? 1 : 0;
			int i2 = (tNow < item2->GetLastPublishTimeKadSrc()) ? 1 : 0;
			iResult=i1 - i2;
			break;
		}
		case 131:{ //kad shared desc
			uint32 tNow = time(NULL);
			int i1 = (tNow < item1->GetLastPublishTimeKadSrc()) ? 1 : 0;
			int i2 = (tNow < item2->GetLastPublishTimeKadSrc()) ? 1 : 0;
			iResult=i2 - i1;
			break;
		}

		default: 
			iResult=0;
			break;
	}

	return iResult;
}

#define sortcmp(a, b) ((a)==(b)) ? 0 : (((a)<(b))?-1:1)
int CSharedFilesCtrl::Compare(const CSharedItem* item1, const CSharedItem* item2, LPARAM lParamSort)
{
	int iResult=0;
	switch(lParamSort){
		case 0: //filename asc
			iResult = sortcmp(item1->Part, item2->Part);
			break;
		case 20: //filename desc
			iResult = sortcmp(item2->Part, item1->Part);
			break;

		case 1: //filesize asc
			iResult = (!item1->KnownFile->IsPartFile() || ((CPartFile*)item1->KnownFile)->IsComplete(PARTSIZE*item1->Part, PARTSIZE*item1->Part+PARTSIZE-1, true)) - (!item2->KnownFile->IsPartFile() || ((CPartFile*)item2->KnownFile)->IsComplete(PARTSIZE*item2->Part, PARTSIZE*item2->Part+PARTSIZE-1, true));
			break;
		case 21: //filesize desc
			iResult = (!item2->KnownFile->IsPartFile() || ((CPartFile*)item2->KnownFile)->IsComplete(PARTSIZE*item2->Part, PARTSIZE*item2->Part+PARTSIZE-1, true)) - (!item1->KnownFile->IsPartFile() || ((CPartFile*)item1->KnownFile)->IsComplete(PARTSIZE*item1->Part, PARTSIZE*item1->Part+PARTSIZE-1, true));
			break;

		case 4: //fileID asc
			iResult = memcmp(item1->KnownFile->GetPartHash(item1->Part), item2->KnownFile->GetPartHash(item2->Part), 16);
			break;
		case 24: //fileID desc
			iResult = memcmp(item2->KnownFile->GetPartHash(item2->Part), item1->KnownFile->GetPartHash(item1->Part), 16);
			break;

		default: 
			iResult=0;
			break;
	}
	return iResult;
}
// X-Ray :: SharedParts :: End

void CSharedFilesCtrl::OpenFile(const CKnownFile* file)
{
	if(file->m_pCollection)
	{
		// X-Ray :: ModelessDialogs :: Start
		/*
		CCollectionViewDialog dialog;
		dialog.SetCollection(file->m_pCollection);
		dialog.DoModal();
		*/
		CCollectionViewDialog* dialog = new CCollectionViewDialog(); 
		dialog->SetCollection(file->m_pCollection);
		dialog->OpenDialog();
		// X-Ray :: ModelessDialogs :: End
	}
	else
		ShellOpenFile(file->GetFilePath(), NULL);
}

void CSharedFilesCtrl::OnNMDblclk(NMHDR* pNMHDR, LRESULT* pResult) // X-Ray :: SharedParts
{
	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	if (iSel != -1)
	{
		// X-Ray :: SharedParts :: Start
		/*
		CKnownFile* file = (CKnownFile*)GetItemData(iSel);
		*/
		if(thePrefs.IsDoubleClickEnabled()){
			NMITEMACTIVATE *i = (NMITEMACTIVATE*)pNMHDR;
			ExpandCollapseItem(i->iItem);
		} else {
			CKnownFile* file = ((CSharedItem*)GetItemData(iSel))->KnownFile;
		// X-Ray :: SharedParts :: End
			if (file)
			{
				if (GetKeyState(VK_MENU) & 0x8000)
				{
					CTypedPtrList<CPtrList, CKnownFile*> aFiles;
					aFiles.AddHead(file);
					ShowFileDialog(aFiles);
				}
				else if (!file->IsPartFile())
					OpenFile(file);
			}
		} // X-Ray :: SharedParts
	}
	*pResult = 0;
}

void CSharedFilesCtrl::CreateMenues()
{
	if (m_PrioMenu) VERIFY( m_PrioMenu.DestroyMenu() );
	if (m_PrioDownMenu) VERIFY( m_PrioDownMenu.DestroyMenu() ); // X-Ray :: DLULPrioExtension
	if (m_CollectionsMenu) VERIFY( m_CollectionsMenu.DestroyMenu() );
	if (m_SharedFilesMenu) VERIFY( m_SharedFilesMenu.DestroyMenu() );


	m_PrioMenu.CreateMenu();
	m_PrioMenu.AddMenuTitle(GetResString(IDS_PRIORITY), true); // X-Ray :: MOD
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIOVERYLOW,GetResString(IDS_PRIOVERYLOW));
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIOLOW,GetResString(IDS_PRIOLOW));
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIONORMAL,GetResString(IDS_PRIONORMAL));
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIOHIGH, GetResString(IDS_PRIOHIGH));
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIOVERYHIGH, GetResString(IDS_PRIORELEASE));
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIOAUTO, GetResString(IDS_PRIOAUTO));//UAP

	// X-Ray :: SlotRelease :: Start
	m_PrioMenu.AppendMenu(MF_SEPARATOR);
	m_PrioMenu.AppendMenu(MF_STRING,MP_RELEASESET, GetResString(IDS_RELEASESET));
	m_PrioMenu.AppendMenu(MF_STRING,MP_RELEASEREMOVE, GetResString(IDS_RELEASEREMOVE));
	// X-Ray :: SlotRelease :: End

	// X-Ray :: DLULPrioExtension :: Start
	m_PrioDownMenu.CreateMenu();
	m_PrioDownMenu.AddMenuTitle(GetResString(IDS_PRIORITY), true);
	m_PrioDownMenu.AppendMenu(MF_STRING, MP_PRIODOWNLOW, GetResString(IDS_PRIOLOW));
	m_PrioDownMenu.AppendMenu(MF_STRING, MP_PRIODOWNNORMAL, GetResString(IDS_PRIONORMAL));
	m_PrioDownMenu.AppendMenu(MF_STRING, MP_PRIODOWNHIGH, GetResString(IDS_PRIOHIGH));
	m_PrioDownMenu.AppendMenu(MF_STRING, MP_PRIODOWNAUTO, GetResString(IDS_PRIOAUTO));
	// X-Ray :: DLULPrioExtension :: End

	m_CollectionsMenu.CreateMenu();
	m_CollectionsMenu.AddMenuTitle(GetResString(IDS_META_COLLECTION), true); // X-Ray :: MOD
	m_CollectionsMenu.AppendMenu(MF_STRING,MP_CREATECOLLECTION, GetResString(IDS_CREATECOLLECTION), _T("COLLECTION_ADD"));
	m_CollectionsMenu.AppendMenu(MF_STRING,MP_MODIFYCOLLECTION, GetResString(IDS_MODIFYCOLLECTION), _T("COLLECTION_EDIT"));
	m_CollectionsMenu.AppendMenu(MF_STRING,MP_VIEWCOLLECTION, GetResString(IDS_VIEWCOLLECTION), _T("COLLECTION_VIEW"));
	m_CollectionsMenu.AppendMenu(MF_STRING,MP_SEARCHAUTHOR, GetResString(IDS_SEARCHAUTHORCOLLECTION), _T("COLLECTION_SEARCH"));

	m_SharedFilesMenu.CreatePopupMenu();
	m_SharedFilesMenu.AddMenuTitle(GetResString(IDS_SHAREDFILES), true);

	m_SharedFilesMenu.AppendMenu(MF_STRING,MP_OPEN, GetResString(IDS_OPENFILE), _T("OPENFILE"));
	m_SharedFilesMenu.AppendMenu(MF_STRING,MP_OPENFOLDER, GetResString(IDS_OPENFOLDER), _T("OPENFOLDER"));
	m_SharedFilesMenu.AppendMenu(MF_STRING,MP_RENAME, GetResString(IDS_RENAME) + _T("..."), _T("FILERENAME"));
	m_SharedFilesMenu.AppendMenu(MF_STRING,MP_REMOVE, GetResString(IDS_DELETE), _T("DELETE"));
	if (thePrefs.IsExtControlsEnabled())
		m_SharedFilesMenu.AppendMenu(MF_STRING,Irc_SetSendLink,GetResString(IDS_IRC_ADDLINKTOIRC), _T("IRCCLIPBOARD"));

	// X-Ray :: Filefeedback :: Start
	m_SharedFilesMenu.AppendMenu(MF_SEPARATOR);
	m_SharedFilesMenu.AppendMenu(MF_STRING, MP_FILEFEEDBACK, GetResString(IDS_FEEDBACK_COPY), _T("COPY"));
	// X-Ray :: Filefeedback :: End

	m_SharedFilesMenu.AppendMenu(MF_STRING|MF_SEPARATOR);
	m_SharedFilesMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_PrioDownMenu.m_hMenu, GetResString(IDS_PRIORITY) + _T(" (") + GetResString(IDS_DOWNLOAD) + _T(")"), _T("FILEPRIORITYDOWN")); // X-Ray :: DLULPrioExtension
	m_SharedFilesMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_PrioMenu.m_hMenu, GetResString(IDS_PRIORITY) + _T(" (") + GetResString(IDS_PW_CON_UPLBL) + _T(")"), _T("FILEPRIORITYUP")); // X-Ray :: MOD
	m_SharedFilesMenu.AppendMenu(MF_STRING|MF_SEPARATOR);

	m_SharedFilesMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_CollectionsMenu.m_hMenu, GetResString(IDS_META_COLLECTION), _T("COLLECTION"));
	m_SharedFilesMenu.AppendMenu(MF_STRING|MF_SEPARATOR); 	

	m_SharedFilesMenu.AppendMenu(MF_STRING,MP_DETAIL, GetResString(IDS_SHOWDETAILS), _T("FILEINFO"));
	m_SharedFilesMenu.AppendMenu(MF_STRING,MP_CMT, GetResString(IDS_CMT_ADD), _T("FILECOMMENTS"));
	if (thePrefs.GetShowCopyEd2kLinkCmd())
		m_SharedFilesMenu.AppendMenu(MF_STRING,MP_GETED2KLINK, GetResString(IDS_DL_LINK1), _T("ED2KLINK") );
	else
		m_SharedFilesMenu.AppendMenu(MF_STRING,MP_SHOWED2KLINK, GetResString(IDS_DL_SHOWED2KLINK), _T("ED2KLINK") );
	m_SharedFilesMenu.AppendMenu(MF_STRING,MP_FIND, GetResString(IDS_FIND), _T("Search"));
	m_SharedFilesMenu.AppendMenu(MF_STRING|MF_SEPARATOR);

#if defined(_DEBUG)
	if (thePrefs.IsExtControlsEnabled()){
		//JOHNTODO: Not for release as we need kad lowID users in the network to see how well this work work. Also, we do not support these links yet.
		m_SharedFilesMenu.AppendMenu(MF_STRING,MP_GETKADSOURCELINK, _T("Copy eD2K Links To Clipboard (Kad)"));
		m_SharedFilesMenu.AppendMenu(MF_STRING|MF_SEPARATOR);
	}
#endif
}

void CSharedFilesCtrl::ShowComments(CKnownFile* file)
{
	if (file)
	{
		CTypedPtrList<CPtrList, CKnownFile*> aFiles;
		aFiles.AddHead(file);
		ShowFileDialog(aFiles, IDD_COMMENT);
	}
}

void CSharedFilesCtrl::OnGetDispInfo(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLVDISPINFO *pDispInfo = reinterpret_cast<NMLVDISPINFO*>(pNMHDR);

	if (theApp.emuledlg->IsRunning()){
		// Although we have an owner drawn listview control we store the text for the primary item in the listview, to be
		// capable of quick searching those items via the keyboard. Because our listview items may change their contents,
		// we do this via a text callback function. The listview control will send us the LVN_DISPINFO notification if
		// it needs to know the contents of the primary item.
		//
		// But, the listview control sends this notification all the time, even if we do not search for an item. At least
		// this notification is only sent for the visible items and not for all items in the list. Though, because this
		// function is invoked *very* often, no *NOT* put any time consuming code here in.

		if (pDispInfo->item.mask & LVIF_TEXT){
			// X-Ray :: SharedParts :: Start
			/*
			const CKnownFile* pFile = reinterpret_cast<CKnownFile*>(pDispInfo->item.lParam);
			*/
			const CSharedItem* pItem = reinterpret_cast<CSharedItem*>(pDispInfo->item.lParam);
			const CKnownFile* pFile = pItem->KnownFile;
			// X-Ray :: SharedParts :: End
			if (pFile != NULL){
				switch (pDispInfo->item.iSubItem){
					case 0:
						if (pDispInfo->item.cchTextMax > 0){
							_tcsncpy(pDispInfo->item.pszText, pFile->GetFileName(), pDispInfo->item.cchTextMax);
							pDispInfo->item.pszText[pDispInfo->item.cchTextMax-1] = _T('\0');
						}
						break;
					default:
						// shouldn't happen
						pDispInfo->item.pszText[0] = _T('\0');
						break;
				}
			}
		}
	}
	*pResult = 0;
}

void CSharedFilesCtrl::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	if (nChar == 'C' && (GetKeyState(VK_CONTROL) & 0x8000))
	{
		// Ctrl+C: Copy listview items to clipboard
		SendMessage(WM_COMMAND, MP_GETED2KLINK);
		return;
	}
	else if (nChar == VK_F5)
		ReloadFileList();

	CMuleListCtrl::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CSharedFilesCtrl::ShowFileDialog(CTypedPtrList<CPtrList, CKnownFile*>& aFiles, UINT uPshInvokePage)
{
	// X-Ray :: ModelessDialogs :: Start
	/*
	if (aFiles.GetSize() > 0)
	{
		CSharedFileDetailsSheet dialog(aFiles, uPshInvokePage, this);
		dialog.DoModal();
	}
	*/
	if (aFiles.GetSize() > 0)
		aFiles.GetHead()->GetDetailDialogInterface()->OpenDetailDialog(aFiles, uPshInvokePage, this);
	// X-Ray :: ModelessDialogs :: End
}

void CSharedFilesCtrl::SetDirectoryFilter(CDirectoryItem* pNewFilter, bool bRefresh){
	if (m_pDirectoryFilter == pNewFilter)
		return;
	m_pDirectoryFilter = pNewFilter;
	if (bRefresh)
		ReloadFileList();
}

void CSharedFilesCtrl::OnLvnGetInfoTip(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLVGETINFOTIP pGetInfoTip = reinterpret_cast<LPNMLVGETINFOTIP>(pNMHDR);
	if (pGetInfoTip->iSubItem == 0)
	{
		LVHITTESTINFO hti = {0};
		::GetCursorPos(&hti.pt);
		ScreenToClient(&hti.pt);
		if (SubItemHitTest(&hti) == -1 || hti.iItem != pGetInfoTip->iItem || hti.iSubItem != 0){
			// don' show the default label tip for the main item, if the mouse is not over the main item
			if ((pGetInfoTip->dwFlags & LVGIT_UNFOLDED) == 0 && pGetInfoTip->cchTextMax > 0 && pGetInfoTip->pszText[0] != _T('\0'))
				pGetInfoTip->pszText[0] = _T('\0');
			return;
		}

		// X-Ray :: SharedParts :: Start
		/*
		const CKnownFile* pFile = (CKnownFile*)GetItemData(pGetInfoTip->iItem);
		*/
		const CSharedItem* pItem = (CSharedItem*)GetItemData(pGetInfoTip->iItem);
		if(pItem->isFile == false)
			return;
		const CKnownFile* pFile = pItem->KnownFile;
		// X-Ray :: SharedParts :: End
		if (pFile && pGetInfoTip->pszText && pGetInfoTip->cchTextMax > 0)
		{
			CString strInfo = pFile->GetInfoSummary();
			_tcsncpy(pGetInfoTip->pszText, strInfo, pGetInfoTip->cchTextMax);
			pGetInfoTip->pszText[pGetInfoTip->cchTextMax-1] = _T('\0');
		}
	}
	*pResult = 0;
}

// X-Ray :: SharedParts :: Start
void CSharedFilesCtrl::ExpandCollapseItem(int Item)
{
	if (Item == -1)
		return;

	CSharedItem *ItemDataParent=(CSharedItem*)GetItemData(Item);

	if(!ItemDataParent->isFile)
		return;

	CKnownFile *File=ItemDataParent->KnownFile;

	if(ItemDataParent->isOpen == true){
		SetRedraw(false);

		ItemDataParent->isOpen=false;
		for(uint16 Part=0; Part<ItemDataParent->Parts; Part++){
			CSharedItem *ItemData=(CSharedItem*)GetItemData(Item+1);
			if (ItemData->isFile)
				break;
			SetItemData(Item+1, NULL);
			DeleteItem(Item+1);
			if(ItemData) 
				delete ItemData;
		}

		SetRedraw(true);
	} else {
		if(!(File->GetHashCount() == File->GetED2KPartCount()) || File->GetPartCount() == 1) // X-Ray :: SafeHash - use GetED2KPartCount
			return; // we don't have the hashset!

		SetRedraw(false);

		CString	Buffer;
		uint16	Parts=0;
		for(uint16 Part=0; Part<File->GetPartCount(); Part++){
			Parts++;

			CSharedItem	*ItemData = new CSharedItem;
			ItemData->isFile = false;
			ItemData->isOpen = false;
			ItemData->KnownFile = File;
			ItemData->Part = Part;
			ItemData->Parts = 0;

			Buffer.Format(_T("%i"), Part);
			InsertItem(LVIF_TEXT|LVIF_PARAM, Item+Parts, Buffer, 0, 0, 0, (LPARAM)ItemData);
		}

		SetRedraw(true);

		ItemDataParent->Parts=Parts;
		if(Parts==0){
			ItemDataParent->isOpen=false;
		}else{
			ItemDataParent->isOpen=true;
		}
	}
}

BOOL CSharedFilesCtrl::DeleteAllItems()
{
	CSharedItem *ItemData;
	for(int i=GetItemCount(); i>0; i--){
		ItemData=(CSharedItem *)GetItemData(i-1);
		SetItemData(i-1, NULL);
		if(ItemData){
			delete ItemData;
		}
	}
	return CListCtrl::DeleteAllItems();
}

CSharedFilesListCtrlItemWalk::CSharedFilesListCtrlItemWalk(CSharedFilesCtrl* pListCtrl)
: CListCtrlItemWalk(pListCtrl)
{
	m_pSharedFilesListCtrl = pListCtrl;
	m_iParts = false;
}

CObject* CSharedFilesListCtrlItemWalk::GetPrevSelectableItem()
{
	ASSERT( m_pSharedFilesListCtrl != NULL );
	if (m_pSharedFilesListCtrl == NULL)
		return NULL;

	int iItemCount = m_pSharedFilesListCtrl->GetItemCount();
	if (iItemCount >= 2){
		POSITION pos = m_pSharedFilesListCtrl->GetFirstSelectedItemPosition();
		if (pos){
			int iItem = m_pSharedFilesListCtrl->GetNextSelectedItem(pos);
			int iCurSelItem = iItem;
			while (iItem-1 >= 0){
				iItem--;

				const CSharedItem* SharedItem = (CSharedItem*)m_pSharedFilesListCtrl->GetItemData(iItem);
				if (SharedItem->isFile == !m_iParts){
					m_pSharedFilesListCtrl->SetItemState(iCurSelItem, 0, LVIS_SELECTED | LVIS_FOCUSED);
					m_pSharedFilesListCtrl->SetItemState(iItem, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
					m_pSharedFilesListCtrl->SetSelectionMark(iItem);
					m_pSharedFilesListCtrl->EnsureVisible(iItem, FALSE);
					return STATIC_DOWNCAST(CObject, (CObject*)SharedItem->KnownFile);
				}
			}
		}
	}
	return NULL;
}

CObject* CSharedFilesListCtrlItemWalk::GetNextSelectableItem()
{
	ASSERT( m_pSharedFilesListCtrl != NULL );
	if (m_pSharedFilesListCtrl == NULL)
		return NULL;

	int iItemCount =m_pSharedFilesListCtrl->GetItemCount();
	if (iItemCount >= 2){
		POSITION pos = m_pSharedFilesListCtrl->GetFirstSelectedItemPosition();
		if (pos){
			int iItem = m_pSharedFilesListCtrl->GetNextSelectedItem(pos);
			int iCurSelItem = iItem;
			while (iItem+1 < iItemCount){
				iItem++;

				const CSharedItem* SharedItem = (CSharedItem*)m_pSharedFilesListCtrl->GetItemData(iItem);
				if (SharedItem->isFile == !m_iParts){
					m_pSharedFilesListCtrl->SetItemState(iCurSelItem, 0, LVIS_SELECTED | LVIS_FOCUSED);
					m_pSharedFilesListCtrl->SetItemState(iItem, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
					m_pSharedFilesListCtrl->SetSelectionMark(iItem);
					m_pSharedFilesListCtrl->EnsureVisible(iItem, FALSE);
					return STATIC_DOWNCAST(CObject, (CObject*)SharedItem->KnownFile);
				}
			}
		}
	}
	return NULL;
}
// X-Ray :: SharedParts :: End