// X-Ray :: PrefSlider :: Start
//this file is part of eMule
//Copyright (C)2002-2007 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PreferencesDlg.h"
#include "EnBitmap.h" // X-Ray :: PrefBanner

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#endif

// X-Ray :: ModelessDialogs :: Start
/*
IMPLEMENT_DYNAMIC(CPreferencesDlg, CPropertySheet)

BEGIN_MESSAGE_MAP(CPreferencesDlg, CPropertySheet)
*/
IMPLEMENT_DYNAMIC(CPreferencesDlg, CModelessPropertySheet)

BEGIN_MESSAGE_MAP(CPreferencesDlg, CModelessPropertySheet)
// X-Ray :: ModelessDialogs :: End
	ON_WM_DESTROY()
	ON_MESSAGE(WM_SBN_SELCHANGED, OnSlideBarSelChanged) // X-Ray :: PrefSlider
	ON_WM_HELPINFO()
END_MESSAGE_MAP()

CPreferencesDlg::CPreferencesDlg()
{
	m_psh.dwFlags &= ~PSH_HASHELP;
	m_wndGeneral.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndDisplay.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndConnection.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndServer.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndDirectories.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndFiles.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndStats.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndIRC.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndWebServer.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndTweaks.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndSecurity.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndScheduler.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndProxy.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndMessages.m_psp.dwFlags &= ~PSH_HASHELP;

	// X-Ray :: MOD-Prefs
	m_wndX_General.m_psp.dwFlags &= ~PSH_HASHELP;		// General
	m_wndX_Gui.m_psp.dwFlags &= ~PSH_HASHELP;			// GUI
	m_wndX_Con.m_psp.dwFlags &= ~PSH_HASHELP;			// Connection
	m_wndX_Upload.m_psp.dwFlags &= ~PSH_HASHELP;		// Upload
	m_wndX_Download.m_psp.dwFlags &= ~PSH_HASHELP;		// Download
	m_wndX_Share.m_psp.dwFlags &= ~PSH_HASHELP;			// Share
	m_wndX_Argos.m_psp.dwFlags &= ~PSH_HASHELP;			// Argos
	m_wndX_Update.m_psp.dwFlags &= ~PSH_HASHELP;		// Update

	m_wndX_Drop.m_psp.dwFlags &= ~PSH_HASHELP;			// DropSystem
	// X-Ray :: End

	EnableStackedTabs(FALSE); // X-Ray :: PrefSlider

	//	WARNING: Pages must be added with the same order as the slidebar group items.
	//basics:
	AddPage(&m_wndGeneral);
	AddPage(&m_wndDisplay);
	AddPage(&m_wndConnection);
	AddPage(&m_wndServer);
	AddPage(&m_wndDirectories);
	AddPage(&m_wndFiles);

	//advanced:
	AddPage(&m_wndProxy);
	AddPage(&m_wndNotify);
	AddPage(&m_wndStats);
	AddPage(&m_wndIRC);
	AddPage(&m_wndMessages);
	AddPage(&m_wndSecurity);
	AddPage(&m_wndScheduler);
	AddPage(&m_wndWebServer);
	AddPage(&m_wndTweaks);
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	AddPage(&m_wndDebug);
#endif

	// X-Ray :: MOD-Prefs
	AddPage(&m_wndX_General);	// General
	AddPage(&m_wndX_Gui);		// GUI
	AddPage(&m_wndX_Con);		// Connection
	AddPage(&m_wndX_Upload);	// Upload
	AddPage(&m_wndX_Download);	// Donwload
	AddPage(&m_wndX_Share);		// Share
	AddPage(&m_wndX_Argos);		// Argos
	AddPage(&m_wndX_Update);	// Update

	// Double pages must be on the very end of the list!!!
	AddPage(&m_wndX_Drop);		// DropSystem
	// X-Ray :: End

	// X-Ray :: PPgPrefTabs
	m_iStartPageDownload = 0;			// DropSystem
	// X-Ray :: End

	m_nActiveWnd = 0;
	m_bSaveIniFile = false;
}

CPreferencesDlg::~CPreferencesDlg()
{
	ImageList.DeleteImageList(); // X-Ray :: PrefSlider
}

void CPreferencesDlg::OnDestroy()
{
	CPropertySheet::OnDestroy();

	if (m_bSaveIniFile){
		thePrefs.Save();
		m_bSaveIniFile = false;
	}

	m_nActiveWnd = GetActiveIndex();

	// X-Ray :: PPgPrefTabs
	if(m_nActiveWnd == PW_X_DROP)
		m_nActiveWnd = PW_X_DOWNLOAD;
	// X-Ray :: End
}

BOOL CPreferencesDlg::OnInitDialog()
{		
	// X-Ray :: PrefSlider
	m_slideBar.CreateEx(WS_EX_CLIENTEDGE, WS_CHILD | WS_VISIBLE | WS_BORDER, CRect(0, 0, 0, 0), this, IDC_PREFS_SLIDEBAR);
	m_slideBar.SetImageList(&ImageList);
	m_slideBar.SetHAlignCaption(DT_CENTER);

//	Sets a bold font for the group buttons
	CFont* pGroupFont = m_slideBar.GetGroupFont();
	ASSERT_VALID(pGroupFont);
	LOGFONT logFont;
	pGroupFont->GetLogFont(&logFont);
	logFont.lfWeight *= 2;
	if (logFont.lfWeight > FW_BLACK)
		logFont.lfWeight = FW_BLACK;
	pGroupFont->DeleteObject();
	pGroupFont->CreateFontIndirect(&logFont);
	ASSERT_VALID(pGroupFont);

	ASSERT(!m_bSaveIniFile);
	// X-Ray :: ModelessDialogs :: Start
	/*
	BOOL bResult = CPropertySheet::OnInitDialog();
	*/
	BOOL bResult = CModelessPropertySheet::OnInitDialog();
	// X-Ray :: ModelessDialogs :: End

	SetActivePage(m_nActiveWnd);

	// X-Ray :: PrefBanner
	CEnBitmap bmp;
	bmp.LoadImage(_T("BANNER"),_T("JPG"));
	m_banner.SetTexture((HBITMAP)bmp.Detach());	
	m_banner.SetFillFlag(KCSB_FILL_TEXTURE);
	m_banner.SetSize(62);
	m_banner.SetTitle(_T(""));
	m_banner.SetCaption(_T(""));
	m_banner.Attach(this, KCSB_ATTACH_RIGHT);
	// X-Ray :: End

	Localize();
	m_slideBar.SetFocus();
	// X-Ray :: End

	return bResult;
}

// X-Ray :: PrefSlider
LRESULT CPreferencesDlg::OnSlideBarSelChanged(WPARAM /*wParam*/, LPARAM /*lParam*/)
{
	int iCurrentGlobalSel = m_slideBar.GetGlobalSelectedItem();

	// X-Ray :: PPgPrefTabs
	if(iCurrentGlobalSel == PW_X_DOWNLOAD && m_iStartPageDownload == 1)
		iCurrentGlobalSel = PW_X_DROP;
	// X-Ray :: End

	SetActivePage(iCurrentGlobalSel);

	CListBoxST* pListBox = m_slideBar.GetGroupListBox(m_slideBar.GetSelectedGroupIndex());
	ASSERT_VALID(pListBox);

	CString strCurrentItemText;
	pListBox->GetText(pListBox->GetCurSel(), strCurrentItemText);

	CString strCurrentGroupText = m_slideBar.GetGroupName(m_slideBar.GetSelectedGroupIndex());
	strCurrentGroupText.Remove('&');

	CString strTitle = GetResString(IDS_EM_PREFS);
	strTitle.Remove('&');
	SetWindowText(strTitle + _T(" -> ") + strCurrentGroupText + _T(" -> ") + strCurrentItemText);

	pListBox->SetFocus();

	return TRUE;
}
// X-Ray :: End

void CPreferencesDlg::Localize()
{
	ImageList.DeleteImageList();
	ImageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 0, 1);
	ImageList.Add(CTempIconLoader(_T("Preferences")));
	ImageList.Add(CTempIconLoader(_T("DISPLAY")));
	ImageList.Add(CTempIconLoader(_T("CONNECTION")));
	ImageList.Add(CTempIconLoader(_T("PROXY")));
	ImageList.Add(CTempIconLoader(_T("SERVER")));
	ImageList.Add(CTempIconLoader(_T("FOLDERS")));
	ImageList.Add(CTempIconLoader(_T("SharedFiles")));
	ImageList.Add(CTempIconLoader(_T("NOTIFICATIONS")));
	ImageList.Add(CTempIconLoader(_T("STATISTICS")));
	ImageList.Add(CTempIconLoader(_T("IRC")));
	ImageList.Add(CTempIconLoader(_T("MESSAGES")));
	ImageList.Add(CTempIconLoader(_T("SECURITY")));
	ImageList.Add(CTempIconLoader(_T("SCHEDULER")));
	ImageList.Add(CTempIconLoader(_T("WEB")));
	ImageList.Add(CTempIconLoader(_T("TWEAK")));
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	ImageList.Add(CTempIconLoader(_T("EMPTY")));
#endif

	// X-Ray :: MOD-Prefs
	ImageList.Add(CTempIconLoader(_T("PRF_X_GENERAL")));	// General
	ImageList.Add(CTempIconLoader(_T("PRF_X_GUI")));		// GUI
	ImageList.Add(CTempIconLoader(_T("PRF_X_CONNECTION")));	// Connection
	ImageList.Add(CTempIconLoader(_T("PRF_X_UPLOAD")));		// Upload
	ImageList.Add(CTempIconLoader(_T("PRF_X_DOWNLOAD")));	// Download
	ImageList.Add(CTempIconLoader(_T("PRF_X_SHARE")));		// Share
	ImageList.Add(CTempIconLoader(_T("PRF_X_SECURITY")));	// Argos
	ImageList.Add(CTempIconLoader(_T("PRF_X_UPDATE")));		// Update
	// X-Ray :: End

	CString title = GetResString(IDS_EM_PREFS); 
	title.Remove(_T('&')); 
	SetTitle(title); 

	m_wndGeneral.Localize();
	m_wndDisplay.Localize();
	m_wndConnection.Localize();
	m_wndServer.Localize();
	m_wndDirectories.Localize();
	m_wndFiles.Localize();
	m_wndStats.Localize();
	m_wndNotify.Localize();
	m_wndIRC.Localize();
	m_wndSecurity.Localize();
	m_wndTweaks.Localize();
	m_wndWebServer.Localize();
	m_wndScheduler.Localize();
	m_wndProxy.Localize();
	m_wndMessages.Localize();

	// X-Ray :: MOD-Prefs
	m_wndX_General.Localize();	// General
	m_wndX_Gui.Localize();		// GUI
	m_wndX_Con.Localize();		// Connection
	m_wndX_Upload.Localize();	// Upload
	m_wndX_Download.Localize();	// Download
	m_wndX_Share.Localize();	// Share
	//m_wndX_Argos.Localize();	// Argos
	m_wndX_Update.Localize();	// Update

	m_wndX_Drop.Localize();		// DropSystem
	// X-Ray :: End


	// X-Ray :: PrefSlider
	m_slideBar.ResetContent();

	// basic settings
	int iGroupNormal = m_slideBar.AddGroup(GetResString(IDS_LD_BASICOPT));
	m_slideBar.AddGroupItem(GetResString(IDS_PW_GENERAL), iGroupNormal, PW_PREFERENCES); 
	m_slideBar.AddGroupItem(GetResString(IDS_PW_DISPLAY), iGroupNormal, PW_DISPLAY); 
	m_slideBar.AddGroupItem(GetResString(IDS_PW_CONNECTION), iGroupNormal, PW_CONNECTION); 
	m_slideBar.AddGroupItem(GetResString(IDS_PW_SERVER), iGroupNormal,PW_SERVER); 
	m_slideBar.AddGroupItem(GetResString(IDS_PW_DIR), iGroupNormal, PW_FOLDERS); 
	m_slideBar.AddGroupItem(GetResString(IDS_PW_FILES), iGroupNormal, PW_SHAREDFILES);

	// advanced settings
	int iGroupAdvanced = m_slideBar.AddGroup(GetResString(IDS_LD_ADVANCEDOPT));
	m_slideBar.AddGroupItem(GetResString(IDS_PW_PROXY), iGroupAdvanced, PW_PROXY); 
	m_slideBar.AddGroupItem(GetResString(IDS_PW_EKDEV_OPTIONS), iGroupAdvanced, PW_NOTIFICATIONS);
	m_slideBar.AddGroupItem(GetResString(IDS_STATSSETUPINFO), iGroupAdvanced, PW_STATISTICS);
	m_slideBar.AddGroupItem(GetResString(IDS_IRC), iGroupAdvanced, PW_IRC);
	m_slideBar.AddGroupItem(GetResString(IDS_MESSAGESCOMMENTS), iGroupAdvanced, PW_MESSAGES);
	m_slideBar.AddGroupItem(GetResString(IDS_SECURITY), iGroupAdvanced, PW_SECURITY); 
	m_slideBar.AddGroupItem(GetResString(IDS_SCHEDULER), iGroupAdvanced, PW_SCHEDULER);
	m_slideBar.AddGroupItem(GetResString(IDS_PW_WS), iGroupAdvanced, PW_WEB);
	m_slideBar.AddGroupItem(GetResString(IDS_PW_TWEAK), iGroupAdvanced, PW_TWEAK); 

#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	m_slideBar.AddGroupItem(_T("Debug"), iGroupAdvanced, PW_EMPTY);	//NoIcon
#endif

	// X-Ray :: MOD-Prefs
	int iGroupXRay = m_slideBar.AddGroup(GetResString(IDS_PRF_XRAY_GRP));
	m_slideBar.AddGroupItem(GetResString(IDS_PRF_X_GENERAL), iGroupXRay, PW_X_GENERAL);		// General
	m_slideBar.AddGroupItem(GetResString(IDS_PRF_X_GUI), iGroupXRay, PW_X_GUI);				// GUI
	m_slideBar.AddGroupItem(GetResString(IDS_PRF_X_CONNECTION), iGroupXRay, PW_X_CON);		// Connection
	m_slideBar.AddGroupItem(GetResString(IDS_PRF_X_UPLOAD), iGroupXRay, PW_X_UPLOAD);		// Upload
	m_slideBar.AddGroupItem(GetResString(IDS_PRF_X_DOWNLOAD), iGroupXRay, PW_X_DOWNLOAD);	// Download
	m_slideBar.AddGroupItem(GetResString(IDS_PRF_X_SHARE), iGroupXRay, PW_X_SHARE);			// Share
	m_slideBar.AddGroupItem(GetResString(IDS_PRF_X_SECURITY), iGroupXRay, PW_X_ARGOS);		// Argos
	m_slideBar.AddGroupItem(GetResString(IDS_PRF_X_UPDATE), iGroupXRay, PW_X_UPDATE);		// Update
	// X-Ray :: End
	
	int width = m_slideBar.GetGreaterStringWidth();
	width += 60;

	CRect rectOld;
	m_slideBar.GetWindowRect(rectOld);
	// X-Ray :: End

	int xoffset, yoffset;
	if(IsWindowVisible()){
		yoffset=0;
		xoffset=width-rectOld.Width();
	} else {
		xoffset=width-rectOld.Width()+10;
		// X-Ray :: PrefSlider
		GetActivePage()->GetWindowRect(rectOld);
		ScreenToClient (rectOld);
		yoffset = -rectOld.top;
		// X-Ray :: End
	}

	GetWindowRect(rectOld);
	SetWindowPos(NULL,0,0,rectOld.Width()+xoffset,rectOld.Height()+yoffset,SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE);
	CTabCtrl* tab = GetTabControl(); // X-Ray :: PrefSlider
	tab->GetWindowRect (rectOld);
	ScreenToClient (rectOld);
	tab->SetWindowPos(NULL,rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
	CPropertyPage* activepage = GetActivePage();
	activepage->GetWindowRect(rectOld);
	ScreenToClient (rectOld);
	activepage->SetWindowPos(NULL,rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
	// X-Ray :: PrefSlider
	GetClientRect(rectOld);
	m_slideBar.SetWindowPos(NULL, 6, 6, width, rectOld.Height() - 12, SWP_NOZORDER | SWP_NOACTIVATE);
	// X-Ray :: End
	int _PropSheetButtons[] = {IDOK, IDCANCEL, ID_APPLY_NOW, IDHELP };
	CWnd* PropSheetButton;
	for (int i = 0; i < sizeof (_PropSheetButtons) / sizeof(_PropSheetButtons[0]); i++)
	{
		if ((PropSheetButton = GetDlgItem(_PropSheetButtons[i])) != NULL)
		{
			PropSheetButton->GetWindowRect (rectOld);
			ScreenToClient (rectOld);
			PropSheetButton->SetWindowPos (NULL, rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
		}
	}
	tab->ShowWindow(SW_HIDE);
	// X-Ray :: PrefSlider
	m_slideBar.SelectGlobalItem(m_nActiveWnd);
	OnSlideBarSelChanged(NULL, NULL);
	// X-Ray :: End
	CenterWindow();
	m_banner.UpdateSize(); // X-Ray :: PrefBanner
	Invalidate();
	RedrawWindow();
}

void CPreferencesDlg::OnHelp()
{
	int iCurSel = m_slideBar.GetGlobalSelectedItem(); // X-Ray :: PrefSlider
	if (iCurSel >= 0)
	{
		CPropertyPage* pPage = GetPage(iCurSel);
		if (pPage)
		{
			HELPINFO hi = {0};
			hi.cbSize = sizeof hi;
			hi.iContextType = HELPINFO_WINDOW;
			hi.iCtrlId = 0;
			hi.hItemHandle = pPage->m_hWnd;
			hi.dwContextId = 0;
			pPage->SendMessage(WM_HELP, 0, (LPARAM)&hi);
			return;
		}
	}

	theApp.ShowHelp(0, HELP_CONTENTS);
}

BOOL CPreferencesDlg::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP){
		OnHelp();
		return TRUE;
	}

	if (wParam == IDOK || wParam == ID_APPLY_NOW)
		m_bSaveIniFile = true;

	return __super::OnCommand(wParam, lParam);
}

BOOL CPreferencesDlg::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}

// X-Ray :: PPgPrefTabs
void CPreferencesDlg::SwitchTab(int Page)
{
	if(m_hWnd && IsWindowVisible()){
		CPropertyPage* activepage = GetActivePage();

		// Download && DropSystem && HardLimit
		if (activepage == &m_wndX_Download || activepage == &m_wndX_Drop){
			m_iStartPageDownload = Page;
			if (Page == 0) {
				SetActivePage(&m_wndX_Download);
				m_wndX_Download.InitTab(false, 0);
			} else if (Page == 1) {
				SetActivePage(&m_wndX_Drop);
				m_wndX_Drop.InitTab(false, 1);
			}
		}
	}
}
// X-Ray :: End
// X-Ray :: PrefSlider :: End