//this file is part of eMule
//Copyright (C)2002-2007 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "FileDetailDialog.h"
#include "PartFile.h"
#include "HighColorTab.hpp"
#include "UserMsgs.h"
#include "DownloadListCtrl.h"

// X-Ray :: ModelessDialogs :: Start
#include "AbstractFile.h"
#include "SearchFile.h"
#include "SharedFilesCtrl.h"
#include "SearchListCtrl.h"
#include "CollectionListCtrl.h"
#include "Addons/ReqFiles/RequestedFilesCtrl.h"
// X-Ray :: ModelessDialogs :: End

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



//////////////////////////////////////////////////////////////////////////////
// Helper Functions for FileDetail and SharedFileDetailsSheet dialogs

bool NeedArchiveInfoPage(const CSimpleArray<CObject*>* paItems)
{
	if (paItems->GetSize() == 1)
	{
		CKnownFile *pFile = STATIC_DOWNCAST(CKnownFile, (*paItems)[0]);
		EFileType eFileType = GetFileTypeEx(pFile);
		switch (eFileType) {
			case ARCHIVE_ZIP:
			case ARCHIVE_RAR:
			case ARCHIVE_ACE:
				return true;
		}
	}
	return false;
}

void UpdateFileDetailsPages(CListViewWalkerPropertySheet *pSheet,
							CResizablePage *pArchiveInfo, CResizablePage *pMediaInfo)
{
	if (pSheet->GetItems().GetSize() == 1)
	{
		bool bUpdateWindow = false;
		CPropertyPage *pActivePage = pSheet->GetActivePage();
		bool bNeedArchiveInfoPage = NeedArchiveInfoPage(&pSheet->GetItems());
		if (bNeedArchiveInfoPage)
		{
			bool bFound = false;
			for (int i = 0; !bFound && i < pSheet->GetPages().GetSize(); i++) {
				if (pSheet->GetPages()[i] == pArchiveInfo)
					bFound = true;
			}

			int iMediaInfoPage = pSheet->GetPageIndex(pMediaInfo);
			bool bMediaInfoPageWasActive = false;
			if (iMediaInfoPage >= 0) {
				if (pActivePage == pMediaInfo)
					bMediaInfoPageWasActive = true;
				if (!bUpdateWindow) {
					pSheet->SetRedraw(FALSE);
					bUpdateWindow = true;
				}
				pSheet->RemovePage(pMediaInfo);
			}

			if (!bFound) {
				ASSERT( iMediaInfoPage >= 0 );
				if (!bUpdateWindow) {
					pSheet->SetRedraw(FALSE);
					bUpdateWindow = true;
				}
				pSheet->InsertPage(iMediaInfoPage, pArchiveInfo);
				if (bMediaInfoPageWasActive)
					pSheet->SetActivePage(iMediaInfoPage);
			}
		}
		else
		{
			bool bFound = false;
			for (int i = 0; !bFound && i < pSheet->GetPages().GetSize(); i++) {
				if (pSheet->GetPages()[i] == pMediaInfo)
					bFound = true;
			}

			int iArchiveInfoPage = pSheet->GetPageIndex(pArchiveInfo);
			bool bArchiveInfoPageWasActive = false;
			if (iArchiveInfoPage >= 0) {
				if (pActivePage == pArchiveInfo)
					bArchiveInfoPageWasActive = true;
				if (!bUpdateWindow) {
					pSheet->SetRedraw(FALSE);
					bUpdateWindow = true;
				}
				pSheet->RemovePage(pArchiveInfo);
			}

			if (!bFound) {
				ASSERT( iArchiveInfoPage >= 0 );
				if (!bUpdateWindow) {
					pSheet->SetRedraw(FALSE);
					bUpdateWindow = true;
				}
				pSheet->InsertPage(iArchiveInfoPage, pMediaInfo);
				if (bArchiveInfoPageWasActive)
					pSheet->SetActivePage(pMediaInfo);
			}
		}
		if (bUpdateWindow) {
			pSheet->SetRedraw(TRUE);
			pSheet->Invalidate();
			pSheet->UpdateWindow();
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
// CFileDetailDialog

LPCTSTR CFileDetailDialog::m_pPshStartPage;

// X-Ray :: ModelessDialogs :: Start
/*
IMPLEMENT_DYNAMIC(CFileDetailDialog, CListViewWalkerPropertySheet)

BEGIN_MESSAGE_MAP(CFileDetailDialog, CListViewWalkerPropertySheet)
*/
IMPLEMENT_DYNAMIC(CFileDetailDialog, CListViewWalkerModelessPropertySheet)

BEGIN_MESSAGE_MAP(CFileDetailDialog, CListViewWalkerModelessPropertySheet)
// X-Ray :: ModelessDialogs :: End
	ON_WM_DESTROY()
	ON_MESSAGE(UM_DATA_CHANGED, OnDataChanged)
END_MESSAGE_MAP()

// X-Ray :: ModelessDialogs :: Start
/*
CFileDetailDialog::CFileDetailDialog(const CSimpleArray<CPartFile*>* paFiles, UINT uPshInvokePage, CListCtrlItemWalk* pListCtrl)
	: CListViewWalkerPropertySheet(pListCtrl)
{
	m_uPshInvokePage = uPshInvokePage;
	for (int i = 0; i < paFiles->GetSize(); i++)
		m_aItems.Add((*paFiles)[i]);
	m_psh.dwFlags &= ~PSH_HASHELP;

	m_wndInfo.m_psp.dwFlags &= ~PSP_HASHELP;
	m_wndInfo.m_psp.dwFlags |= PSP_USEICONID;
	m_wndInfo.m_psp.pszIcon = _T("FILEINFO");
	m_wndInfo.SetFiles(&m_aItems);
	AddPage(&m_wndInfo);

	if (m_aItems.GetSize() == 1)
	{
		m_wndName.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndName.m_psp.dwFlags |= PSP_USEICONID;
		m_wndName.m_psp.pszIcon = _T("FILERENAME");
		m_wndName.SetFiles(&m_aItems);
		AddPage(&m_wndName);
	}

	m_wndComments.m_psp.dwFlags &= ~PSP_HASHELP;
	m_wndComments.m_psp.dwFlags |= PSP_USEICONID;
	m_wndComments.m_psp.pszIcon = _T("FILECOMMENTS");
	m_wndComments.SetFiles(&m_aItems);
	AddPage(&m_wndComments);

	m_wndArchiveInfo.m_psp.dwFlags &= ~PSP_HASHELP;
	m_wndArchiveInfo.m_psp.dwFlags |= PSP_USEICONID;
	m_wndArchiveInfo.m_psp.pszIcon = _T("ARCHIVE_PREVIEW");
	m_wndArchiveInfo.SetFiles(&m_aItems);
	m_wndMediaInfo.m_psp.dwFlags &= ~PSP_HASHELP;
	m_wndMediaInfo.m_psp.dwFlags |= PSP_USEICONID;
	m_wndMediaInfo.m_psp.pszIcon = _T("MEDIAINFO");
	m_wndMediaInfo.SetFiles(&m_aItems);
	if (NeedArchiveInfoPage(&m_aItems))
		AddPage(&m_wndArchiveInfo);
	else
		AddPage(&m_wndMediaInfo);

	if (m_aItems.GetSize() == 1)
	{
		if (thePrefs.IsExtControlsEnabled()) {
			m_wndMetaData.m_psp.dwFlags &= ~PSP_HASHELP;
			m_wndMetaData.m_psp.dwFlags |= PSP_USEICONID;
			m_wndMetaData.m_psp.pszIcon = _T("METADATA");
			m_wndMetaData.SetFiles(&m_aItems);
			AddPage(&m_wndMetaData);
		}
	}

	m_wndFileLink.m_psp.dwFlags &= ~PSP_HASHELP;
	m_wndFileLink.m_psp.dwFlags |= PSP_USEICONID;
	m_wndFileLink.m_psp.pszIcon = _T("ED2KLINK");
	m_wndFileLink.SetFiles(&m_aItems);
	AddPage(&m_wndFileLink);

	LPCTSTR pPshStartPage = m_pPshStartPage;
	if (m_uPshInvokePage != 0)
		pPshStartPage = MAKEINTRESOURCE(m_uPshInvokePage);
	for (int i = 0; i < m_pages.GetSize(); i++)
	{
		CPropertyPage* pPage = GetPage(i);
		if (pPage->m_psp.pszTemplate == pPshStartPage)
		{
			m_psh.nStartPage = i;
			break;
		}
	}
}
*/
CFileDetailDialog::CFileDetailDialog(const CSimpleArray<CObject*>* paFiles, UINT uPshInvokePage, CListCtrlItemWalk* pListCtrl)
: CListViewWalkerModelessPropertySheet(pListCtrl)
{
	m_uPshInvokePage = uPshInvokePage;
	for (int i = 0; i < paFiles->GetSize(); i++)
		m_aItems.Add((*paFiles)[i]);
	m_psh.dwFlags &= ~PSH_HASHELP;
	AddPages();
}
// X-Ray :: ModelessDialogs :: End

CFileDetailDialog::~CFileDetailDialog()
{
}

// X-Ray :: ModelessDialogs :: Start
void CFileDetailDialog::AddPages()
{
	if(m_pListCtrl->GetListCtrl()->IsKindOf(RUNTIME_CLASS(CSharedFilesCtrl))){
		m_wndFileComments.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndFileComments.m_psp.dwFlags |= PSP_USEICONID;
		m_wndFileComments.m_psp.pszIcon = _T("FileComments");
		m_wndFileComments.SetFiles(&m_aItems);
		AddPage(&m_wndFileComments);

		m_wndArchiveInfo.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndArchiveInfo.m_psp.dwFlags |= PSP_USEICONID;
		m_wndArchiveInfo.m_psp.pszIcon = _T("ARCHIVE_PREVIEW");
		m_wndArchiveInfo.SetFiles(&m_aItems);
		m_wndMediaInfo.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndMediaInfo.m_psp.dwFlags |= PSP_USEICONID;
		m_wndMediaInfo.m_psp.pszIcon = _T("MEDIAINFO");
		m_wndMediaInfo.SetFiles(&m_aItems);
		if (NeedArchiveInfoPage(&m_aItems))
			AddPage(&m_wndArchiveInfo);
		else
			AddPage(&m_wndMediaInfo);

		m_wndMetaData.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndMetaData.m_psp.dwFlags |= PSP_USEICONID;
		m_wndMetaData.m_psp.pszIcon = _T("METADATA");
		if (m_aItems.GetSize() == 1 && thePrefs.IsExtControlsEnabled()) {
			m_wndMetaData.SetFiles(&m_aItems);
			AddPage(&m_wndMetaData);
		}

		m_wndFileLink.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndFileLink.m_psp.dwFlags |= PSP_USEICONID;
		m_wndFileLink.m_psp.pszIcon = _T("ED2KLINK");
		m_wndFileLink.SetFiles(&m_aItems);
		AddPage(&m_wndFileLink);


	}

	else if(m_pListCtrl->GetListCtrl()->IsKindOf(RUNTIME_CLASS(CDownloadListCtrl))){
		m_wndInfo.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndInfo.m_psp.dwFlags |= PSP_USEICONID;
		m_wndInfo.m_psp.pszIcon = _T("FILEINFO");
		m_wndInfo.SetFiles(&m_aItems);
		AddPage(&m_wndInfo);

		if (m_aItems.GetSize() == 1){
			m_wndName.m_psp.dwFlags &= ~PSP_HASHELP;
			m_wndName.m_psp.dwFlags |= PSP_USEICONID;
			m_wndName.m_psp.pszIcon = _T("FILERENAME");
			m_wndName.SetFiles(&m_aItems);
			AddPage(&m_wndName);
		}

		m_wndComments.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndComments.m_psp.dwFlags |= PSP_USEICONID;
		m_wndComments.m_psp.pszIcon = _T("FILECOMMENTS");
		m_wndComments.SetFiles(&m_aItems);
		AddPage(&m_wndComments);

		m_wndArchiveInfo.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndArchiveInfo.m_psp.dwFlags |= PSP_USEICONID;
		m_wndArchiveInfo.m_psp.pszIcon = _T("ARCHIVE_PREVIEW");
		m_wndArchiveInfo.SetFiles(&m_aItems);
		m_wndMediaInfo.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndMediaInfo.m_psp.dwFlags |= PSP_USEICONID;
		m_wndMediaInfo.m_psp.pszIcon = _T("MEDIAINFO");
		m_wndMediaInfo.SetFiles(&m_aItems);
		if (NeedArchiveInfoPage(&m_aItems))
			AddPage(&m_wndArchiveInfo);
		else
			AddPage(&m_wndMediaInfo);

		if (m_aItems.GetSize() == 1){
			if (thePrefs.IsExtControlsEnabled()){
				m_wndMetaData.m_psp.dwFlags &= ~PSP_HASHELP;
				m_wndMetaData.m_psp.dwFlags |= PSP_USEICONID;
				m_wndMetaData.m_psp.pszIcon = _T("METADATA");
				m_wndMetaData.SetFiles(&m_aItems);
				AddPage(&m_wndMetaData);
			}
		}

		m_wndFileLink.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndFileLink.m_psp.dwFlags |= PSP_USEICONID;
		m_wndFileLink.m_psp.pszIcon = _T("ED2KLINK");
		m_wndFileLink.SetFiles(&m_aItems);
		AddPage(&m_wndFileLink);
	}

	else if(m_pListCtrl->GetListCtrl()->IsKindOf(RUNTIME_CLASS(CSearchListCtrl))){
		m_wndMetaData.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndMetaData.m_psp.dwFlags |= PSP_USEICONID;
		m_wndMetaData.m_psp.pszIcon = _T("METADATA");
		if (m_aItems.GetSize() == 1 && thePrefs.IsExtControlsEnabled()) {
			m_wndMetaData.SetFiles(&m_aItems);
			AddPage(&m_wndMetaData);
		}

		m_wndComments.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndComments.m_psp.dwFlags |= PSP_USEICONID;
		m_wndComments.m_psp.pszIcon = _T("FileComments");
		m_wndComments.SetFiles(&m_aItems);
		AddPage(&m_wndComments);
	}

	else if(m_pListCtrl->GetListCtrl()->IsKindOf(RUNTIME_CLASS(CCollectionListCtrl))){
		m_wndMetaData.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndMetaData.m_psp.dwFlags |= PSP_USEICONID;
		m_wndMetaData.m_psp.pszIcon = _T("METADATA");
		m_wndMetaData.SetFiles(&m_aItems);
		AddPage(&m_wndMetaData);
	}

	// X-Ray :: ReqFiles :: Start
	else if(m_pListCtrl->GetListCtrl()->IsKindOf(RUNTIME_CLASS(CRequestedFilesCtrl))){
		m_wndMediaInfo.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndMediaInfo.m_psp.dwFlags |= PSP_USEICONID;
		m_wndMediaInfo.m_psp.pszIcon = _T("MEDIAINFO");
		m_wndMediaInfo.SetFiles(&m_aItems);
		AddPage(&m_wndMediaInfo);

		m_wndMetaData.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndMetaData.m_psp.dwFlags |= PSP_USEICONID;
		m_wndMetaData.m_psp.pszIcon = _T("METADATA");
		if (m_aItems.GetSize() == 1 && thePrefs.IsExtControlsEnabled()) {
			m_wndMetaData.SetFiles(&m_aItems);
			AddPage(&m_wndMetaData);
		}

		m_wndComments.m_psp.dwFlags &= ~PSP_HASHELP;
		m_wndComments.m_psp.dwFlags |= PSP_USEICONID;
		m_wndComments.m_psp.pszIcon = _T("FILECOMMENTS");
		m_wndComments.SetFiles(&m_aItems);
		AddPage(&m_wndComments);
	}
	// X-Ray :: ReqFiles :: End

	LPCTSTR pPshStartPage = m_pPshStartPage;
	if (m_uPshInvokePage != 0)
		pPshStartPage = MAKEINTRESOURCE(m_uPshInvokePage);
	for (int i = 0; i < m_pages.GetSize(); i++)
	{
		CPropertyPage* pPage = GetPage(i);
		if (pPage->m_psp.pszTemplate == pPshStartPage)
		{
			m_psh.nStartPage = i;
			break;
		}
	}
}
// X-Ray :: ModelessDialogs :: End

void CFileDetailDialog::OnDestroy()
{
	if (m_uPshInvokePage == 0)
		m_pPshStartPage = GetPage(GetActiveIndex())->m_psp.pszTemplate;
	// X-Ray :: ModelessDialogs :: Start
	/*
	CListViewWalkerPropertySheet::OnDestroy();
	*/
	CListViewWalkerModelessPropertySheet::OnDestroy();
	// X-Ray :: ModelessDialogs :: End
}

BOOL CFileDetailDialog::OnInitDialog()
{		
	EnableStackedTabs(FALSE);
	// X-Ray :: ModelessDialogs :: Start
	/*
	BOOL bResult = CListViewWalkerPropertySheet::OnInitDialog();
	*/
	BOOL bResult = CListViewWalkerModelessPropertySheet::OnInitDialog();
	// X-Ray :: ModelessDialogs :: End
	HighColorTab::UpdateImageList(*this);
	InitWindowStyles(this);
	EnableSaveRestore(_T("FileDetailDialog")); // call this after(!) OnInitDialog
	UpdateTitle();

	return bResult;
}

LRESULT CFileDetailDialog::OnDataChanged(WPARAM, LPARAM)
{
	UpdateTitle();
	if(m_pListCtrl->GetListCtrl()->IsKindOf(RUNTIME_CLASS(CDownloadListCtrl)) || m_pListCtrl->GetListCtrl()->IsKindOf(RUNTIME_CLASS(CSharedFilesCtrl)))
		UpdateFileDetailsPages(this, &m_wndArchiveInfo, &m_wndMediaInfo);
	return 1;
}

void CFileDetailDialog::UpdateTitle()
{
	if (m_aItems.GetSize() == 1)
		SetWindowText(GetResString(IDS_DETAILS) + _T(": ") + STATIC_DOWNCAST(CAbstractFile, m_aItems[0])->GetFileName());
	else
		SetWindowText(GetResString(IDS_DETAILS));
}

// X-Ray :: ModelessDialogs :: Start
BOOL CFileDetailDialog::OnCommand(WPARAM wParam, LPARAM lParam)
{
	#define IDC_PREV	100
	#define IDC_NEXT	101

	if(!m_pListCtrl){
		if(wParam == IDC_NEXT || wParam == IDC_PREV){
			GetDlgItem(IDC_NEXT)->EnableWindow(FALSE);
			GetDlgItem(IDC_PREV)->EnableWindow(FALSE);
			return TRUE;
		}
	} else {
		if(m_pListCtrl->GetListCtrl()->IsKindOf(RUNTIME_CLASS(CSharedFilesCtrl))){
			if (wParam == ID_APPLY_NOW){
				CSharedFilesCtrl* pSharedFilesCtrl = DYNAMIC_DOWNCAST(CSharedFilesCtrl, m_pListCtrl->GetListCtrl());
				if (pSharedFilesCtrl){
					for (int i = 0; i < m_aItems.GetSize(); i++){
						// so, and why does this not(!) work while the sheet is open ??
						pSharedFilesCtrl->UpdateFile(DYNAMIC_DOWNCAST(CKnownFile, m_aItems[i]));
					}
				}
			}
		}
	}
	return CListViewWalkerPropertySheet::OnCommand(wParam, lParam);
}

///////////////////////////////////////////////////////////////////////////////
// CFileDetailDialogInterface

CFileDetailDialogInterface::CFileDetailDialogInterface(CKnownFile* owner)
: CListViewWalkerModelessPropertySheetInterface(STATIC_DOWNCAST(CObject, owner))
{
}

CFileDetailDialogInterface::CFileDetailDialogInterface(CPartFile* owner)
: CListViewWalkerModelessPropertySheetInterface(STATIC_DOWNCAST(CObject, owner))
{
}

CFileDetailDialogInterface::CFileDetailDialogInterface(CSearchFile* owner)
: CListViewWalkerModelessPropertySheetInterface(STATIC_DOWNCAST(CObject, owner))
{
}

CFileDetailDialogInterface::CFileDetailDialogInterface(CAbstractFile* owner)
: CListViewWalkerModelessPropertySheetInterface(STATIC_DOWNCAST(CObject, owner))
{
}

void CFileDetailDialogInterface::OpenDetailDialog(CTypedPtrList<CPtrList, CKnownFile*>& paFiles, UINT uInvokePage, CListCtrlItemWalk* pListCtrl)
{
	CSimpleArray<CListViewWalkerModelessPropertySheetInterface*> aInterfaces;
	CSimpleArray<CObject*> m_aItems;
	POSITION pos = paFiles.GetHeadPosition();
	while (pos){
		m_aItems.Add(paFiles.GetAt(pos));
		aInterfaces.Add(STATIC_DOWNCAST(CListViewWalkerModelessPropertySheetInterface, paFiles.GetNext(pos)->GetDetailDialogInterface()));
	}
	OpenPropertySheet(&aInterfaces, &m_aItems, uInvokePage, pListCtrl);
}

void CFileDetailDialogInterface::OpenDetailDialog(CTypedPtrList<CPtrList, CPartFile*>& paFiles, UINT uInvokePage, CListCtrlItemWalk* pListCtrl)
{
	CSimpleArray<CListViewWalkerModelessPropertySheetInterface*> aInterfaces;
	CSimpleArray<CObject*> m_aItems;
	POSITION pos = paFiles.GetHeadPosition();
	while (pos){
		m_aItems.Add(paFiles.GetAt(pos));
		aInterfaces.Add(STATIC_DOWNCAST(CListViewWalkerModelessPropertySheetInterface, paFiles.GetNext(pos)->GetDetailDialogInterface()));
	}
	OpenPropertySheet(&aInterfaces, &m_aItems, uInvokePage, pListCtrl);
}

void CFileDetailDialogInterface::OpenDetailDialog(CTypedPtrList<CPtrList, CSearchFile*>& paFiles, UINT uInvokePage, CListCtrlItemWalk* pListCtrl)
{
	CSimpleArray<CListViewWalkerModelessPropertySheetInterface*> aInterfaces;
	CSimpleArray<CObject*> m_aItems;
	POSITION pos = paFiles.GetHeadPosition();
	while (pos){
		m_aItems.Add(paFiles.GetAt(pos));
		aInterfaces.Add(STATIC_DOWNCAST(CListViewWalkerModelessPropertySheetInterface, paFiles.GetNext(pos)->GetDetailDialogInterface()));
	}
	OpenPropertySheet(&aInterfaces, &m_aItems, uInvokePage, pListCtrl);
}

void CFileDetailDialogInterface::OpenDetailDialog(CTypedPtrList<CPtrList, CAbstractFile*>& paFiles, UINT uInvokePage, CListCtrlItemWalk* pListCtrl)
{
	CSimpleArray<CListViewWalkerModelessPropertySheetInterface*> aInterfaces;
	CSimpleArray<CObject*> m_aItems;
	POSITION pos = paFiles.GetHeadPosition();
	while (pos){
		m_aItems.Add(paFiles.GetAt(pos));
		aInterfaces.Add(STATIC_DOWNCAST(CListViewWalkerModelessPropertySheetInterface, paFiles.GetNext(pos)->GetDetailDialogInterface()));
	}
	OpenPropertySheet(&aInterfaces, &m_aItems, uInvokePage, pListCtrl);
}

CListViewWalkerModelessPropertySheet* CFileDetailDialogInterface::CreatePropertySheet(va_list args)
{
	const CSimpleArray<CObject*>* paFiles = (const CSimpleArray<CObject*>*)va_arg(args, LPVOID);
	UINT uInvokePage = va_arg(args, UINT);
	CListCtrlItemWalk* pListCtrl = va_arg(args, CListCtrlItemWalk*);
	return STATIC_DOWNCAST(CListViewWalkerModelessPropertySheet, new CFileDetailDialog(paFiles, uInvokePage, pListCtrl));
}
// X-Ray :: ModelessDialogs :: End