//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PPg_X_Update.h"
#include "opcodes.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "Log.h"
#include "Addons/IP2Country/IP2Country.h" // X-Ray :: IP2Country
#include "IPFilter.h" // X-Ray :: IPFilterUpdate

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPg_X_Update, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPg_X_Update, CPropertyPage)
	// X-Ray :: IP2Country :: Start
	ON_BN_CLICKED(IDC_PRF_UPDATE_I2C_STARTUP_CHK, OnSettingsChange)
	ON_EN_CHANGE(IDC_PRF_UPDATE_I2C_URL_BOX, OnSettingsChange)
	ON_EN_CHANGE(IDC_PRF_UPDATE_I2C_URL2_BOX, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_UPDATE_I2C_PUSHBTN, OnBnClickedIP2CountryUpdate)
	ON_BN_CLICKED(IDC_PRF_UPDATE_I2C_RESET_PUSH, OnBnClickedResetIP2CountryURL)
	// X-Ray :: IP2Country :: End
	// X-Ray :: IPFilterUpdate :: Start
	ON_BN_CLICKED(IDC_PRF_UPDATE_IPF_STARTUP_CHK, OnSettingsChange)
	ON_EN_CHANGE(IDC_PRF_UPDATE_IPF_URL_BOX, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_UPDATE_IPF_PUSHBTN, OnBnClickedIPFilterUpdate)
	ON_BN_CLICKED(IDC_PRF_UPDATE_IPF_RESET_PUSH, OnBnClickedResetIPFilterURL)
	// X-Ray :: IPFilterUpdate :: End
END_MESSAGE_MAP()

CPPg_X_Update::CPPg_X_Update()
	: CPropertyPage(CPPg_X_Update::IDD)
{
}

CPPg_X_Update::~CPPg_X_Update()
{
}

void CPPg_X_Update::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BOOL CPPg_X_Update::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

void CPPg_X_Update::SysTimeToStr(LPSYSTEMTIME st, LPTSTR str)
{
	TCHAR sDate[15];
	sDate[0] = _T('\0');
	GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, st, NULL, sDate, 100);
	TCHAR sTime[15];
	sTime[0] = _T('\0');
	GetTimeFormat(LOCALE_USER_DEFAULT, 0, st, NULL ,sTime ,100);
	_stprintf(str, _T("%s %s"), sDate, sTime);
}

BOOL CPPg_X_Update::OnApply()
{
	// X-Ray :: IP2Country :: Start
	thePrefs.SetAutoUpdateIP2Country(IsDlgButtonChecked(IDC_PRF_UPDATE_I2C_STARTUP_CHK) ? true : false);

	CString strBuffer;
	if(GetDlgItem(IDC_PRF_UPDATE_I2C_URL_BOX)->GetWindowTextLength()){
		GetDlgItem(IDC_PRF_UPDATE_I2C_URL_BOX)->GetWindowText(strBuffer);
		thePrefs.SetIP2CountryUpdateURL(strBuffer);
	}

	if(GetDlgItem(IDC_PRF_UPDATE_I2C_URL2_BOX)->GetWindowTextLength()){
		GetDlgItem(IDC_PRF_UPDATE_I2C_URL2_BOX)->GetWindowText(strBuffer);
		thePrefs.SetIP2CountryUpdateVerURL(strBuffer);
	}
	// X-Ray :: IP2Country :: End

	// X-Ray :: IPFilterUpdate :: Start
	thePrefs.SetUseAutoUpdateIPFilter(IsDlgButtonChecked(IDC_PRF_UPDATE_IPF_STARTUP_CHK) ? true : false);

	if(GetDlgItem(IDC_PRF_UPDATE_IPF_URL_BOX)->GetWindowTextLength()){
		GetDlgItem(IDC_PRF_UPDATE_IPF_URL_BOX)->GetWindowText(strBuffer);
		thePrefs.SetIPFilterUpdateURL(strBuffer);
	}
	// X-Ray :: IPFilterUpdate :: End

	LoadSettings();
	return TRUE;
}

void CPPg_X_Update::LoadSettings()
{
	// X-Ray :: IP2Country :: Start
	CheckDlgButton(IDC_PRF_UPDATE_I2C_STARTUP_CHK, thePrefs.IsAutoUpdateIP2CountryEnabled());
	GetDlgItem(IDC_PRF_UPDATE_I2C_URL_BOX)->SetWindowText(thePrefs.GetIP2CountryUpdateURL());
	GetDlgItem(IDC_PRF_UPDATE_I2C_URL2_BOX)->SetWindowText(thePrefs.GetIP2CountryUpdateVerURL());

	TCHAR sTime[30];
	sTime[0] = _T('\0');
	SysTimeToStr(thePrefs.GetIP2CountryVersion2(), sTime);
	GetDlgItem(IDC_PRF_UPDATE_I2C_VERSION_LBL)->SetWindowText(sTime);
	// X-Ray :: IP2Country :: End

	// X-Ray :: IPFilterUpdate :: Start
	CheckDlgButton(IDC_PRF_UPDATE_IPF_STARTUP_CHK, thePrefs.GetUseAutoUpdateIPFilter());
	GetDlgItem(IDC_PRF_UPDATE_IPF_URL_BOX)->SetWindowText(thePrefs.GetIPFilterUpdateURL());

	sTime[0] = _T('\0');
	SysTimeToStr(thePrefs.GetIPFilterVersion(), sTime);
	GetDlgItem(IDC_PRF_UPDATE_IPF_VERSION_LBL)->SetWindowText(sTime);
	// X-Ray :: IPFilterUpdate :: End
}

void CPPg_X_Update::Localize()
{
	if (m_hWnd)
	{
		// X-Ray :: IP2Country :: Start
		GetDlgItem(IDC_PRF_UPDATE_I2C_GRP)->SetWindowText(GetResString(IDS_PRF_UPDATE_I2C_GRP));
		GetDlgItem(IDC_PRF_UPDATE_I2C_STARTUP_CHK)->SetWindowText(GetResString(IDS_PRF_UPDATE_I2C_STARTUP_CHK));
		GetDlgItem(IDC_PRF_UPDATE_I2C_URL_LBL)->SetWindowText(GetResString(IDS_PRF_UPDATE_I2C_URL_LBL));
		GetDlgItem(IDC_PRF_UPDATE_I2C_URL2_LBL)->SetWindowText(GetResString(IDS_PRF_UPDATE_I2C_URL2_LBL));
		GetDlgItem(IDC_PRF_UPDATE_I2C_RESET_PUSH)->SetWindowText(GetResString(IDS_PW_RESET));
		GetDlgItem(IDC_PRF_UPDATE_I2C_PUSHBTN)->SetWindowText(GetResString(IDS_SV_UPDATE));
		// X-Ray :: IP2Country :: End
		// X-Ray :: IPFilterUpdate :: Start
		GetDlgItem(IDC_PRF_UPDATE_IPF_GRP)->SetWindowText(GetResString(IDS_PRF_UPDATE_IPF_GRP));
		GetDlgItem(IDC_PRF_UPDATE_IPF_STARTUP_CHK)->SetWindowText(GetResString(IDS_PRF_UPDATE_IPF_STARTUP_CHK));
		GetDlgItem(IDC_PRF_UPDATE_IPF_URL_LBL)->SetWindowText(GetResString(IDS_PRF_UPDATE_IPF_URL_LBL));
		GetDlgItem(IDC_PRF_UPDATE_IPF_RESET_PUSH)->SetWindowText(GetResString(IDS_PW_RESET));
		GetDlgItem(IDC_PRF_UPDATE_IPF_PUSHBTN)->SetWindowText(GetResString(IDS_SV_UPDATE));
		// X-Ray :: IPFilterUpdate :: End
	}
}

// X-Ray :: IP2Country :: Start
void CPPg_X_Update::OnBnClickedIP2CountryUpdate()
{
	OnApply();
	theApp.ip2country->UpdateIP2CountryURL();
	TCHAR sBuffer[30];
	sBuffer[0] = _T('\0');
	SysTimeToStr(thePrefs.GetIP2CountryVersion2(), sBuffer);
	GetDlgItem(IDC_PRF_UPDATE_I2C_VERSION_LBL)->SetWindowText(sBuffer);
}

void CPPg_X_Update::OnBnClickedResetIP2CountryURL()
{
	CString strBuffer = _T("http://ip-to-country.webhosting.info/downloads/ip-to-country.csv.zip");
	GetDlgItem(IDC_PRF_UPDATE_I2C_URL_BOX)->SetWindowText(strBuffer);
	strBuffer = _T("http://ip-to-country.webhosting.info/downloads/latest");
	GetDlgItem(IDC_PRF_UPDATE_I2C_URL2_BOX)->SetWindowText(strBuffer);
	thePrefs.SetIP2CountryVersion(0);
	memset(thePrefs.GetIP2CountryVersion2(), 0, sizeof(SYSTEMTIME));
	TCHAR sBuffer[30];
	sBuffer[0] = _T('\0');
	SysTimeToStr(thePrefs.GetIP2CountryVersion2(), sBuffer);
	GetDlgItem(IDC_PRF_UPDATE_I2C_VERSION_LBL)->SetWindowText(sBuffer);
}
// X-Ray :: IP2Country :: End

// X-Ray :: IPFilterUpdate :: Start
void CPPg_X_Update::OnBnClickedIPFilterUpdate()
{
	OnApply();
	theApp.ipfilter->UpdateIPFilterURL();
	TCHAR sBuffer[30];
	sBuffer[0] = _T('\0'); 
	SysTimeToStr(thePrefs.GetIPFilterVersion(), sBuffer);
	GetDlgItem(IDC_PRF_UPDATE_IPF_VERSION_LBL)->SetWindowText(sBuffer);
}

void CPPg_X_Update::OnBnClickedResetIPFilterURL()
{
	CString strBuffer = _T("http://emulepawcio.sourceforge.net/ipfilter.zip");
	GetDlgItem(IDC_PRF_UPDATE_IPF_URL_BOX)->SetWindowText(strBuffer);
	memset(thePrefs.GetIPFilterVersion(), 0, sizeof(SYSTEMTIME));
	TCHAR sBuffer[30];
	sBuffer[0] = _T('\0');
	SysTimeToStr(thePrefs.GetIPFilterVersion(), sBuffer);
	GetDlgItem(IDC_PRF_UPDATE_IPF_VERSION_LBL)->SetWindowText(sBuffer);
}
// X-Ray :: IPFilterUpdate :: End