//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PPg_X_Upload.h"
#include "opcodes.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "Log.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPg_X_Upload, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPg_X_Upload, CPropertyPage)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_PRF_UP_SLOTCTRL_OMSIN, OnSettingsChange) // X-Ray :: SlotControl
END_MESSAGE_MAP()

CPPg_X_Upload::CPPg_X_Upload()
	: CPropertyPage(CPPg_X_Upload::IDD)
{
}

CPPg_X_Upload::~CPPg_X_Upload()
{
}

void CPPg_X_Upload::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BOOL CPPg_X_Upload::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPg_X_Upload::OnApply()
{
	// X-Ray :: SlotControl :: Start
	thePrefs.SetUpSlots((uint8)((CSliderCtrl*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))->GetPos()+1);
	thePrefs.SetOpenMoreSlots(IsDlgButtonChecked(IDC_PRF_UP_SLOTCTRL_OMSIN) ? true : false);
	// X-Ray :: SlotControl :: End

	LoadSettings();
	return TRUE;
}

void CPPg_X_Upload::LoadSettings()
{
	// X-Ray :: SlotControl :: Start
	uint32 MaxUpSpeed = thePrefs.maxupload;
	uint8 MinSlots = (uint8)(sqrtl(MaxUpSpeed)-1);
	if (MaxUpSpeed != UNLIMITED)
		((CSliderCtrl*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))->SetRange(MinSlots < 1 ? 1 : MinSlots, MaxUpSpeed/3, TRUE);
	else
		((CSliderCtrl*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))->SetRange(1, 255, TRUE);
	((CSliderCtrl*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))->SetPos(thePrefs.GetUpSlots()-1);
	ShowUpSlotValues();

	if(thePrefs.maxupload != UNLIMITED){
		GetDlgItem(IDC_PRF_UP_SLOTCTRL_OMSIN)->EnableWindow(true);
		CheckDlgButton(IDC_PRF_UP_SLOTCTRL_OMSIN, thePrefs.GetOpenMoreSlots());
	}
	else {
		GetDlgItem(IDC_PRF_UP_SLOTCTRL_OMSIN)->EnableWindow(false);
		CheckDlgButton(IDC_PRF_UP_SLOTCTRL_OMSIN, false);
	}

	// X-Ray :: SlotControl :: End
}

void CPPg_X_Upload::Localize()
{
	if (m_hWnd)
	{
		// X-Ray :: SlotControl :: Start
		GetDlgItem(IDC_PRF_UP_SLOTCTRL_GRP)->SetWindowText(GetResString(IDS_PRF_UP_SLOTCTRL_GRP));
		GetDlgItem(IDC_PRF_UP_SLOTCTRL_LBL)->SetWindowText(GetResString(IDS_PRF_UP_SLOTCTRL_LBL));
		GetDlgItem(IDC_PRF_UP_SLOTCTRL_DRPC_LBL)->SetWindowText(GetResString(IDS_PRF_UP_SLOTCTRL_DRPC_LBL));
		GetDlgItem(IDC_PRF_UP_SLOTCTRL_OMSIN)->SetWindowText(GetResString(IDS_PRF_UP_SLOTCTRL_OMSIN));
		// X-Ray :: SlotControl :: End
	}
}

void CPPg_X_Upload::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SetModified();
	// X-Ray :: SlotControl :: Start
	if( pScrollBar == (CScrollBar*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER) )
		ShowUpSlotValues();
	// X-Ray :: SlotControl :: End
	UpdateData(false); 
	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}

// X-Ray :: SlotControl :: Start
void CPPg_X_Upload::ShowUpSlotValues()
{
	CString strBuffer;
	strBuffer.Format(_T("%i+1 LowID"), ((CSliderCtrl*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))->GetPos());
	GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLOTS)->SetWindowText(strBuffer);
	if(thePrefs.GetMaxUpload() == UNLIMITED){
		if(thePrefs.maxGraphUploadRate == UNLIMITED)
			strBuffer=_T("UNLIMITED");
		else
			strBuffer.Format(_T("%s - %s"),CastItoXBytes((UINT)((thePrefs.maxGraphUploadRate*1024)/(((CSliderCtrl*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))->GetPos()+1))),CastItoXBytes((UINT)((thePrefs.maxGraphUploadRate*1024)/((CSliderCtrl*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))->GetPos())));
	}
	else
		strBuffer.Format(_T("%s - %s"),CastItoXBytes((UINT)((thePrefs.GetMaxUpload()*1024)/(((CSliderCtrl*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))->GetPos()+1))),CastItoXBytes((UINT)((thePrefs.GetMaxUpload()*1024)/((CSliderCtrl*)GetDlgItem(IDC_PRF_UP_SLOTCTRL_SLIDER))->GetPos())));
	GetDlgItem(IDC_PRF_UP_SLOTCTRL_DRPC)->SetWindowText(strBuffer);
}
// X-Ray :: SlotControl :: End
