//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PPg_X_GUI.h"
#include "opcodes.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "Log.h"
#include "emuleDlg.h" // X-Ray :: Toolbar
#include "Addons/IP2Country/IP2Country.h" // X-Ray :: IP2Country

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPg_X_GUI, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPg_X_GUI, CPropertyPage)
	ON_BN_CLICKED(IDC_PRF_GUI_MISC_CP_CHK, OnSettingsChange) // X-Ray :: ClientPercentage
	ON_BN_CLICKED(IDC_PRF_GUI_MISC_SDL_CHK, OnSettingsChange) // X-Ray :: SessionDownload
	// X-Ray :: Toolbar :: Start
	ON_BN_CLICKED(IDC_PRF_GUI_TB_HIDE_LBL, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_GUI_TB_SHOW_LBL, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_GUI_TB_ACTIVE_LBL, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_GUI_TB_MOVER_LBL, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_GUI_TB_ACTIVEMOVER_LBL, OnSettingsChange)
	// X-Ray :: Toolbar :: End
	// X-Ray :: IP2Country :: Start
	ON_BN_CLICKED(IDC_PRF_GUI_I2P_FLAGS_CHK, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_GUI_I2P_2LETTERS_RADIO, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_GUI_I2P_3LETTERS_RADIO, OnSettingsChange)
	ON_BN_CLICKED(IDC_PRF_GUI_I2P_FULL_RADIO, OnSettingsChange)
	// X-Ray :: IP2Country :: End
END_MESSAGE_MAP()

CPPg_X_GUI::CPPg_X_GUI()
	: CPropertyPage(CPPg_X_GUI::IDD)
{
}

CPPg_X_GUI::~CPPg_X_GUI()
{
}

void CPPg_X_GUI::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BOOL CPPg_X_GUI::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPg_X_GUI::OnApply()
{
	thePrefs.SetUseClientPercentage(IsDlgButtonChecked(IDC_PRF_GUI_MISC_CP_CHK) ? true : false); // X-Ray :: ClientPercentage
    thePrefs.SetUseSessionDownload(IsDlgButtonChecked(IDC_PRF_GUI_MISC_SDL_CHK) ? true : false); // X-Ray :: SessionDownload

	// X-Ray :: IP2Country :: Start
	thePrefs.SetIP2CountryShowFlag(IsDlgButtonChecked(IDC_PRF_GUI_I2P_FLAGS_CHK) ? true : false);
	if(IsDlgButtonChecked(IDC_PRF_GUI_I2P_2LETTERS_RADIO))
		thePrefs.SetIP2CountryNameMode(0);
	else if(IsDlgButtonChecked(IDC_PRF_GUI_I2P_3LETTERS_RADIO))
		thePrefs.SetIP2CountryNameMode(1);
	else if(IsDlgButtonChecked(IDC_PRF_GUI_I2P_FULL_RADIO))
		thePrefs.SetIP2CountryNameMode(2);
	else
		thePrefs.SetIP2CountryNameMode(2);

	if (!theApp.ip2country->IsIP2Country())
		theApp.ip2country->Load();
	theApp.ip2country->Refresh();
	// X-Ray :: IP2Country :: End

	// X-Ray :: Toolbar :: Start
	// switch for ToolbarLabels: 0: hide | 1: show | 2: show only active | 3: show on mouse over | 4: 2+3
	if(IsDlgButtonChecked(IDC_PRF_GUI_TB_HIDE_LBL))
		thePrefs.SetToolbarLabelStyle(0);
	else if(IsDlgButtonChecked(IDC_PRF_GUI_TB_SHOW_LBL))
		thePrefs.SetToolbarLabelStyle(1);
	else if(IsDlgButtonChecked(IDC_PRF_GUI_TB_ACTIVE_LBL))
		thePrefs.SetToolbarLabelStyle(2);
	else if(IsDlgButtonChecked(IDC_PRF_GUI_TB_MOVER_LBL))
		thePrefs.SetToolbarLabelStyle(3);
	else if(IsDlgButtonChecked(IDC_PRF_GUI_TB_ACTIVEMOVER_LBL))
		thePrefs.SetToolbarLabelStyle(4);
	else
		thePrefs.SetToolbarLabelStyle(1);
	theApp.emuledlg->InvalidateButtons();
	// X-Ray :: Toolbar :: End

	LoadSettings();
	return TRUE;
}

void CPPg_X_GUI::LoadSettings()
{
	CheckDlgButton(IDC_PRF_GUI_MISC_CP_CHK, thePrefs.GetUseClientPercentage()); // X-Ray :: ClientPercentage
	CheckDlgButton(IDC_PRF_GUI_MISC_SDL_CHK, thePrefs.GetUseSessionDownload()); // X-Ray :: SessionDownload

	// X-Ray :: IP2Country :: Start
	CheckDlgButton(IDC_PRF_GUI_I2P_FLAGS_CHK, thePrefs.IsIP2CountryShowFlag());
	uint8 m_uIP2CountryNameMode = thePrefs.GetIP2CountryNameMode();
	if(m_uIP2CountryNameMode == 0)
		CheckDlgButton(IDC_PRF_GUI_I2P_2LETTERS_RADIO, true);
	else if(m_uIP2CountryNameMode == 1)
		CheckDlgButton(IDC_PRF_GUI_I2P_3LETTERS_RADIO, true);
	else if(m_uIP2CountryNameMode == 2)
		CheckDlgButton(IDC_PRF_GUI_I2P_FULL_RADIO, true);
	else
		CheckDlgButton(IDC_PRF_GUI_I2P_FULL_RADIO, true);
	// X-Ray :: IP2Country :: End

	// X-Ray :: Toolbar :: Start
	// switch for ToolbarLabels: 0: hide | 1: show | 2: show only active | 3: show on mouse over | 4: 2+3
	uint8 m_uToolbarLabelStyle = thePrefs.GetToolbarLabelStyle();
	if(m_uToolbarLabelStyle == 0)
		CheckDlgButton(IDC_PRF_GUI_TB_HIDE_LBL, true);
	else if(m_uToolbarLabelStyle == 1)
		CheckDlgButton(IDC_PRF_GUI_TB_SHOW_LBL, true);
	else if(m_uToolbarLabelStyle == 2)
		CheckDlgButton(IDC_PRF_GUI_TB_ACTIVE_LBL, true);
	else if(m_uToolbarLabelStyle == 3)
		CheckDlgButton(IDC_PRF_GUI_TB_MOVER_LBL, true);
	else if(m_uToolbarLabelStyle == 4)
		CheckDlgButton(IDC_PRF_GUI_TB_ACTIVEMOVER_LBL, true);
	else
		CheckDlgButton(IDC_PRF_GUI_TB_SHOW_LBL, true);
	// X-Ray :: Toolbar :: End
}

void CPPg_X_GUI::Localize()
{
	if (m_hWnd)
	{
		GetDlgItem(IDC_PRF_GUI_MISC_GRP)->SetWindowText(GetResString(IDS_MISC));
		GetDlgItem(IDC_PRF_GUI_MISC_CP_CHK)->SetWindowText(GetResString(IDS_PRF_GUI_MISC_CP_CHK)); // X-Ray :: ClientPercentage
		GetDlgItem(IDC_PRF_GUI_MISC_SDL_CHK)->SetWindowText(GetResString(IDS_PRF_GUI_MISC_SDL_CHK)); // X-Ray :: SessionDownload
		// X-Ray :: IP2Country :: Start
		GetDlgItem(IDC_PRF_GUI_I2P_GRP)->SetWindowText(GetResString(IDS_PRF_GUI_I2P_GRP));
		GetDlgItem(IDC_PRF_GUI_I2P_FLAGS_CHK)->SetWindowText(GetResString(IDS_PRF_GUI_I2P_FLAGS_CHK));
		GetDlgItem(IDC_PRF_GUI_I2P_2LETTERS_RADIO)->SetWindowText(GetResString(IDS_PRF_GUI_I2P_2LETTERS_RADIO));
		GetDlgItem(IDC_PRF_GUI_I2P_3LETTERS_RADIO)->SetWindowText(GetResString(IDS_PRF_GUI_I2P_3LETTERS_RADIO));
		GetDlgItem(IDC_PRF_GUI_I2P_FULL_RADIO)->SetWindowText(GetResString(IDS_PRF_GUI_I2P_FULL_RADIO));
		// X-Ray :: IP2Country :: End
		// X-Ray :: Toolbar :: Start
		GetDlgItem(IDC_PRF_GUI_TOOLBAR_GRP)->SetWindowText(GetResString(IDS_PRF_GUI_TOOLBAR_GRP));
		GetDlgItem(IDC_PRF_GUI_TB_HIDE_LBL)->SetWindowText(GetResString(IDS_PRF_GUI_TB_HIDE_LBL));
		GetDlgItem(IDC_PRF_GUI_TB_SHOW_LBL)->SetWindowText(GetResString(IDS_PRF_GUI_TB_SHOW_LBL));
		GetDlgItem(IDC_PRF_GUI_TB_ACTIVE_LBL)->SetWindowText(GetResString(IDS_PRF_GUI_TB_ACTIVE_LBL));
		GetDlgItem(IDC_PRF_GUI_TB_MOVER_LBL)->SetWindowText(GetResString(IDS_PRF_GUI_TB_MOVER_LBL));
		GetDlgItem(IDC_PRF_GUI_TB_ACTIVEMOVER_LBL)->SetWindowText(GetResString(IDS_PRF_GUI_TB_ACTIVEMOVER_LBL));
		GetDlgItem(IDC_PRF_GUI_TB_LBL)->SetWindowText(GetResString(IDS_PRF_GUI_TB_LBL));
		// X-Ray :: Toolbar :: End
	}
}