//this file is part of eMule
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once

#include "ResizableLib/ResizableSheet.h"
#include "ListViewWalkerPropertySheet.h"
#include "ListViewWalkerPreferenceSheet.h"
#include "ResizableLib/ResizableDialog.h"

// CModelessDialog

class CModelessDialog : public CDialog {
	DECLARE_DYNAMIC(CModelessDialog)

public:
	CModelessDialog(UINT nIDTemplate, CWnd* pParent = NULL, BOOL bDeleteOnClose = TRUE);
	void OpenDialog();
	void CloseDialog();
	bool IsDialogOpen();

protected:
	virtual BOOL OnInitDialog();
	afx_msg void OnOK();
	afx_msg void OnCancel();
	afx_msg void PostNcDestroy();
	DECLARE_MESSAGE_MAP()

private:
	UINT			m_nIDTemplate;
	CWnd*			m_pParent;
	BOOL			m_bActive;
	BOOL			m_bDeleteOnClose;
};

// CModelessResizableDialog

class CModelessResizableDialog : public CResizableDialog {
	//DECLARE_DYNAMIC(CModelessResizableDialog)

public:
	CModelessResizableDialog(UINT nIDTemplate, CWnd* pParent = NULL, BOOL bDeleteOnClose = TRUE);
	void OpenDialog();
	void CloseDialog();
	bool IsDialogOpen();

protected:
	virtual BOOL OnInitDialog();
	afx_msg void OnOK();
	afx_msg void OnCancel();
	afx_msg void PostNcDestroy();
	DECLARE_MESSAGE_MAP()

private:
	UINT			m_nIDTemplate;
	CWnd*			m_pParent;
	BOOL			m_bActive;
	BOOL			m_bDeleteOnClose;
};


// CModelessResizableSheet

class CModelessResizableSheet : public CResizableSheet {
	DECLARE_DYNAMIC(CModelessResizableSheet)

public:
	CModelessResizableSheet(BOOL bDeleteOnClose = TRUE);
	void OpenDialog();
	void CloseDialog();
	bool IsDialogOpen();

protected:
	virtual BOOL OnInitDialog();
	afx_msg void OnOK();
	afx_msg void OnCancel();
	afx_msg void PostNcDestroy();
	DECLARE_MESSAGE_MAP()

private:
	BOOL			m_bActive;
	BOOL			m_bDeleteOnClose;
};



// CModelessPropertySheet

class CModelessPropertySheet : public CPropertySheet {
	DECLARE_DYNAMIC(CModelessPropertySheet)

public:
	CModelessPropertySheet(BOOL bDeleteOnClose = FALSE);
	void OpenDialog();
	void CloseDialog();
	bool IsDialogOpen();

protected:
	virtual BOOL OnInitDialog();
	afx_msg void OnOK();
	afx_msg void OnCancel();
	afx_msg void PostNcDestroy();
	DECLARE_MESSAGE_MAP()

private:
	BOOL			m_bActive;
	BOOL			m_bDeleteOnClose;
};




// CListViewWalkerModelessPropertySheet

class CListViewWalkerModelessPropertySheet : public CListViewWalkerPropertySheet {
	friend class CListViewWalkerModelessPropertySheetInterface;
	DECLARE_DYNAMIC(CListViewWalkerModelessPropertySheet)

public:
	CListViewWalkerModelessPropertySheet(CListCtrlItemWalk* pListCtrl, BOOL bDeleteOnClose = TRUE);
	~CListViewWalkerModelessPropertySheet();
	void OpenDialog();
	void CloseDialog();

	virtual BOOL PreTranslateMessage(MSG* pMsg);

	BOOL IsDialogOpen() { return m_bActive; } // X!
protected:
	void DeleteOnClose() { m_bDeleteOnClose = TRUE; } // X!

	virtual BOOL OnInitDialog();
	afx_msg void OnOK();
	afx_msg void OnCancel();
	afx_msg void PostNcDestroy();
	DECLARE_MESSAGE_MAP()

private:
	void RemoveData(CObject* toremove);
	BOOL m_bActive;
	BOOL m_bDeleteOnClose;
	CSimpleArray<CListViewWalkerModelessPropertySheetInterface*> m_interfaces;
};

// CListViewWalkerModelessPropertySheetInterface

class CListViewWalkerModelessPropertySheetInterface : public CObject {
	friend class CListViewWalkerModelessPropertySheet;
	DECLARE_DYNAMIC(CListViewWalkerModelessPropertySheetInterface)

public:
	CListViewWalkerModelessPropertySheetInterface(CObject* owner);
	~CListViewWalkerModelessPropertySheetInterface();
	bool IsDialogOpen() const;
	void DropControlHandle(CListCtrlItemWalk* pListCtrl = NULL);

protected:
	void OpenPropertySheet(const CSimpleArray<CListViewWalkerModelessPropertySheetInterface*>* paOthers, ...);
	virtual CListViewWalkerModelessPropertySheet* CreatePropertySheet(va_list) = 0;
	CObject* GetOwner() const;
	int GetPropertySheetCount() const;
	CListViewWalkerModelessPropertySheet* GetPropertySheet(int i) const;

private:
	CObject* m_owner;
	CSimpleArray<CListViewWalkerModelessPropertySheet*> m_propertySheets;
};




// CListViewWalkerModelessPreferenceSheet

class CListViewWalkerModelessPreferenceSheet : public CListViewWalkerPreferenceSheet {
	friend class CListViewWalkerModelessPreferenceSheetInterface;
	DECLARE_DYNAMIC(CListViewWalkerModelessPreferenceSheet)

public:
	CListViewWalkerModelessPreferenceSheet(CListCtrlItemWalk* pListCtrl, BOOL bDeleteOnClose = TRUE);
	~CListViewWalkerModelessPreferenceSheet();
	void OpenDialog();
	void CloseDialog();

	virtual BOOL PreTranslateMessage(MSG* pMsg);

protected:
	virtual BOOL OnInitDialog();
	afx_msg void OnOK();
	afx_msg void OnCancel();
	afx_msg void PostNcDestroy();
	DECLARE_MESSAGE_MAP()

private:
	void RemoveData(CObject* toremove);
	BOOL m_bActive;
	BOOL m_bDeleteOnClose;
	CSimpleArray<CListViewWalkerModelessPreferenceSheetInterface*> m_interfaces;
};

// CListViewWalkerModelessPreferenceSheetInterface

class CListViewWalkerModelessPreferenceSheetInterface : public CObject {
	friend class CListViewWalkerModelessPreferenceSheet;
	DECLARE_DYNAMIC(CListViewWalkerModelessPreferenceSheetInterface)

public:
	CListViewWalkerModelessPreferenceSheetInterface(CObject* owner);
	~CListViewWalkerModelessPreferenceSheetInterface();
	bool IsDialogOpen() const;
	void DropControlHandle(CListCtrlItemWalk* pListCtrl = NULL);

protected:
	void OpenPreferenceSheet(const CSimpleArray<CListViewWalkerModelessPreferenceSheetInterface*>* paOthers, ...);
	virtual CListViewWalkerModelessPreferenceSheet* CreatePreferencesSheet(va_list) = 0;
	CObject* GetOwner() const;
	int GetPreferencesSheetCount() const;
	CListViewWalkerModelessPreferenceSheet* GetPreferencesSheet(int i) const;

private:
	CObject* m_owner;
	CSimpleArray<CListViewWalkerModelessPreferenceSheet*> m_PreferencesSheets;
};