//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "HelpIDs.h"
#include "Opcodes.h"
#include "shellapi.h"
#include "Windows.h"
#include "ppgextra.h"
#include "IPFilter.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPgeXtra, CPropertyPage)

CPPgeXtra::CPPgeXtra()
	: CPropertyPage(CPPgeXtra::IDD)
{
}

CPPgeXtra::~CPPgeXtra()
{
}

void CPPgeXtra::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPPgeXtra, CPropertyPage)

	ON_WM_HELPINFO()
	ON_BN_CLICKED(IDC_EN_HOTKEY, OnBnClickedEnHotkey)
	ON_BN_CLICKED(IDC_CHECK1, OnBnClickedCheck1)
	ON_BN_CLICKED(IDC_CHECK2, OnBnClickedCheck2)
	ON_BN_CLICKED(IDC_CHECK3, OnBnClickedCheck3)
	ON_BN_CLICKED(IDC_CHECK4, OnBnClickedCheck4)
	ON_CBN_SELCHANGE(IDC_COMBOKEY, OnCbnSelchangeCombokey)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDERFDC, OnNMCustomdrawSliderfdc)
	ON_BN_CLICKED(IDC_SLOTFOCUS, OnBnClickedSlotfocus)
	ON_EN_CHANGE(IDC_EDITURL, OnEnChangeEditurl)
	ON_BN_CLICKED(IDC_HIDEFILTERS, OnBnClickedHidefilters)
	ON_EN_CHANGE(IDC_SEARCHPRESETEDIT, OnEnChangeSearchpresetedit)
	ON_BN_CLICKED(IDC_FDCTEA, OnBnClickedFdctea)
	ON_BN_CLICKED(IDC_IP30UPDATE, OnBnClickedIp30update)
END_MESSAGE_MAP()
// CPPgeXtra message handlers


BOOL CPPgeXtra::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);
	//[FDC]Start set max and min range for check parameter and pointer position
	fdcspos = 100 - thePrefs.FDCSensitivity;//convert the max percentage mismatch to percent match so the slider goes the right way
    CSliderCtrl* fdcslider = (CSliderCtrl*)GetDlgItem(IDC_SLIDERFDC);
	fdcslider->SetRange(6,30,false);//was SetRange(8,30,false) greater range default moved for 1.5a
	fdcslider->SetPos(fdcspos);
	b_localdoubleFDC = thePrefs.doubleFDC; //set double error state
	((CButton*)GetDlgItem(IDC_FDCTEA))->SetCheck(b_localdoubleFDC);//set enable state
	//[FDC]End set max and min range for check parameter

    //Get saved or default states
	key = thePrefs.hotkey_key;
	mod = thePrefs.hotkey_mod;
	enablestate = thePrefs.hotkey_enabled; //get enabled state
	((CButton*)GetDlgItem(IDC_EN_HOTKEY))->SetCheck(enablestate);//set enable state
	Localize();
	//Note: Localize has just set the hot keys check box state, 
	//So OnBnClickedEnHotkey retrieves it and sets the items enable state
	OnBnClickedEnHotkey();
	//[FDC] Start control enable state
	GetDlgItem(IDC_SLIDERFDC)->EnableWindow(thePrefs.BadNameCheck);
	GetDlgItem(IDC_STATIC_FDC)->EnableWindow(thePrefs.BadNameCheck);
	GetDlgItem(IDC_STATIC_LOW)->EnableWindow(thePrefs.BadNameCheck);
	GetDlgItem(IDC_STATIC_HIGH)->EnableWindow(thePrefs.BadNameCheck);
	GetDlgItem(IDC_FDCTEA)->EnableWindow(thePrefs.BadNameCheck);
	//[FDC] Start control enable state
    //set the checkbox/button state from the mod (hotkey_mod) variable. Note order as onscreen is check1,2,4,3
    CheckDlgButton(IDC_CHECK1, (mod & MOD_CONTROL) == MOD_CONTROL);
	CheckDlgButton(IDC_CHECK2, (mod & MOD_ALT) == MOD_ALT);
	CheckDlgButton(IDC_CHECK4, (mod & MOD_WIN) == MOD_WIN);
	CheckDlgButton(IDC_CHECK3, (mod & MOD_SHIFT) == MOD_SHIFT);
	((CComboBox*)GetDlgItem(IDC_COMBOKEY))->SetCurSel(key-65);

	//[IPUP] IP update
	GetDlgItem(IDC_EDITURL)->SetWindowText(thePrefs.urlandfile);
	urlinput = "";//[IPUP] IP update 
	b_localIPUP30 = thePrefs.IPUP30Auto; //New in version 2.0a
    ((CButton*)GetDlgItem(IDC_IP30UPDATE))->SetCheck(b_localIPUP30);//[IPUP] set auto update state new Ver 2.0a
	//[SF] Slot Focus
	uploadslotfocus = thePrefs.SlotFocus;//[SF] Slot Focus
	((CButton*)GetDlgItem(IDC_SLOTFOCUS))->SetCheck(uploadslotfocus);//[SF] Slot Focus
	//[PSF] Preset Search Filters
	b_localHideFiltersState = thePrefs.b_hideFiltersState; //[PSF] get hide filters state
	((CButton*)GetDlgItem(IDC_HIDEFILTERS))->SetCheck(b_localHideFiltersState);//[PSF] set hide filters state
	if(b_localHideFiltersState) GetDlgItem(IDC_SEARCHPRESETEDIT)->ShowWindow(SW_HIDE);//[PSF] Hide filters edit box
      else                      GetDlgItem(IDC_SEARCHPRESETEDIT)->ShowWindow(SW_SHOW);//[PSF] Show filters edit box
    localPresetFilters = thePrefs.PresetFilters;//[PSF] get existing filters
    GetDlgItem(IDC_SEARCHPRESETEDIT)->SetWindowText(localPresetFilters);
	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPgeXtra::OnApply()
{	/*Start Hotkey save code*/
    if(thePrefs.hotkey_enabled == false && enablestate == true)//Not enabled apply - enable
	  {
		thePrefs.hotkey_enabled = enablestate;
		RegisterHotKey(thePrefs.HideWnd, 0x1515, mod, key);
	   } else
	       if(thePrefs.hotkey_enabled == true && enablestate == false)//Enabled apply - disable
			 {
			   thePrefs.hotkey_enabled = enablestate;
			   UnregisterHotKey(thePrefs.HideWnd, 0x1515);
			  } else //Hidden is enabled and hot keys have been changed
				  if(thePrefs.hotkey_enabled == true && (thePrefs.hotkey_key != key || thePrefs.hotkey_mod != mod))
		            {	//Unregister the old sequence
						UnregisterHotKey(thePrefs.HideWnd, 0x1515);
						//Register new sequence
						RegisterHotKey(thePrefs.HideWnd, 0x1515, mod, key);
	 				 }
    //SAVE and changes made, if none the no harm done
    thePrefs.hotkey_mod = mod;
    thePrefs.hotkey_key = key;
    /*End Hotkey save code*/
    //[FDC] Save settting, get convert and save.
	thePrefs.FDCSensitivity = 100 - fdcspos;
	thePrefs.doubleFDC = b_localdoubleFDC;//save double error state
	//[SF]  Slot Focus
	thePrefs.SlotFocus = uploadslotfocus;
	//[PSF] Preset Search Filters save hide state
	thePrefs.b_hideFiltersState = b_localHideFiltersState;
	thePrefs.PresetFilters = localPresetFilters;

    //[IPUP] IP update 
	thePrefs.IPUP30Auto = b_localIPUP30; //New in version 2.0a

	if(urlinput)
	  {
	   //make lower case
	   CString ipfiltername(DFLT_IPFILTER_FILENAME);
       ipfiltername.MakeLower();
	   CString ipnamegz = ipfiltername + _T(".gz");
	   urlinput.MakeLower();
	   CString ext1 = urlinput.Right(4);//get the last four characters
	   CString ext2 = urlinput.Right(ipfiltername.GetLength());//get the fiter file name characters len
   	   CString ext3 = urlinput.Right(ipnamegz.GetLength());//get the fiter file name characters len + .gz 

	   //is this a valid target file
	   if(ext1==_T(".zip") || ext2==ipfiltername || ext3==ipnamegz)
	    {
	     //fix missing protocol
		 ext1 = urlinput.Left(7);
         ext2 = CString("http://");
         if(ext1!=ext2)
	       {
            CString temp(urlinput);
		    urlinput = ext2 + temp;
		    }
         //update preferences
         thePrefs.urlandfile = urlinput;
	    }
	   }
	urlinput = "";
	SetModified(TRUE);
	return CPropertyPage::OnApply();
}

void CPPgeXtra::Localize(void)
{
	if(m_hWnd)
	{//Set dialog text
	 GetDlgItem(IDC_EN_HOTKEY)->SetWindowText(GetResString(IDS_EN_HOTKEY));
	 GetDlgItem(IDC_HOTKEY)->SetWindowText(GetResString(IDS_HOTKEY));
	 //[FDC] Set dialog text for FDC sensitivity slider
	 GetDlgItem(IDC_STATIC_FDC)->SetWindowText(GetResString(IDS_FDC_SENSITIVITY));
	 GetDlgItem(IDC_STATIC_LOW)->SetWindowText(GetResString(IDS_PRIOLOW));//reused string table entry
	 GetDlgItem(IDC_STATIC_HIGH)->SetWindowText(GetResString(IDS_PRIOHIGH));//reused string table entry
	 GetDlgItem(IDC_FDCTEA)->SetWindowText(GetResString(IDS_FCDTEA));
	 //[SF] Slot Focus
	 GetDlgItem(IDC_SLOTFOCUS)->SetWindowText(GetResString(IDS_SLOTFOCUS));
	 //[IPUP] IP update 
 	 GetDlgItem(IDC_STATIC_FILTERFILES)->SetWindowText(GetResString(IDS_STATIC_FILTERFILES));
	 GetDlgItem(IDC_STATIC_IPUPDATE)->SetWindowText(GetResString(IDS_STATIC_IPUPDATE));
	 GetDlgItem(IDC_IP30UPDATE)->SetWindowText(GetResString(IDS_IP30UPDATE));
	 //[PSF] Preset Search Filters
	 GetDlgItem(IDC_HIDEFILTERS)->SetWindowText(GetResString(IDS_HIDEFILTERS));
	 GetDlgItem(IDC_SEARCHPRESETTITLE)->SetWindowText(GetResString(IDS_SEARCHPRESETTITLE));
 	}
}


void CPPgeXtra::OnHelp()
{
//	theApp.ShowHelp(eMule_FAQ_Preferences_VS);
}

BOOL CPPgeXtra::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CPPgeXtra::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}


void CPPgeXtra::OnBnClickedEnHotkey()
{
    //Get enabled disabled state
    enablestate =(IsDlgButtonChecked(IDC_EN_HOTKEY)!=0);
   
	//Toggle hot keys selection controls state
	GetDlgItem(IDC_HOTKEY)->EnableWindow(enablestate);
	GetDlgItem(IDC_CHECK1)->EnableWindow(enablestate);
	GetDlgItem(IDC_CHECK2)->EnableWindow(enablestate);
	GetDlgItem(IDC_CHECK3)->EnableWindow(enablestate);
	GetDlgItem(IDC_CHECK4)->EnableWindow(enablestate);
	SetModified(TRUE);
}

void CPPgeXtra::OnBnClickedCheck1()
{//Ctrl
 if(IsDlgButtonChecked(IDC_CHECK1)) mod |= MOD_CONTROL;//02
   else mod &= 0xfffd;
 SetModified(TRUE);
}

void CPPgeXtra::OnBnClickedCheck2()
{//Alt
 if(IsDlgButtonChecked(IDC_CHECK2)) mod |= MOD_ALT;//01
   else mod &= 0xfffe;
 SetModified(TRUE);
}

void CPPgeXtra::OnBnClickedCheck4()
{//Win
 if(IsDlgButtonChecked(IDC_CHECK4)) mod |= MOD_WIN;//08
   else mod &= 0xfff7;
 SetModified(TRUE);
}

void CPPgeXtra::OnBnClickedCheck3()
{//Shift
 if(IsDlgButtonChecked(IDC_CHECK3)) mod |= MOD_SHIFT;//04
   else mod &= 0xfffb;
 SetModified(TRUE);	
}

void CPPgeXtra::OnCbnSelchangeCombokey()
{//Get Letter Key
 CString strLetter;
 GetDlgItem(IDC_COMBOKEY)->GetWindowText(strLetter);
 key=(int)strLetter[0];
 SetModified(TRUE);
}

/*[FDC] check slider position on redraw*/
void CPPgeXtra::OnNMCustomdrawSliderfdc(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	// [FDC] get slider position
	int newpos = ((CSliderCtrl*)GetDlgItem(IDC_SLIDERFDC))->GetPos();
	if(newpos!=fdcspos){//store new position and set modified to enable apply
						fdcspos = newpos;
						SetModified(TRUE);
	                    }
	*pResult = 0;
}


/*[SF] Slot Focus*/
void CPPgeXtra::OnBnClickedSlotfocus()
{
  //Get enabled disabled state
  uploadslotfocus =(IsDlgButtonChecked(IDC_SLOTFOCUS)!=0);
  SetModified(TRUE);
}

/*[IPUP] IP update - URL entered here*/
void CPPgeXtra::OnEnChangeEditurl()
{//Get inputed URL
 GetDlgItem(IDC_EDITURL)->GetWindowText(urlinput);
 SetModified(TRUE);
}

/*[PSF] Preset Search Filters Hide/Unhide filters checkbox*/
void CPPgeXtra::OnBnClickedHidefilters()
{//get hide un-hide state
  b_localHideFiltersState =(IsDlgButtonChecked(IDC_HIDEFILTERS)!=0);
  //((CRichEditCtrl*)GetDlgItem(IDC_SEARCHPRESETEDIT))->HideSelection(b_localHideFiltersState, TRUE);
  if(b_localHideFiltersState) GetDlgItem(IDC_SEARCHPRESETEDIT)->ShowWindow(SW_HIDE);
   else GetDlgItem(IDC_SEARCHPRESETEDIT)->ShowWindow(SW_SHOW);
  SetModified(TRUE);	  
}

/*[PSF] Preset Search Filters - get filter text*/
void CPPgeXtra::OnEnChangeSearchpresetedit()
{//Get filter text
 GetDlgItem(IDC_SEARCHPRESETEDIT)->GetWindowText(localPresetFilters);
 SetModified(TRUE);
}

/*[FDC] 2 bad names for alert*/
void CPPgeXtra::OnBnClickedFdctea()
{//get 2 bad names checkbox state
 b_localdoubleFDC =(IsDlgButtonChecked(IDC_FDCTEA)!=0);
 SetModified(TRUE);
}

/*[IPUP] Ver2.0a onward Update every 30 days*/
void CPPgeXtra::OnBnClickedIp30update()
{//get auto-IPFilter Update
 b_localIPUP30 =(IsDlgButtonChecked(IDC_IP30UPDATE)!=0);
 SetModified(TRUE);
}
