//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "HelpIDs.h"
#include "Opcodes.h"
#include "shellapi.h"
#include "Windows.h"
#include "PPgVS.h"



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPgVS, CPropertyPage)

/*Stores 'program files' directory for AV path*/
CString CPPgVS::ProgramFilesPath("");

CPPgVS::CPPgVS()
	: CPropertyPage(CPPgVS::IDD)
{
}

CPPgVS::~CPPgVS()
{
}

void CPPgVS::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPPgVS, CPropertyPage)

	ON_WM_HELPINFO()
	ON_BN_CLICKED(IDC_ENABLEVS, OnBnClickedEnablevs)
	ON_CBN_SELCHANGE(IDC_VIRUSSCANNERTYPE, OnCbnSelchangeVirusscannertype)
	ON_EN_CHANGE(IDC_VSEDIT1, OnEnChangeVsedit1)
	ON_EN_CHANGE(IDC_VSEDIT2, OnEnChangeVsedit2)
	ON_EN_CHANGE(IDC_VSEDIT3, OnEnChangeVsedit3)
	ON_BN_CLICKED(IDC_VSRADIO1, OnBnClickedVsradio1)
	ON_BN_CLICKED(IDC_VSRADIO2, OnBnClickedVsradio2)
	ON_BN_CLICKED(IDC_VSRADIO3, OnBnClickedVsradio3)
	ON_BN_CLICKED(IDC_BROWSE, OnBnClickedBrowse)
	ON_BN_CLICKED(IDC_TEST, OnBnClickedTest)
END_MESSAGE_MAP()


// CPPgVS message handlers

BOOL CPPgVS::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	LoadSettings();
	Localize();

	//Get a valid 'program files' directory name, 'new' for version 1.2a
	HKEY hKey;
	BYTE Buffer[MAX_PATH];
	long RetVal;
	DWORD BufferSize = MAX_PATH;
	//Open registry key return 0L = ERROR_SUCCESS on sucess.
	RetVal = RegOpenKeyEx(HKEY_LOCAL_MACHINE,TEXT("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\"), 0, KEY_READ, &hKey);
	if(RetVal==ERROR_SUCCESS) //Key succesfully opened
	   { //Read registry value
		 RegQueryValueEx( hKey,                    //HKEY hKey,
						  TEXT("ProgramFilesDir"), //LPCTSTR lpValueName,
						  NULL,				       //LPDWORD lpReserved,
						  NULL,				       //LPDWORD lpType,
						  (LPBYTE)Buffer,		   //LPBYTE lpData,
						  &BufferSize);		       //LPDWORD lpcbData);
		 //Close Key
		 RegCloseKey(hKey);
		 //Copy registry value to use in virus scanner paths
		 ProgramFilesPath = CString((TCHAR*)Buffer); 
		 //If we have a value for 'Program files' we're done, return
		 if(!ProgramFilesPath.IsEmpty()) return TRUE;// #
	   }
  //If any of the above code fails and ProgramFilesPath has no value assign the English value as Default.
  ProgramFilesPath = CString(_T("C:\\Program Files"));

	return TRUE;  // # return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgVS::LoadSettings(void)
{	//Loads settings for preferences
	CString strVStype;

    ((CComboBox*)GetDlgItem(IDC_VIRUSSCANNERTYPE))->SetCurSel(thePrefs.virusscannertype);
	((CButton*)GetDlgItem(IDC_ENABLEVS))->SetCheck(thePrefs.virusscannerenabled);
	if(thePrefs.virusscanradio==3) CheckDlgButton(IDC_VSRADIO3, true);
	  else if(thePrefs.virusscanradio==2) CheckDlgButton(IDC_VSRADIO2, true);
	          else CheckDlgButton(IDC_VSRADIO1, true);

	//Toggle virus scanner selection controls
	GetDlgItem(IDC_VIRUSSCANNER_LBL)->EnableWindow(thePrefs.virusscannerenabled);
	GetDlgItem(IDC_VIRUSSCANNERTYPE)->EnableWindow(thePrefs.virusscannerenabled);
	GetDlgItem(IDC_VIRUSSCANNERTYPE)->GetWindowText(strVStype); 
	if(strVStype=="Other")
	  {	
		GetDlgItem(IDC_VSEDIT1)->SetWindowText(thePrefs.virusscanner);
		GetDlgItem(IDC_VSEDIT2)->SetWindowText(thePrefs.virusscanprefilesw);
		GetDlgItem(IDC_VSEDIT3)->SetWindowText(thePrefs.virusscanswitches);
	  }

	OnBnClickedEnablevs();
	SetModified(FALSE);
}

BOOL CPPgVS::OnApply()
{	
	CString strVStype;
	//backup values added 1.4g 
	CString vstbackup    = thePrefs.virusscanner;
	CString vsprebackup  = thePrefs.virusscanprefilesw;
    CString vspostbackup = thePrefs.virusscanswitches;
    int     vstypeno     = thePrefs.virusscannertype;
    thePrefs.virusscannerenabled = b_scannerEnabled;//fix for 1.5b
	GetDlgItem(IDC_VIRUSSCANNERTYPE)->GetWindowText(strVStype);
	thePrefs.virusscannertype = ((CComboBox*)GetDlgItem(IDC_VIRUSSCANNERTYPE))->GetCurSel();//get the new scanner (list number)
    thePrefs.virusscanprefilesw.Empty();//empty here so no need to set to empty in each switch statement when unused
	thePrefs.virusscanswitches.Empty();//empty here so no need to set to empty in each switch statement when unused
    if(IsDlgButtonChecked(IDC_VSRADIO3))         thePrefs.virusscanradio=3;//check box 3 selected "delete"
	   else if(IsDlgButtonChecked(IDC_VSRADIO2)) thePrefs.virusscanradio=2;//check box 2 selected "clean/delete"
				else                             thePrefs.virusscanradio=1;//check mox 1 selected "scan only"
	//Note: "ProgramFilesPath" is a CString conaining the name of 'program files' folder retrieved from the system registry
	//  eg: in Germany 'program files' is 'programme'

      if(strVStype=="F-Prot")
       {//f-prot use the NT/2K/XP command line scanner as more FP-Win will not run more than one instance!
	   	thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\FSI\\F-Prot\\fpcmd.exe"));/*Tested*/
	    if(!VerifyPath(true)){//restore previous settings
                               thePrefs.virusscanner       = vstbackup;
		                       thePrefs.virusscanprefilesw = vsprebackup;
                               thePrefs.virusscanswitches  = vspostbackup;
							   thePrefs.virusscannertype   = vstypeno;
							   return CPropertyPage::OnApply();
		                      }
        // -page pauses to show sucessive pages, it is the only way to make fpcmd show a report for scan only
        if(thePrefs.virusscanradio==1)  thePrefs.virusscanswitches = "-archive=10 -packed -page";
	     else
			if(thePrefs.virusscanradio==2)  thePrefs.virusscanswitches = "-archive=10 -packed -disinf -auto";
			 else thePrefs.virusscanswitches = "-archive=10 -packed -delete -auto";
	   } 
	    else
      if(strVStype=="AVG7" || strVStype=="AVG6") 
	   {//avg doesn't disinffect inside arc doesn't see lha's
        if(strVStype=="AVG6") thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\Grisoft\\AVG6\\avgscan.exe"));
	     else thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\Grisoft\\AVG7\\avgscan.exe")); /*Tested*/
	    if(!VerifyPath(true)){//restore previous settings
                              thePrefs.virusscanner       = vstbackup;
		                      thePrefs.virusscanprefilesw = vsprebackup;
                              thePrefs.virusscanswitches  = vspostbackup;
							  thePrefs.virusscannertype   = vstypeno;
							  return CPropertyPage::OnApply();
		                     }										
     /*  if(thePrefs.virusscanradio==1)  thePrefs.virusscanswitches = "/arc /rt /noboot /stoplevel=1";//stoplevel is used for scan only so the user has chance to see infections - but it *does not work*!!!!
	      else*/
			if(thePrefs.virusscanradio==2)  thePrefs.virusscanswitches = "/clean /arc /rt /noboot";
			 else thePrefs.virusscanswitches = "/trash /arc /rt /noboot";
	   } 
	    else
	   if(strVStype=="Sophos")
	    {//Sophos doesn't see lha's switches nc=no comment di=disinffect f=full scan
		 thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\Sophos SWEEP for NT\\sav32cli.exe"));/*Tested*/
	     if(!VerifyPath(true)){//restore previous settings
                               thePrefs.virusscanner       = vstbackup;
		                       thePrefs.virusscanprefilesw = vsprebackup;
                               thePrefs.virusscanswitches  = vspostbackup;
							   thePrefs.virusscannertype   = vstypeno;			   				  
							   return CPropertyPage::OnApply();
		                       }                       
       if(thePrefs.virusscanradio==1)  thePrefs.virusscanswitches = "-archive -c -di -remove -f -nmbr";//Only way to make it pause is to run for disinfect/remove and ask for a prompt
	    else
			if(thePrefs.virusscanradio==2)  thePrefs.virusscanswitches = "-archive -di -nc -di -f -nmbr";
			 else thePrefs.virusscanswitches = "-archive -remove -nc -f -nmbr";
	   } 
	    else
	  if(strVStype=="Norton")
	   {
		  thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\Norton AntiVirus\\navw32.exe"));/*Tested*/
	      if(!VerifyPath(true)){//restore previous settings
                                thePrefs.virusscanner       = vstbackup;
		                        thePrefs.virusscanprefilesw = vsprebackup;
                                thePrefs.virusscanswitches  = vspostbackup;
			   				    thePrefs.virusscannertype   = vstypeno;
							    return CPropertyPage::OnApply();
		                       } 
          thePrefs.virusscanswitches = "-b";//Norton's command line does not allow action to be specified
	    } 
	      else
	   if(strVStype=="ZoneAlarm")
	    {
		 thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\Zone Labs\\ZoneAlarm\\multiscan.exe"));/*Tested*/
	     if(!VerifyPath(true)){//restore previous settings
                               thePrefs.virusscanner       = vstbackup;
		                       thePrefs.virusscanprefilesw = vsprebackup;
                               thePrefs.virusscanswitches  = vspostbackup;
							   thePrefs.virusscannertype   = vstypeno;
			   				   return CPropertyPage::OnApply();
		                      } 
		 //ZoneAlarm command line does not allow action to be specified (added 1.3a)
	    }
	      else
	   if(strVStype=="Kaspersky Personal")
	    {
		 thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\Kaspersky Lab\\Kaspersky Anti-Virus Personal\\kav.exe"));
		 if(!VerifyPath(false)){
			thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\Kaspersky Lab\\Kaspersky Anti-Virus Personal Pro\\kav.exe"));
	        if(!VerifyPath(true)){//restore previous settings
                                  thePrefs.virusscanner       = vstbackup;
		                          thePrefs.virusscanprefilesw = vsprebackup;
                                  thePrefs.virusscanswitches  = vspostbackup;
			   				      thePrefs.virusscannertype   = vstypeno;
								  return CPropertyPage::OnApply();
		                          } 
		    }
         thePrefs.virusscanswitches = "/wait";//Kaspersky's command line does not allow action to be specified
	    }
	      else
	   if(strVStype=="McAfee")
	    {//McAfee detects other AV products on installation and will not install unless you let it remove them!!!! Asking is one thing....mandating another! Option untested.
		 thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\Common Files\\Network Associates\\On Demand Scanner\\Scan32\\scan32.exe"));/*UnTested*/
	     if(!VerifyPath(true)){//restore previous settings
                               thePrefs.virusscanner       = vstbackup;
		                       thePrefs.virusscanprefilesw = vsprebackup;
                               thePrefs.virusscanswitches  = vspostbackup;
			   				   thePrefs.virusscannertype   = vstypeno;
							   return CPropertyPage::OnApply();
		                      } 
        //note for McAfee the post file switches are blank
		if(thePrefs.virusscanradio==1)  thePrefs.virusscanprefilesw ="/noboot /autoscan /autoexit /comp /continue /uiexonly"; 
	    else if(thePrefs.virusscanradio==2)  thePrefs.virusscanprefilesw ="/noboot /autoscan /autoexit /comp /clean /uiexonly"; 
			   else thePrefs.virusscanprefilesw ="/noboot /autoscan /autoexit /comp /delete /uiexonly"; 
	   }
	     else
	   if(strVStype=="AntiVir")
	    {//Antivir a very impressive free AV prog! it's command line options are before the file name!
		 thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\AVPersonal\\AVNT.EXE"));/*Tested*/
	     if(!VerifyPath(false)){//check for new free version
		                        thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\AntiVir PersonalEdition Classic\\avcmd.exe"));/*Tested - new path and exe for version 7 of antivir*/
								if(!VerifyPath(false)){//check for new "pay for" version
									                    thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\AntiVir PersonalEdition Premium\\avcmd.exe"));/*new path and exe for premium version 7 of antivir*/
	                                                    if(!VerifyPath(true)){//restore previous settings
                                                                               thePrefs.virusscanner       = vstbackup;
		                                                                       thePrefs.virusscanprefilesw = vsprebackup;
                                                                               thePrefs.virusscanswitches  = vspostbackup;
			   				                                                   thePrefs.virusscannertype   = vstypeno;
								                                               return CPropertyPage::OnApply();
		                                                                      }
								                       }
		    }
	
		thePrefs.virusscanswitches = ""; //note for Antivir the post file switches are blank
		if(thePrefs.virusscanradio==1)  thePrefs.virusscanprefilesw ="-allfiles -z -noboot"; 
	    else if(thePrefs.virusscanradio==2)  thePrefs.virusscanprefilesw ="-allfiles -z -e -noboot"; 
			   else thePrefs.virusscanprefilesw ="-allfiles -z -del -dmdel -noboot"; //delete and delete all macros if one is bad
	   } 
	     else
	   if(strVStype=="BitDefender")
	    {//BitDefender - It has a free version available
		 thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\Common Files\\Softwin\\BitDefender Scan Server\\bdc.exe"));/*Tested*/
	     if(!VerifyPath(true)){//restore previous settings
                               thePrefs.virusscanner       = vstbackup;
		                       thePrefs.virusscanprefilesw = vsprebackup;
                               thePrefs.virusscanswitches  = vspostbackup;
			   				   thePrefs.virusscannertype   = vstypeno;
							   return CPropertyPage::OnApply();
		                      } 	
		if(thePrefs.virusscanradio==1)  thePrefs.virusscanswitches ="/files /arc /prompt"; 
	    else if(thePrefs.virusscanradio==2)  thePrefs.virusscanswitches ="/dis /files /arc"; 
			   else thePrefs.virusscanswitches ="/del /files /arc";
	   }
	     else
	   if(strVStype=="Eset NOD32")
	    {//Eset :) (Isis)  
		 thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\ESET\\nod32.exe"));/*Tested*/
	     if(!VerifyPath(true)){//restore previous settings
                               thePrefs.virusscanner       = vstbackup;
		                       thePrefs.virusscanprefilesw = vsprebackup;
                               thePrefs.virusscanswitches  = vspostbackup;
			   				   thePrefs.virusscannertype   = vstypeno;
							   return CPropertyPage::OnApply();
		                      } 
		if(thePrefs.virusscanradio==1)  thePrefs.virusscanswitches ="/scanfile+ /arch+ /pack+ /sfx+ /scanmbr- /scanboot- /adware /unsafe /all"; 
	    else if(thePrefs.virusscanradio==2)  thePrefs.virusscanswitches ="/cleanmode /clean /delete /scanfile+ /arch+ /pack+ /sfx+ /scanmbr- /scanboot- /adware /unsafe /all"; 
			   else thePrefs.virusscanswitches ="/cleanmode /delete /scanfile+ /arch+ /pack+ /sfx+ /scanmbr- /scanboot- /adware /unsafe /all";
	   } 
	     else
	   if(strVStype=="Norman")
	    {//Norman
		 thePrefs.virusscanner = "C:\\Norman\\Nvc\\Bin\\nvcc.exe";/*Tested*/
	     if(!VerifyPath(true)){//restore previous settings
                               thePrefs.virusscanner       = vstbackup;
		                       thePrefs.virusscanprefilesw = vsprebackup;
                               thePrefs.virusscanswitches  = vspostbackup;
							   thePrefs.virusscannertype   = vstypeno;
			   				   return CPropertyPage::OnApply();
		                      } 
		if(thePrefs.virusscanradio==1)  thePrefs.virusscanswitches ="/bs- /cp /c"; 
		  else thePrefs.virusscanswitches ="/bs- /cp /cl:2 /c /u";//u do not stop/prompt
	   }
	    else
	   if(strVStype=="Comodo")
	    {//Comodo - C:\Program Files\Comodo\Comodo AntiVirus
         thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\Comodo\\Comodo AntiVirus\\CAVSCons.exe"));/*Tested*/
	     if(!VerifyPath(true)){//restore previous settings
                               thePrefs.virusscanner       = vstbackup;
		                       thePrefs.virusscanprefilesw = vsprebackup;
                               thePrefs.virusscanswitches  = vspostbackup;
							   thePrefs.virusscannertype   = vstypeno;
			   				   return CPropertyPage::OnApply();
		                      } 
		if(thePrefs.virusscanradio==2) thePrefs.virusscanprefilesw ="/D";//Disinfect
	   }
	     else 
	   if(strVStype=="eTrust EZ")
	    {//eTrust EZ Antivirus added 1.4a fixed in ver 1.4g
		 thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\CA\\eTrust EZ Armor\\eTrust EZ Antivirus\\vet32.exe"));/*Tested*/
	     if(!VerifyPath(true)){//restore previous settings
                               thePrefs.virusscanner       = vstbackup;
		                       thePrefs.virusscanprefilesw = vsprebackup;
                               thePrefs.virusscanswitches  = vspostbackup;
							   thePrefs.virusscannertype   = vstypeno;
			   				   return CPropertyPage::OnApply();
		                      } 
		if(thePrefs.virusscanradio==1)  thePrefs.virusscanswitches ="/nobootscan /compressed /infect=reportonly";// /exit would exit even if it's found something, not good if no remeadial action is specified
	    else if(thePrefs.virusscanradio==2)  thePrefs.virusscanswitches ="/nobootscan /compressed /exit /infect=clean /uncleanable=rename"; 
		       else thePrefs.virusscanswitches ="/nobootscan /compressed /exit /infect=delete"; 
	   } 
	     else
	   if(strVStype=="Avast! 4 Pro")
	    {//aVast! Pro (4.6) Antivirus added 1.4g
		 thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\Alwil Software\\Avast4pro\\ashCmd.exe"));/*Tested*/
	     if(!VerifyPath(true)){//restore previous settings
                               thePrefs.virusscanner       = vstbackup;
		                       thePrefs.virusscanprefilesw = vsprebackup;
                               thePrefs.virusscanswitches  = vspostbackup;
							   thePrefs.virusscannertype   = vstypeno;
			   				   return CPropertyPage::OnApply();
		                      } 
		if(thePrefs.virusscanradio==1)  thePrefs.virusscanswitches ="/a /c /t=A /s";
	    else                             thePrefs.virusscanswitches ="/a /c /p=1 /t=A /s"; 
	   }
	     else
	   if(strVStype=="Avast! 4 Home")
	    {
		 thePrefs.virusscanner = ProgramFilesPath + CString(_T("\\Alwil Software\\Avast4\\ashQuick.exe"));/*Tested*/
	     if(!VerifyPath(true)){//restore previous settings
                               thePrefs.virusscanner       = vstbackup;
		                       thePrefs.virusscanprefilesw = vsprebackup;
                               thePrefs.virusscanswitches  = vspostbackup;
							   thePrefs.virusscannertype   = vstypeno;
			   				   return CPropertyPage::OnApply();
		                      } 
		 //Avast! Home does not come with a command line scanner
	    } else 
			if(strVStype=="Other") {
			                       GetDlgItem(IDC_VSEDIT1)->GetWindowText(thePrefs.virusscanner);
			                       GetDlgItem(IDC_VSEDIT2)->GetWindowText(thePrefs.virusscanprefilesw);
			                       GetDlgItem(IDC_VSEDIT3)->GetWindowText(thePrefs.virusscanswitches);
			                       if(INVALID_FILE_ATTRIBUTES==GetFileAttributes((LPCTSTR)thePrefs.virusscanner) && thePrefs.virusscannerenabled)  //Spe64 fix 
								    {
			                         ::MessageBox(m_hWnd, _T("Path or Filename incorrect."),_T("Virus Scanner.") , MB_ICONSTOP | MB_OK);
                                    } else {//Check file is an executable not a batch file written to move files from incomming etc.
								            int chrpos = thePrefs.virusscanner.ReverseFind(_T('.'));
										    CString Filetype=thePrefs.virusscanner.Mid( chrpos+1,3);
										    if(Filetype.CompareNoCase(_T("exe"))!=0 && Filetype.CompareNoCase(_T("com"))!=0 && Filetype.CompareNoCase(_T("bin"))!=0 )
										     {
											  thePrefs.virusscanner  = "";
											  ::MessageBox(m_hWnd, _T("Executables only please!"),_T("Virus Scanner.") , MB_ICONSTOP | MB_OK);
										      } 
										    }
			}

	SetModified(TRUE);
	return CPropertyPage::OnApply();
}

void CPPgVS::Localize(void)
{
	if(m_hWnd)
	{//Set dialog text
 	 GetDlgItem(IDC_ENABLEVS)->SetWindowText(GetResString(IDS_ENABLEVS));
	 GetDlgItem(IDC_VIRUSSCANNER_LBL)->SetWindowText(GetResString(IDS_VIRUSSCANNER_LBL));
	 GetDlgItem(IDC_VSRADIO1)->SetWindowText(GetResString(IDS_VSRADIO1));
	 GetDlgItem(IDC_VSRADIO2)->SetWindowText(GetResString(IDS_VSRADIO2));
	 GetDlgItem(IDC_VSRADIO3)->SetWindowText(GetResString(IDS_VSRADIO3));
	 GetDlgItem(IDC_OTHERVS_LBL)->SetWindowText(GetResString(IDS_OTHERVS_LBL));
	 GetDlgItem(IDC_VSPATH)->SetWindowText(GetResString(IDS_VSPATH));
	 GetDlgItem(IDC_VSPREFSW)->SetWindowText(GetResString(IDS_VSPREFSW));
	 GetDlgItem(IDC_SW)->SetWindowText(GetResString(IDS_SW));
	 GetDlgItem(IDC_TEST)->SetWindowText(GetResString(IDS_TEST));
	 GetDlgItem(IDC_BROWSE)->SetWindowText(GetResString(IDS_BROWSE));
     }
}

void CPPgVS::OnHelp()
{
//	theApp.ShowHelp(eMule_FAQ_Preferences_VS);
}

BOOL CPPgVS::OnCommand(WPARAM wParam, LPARAM lParam)
{
	if (wParam == ID_HELP)
	{
		OnHelp();
		return TRUE;
	}
	return __super::OnCommand(wParam, lParam);
}

BOOL CPPgVS::OnHelpInfo(HELPINFO* /*pHelpInfo*/)
{
	OnHelp();
	return TRUE;
}

void CPPgVS::OnBnClickedEnablevs()
{
	// If checked enable virus scan config
	b_scannerEnabled = (IsDlgButtonChecked(IDC_ENABLEVS)!=0);//Fixed in 1.5b
   
	//Toggle virus scanner selection controls
	GetDlgItem(IDC_VIRUSSCANNER_LBL)->EnableWindow(b_scannerEnabled);//Fixed in 1.5b
	GetDlgItem(IDC_VIRUSSCANNERTYPE)->EnableWindow(b_scannerEnabled);//Fixed in 1.5b
	
	if(!b_scannerEnabled) {//Fixed in 1.5b
	  GetDlgItem(IDC_VSRADIO1)->EnableWindow(false);
	  GetDlgItem(IDC_VSRADIO2)->EnableWindow(false);
	  GetDlgItem(IDC_VSRADIO3)->EnableWindow(false);
	  GetDlgItem(IDC_OTHERVS_LBL)->EnableWindow(false);
	  GetDlgItem(IDC_VSPATH)->EnableWindow(false);
	  GetDlgItem(IDC_VSEDIT1)->EnableWindow(false);
	  GetDlgItem(IDC_VSEDIT2)->EnableWindow(false);
	  GetDlgItem(IDC_VSEDIT3)->EnableWindow(false);
	  GetDlgItem(IDC_VSPREFSW)->EnableWindow(false);
	  GetDlgItem(IDC_SW)->EnableWindow(false);
	  GetDlgItem(IDC_TEST)->EnableWindow(false);
	  GetDlgItem(IDC_BROWSE)->EnableWindow(false);
	  } else OnCbnSelchangeVirusscannertype();//because setting vary depending on the selected scanner

	SetModified(TRUE);
}

void CPPgVS::OnCbnSelchangeVirusscannertype()
{
	CString strVStype;
	bool EnableDisabled;

	GetDlgItem(IDC_VIRUSSCANNERTYPE)->GetWindowText(strVStype);

	if(strVStype=="ZoneAlarm" || strVStype=="Avast! 4 Home" || strVStype=="Kaspersky Personal" || strVStype=="Norton" || strVStype=="Other" || strVStype=="") EnableDisabled=false;
	  else EnableDisabled=true;
	//AVG cannot be made to pause after a 'scan only' so if it finds something you would not know hence no 'scan only'
	  if(strVStype=="AVG7" || strVStype=="AVG6"){
		  if(thePrefs.virusscanradio!=3){//Therefore it's either 2 or 1 and 1 is not a valid option ==1 would not work if a state change had not been applied
			   thePrefs.virusscanradio=2;
			   CheckDlgButton(IDC_VSRADIO2, true);
			   CheckDlgButton(IDC_VSRADIO3, false);
			 } else {
					 CheckDlgButton(IDC_VSRADIO2, false);
				     CheckDlgButton(IDC_VSRADIO3, true);
					 }
		   CheckDlgButton(IDC_VSRADIO1, false);
		   GetDlgItem(IDC_VSRADIO1)->EnableWindow(false);
	      }	  else GetDlgItem(IDC_VSRADIO1)->EnableWindow(EnableDisabled);

	
	GetDlgItem(IDC_VSRADIO2)->EnableWindow(EnableDisabled);

	if(strVStype=="Norman" || strVStype=="Comodo"){
	  if(thePrefs.virusscanradio!=1){
			     thePrefs.virusscanradio=2;
			     CheckDlgButton(IDC_VSRADIO2, true);
			     CheckDlgButton(IDC_VSRADIO1, false);
				} else {
						CheckDlgButton(IDC_VSRADIO2, false);
			            CheckDlgButton(IDC_VSRADIO1, true);
						}
	  CheckDlgButton(IDC_VSRADIO3, false);
	  EnableDisabled=false;
	  } else //avast's clean is unreliable, it won't delete if clean fails...	
	        if(strVStype=="Avast! 4 Pro"){
	                                      if(thePrefs.virusscanradio!=3)
	 							           { 
										    thePrefs.virusscanradio=2;
			                                CheckDlgButton(IDC_VSRADIO1, true);
			                                CheckDlgButton(IDC_VSRADIO3, false);
			                                } else {
					                                CheckDlgButton(IDC_VSRADIO1, false);
				                                    CheckDlgButton(IDC_VSRADIO3, true);
					                                }
							               CheckDlgButton(IDC_VSRADIO2, false);
										   GetDlgItem(IDC_VSRADIO2)->EnableWindow(false);
	                                      }

	GetDlgItem(IDC_VSRADIO3)->EnableWindow(EnableDisabled);
	EnableDisabled=(strVStype=="Other");
	GetDlgItem(IDC_OTHERVS_LBL)->EnableWindow(EnableDisabled);
	GetDlgItem(IDC_VSPATH)->EnableWindow(EnableDisabled);
	GetDlgItem(IDC_VSEDIT1)->EnableWindow(EnableDisabled);
    GetDlgItem(IDC_VSEDIT2)->EnableWindow(EnableDisabled);
	GetDlgItem(IDC_VSEDIT3)->EnableWindow(EnableDisabled);
	GetDlgItem(IDC_TEST)->EnableWindow(EnableDisabled);
	GetDlgItem(IDC_VSPREFSW)->EnableWindow(EnableDisabled);
	GetDlgItem(IDC_SW)->EnableWindow(EnableDisabled);
	GetDlgItem(IDC_BROWSE)->EnableWindow(EnableDisabled);
	SetModified(TRUE);
}



bool CPPgVS::VerifyPath(bool notrunningtwice)
{
TryAgain:if(INVALID_FILE_ATTRIBUTES==GetFileAttributes((LPCTSTR)thePrefs.virusscanner))		
		 {
			 CString Path;
			 Path = thePrefs.virusscanner.Mid(0,3);
			 if(Path.CompareNoCase(_T("c:\\"))==0)
				{
				 thePrefs.virusscanner.SetAt(0,'D');
				 goto TryAgain;//Try D drive? 
				}
				//Bug fix thanks to Spe64 implemented version 1.3b
				if(notrunningtwice  && thePrefs.virusscannerenabled){//allows checking of a path without the path not found dialog
			       thePrefs.virusscanner="";//reset
	               ::MessageBox(m_hWnd, _T("Sorry, scanner not found in default path!"),_T("Virus Scanner.") , MB_ICONSTOP | MB_OK);
				  }
			return(false);
		  }
return(true);					
}
void CPPgVS::OnEnChangeVsedit1()
{
SetModified(TRUE);
}

void CPPgVS::OnEnChangeVsedit2()
{
SetModified(TRUE);
}

void CPPgVS::OnEnChangeVsedit3()
{
SetModified(TRUE);
}

void CPPgVS::OnBnClickedVsradio1()
{
SetModified(TRUE);
}

void CPPgVS::OnBnClickedVsradio2()
{
SetModified(TRUE);
}

void CPPgVS::OnBnClickedVsradio3()
{
SetModified(TRUE);
}

void CPPgVS::OnBnClickedBrowse()
{	
	CString ps;
 
	if(DialogBrowseFile(ps, (LPCTSTR) _T("Executables (*.exe;*.com;*.bin)|*.exe;*.com;*.bin||"))) {
	  GetDlgItem(IDC_VSEDIT1)->SetWindowText(ps);
	   } else OnApply();
}

void CPPgVS::OnBnClickedTest()
{
	CString Scanit(" ");
	TCHAR buffer[490];
	
	OnApply();//apply new settings before test

	::GetModuleFileName(0, buffer, 490);
    CString LongFileName(buffer);

	LPTSTR ShortFileN = new TCHAR[MAX_PATH];

	if(GetShortPathName(LongFileName,ShortFileN,MAX_PATH)!=0) {//Non-zero short filename returned
		 CString ShortFileName(ShortFileN);//Convert form LPTSTR to CString
		 if(thePrefs.virusscanprefilesw =="") Scanit += ShortFileName + ' ' + thePrefs.virusscanswitches;
			else Scanit += thePrefs.virusscanprefilesw + ' ' + ShortFileName + ' ' + thePrefs.virusscanswitches; 
		 //Execute virus scanner
		 ShellExecute(NULL,NULL,thePrefs.virusscanner, Scanit, NULL,SW_SHOW);
         } else {//get short filename failed try as scan with long filename?
		         if(thePrefs.virusscanprefilesw =="") Scanit +=' ' +  LongFileName + ' ' +  thePrefs.virusscanswitches;
		  	       else Scanit +=' ' + thePrefs.virusscanprefilesw + ' ' + LongFileName + ' ' +  thePrefs.virusscanswitches; 
				 //Execute virus scanner
				 ShellExecute(NULL,NULL,thePrefs.virusscanner, Scanit, NULL,SW_SHOW);
				 }
}
