//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once
#include "types.h"
#include "updownclient.h" // for class CUpDownClient

class CPartFile;
class CUpDownClient;

class CSourceSaver //modified by sivka
{
public:
	CSourceSaver(void);
	~CSourceSaver(void);
	void ManuellSave(CPartFile* file);
	void ManuellLoad(CPartFile* file);
	void Process(CPartFile* file);
	void DeleteFile(CPartFile* file);

protected:
	class CSourceData
	{
	public:
		CSourceData(UINT uID, uint16 uPort, CString strExp){ //modified by sivka
			sourceID = uID; 
			sourcePort = uPort; 
			strExpiration = strExp;
		}
		CSourceData(CUpDownClient* client, CString strExp){ //modified by sivka
			sourceID = client->GetUserIDHybrid(); 
			sourcePort = client->GetUserPort(); 
			partsavailable = client->GetAvailablePartCount();
			strExpiration = strExp;
		}
		CSourceData(CSourceData* pOld){ //modified by sivka
			sourceID = pOld->sourceID;
			sourcePort = pOld->sourcePort; 
			partsavailable = pOld->partsavailable;
			strExpiration = pOld->strExpiration;
		}

		bool Compare(CSourceData* tocompare){
			return ((sourceID == tocompare->sourceID) && (sourcePort == tocompare->sourcePort)); 
		}

		UINT sourceID;
		uint16 sourcePort;
		UINT partsavailable;
		CString strExpiration;
	};
	typedef CTypedPtrList<CPtrList, CSourceData*> SourceList;

	void SaveSourcesToFile(SourceList* sources, CString& slsfile, CPartFile* file);
	void LoadSourcesFromFile(SourceList* sources, CString& slsfile);
	void AddSourcesToDownload(SourceList* sources, CPartFile* file);
	
	bool m_LoadSourcesOnStart;
	UINT m_dwLastTimeSaved;
	
	CString CalcExpiration(int nMinute);
	bool IsExpired(CString strExpirationDate);
};
